/*
 * Decompiled with CFR 0.152.
 */
package electric.xml;

import electric.util.Lex;
import electric.util.Node;
import electric.xml.AttlistDecl;
import electric.xml.Child;
import electric.xml.Comment;
import electric.xml.ElementDecl;
import electric.xml.EntityDecl;
import electric.xml.Instruction;
import electric.xml.NotationDecl;
import electric.xml.Parent;
import java.io.IOException;
import java.io.Writer;

public final class DocType
extends Parent {
    static final String START = "<!DOCTYPE";
    static final String STOP = ">";
    static final String SYSTEM = "SYSTEM";
    static final String PUBLIC = "PUBLIC";
    String name;
    String externalId;

    public DocType(String string) {
        this.name = string;
    }

    public DocType(DocType docType) {
        super(docType);
        this.name = docType.name;
        this.externalId = docType.externalId;
    }

    DocType(Lex lex, Parent parent) throws IOException {
        Object object;
        parent.addChild(this);
        lex.readChar(60);
        lex.readToken(START.substring(1));
        this.name = lex.readToDelimiter("[>");
        if (this.name.equals("[") || this.name.equals(STOP)) {
            throw new IOException("DOCTYPE is missing a name");
        }
        String string = lex.readToken();
        if (string.equals(SYSTEM)) {
            object = lex.readToDelimiter("[>", 49);
            this.externalId = String.valueOf(String.valueOf(new StringBuffer("SYSTEM '").append((String)object).append("'")));
            string = lex.readToDelimiter("[>");
        } else if (string.equals(PUBLIC)) {
            object = lex.readToDelimiter("[>", 49);
            String string2 = lex.readToDelimiter("[>", 49);
            this.externalId = String.valueOf(String.valueOf(new StringBuffer("PUBLIC '").append((String)object).append("' '").append(string2).append("'")));
            string = lex.readToDelimiter("[>");
        }
        if (string.equals("[")) {
            block14: {
                while (true) {
                    lex.skipWhitespace();
                    object = new int[2];
                    lex.peek((int[])object);
                    Object object2 = object[0];
                    Object object3 = object[1];
                    if (object2 == 93) break block14;
                    if (object2 == -1) {
                        throw new IOException("could not find matching ']' in DOCTYPE");
                    }
                    if (object2 == 37) {
                        lex.readToPattern(";", 6);
                        continue;
                    }
                    if (object3 == 33 && lex.peekString("<!ATTLIST")) {
                        new AttlistDecl(lex, this);
                        continue;
                    }
                    if (object3 == 33 && lex.peekString("<!ELEMENT")) {
                        new ElementDecl(lex, this);
                        continue;
                    }
                    if (object3 == 33 && lex.peekString("<!ENTITY")) {
                        new EntityDecl(lex, this);
                        continue;
                    }
                    if (object3 == 33 && lex.peekString("<!NOTATION")) {
                        new NotationDecl(lex, this);
                        continue;
                    }
                    if (object3 == 33 && lex.peekString("<!--")) {
                        new Comment(lex, this);
                        continue;
                    }
                    if (object3 != 63) break;
                    new Instruction(lex, this);
                }
                throw new IOException("illegal entry in DOCTYPE");
            }
            string = lex.readToken();
            string = lex.readToken();
        }
        if (!string.equals(STOP)) {
            throw new IOException("could not find matching '>' in DOCTYPE");
        }
    }

    public Object clone() {
        return new DocType(this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String string) {
        this.externalId = string;
    }

    public void write(Writer writer, int n) throws IOException {
        this.indent(writer, n);
        writer.write(START);
        writer.write(32);
        writer.write(this.name);
        if (this.externalId != null) {
            writer.write(32);
            writer.write(this.externalId);
        }
        if (!this.children.isEmpty()) {
            writer.write("\r\n");
            int n2 = n + 2;
            this.indent(writer, n2);
            writer.write(91);
            Node node = this.children.first;
            while (node != null) {
                writer.write("\r\n");
                ((Child)node).write(writer, n2);
                node = node.next;
            }
            writer.write("\r\n");
            this.indent(writer, n + 2);
            writer.write(93);
            writer.write("\r\n");
        }
        writer.write(STOP);
    }

    static {
        START = START;
        STOP = STOP;
        SYSTEM = SYSTEM;
        PUBLIC = PUBLIC;
    }
}

