/*
 * Decompiled with CFR 0.152.
 */
package electric.xml;

import electric.util.Lex;
import electric.util.Node;
import electric.util.NodeList;
import electric.xml.Attribute;
import electric.xml.Attributes;
import electric.xml.CData;
import electric.xml.Child;
import electric.xml.Comment;
import electric.xml.Instruction;
import electric.xml.NamespaceException;
import electric.xml.Parent;
import electric.xml.Text;
import electric.xml.XPath;
import java.io.IOException;
import java.io.Writer;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Vector;

public class Element
extends Parent {
    String prefix;
    String namespace;
    String name;
    NodeList attributes = new NodeList();

    public Element() {
        this.name = "UNDEFINED";
    }

    public Element(String string) {
        this.name = string;
    }

    public Element(Element element) {
        super(element);
        this.prefix = element.prefix;
        this.namespace = element.namespace;
        this.name = element.name;
        Attribute attribute = (Attribute)element.attributes.first;
        while (attribute != null) {
            this.attributes.append(new Attribute(attribute));
            attribute = (Attribute)attribute.next;
        }
    }

    Element(Lex lex, Parent parent) throws NamespaceException, IOException {
        parent.addChild(this);
        lex.read();
        this.name = lex.readToken();
        if (lex.peek() == 58) {
            this.prefix = this.name;
            lex.read();
            this.name = lex.readToken();
        }
        lex.skipWhitespace();
        int n = lex.peek();
        if (n != 62 && n != 47) {
            this.parseAttributes(lex);
        }
        if (this.prefix == null) {
            this.namespace = this.getNamespace("");
        } else {
            this.namespace = this.getNamespace(this.prefix);
            if (this.namespace == null) {
                throw new NamespaceException("could not find namespace with prefix ".concat(String.valueOf(String.valueOf(this.prefix))));
            }
        }
        int n2 = lex.read();
        if (n2 == 47) {
            lex.readChar(62);
        } else {
            String string;
            if (n2 != 62) {
                throw new IOException("expected > or /");
            }
            this.parseChildren(lex);
            lex.readChar(60);
            lex.readChar(47);
            if (this.prefix != null) {
                string = lex.readToken();
                if (!this.prefix.equals(string)) {
                    throw new IOException(String.valueOf(String.valueOf(new StringBuffer("<").append(this.prefix).append(":...> does not match </").append(string).append(":...>"))));
                }
                lex.readChar(58);
            }
            string = lex.readToken();
            lex.readChar(62);
            if (!this.name.equals(string)) {
                throw new IOException(String.valueOf(String.valueOf(new StringBuffer("<...").append(this.name).append("> does not match </...").append(string).append(">"))));
            }
        }
    }

    void parseAttributes(Lex lex) throws NamespaceException, IOException {
        int n = 0;
        do {
            this.attributes.append(new Attribute(lex, this));
            lex.skipWhitespace();
        } while ((n = lex.peek()) != 62 && n != 47);
        Attribute attribute = (Attribute)this.attributes.first;
        while (attribute != null) {
            attribute.resolve(this);
            attribute = (Attribute)attribute.next;
        }
    }

    void parseChildren(Lex lex) throws NamespaceException, IOException {
        while (true) {
            StringBuffer stringBuffer = lex.readWhitespace();
            lex.mark(2);
            int n = lex.peekRead();
            int n2 = lex.peekRead();
            lex.reset();
            if (n == -1) break;
            if (n != 60) {
                new Text(lex, stringBuffer, this);
                continue;
            }
            if (n2 == 47) {
                if (!this.children.isEmpty() || stringBuffer == null) break;
                new Text(lex, stringBuffer, this);
                break;
            }
            if (n2 == 33 && lex.peekString("<![CDATA[")) {
                new CData(lex, stringBuffer, (Parent)this);
                continue;
            }
            if (n2 == 33 && lex.peekString("<!--")) {
                new Comment(lex, this);
                continue;
            }
            if (n2 == 63) {
                new Instruction(lex, this);
                continue;
            }
            new Element(lex, this);
        }
    }

    public Object clone() {
        return new Element(this);
    }

    public Element getRoot() {
        return this.parent == null ? this : this.parent.getRoot();
    }

    public String getName() {
        return this.name;
    }

    public String getQName() {
        if (this.namespace == null) {
            return this.name;
        }
        if (this.namespace.endsWith(":")) {
            return String.valueOf(String.valueOf(this.namespace)).concat(String.valueOf(String.valueOf(this.name)));
        }
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.namespace))).append(":").append(this.name)));
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Element setName(String string) {
        this.name = string;
        this.namespace = this.getNamespace("");
        return this;
    }

    public Element setName(String string, String string2) throws NamespaceException {
        this.prefix = string;
        this.name = string2;
        if (string == null) {
            this.namespace = this.getNamespace("");
        } else {
            this.namespace = this.getNamespace(string);
            if (this.namespace == null) {
                throw new NamespaceException("could not find namespace with prefix ".concat(String.valueOf(String.valueOf(string))));
            }
        }
        return this;
    }

    public String getQName(String string) throws NamespaceException {
        int n = string.indexOf(58);
        String string2 = null;
        if (n != -1) {
            String string3 = string.substring(0, n);
            string = string.substring(n + 1);
            string2 = this.getNamespace(string3);
            if (string2 == null) {
                throw new NamespaceException(String.valueOf(String.valueOf(new StringBuffer("could not resolve ").append(string3).append(":").append(string))));
            }
        } else {
            string2 = this.getNamespace("");
        }
        if (string2 == null) {
            return this.name;
        }
        if (string2.endsWith(":")) {
            return String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(string)));
        }
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string2))).append(":").append(string)));
    }

    public boolean hasName(String string, String string2) {
        if (!this.name.equals(string2)) {
            return false;
        }
        if (string == null) {
            return true;
        }
        if (this.namespace == null) {
            return false;
        }
        return this.namespace.equals(string);
    }

    public boolean hasText() {
        return this.getText() != null;
    }

    public Text getText() {
        Node node = this.children.first;
        while (node != null) {
            if (node instanceof Text) {
                return (Text)node;
            }
            node = node.next;
        }
        return null;
    }

    public String getTextString() {
        Text text = this.getText();
        return text == null ? null : text.string;
    }

    public Text getText(String string) {
        Element element = this.getElement(string);
        return element == null ? null : element.getText();
    }

    public Text getText(String string, String string2) {
        Element element = this.getElement(string, string2);
        return element == null ? null : element.getText();
    }

    public Text getText(XPath xPath) {
        Element element = this.getElement(xPath);
        return element == null ? null : element.getText();
    }

    public String getTextString(String string) {
        Text text = this.getText(string);
        return text == null ? null : text.string;
    }

    public String getTextString(String string, String string2) {
        Text text = this.getText(string, string2);
        return text == null ? null : text.string;
    }

    public String getTextString(XPath xPath) {
        Text text = this.getText(xPath);
        return text == null ? null : text.string;
    }

    public Element setText(String string) {
        return this.setText(string == null ? null : new Text(string));
    }

    public Element setText(Text text) {
        Text text2 = this.getText();
        if (text == null) {
            if (text2 != null) {
                text2.remove();
            }
        } else if (text2 == null) {
            this.addChild(text);
        } else {
            text2.replaceWith(text);
        }
        return this;
    }

    public Element addText(String string) {
        return this.addText(new Text(string));
    }

    public Element addText(Text text) {
        this.addChild(text);
        return this;
    }

    public boolean hasAttributes() {
        return !this.attributes.isEmpty();
    }

    public Attributes getAttributes() {
        return new Attributes(this.attributes);
    }

    public Attribute getAttribute(String string) {
        Attribute attribute = (Attribute)this.attributes.first;
        while (attribute != null) {
            if (attribute.name.equals(string)) {
                return attribute;
            }
            attribute = (Attribute)attribute.next;
        }
        return null;
    }

    public Attribute getAttribute(String string, String string2) {
        Attribute attribute = (Attribute)this.attributes.first;
        while (attribute != null) {
            if (attribute.hasName(string, string2)) {
                return attribute;
            }
            attribute = (Attribute)attribute.next;
        }
        return null;
    }

    public Attribute getAttribute(XPath xPath) {
        return xPath.getAttribute(this);
    }

    public Attributes getAttributes(XPath xPath) {
        return xPath.getAttributes(this);
    }

    public String getAttributeValue(String string) {
        Attribute attribute = this.getAttribute(string);
        return attribute == null ? null : attribute.value;
    }

    public String getAttributeValue(String string, String string2) {
        Attribute attribute = this.getAttribute(string, string2);
        return attribute == null ? null : attribute.value;
    }

    public String getAttributeValue(XPath xPath) {
        Attribute attribute = this.getAttribute(xPath);
        return attribute == null ? null : attribute.value;
    }

    public Element setAttribute(String string, String string2) {
        this.setAttribute(new Attribute(string, string2));
        return this;
    }

    public Element setAttribute(String string, String string2, String string3) {
        this.setAttribute(new Attribute(string, string2, string3));
        return this;
    }

    public Element setAttribute(Attribute attribute) throws NamespaceException {
        attribute.resolve(this);
        Attribute attribute2 = (Attribute)this.attributes.first;
        while (attribute2 != null) {
            if (attribute2.hasName(attribute.namespace, attribute.name)) {
                this.attributes.replace(attribute2, attribute);
                return this;
            }
            attribute2 = (Attribute)attribute2.next;
        }
        this.attributes.append(attribute);
        return this;
    }

    public Attribute removeAttribute(String string) {
        Attribute attribute = this.getAttribute(string);
        if (attribute != null) {
            attribute.remove();
        }
        return attribute;
    }

    public Attribute removeAttribute(String string, String string2) {
        Attribute attribute = this.getAttribute(string, string2);
        if (attribute != null) {
            attribute.remove();
        }
        return attribute;
    }

    public Attribute removeAttribute(XPath xPath) {
        Attribute attribute = this.getAttribute(xPath);
        if (attribute != null) {
            attribute.remove();
        }
        return attribute;
    }

    public Attributes removeAttributes(XPath xPath) {
        Attributes attributes = this.getAttributes(xPath);
        attributes.remove();
        attributes.reset();
        return attributes;
    }

    public Element setNextSibling(String string) {
        Element element = new Element();
        element.setParent(this.parent);
        element.setName(string);
        this.setNextSibling(element);
        return element;
    }

    public Element setNextSibling(String string, String string2) {
        Element element = new Element();
        element.setParent(this.parent);
        element.setName(string, string2);
        this.setNextSibling(element);
        return element;
    }

    public Element setPreviousSibling(String string) {
        Element element = new Element();
        element.setParent(this.parent);
        element.setName(string);
        this.setPreviousSibling(element);
        return element;
    }

    public Element setPreviousSibling(String string, String string2) {
        Element element = new Element();
        element.setParent(this.parent);
        element.setName(string, string2);
        this.setPreviousSibling(element);
        return element;
    }

    public Dictionary getNamespaces() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Attribute attribute = (Attribute)this.attributes.first;
        while (attribute != null) {
            if (attribute.isNamespace) {
                hashtable.put(attribute.name, attribute.value);
            }
            attribute = (Attribute)attribute.next;
        }
        return hashtable;
    }

    public String getNamespace(String string) {
        Attribute attribute = (Attribute)this.attributes.first;
        while (attribute != null) {
            if (attribute.isNamespace && attribute.name.equals(string)) {
                String string2 = attribute.value;
                return string2.length() > 0 ? string2 : null;
            }
            attribute = (Attribute)attribute.next;
        }
        return this.parent == null ? null : this.parent.getNamespace(string);
    }

    public String[] getNamespacePrefixes(String string) {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        this.addNamespacePrefixes(string, vector, vector2);
        Object[] objectArray = new String[vector2.size()];
        vector2.copyInto(objectArray);
        return objectArray;
    }

    protected void addNamespacePrefixes(String string, Vector vector, Vector vector2) {
        Attribute attribute = (Attribute)this.attributes.first;
        while (attribute != null) {
            if (attribute.isNamespace) {
                if (attribute.value.equals(string) && !vector.contains(attribute.name)) {
                    vector2.addElement(attribute.name);
                }
                vector.addElement(attribute.name);
            }
            attribute = (Attribute)attribute.next;
        }
        if (this.parent != null) {
            this.parent.addNamespacePrefixes(string, vector, vector2);
        }
    }

    public void setNamespace(String string, String string2) throws NamespaceException {
        this.setAttribute(new Attribute(string, string2, true));
    }

    public void removeNamespace(String string) {
        Attribute attribute = (Attribute)this.attributes.first;
        while (attribute != null) {
            if (attribute.isNamespace && attribute.name.equals(string)) {
                attribute.remove();
                return;
            }
            attribute = (Attribute)attribute.next;
        }
    }

    public synchronized Element getElementWithId(String string) {
        Attribute attribute = (Attribute)this.attributes.first;
        while (attribute != null) {
            if (attribute.isId && attribute.value.equals(string)) {
                return this;
            }
            attribute = (Attribute)attribute.next;
        }
        return super.getElementWithId(string);
    }

    public void write(Writer writer, int n) throws IOException {
        this.indent(writer, n);
        writer.write(60);
        if (this.prefix != null) {
            writer.write(this.prefix);
            writer.write(58);
        }
        writer.write(this.name);
        Attribute attribute = (Attribute)this.attributes.first;
        while (attribute != null) {
            writer.write(32);
            attribute.write(writer, n);
            attribute = (Attribute)attribute.next;
        }
        if (this.children.isEmpty()) {
            writer.write(47);
        } else {
            writer.write(62);
            this.writeChildren(writer, n);
            writer.write("</");
            if (this.prefix != null) {
                writer.write(this.prefix);
                writer.write(58);
            }
            writer.write(this.name);
        }
        writer.write(62);
    }

    void writeChildren(Writer writer, int n) throws IOException {
        if (this.children.first == this.children.last && this.children.first instanceof Text) {
            ((Text)this.children.first).write(writer, -1);
        } else if (n == -1) {
            Node node = this.children.first;
            while (node != null) {
                ((Child)node).write(writer, n);
                node = node.next;
            }
        } else {
            int n2 = n + 2;
            Node node = this.children.first;
            while (node != null) {
                writer.write("\r\n");
                ((Child)node).write(writer, n2);
                node = node.next;
            }
            writer.write("\r\n");
            this.indent(writer, n);
        }
    }
}

