/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.connector.file;

import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.sonatype.aether.util.ConfigUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ParallelRepositoryConnector {
    private static final int MAX_POOL_SIZE = 5;
    private boolean closed = false;
    protected Executor executor;

    ParallelRepositoryConnector() {
    }

    protected void initExecutor(Map<String, Object> config) {
        if (this.executor == null) {
            int threads = ConfigUtils.getInteger(config, (int)5, (String[])new String[]{"aether.connector.file.threads"});
            if (threads <= 1) {
                this.executor = new Executor(){

                    public void execute(Runnable command) {
                        command.run();
                    }
                };
            } else {
                RepositoryConnectorThreadFactory threadFactory = new RepositoryConnectorThreadFactory(this.getClass().getSimpleName());
                this.executor = new ThreadPoolExecutor(threads, threads, 3L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
            }
        }
    }

    public void close() {
        this.closed = true;
        if (this.executor instanceof ExecutorService) {
            ((ExecutorService)this.executor).shutdown();
        }
    }

    protected void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("Connector is closed");
        }
    }

    protected static class RepositoryConnectorThreadFactory
    implements ThreadFactory {
        private final AtomicInteger counter = new AtomicInteger(1);
        private final String threadName;

        public RepositoryConnectorThreadFactory(String threadName) {
            this.threadName = threadName;
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, this.threadName + "-" + this.counter.getAndIncrement());
            t.setDaemon(true);
            return t;
        }
    }
}

