/*
 * Decompiled with CFR 0.152.
 */
package blue.clojure;

import blue.clojure.BlueClojureEngine;
import blue.clojure.Bundle;
import blue.projects.BlueProjectManager;
import blue.ui.utilities.jconsole.JConsole;
import blue.ui.utilities.jconsole.JConsoleDelegate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Closeable;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.JScrollPane;
import org.openide.util.Exceptions;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="ClojureConsoleTopComponent", persistenceType=0)
public final class ClojureConsoleTopComponent
extends TopComponent {
    JConsole jconsole = new JConsole();

    public ClojureConsoleTopComponent() {
        this.initComponents();
        this.setName(Bundle.CTL_ClojureConsoleTopComponent());
        this.setToolTipText(Bundle.HINT_ClojureConsoleTopComponent());
        this.add(new JScrollPane((Component)this.jconsole), "Center");
        JConsoleDelegate jConsoleDelegate = new JConsoleDelegate(){

            public String getPrompt() {
                return BlueClojureEngine.getInstance().getCurrentNameSpace() + "=> ";
            }

            public void processCommands(String commands, Reader stdin, Writer stdout, Writer stderr) {
                HashMap<String, Closeable> values = new HashMap<String, Closeable>();
                values.put("*in*", stdin);
                values.put("*out*", stdout);
                values.put("*err*", stderr);
                try {
                    String retVal = BlueClojureEngine.getInstance().processScript(commands, null, null);
                    stdout.write(retVal + "\n");
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        };
        this.jconsole.setDelegate(jConsoleDelegate);
        BlueProjectManager.getInstance().addPropertyChangeListener(pce -> {
            if ("currentProject".equals(pce.getPropertyName())) {
                this.jconsole.setText(jConsoleDelegate.getPrompt());
            }
        });
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }
}

