/*
 * Decompiled with CFR 0.152.
 */
package blue.clojure.project;

import blue.BlueDataObject;
import blue.clojure.project.ClojureLibraryEntry;
import blue.project.ProjectPluginUtils;
import electric.xml.Element;
import electric.xml.Elements;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;

public class ClojureProjectData
implements BlueDataObject {
    private ObservableList<ClojureLibraryEntry> libraryList = FXCollections.observableArrayList();

    public ClojureProjectData() {
    }

    public ClojureProjectData(ClojureProjectData cpd) {
        for (ClojureLibraryEntry lib : cpd.libraryList) {
            this.libraryList.add((Object)new ClojureLibraryEntry(lib));
        }
    }

    public ObservableList<ClojureLibraryEntry> libraryList() {
        return this.libraryList;
    }

    public String getPomegranateString() {
        FilteredList filtered = this.libraryList.filtered(libEntry -> !libEntry.getDependencyCoordinates().isEmpty() && !libEntry.getVersion().isEmpty());
        if (filtered.size() == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("(use '[cemerick.pomegranate :only (add-dependencies)])\n");
        builder.append("(add-dependencies :coordinates '[");
        for (ClojureLibraryEntry lib : filtered) {
            builder.append("[").append(lib.getDependencyCoordinates());
            builder.append(" \"").append(lib.getVersion()).append("\" ");
            builder.append(":exclusions [org.clojure/clojure]]\n");
        }
        builder.append("] :repositories (merge ");
        builder.append("cemerick.pomegranate.aether/maven-central ");
        builder.append("{\"clojars\" \"http://clojars.org/repo\"}))");
        return builder.toString();
    }

    public static ClojureProjectData loadFromXML(Element data) {
        ClojureProjectData projData = new ClojureProjectData();
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            Element node = nodes.next();
            projData.libraryList.add((Object)ClojureLibraryEntry.loadFromXML(node));
        }
        return projData;
    }

    public Element saveAsXML() {
        Element retVal = ProjectPluginUtils.getBaseElement(this.getClass());
        for (ClojureLibraryEntry lib : this.libraryList) {
            retVal.addElement(lib.saveAsXML());
        }
        return retVal;
    }

    public ClojureProjectData deepCopy() {
        return new ClojureProjectData(this);
    }
}

