/*
 * Decompiled with CFR 0.152.
 */
package blue;

import blue.InstrumentLibrary;
import blue.orchestra.Instrument;
import blue.utility.ObjectUtilities;
import electric.xml.Element;

public class InstrumentAssignment
implements Comparable<InstrumentAssignment> {
    public String arrangementId = "";
    public Instrument instr;
    public boolean enabled = true;

    public InstrumentAssignment() {
    }

    public InstrumentAssignment(InstrumentAssignment ia) {
        this.arrangementId = ia.arrangementId;
        this.enabled = ia.enabled;
        this.instr = (Instrument)ia.instr.deepCopy();
    }

    public static InstrumentAssignment loadFromXML(Element data) throws Exception {
        InstrumentAssignment retVal = new InstrumentAssignment();
        retVal.arrangementId = data.getAttributeValue("arrangementId");
        String enabled = data.getAttributeValue("isEnabled");
        if (enabled != null) {
            retVal.enabled = Boolean.valueOf(enabled);
        }
        if (data.getElement("instrument") != null) {
            retVal.instr = (Instrument)ObjectUtilities.loadFromXML(data.getElement("instrument"));
        }
        return retVal;
    }

    public Element saveAsXML() {
        Element retVal = new Element("instrumentAssignment");
        retVal.setAttribute("arrangementId", this.arrangementId);
        retVal.setAttribute("isEnabled", Boolean.toString(this.enabled));
        retVal.addElement(this.instr.saveAsXML());
        return retVal;
    }

    public static InstrumentAssignment loadFromXML(Element data, InstrumentLibrary iLibrary) {
        InstrumentAssignment retVal = new InstrumentAssignment();
        retVal.arrangementId = data.getAttributeValue("arrangementId");
        retVal.instr = iLibrary.getInstrumentById(data.getAttributeValue("instrumentId"));
        String enabled = data.getAttributeValue("isEnabled");
        if (enabled != null) {
            retVal.enabled = Boolean.valueOf(enabled);
        }
        return retVal;
    }

    @Override
    public int compareTo(InstrumentAssignment ia) {
        try {
            int a = Integer.parseInt(this.arrangementId);
            int b = Integer.parseInt(ia.arrangementId);
            return a - b;
        }
        catch (NumberFormatException nfe) {
            return this.arrangementId.compareToIgnoreCase(ia.arrangementId);
        }
    }
}

