/*
 * Decompiled with CFR 0.152.
 */
package blue;

import electric.xml.Element;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;

public class Tables {
    private String tables = "";
    private transient HashMap compilationVariables = null;
    private transient HashSet ftableNumberSet = null;

    public Tables() {
    }

    public Tables(Tables t) {
        this.tables = t.tables;
    }

    public String getTables() {
        return this.tables;
    }

    public void setTables(String tables) {
        this.tables = tables;
    }

    public Object getCompilationVariable(Object key) {
        if (this.compilationVariables == null) {
            this.compilationVariables = new HashMap();
            return null;
        }
        return this.compilationVariables.get(key);
    }

    public void setCompilationVariable(Object key, Object value) {
        if (this.compilationVariables == null) {
            this.compilationVariables = new HashMap();
        }
        this.compilationVariables.put(key, value);
    }

    public int getOpenFTableNumber() {
        if (this.ftableNumberSet == null) {
            this.ftableNumberSet = Tables.getFtableNumberSet(this.getTables());
        }
        int counter = 1;
        Integer tableNum = new Integer(counter);
        while (this.ftableNumberSet.contains(tableNum)) {
            tableNum = new Integer(++counter);
        }
        this.ftableNumberSet.add(tableNum);
        return counter;
    }

    public void addFtgenNumber(int ftgenNum) {
        if (this.ftableNumberSet == null) {
            this.ftableNumberSet = Tables.getFtableNumberSet(this.getTables());
        }
        this.ftableNumberSet.add(new Integer(ftgenNum));
    }

    private static HashSet getFtableNumberSet(String ftableText) {
        HashSet<Integer> ftableNumbers = new HashSet<Integer>();
        StringTokenizer st = new StringTokenizer(ftableText, "\n");
        while (st.hasMoreTokens()) {
            String line = st.nextToken().trim();
            String temp = "";
            if (!line.startsWith("f")) continue;
            int index = line.indexOf(102) + 1;
            String tempLine = line.substring(index).trim();
            for (index = 0; index < tempLine.length() && tempLine.charAt(index) != ' ' && tempLine.charAt(index) != '\t'; ++index) {
                temp = temp + tempLine.charAt(index);
            }
            try {
                ftableNumbers.add(new Integer(temp));
            }
            catch (NumberFormatException nfe) {
                System.err.println("[error] - Tables::getFtableNumberSet - could not parse FTable number for text: " + line);
                System.err.println("Number found was: " + temp);
            }
        }
        return ftableNumbers;
    }

    public static Tables loadFromXML(Element data) {
        Tables tables = new Tables();
        String tableText = data.getTextString();
        tables.setTables(tableText == null ? "" : tableText);
        return tables;
    }

    public Element saveAsXML() {
        Element retVal = new Element("tables");
        retVal.setText(this.tables);
        return retVal;
    }
}

