/*
 * Decompiled with CFR 0.152.
 */
package blue.mixer;

import blue.CompileData;
import blue.automation.Parameter;
import blue.mixer.Channel;
import blue.mixer.Effect;
import blue.mixer.EffectManager;
import blue.mixer.EffectsChain;
import blue.mixer.Mixer;
import blue.mixer.Send;
import blue.udo.OpcodeList;
import blue.udo.UserDefinedOpcode;
import blue.utility.MusicFunctions;
import blue.utility.NumberUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.text.StrBuilder;

class MixerNode {
    public String name;
    public Channel channel;
    public List<MixerNode> children = new ArrayList<MixerNode>();
    public boolean generatesOutSignal = true;
    public boolean outChannelValid = true;
    public int lastPreFaderSendIndex = -1;
    public int lastPostFaderSendIndex = -1;
    public List<String> outChannelNames = null;

    MixerNode() {
    }

    public String toString() {
        return this.str(0);
    }

    private String str(int depth) {
        StrBuilder retVal = new StrBuilder();
        for (int i = 0; i < depth; ++i) {
            retVal.append(" ");
        }
        retVal.append(this.name).append("\n");
        for (MixerNode m : this.children) {
            retVal.append(m.str(depth + 2));
        }
        return retVal.toString();
    }

    public static String getMixerCode(CompileData data, Mixer mixer, OpcodeList udos, EffectManager manager, MixerNode mixerNode, int nchnls) {
        StrBuilder buffer = new StrBuilder();
        ArrayList<MixerNode> nodes = new ArrayList<MixerNode>();
        MixerNode.flattenToList(mixerNode, nodes);
        MixerNode.sortNodesList(nodes);
        HashSet<String> inputSignalCache = new HashSet<String>();
        for (int i = 0; i < nodes.size(); ++i) {
            MixerNode tempNode = (MixerNode)nodes.get(i);
            if (mixer.isSubChannel(tempNode.channel) && !mixer.hasSubChannelDependency(tempNode.name) && !inputSignalCache.contains(tempNode.name)) continue;
            String signalChannels = "";
            for (int j = 0; j < nchnls; ++j) {
                signalChannels = j == 0 ? mixer.getVar(data, tempNode.channel, j) : signalChannels + ", " + mixer.getVar(data, tempNode.channel, j);
            }
            EffectsChain preEffects = tempNode.channel.getPreEffects();
            int lastIndex = Integer.MAX_VALUE;
            if (!tempNode.generatesOutSignal && (lastIndex = tempNode.lastPreFaderSendIndex) < 0) continue;
            MixerNode.applyEffects(preEffects, udos, manager, signalChannels, buffer, lastIndex, inputSignalCache);
            if (!tempNode.generatesOutSignal) continue;
            MixerNode.applyFader(data, mixer, tempNode, nchnls, buffer);
            EffectsChain postEffects = tempNode.channel.getPostEffects();
            lastIndex = Integer.MAX_VALUE;
            if (!tempNode.outChannelValid && (lastIndex = tempNode.lastPostFaderSendIndex) < 0) continue;
            MixerNode.applyEffects(postEffects, udos, manager, signalChannels, buffer, lastIndex, inputSignalCache);
            if (!tempNode.outChannelValid || i == nodes.size() - 1) continue;
            String outChannelName = tempNode.channel.getOutChannel();
            inputSignalCache.add(outChannelName);
            for (int j = 0; j < nchnls; ++j) {
                String channelVar = mixer.getVar(data, tempNode.channel, j);
                String outChannelVar = Mixer.getSubChannelVar(outChannelName, j);
                buffer.append(outChannelVar).append("\t+=\t");
                buffer.append(channelVar).append("\n");
            }
        }
        return buffer.toString();
    }

    protected static void sortNodesList(List<MixerNode> nodes) {
        int topIndex = nodes.size() - 2;
        while (topIndex >= 1) {
            int newIndex = topIndex;
            MixerNode temp = nodes.get(topIndex);
            for (int i = newIndex - 1; i >= 0; --i) {
                MixerNode temp2 = nodes.get(i);
                if (!temp.getOutChannelNames().contains(temp2.name)) continue;
                newIndex = i;
            }
            if (newIndex == topIndex) {
                --topIndex;
                continue;
            }
            nodes.remove(temp);
            nodes.add(newIndex, temp);
        }
    }

    protected static void flattenToList(MixerNode node, List<MixerNode> channels) {
        MixerNode.flattenToList(node, channels, 0);
    }

    private static void flattenToList(MixerNode node, List<MixerNode> channels, int depthCount) {
        for (MixerNode child : node.children) {
            if (child.children.size() <= 0) continue;
            MixerNode.flattenToList(child, channels, depthCount + 1);
        }
        for (MixerNode child : node.children) {
            channels.add(child);
        }
        if (depthCount == 0) {
            channels.add(node);
        }
    }

    protected static boolean isValidOut(String channelName, Map<String, Channel> subChannelCache) {
        Send[] sends;
        if (channelName.equals("Master")) {
            return true;
        }
        Channel channel = subChannelCache.get(channelName);
        for (Send send : sends = channel.getPreFaderSends()) {
            if (!MixerNode.isValidOut(send.getSendChannel(), subChannelCache)) continue;
            return true;
        }
        if (MixerNode.hasOutSignal(channel)) {
            Send[] postSends;
            for (Send postSend : postSends = channel.getPostFaderSends()) {
                if (!MixerNode.isValidOut(postSend.getSendChannel(), subChannelCache)) continue;
                return true;
            }
            if (MixerNode.isValidOut(channel.getOutChannel(), subChannelCache)) {
                return true;
            }
        }
        return false;
    }

    protected static int indexOfLastValidSend(EffectsChain chain, Map<String, Boolean> validOutCache) {
        int index = -1;
        for (int i = 0; i < chain.getSize(); ++i) {
            Object obj = chain.getElementAt(i);
            if (!(obj instanceof Send)) continue;
            Send send = (Send)obj;
            if (send.getSendChannel().equals("Master")) {
                index = i;
                continue;
            }
            Boolean valid = validOutCache.get(send.getSendChannel());
            if (!valid.booleanValue()) continue;
            index = i;
        }
        return index;
    }

    private static void applyFader(CompileData data, Mixer mixer, MixerNode node, int nchnls, StrBuilder buffer) {
        String modifier = null;
        Parameter levelParam = node.channel.getLevelParameter();
        String compilationVarName = levelParam.getCompilationVarName();
        if (levelParam.isAutomationEnabled()) {
            if (compilationVarName != null) {
                buffer.append("ktempdb = ampdb(");
                buffer.append(compilationVarName).append(")\n");
                modifier = "ktempdb";
            }
        } else {
            double multiplier = MusicFunctions.ampdb(node.channel.getLevel());
            if (compilationVarName != null) {
                buffer.append("ktempdb = ampdb(");
                buffer.append(compilationVarName).append(")\n");
                modifier = "ktempdb";
            } else if (multiplier != 1.0) {
                modifier = MixerNode.getMultiplierString(multiplier);
            }
        }
        if (modifier != null) {
            for (int i = 0; i < nchnls; ++i) {
                String sig = mixer.getVar(data, node.channel, i);
                buffer.append(sig).append(" *= ");
                buffer.append(modifier).append("\n");
            }
        }
    }

    private static void applyEffects(EffectsChain chain, OpcodeList udos, EffectManager manager, String signalChannels, StrBuilder buffer, int lastSendIndex, Set<String> inputSignalCache) {
        int lastIndex = lastSendIndex;
        if (lastIndex == Integer.MAX_VALUE) {
            lastIndex = chain.size() - 1;
        } else if (lastIndex < 0) {
            return;
        }
        for (int i = 0; i <= lastIndex; ++i) {
            Send send;
            Object obj = chain.getElementAt(i);
            if (obj instanceof Effect) {
                Effect effect = (Effect)obj;
                if (!effect.isEnabled()) continue;
                UserDefinedOpcode udo = effect.generateUDO(udos);
                udo.commentText = effect.getName();
                String effectName = udos.getNameOfEquivalentCopy(udo);
                if (effectName == null) {
                    udo.opcodeName = effectName = manager.getEffectName();
                    udos.addOpcode(udo);
                }
                buffer.append(signalChannels).append("\t");
                buffer.append(effectName).append("\t");
                buffer.append(signalChannels).append("\n");
                continue;
            }
            if (!(obj instanceof Send) || !(send = (Send)obj).isEnabled()) continue;
            String[] parts = signalChannels.split(",");
            String sendChannelName = send.getSendChannel();
            inputSignalCache.add(sendChannelName);
            for (int j = 0; j < parts.length; ++j) {
                String subVar = Mixer.getSubChannelVar(sendChannelName, j);
                buffer.append(subVar).append("\t+=\t");
                Parameter levelParam = send.getLevelParameter();
                if (levelParam.isAutomationEnabled()) {
                    String compilationVarName = levelParam.getCompilationVarName();
                    buffer.append("(").append(parts[j].trim()).append(" * ");
                    buffer.append(compilationVarName).append(")\n");
                    continue;
                }
                if (send.getLevel() == 1.0) {
                    buffer.append(parts[j].trim()).append("\n");
                    continue;
                }
                String levelStr = NumberUtilities.formatDouble(send.getLevel());
                buffer.append("(").append(parts[j].trim()).append(" * ");
                buffer.append(levelStr).append(")\n");
            }
        }
    }

    private static String getMultiplierString(double multiplier) {
        return NumberUtilities.formatDouble(multiplier);
    }

    private static void configureNode(MixerNode node, Map<String, Boolean> validOutCache) {
        boolean hasOutSignal = MixerNode.hasOutSignal(node.channel);
        node.lastPreFaderSendIndex = MixerNode.indexOfLastValidSend(node.channel.getPreEffects(), validOutCache);
        node.lastPostFaderSendIndex = MixerNode.indexOfLastValidSend(node.channel.getPostEffects(), validOutCache);
        node.generatesOutSignal = hasOutSignal;
        node.outChannelValid = true;
        String outChannel = node.channel.getOutChannel();
        if (outChannel.equals("Master")) {
            node.outChannelValid = true;
        } else {
            Boolean valid = validOutCache.get(outChannel);
            if (valid == null) {
                System.err.println("ERROR: " + node.channel.getName() + " : " + outChannel);
            }
            node.outChannelValid = valid;
        }
    }

    private static boolean hasOutSignal(Channel channel) {
        Parameter levelParam = channel.getLevelParameter();
        double level = channel.getLevel();
        boolean hasOutSignal = levelParam.isAutomationEnabled() || level > -96.0;
        return hasOutSignal;
    }

    public static MixerNode getMixerGraph(Mixer mixer) {
        MixerNode masterNode = new MixerNode();
        masterNode.channel = mixer.getMaster();
        masterNode.name = "Master";
        Map<String, Boolean> validOutCache = MixerNode.getValidOutCache(mixer);
        MixerNode.attachChildren(mixer, masterNode, validOutCache);
        return masterNode;
    }

    protected static Map<String, Boolean> getValidOutCache(Mixer mixer) {
        Map<String, Channel> subChannelCache = mixer.getSubChannelCache();
        HashMap<String, Boolean> validOutCache = new HashMap<String, Boolean>();
        for (int i = 0; i < mixer.getSubChannels().size(); ++i) {
            Channel subChannel = mixer.getSubChannel(i);
            boolean valid = MixerNode.isValidOut(subChannel.getName(), subChannelCache);
            validOutCache.put(subChannel.getName(), valid);
        }
        return validOutCache;
    }

    private static void attachChildren(final Mixer mixer, MixerNode node, Map<String, Boolean> validOutCache) {
        for (Channel c : mixer.getAllSourceChannels()) {
            if (!c.getOutChannel().equals(node.name)) continue;
            MixerNode m = new MixerNode();
            m.name = c.getName();
            m.channel = c;
            MixerNode.configureNode(m, validOutCache);
            node.children.add(m);
        }
        ArrayList<MixerNode> temp = new ArrayList<MixerNode>();
        for (Channel c : mixer.getSubChannels()) {
            if (!c.getOutChannel().equals(node.name)) continue;
            MixerNode m = new MixerNode();
            m.name = c.getName();
            m.channel = c;
            MixerNode.configureNode(m, validOutCache);
            temp.add(m);
            MixerNode.attachChildren(mixer, m, validOutCache);
        }
        if (temp.size() > 0) {
            Collections.sort(temp, new Comparator<MixerNode>(){

                @Override
                public int compare(MixerNode node1, MixerNode node2) {
                    if (mixer.sendsTo(node1.channel, node2.channel)) {
                        return -1;
                    }
                    if (mixer.sendsTo(node2.channel, node1.channel)) {
                        return 1;
                    }
                    return 0;
                }
            });
            node.children.addAll(temp);
        }
    }

    public List<String> getOutChannelNames() {
        if (this.outChannelNames == null) {
            Send[] preSends;
            this.outChannelNames = new ArrayList<String>();
            for (Send preSend : preSends = this.channel.getPreFaderSends()) {
                String sendName = preSend.getSendChannel();
                if (this.outChannelNames.contains(sendName)) continue;
                this.outChannelNames.add(sendName);
            }
            if (this.generatesOutSignal) {
                Send[] postSends;
                for (Send postSend : postSends = this.channel.getPostFaderSends()) {
                    String sendName = postSend.getSendChannel();
                    if (this.outChannelNames.contains(sendName)) continue;
                    this.outChannelNames.add(sendName);
                }
                if (!this.outChannelNames.contains(this.channel.getOutChannel())) {
                    this.outChannelNames.add(this.channel.getOutChannel());
                }
            }
        }
        return this.outChannelNames;
    }
}

