/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra;

import blue.Tables;
import blue.orchestra.AbstractInstrument;
import blue.orchestra.Instrument;
import blue.orchestra.InstrumentUtilities;
import blue.udo.OpcodeList;
import blue.utility.TextUtilities;
import blue.utility.UDOUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.util.HashMap;

public class GenericInstrument
extends AbstractInstrument {
    String instrumentText;
    String globalOrc;
    String globalSco;
    OpcodeList opcodeList;
    private transient HashMap udoReplacementValues;

    public GenericInstrument() {
        this.instrumentText = "";
        this.globalOrc = "";
        this.globalSco = "";
        this.opcodeList = new OpcodeList();
    }

    public GenericInstrument(GenericInstrument genericInstr) {
        super(genericInstr);
        this.instrumentText = genericInstr.instrumentText;
        this.globalOrc = genericInstr.globalOrc;
        this.globalSco = genericInstr.globalSco;
        this.opcodeList = new OpcodeList(genericInstr.opcodeList);
    }

    @Override
    public String generateInstrument() {
        String retVal = this.instrumentText;
        if (this.udoReplacementValues != null) {
            retVal = TextUtilities.replaceOpcodeNames(this.udoReplacementValues, retVal);
            this.udoReplacementValues = null;
        }
        return retVal;
    }

    public String getText() {
        return this.instrumentText;
    }

    public void setText(String iText) {
        this.instrumentText = iText == null ? "" : iText;
    }

    public boolean hasFTable() {
        return false;
    }

    @Override
    public void generateUserDefinedOpcodes(OpcodeList udoList) {
        this.udoReplacementValues = UDOUtilities.appendUserDefinedOpcodes(this.opcodeList, udoList);
    }

    @Override
    public void generateFTables(Tables tables) {
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String generateGlobalOrc() {
        return this.getGlobalOrc();
    }

    @Override
    public String generateGlobalSco() {
        return this.getGlobalSco();
    }

    public String getGlobalOrc() {
        return this.globalOrc;
    }

    public void setGlobalOrc(String globalOrc) {
        this.globalOrc = globalOrc == null ? "" : globalOrc;
    }

    public String getGlobalSco() {
        return this.globalSco;
    }

    public void setGlobalSco(String globalSco) {
        this.globalSco = globalSco == null ? "" : globalSco;
    }

    public static Instrument loadFromXML(Element data) throws Exception {
        GenericInstrument instr = new GenericInstrument();
        InstrumentUtilities.initBasicFromXML(data, instr);
        Elements elements = data.getElements();
        while (elements.hasMoreElements()) {
            String nodeName;
            Element node = elements.next();
            switch (nodeName = node.getName()) {
                case "globalOrc": {
                    instr.setGlobalOrc(node.getTextString());
                    break;
                }
                case "globalSco": {
                    instr.setGlobalSco(node.getTextString());
                    break;
                }
                case "instrumentText": {
                    instr.setText(node.getTextString());
                    break;
                }
                case "opcodeList": {
                    instr.opcodeList = OpcodeList.loadFromXML(node);
                }
            }
        }
        return instr;
    }

    @Override
    public Element saveAsXML() {
        Element retVal = InstrumentUtilities.getBasicXML(this);
        retVal.addElement("globalOrc").setText(this.getGlobalOrc());
        retVal.addElement("globalSco").setText(this.getGlobalSco());
        retVal.addElement("instrumentText").setText(this.getText());
        retVal.addElement(this.opcodeList.saveAsXML());
        return retVal;
    }

    public OpcodeList getOpcodeList() {
        return this.opcodeList;
    }

    @Override
    public GenericInstrument deepCopy() {
        return new GenericInstrument(this);
    }
}

