/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.blueSynthBuilder;

import blue.automation.Parameter;
import blue.automation.ParameterListener;
import blue.automation.ParameterTimeManagerFactory;
import blue.orchestra.blueSynthBuilder.AutomatableBSBObject;
import blue.orchestra.blueSynthBuilder.BSBCompilationUnit;
import blue.orchestra.blueSynthBuilder.BSBObject;
import blue.orchestra.blueSynthBuilder.ClampedValue;
import blue.orchestra.blueSynthBuilder.ClampedValueListener;
import blue.utility.NumberUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.math.BigDecimal;
import javafx.beans.property.DoubleProperty;

public class BSBValue
extends AutomatableBSBObject
implements ParameterListener {
    ClampedValueListener cvl = (pType, bType) -> {
        Parameter p;
        if (this.parameters != null && (p = this.parameters.getParameter(this.getObjectName())) != null) {
            this.updateParameter(this.getDefaultValueProperty(), p, pType, bType);
        }
    };
    private ClampedValue defaultValue;

    public BSBValue() {
        this.defaultValue = new ClampedValue(0.0, 1.0, 0.0, new BigDecimal(-1.0));
        this.defaultValue.addListener(this.cvl);
    }

    public BSBValue(BSBValue val) {
        super(val);
        this.defaultValue = new ClampedValue(val.defaultValue);
        this.defaultValue.addListener(this.cvl);
    }

    public final void setDefaultValue(double value) {
        this.defaultValue.setValue(value);
    }

    public final double getDefaultValue() {
        return this.defaultValue.getValue();
    }

    public final DoubleProperty defaultValueProperty() {
        return this.defaultValue.valueProperty();
    }

    public final void setMinimum(double value) {
        this.defaultValue.setMin(value);
    }

    public final double getMinimum() {
        return this.defaultValue.getMin();
    }

    public final DoubleProperty minimumProperty() {
        return this.defaultValue.minProperty();
    }

    public final void setMaximum(double value) {
        this.defaultValue.setMax(value);
    }

    public final double getMaximum() {
        return this.defaultValue.getMax();
    }

    public final DoubleProperty maximumProperty() {
        return this.defaultValue.maxProperty();
    }

    private final void setDefaultValueProperty(ClampedValue value) {
        if (this.defaultValue != null) {
            this.defaultValue.removeListener(this.cvl);
        }
        this.defaultValue = value;
        this.defaultValue.addListener(this.cvl);
    }

    private ClampedValue getDefaultValueProperty() {
        return this.defaultValue;
    }

    public static BSBObject loadFromXML(Element data) {
        BSBValue value = new BSBValue();
        double minVal = 0.0;
        double maxVal = 1.0;
        double val = 0.0;
        BSBValue.initBasicFromXML(data, value);
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            Element node = nodes.next();
            String nodeName = node.getName();
            String nodeText = node.getTextString();
            switch (nodeName) {
                case "minimum": {
                    minVal = Double.parseDouble(nodeText);
                    break;
                }
                case "maximum": {
                    maxVal = Double.parseDouble(nodeText);
                    break;
                }
                case "defaultValue": {
                    val = Double.parseDouble(nodeText);
                }
            }
        }
        value.setDefaultValueProperty(new ClampedValue(minVal, maxVal, val, new BigDecimal(-1.0)));
        return value;
    }

    @Override
    public Element saveAsXML() {
        Element retVal = BSBValue.getBasicXML(this);
        retVal.addElement("minimum").setText(Double.toString(this.getMinimum()));
        retVal.addElement("maximum").setText(Double.toString(this.getMaximum()));
        retVal.addElement("defaultValue").setText(Double.toString(this.getDefaultValue()));
        return retVal;
    }

    @Override
    public void setupForCompilation(BSBCompilationUnit compilationUnit) {
        Parameter param;
        if (this.parameters != null && (param = this.parameters.getParameter(this.getObjectName())) != null && param.getCompilationVarName() != null) {
            compilationUnit.addReplacementValue(this.getObjectName(), param.getCompilationVarName());
            return;
        }
        compilationUnit.addReplacementValue(this.getObjectName(), Double.toString(this.getDefaultValue()));
    }

    @Override
    public String getPresetValue() {
        return NumberUtilities.formatDouble(this.getDefaultValue());
    }

    @Override
    public void setPresetValue(String val) {
        double fval = Double.parseDouble(val);
        this.setDefaultValue(fval);
    }

    @Override
    public void initializeParameters() {
        if (this.parameters == null) {
            return;
        }
        if (!this.automationAllowed && this.getObjectName() != null && this.getObjectName().length() != 0) {
            Parameter param = this.parameters.getParameter(this.getObjectName());
            if (param != null && param.isAutomationEnabled()) {
                this.automationAllowed = true;
            } else {
                this.parameters.removeParameter(this.getObjectName());
                return;
            }
        }
        if (this.getObjectName() == null || this.getObjectName().trim().length() == 0) {
            return;
        }
        Parameter parameter = this.parameters.getParameter(this.getObjectName());
        if (parameter != null) {
            parameter.addParameterListener(this);
            if (!parameter.isAutomationEnabled()) {
                parameter.setValue(this.getDefaultValue());
            }
            return;
        }
        Parameter param = new Parameter();
        param.setValue(this.getDefaultValue());
        param.setMax(this.getMaximum(), true);
        param.setMin(this.getMinimum(), true);
        param.setName(this.getObjectName());
        param.setResolution(new BigDecimal(-1));
        param.addParameterListener(this);
        param.setValue(this.getDefaultValue());
        this.parameters.add(param);
    }

    @Override
    public void lineDataChanged(Parameter param) {
        Parameter parameter = this.parameters.getParameter(this.getObjectName());
        if (parameter != null) {
            double time = ParameterTimeManagerFactory.getInstance().getTime();
            double val = parameter.getLine().getValue(time);
            this.setDefaultValue(val);
        }
    }

    @Override
    public void parameterChanged(Parameter param) {
    }

    @Override
    public void setAutomationAllowed(boolean allowAutomation) {
        this.automationAllowed = allowAutomation;
        if (this.parameters != null) {
            if (allowAutomation) {
                this.initializeParameters();
            } else if (this.getObjectName() != null && this.getObjectName().length() != 0) {
                this.parameters.removeParameter(this.getObjectName());
            }
        }
    }

    @Override
    public BSBObject deepCopy() {
        return new BSBValue(this);
    }
}

