/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.blueSynthBuilder;

import blue.automation.Parameter;
import blue.automation.ParameterListener;
import blue.automation.ParameterTimeManagerFactory;
import blue.orchestra.blueSynthBuilder.AutomatableBSBObject;
import blue.orchestra.blueSynthBuilder.BSBCompilationUnit;
import blue.orchestra.blueSynthBuilder.BSBObject;
import blue.orchestra.blueSynthBuilder.ClampedValue;
import blue.orchestra.blueSynthBuilder.ClampedValueListener;
import blue.orchestra.blueSynthBuilder.Randomizable;
import blue.utility.NumberUtilities;
import blue.utility.XMLUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.math.BigDecimal;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;

public class BSBXYController
extends AutomatableBSBObject
implements ParameterListener,
Randomizable {
    private final IntegerProperty width = new SimpleIntegerProperty(100);
    private final IntegerProperty height = new SimpleIntegerProperty(80);
    private ClampedValue xValue;
    private ClampedValue yValue;
    private final BooleanProperty randomizable = new SimpleBooleanProperty(true);
    private final BooleanProperty valueDisplayEnabled = new SimpleBooleanProperty(true);
    ClampedValueListener xcvl = (pType, bType) -> {
        Parameter p;
        if (this.parameters != null && (p = this.parameters.getParameter(this.getObjectName() + "X")) != null) {
            this.updateParameter(this.xValueProperty(), p, pType, bType);
        }
    };
    ClampedValueListener ycvl = (pType, bType) -> {
        Parameter p;
        if (this.parameters != null && (p = this.parameters.getParameter(this.getObjectName() + "Y")) != null) {
            this.updateParameter(this.yValueProperty(), p, pType, bType);
        }
    };

    public BSBXYController() {
        this.xValue = new ClampedValue(0.0, 1.0, 0.5, new BigDecimal(-1.0));
        this.xValue.addListener(this.xcvl);
        this.yValue = new ClampedValue(0.0, 1.0, 0.5, new BigDecimal(-1.0));
        this.yValue.addListener(this.ycvl);
    }

    public BSBXYController(BSBXYController xy) {
        super(xy);
        this.xValue = new ClampedValue(xy.xValueProperty());
        this.xValue.addListener(this.xcvl);
        this.yValue = new ClampedValue(xy.yValueProperty());
        this.yValue.addListener(this.ycvl);
        this.setWidth(xy.getWidth());
        this.setHeight(xy.getHeight());
        this.setRandomizable(xy.isRandomizable());
        this.setValueDisplayEnabled(xy.isValueDisplayEnabled());
    }

    @Override
    public void setObjectName(String objectName) {
        String oldName = this.getObjectName();
        if (!(this.unm == null || objectName == null || objectName.length() == 0 || this.unm.isUnique(objectName + "X") && this.unm.isUnique(objectName + "Y"))) {
            return;
        }
        boolean doInitialize = false;
        if (this.parameters != null && this.automationAllowed) {
            if (objectName == null || objectName.length() == 0) {
                this.parameters.removeParameter(oldName + "X");
                this.parameters.removeParameter(oldName + "Y");
            } else {
                Parameter param = this.parameters.getParameter(oldName + "X");
                Parameter param2 = this.parameters.getParameter(oldName + "Y");
                if (param == null || param2 == null) {
                    this.parameters.removeParameter(oldName + "X");
                    this.parameters.removeParameter(oldName + "Y");
                    doInitialize = true;
                } else {
                    param.setName(objectName + "X");
                    param2.setName(objectName + "Y");
                }
            }
        }
        this.objectNameProperty().set((Object)objectName);
        if (doInitialize) {
            this.initializeParameters();
        }
    }

    public final void setWidth(int value) {
        this.width.set(value);
    }

    public final int getWidth() {
        return this.width.get();
    }

    public final IntegerProperty widthProperty() {
        return this.width;
    }

    public final void setHeight(int value) {
        this.height.set(value);
    }

    public final int getHeight() {
        return this.height.get();
    }

    public final IntegerProperty heightProperty() {
        return this.height;
    }

    @Override
    public final void setRandomizable(boolean value) {
        this.randomizable.set(value);
    }

    @Override
    public final boolean isRandomizable() {
        return this.randomizable.get();
    }

    public final BooleanProperty randomizableProperty() {
        return this.randomizable;
    }

    public final void setValueDisplayEnabled(boolean value) {
        this.valueDisplayEnabled.set(value);
    }

    public final boolean isValueDisplayEnabled() {
        return this.valueDisplayEnabled.get();
    }

    public final BooleanProperty valueDisplayEnabledProperty() {
        return this.valueDisplayEnabled;
    }

    public final ClampedValue xValueProperty() {
        return this.xValue;
    }

    public final ClampedValue yValueProperty() {
        return this.yValue;
    }

    public final void setXValue(double val) {
        this.xValue.setValue(val);
    }

    public final double getXValue() {
        return this.xValue.getValue();
    }

    public final void setXMin(double value) {
        this.xValue.setMin(value);
    }

    public final double getXMin() {
        return this.xValue.getMin();
    }

    public final void setXMax(double value) {
        this.xValue.setMax(value);
    }

    public final double getXMax() {
        return this.xValue.getMax();
    }

    public final void setYValue(double val) {
        this.yValue.setValue(val);
    }

    public final double getYValue() {
        return this.yValue.getValue();
    }

    public final void setYMin(double value) {
        this.yValue.setMin(value);
    }

    public final double getYMin() {
        return this.yValue.getMin();
    }

    public final void setYMax(double value) {
        this.yValue.setMax(value);
    }

    public final double getYMax() {
        return this.yValue.getMax();
    }

    private final void setXValueProperty(ClampedValue value) {
        if (this.xValue != null) {
            this.xValue.removeListener(this.xcvl);
        }
        this.xValue = value;
        this.xValue.addListener(this.xcvl);
    }

    private final void setYValueProperty(ClampedValue value) {
        if (this.yValue != null) {
            this.yValue.removeListener(this.ycvl);
        }
        this.yValue = value;
        this.yValue.addListener(this.ycvl);
    }

    public static BSBObject loadFromXML(Element data) {
        BSBXYController xyController = new BSBXYController();
        BSBXYController.initBasicFromXML(data, xyController);
        int version = 1;
        String versionStr = data.getAttributeValue("version");
        if (versionStr != null) {
            version = Integer.parseInt(versionStr);
        }
        double xmin = 0.0;
        double xmax = 1.0;
        double xval = 0.0;
        double ymin = 0.0;
        double ymax = 1.0;
        double yval = 0.0;
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            Element node = nodes.next();
            String nodeName = node.getName();
            String nodeText = node.getTextString();
            switch (nodeName) {
                case "width": {
                    xyController.setWidth(Integer.parseInt(nodeText));
                    break;
                }
                case "height": {
                    xyController.setHeight(Integer.parseInt(nodeText));
                    break;
                }
                case "xMin": {
                    xmin = Double.parseDouble(nodeText);
                    break;
                }
                case "xMax": {
                    xmax = Double.parseDouble(nodeText);
                    break;
                }
                case "yMin": {
                    ymin = Double.parseDouble(nodeText);
                    break;
                }
                case "yMax": {
                    ymax = Double.parseDouble(nodeText);
                    break;
                }
                case "xValue": {
                    xval = Double.parseDouble(nodeText);
                    break;
                }
                case "yValue": {
                    yval = Double.parseDouble(nodeText);
                    break;
                }
                case "randomizable": {
                    xyController.setRandomizable(XMLUtilities.readBoolean(node));
                    break;
                }
                case "valueDisplayEnabled": {
                    xyController.setValueDisplayEnabled(XMLUtilities.readBoolean(node));
                }
            }
        }
        if (version == 1) {
            double xrange = xmax - xmin;
            xval = xrange * xval + xmin;
            double yrange = ymax - ymin;
            yval = yrange * yval + ymin;
        }
        xyController.setXValueProperty(new ClampedValue(xmin, xmax, xval, new BigDecimal(-1.0)));
        xyController.setYValueProperty(new ClampedValue(ymin, ymax, yval, new BigDecimal(-1.0)));
        return xyController;
    }

    @Override
    public Element saveAsXML() {
        Element retVal = AutomatableBSBObject.getBasicXML(this);
        retVal.setAttribute("version", "2");
        retVal.addElement("width").setText(Integer.toString(this.getWidth()));
        retVal.addElement("height").setText(Integer.toString(this.getHeight()));
        retVal.addElement("xMin").setText(Double.toString(this.xValue.getMin()));
        retVal.addElement("xMax").setText(Double.toString(this.xValue.getMax()));
        retVal.addElement("yMin").setText(Double.toString(this.yValue.getMin()));
        retVal.addElement("yMax").setText(Double.toString(this.yValue.getMax()));
        retVal.addElement("xValue").setText(Double.toString(this.xValue.getValue()));
        retVal.addElement("yValue").setText(Double.toString(this.yValue.getValue()));
        retVal.addElement(XMLUtilities.writeBoolean("randomizable", this.isRandomizable()));
        retVal.addElement(XMLUtilities.writeBoolean("valueDisplayEnabled", this.isValueDisplayEnabled()));
        return retVal;
    }

    @Override
    public String[] getReplacementKeys() {
        String objectName = this.getObjectName();
        if (objectName == null || objectName.trim().length() == 0) {
            return new String[0];
        }
        return new String[]{objectName + "X", objectName + "Y"};
    }

    @Override
    public void setupForCompilation(BSBCompilationUnit compilationUnit) {
        String xCompVal = null;
        String yCompVal = null;
        String objectName = this.getObjectName();
        if (this.parameters != null) {
            Parameter param = this.parameters.getParameter(objectName + "X");
            if (param != null && param.getCompilationVarName() != null) {
                xCompVal = param.getCompilationVarName();
            }
            if ((param = this.parameters.getParameter(objectName + "Y")) != null && param.getCompilationVarName() != null) {
                yCompVal = param.getCompilationVarName();
            }
        }
        compilationUnit.addReplacementValue(objectName + "X", xCompVal == null ? NumberUtilities.formatDouble(this.xValue.getValue()) : xCompVal);
        compilationUnit.addReplacementValue(objectName + "Y", yCompVal == null ? NumberUtilities.formatDouble(this.yValue.getValue()) : yCompVal);
    }

    @Override
    public String getPresetValue() {
        return "ver2:" + this.xValue.getValue() + ":" + this.yValue.getValue();
    }

    @Override
    public void setPresetValue(String val) {
        double yVal;
        double xVal;
        String[] vals = val.split(":");
        if (vals.length == 2) {
            xVal = Double.parseDouble(vals[0]);
            yVal = Double.parseDouble(vals[1]);
            xVal = xVal * (this.xValue.getMax() - this.xValue.getMin()) + this.xValue.getMin();
            yVal = yVal * (this.yValue.getMax() - this.yValue.getMin()) + this.yValue.getMin();
        } else {
            xVal = Double.parseDouble(vals[1]);
            yVal = Double.parseDouble(vals[2]);
        }
        this.xValue.setValue(xVal);
        this.yValue.setValue(yVal);
    }

    @Override
    public void initializeParameters() {
        Parameter param;
        if (this.parameters == null) {
            return;
        }
        String objectName = this.getObjectName();
        if (!this.automationAllowed && objectName != null && objectName.length() != 0) {
            param = this.parameters.getParameter(objectName + "X");
            if (param != null && param.isAutomationEnabled()) {
                this.automationAllowed = true;
            } else {
                this.parameters.removeParameter(objectName + "X");
                this.parameters.removeParameter(objectName + "Y");
                return;
            }
        }
        if (objectName == null || objectName.trim().length() == 0) {
            return;
        }
        param = this.parameters.getParameter(objectName + "X");
        Parameter param2 = this.parameters.getParameter(objectName + "Y");
        if (param != null && param2 != null) {
            param.addParameterListener(this);
            param2.addParameterListener(this);
            if (!param.isAutomationEnabled()) {
                param.setValue(this.xValue.getValue());
            }
            if (!param2.isAutomationEnabled()) {
                param2.setValue(this.yValue.getValue());
            }
            return;
        }
        if (param != null || param2 != null) {
            this.parameters.removeParameter(objectName + "X");
            this.parameters.removeParameter(objectName + "Y");
            return;
        }
        param = new Parameter();
        param.setValue(this.xValue.getValue());
        param.setMax(this.xValue.getMax(), true);
        param.setMin(this.xValue.getMin(), true);
        param.setName(this.getObjectName() + "X");
        param.setResolution(new BigDecimal(-1));
        param.addParameterListener(this);
        param.setValue(this.xValue.getValue());
        this.parameters.add(param);
        param = new Parameter();
        param.setValue(this.yValue.getValue());
        param.setMax(this.yValue.getMax(), true);
        param.setMin(this.yValue.getMin(), true);
        param.setName(this.getObjectName() + "Y");
        param.setResolution(new BigDecimal(-1));
        param.addParameterListener(this);
        param.setValue(this.yValue.getValue());
        this.parameters.add(param);
    }

    @Override
    public void lineDataChanged(Parameter param) {
        double time = ParameterTimeManagerFactory.getInstance().getTime();
        double val = param.getLine().getValue(time);
        String paramName = param.getName();
        if (paramName.endsWith("X")) {
            this.xValue.setValue(val);
        } else if (paramName.endsWith("Y")) {
            this.yValue.setValue(val);
        }
    }

    @Override
    public void parameterChanged(Parameter param) {
    }

    @Override
    public void setAutomationAllowed(boolean allowAutomation) {
        this.automationAllowed = allowAutomation;
        String objectName = this.getObjectName();
        if (this.parameters != null) {
            if (allowAutomation) {
                this.initializeParameters();
            } else if (objectName != null && objectName.length() != 0) {
                this.parameters.removeParameter(objectName + "X");
                this.parameters.removeParameter(objectName + "Y");
            }
        }
    }

    @Override
    public void randomize() {
        if (this.isRandomizable()) {
            this.xValue.randomizeValue();
            this.yValue.randomizeValue();
        }
    }

    @Override
    public BSBXYController deepCopy() {
        return new BSBXYController(this);
    }
}

