/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.blueSynthBuilder;

import blue.orchestra.blueSynthBuilder.Preset;
import electric.xml.Element;
import electric.xml.Elements;
import java.util.ArrayList;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class PresetGroup
implements Comparable<PresetGroup> {
    private String presetGroupName = "Presets";
    private ArrayList<PresetGroup> subGroups = new ArrayList();
    private ArrayList<Preset> presets = new ArrayList();
    private String currentPresetUniqueId = null;
    private boolean currentPresetModified = false;

    public PresetGroup() {
    }

    public PresetGroup(PresetGroup presetGroup) {
        this.presetGroupName = presetGroup.presetGroupName;
        this.currentPresetUniqueId = presetGroup.currentPresetUniqueId;
        this.currentPresetModified = presetGroup.currentPresetModified;
        for (PresetGroup group : presetGroup.subGroups) {
            this.subGroups.add(new PresetGroup(group));
        }
        for (Preset preset : presetGroup.presets) {
            this.presets.add(new Preset(preset));
        }
    }

    public String getPresetGroupName() {
        return this.presetGroupName;
    }

    public void setPresetGroupName(String presetGroupName) {
        this.presetGroupName = presetGroupName;
    }

    public ArrayList<Preset> getPresets() {
        return this.presets;
    }

    public void setPresets(ArrayList<Preset> presets) {
        this.presets = presets;
    }

    public ArrayList<PresetGroup> getSubGroups() {
        return this.subGroups;
    }

    public void setSubGroups(ArrayList<PresetGroup> subGroups) {
        this.subGroups = subGroups;
    }

    public String getCurrentPresetUniqueId() {
        return this.currentPresetUniqueId;
    }

    public void setCurrentPresetUniqueId(String currentPresetUniqueId) {
        this.currentPresetUniqueId = currentPresetUniqueId;
    }

    public boolean isCurrentPresetModified() {
        return this.currentPresetModified;
    }

    public void setCurrentPresetModified(boolean currentPresetModified) {
        this.currentPresetModified = currentPresetModified;
    }

    public static PresetGroup loadFromXML(Element data) {
        PresetGroup group = new PresetGroup();
        group.setPresetGroupName(data.getAttributeValue("name"));
        String val = data.getAttributeValue("currentPresetUniqueId");
        if (val != null && val.length() > 0) {
            group.setCurrentPresetUniqueId(val);
        }
        if ((val = data.getAttributeValue("currentPresetModified")) != null && val.length() > 0) {
            group.setCurrentPresetModified(Boolean.valueOf(val));
        }
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            Element node = nodes.next();
            switch (node.getName()) {
                case "presetGroup": {
                    PresetGroup pGroup = PresetGroup.loadFromXML(node);
                    group.getSubGroups().add(pGroup);
                    break;
                }
                case "preset": {
                    Preset preset = Preset.loadFromXML(node);
                    group.getPresets().add(preset);
                }
            }
        }
        return group;
    }

    public Element saveAsXML() {
        Element retVal = new Element("presetGroup");
        retVal.setAttribute("name", this.getPresetGroupName());
        if (this.currentPresetUniqueId != null) {
            retVal.setAttribute("currentPresetUniqueId", this.currentPresetUniqueId);
            retVal.setAttribute("currentPresetModified", Boolean.toString(this.currentPresetModified));
        }
        for (PresetGroup subGroup : this.subGroups) {
            retVal.addElement(subGroup.saveAsXML());
        }
        for (Preset preset : this.presets) {
            retVal.addElement(preset.saveAsXML());
        }
        return retVal;
    }

    @Override
    public int compareTo(PresetGroup b) {
        return this.getPresetGroupName().compareTo(b.getPresetGroupName());
    }

    public void addPreset(Preset preset) {
        this.presets.add(preset);
    }

    public void addPresetGroup(PresetGroup presetGroup) {
        this.subGroups.add(presetGroup);
    }

    public boolean removePreset(Preset preset) {
        if (this.presets.contains(preset)) {
            this.presets.remove(preset);
            return true;
        }
        for (PresetGroup tempGroup : this.subGroups) {
            if (!tempGroup.removePreset(preset)) continue;
            return true;
        }
        return false;
    }

    public boolean removePresetGroup(PresetGroup presetGroup) {
        if (this.subGroups.contains(presetGroup)) {
            this.subGroups.remove(presetGroup);
            return true;
        }
        for (PresetGroup tempGroup : this.subGroups) {
            if (!tempGroup.removePresetGroup(presetGroup)) continue;
            return true;
        }
        return false;
    }

    public Preset findPresetByUniqueId(String uniqueId) {
        if (uniqueId == null) {
            return null;
        }
        for (PresetGroup presetGroup : this.subGroups) {
            Preset preset = presetGroup.findPresetByUniqueId(uniqueId);
            if (preset == null) continue;
            return preset;
        }
        for (Preset preset : this.presets) {
            if (!uniqueId.equals(preset.getUniqueId())) continue;
            return preset;
        }
        return null;
    }

    public String getPresetFullPathName(String uniqueId) {
        if (uniqueId == null) {
            return null;
        }
        for (PresetGroup presetGroup : this.subGroups) {
            Preset preset = presetGroup.findPresetByUniqueId(uniqueId);
            if (preset == null) continue;
            return presetGroup.getPresetGroupName() + " :: " + preset.getPresetName();
        }
        for (Preset preset : this.presets) {
            if (!uniqueId.equals(preset.getUniqueId())) continue;
            return preset.getPresetName();
        }
        return null;
    }

    public String toString() {
        return this.getPresetGroupName();
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }
}

