/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject;

import blue.noteProcessor.NoteProcessorChain;
import blue.soundObject.Instance;
import blue.soundObject.PolyObject;
import blue.soundObject.SoundObject;
import electric.xml.Element;
import java.awt.Color;

public class SoundObjectUtilities {
    public static Element getBasicXML(SoundObject sObj) {
        Element retVal = new Element("soundObject");
        retVal.setAttribute("type", sObj.getClass().getName());
        retVal.addElement("subjectiveDuration").setText(Double.toString(sObj.getSubjectiveDuration()));
        retVal.addElement("startTime").setText(Double.toString(sObj.getStartTime()));
        retVal.addElement("name").setText(sObj.getName());
        String colorStr = Integer.toString(sObj.getBackgroundColor().getRGB());
        retVal.addElement("backgroundColor").setText(colorStr);
        if (sObj.getTimeBehavior() != -1) {
            retVal.addElement("timeBehavior").setText(Integer.toString(sObj.getTimeBehavior()));
        }
        if (sObj.getTimeBehavior() == 1) {
            retVal.addElement("repeatPoint").setText(Double.toString(sObj.getRepeatPoint()));
        }
        if (sObj.getNoteProcessorChain() != null) {
            retVal.addElement(sObj.getNoteProcessorChain().saveAsXML());
        }
        return retVal;
    }

    public static void initBasicFromXML(Element data, SoundObject sObj) throws Exception {
        sObj.setSubjectiveDuration(Double.parseDouble(data.getTextString("subjectiveDuration")));
        sObj.setStartTime(Double.parseDouble(data.getTextString("startTime")));
        String name = data.getTextString("name");
        if (name == null) {
            sObj.setName("");
        } else {
            sObj.setName(name);
        }
        if (data.getElement("backgroundColor") != null) {
            String colorStr = data.getTextString("backgroundColor");
            sObj.setBackgroundColor(new Color(Integer.parseInt(colorStr)));
        }
        if (data.getElement("timeBehavior") != null) {
            sObj.setTimeBehavior(Integer.parseInt(data.getTextString("timeBehavior")));
        }
        if (sObj.getTimeBehavior() == 1 && data.getElement("repeatPoint") != null) {
            sObj.setRepeatPoint(Double.parseDouble(data.getTextString("repeatPoint")));
        }
        if (data.getElement("noteProcessorChain") != null) {
            sObj.setNoteProcessorChain(NoteProcessorChain.loadFromXML(data.getElement("noteProcessorChain")));
        }
    }

    public static boolean isOrContainsInstance(SoundObject sObj) {
        if (sObj instanceof Instance) {
            return true;
        }
        if (sObj instanceof PolyObject) {
            PolyObject pObj = (PolyObject)sObj;
            for (SoundObject soundObject : pObj.getSoundObjects(true)) {
                if (!SoundObjectUtilities.isOrContainsInstance(soundObject)) continue;
                return true;
            }
        }
        return false;
    }
}

