/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.jmask;

import blue.soundObject.jmask.Accumulatable;
import blue.soundObject.jmask.Generator;
import blue.soundObject.jmask.Quantizable;
import blue.soundObject.jmask.Table;
import blue.soundObject.jmask.TablePoint;
import electric.xml.Element;
import electric.xml.Elements;
import java.util.Random;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Segment
implements Generator,
Quantizable,
Accumulatable {
    Table table = new Table();

    public Segment() {
    }

    public Segment(Segment seg) {
        this.table = new Table(seg.table);
    }

    public static Generator loadFromXML(Element data) {
        Segment retVal = new Segment();
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            Element node = nodes.next();
            String nodeName = node.getName();
            if (!nodeName.equals("table")) continue;
            retVal.table = Table.loadFromXML(node);
        }
        return retVal;
    }

    @Override
    public Element saveAsXML() {
        Element retVal = new Element("generator");
        retVal.setAttribute("type", this.getClass().getName());
        retVal.addElement(this.table.saveAsXML());
        return retVal;
    }

    @Override
    public void initialize(double duration) {
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            TablePoint tp = this.table.getTablePoint(i);
            tp.setTime(tp.getTime() * duration);
        }
    }

    @Override
    public double getValue(double time, Random rnd) {
        return this.table.getValue(time);
    }

    public Table getTable() {
        return this.table;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Override
    public Segment deepCopy() {
        return new Segment(this);
    }
}

