/*
 * Decompiled with CFR 0.152.
 */
package blue.udo;

import blue.udo.UDOCategory;
import blue.udo.UserDefinedOpcode;
import blue.utility.ListUtil;
import electric.xml.Element;
import java.util.Collections;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class UDOLibrary
implements TreeModel {
    UDOCategory rootUDOCategory = new UDOCategory();
    transient Vector listeners = new Vector();

    public UDOLibrary() {
        this.rootUDOCategory.setRoot(true);
        this.rootUDOCategory.setCategoryName("UDO Library");
    }

    public UDOCategory getRootUDOCategory() {
        return this.rootUDOCategory;
    }

    public void setRootUDOCategory(UDOCategory rootUDOCategory) {
        this.rootUDOCategory = rootUDOCategory;
    }

    public void addUDO(UDOCategory parent, UserDefinedOpcode udo) {
        this.addUDO(parent, -1, udo);
    }

    public void addUDO(UDOCategory parent, int insertIndex, UserDefinedOpcode udo) {
        if (insertIndex < 0 || insertIndex >= parent.getUserDefinedOpcodes().size()) {
            parent.addUDO(udo);
        } else {
            parent.addUDO(insertIndex, udo);
        }
        int index = this.getIndexOfChild(parent, udo);
        int[] childIndices = new int[]{index};
        Object[] children = new Object[]{udo};
        TreeModelEvent e = new TreeModelEvent((Object)this, this.getPathForObject(udo), childIndices, children);
        this.fireNodesInserted(e);
    }

    private Object[] getPathForObject(Object obj) {
        Vector v = new Vector();
        this.getPathForObject(this.getRootUDOCategory(), obj, v);
        Collections.reverse(v);
        return v.toArray();
    }

    private Object getPathForObject(UDOCategory current, Object obj, Vector v) {
        if (current == obj) {
            return v;
        }
        if (ListUtil.containsByRef(current.getUserDefinedOpcodes(), obj)) {
            v.add(current);
            return v;
        }
        for (UDOCategory cat : current.getSubCategories()) {
            Object pathObj = this.getPathForObject(cat, obj, v);
            if (pathObj == null) continue;
            v.add(current);
            return v;
        }
        return null;
    }

    public void addCategory(UDOCategory parent, UDOCategory cat) {
        parent.addUDOCategory(cat);
        int index = this.getIndexOfChild(parent, cat);
        int[] childIndices = new int[]{index};
        Object[] children = new Object[]{cat};
        TreeModelEvent e = new TreeModelEvent((Object)this, this.getPathForObject(cat), childIndices, children);
        this.fireNodesInserted(e);
    }

    public void removeUDO(UserDefinedOpcode udo) {
        UDOCategory parent = this.findParent(this.rootUDOCategory, udo);
        int index = this.getIndexOfChild(parent, udo);
        int[] childIndices = new int[]{index};
        Object[] children = new Object[]{udo};
        TreeModelEvent e = new TreeModelEvent((Object)this, this.getPathForObject(udo), childIndices, children);
        this.rootUDOCategory.removeUDO(udo);
        this.fireNodesRemoved(e);
    }

    public void removeCategory(UDOCategory cat) {
        UDOCategory parent = this.findParent(this.rootUDOCategory, cat);
        int index = this.getIndexOfChild(parent, cat);
        int[] childIndices = new int[]{index};
        Object[] children = new Object[]{cat};
        TreeModelEvent e = new TreeModelEvent((Object)this, this.getPathForObject(cat), childIndices, children);
        this.rootUDOCategory.removeUDOCategory(cat);
        this.fireNodesRemoved(e);
    }

    public static UDOLibrary loadFromXML(Element data) throws Exception {
        UDOLibrary iLibrary = new UDOLibrary();
        iLibrary.setRootUDOCategory(UDOCategory.loadFromXML(data.getElement("udoCategory")));
        return iLibrary;
    }

    public Element saveAsXML() {
        Element retVal = new Element("udoLibrary");
        retVal.addElement(this.rootUDOCategory.saveAsXML());
        return retVal;
    }

    @Override
    public Object getRoot() {
        return this.getRootUDOCategory();
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent instanceof UserDefinedOpcode) {
            return 0;
        }
        if (parent instanceof UDOCategory) {
            UDOCategory cat = (UDOCategory)parent;
            return cat.getSubCategories().size() + cat.getUserDefinedOpcodes().size();
        }
        return 0;
    }

    @Override
    public boolean isLeaf(Object node) {
        return node instanceof UserDefinedOpcode;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        Object obj = path.getLastPathComponent();
        if (obj instanceof UDOCategory) {
            ((UDOCategory)obj).setCategoryName(newValue.toString());
        } else if (obj instanceof UserDefinedOpcode) {
            ((UserDefinedOpcode)obj).setOpcodeName(newValue.toString());
        }
        TreeModelEvent e = new TreeModelEvent((Object)this, path);
        this.fireNodesChanged(e);
    }

    private void fireNodesChanged(TreeModelEvent e) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TreeModelListener)this.listeners.get(i)).treeNodesChanged(e);
        }
    }

    private void fireNodesInserted(TreeModelEvent e) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TreeModelListener)this.listeners.get(i)).treeNodesInserted(e);
        }
    }

    private void fireNodesRemoved(TreeModelEvent e) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TreeModelListener)this.listeners.get(i)).treeNodesRemoved(e);
        }
    }

    private void fireTreeStructureChanged(TreeModelEvent e) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TreeModelListener)this.listeners.get(i)).treeStructureChanged(e);
        }
    }

    @Override
    public Object getChild(Object parent, int index) {
        UDOCategory category = (UDOCategory)parent;
        if (category == null) {
            return null;
        }
        if (index >= category.getSubCategories().size()) {
            return category.getUserDefinedOpcodes().get(index - category.getSubCategories().size());
        }
        return category.getSubCategories().get(index);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        UDOCategory category = (UDOCategory)parent;
        if (category == null || child == null) {
            return -1;
        }
        int retVal = ListUtil.indexOfByRef(category.getSubCategories(), child);
        if (retVal >= 0) {
            return retVal;
        }
        retVal = ListUtil.indexOfByRef(category.getUserDefinedOpcodes(), child);
        if (retVal >= 0) {
            return retVal + category.getSubCategories().size();
        }
        return -1;
    }

    private UDOCategory findParent(UDOCategory cat, Object obj) {
        if (ListUtil.containsByRef(cat.getUserDefinedOpcodes(), obj) || ListUtil.containsByRef(cat.getSubCategories(), obj)) {
            return cat;
        }
        for (UDOCategory c : cat.getSubCategories()) {
            UDOCategory temp = this.findParent(c, obj);
            if (temp == null) continue;
            return temp;
        }
        return null;
    }
}

