/*
 * Decompiled with CFR 0.152.
 */
package blue.utility;

import blue.BlueSystem;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class SoundFileUtilities {
    public static int getNumberOfChannels(String soundFileName) throws IOException, UnsupportedAudioFileException {
        File soundFile = BlueSystem.findFile(soundFileName);
        AudioFileFormat aFormat = AudioSystem.getAudioFileFormat(soundFile);
        AudioFormat format = aFormat.getFormat();
        return format.getChannels();
    }

    public static float getDurationInSeconds(String soundFileName) throws IOException, UnsupportedAudioFileException {
        File soundFile = BlueSystem.findFile(soundFileName);
        AudioFileFormat aFormat = AudioSystem.getAudioFileFormat(soundFile);
        AudioFormat format = aFormat.getFormat();
        float duration = (float)aFormat.getByteLength() / (format.getSampleRate() * (float)(format.getSampleSizeInBits() / 8) * (float)format.getChannels());
        return duration;
    }

    public static int getNumberOfFrames(String soundFileName) throws IOException, UnsupportedAudioFileException {
        File soundFile = BlueSystem.findFile(soundFileName);
        AudioFileFormat aFormat = AudioSystem.getAudioFileFormat(soundFile);
        return aFormat.getFrameLength();
    }

    public static float getSampleRate(String soundFileName) throws IOException, UnsupportedAudioFileException {
        File soundFile = BlueSystem.findFile(soundFileName);
        AudioFileFormat aFormat = AudioSystem.getAudioFileFormat(soundFile);
        AudioFormat format = aFormat.getFormat();
        return format.getSampleRate();
    }
}

