/*
 * Decompiled with CFR 0.152.
 */
package blue.jfx.controls;

import blue.jfx.controls.Knob;
import javafx.beans.InvalidationListener;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Tooltip;
import javafx.scene.effect.Effect;
import javafx.scene.effect.Glow;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Ellipse;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeType;

public class KnobSkin
extends SkinBase<Knob> {
    private static double ARC_LENGTH = 270.0;
    Shape track;
    double mouseYBase = 0.0;
    double baseValue = 0.0;
    DoubleBinding percent;
    boolean invalid = true;
    Tooltip tooltip = new Tooltip();
    InvalidationListener invalidListener = o -> {
        this.invalid = true;
    };

    public KnobSkin(Knob knob) {
        super((Control)knob);
        knob.getStyleClass().add((Object)"knob");
        DoubleBinding range = knob.maxProperty().subtract((ObservableNumberValue)knob.minProperty());
        this.percent = knob.valueProperty().subtract((ObservableNumberValue)knob.minProperty()).divide((ObservableNumberValue)range);
        this.initHandlers();
        knob.widthProperty().addListener(this.invalidListener);
        knob.heightProperty().addListener(this.invalidListener);
        knob.setTooltip(this.tooltip);
        this.tooltip.textProperty().bind((ObservableValue)knob.valueProperty().asString());
    }

    private void initHandlers() {
        Knob knob = (Knob)this.getSkinnable();
        knob.setOnMousePressed(e -> {
            this.mouseYBase = e.getY();
            this.baseValue = knob.getValue();
        });
        knob.setOnMouseDragged(e -> {
            double mouseAdjust = this.mouseYBase - e.getY();
            double valueAdjust = 0.01 * mouseAdjust * knob.getRange();
            double newValue = this.baseValue + valueAdjust;
            if (newValue < knob.getMin()) {
                knob.setValue(knob.getMin());
            } else if (newValue > knob.getMax()) {
                knob.setValue(knob.getMax());
            } else {
                knob.setValue(newValue);
            }
        });
    }

    private void initComponents(double w) {
        this.getChildren().clear();
        double width = this.snapSize(w);
        double radius = width / 2.0;
        double innerRadius = this.snapSize(radius * 0.5);
        Color trackColor = ((Knob)this.getSkinnable()).getTrackColor();
        Ellipse outer = new Ellipse(radius, radius, radius, radius);
        Ellipse inner = new Ellipse(radius, radius, innerRadius, innerRadius);
        Shape shape = Path.subtract((Shape)outer, (Shape)inner);
        Rectangle rect = new Rectangle(radius, radius);
        Shape trackBG = Path.subtract((Shape)shape, (Shape)rect);
        trackBG.setRotate(-135.0);
        trackBG.setStroke((Paint)((Knob)this.getSkinnable()).getTrackBackgroundColor());
        trackBG.setStrokeType(StrokeType.INSIDE);
        trackBG.setFill((Paint)((Knob)this.getSkinnable()).getTrackBackgroundColor().darker());
        Arc mask = new Arc(radius, radius, radius + 2.0, radius + 2.0, -270.0, -270.0);
        mask.setType(ArcType.ROUND);
        mask.lengthProperty().bind((ObservableValue)this.percent.multiply(-ARC_LENGTH));
        this.track = Path.subtract((Shape)shape, (Shape)rect);
        this.track.setRotate(-135.0);
        this.track.setStroke((Paint)trackColor);
        this.track.setStrokeType(StrokeType.INSIDE);
        this.track.setFill((Paint)trackColor.deriveColor(1.0, 1.0, 1.0, 0.5));
        this.track.setClip((Node)mask);
        this.track.setEffect((Effect)new Glow(1.0));
        Canvas c = new Canvas(width, width);
        GraphicsContext gc = c.getGraphicsContext2D();
        gc.setStroke((Paint)trackColor.brighter().brighter().brighter());
        gc.setLineWidth(2.0);
        gc.strokeLine(radius, 0.0, radius, radius - innerRadius - 1.0);
        gc.setFill((Paint)Color.BLACK);
        gc.fillOval(width * 0.25, width * 0.25, width * 0.5, width * 0.5);
        gc.setFill((Paint)trackColor);
        double notchWidth = width / 10.0;
        double notchAdj = notchWidth / 2.0;
        gc.fillRoundRect(radius - notchAdj, width * 0.25 - notchAdj, notchWidth, width * 0.25 + notchWidth, notchWidth, notchWidth);
        gc.setStroke((Paint)Color.BLACK);
        gc.strokeRoundRect(radius - notchAdj, width * 0.25 - notchAdj, notchWidth, width * 0.25 + notchWidth, notchWidth, notchWidth);
        c.rotateProperty().bind((ObservableValue)this.percent.multiply(ARC_LENGTH).subtract(135.0));
        this.getChildren().addAll((Object[])new Node[]{trackBG, this.track, c});
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return topInset + bottomInset + 60.0;
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return leftInset + rightInset + 60.0;
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return Double.MAX_VALUE;
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return Double.MAX_VALUE;
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return topInset + bottomInset + 10.0;
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return leftInset + rightInset + 10.0;
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        if (this.invalid) {
            this.initComponents(contentWidth);
            this.invalid = false;
        }
        for (Node child : this.getChildren()) {
            this.layoutInArea(child, contentX, contentY, contentWidth, contentHeight, 0.0, HPos.LEFT, VPos.TOP);
        }
    }

    public void dispose() {
        ((Knob)this.getSkinnable()).widthProperty().removeListener(this.invalidListener);
        ((Knob)this.getSkinnable()).heightProperty().removeListener(this.invalidListener);
    }
}

