/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs.impl;

import java.util.List;
import javax.swing.event.ListDataEvent;
import javax.swing.table.AbstractTableModel;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.netbeans.swing.tabcontrol.event.ComplexListDataEvent;
import org.netbeans.swing.tabcontrol.event.ComplexListDataListener;

public abstract class TabTableModel
extends AbstractTableModel {
    protected final TabDataModel tabModel;

    protected TabTableModel(TabDataModel tabModel) {
        this.tabModel = tabModel;
    }

    public static TabTableModel create(TabDataModel tabModel, int tabsLocation) {
        if (tabsLocation == 2 || tabsLocation == 4) {
            return new ColumnTableModel(tabModel);
        }
        return new RowTableModel(tabModel);
    }

    public static TabTableModel create(TabDataModel tabModel, List<Integer> tabIndexes) {
        return new MapTableModel(tabModel, tabIndexes);
    }

    @Override
    public final Object getValueAt(int rowIndex, int columnIndex) {
        TabData res = null;
        int tabIndex = this.toTabIndex(rowIndex, columnIndex);
        if (tabIndex >= 0 && tabIndex < this.tabModel.size()) {
            res = this.tabModel.getTab(tabIndex);
        }
        return res;
    }

    public final Class getColumnClass(int col) {
        return TabData.class;
    }

    protected abstract int toTabIndex(int var1, int var2);

    protected abstract int toColumnIndex(int var1);

    protected abstract int toRowIndex(int var1);

    private static class ColumnTableModel
    extends DefaultTabTableModel {
        public ColumnTableModel(TabDataModel tabModel) {
            super(tabModel);
        }

        @Override
        protected int toTabIndex(int rowIndex, int colIndex) {
            return rowIndex;
        }

        @Override
        public int getRowCount() {
            return this.tabModel.size();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        protected int toColumnIndex(int tabIndex) {
            return 0;
        }

        @Override
        protected int toRowIndex(int tabIndex) {
            return tabIndex;
        }
    }

    private static abstract class DefaultTabTableModel
    extends TabTableModel
    implements ComplexListDataListener {
        DefaultTabTableModel(TabDataModel tabModel) {
            super(tabModel);
            tabModel.addComplexListDataListener((ComplexListDataListener)this);
        }

        public void indicesAdded(ComplexListDataEvent e) {
            this.fireTableStructureChanged();
        }

        public void indicesRemoved(ComplexListDataEvent e) {
            this.fireTableStructureChanged();
        }

        public void indicesChanged(ComplexListDataEvent e) {
            this.fireTableStructureChanged();
        }

        public void intervalAdded(ListDataEvent e) {
            this.fireTableStructureChanged();
        }

        public void intervalRemoved(ListDataEvent e) {
            this.fireTableStructureChanged();
        }

        public void contentsChanged(ListDataEvent e) {
            this.fireTableDataChanged();
        }
    }

    private static class MapTableModel
    extends TabTableModel {
        private final List<Integer> tabIndexes;

        public MapTableModel(TabDataModel tabModel, List<Integer> tabIndexes) {
            super(tabModel);
            this.tabIndexes = tabIndexes;
        }

        @Override
        protected int toTabIndex(int rowIndex, int colIndex) {
            int res = -1;
            if (colIndex >= 0 && colIndex < this.tabIndexes.size()) {
                res = this.tabIndexes.get(colIndex);
            }
            return res;
        }

        @Override
        protected int toColumnIndex(int tabIndex) {
            int index = 0;
            for (Integer i : this.tabIndexes) {
                if (i == tabIndex) {
                    return index;
                }
                ++index;
            }
            return -1;
        }

        @Override
        protected int toRowIndex(int tabIndex) {
            return 0;
        }

        @Override
        public int getRowCount() {
            return this.tabIndexes.isEmpty() ? 0 : 1;
        }

        @Override
        public int getColumnCount() {
            return this.tabIndexes.size();
        }
    }

    private static class RowTableModel
    extends DefaultTabTableModel {
        public RowTableModel(TabDataModel tabModel) {
            super(tabModel);
        }

        @Override
        protected int toTabIndex(int rowIndex, int colIndex) {
            return colIndex;
        }

        @Override
        public int getRowCount() {
            return 1;
        }

        @Override
        public int getColumnCount() {
            return this.tabModel.size();
        }

        @Override
        protected int toColumnIndex(int tabIndex) {
            return tabIndex;
        }

        @Override
        protected int toRowIndex(int tabIndex) {
            return 0;
        }
    }
}

