/*
 * Decompiled with CFR 0.152.
 */
package blue.score.layers.patterns.ui;

import blue.score.TimeState;
import blue.score.layers.patterns.core.PatternData;
import blue.score.layers.patterns.core.PatternLayer;
import blue.score.layers.patterns.core.PatternsLayerGroup;
import blue.score.layers.patterns.ui.PatternsLayerPanel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class PatternsLayerPanelMouseListener
extends MouseAdapter {
    private final PatternsLayerPanel panel;
    private final PatternsLayerGroup layerGroup;
    private PatternData selectedData = null;
    private PatternData clone = null;
    private boolean setSquareOn = false;
    private final TimeState timeState;
    int startIndex = -1;
    int lastIndex = -1;
    PatternLayer currentPatternLayer = null;

    public PatternsLayerPanelMouseListener(PatternsLayerPanel panel, PatternsLayerGroup layerGroup, TimeState timeState) {
        this.panel = panel;
        this.layerGroup = layerGroup;
        this.timeState = timeState;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int patternIndex;
        e.consume();
        this.panel.requestFocus();
        int x = e.getX();
        int y = e.getY();
        if (y < 0 || y >= this.panel.getHeight()) {
            this.selectedData = null;
            return;
        }
        int layerIndex = y / 22;
        PatternLayer layer = (PatternLayer)this.layerGroup.get(layerIndex);
        this.startIndex = patternIndex = (int)((float)x / (float)(this.layerGroup.getPatternBeatsLength() * this.timeState.getPixelSecond()));
        this.lastIndex = patternIndex;
        this.selectedData = layer.getPatternData();
        this.clone = new PatternData(this.selectedData);
        this.setSquareOn = !layer.getPatternData().isPatternSet(patternIndex);
        this.selectedData.setPattern(patternIndex, this.setSquareOn);
        this.panel.checkSize();
        this.panel.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.selectedData = null;
        this.clone = null;
        this.startIndex = -1;
        this.lastIndex = -1;
        e.consume();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        e.consume();
        if (this.selectedData == null) {
            return;
        }
        int x = e.getX();
        if (x < 0) {
            x = 0;
        } else if (x > this.panel.getWidth()) {
            x = this.panel.getWidth();
        }
        int patternIndex = (int)((float)x / (float)(this.layerGroup.getPatternBeatsLength() * this.timeState.getPixelSecond()));
        if (patternIndex == this.lastIndex) {
            return;
        }
        if (patternIndex > this.startIndex) {
            for (int i = this.lastIndex + 1; i <= patternIndex; ++i) {
                if (this.selectedData.isPatternSet(i) == this.setSquareOn) continue;
                this.selectedData.setPattern(i, this.setSquareOn);
            }
        } else {
            for (int i = this.lastIndex - 1; i >= patternIndex; --i) {
                if (this.selectedData.isPatternSet(i) == this.setSquareOn) continue;
                this.selectedData.setPattern(i, this.setSquareOn);
            }
        }
        this.panel.checkSize();
        this.panel.repaint();
        this.lastIndex = patternIndex;
    }
}

