;
; "Palimpsest"
; by Dave Seidel
;
; Copyright 2007 Dave Seidel, some rights reserved.  This work is licensed under a
; Creative Commons Attribution License (see http://creativecommons.org/licenses/by/3.0/).
; 
; For more information, go to http://mysterybear.net/article/23/palimpsest
; 
; Add the following lines after <CsoundSynthesizer> and before <CsInstruments> below,
; uncomment by removing the leading semicolons, then edit as desired.
; 
; *** START OF OPTIONS ***
; <CsOptions>
; ;; 96K/24-bit
; ;--sample-rate=96000 --control-rate=96000 --format=wav:24bit -o "Palimpsest-(96-24).wav"
; ;; 44.1K/16-bit
; --sample-rate=44100 --control-rate=44100 --format=wav:short -o "Palimpsest-(44-16).wav"
; </CsOptions>
; *** END OF OPTIONS ***
; 
;
; Generated by blue 0.115.0 (http://csounds.com/stevenyi/blue/index.html)
;

<CsoundSynthesizer>

<CsOptions>

;; 96K/24-bit
;--sample-rate=96000 --control-rate=96000 --format=wav:24bit -o "Palimpsest-(96-24).wav"

;; 44.1K/16-bit
--sample-rate=44100 --control-rate=44100 --format=wav:short -o "Palimpsest-(44-16).wav"

</CsOptions>

<CsInstruments>
sr=96000
ksmps=1
nchnls=2

; sine wave table
giTblSz	init	1048576
gifn1	ftgen	1, 0, giTblSz, 10, 1

; globals left/right channels
gaL	init	0
gaR	init	0






	instr 1	;sine
idur	=	p3				; duration
iamp	=	p4				; amplitude
ifn	=	p5				; function table number (waveform)
ifreq	=	p6
ilr	=	p7				; 1.0 = left <-> 0.0 = right
irise	=	p8
ifall	=	p9
index	=	p10				; display only

;	print	p2, index

kenv	linen	iamp, irise, idur, ifall	; envelope for poscil
asig	poscil3	kenv, ifreq, ifn, -1

gaL	=	gaL + (asig*ilr)
gaR	=	gaR + (asig*(1-ilr))

	endin

	instr 2	;stereo reverb
aL, aR	reverbsc gaL, gaR, p4, p5, sr/1.5, p6, 0
a1	= 	gaL+(aL*p7)
a2	= 	gaR+(aR*p7)
	outs	a1, a2
gaL	=	0
gaR	=	0
	endin


</CsInstruments>

<CsScore>



# tempo scaling
t 0 20 316 60






i2	0.0	337	.9	30720	.5	.7
i1	0.0	20.7000007629	4000.000000	1	60.000000	1.000000	1.700000	6.900000	1
i1	3.1206	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	3.117	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	3.1134	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	3.1098	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	3.1062	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	3.1026	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	3.099	3.4500000477	72.727273	1	3300.000000	1.000000	1.700000	1.000000	55
i1	3.0954	3.4500000477	75.471698	1	3180.000000	1.000000	1.700000	1.000000	53
i1	3.0918	3.4500000477	78.431373	1	3060.000000	1.000000	1.700000	1.000000	51
i1	3.0882	3.4500000477	81.632653	1	2940.000000	1.000000	1.700000	1.000000	49
i1	3.0846	3.4500000477	85.106383	1	2820.000000	1.000000	1.700000	1.000000	47
i1	3.081	3.4500000477	88.888889	1	2700.000000	1.000000	1.700000	1.000000	45
i1	3.0774	3.4500000477	93.023256	1	2580.000000	1.000000	1.700000	1.000000	43
i1	3.0738	3.4500000477	97.560976	1	2460.000000	1.000000	1.700000	1.000000	41
i1	3.0702	3.4500000477	102.564103	1	2340.000000	1.000000	1.700000	1.000000	39
i1	3.0666	3.4500000477	108.108108	1	2220.000000	1.000000	1.700000	1.000000	37
i1	3.063	3.4500000477	114.285714	1	2100.000000	1.000000	1.700000	1.000000	35
i1	3.0594	3.4500000477	121.212121	1	1980.000000	1.000000	1.700000	1.000000	33
i1	3.0558	3.4500000477	129.032258	1	1860.000000	1.000000	1.700000	1.000000	31
i1	3.0522	3.4500000477	137.931034	1	1740.000000	1.000000	1.700000	1.000000	29
i1	3.0486	3.4500000477	148.148148	1	1620.000000	1.000000	1.700000	1.000000	27
i1	3.045	3.4500000477	160.000000	1	1500.000000	1.000000	1.700000	1.000000	25
i1	3.0414	3.4500000477	173.913043	1	1380.000000	1.000000	1.700000	1.000000	23
i1	3.0378	3.4500000477	190.476190	1	1260.000000	1.000000	1.700000	1.000000	21
i1	3.0342	3.4500000477	210.526316	1	1140.000000	1.000000	1.700000	1.000000	19
i1	3.0306	3.4500000477	235.294118	1	1020.000000	1.000000	1.700000	1.000000	17
i1	3.027	3.4500000477	266.666667	1	900.000000	1.000000	1.700000	1.000000	15
i1	3.0234	3.4500000477	307.692308	1	780.000000	1.000000	1.700000	1.000000	13
i1	3.0198	3.4500000477	363.636364	1	660.000000	1.000000	1.700000	1.000000	11
i1	3.0162	3.4500000477	444.444444	1	540.000000	1.000000	1.700000	1.000000	9
i1	3.0126	3.4500000477	571.428571	1	420.000000	1.000000	1.700000	1.000000	7
i1	3.009	3.4500000477	800.000000	1	300.000000	1.000000	1.700000	1.000000	5
i1	3.0054	3.4500000477	1333.333333	1	180.000000	1.000000	1.700000	1.000000	3
i1	3.0036	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	3.0072	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	3.0108	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	3.0144	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	3.018	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	3.0216	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	3.0252	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	3.0288	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	3.0324	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	3.036	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	3.0396	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	3.0432	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	3.0468	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	3.0504	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	3.054	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	3.0576	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	3.0612	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	3.0648	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	3.0684	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	3.072	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	3.0756	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	3.0792	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	3.0828	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	3.0864	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	3.09	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	3.0936	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	3.0972	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	3.1008	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	3.1044	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	3.108	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	3.1116	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	3.1152	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	3.1188	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	6.0027	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	6.0054	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	9.2412	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	9.234	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	9.2268	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	9.2196	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	9.2124	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	9.2052	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	9.198	3.4500000477	72.727273	1	3300.000000	1.000000	1.700000	1.000000	55
i1	9.1908	3.4500000477	75.471698	1	3180.000000	1.000000	1.700000	1.000000	53
i1	9.1836	3.4500000477	78.431373	1	3060.000000	1.000000	1.700000	1.000000	51
i1	9.1764	3.4500000477	81.632653	1	2940.000000	1.000000	1.700000	1.000000	49
i1	9.1692	3.4500000477	85.106383	1	2820.000000	1.000000	1.700000	1.000000	47
i1	9.162	3.4500000477	88.888889	1	2700.000000	1.000000	1.700000	1.000000	45
i1	9.1548	3.4500000477	93.023256	1	2580.000000	1.000000	1.700000	1.000000	43
i1	9.1476	3.4500000477	97.560976	1	2460.000000	1.000000	1.700000	1.000000	41
i1	9.1404	3.4500000477	102.564103	1	2340.000000	1.000000	1.700000	1.000000	39
i1	9.1332	3.4500000477	108.108108	1	2220.000000	1.000000	1.700000	1.000000	37
i1	9.126	3.4500000477	114.285714	1	2100.000000	1.000000	1.700000	1.000000	35
i1	9.1188	3.4500000477	121.212121	1	1980.000000	1.000000	1.700000	1.000000	33
i1	9.1116	3.4500000477	129.032258	1	1860.000000	1.000000	1.700000	1.000000	31
i1	9.1044	3.4500000477	137.931034	1	1740.000000	1.000000	1.700000	1.000000	29
i1	9.0972	3.4500000477	148.148148	1	1620.000000	1.000000	1.700000	1.000000	27
i1	9.09	3.4500000477	160.000000	1	1500.000000	1.000000	1.700000	1.000000	25
i1	9.0828	3.4500000477	173.913043	1	1380.000000	1.000000	1.700000	1.000000	23
i1	9.0756	3.4500000477	190.476190	1	1260.000000	1.000000	1.700000	1.000000	21
i1	9.0684	3.4500000477	210.526316	1	1140.000000	1.000000	1.700000	1.000000	19
i1	9.0612	3.4500000477	235.294118	1	1020.000000	1.000000	1.700000	1.000000	17
i1	9.054	3.4500000477	266.666667	1	900.000000	1.000000	1.700000	1.000000	15
i1	9.0468	3.4500000477	307.692308	1	780.000000	1.000000	1.700000	1.000000	13
i1	9.0396	3.4500000477	363.636364	1	660.000000	1.000000	1.700000	1.000000	11
i1	9.0324	3.4500000477	444.444444	1	540.000000	1.000000	1.700000	1.000000	9
i1	9.0252	3.4500000477	571.428571	1	420.000000	1.000000	1.700000	1.000000	7
i1	9.018	3.4500000477	800.000000	1	300.000000	1.000000	1.700000	1.000000	5
i1	9.0036	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	9.0144	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	9.0216	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	9.0288	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	9.036	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	9.0432	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	9.0504	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	9.0576	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	9.0648	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	9.072	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	9.0792	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	9.0864	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	9.0936	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	9.1008	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	9.108	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	9.1152	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	9.1224	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	9.1296	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	9.1368	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	9.144	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	9.1512	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	9.1584	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	9.1656	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	9.1728	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	9.18	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	9.1872	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	9.1944	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	9.2016	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	9.2088	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	9.216	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	9.2232	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	9.2304	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	9.2376	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	12.0135	3.4500000477	1333.333333	1	180.000000	1.000000	1.700000	1.000000	3
i1	12.009	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	12.018	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	15.3618	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	15.351	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	15.3402	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	15.3294	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	15.3186	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	15.3078	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	15.297	3.4500000477	72.727273	1	3300.000000	1.000000	1.700000	1.000000	55
i1	15.2862	3.4500000477	75.471698	1	3180.000000	1.000000	1.700000	1.000000	53
i1	15.2754	3.4500000477	78.431373	1	3060.000000	1.000000	1.700000	1.000000	51
i1	15.2646	3.4500000477	81.632653	1	2940.000000	1.000000	1.700000	1.000000	49
i1	15.2538	3.4500000477	85.106383	1	2820.000000	1.000000	1.700000	1.000000	47
i1	15.243	3.4500000477	88.888889	1	2700.000000	1.000000	1.700000	1.000000	45
i1	15.2322	3.4500000477	93.023256	1	2580.000000	1.000000	1.700000	1.000000	43
i1	15.2214	3.4500000477	97.560976	1	2460.000000	1.000000	1.700000	1.000000	41
i1	15.2106	3.4500000477	102.564103	1	2340.000000	1.000000	1.700000	1.000000	39
i1	15.1998	3.4500000477	108.108108	1	2220.000000	1.000000	1.700000	1.000000	37
i1	15.189	3.4500000477	114.285714	1	2100.000000	1.000000	1.700000	1.000000	35
i1	15.1782	3.4500000477	121.212121	1	1980.000000	1.000000	1.700000	1.000000	33
i1	15.1674	3.4500000477	129.032258	1	1860.000000	1.000000	1.700000	1.000000	31
i1	15.1566	3.4500000477	137.931034	1	1740.000000	1.000000	1.700000	1.000000	29
i1	15.1458	3.4500000477	148.148148	1	1620.000000	1.000000	1.700000	1.000000	27
i1	15.135	3.4500000477	160.000000	1	1500.000000	1.000000	1.700000	1.000000	25
i1	15.1242	3.4500000477	173.913043	1	1380.000000	1.000000	1.700000	1.000000	23
i1	15.1134	3.4500000477	190.476190	1	1260.000000	1.000000	1.700000	1.000000	21
i1	15.1026	3.4500000477	210.526316	1	1140.000000	1.000000	1.700000	1.000000	19
i1	15.0918	3.4500000477	235.294118	1	1020.000000	1.000000	1.700000	1.000000	17
i1	15.081	3.4500000477	266.666667	1	900.000000	1.000000	1.700000	1.000000	15
i1	15.0702	3.4500000477	307.692308	1	780.000000	1.000000	1.700000	1.000000	13
i1	15.0594	3.4500000477	363.636364	1	660.000000	1.000000	1.700000	1.000000	11
i1	15.0486	3.4500000477	444.444444	1	540.000000	1.000000	1.700000	1.000000	9
i1	15.0378	3.4500000477	571.428571	1	420.000000	1.000000	1.700000	1.000000	7
i1	15.0054	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	15.0108	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	15.0324	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	15.0432	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	15.054	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	15.0648	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	15.0756	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	15.0864	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	15.0972	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	15.108	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	15.1188	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	15.1296	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	15.1404	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	15.1512	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	15.162	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	15.1728	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	15.1836	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	15.1944	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	15.2052	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	15.216	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	15.2268	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	15.2376	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	15.2484	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	15.2592	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	15.27	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	15.2808	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	15.2916	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	15.3024	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	15.3132	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	15.324	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	15.3348	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	15.3456	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	15.3564	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	18.0315	3.4500000477	800.000000	1	300.000000	1.000000	1.700000	1.000000	5
i1	18.0063	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	18.0252	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	18.0378	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	21.4824	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	21.468	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	21.4536	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	21.4392	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	21.4248	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	21.4104	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	21.396	3.4500000477	72.727273	1	3300.000000	1.000000	1.700000	1.000000	55
i1	21.3816	3.4500000477	75.471698	1	3180.000000	1.000000	1.700000	1.000000	53
i1	21.3672	3.4500000477	78.431373	1	3060.000000	1.000000	1.700000	1.000000	51
i1	21.3528	3.4500000477	81.632653	1	2940.000000	1.000000	1.700000	1.000000	49
i1	21.3384	3.4500000477	85.106383	1	2820.000000	1.000000	1.700000	1.000000	47
i1	21.324	3.4500000477	88.888889	1	2700.000000	1.000000	1.700000	1.000000	45
i1	21.3096	3.4500000477	93.023256	1	2580.000000	1.000000	1.700000	1.000000	43
i1	21.2952	3.4500000477	97.560976	1	2460.000000	1.000000	1.700000	1.000000	41
i1	21.2808	3.4500000477	102.564103	1	2340.000000	1.000000	1.700000	1.000000	39
i1	21.2664	3.4500000477	108.108108	1	2220.000000	1.000000	1.700000	1.000000	37
i1	21.252	3.4500000477	114.285714	1	2100.000000	1.000000	1.700000	1.000000	35
i1	21.2376	3.4500000477	121.212121	1	1980.000000	1.000000	1.700000	1.000000	33
i1	21.2232	3.4500000477	129.032258	1	1860.000000	1.000000	1.700000	1.000000	31
i1	21.2088	3.4500000477	137.931034	1	1740.000000	1.000000	1.700000	1.000000	29
i1	21.1944	3.4500000477	148.148148	1	1620.000000	1.000000	1.700000	1.000000	27
i1	21.18	3.4500000477	160.000000	1	1500.000000	1.000000	1.700000	1.000000	25
i1	21.1656	3.4500000477	173.913043	1	1380.000000	1.000000	1.700000	1.000000	23
i1	21.1512	3.4500000477	190.476190	1	1260.000000	1.000000	1.700000	1.000000	21
i1	21.1368	3.4500000477	210.526316	1	1140.000000	1.000000	1.700000	1.000000	19
i1	21.1224	3.4500000477	235.294118	1	1020.000000	1.000000	1.700000	1.000000	17
i1	21.108	3.4500000477	266.666667	1	900.000000	1.000000	1.700000	1.000000	15
i1	21.0936	3.4500000477	307.692308	1	780.000000	1.000000	1.700000	1.000000	13
i1	21.0792	3.4500000477	363.636364	1	660.000000	1.000000	1.700000	1.000000	11
i1	21.0648	3.4500000477	444.444444	1	540.000000	1.000000	1.700000	1.000000	9
i1	21.0216	3.4500000477	1333.333333	1	180.000000	1.000000	1.700000	1.000000	3
i1	21.0144	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	21.0288	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	21.0576	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	21.072	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	21.0864	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	21.1008	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	21.1152	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	21.1296	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	21.144	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	21.1584	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	21.1728	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	21.1872	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	21.2016	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	21.216	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	21.2304	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	21.2448	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	21.2592	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	21.2736	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	21.288	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	21.3024	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	21.3168	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	21.3312	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	21.3456	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	21.36	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	21.3744	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	21.3888	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	21.4032	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	21.4176	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	21.432	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	21.4464	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	21.4608	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	21.4752	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	24.0567	3.4500000477	571.428571	1	420.000000	1.000000	1.700000	1.000000	7
i1	24.0081	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	24.0162	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	24.0486	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	24.0648	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	27.603	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	27.585	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	27.567	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	27.549	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	27.531	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	27.513	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	27.495	3.4500000477	72.727273	1	3300.000000	1.000000	1.700000	1.000000	55
i1	27.477	3.4500000477	75.471698	1	3180.000000	1.000000	1.700000	1.000000	53
i1	27.459	3.4500000477	78.431373	1	3060.000000	1.000000	1.700000	1.000000	51
i1	27.441	3.4500000477	81.632653	1	2940.000000	1.000000	1.700000	1.000000	49
i1	27.423	3.4500000477	85.106383	1	2820.000000	1.000000	1.700000	1.000000	47
i1	27.405	3.4500000477	88.888889	1	2700.000000	1.000000	1.700000	1.000000	45
i1	27.387	3.4500000477	93.023256	1	2580.000000	1.000000	1.700000	1.000000	43
i1	27.369	3.4500000477	97.560976	1	2460.000000	1.000000	1.700000	1.000000	41
i1	27.351	3.4500000477	102.564103	1	2340.000000	1.000000	1.700000	1.000000	39
i1	27.333	3.4500000477	108.108108	1	2220.000000	1.000000	1.700000	1.000000	37
i1	27.315	3.4500000477	114.285714	1	2100.000000	1.000000	1.700000	1.000000	35
i1	27.297	3.4500000477	121.212121	1	1980.000000	1.000000	1.700000	1.000000	33
i1	27.279	3.4500000477	129.032258	1	1860.000000	1.000000	1.700000	1.000000	31
i1	27.261	3.4500000477	137.931034	1	1740.000000	1.000000	1.700000	1.000000	29
i1	27.243	3.4500000477	148.148148	1	1620.000000	1.000000	1.700000	1.000000	27
i1	27.225	3.4500000477	160.000000	1	1500.000000	1.000000	1.700000	1.000000	25
i1	27.207	3.4500000477	173.913043	1	1380.000000	1.000000	1.700000	1.000000	23
i1	27.189	3.4500000477	190.476190	1	1260.000000	1.000000	1.700000	1.000000	21
i1	27.171	3.4500000477	210.526316	1	1140.000000	1.000000	1.700000	1.000000	19
i1	27.153	3.4500000477	235.294118	1	1020.000000	1.000000	1.700000	1.000000	17
i1	27.135	3.4500000477	266.666667	1	900.000000	1.000000	1.700000	1.000000	15
i1	27.117	3.4500000477	307.692308	1	780.000000	1.000000	1.700000	1.000000	13
i1	27.099	3.4500000477	363.636364	1	660.000000	1.000000	1.700000	1.000000	11
i1	27.045	3.4500000477	800.000000	1	300.000000	1.000000	1.700000	1.000000	5
i1	27.009	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	27.036	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	27.054	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	27.09	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	27.108	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	27.126	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	27.144	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	27.162	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	27.18	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	27.198	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	27.216	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	27.234	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	27.252	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	27.27	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	27.288	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	27.306	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	27.324	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	27.342	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	27.36	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	27.378	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	27.396	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	27.414	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	27.432	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	27.45	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	27.468	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	27.486	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	27.504	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	27.522	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	27.54	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	27.558	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	27.576	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	27.594	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	30.0891	3.4500000477	444.444444	1	540.000000	1.000000	1.700000	1.000000	9
i1	30.0297	3.4500000477	1333.333333	1	180.000000	1.000000	1.700000	1.000000	3
i1	30.0198	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	30.0396	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	30.0792	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	30.099	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	33.7236	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	33.702	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	33.6804	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	33.6588	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	33.6372	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	33.6156	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	33.594	3.4500000477	72.727273	1	3300.000000	1.000000	1.700000	1.000000	55
i1	33.5724	3.4500000477	75.471698	1	3180.000000	1.000000	1.700000	1.000000	53
i1	33.5508	3.4500000477	78.431373	1	3060.000000	1.000000	1.700000	1.000000	51
i1	33.5292	3.4500000477	81.632653	1	2940.000000	1.000000	1.700000	1.000000	49
i1	33.5076	3.4500000477	85.106383	1	2820.000000	1.000000	1.700000	1.000000	47
i1	33.486	3.4500000477	88.888889	1	2700.000000	1.000000	1.700000	1.000000	45
i1	33.4644	3.4500000477	93.023256	1	2580.000000	1.000000	1.700000	1.000000	43
i1	33.4428	3.4500000477	97.560976	1	2460.000000	1.000000	1.700000	1.000000	41
i1	33.4212	3.4500000477	102.564103	1	2340.000000	1.000000	1.700000	1.000000	39
i1	33.3996	3.4500000477	108.108108	1	2220.000000	1.000000	1.700000	1.000000	37
i1	33.378	3.4500000477	114.285714	1	2100.000000	1.000000	1.700000	1.000000	35
i1	33.3564	3.4500000477	121.212121	1	1980.000000	1.000000	1.700000	1.000000	33
i1	33.3348	3.4500000477	129.032258	1	1860.000000	1.000000	1.700000	1.000000	31
i1	33.3132	3.4500000477	137.931034	1	1740.000000	1.000000	1.700000	1.000000	29
i1	33.2916	3.4500000477	148.148148	1	1620.000000	1.000000	1.700000	1.000000	27
i1	33.27	3.4500000477	160.000000	1	1500.000000	1.000000	1.700000	1.000000	25
i1	33.2484	3.4500000477	173.913043	1	1380.000000	1.000000	1.700000	1.000000	23
i1	33.2268	3.4500000477	190.476190	1	1260.000000	1.000000	1.700000	1.000000	21
i1	33.2052	3.4500000477	210.526316	1	1140.000000	1.000000	1.700000	1.000000	19
i1	33.1836	3.4500000477	235.294118	1	1020.000000	1.000000	1.700000	1.000000	17
i1	33.162	3.4500000477	266.666667	1	900.000000	1.000000	1.700000	1.000000	15
i1	33.1404	3.4500000477	307.692308	1	780.000000	1.000000	1.700000	1.000000	13
i1	33.0756	3.4500000477	571.428571	1	420.000000	1.000000	1.700000	1.000000	7
i1	33.0108	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	33.0216	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	33.0648	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	33.0864	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	33.1296	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	33.1512	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	33.1728	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	33.1944	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	33.216	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	33.2376	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	33.2592	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	33.2808	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	33.3024	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	33.324	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	33.3456	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	33.3672	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	33.3888	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	33.4104	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	33.432	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	33.4536	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	33.4752	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	33.4968	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	33.5184	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	33.54	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	33.5616	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	33.5832	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	33.6048	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	33.6264	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	33.648	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	33.6696	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	33.6912	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	33.7128	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	36.1287	3.4500000477	363.636364	1	660.000000	1.000000	1.700000	1.000000	11
i1	36.0585	3.4500000477	800.000000	1	300.000000	1.000000	1.700000	1.000000	5
i1	36.0117	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	36.0468	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	36.0702	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	36.117	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	36.1404	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	39.8442	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	39.819	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	39.7938	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	39.7686	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	39.7434	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	39.7182	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	39.693	3.4500000477	72.727273	1	3300.000000	1.000000	1.700000	1.000000	55
i1	39.6678	3.4500000477	75.471698	1	3180.000000	1.000000	1.700000	1.000000	53
i1	39.6426	3.4500000477	78.431373	1	3060.000000	1.000000	1.700000	1.000000	51
i1	39.6174	3.4500000477	81.632653	1	2940.000000	1.000000	1.700000	1.000000	49
i1	39.5922	3.4500000477	85.106383	1	2820.000000	1.000000	1.700000	1.000000	47
i1	39.567	3.4500000477	88.888889	1	2700.000000	1.000000	1.700000	1.000000	45
i1	39.5418	3.4500000477	93.023256	1	2580.000000	1.000000	1.700000	1.000000	43
i1	39.5166	3.4500000477	97.560976	1	2460.000000	1.000000	1.700000	1.000000	41
i1	39.4914	3.4500000477	102.564103	1	2340.000000	1.000000	1.700000	1.000000	39
i1	39.4662	3.4500000477	108.108108	1	2220.000000	1.000000	1.700000	1.000000	37
i1	39.441	3.4500000477	114.285714	1	2100.000000	1.000000	1.700000	1.000000	35
i1	39.4158	3.4500000477	121.212121	1	1980.000000	1.000000	1.700000	1.000000	33
i1	39.3906	3.4500000477	129.032258	1	1860.000000	1.000000	1.700000	1.000000	31
i1	39.3654	3.4500000477	137.931034	1	1740.000000	1.000000	1.700000	1.000000	29
i1	39.3402	3.4500000477	148.148148	1	1620.000000	1.000000	1.700000	1.000000	27
i1	39.315	3.4500000477	160.000000	1	1500.000000	1.000000	1.700000	1.000000	25
i1	39.2898	3.4500000477	173.913043	1	1380.000000	1.000000	1.700000	1.000000	23
i1	39.2646	3.4500000477	190.476190	1	1260.000000	1.000000	1.700000	1.000000	21
i1	39.2394	3.4500000477	210.526316	1	1140.000000	1.000000	1.700000	1.000000	19
i1	39.2142	3.4500000477	235.294118	1	1020.000000	1.000000	1.700000	1.000000	17
i1	39.189	3.4500000477	266.666667	1	900.000000	1.000000	1.700000	1.000000	15
i1	39.1134	3.4500000477	444.444444	1	540.000000	1.000000	1.700000	1.000000	9
i1	39.0378	3.4500000477	1333.333333	1	180.000000	1.000000	1.700000	1.000000	3
i1	39.0252	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	39.0504	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	39.1008	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	39.126	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	39.1764	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	39.2016	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	39.2268	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	39.252	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	39.2772	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	39.3024	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	39.3276	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	39.3528	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	39.378	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	39.4032	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	39.4284	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	39.4536	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	39.4788	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	39.504	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	39.5292	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	39.5544	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	39.5796	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	39.6048	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	39.63	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	39.6552	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	39.6804	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	39.7056	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	39.7308	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	39.756	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	39.7812	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	39.8064	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	39.8316	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	42.1755	3.4500000477	307.692308	1	780.000000	1.000000	1.700000	1.000000	13
i1	42.0945	3.4500000477	571.428571	1	420.000000	1.000000	1.700000	1.000000	7
i1	42.0135	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	42.027	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	42.081	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	42.108	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	42.162	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	42.189	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	45.9648	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	45.936	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	45.9072	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	45.8784	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	45.8496	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	45.8208	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	45.792	3.4500000477	72.727273	1	3300.000000	1.000000	1.700000	1.000000	55
i1	45.7632	3.4500000477	75.471698	1	3180.000000	1.000000	1.700000	1.000000	53
i1	45.7344	3.4500000477	78.431373	1	3060.000000	1.000000	1.700000	1.000000	51
i1	45.7056	3.4500000477	81.632653	1	2940.000000	1.000000	1.700000	1.000000	49
i1	45.6768	3.4500000477	85.106383	1	2820.000000	1.000000	1.700000	1.000000	47
i1	45.648	3.4500000477	88.888889	1	2700.000000	1.000000	1.700000	1.000000	45
i1	45.6192	3.4500000477	93.023256	1	2580.000000	1.000000	1.700000	1.000000	43
i1	45.5904	3.4500000477	97.560976	1	2460.000000	1.000000	1.700000	1.000000	41
i1	45.5616	3.4500000477	102.564103	1	2340.000000	1.000000	1.700000	1.000000	39
i1	45.5328	3.4500000477	108.108108	1	2220.000000	1.000000	1.700000	1.000000	37
i1	45.504	3.4500000477	114.285714	1	2100.000000	1.000000	1.700000	1.000000	35
i1	45.4752	3.4500000477	121.212121	1	1980.000000	1.000000	1.700000	1.000000	33
i1	45.4464	3.4500000477	129.032258	1	1860.000000	1.000000	1.700000	1.000000	31
i1	45.4176	3.4500000477	137.931034	1	1740.000000	1.000000	1.700000	1.000000	29
i1	45.3888	3.4500000477	148.148148	1	1620.000000	1.000000	1.700000	1.000000	27
i1	45.36	3.4500000477	160.000000	1	1500.000000	1.000000	1.700000	1.000000	25
i1	45.3312	3.4500000477	173.913043	1	1380.000000	1.000000	1.700000	1.000000	23
i1	45.3024	3.4500000477	190.476190	1	1260.000000	1.000000	1.700000	1.000000	21
i1	45.2736	3.4500000477	210.526316	1	1140.000000	1.000000	1.700000	1.000000	19
i1	45.2448	3.4500000477	235.294118	1	1020.000000	1.000000	1.700000	1.000000	17
i1	45.1584	3.4500000477	363.636364	1	660.000000	1.000000	1.700000	1.000000	11
i1	45.072	3.4500000477	800.000000	1	300.000000	1.000000	1.700000	1.000000	5
i1	45.0144	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	45.0576	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	45.0864	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	45.144	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	45.1728	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	45.2304	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	45.2592	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	45.288	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	45.3168	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	45.3456	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	45.3744	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	45.4032	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	45.432	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	45.4608	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	45.4896	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	45.5184	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	45.5472	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	45.576	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	45.6048	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	45.6336	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	45.6624	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	45.6912	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	45.72	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	45.7488	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	45.7776	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	45.8064	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	45.8352	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	45.864	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	45.8928	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	45.9216	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	45.9504	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	48.2295	3.4500000477	266.666667	1	900.000000	1.000000	1.700000	1.000000	15
i1	48.1377	3.4500000477	444.444444	1	540.000000	1.000000	1.700000	1.000000	9
i1	48.0459	3.4500000477	1333.333333	1	180.000000	1.000000	1.700000	1.000000	3
i1	48.0306	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	48.0612	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	48.1224	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	48.153	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	48.2142	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	48.2448	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	52.0854	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	52.053	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	52.0206	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	51.9882	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	51.9558	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	51.9234	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	51.891	3.4500000477	72.727273	1	3300.000000	1.000000	1.700000	1.000000	55
i1	51.8586	3.4500000477	75.471698	1	3180.000000	1.000000	1.700000	1.000000	53
i1	51.8262	3.4500000477	78.431373	1	3060.000000	1.000000	1.700000	1.000000	51
i1	51.7938	3.4500000477	81.632653	1	2940.000000	1.000000	1.700000	1.000000	49
i1	51.7614	3.4500000477	85.106383	1	2820.000000	1.000000	1.700000	1.000000	47
i1	51.729	3.4500000477	88.888889	1	2700.000000	1.000000	1.700000	1.000000	45
i1	51.6966	3.4500000477	93.023256	1	2580.000000	1.000000	1.700000	1.000000	43
i1	51.6642	3.4500000477	97.560976	1	2460.000000	1.000000	1.700000	1.000000	41
i1	51.6318	3.4500000477	102.564103	1	2340.000000	1.000000	1.700000	1.000000	39
i1	51.5994	3.4500000477	108.108108	1	2220.000000	1.000000	1.700000	1.000000	37
i1	51.567	3.4500000477	114.285714	1	2100.000000	1.000000	1.700000	1.000000	35
i1	51.5346	3.4500000477	121.212121	1	1980.000000	1.000000	1.700000	1.000000	33
i1	51.5022	3.4500000477	129.032258	1	1860.000000	1.000000	1.700000	1.000000	31
i1	51.4698	3.4500000477	137.931034	1	1740.000000	1.000000	1.700000	1.000000	29
i1	51.4374	3.4500000477	148.148148	1	1620.000000	1.000000	1.700000	1.000000	27
i1	51.405	3.4500000477	160.000000	1	1500.000000	1.000000	1.700000	1.000000	25
i1	51.3726	3.4500000477	173.913043	1	1380.000000	1.000000	1.700000	1.000000	23
i1	51.3402	3.4500000477	190.476190	1	1260.000000	1.000000	1.700000	1.000000	21
i1	51.3078	3.4500000477	210.526316	1	1140.000000	1.000000	1.700000	1.000000	19
i1	51.2106	3.4500000477	307.692308	1	780.000000	1.000000	1.700000	1.000000	13
i1	51.1134	3.4500000477	571.428571	1	420.000000	1.000000	1.700000	1.000000	7
i1	51.0162	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	51.0324	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	51.0972	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	51.1296	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	51.1944	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	51.2268	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	51.2916	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	51.324	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	51.3564	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	51.3888	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	51.4212	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	51.4536	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	51.486	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	51.5184	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	51.5508	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	51.5832	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	51.6156	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	51.648	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	51.6804	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	51.7128	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	51.7452	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	51.7776	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	51.81	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	51.8424	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	51.8748	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	51.9072	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	51.9396	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	51.972	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	52.0044	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	52.0368	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	52.0692	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	54.2907	3.4500000477	235.294118	1	1020.000000	1.000000	1.700000	1.000000	17
i1	54.1881	3.4500000477	363.636364	1	660.000000	1.000000	1.700000	1.000000	11
i1	54.0855	3.4500000477	800.000000	1	300.000000	1.000000	1.700000	1.000000	5
i1	54.0171	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	54.0684	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	54.1026	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	54.171	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	54.2052	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	54.2736	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	54.3078	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	58.206	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	58.17	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	58.134	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	58.098	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	58.062	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	58.026	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	57.99	3.4500000477	72.727273	1	3300.000000	1.000000	1.700000	1.000000	55
i1	57.954	3.4500000477	75.471698	1	3180.000000	1.000000	1.700000	1.000000	53
i1	57.918	3.4500000477	78.431373	1	3060.000000	1.000000	1.700000	1.000000	51
i1	57.882	3.4500000477	81.632653	1	2940.000000	1.000000	1.700000	1.000000	49
i1	57.846	3.4500000477	85.106383	1	2820.000000	1.000000	1.700000	1.000000	47
i1	57.81	3.4500000477	88.888889	1	2700.000000	1.000000	1.700000	1.000000	45
i1	57.774	3.4500000477	93.023256	1	2580.000000	1.000000	1.700000	1.000000	43
i1	57.738	3.4500000477	97.560976	1	2460.000000	1.000000	1.700000	1.000000	41
i1	57.702	3.4500000477	102.564103	1	2340.000000	1.000000	1.700000	1.000000	39
i1	57.666	3.4500000477	108.108108	1	2220.000000	1.000000	1.700000	1.000000	37
i1	57.63	3.4500000477	114.285714	1	2100.000000	1.000000	1.700000	1.000000	35
i1	57.594	3.4500000477	121.212121	1	1980.000000	1.000000	1.700000	1.000000	33
i1	57.558	3.4500000477	129.032258	1	1860.000000	1.000000	1.700000	1.000000	31
i1	57.522	3.4500000477	137.931034	1	1740.000000	1.000000	1.700000	1.000000	29
i1	57.486	3.4500000477	148.148148	1	1620.000000	1.000000	1.700000	1.000000	27
i1	57.45	3.4500000477	160.000000	1	1500.000000	1.000000	1.700000	1.000000	25
i1	57.414	3.4500000477	173.913043	1	1380.000000	1.000000	1.700000	1.000000	23
i1	57.378	3.4500000477	190.476190	1	1260.000000	1.000000	1.700000	1.000000	21
i1	57.27	3.4500000477	266.666667	1	900.000000	1.000000	1.700000	1.000000	15
i1	57.162	3.4500000477	444.444444	1	540.000000	1.000000	1.700000	1.000000	9
i1	57.054	3.4500000477	1333.333333	1	180.000000	1.000000	1.700000	1.000000	3
i1	57.036	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	57.072	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	57.144	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	57.18	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	57.252	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	57.288	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	57.36	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	57.396	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	57.432	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	57.468	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	57.504	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	57.54	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	57.576	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	57.612	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	57.648	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	57.684	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	57.72	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	57.756	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	57.792	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	57.828	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	57.864	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	57.9	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	57.936	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	57.972	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	58.008	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	58.044	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	58.08	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	58.116	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	58.152	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	58.188	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	60.3591	3.4500000477	210.526316	1	1140.000000	1.000000	1.700000	1.000000	19
i1	60.2457	3.4500000477	307.692308	1	780.000000	1.000000	1.700000	1.000000	13
i1	60.1323	3.4500000477	571.428571	1	420.000000	1.000000	1.700000	1.000000	7
i1	60.0189	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	60.0378	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	60.1134	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	60.1512	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	60.2268	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	60.2646	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	60.3402	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	60.378	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	64.3266	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	64.287	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	64.2474	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	64.2078	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	64.1682	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	64.1286	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	64.089	3.4500000477	72.727273	1	3300.000000	1.000000	1.700000	1.000000	55
i1	64.0494	3.4500000477	75.471698	1	3180.000000	1.000000	1.700000	1.000000	53
i1	64.0098	3.4500000477	78.431373	1	3060.000000	1.000000	1.700000	1.000000	51
i1	63.9702	3.4500000477	81.632653	1	2940.000000	1.000000	1.700000	1.000000	49
i1	63.9306	3.4500000477	85.106383	1	2820.000000	1.000000	1.700000	1.000000	47
i1	63.891	3.4500000477	88.888889	1	2700.000000	1.000000	1.700000	1.000000	45
i1	63.8514	3.4500000477	93.023256	1	2580.000000	1.000000	1.700000	1.000000	43
i1	63.8118	3.4500000477	97.560976	1	2460.000000	1.000000	1.700000	1.000000	41
i1	63.7722	3.4500000477	102.564103	1	2340.000000	1.000000	1.700000	1.000000	39
i1	63.7326	3.4500000477	108.108108	1	2220.000000	1.000000	1.700000	1.000000	37
i1	63.693	3.4500000477	114.285714	1	2100.000000	1.000000	1.700000	1.000000	35
i1	63.6534	3.4500000477	121.212121	1	1980.000000	1.000000	1.700000	1.000000	33
i1	63.6138	3.4500000477	129.032258	1	1860.000000	1.000000	1.700000	1.000000	31
i1	63.5742	3.4500000477	137.931034	1	1740.000000	1.000000	1.700000	1.000000	29
i1	63.5346	3.4500000477	148.148148	1	1620.000000	1.000000	1.700000	1.000000	27
i1	63.495	3.4500000477	160.000000	1	1500.000000	1.000000	1.700000	1.000000	25
i1	63.4554	3.4500000477	173.913043	1	1380.000000	1.000000	1.700000	1.000000	23
i1	63.3366	3.4500000477	235.294118	1	1020.000000	1.000000	1.700000	1.000000	17
i1	63.2178	3.4500000477	363.636364	1	660.000000	1.000000	1.700000	1.000000	11
i1	63.099	3.4500000477	800.000000	1	300.000000	1.000000	1.700000	1.000000	5
i1	63.0198	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	63.0792	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	63.1188	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	63.198	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	63.2376	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	63.3168	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	63.3564	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	63.4356	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	63.4752	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	63.5148	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	63.5544	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	63.594	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	63.6336	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	63.6732	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	63.7128	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	63.7524	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	63.792	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	63.8316	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	63.8712	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	63.9108	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	63.9504	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	63.99	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	64.0296	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	64.0692	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	64.1088	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	64.1484	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	64.188	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	64.2276	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	64.2672	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	64.3068	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	66.4347	3.4500000477	190.476190	1	1260.000000	1.000000	1.700000	1.000000	21
i1	66.3105	3.4500000477	266.666667	1	900.000000	1.000000	1.700000	1.000000	15
i1	66.1863	3.4500000477	444.444444	1	540.000000	1.000000	1.700000	1.000000	9
i1	66.0621	3.4500000477	1333.333333	1	180.000000	1.000000	1.700000	1.000000	3
i1	66.0414	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	66.0828	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	66.1656	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	66.207	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	66.2898	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	66.3312	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	66.414	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	66.4554	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	70.4472	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	70.404	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	70.3608	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	70.3176	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	70.2744	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	70.2312	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	70.188	3.4500000477	72.727273	1	3300.000000	1.000000	1.700000	1.000000	55
i1	70.1448	3.4500000477	75.471698	1	3180.000000	1.000000	1.700000	1.000000	53
i1	70.1016	3.4500000477	78.431373	1	3060.000000	1.000000	1.700000	1.000000	51
i1	70.0584	3.4500000477	81.632653	1	2940.000000	1.000000	1.700000	1.000000	49
i1	70.0152	3.4500000477	85.106383	1	2820.000000	1.000000	1.700000	1.000000	47
i1	69.972	3.4500000477	88.888889	1	2700.000000	1.000000	1.700000	1.000000	45
i1	69.9288	3.4500000477	93.023256	1	2580.000000	1.000000	1.700000	1.000000	43
i1	69.8856	3.4500000477	97.560976	1	2460.000000	1.000000	1.700000	1.000000	41
i1	69.8424	3.4500000477	102.564103	1	2340.000000	1.000000	1.700000	1.000000	39
i1	69.7992	3.4500000477	108.108108	1	2220.000000	1.000000	1.700000	1.000000	37
i1	69.756	3.4500000477	114.285714	1	2100.000000	1.000000	1.700000	1.000000	35
i1	69.7128	3.4500000477	121.212121	1	1980.000000	1.000000	1.700000	1.000000	33
i1	69.6696	3.4500000477	129.032258	1	1860.000000	1.000000	1.700000	1.000000	31
i1	69.6264	3.4500000477	137.931034	1	1740.000000	1.000000	1.700000	1.000000	29
i1	69.5832	3.4500000477	148.148148	1	1620.000000	1.000000	1.700000	1.000000	27
i1	69.54	3.4500000477	160.000000	1	1500.000000	1.000000	1.700000	1.000000	25
i1	69.4104	3.4500000477	210.526316	1	1140.000000	1.000000	1.700000	1.000000	19
i1	69.2808	3.4500000477	307.692308	1	780.000000	1.000000	1.700000	1.000000	13
i1	69.1512	3.4500000477	571.428571	1	420.000000	1.000000	1.700000	1.000000	7
i1	69.0216	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	69.0432	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	69.1296	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	69.1728	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	69.2592	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	69.3024	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	69.3888	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	69.432	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	69.5184	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	69.5616	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	69.6048	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	69.648	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	69.6912	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	69.7344	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	69.7776	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	69.8208	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	69.864	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	69.9072	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	69.9504	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	69.9936	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	70.0368	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	70.08	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	70.1232	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	70.1664	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	70.2096	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	70.2528	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	70.296	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	70.3392	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	70.3824	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	70.4256	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	72.5175	3.4500000477	173.913043	1	1380.000000	1.000000	1.700000	1.000000	23
i1	72.3825	3.4500000477	235.294118	1	1020.000000	1.000000	1.700000	1.000000	17
i1	72.2475	3.4500000477	363.636364	1	660.000000	1.000000	1.700000	1.000000	11
i1	72.1125	3.4500000477	800.000000	1	300.000000	1.000000	1.700000	1.000000	5
i1	72.0225	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	72.09	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	72.135	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	72.225	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	72.27	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	72.36	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	72.405	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	72.495	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	72.54	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	76.5678	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	76.521	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	76.4742	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	76.4274	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	76.3806	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	76.3338	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	76.287	3.4500000477	72.727273	1	3300.000000	1.000000	1.700000	1.000000	55
i1	76.2402	3.4500000477	75.471698	1	3180.000000	1.000000	1.700000	1.000000	53
i1	76.1934	3.4500000477	78.431373	1	3060.000000	1.000000	1.700000	1.000000	51
i1	76.1466	3.4500000477	81.632653	1	2940.000000	1.000000	1.700000	1.000000	49
i1	76.0998	3.4500000477	85.106383	1	2820.000000	1.000000	1.700000	1.000000	47
i1	76.053	3.4500000477	88.888889	1	2700.000000	1.000000	1.700000	1.000000	45
i1	76.0062	3.4500000477	93.023256	1	2580.000000	1.000000	1.700000	1.000000	43
i1	75.9594	3.4500000477	97.560976	1	2460.000000	1.000000	1.700000	1.000000	41
i1	75.9126	3.4500000477	102.564103	1	2340.000000	1.000000	1.700000	1.000000	39
i1	75.8658	3.4500000477	108.108108	1	2220.000000	1.000000	1.700000	1.000000	37
i1	75.819	3.4500000477	114.285714	1	2100.000000	1.000000	1.700000	1.000000	35
i1	75.7722	3.4500000477	121.212121	1	1980.000000	1.000000	1.700000	1.000000	33
i1	75.7254	3.4500000477	129.032258	1	1860.000000	1.000000	1.700000	1.000000	31
i1	75.6786	3.4500000477	137.931034	1	1740.000000	1.000000	1.700000	1.000000	29
i1	75.6318	3.4500000477	148.148148	1	1620.000000	1.000000	1.700000	1.000000	27
i1	75.4914	3.4500000477	190.476190	1	1260.000000	1.000000	1.700000	1.000000	21
i1	75.351	3.4500000477	266.666667	1	900.000000	1.000000	1.700000	1.000000	15
i1	75.2106	3.4500000477	444.444444	1	540.000000	1.000000	1.700000	1.000000	9
i1	75.0702	3.4500000477	1333.333333	1	180.000000	1.000000	1.700000	1.000000	3
i1	75.0468	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	75.0936	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	75.1872	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	75.234	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	75.3276	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	75.3744	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	75.468	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	75.5148	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	75.6084	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	75.6552	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	75.702	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	75.7488	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	75.7956	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	75.8424	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	75.8892	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	75.936	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	75.9828	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	76.0296	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	76.0764	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	76.1232	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	76.17	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	76.2168	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	76.2636	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	76.3104	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	76.3572	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	76.404	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	76.4508	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	76.4976	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	76.5444	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	78.6075	3.4500000477	160.000000	1	1500.000000	1.000000	1.700000	1.000000	25
i1	78.4617	3.4500000477	210.526316	1	1140.000000	1.000000	1.700000	1.000000	19
i1	78.3159	3.4500000477	307.692308	1	780.000000	1.000000	1.700000	1.000000	13
i1	78.1701	3.4500000477	571.428571	1	420.000000	1.000000	1.700000	1.000000	7
i1	78.0243	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	78.0486	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	78.1458	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	78.1944	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	78.2916	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	78.3402	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	78.4374	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	78.486	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	78.5832	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	78.6318	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	82.6884	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	82.638	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	82.5876	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	82.5372	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	82.4868	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	82.4364	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	82.386	3.4500000477	72.727273	1	3300.000000	1.000000	1.700000	1.000000	55
i1	82.3356	3.4500000477	75.471698	1	3180.000000	1.000000	1.700000	1.000000	53
i1	82.2852	3.4500000477	78.431373	1	3060.000000	1.000000	1.700000	1.000000	51
i1	82.2348	3.4500000477	81.632653	1	2940.000000	1.000000	1.700000	1.000000	49
i1	82.1844	3.4500000477	85.106383	1	2820.000000	1.000000	1.700000	1.000000	47
i1	82.134	3.4500000477	88.888889	1	2700.000000	1.000000	1.700000	1.000000	45
i1	82.0836	3.4500000477	93.023256	1	2580.000000	1.000000	1.700000	1.000000	43
i1	82.0332	3.4500000477	97.560976	1	2460.000000	1.000000	1.700000	1.000000	41
i1	81.9828	3.4500000477	102.564103	1	2340.000000	1.000000	1.700000	1.000000	39
i1	81.9324	3.4500000477	108.108108	1	2220.000000	1.000000	1.700000	1.000000	37
i1	81.882	3.4500000477	114.285714	1	2100.000000	1.000000	1.700000	1.000000	35
i1	81.8316	3.4500000477	121.212121	1	1980.000000	1.000000	1.700000	1.000000	33
i1	81.7812	3.4500000477	129.032258	1	1860.000000	1.000000	1.700000	1.000000	31
i1	81.7308	3.4500000477	137.931034	1	1740.000000	1.000000	1.700000	1.000000	29
i1	81.5796	3.4500000477	173.913043	1	1380.000000	1.000000	1.700000	1.000000	23
i1	81.4284	3.4500000477	235.294118	1	1020.000000	1.000000	1.700000	1.000000	17
i1	81.2772	3.4500000477	363.636364	1	660.000000	1.000000	1.700000	1.000000	11
i1	81.126	3.4500000477	800.000000	1	300.000000	1.000000	1.700000	1.000000	5
i1	81.0252	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	81.1008	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	81.1512	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	81.252	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	81.3024	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	81.4032	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	81.4536	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	81.5544	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	81.6048	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	81.7056	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	81.756	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	81.8064	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	81.8568	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	81.9072	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	81.9576	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	82.008	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	82.0584	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	82.1088	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	82.1592	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	82.2096	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	82.26	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	82.3104	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	82.3608	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	82.4112	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	82.4616	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	82.512	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	82.5624	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	82.6128	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	82.6632	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	84.7047	3.4500000477	148.148148	1	1620.000000	1.000000	1.700000	1.000000	27
i1	84.5481	3.4500000477	190.476190	1	1260.000000	1.000000	1.700000	1.000000	21
i1	84.3915	3.4500000477	266.666667	1	900.000000	1.000000	1.700000	1.000000	15
i1	84.2349	3.4500000477	444.444444	1	540.000000	1.000000	1.700000	1.000000	9
i1	84.0783	3.4500000477	1333.333333	1	180.000000	1.000000	1.700000	1.000000	3
i1	84.0522	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	84.1044	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	84.2088	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	84.261	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	84.3654	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	84.4176	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	84.522	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	84.5742	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	84.6786	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	84.7308	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	88.809	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	88.755	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	88.701	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	88.647	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	88.593	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	88.539	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	88.485	3.4500000477	72.727273	1	3300.000000	1.000000	1.700000	1.000000	55
i1	88.431	3.4500000477	75.471698	1	3180.000000	1.000000	1.700000	1.000000	53
i1	88.377	3.4500000477	78.431373	1	3060.000000	1.000000	1.700000	1.000000	51
i1	88.323	3.4500000477	81.632653	1	2940.000000	1.000000	1.700000	1.000000	49
i1	88.269	3.4500000477	85.106383	1	2820.000000	1.000000	1.700000	1.000000	47
i1	88.215	3.4500000477	88.888889	1	2700.000000	1.000000	1.700000	1.000000	45
i1	88.161	3.4500000477	93.023256	1	2580.000000	1.000000	1.700000	1.000000	43
i1	88.107	3.4500000477	97.560976	1	2460.000000	1.000000	1.700000	1.000000	41
i1	88.053	3.4500000477	102.564103	1	2340.000000	1.000000	1.700000	1.000000	39
i1	87.999	3.4500000477	108.108108	1	2220.000000	1.000000	1.700000	1.000000	37
i1	87.945	3.4500000477	114.285714	1	2100.000000	1.000000	1.700000	1.000000	35
i1	87.891	3.4500000477	121.212121	1	1980.000000	1.000000	1.700000	1.000000	33
i1	87.837	3.4500000477	129.032258	1	1860.000000	1.000000	1.700000	1.000000	31
i1	87.675	3.4500000477	160.000000	1	1500.000000	1.000000	1.700000	1.000000	25
i1	87.513	3.4500000477	210.526316	1	1140.000000	1.000000	1.700000	1.000000	19
i1	87.351	3.4500000477	307.692308	1	780.000000	1.000000	1.700000	1.000000	13
i1	87.189	3.4500000477	571.428571	1	420.000000	1.000000	1.700000	1.000000	7
i1	87.027	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	87.054	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	87.162	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	87.216	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	87.324	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	87.378	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	87.486	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	87.54	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	87.648	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	87.702	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	87.81	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	87.864	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	87.918	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	87.972	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	88.026	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	88.08	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	88.134	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	88.188	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	88.242	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	88.296	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	88.35	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	88.404	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	88.458	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	88.512	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	88.566	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	88.62	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	88.674	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	88.728	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	88.782	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	90.8091	3.4500000477	137.931034	1	1740.000000	1.000000	1.700000	1.000000	29
i1	90.6417	3.4500000477	173.913043	1	1380.000000	1.000000	1.700000	1.000000	23
i1	90.4743	3.4500000477	235.294118	1	1020.000000	1.000000	1.700000	1.000000	17
i1	90.3069	3.4500000477	363.636364	1	660.000000	1.000000	1.700000	1.000000	11
i1	90.1395	3.4500000477	800.000000	1	300.000000	1.000000	1.700000	1.000000	5
i1	90.0279	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	90.1116	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	90.1674	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	90.279	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	90.3348	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	90.4464	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	90.5022	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	90.6138	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	90.6696	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	90.7812	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	90.837	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	94.9296	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	94.872	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	94.8144	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	94.7568	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	94.6992	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	94.6416	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	94.584	3.4500000477	72.727273	1	3300.000000	1.000000	1.700000	1.000000	55
i1	94.5264	3.4500000477	75.471698	1	3180.000000	1.000000	1.700000	1.000000	53
i1	94.4688	3.4500000477	78.431373	1	3060.000000	1.000000	1.700000	1.000000	51
i1	94.4112	3.4500000477	81.632653	1	2940.000000	1.000000	1.700000	1.000000	49
i1	94.3536	3.4500000477	85.106383	1	2820.000000	1.000000	1.700000	1.000000	47
i1	94.296	3.4500000477	88.888889	1	2700.000000	1.000000	1.700000	1.000000	45
i1	94.2384	3.4500000477	93.023256	1	2580.000000	1.000000	1.700000	1.000000	43
i1	94.1808	3.4500000477	97.560976	1	2460.000000	1.000000	1.700000	1.000000	41
i1	94.1232	3.4500000477	102.564103	1	2340.000000	1.000000	1.700000	1.000000	39
i1	94.0656	3.4500000477	108.108108	1	2220.000000	1.000000	1.700000	1.000000	37
i1	94.008	3.4500000477	114.285714	1	2100.000000	1.000000	1.700000	1.000000	35
i1	93.9504	3.4500000477	121.212121	1	1980.000000	1.000000	1.700000	1.000000	33
i1	93.7776	3.4500000477	148.148148	1	1620.000000	1.000000	1.700000	1.000000	27
i1	93.6048	3.4500000477	190.476190	1	1260.000000	1.000000	1.700000	1.000000	21
i1	93.432	3.4500000477	266.666667	1	900.000000	1.000000	1.700000	1.000000	15
i1	93.2592	3.4500000477	444.444444	1	540.000000	1.000000	1.700000	1.000000	9
i1	93.0864	3.4500000477	1333.333333	1	180.000000	1.000000	1.700000	1.000000	3
i1	93.0576	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	93.1152	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	93.2304	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	93.288	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	93.4032	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	93.4608	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	93.576	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	93.6336	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	93.7488	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	93.8064	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	93.9216	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	93.9792	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	94.0368	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	94.0944	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	94.152	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	94.2096	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	94.2672	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	94.3248	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	94.3824	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	94.44	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	94.4976	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	94.5552	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	94.6128	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	94.6704	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	94.728	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	94.7856	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	94.8432	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	94.9008	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	96.9207	3.4500000477	129.032258	1	1860.000000	1.000000	1.700000	1.000000	31
i1	96.7425	3.4500000477	160.000000	1	1500.000000	1.000000	1.700000	1.000000	25
i1	96.5643	3.4500000477	210.526316	1	1140.000000	1.000000	1.700000	1.000000	19
i1	96.3861	3.4500000477	307.692308	1	780.000000	1.000000	1.700000	1.000000	13
i1	96.2079	3.4500000477	571.428571	1	420.000000	1.000000	1.700000	1.000000	7
i1	96.0297	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	96.0594	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	96.1782	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	96.2376	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	96.3564	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	96.4158	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	96.5346	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	96.594	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	96.7128	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	96.7722	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	96.891	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	96.9504	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	101.0502	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	100.989	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	100.9278	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	100.8666	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	100.8054	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	100.7442	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	100.683	3.4500000477	72.727273	1	3300.000000	1.000000	1.700000	1.000000	55
i1	100.6218	3.4500000477	75.471698	1	3180.000000	1.000000	1.700000	1.000000	53
i1	100.5606	3.4500000477	78.431373	1	3060.000000	1.000000	1.700000	1.000000	51
i1	100.4994	3.4500000477	81.632653	1	2940.000000	1.000000	1.700000	1.000000	49
i1	100.4382	3.4500000477	85.106383	1	2820.000000	1.000000	1.700000	1.000000	47
i1	100.377	3.4500000477	88.888889	1	2700.000000	1.000000	1.700000	1.000000	45
i1	100.3158	3.4500000477	93.023256	1	2580.000000	1.000000	1.700000	1.000000	43
i1	100.2546	3.4500000477	97.560976	1	2460.000000	1.000000	1.700000	1.000000	41
i1	100.1934	3.4500000477	102.564103	1	2340.000000	1.000000	1.700000	1.000000	39
i1	100.1322	3.4500000477	108.108108	1	2220.000000	1.000000	1.700000	1.000000	37
i1	100.071	3.4500000477	114.285714	1	2100.000000	1.000000	1.700000	1.000000	35
i1	99.8874	3.4500000477	137.931034	1	1740.000000	1.000000	1.700000	1.000000	29
i1	99.7038	3.4500000477	173.913043	1	1380.000000	1.000000	1.700000	1.000000	23
i1	99.5202	3.4500000477	235.294118	1	1020.000000	1.000000	1.700000	1.000000	17
i1	99.3366	3.4500000477	363.636364	1	660.000000	1.000000	1.700000	1.000000	11
i1	99.153	3.4500000477	800.000000	1	300.000000	1.000000	1.700000	1.000000	5
i1	99.0306	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	99.1224	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	99.1836	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	99.306	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	99.3672	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	99.4896	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	99.5508	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	99.6732	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	99.7344	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	99.8568	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	99.918	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	100.0404	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	100.1016	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	100.1628	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	100.224	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	100.2852	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	100.3464	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	100.4076	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	100.4688	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	100.53	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	100.5912	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	100.6524	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	100.7136	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	100.7748	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	100.836	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	100.8972	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	100.9584	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	101.0196	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	103.0395	3.4500000477	121.212121	1	1980.000000	1.000000	1.700000	1.000000	33
i1	102.8505	3.4500000477	148.148148	1	1620.000000	1.000000	1.700000	1.000000	27
i1	102.6615	3.4500000477	190.476190	1	1260.000000	1.000000	1.700000	1.000000	21
i1	102.4725	3.4500000477	266.666667	1	900.000000	1.000000	1.700000	1.000000	15
i1	102.2835	3.4500000477	444.444444	1	540.000000	1.000000	1.700000	1.000000	9
i1	102.0945	3.4500000477	1333.333333	1	180.000000	1.000000	1.700000	1.000000	3
i1	102.063	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	102.126	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	102.252	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	102.315	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	102.441	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	102.504	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	102.63	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	102.693	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	102.819	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	102.882	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	103.008	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	103.071	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	107.1708	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	107.106	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	107.0412	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	106.9764	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	106.9116	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	106.8468	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	106.782	3.4500000477	72.727273	1	3300.000000	1.000000	1.700000	1.000000	55
i1	106.7172	3.4500000477	75.471698	1	3180.000000	1.000000	1.700000	1.000000	53
i1	106.6524	3.4500000477	78.431373	1	3060.000000	1.000000	1.700000	1.000000	51
i1	106.5876	3.4500000477	81.632653	1	2940.000000	1.000000	1.700000	1.000000	49
i1	106.5228	3.4500000477	85.106383	1	2820.000000	1.000000	1.700000	1.000000	47
i1	106.458	3.4500000477	88.888889	1	2700.000000	1.000000	1.700000	1.000000	45
i1	106.3932	3.4500000477	93.023256	1	2580.000000	1.000000	1.700000	1.000000	43
i1	106.3284	3.4500000477	97.560976	1	2460.000000	1.000000	1.700000	1.000000	41
i1	106.2636	3.4500000477	102.564103	1	2340.000000	1.000000	1.700000	1.000000	39
i1	106.1988	3.4500000477	108.108108	1	2220.000000	1.000000	1.700000	1.000000	37
i1	106.0044	3.4500000477	129.032258	1	1860.000000	1.000000	1.700000	1.000000	31
i1	105.81	3.4500000477	160.000000	1	1500.000000	1.000000	1.700000	1.000000	25
i1	105.6156	3.4500000477	210.526316	1	1140.000000	1.000000	1.700000	1.000000	19
i1	105.4212	3.4500000477	307.692308	1	780.000000	1.000000	1.700000	1.000000	13
i1	105.2268	3.4500000477	571.428571	1	420.000000	1.000000	1.700000	1.000000	7
i1	105.0324	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	105.0648	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	105.1944	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	105.2592	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	105.3888	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	105.4536	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	105.5832	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	105.648	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	105.7776	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	105.8424	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	105.972	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	106.0368	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	106.1664	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	106.2312	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	106.296	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	106.3608	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	106.4256	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	106.4904	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	106.5552	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	106.62	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	106.6848	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	106.7496	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	106.8144	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	106.8792	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	106.944	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	107.0088	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	107.0736	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	107.1384	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	109.1655	3.4500000477	114.285714	1	2100.000000	1.000000	1.700000	1.000000	35
i1	108.9657	3.4500000477	137.931034	1	1740.000000	1.000000	1.700000	1.000000	29
i1	108.7659	3.4500000477	173.913043	1	1380.000000	1.000000	1.700000	1.000000	23
i1	108.5661	3.4500000477	235.294118	1	1020.000000	1.000000	1.700000	1.000000	17
i1	108.3663	3.4500000477	363.636364	1	660.000000	1.000000	1.700000	1.000000	11
i1	108.1665	3.4500000477	800.000000	1	300.000000	1.000000	1.700000	1.000000	5
i1	108.0333	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	108.1332	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	108.1998	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	108.333	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	108.3996	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	108.5328	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	108.5994	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	108.7326	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	108.7992	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	108.9324	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	108.999	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	109.1322	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	109.1988	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	113.2914	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	113.223	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	113.1546	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	113.0862	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	113.0178	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	112.9494	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	112.881	3.4500000477	72.727273	1	3300.000000	1.000000	1.700000	1.000000	55
i1	112.8126	3.4500000477	75.471698	1	3180.000000	1.000000	1.700000	1.000000	53
i1	112.7442	3.4500000477	78.431373	1	3060.000000	1.000000	1.700000	1.000000	51
i1	112.6758	3.4500000477	81.632653	1	2940.000000	1.000000	1.700000	1.000000	49
i1	112.6074	3.4500000477	85.106383	1	2820.000000	1.000000	1.700000	1.000000	47
i1	112.539	3.4500000477	88.888889	1	2700.000000	1.000000	1.700000	1.000000	45
i1	112.4706	3.4500000477	93.023256	1	2580.000000	1.000000	1.700000	1.000000	43
i1	112.4022	3.4500000477	97.560976	1	2460.000000	1.000000	1.700000	1.000000	41
i1	112.3338	3.4500000477	102.564103	1	2340.000000	1.000000	1.700000	1.000000	39
i1	112.1286	3.4500000477	121.212121	1	1980.000000	1.000000	1.700000	1.000000	33
i1	111.9234	3.4500000477	148.148148	1	1620.000000	1.000000	1.700000	1.000000	27
i1	111.7182	3.4500000477	190.476190	1	1260.000000	1.000000	1.700000	1.000000	21
i1	111.513	3.4500000477	266.666667	1	900.000000	1.000000	1.700000	1.000000	15
i1	111.3078	3.4500000477	444.444444	1	540.000000	1.000000	1.700000	1.000000	9
i1	111.1026	3.4500000477	1333.333333	1	180.000000	1.000000	1.700000	1.000000	3
i1	111.0684	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	111.1368	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	111.2736	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	111.342	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	111.4788	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	111.5472	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	111.684	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	111.7524	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	111.8892	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	111.9576	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	112.0944	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	112.1628	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	112.2996	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	112.368	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	112.4364	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	112.5048	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	112.5732	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	112.6416	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	112.71	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	112.7784	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	112.8468	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	112.9152	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	112.9836	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	113.052	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	113.1204	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	113.1888	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	113.2572	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	115.2987	3.4500000477	108.108108	1	2220.000000	1.000000	1.700000	1.000000	37
i1	115.0881	3.4500000477	129.032258	1	1860.000000	1.000000	1.700000	1.000000	31
i1	114.8775	3.4500000477	160.000000	1	1500.000000	1.000000	1.700000	1.000000	25
i1	114.6669	3.4500000477	210.526316	1	1140.000000	1.000000	1.700000	1.000000	19
i1	114.4563	3.4500000477	307.692308	1	780.000000	1.000000	1.700000	1.000000	13
i1	114.2457	3.4500000477	571.428571	1	420.000000	1.000000	1.700000	1.000000	7
i1	114.0351	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	114.0702	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	114.2106	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	114.2808	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	114.4212	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	114.4914	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	114.6318	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	114.702	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	114.8424	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	114.9126	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	115.053	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	115.1232	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	115.2636	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	115.3338	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	119.412	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	119.34	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	119.268	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	119.196	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	119.124	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	119.052	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	118.98	3.4500000477	72.727273	1	3300.000000	1.000000	1.700000	1.000000	55
i1	118.908	3.4500000477	75.471698	1	3180.000000	1.000000	1.700000	1.000000	53
i1	118.836	3.4500000477	78.431373	1	3060.000000	1.000000	1.700000	1.000000	51
i1	118.764	3.4500000477	81.632653	1	2940.000000	1.000000	1.700000	1.000000	49
i1	118.692	3.4500000477	85.106383	1	2820.000000	1.000000	1.700000	1.000000	47
i1	118.62	3.4500000477	88.888889	1	2700.000000	1.000000	1.700000	1.000000	45
i1	118.548	3.4500000477	93.023256	1	2580.000000	1.000000	1.700000	1.000000	43
i1	118.476	3.4500000477	97.560976	1	2460.000000	1.000000	1.700000	1.000000	41
i1	118.26	3.4500000477	114.285714	1	2100.000000	1.000000	1.700000	1.000000	35
i1	118.044	3.4500000477	137.931034	1	1740.000000	1.000000	1.700000	1.000000	29
i1	117.828	3.4500000477	173.913043	1	1380.000000	1.000000	1.700000	1.000000	23
i1	117.612	3.4500000477	235.294118	1	1020.000000	1.000000	1.700000	1.000000	17
i1	117.396	3.4500000477	363.636364	1	660.000000	1.000000	1.700000	1.000000	11
i1	117.18	3.4500000477	800.000000	1	300.000000	1.000000	1.700000	1.000000	5
i1	117.036	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	117.144	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	117.216	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	117.36	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	117.432	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	117.576	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	117.648	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	117.792	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	117.864	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	118.008	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	118.08	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	118.224	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	118.296	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	118.44	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	118.512	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	118.584	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	118.656	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	118.728	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	118.8	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	118.872	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	118.944	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	119.016	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	119.088	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	119.16	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	119.232	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	119.304	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	119.376	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	121.4391	3.4500000477	102.564103	1	2340.000000	1.000000	1.700000	1.000000	39
i1	121.2177	3.4500000477	121.212121	1	1980.000000	1.000000	1.700000	1.000000	33
i1	120.9963	3.4500000477	148.148148	1	1620.000000	1.000000	1.700000	1.000000	27
i1	120.7749	3.4500000477	190.476190	1	1260.000000	1.000000	1.700000	1.000000	21
i1	120.5535	3.4500000477	266.666667	1	900.000000	1.000000	1.700000	1.000000	15
i1	120.3321	3.4500000477	444.444444	1	540.000000	1.000000	1.700000	1.000000	9
i1	120.1107	3.4500000477	1333.333333	1	180.000000	1.000000	1.700000	1.000000	3
i1	120.0738	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	120.1476	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	120.2952	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	120.369	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	120.5166	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	120.5904	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	120.738	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	120.8118	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	120.9594	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	121.0332	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	121.1808	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	121.2546	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	121.4022	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	121.476	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	125.5326	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	125.457	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	125.3814	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	125.3058	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	125.2302	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	125.1546	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	125.079	3.4500000477	72.727273	1	3300.000000	1.000000	1.700000	1.000000	55
i1	125.0034	3.4500000477	75.471698	1	3180.000000	1.000000	1.700000	1.000000	53
i1	124.9278	3.4500000477	78.431373	1	3060.000000	1.000000	1.700000	1.000000	51
i1	124.8522	3.4500000477	81.632653	1	2940.000000	1.000000	1.700000	1.000000	49
i1	124.7766	3.4500000477	85.106383	1	2820.000000	1.000000	1.700000	1.000000	47
i1	124.701	3.4500000477	88.888889	1	2700.000000	1.000000	1.700000	1.000000	45
i1	124.6254	3.4500000477	93.023256	1	2580.000000	1.000000	1.700000	1.000000	43
i1	124.3986	3.4500000477	108.108108	1	2220.000000	1.000000	1.700000	1.000000	37
i1	124.1718	3.4500000477	129.032258	1	1860.000000	1.000000	1.700000	1.000000	31
i1	123.945	3.4500000477	160.000000	1	1500.000000	1.000000	1.700000	1.000000	25
i1	123.7182	3.4500000477	210.526316	1	1140.000000	1.000000	1.700000	1.000000	19
i1	123.4914	3.4500000477	307.692308	1	780.000000	1.000000	1.700000	1.000000	13
i1	123.2646	3.4500000477	571.428571	1	420.000000	1.000000	1.700000	1.000000	7
i1	123.0378	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	123.0756	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	123.2268	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	123.3024	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	123.4536	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	123.5292	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	123.6804	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	123.756	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	123.9072	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	123.9828	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	124.134	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	124.2096	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	124.3608	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	124.4364	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	124.5876	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	124.6632	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	124.7388	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	124.8144	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	124.89	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	124.9656	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	125.0412	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	125.1168	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	125.1924	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	125.268	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	125.3436	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	125.4192	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	125.4948	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	127.5867	3.4500000477	97.560976	1	2460.000000	1.000000	1.700000	1.000000	41
i1	127.3545	3.4500000477	114.285714	1	2100.000000	1.000000	1.700000	1.000000	35
i1	127.1223	3.4500000477	137.931034	1	1740.000000	1.000000	1.700000	1.000000	29
i1	126.8901	3.4500000477	173.913043	1	1380.000000	1.000000	1.700000	1.000000	23
i1	126.6579	3.4500000477	235.294118	1	1020.000000	1.000000	1.700000	1.000000	17
i1	126.4257	3.4500000477	363.636364	1	660.000000	1.000000	1.700000	1.000000	11
i1	126.1935	3.4500000477	800.000000	1	300.000000	1.000000	1.700000	1.000000	5
i1	126.0387	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	126.1548	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	126.2322	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	126.387	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	126.4644	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	126.6192	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	126.6966	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	126.8514	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	126.9288	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	127.0836	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	127.161	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	127.3158	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	127.3932	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	127.548	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	127.6254	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	131.6532	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	131.574	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	131.4948	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	131.4156	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	131.3364	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	131.2572	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	131.178	3.4500000477	72.727273	1	3300.000000	1.000000	1.700000	1.000000	55
i1	131.0988	3.4500000477	75.471698	1	3180.000000	1.000000	1.700000	1.000000	53
i1	131.0196	3.4500000477	78.431373	1	3060.000000	1.000000	1.700000	1.000000	51
i1	130.9404	3.4500000477	81.632653	1	2940.000000	1.000000	1.700000	1.000000	49
i1	130.8612	3.4500000477	85.106383	1	2820.000000	1.000000	1.700000	1.000000	47
i1	130.782	3.4500000477	88.888889	1	2700.000000	1.000000	1.700000	1.000000	45
i1	130.5444	3.4500000477	102.564103	1	2340.000000	1.000000	1.700000	1.000000	39
i1	130.3068	3.4500000477	121.212121	1	1980.000000	1.000000	1.700000	1.000000	33
i1	130.0692	3.4500000477	148.148148	1	1620.000000	1.000000	1.700000	1.000000	27
i1	129.8316	3.4500000477	190.476190	1	1260.000000	1.000000	1.700000	1.000000	21
i1	129.594	3.4500000477	266.666667	1	900.000000	1.000000	1.700000	1.000000	15
i1	129.3564	3.4500000477	444.444444	1	540.000000	1.000000	1.700000	1.000000	9
i1	129.1188	3.4500000477	1333.333333	1	180.000000	1.000000	1.700000	1.000000	3
i1	129.0792	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	129.1584	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	129.3168	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	129.396	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	129.5544	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	129.6336	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	129.792	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	129.8712	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	130.0296	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	130.1088	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	130.2672	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	130.3464	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	130.5048	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	130.584	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	130.7424	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	130.8216	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	130.9008	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	130.98	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	131.0592	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	131.1384	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	131.2176	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	131.2968	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	131.376	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	131.4552	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	131.5344	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	131.6136	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	133.7415	3.4500000477	93.023256	1	2580.000000	1.000000	1.700000	1.000000	43
i1	133.4985	3.4500000477	108.108108	1	2220.000000	1.000000	1.700000	1.000000	37
i1	133.2555	3.4500000477	129.032258	1	1860.000000	1.000000	1.700000	1.000000	31
i1	133.0125	3.4500000477	160.000000	1	1500.000000	1.000000	1.700000	1.000000	25
i1	132.7695	3.4500000477	210.526316	1	1140.000000	1.000000	1.700000	1.000000	19
i1	132.5265	3.4500000477	307.692308	1	780.000000	1.000000	1.700000	1.000000	13
i1	132.2835	3.4500000477	571.428571	1	420.000000	1.000000	1.700000	1.000000	7
i1	132.0405	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	132.081	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	132.243	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	132.324	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	132.486	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	132.567	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	132.729	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	132.81	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	132.972	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	133.053	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	133.215	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	133.296	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	133.458	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	133.539	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	133.701	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	133.782	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	137.7738	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	137.691	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	137.6082	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	137.5254	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	137.4426	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	137.3598	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	137.277	3.4500000477	72.727273	1	3300.000000	1.000000	1.700000	1.000000	55
i1	137.1942	3.4500000477	75.471698	1	3180.000000	1.000000	1.700000	1.000000	53
i1	137.1114	3.4500000477	78.431373	1	3060.000000	1.000000	1.700000	1.000000	51
i1	137.0286	3.4500000477	81.632653	1	2940.000000	1.000000	1.700000	1.000000	49
i1	136.9458	3.4500000477	85.106383	1	2820.000000	1.000000	1.700000	1.000000	47
i1	136.6974	3.4500000477	97.560976	1	2460.000000	1.000000	1.700000	1.000000	41
i1	136.449	3.4500000477	114.285714	1	2100.000000	1.000000	1.700000	1.000000	35
i1	136.2006	3.4500000477	137.931034	1	1740.000000	1.000000	1.700000	1.000000	29
i1	135.9522	3.4500000477	173.913043	1	1380.000000	1.000000	1.700000	1.000000	23
i1	135.7038	3.4500000477	235.294118	1	1020.000000	1.000000	1.700000	1.000000	17
i1	135.4554	3.4500000477	363.636364	1	660.000000	1.000000	1.700000	1.000000	11
i1	135.207	3.4500000477	800.000000	1	300.000000	1.000000	1.700000	1.000000	5
i1	135.0414	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	135.1656	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	135.2484	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	135.414	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	135.4968	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	135.6624	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	135.7452	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	135.9108	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	135.9936	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	136.1592	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	136.242	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	136.4076	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	136.4904	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	136.656	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	136.7388	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	136.9044	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	136.9872	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	137.07	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	137.1528	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	137.2356	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	137.3184	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	137.4012	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	137.484	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	137.5668	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	137.6496	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	137.7324	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	139.9035	3.4500000477	88.888889	1	2700.000000	1.000000	1.700000	1.000000	45
i1	139.6497	3.4500000477	102.564103	1	2340.000000	1.000000	1.700000	1.000000	39
i1	139.3959	3.4500000477	121.212121	1	1980.000000	1.000000	1.700000	1.000000	33
i1	139.1421	3.4500000477	148.148148	1	1620.000000	1.000000	1.700000	1.000000	27
i1	138.8883	3.4500000477	190.476190	1	1260.000000	1.000000	1.700000	1.000000	21
i1	138.6345	3.4500000477	266.666667	1	900.000000	1.000000	1.700000	1.000000	15
i1	138.3807	3.4500000477	444.444444	1	540.000000	1.000000	1.700000	1.000000	9
i1	138.1269	3.4500000477	1333.333333	1	180.000000	1.000000	1.700000	1.000000	3
i1	138.0846	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	138.1692	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	138.3384	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	138.423	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	138.5922	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	138.6768	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	138.846	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	138.9306	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	139.0998	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	139.1844	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	139.3536	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	139.4382	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	139.6074	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	139.692	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	139.8612	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	139.9458	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	143.8944	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	143.808	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	143.7216	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	143.6352	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	143.5488	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	143.4624	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	143.376	3.4500000477	72.727273	1	3300.000000	1.000000	1.700000	1.000000	55
i1	143.2896	3.4500000477	75.471698	1	3180.000000	1.000000	1.700000	1.000000	53
i1	143.2032	3.4500000477	78.431373	1	3060.000000	1.000000	1.700000	1.000000	51
i1	143.1168	3.4500000477	81.632653	1	2940.000000	1.000000	1.700000	1.000000	49
i1	142.8576	3.4500000477	93.023256	1	2580.000000	1.000000	1.700000	1.000000	43
i1	142.5984	3.4500000477	108.108108	1	2220.000000	1.000000	1.700000	1.000000	37
i1	142.3392	3.4500000477	129.032258	1	1860.000000	1.000000	1.700000	1.000000	31
i1	142.08	3.4500000477	160.000000	1	1500.000000	1.000000	1.700000	1.000000	25
i1	141.8208	3.4500000477	210.526316	1	1140.000000	1.000000	1.700000	1.000000	19
i1	141.5616	3.4500000477	307.692308	1	780.000000	1.000000	1.700000	1.000000	13
i1	141.3024	3.4500000477	571.428571	1	420.000000	1.000000	1.700000	1.000000	7
i1	141.0432	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	141.0864	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	141.2592	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	141.3456	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	141.5184	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	141.6048	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	141.7776	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	141.864	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	142.0368	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	142.1232	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	142.296	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	142.3824	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	142.5552	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	142.6416	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	142.8144	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	142.9008	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	143.0736	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	143.16	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	143.2464	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	143.3328	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	143.4192	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	143.5056	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	143.592	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	143.6784	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	143.7648	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	143.8512	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	146.0727	3.4500000477	85.106383	1	2820.000000	1.000000	1.700000	1.000000	47
i1	145.8081	3.4500000477	97.560976	1	2460.000000	1.000000	1.700000	1.000000	41
i1	145.5435	3.4500000477	114.285714	1	2100.000000	1.000000	1.700000	1.000000	35
i1	145.2789	3.4500000477	137.931034	1	1740.000000	1.000000	1.700000	1.000000	29
i1	145.0143	3.4500000477	173.913043	1	1380.000000	1.000000	1.700000	1.000000	23
i1	144.7497	3.4500000477	235.294118	1	1020.000000	1.000000	1.700000	1.000000	17
i1	144.4851	3.4500000477	363.636364	1	660.000000	1.000000	1.700000	1.000000	11
i1	144.2205	3.4500000477	800.000000	1	300.000000	1.000000	1.700000	1.000000	5
i1	144.0441	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	144.1764	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	144.2646	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	144.441	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	144.5292	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	144.7056	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	144.7938	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	144.9702	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	145.0584	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	145.2348	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	145.323	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	145.4994	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	145.5876	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	145.764	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	145.8522	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	146.0286	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	146.1168	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	150.015	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	149.925	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	149.835	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	149.745	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	149.655	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	149.565	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	149.475	3.4500000477	72.727273	1	3300.000000	1.000000	1.700000	1.000000	55
i1	149.385	3.4500000477	75.471698	1	3180.000000	1.000000	1.700000	1.000000	53
i1	149.295	3.4500000477	78.431373	1	3060.000000	1.000000	1.700000	1.000000	51
i1	149.025	3.4500000477	88.888889	1	2700.000000	1.000000	1.700000	1.000000	45
i1	148.755	3.4500000477	102.564103	1	2340.000000	1.000000	1.700000	1.000000	39
i1	148.485	3.4500000477	121.212121	1	1980.000000	1.000000	1.700000	1.000000	33
i1	148.215	3.4500000477	148.148148	1	1620.000000	1.000000	1.700000	1.000000	27
i1	147.945	3.4500000477	190.476190	1	1260.000000	1.000000	1.700000	1.000000	21
i1	147.675	3.4500000477	266.666667	1	900.000000	1.000000	1.700000	1.000000	15
i1	147.405	3.4500000477	444.444444	1	540.000000	1.000000	1.700000	1.000000	9
i1	147.135	3.4500000477	1333.333333	1	180.000000	1.000000	1.700000	1.000000	3
i1	147.09	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	147.18	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	147.36	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	147.45	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	147.63	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	147.72	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	147.9	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	147.99	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	148.17	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	148.26	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	148.44	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	148.53	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	148.71	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	148.8	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	148.98	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	149.07	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	149.25	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	149.34	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	149.43	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	149.52	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	149.61	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	149.7	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	149.79	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	149.88	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	149.97	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	152.2491	3.4500000477	81.632653	1	2940.000000	1.000000	1.700000	1.000000	49
i1	151.9737	3.4500000477	93.023256	1	2580.000000	1.000000	1.700000	1.000000	43
i1	151.6983	3.4500000477	108.108108	1	2220.000000	1.000000	1.700000	1.000000	37
i1	151.4229	3.4500000477	129.032258	1	1860.000000	1.000000	1.700000	1.000000	31
i1	151.1475	3.4500000477	160.000000	1	1500.000000	1.000000	1.700000	1.000000	25
i1	150.8721	3.4500000477	210.526316	1	1140.000000	1.000000	1.700000	1.000000	19
i1	150.5967	3.4500000477	307.692308	1	780.000000	1.000000	1.700000	1.000000	13
i1	150.3213	3.4500000477	571.428571	1	420.000000	1.000000	1.700000	1.000000	7
i1	150.0459	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	150.0918	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	150.2754	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	150.3672	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	150.5508	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	150.6426	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	150.8262	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	150.918	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	151.1016	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	151.1934	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	151.377	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	151.4688	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	151.6524	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	151.7442	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	151.9278	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	152.0196	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	152.2032	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	152.295	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	156.1356	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	156.042	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	155.9484	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	155.8548	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	155.7612	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	155.6676	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	155.574	3.4500000477	72.727273	1	3300.000000	1.000000	1.700000	1.000000	55
i1	155.4804	3.4500000477	75.471698	1	3180.000000	1.000000	1.700000	1.000000	53
i1	155.1996	3.4500000477	85.106383	1	2820.000000	1.000000	1.700000	1.000000	47
i1	154.9188	3.4500000477	97.560976	1	2460.000000	1.000000	1.700000	1.000000	41
i1	154.638	3.4500000477	114.285714	1	2100.000000	1.000000	1.700000	1.000000	35
i1	154.3572	3.4500000477	137.931034	1	1740.000000	1.000000	1.700000	1.000000	29
i1	154.0764	3.4500000477	173.913043	1	1380.000000	1.000000	1.700000	1.000000	23
i1	153.7956	3.4500000477	235.294118	1	1020.000000	1.000000	1.700000	1.000000	17
i1	153.5148	3.4500000477	363.636364	1	660.000000	1.000000	1.700000	1.000000	11
i1	153.234	3.4500000477	800.000000	1	300.000000	1.000000	1.700000	1.000000	5
i1	153.0468	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	153.1872	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	153.2808	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	153.468	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	153.5616	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	153.7488	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	153.8424	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	154.0296	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	154.1232	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	154.3104	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	154.404	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	154.5912	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	154.6848	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	154.872	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	154.9656	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	155.1528	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	155.2464	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	155.4336	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	155.5272	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	155.6208	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	155.7144	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	155.808	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	155.9016	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	155.9952	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	156.0888	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	158.4327	3.4500000477	78.431373	1	3060.000000	1.000000	1.700000	1.000000	51
i1	158.1465	3.4500000477	88.888889	1	2700.000000	1.000000	1.700000	1.000000	45
i1	157.8603	3.4500000477	102.564103	1	2340.000000	1.000000	1.700000	1.000000	39
i1	157.5741	3.4500000477	121.212121	1	1980.000000	1.000000	1.700000	1.000000	33
i1	157.2879	3.4500000477	148.148148	1	1620.000000	1.000000	1.700000	1.000000	27
i1	157.0017	3.4500000477	190.476190	1	1260.000000	1.000000	1.700000	1.000000	21
i1	156.7155	3.4500000477	266.666667	1	900.000000	1.000000	1.700000	1.000000	15
i1	156.4293	3.4500000477	444.444444	1	540.000000	1.000000	1.700000	1.000000	9
i1	156.1431	3.4500000477	1333.333333	1	180.000000	1.000000	1.700000	1.000000	3
i1	156.0954	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	156.1908	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	156.3816	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	156.477	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	156.6678	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	156.7632	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	156.954	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	157.0494	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	157.2402	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	157.3356	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	157.5264	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	157.6218	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	157.8126	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	157.908	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	158.0988	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	158.1942	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	158.385	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	158.4804	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	162.2562	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	162.159	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	162.0618	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	161.9646	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	161.8674	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	161.7702	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	161.673	3.4500000477	72.727273	1	3300.000000	1.000000	1.700000	1.000000	55
i1	161.3814	3.4500000477	81.632653	1	2940.000000	1.000000	1.700000	1.000000	49
i1	161.0898	3.4500000477	93.023256	1	2580.000000	1.000000	1.700000	1.000000	43
i1	160.7982	3.4500000477	108.108108	1	2220.000000	1.000000	1.700000	1.000000	37
i1	160.5066	3.4500000477	129.032258	1	1860.000000	1.000000	1.700000	1.000000	31
i1	160.215	3.4500000477	160.000000	1	1500.000000	1.000000	1.700000	1.000000	25
i1	159.9234	3.4500000477	210.526316	1	1140.000000	1.000000	1.700000	1.000000	19
i1	159.6318	3.4500000477	307.692308	1	780.000000	1.000000	1.700000	1.000000	13
i1	159.3402	3.4500000477	571.428571	1	420.000000	1.000000	1.700000	1.000000	7
i1	159.0486	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	159.0972	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	159.2916	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	159.3888	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	159.5832	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	159.6804	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	159.8748	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	159.972	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	160.1664	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	160.2636	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	160.458	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	160.5552	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	160.7496	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	160.8468	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	161.0412	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	161.1384	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	161.3328	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	161.43	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	161.6244	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	161.7216	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	161.8188	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	161.916	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	162.0132	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	162.1104	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	162.2076	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	164.6235	3.4500000477	75.471698	1	3180.000000	1.000000	1.700000	1.000000	53
i1	164.3265	3.4500000477	85.106383	1	2820.000000	1.000000	1.700000	1.000000	47
i1	164.0295	3.4500000477	97.560976	1	2460.000000	1.000000	1.700000	1.000000	41
i1	163.7325	3.4500000477	114.285714	1	2100.000000	1.000000	1.700000	1.000000	35
i1	163.4355	3.4500000477	137.931034	1	1740.000000	1.000000	1.700000	1.000000	29
i1	163.1385	3.4500000477	173.913043	1	1380.000000	1.000000	1.700000	1.000000	23
i1	162.8415	3.4500000477	235.294118	1	1020.000000	1.000000	1.700000	1.000000	17
i1	162.5445	3.4500000477	363.636364	1	660.000000	1.000000	1.700000	1.000000	11
i1	162.2475	3.4500000477	800.000000	1	300.000000	1.000000	1.700000	1.000000	5
i1	162.0495	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	162.198	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	162.297	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	162.495	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	162.594	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	162.792	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	162.891	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	163.089	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	163.188	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	163.386	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	163.485	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	163.683	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	163.782	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	163.98	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	164.079	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	164.277	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	164.376	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	164.574	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	164.673	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	168.3768	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	168.276	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	168.1752	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	168.0744	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	167.9736	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	167.8728	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	167.5704	3.4500000477	78.431373	1	3060.000000	1.000000	1.700000	1.000000	51
i1	167.268	3.4500000477	88.888889	1	2700.000000	1.000000	1.700000	1.000000	45
i1	166.9656	3.4500000477	102.564103	1	2340.000000	1.000000	1.700000	1.000000	39
i1	166.6632	3.4500000477	121.212121	1	1980.000000	1.000000	1.700000	1.000000	33
i1	166.3608	3.4500000477	148.148148	1	1620.000000	1.000000	1.700000	1.000000	27
i1	166.0584	3.4500000477	190.476190	1	1260.000000	1.000000	1.700000	1.000000	21
i1	165.756	3.4500000477	266.666667	1	900.000000	1.000000	1.700000	1.000000	15
i1	165.4536	3.4500000477	444.444444	1	540.000000	1.000000	1.700000	1.000000	9
i1	165.1512	3.4500000477	1333.333333	1	180.000000	1.000000	1.700000	1.000000	3
i1	165.1008	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	165.2016	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	165.4032	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	165.504	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	165.7056	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	165.8064	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	166.008	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	166.1088	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	166.3104	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	166.4112	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	166.6128	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	166.7136	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	166.9152	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	167.016	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	167.2176	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	167.3184	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	167.52	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	167.6208	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	167.8224	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	167.9232	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	168.024	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	168.1248	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	168.2256	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	168.3264	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	170.8215	3.4500000477	72.727273	1	3300.000000	1.000000	1.700000	1.000000	55
i1	170.5137	3.4500000477	81.632653	1	2940.000000	1.000000	1.700000	1.000000	49
i1	170.2059	3.4500000477	93.023256	1	2580.000000	1.000000	1.700000	1.000000	43
i1	169.8981	3.4500000477	108.108108	1	2220.000000	1.000000	1.700000	1.000000	37
i1	169.5903	3.4500000477	129.032258	1	1860.000000	1.000000	1.700000	1.000000	31
i1	169.2825	3.4500000477	160.000000	1	1500.000000	1.000000	1.700000	1.000000	25
i1	168.9747	3.4500000477	210.526316	1	1140.000000	1.000000	1.700000	1.000000	19
i1	168.6669	3.4500000477	307.692308	1	780.000000	1.000000	1.700000	1.000000	13
i1	168.3591	3.4500000477	571.428571	1	420.000000	1.000000	1.700000	1.000000	7
i1	168.0513	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	168.1026	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	168.3078	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	168.4104	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	168.6156	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	168.7182	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	168.9234	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	169.026	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	169.2312	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	169.3338	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	169.539	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	169.6416	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	169.8468	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	169.9494	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	170.1546	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	170.2572	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	170.4624	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	170.565	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	170.7702	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	170.8728	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	174.4974	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	174.393	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	174.2886	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	174.1842	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	174.0798	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	173.7666	3.4500000477	75.471698	1	3180.000000	1.000000	1.700000	1.000000	53
i1	173.4534	3.4500000477	85.106383	1	2820.000000	1.000000	1.700000	1.000000	47
i1	173.1402	3.4500000477	97.560976	1	2460.000000	1.000000	1.700000	1.000000	41
i1	172.827	3.4500000477	114.285714	1	2100.000000	1.000000	1.700000	1.000000	35
i1	172.5138	3.4500000477	137.931034	1	1740.000000	1.000000	1.700000	1.000000	29
i1	172.2006	3.4500000477	173.913043	1	1380.000000	1.000000	1.700000	1.000000	23
i1	171.8874	3.4500000477	235.294118	1	1020.000000	1.000000	1.700000	1.000000	17
i1	171.5742	3.4500000477	363.636364	1	660.000000	1.000000	1.700000	1.000000	11
i1	171.261	3.4500000477	800.000000	1	300.000000	1.000000	1.700000	1.000000	5
i1	171.0522	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	171.2088	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	171.3132	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	171.522	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	171.6264	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	171.8352	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	171.9396	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	172.1484	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	172.2528	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	172.4616	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	172.566	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	172.7748	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	172.8792	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	173.088	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	173.1924	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	173.4012	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	173.5056	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	173.7144	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	173.8188	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	174.0276	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	174.132	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	174.2364	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	174.3408	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	174.4452	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	177.0267	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	176.7081	3.4500000477	78.431373	1	3060.000000	1.000000	1.700000	1.000000	51
i1	176.3895	3.4500000477	88.888889	1	2700.000000	1.000000	1.700000	1.000000	45
i1	176.0709	3.4500000477	102.564103	1	2340.000000	1.000000	1.700000	1.000000	39
i1	175.7523	3.4500000477	121.212121	1	1980.000000	1.000000	1.700000	1.000000	33
i1	175.4337	3.4500000477	148.148148	1	1620.000000	1.000000	1.700000	1.000000	27
i1	175.1151	3.4500000477	190.476190	1	1260.000000	1.000000	1.700000	1.000000	21
i1	174.7965	3.4500000477	266.666667	1	900.000000	1.000000	1.700000	1.000000	15
i1	174.4779	3.4500000477	444.444444	1	540.000000	1.000000	1.700000	1.000000	9
i1	174.1593	3.4500000477	1333.333333	1	180.000000	1.000000	1.700000	1.000000	3
i1	174.1062	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	174.2124	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	174.4248	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	174.531	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	174.7434	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	174.8496	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	175.062	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	175.1682	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	175.3806	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	175.4868	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	175.6992	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	175.8054	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	176.0178	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	176.124	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	176.3364	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	176.4426	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	176.655	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	176.7612	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	176.9736	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	177.0798	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	180.618	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	180.51	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	180.402	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	180.294	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	179.97	3.4500000477	72.727273	1	3300.000000	1.000000	1.700000	1.000000	55
i1	179.646	3.4500000477	81.632653	1	2940.000000	1.000000	1.700000	1.000000	49
i1	179.322	3.4500000477	93.023256	1	2580.000000	1.000000	1.700000	1.000000	43
i1	178.998	3.4500000477	108.108108	1	2220.000000	1.000000	1.700000	1.000000	37
i1	178.674	3.4500000477	129.032258	1	1860.000000	1.000000	1.700000	1.000000	31
i1	178.35	3.4500000477	160.000000	1	1500.000000	1.000000	1.700000	1.000000	25
i1	178.026	3.4500000477	210.526316	1	1140.000000	1.000000	1.700000	1.000000	19
i1	177.702	3.4500000477	307.692308	1	780.000000	1.000000	1.700000	1.000000	13
i1	177.378	3.4500000477	571.428571	1	420.000000	1.000000	1.700000	1.000000	7
i1	177.054	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	177.108	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	177.324	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	177.432	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	177.648	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	177.756	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	177.972	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	178.08	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	178.296	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	178.404	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	178.62	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	178.728	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	178.944	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	179.052	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	179.268	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	179.376	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	179.592	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	179.7	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	179.916	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	180.024	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	180.24	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	180.348	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	180.456	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	180.564	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	183.2391	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	182.9097	3.4500000477	75.471698	1	3180.000000	1.000000	1.700000	1.000000	53
i1	182.5803	3.4500000477	85.106383	1	2820.000000	1.000000	1.700000	1.000000	47
i1	182.2509	3.4500000477	97.560976	1	2460.000000	1.000000	1.700000	1.000000	41
i1	181.9215	3.4500000477	114.285714	1	2100.000000	1.000000	1.700000	1.000000	35
i1	181.5921	3.4500000477	137.931034	1	1740.000000	1.000000	1.700000	1.000000	29
i1	181.2627	3.4500000477	173.913043	1	1380.000000	1.000000	1.700000	1.000000	23
i1	180.9333	3.4500000477	235.294118	1	1020.000000	1.000000	1.700000	1.000000	17
i1	180.6039	3.4500000477	363.636364	1	660.000000	1.000000	1.700000	1.000000	11
i1	180.2745	3.4500000477	800.000000	1	300.000000	1.000000	1.700000	1.000000	5
i1	180.0549	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	180.2196	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	180.3294	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	180.549	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	180.6588	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	180.8784	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	180.9882	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	181.2078	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	181.3176	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	181.5372	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	181.647	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	181.8666	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	181.9764	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	182.196	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	182.3058	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	182.5254	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	182.6352	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	182.8548	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	182.9646	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	183.1842	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	183.294	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	186.7386	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	186.627	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	186.5154	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	186.1806	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	185.8458	3.4500000477	78.431373	1	3060.000000	1.000000	1.700000	1.000000	51
i1	185.511	3.4500000477	88.888889	1	2700.000000	1.000000	1.700000	1.000000	45
i1	185.1762	3.4500000477	102.564103	1	2340.000000	1.000000	1.700000	1.000000	39
i1	184.8414	3.4500000477	121.212121	1	1980.000000	1.000000	1.700000	1.000000	33
i1	184.5066	3.4500000477	148.148148	1	1620.000000	1.000000	1.700000	1.000000	27
i1	184.1718	3.4500000477	190.476190	1	1260.000000	1.000000	1.700000	1.000000	21
i1	183.837	3.4500000477	266.666667	1	900.000000	1.000000	1.700000	1.000000	15
i1	183.5022	3.4500000477	444.444444	1	540.000000	1.000000	1.700000	1.000000	9
i1	183.1674	3.4500000477	1333.333333	1	180.000000	1.000000	1.700000	1.000000	3
i1	183.1116	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	183.2232	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	183.4464	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	183.558	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	183.7812	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	183.8928	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	184.116	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	184.2276	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	184.4508	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	184.5624	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	184.7856	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	184.8972	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	185.1204	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	185.232	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	185.4552	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	185.5668	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	185.79	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	185.9016	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	186.1248	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	186.2364	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	186.4596	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	186.5712	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	186.6828	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	189.4587	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	189.1185	3.4500000477	72.727273	1	3300.000000	1.000000	1.700000	1.000000	55
i1	188.7783	3.4500000477	81.632653	1	2940.000000	1.000000	1.700000	1.000000	49
i1	188.4381	3.4500000477	93.023256	1	2580.000000	1.000000	1.700000	1.000000	43
i1	188.0979	3.4500000477	108.108108	1	2220.000000	1.000000	1.700000	1.000000	37
i1	187.7577	3.4500000477	129.032258	1	1860.000000	1.000000	1.700000	1.000000	31
i1	187.4175	3.4500000477	160.000000	1	1500.000000	1.000000	1.700000	1.000000	25
i1	187.0773	3.4500000477	210.526316	1	1140.000000	1.000000	1.700000	1.000000	19
i1	186.7371	3.4500000477	307.692308	1	780.000000	1.000000	1.700000	1.000000	13
i1	186.3969	3.4500000477	571.428571	1	420.000000	1.000000	1.700000	1.000000	7
i1	186.0567	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	186.1134	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	186.3402	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	186.4536	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	186.6804	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	186.7938	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	187.0206	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	187.134	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	187.3608	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	187.4742	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	187.701	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	187.8144	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	188.0412	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	188.1546	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	188.3814	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	188.4948	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	188.7216	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	188.835	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	189.0618	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	189.1752	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	189.402	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	189.5154	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	192.8592	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	192.744	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	192.3984	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	192.0528	3.4500000477	75.471698	1	3180.000000	1.000000	1.700000	1.000000	53
i1	191.7072	3.4500000477	85.106383	1	2820.000000	1.000000	1.700000	1.000000	47
i1	191.3616	3.4500000477	97.560976	1	2460.000000	1.000000	1.700000	1.000000	41
i1	191.016	3.4500000477	114.285714	1	2100.000000	1.000000	1.700000	1.000000	35
i1	190.6704	3.4500000477	137.931034	1	1740.000000	1.000000	1.700000	1.000000	29
i1	190.3248	3.4500000477	173.913043	1	1380.000000	1.000000	1.700000	1.000000	23
i1	189.9792	3.4500000477	235.294118	1	1020.000000	1.000000	1.700000	1.000000	17
i1	189.6336	3.4500000477	363.636364	1	660.000000	1.000000	1.700000	1.000000	11
i1	189.288	3.4500000477	800.000000	1	300.000000	1.000000	1.700000	1.000000	5
i1	189.0576	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	189.2304	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	189.3456	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	189.576	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	189.6912	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	189.9216	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	190.0368	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	190.2672	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	190.3824	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	190.6128	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	190.728	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	190.9584	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	191.0736	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	191.304	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	191.4192	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	191.6496	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	191.7648	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	191.9952	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	192.1104	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	192.3408	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	192.456	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	192.6864	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	192.8016	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	195.6855	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	195.3345	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	194.9835	3.4500000477	78.431373	1	3060.000000	1.000000	1.700000	1.000000	51
i1	194.6325	3.4500000477	88.888889	1	2700.000000	1.000000	1.700000	1.000000	45
i1	194.2815	3.4500000477	102.564103	1	2340.000000	1.000000	1.700000	1.000000	39
i1	193.9305	3.4500000477	121.212121	1	1980.000000	1.000000	1.700000	1.000000	33
i1	193.5795	3.4500000477	148.148148	1	1620.000000	1.000000	1.700000	1.000000	27
i1	193.2285	3.4500000477	190.476190	1	1260.000000	1.000000	1.700000	1.000000	21
i1	192.8775	3.4500000477	266.666667	1	900.000000	1.000000	1.700000	1.000000	15
i1	192.5265	3.4500000477	444.444444	1	540.000000	1.000000	1.700000	1.000000	9
i1	192.1755	3.4500000477	1333.333333	1	180.000000	1.000000	1.700000	1.000000	3
i1	192.117	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	192.234	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	192.468	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	192.585	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	192.819	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	192.936	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	193.17	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	193.287	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	193.521	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	193.638	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	193.872	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	193.989	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	194.223	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	194.34	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	194.574	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	194.691	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	194.925	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	195.042	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	195.276	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	195.393	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	195.627	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	195.744	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	198.9798	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	198.6234	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	198.267	3.4500000477	72.727273	1	3300.000000	1.000000	1.700000	1.000000	55
i1	197.9106	3.4500000477	81.632653	1	2940.000000	1.000000	1.700000	1.000000	49
i1	197.5542	3.4500000477	93.023256	1	2580.000000	1.000000	1.700000	1.000000	43
i1	197.1978	3.4500000477	108.108108	1	2220.000000	1.000000	1.700000	1.000000	37
i1	196.8414	3.4500000477	129.032258	1	1860.000000	1.000000	1.700000	1.000000	31
i1	196.485	3.4500000477	160.000000	1	1500.000000	1.000000	1.700000	1.000000	25
i1	196.1286	3.4500000477	210.526316	1	1140.000000	1.000000	1.700000	1.000000	19
i1	195.7722	3.4500000477	307.692308	1	780.000000	1.000000	1.700000	1.000000	13
i1	195.4158	3.4500000477	571.428571	1	420.000000	1.000000	1.700000	1.000000	7
i1	195.0594	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	195.1188	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	195.3564	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	195.4752	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	195.7128	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	195.8316	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	196.0692	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	196.188	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	196.4256	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	196.5444	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	196.782	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	196.9008	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	197.1384	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	197.2572	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	197.4948	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	197.6136	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	197.8512	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	197.97	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	198.2076	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	198.3264	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	198.564	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	198.6828	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	198.9204	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	201.9195	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	201.5577	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	201.1959	3.4500000477	75.471698	1	3180.000000	1.000000	1.700000	1.000000	53
i1	200.8341	3.4500000477	85.106383	1	2820.000000	1.000000	1.700000	1.000000	47
i1	200.4723	3.4500000477	97.560976	1	2460.000000	1.000000	1.700000	1.000000	41
i1	200.1105	3.4500000477	114.285714	1	2100.000000	1.000000	1.700000	1.000000	35
i1	199.7487	3.4500000477	137.931034	1	1740.000000	1.000000	1.700000	1.000000	29
i1	199.3869	3.4500000477	173.913043	1	1380.000000	1.000000	1.700000	1.000000	23
i1	199.0251	3.4500000477	235.294118	1	1020.000000	1.000000	1.700000	1.000000	17
i1	198.6633	3.4500000477	363.636364	1	660.000000	1.000000	1.700000	1.000000	11
i1	198.3015	3.4500000477	800.000000	1	300.000000	1.000000	1.700000	1.000000	5
i1	198.0603	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	198.2412	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	198.3618	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	198.603	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	198.7236	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	198.9648	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	199.0854	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	199.3266	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	199.4472	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	199.6884	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	199.809	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	200.0502	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	200.1708	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	200.412	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	200.5326	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	200.7738	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	200.8944	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	201.1356	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	201.2562	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	201.4974	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	201.618	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	201.8592	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	201.9798	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	205.1004	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	204.8556	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	204.4884	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	204.1212	3.4500000477	78.431373	1	3060.000000	1.000000	1.700000	1.000000	51
i1	203.754	3.4500000477	88.888889	1	2700.000000	1.000000	1.700000	1.000000	45
i1	203.3868	3.4500000477	102.564103	1	2340.000000	1.000000	1.700000	1.000000	39
i1	203.0196	3.4500000477	121.212121	1	1980.000000	1.000000	1.700000	1.000000	33
i1	202.6524	3.4500000477	148.148148	1	1620.000000	1.000000	1.700000	1.000000	27
i1	202.2852	3.4500000477	190.476190	1	1260.000000	1.000000	1.700000	1.000000	21
i1	201.918	3.4500000477	266.666667	1	900.000000	1.000000	1.700000	1.000000	15
i1	201.5508	3.4500000477	444.444444	1	540.000000	1.000000	1.700000	1.000000	9
i1	201.1836	3.4500000477	1333.333333	1	180.000000	1.000000	1.700000	1.000000	3
i1	201.1224	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	201.2448	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	201.4896	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	201.612	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	201.8568	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	201.9792	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	202.224	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	202.3464	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	202.5912	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	202.7136	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	202.9584	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	203.0808	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	203.3256	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	203.448	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	203.6928	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	203.8152	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	204.06	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	204.1824	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	204.4272	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	204.5496	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	204.7944	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	204.9168	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	208.0365	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	207.7881	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	207.4155	3.4500000477	72.727273	1	3300.000000	1.000000	1.700000	1.000000	55
i1	207.0429	3.4500000477	81.632653	1	2940.000000	1.000000	1.700000	1.000000	49
i1	206.6703	3.4500000477	93.023256	1	2580.000000	1.000000	1.700000	1.000000	43
i1	206.2977	3.4500000477	108.108108	1	2220.000000	1.000000	1.700000	1.000000	37
i1	205.9251	3.4500000477	129.032258	1	1860.000000	1.000000	1.700000	1.000000	31
i1	205.5525	3.4500000477	160.000000	1	1500.000000	1.000000	1.700000	1.000000	25
i1	205.1799	3.4500000477	210.526316	1	1140.000000	1.000000	1.700000	1.000000	19
i1	204.8073	3.4500000477	307.692308	1	780.000000	1.000000	1.700000	1.000000	13
i1	204.4347	3.4500000477	571.428571	1	420.000000	1.000000	1.700000	1.000000	7
i1	204.0621	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	204.1242	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	204.3726	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	204.4968	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	204.7452	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	204.8694	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	205.1178	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	205.242	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	205.4904	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	205.6146	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	205.863	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	205.9872	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	206.2356	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	206.3598	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	206.6082	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	206.7324	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	206.9808	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	207.105	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	207.3534	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	207.4776	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	207.726	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	207.8502	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	208.0986	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	211.221	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	210.969	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	210.717	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	210.339	3.4500000477	75.471698	1	3180.000000	1.000000	1.700000	1.000000	53
i1	209.961	3.4500000477	85.106383	1	2820.000000	1.000000	1.700000	1.000000	47
i1	209.583	3.4500000477	97.560976	1	2460.000000	1.000000	1.700000	1.000000	41
i1	209.205	3.4500000477	114.285714	1	2100.000000	1.000000	1.700000	1.000000	35
i1	208.827	3.4500000477	137.931034	1	1740.000000	1.000000	1.700000	1.000000	29
i1	208.449	3.4500000477	173.913043	1	1380.000000	1.000000	1.700000	1.000000	23
i1	208.071	3.4500000477	235.294118	1	1020.000000	1.000000	1.700000	1.000000	17
i1	207.693	3.4500000477	363.636364	1	660.000000	1.000000	1.700000	1.000000	11
i1	207.315	3.4500000477	800.000000	1	300.000000	1.000000	1.700000	1.000000	5
i1	207.063	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	207.252	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	207.378	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	207.63	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	207.756	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	208.008	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	208.134	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	208.386	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	208.512	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	208.764	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	208.89	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	209.142	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	209.268	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	209.52	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	209.646	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	209.898	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	210.024	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	210.276	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	210.402	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	210.654	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	210.78	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	211.032	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	214.1535	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	213.8979	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	213.6423	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	213.2589	3.4500000477	78.431373	1	3060.000000	1.000000	1.700000	1.000000	51
i1	212.8755	3.4500000477	88.888889	1	2700.000000	1.000000	1.700000	1.000000	45
i1	212.4921	3.4500000477	102.564103	1	2340.000000	1.000000	1.700000	1.000000	39
i1	212.1087	3.4500000477	121.212121	1	1980.000000	1.000000	1.700000	1.000000	33
i1	211.7253	3.4500000477	148.148148	1	1620.000000	1.000000	1.700000	1.000000	27
i1	211.3419	3.4500000477	190.476190	1	1260.000000	1.000000	1.700000	1.000000	21
i1	210.9585	3.4500000477	266.666667	1	900.000000	1.000000	1.700000	1.000000	15
i1	210.5751	3.4500000477	444.444444	1	540.000000	1.000000	1.700000	1.000000	9
i1	210.1917	3.4500000477	1333.333333	1	180.000000	1.000000	1.700000	1.000000	3
i1	210.1278	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	210.2556	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	210.5112	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	210.639	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	210.8946	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	211.0224	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	211.278	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	211.4058	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	211.6614	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	211.7892	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	212.0448	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	212.1726	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	212.4282	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	212.556	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	212.8116	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	212.9394	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	213.195	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	213.3228	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	213.5784	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	213.7062	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	213.9618	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	214.2174	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	217.3416	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	217.0824	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	216.8232	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	216.564	3.4500000477	72.727273	1	3300.000000	1.000000	1.700000	1.000000	55
i1	216.1752	3.4500000477	81.632653	1	2940.000000	1.000000	1.700000	1.000000	49
i1	215.7864	3.4500000477	93.023256	1	2580.000000	1.000000	1.700000	1.000000	43
i1	215.3976	3.4500000477	108.108108	1	2220.000000	1.000000	1.700000	1.000000	37
i1	215.0088	3.4500000477	129.032258	1	1860.000000	1.000000	1.700000	1.000000	31
i1	214.62	3.4500000477	160.000000	1	1500.000000	1.000000	1.700000	1.000000	25
i1	214.2312	3.4500000477	210.526316	1	1140.000000	1.000000	1.700000	1.000000	19
i1	213.8424	3.4500000477	307.692308	1	780.000000	1.000000	1.700000	1.000000	13
i1	213.4536	3.4500000477	571.428571	1	420.000000	1.000000	1.700000	1.000000	7
i1	213.0648	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	213.1296	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	213.3888	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	213.5184	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	213.7776	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	213.9072	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	214.1664	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	214.296	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	214.5552	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	214.6848	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	214.944	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	215.0736	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	215.3328	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	215.4624	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	215.7216	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	215.8512	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	216.1104	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	216.24	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	216.4992	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	216.6288	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	216.888	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	217.1472	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	220.2705	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	220.0077	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	219.7449	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	219.4821	3.4500000477	75.471698	1	3180.000000	1.000000	1.700000	1.000000	53
i1	219.0879	3.4500000477	85.106383	1	2820.000000	1.000000	1.700000	1.000000	47
i1	218.6937	3.4500000477	97.560976	1	2460.000000	1.000000	1.700000	1.000000	41
i1	218.2995	3.4500000477	114.285714	1	2100.000000	1.000000	1.700000	1.000000	35
i1	217.9053	3.4500000477	137.931034	1	1740.000000	1.000000	1.700000	1.000000	29
i1	217.5111	3.4500000477	173.913043	1	1380.000000	1.000000	1.700000	1.000000	23
i1	217.1169	3.4500000477	235.294118	1	1020.000000	1.000000	1.700000	1.000000	17
i1	216.7227	3.4500000477	363.636364	1	660.000000	1.000000	1.700000	1.000000	11
i1	216.3285	3.4500000477	800.000000	1	300.000000	1.000000	1.700000	1.000000	5
i1	216.0657	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	216.2628	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	216.3942	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	216.657	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	216.7884	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	217.0512	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	217.1826	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	217.4454	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	217.5768	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	217.8396	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	217.971	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	218.2338	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	218.3652	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	218.628	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	218.7594	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	219.0222	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	219.1536	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	219.4164	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	219.5478	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	219.8106	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	220.0734	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	220.3362	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	223.4622	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	223.1958	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	222.9294	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	222.663	3.4500000477	72.727273	1	3300.000000	1.000000	1.700000	1.000000	55
i1	222.3966	3.4500000477	78.431373	1	3060.000000	1.000000	1.700000	1.000000	51
i1	221.997	3.4500000477	88.888889	1	2700.000000	1.000000	1.700000	1.000000	45
i1	221.5974	3.4500000477	102.564103	1	2340.000000	1.000000	1.700000	1.000000	39
i1	221.1978	3.4500000477	121.212121	1	1980.000000	1.000000	1.700000	1.000000	33
i1	220.7982	3.4500000477	148.148148	1	1620.000000	1.000000	1.700000	1.000000	27
i1	220.3986	3.4500000477	190.476190	1	1260.000000	1.000000	1.700000	1.000000	21
i1	219.999	3.4500000477	266.666667	1	900.000000	1.000000	1.700000	1.000000	15
i1	219.5994	3.4500000477	444.444444	1	540.000000	1.000000	1.700000	1.000000	9
i1	219.1998	3.4500000477	1333.333333	1	180.000000	1.000000	1.700000	1.000000	3
i1	219.1332	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	219.2664	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	219.5328	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	219.666	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	219.9324	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	220.0656	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	220.332	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	220.4652	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	220.7316	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	220.8648	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	221.1312	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	221.2644	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	221.5308	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	221.664	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	221.9304	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	222.0636	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	222.33	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	222.4632	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	222.7296	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	222.996	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	223.2624	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	226.3875	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	226.1175	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	225.8475	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	225.5775	3.4500000477	75.471698	1	3180.000000	1.000000	1.700000	1.000000	53
i1	225.3075	3.4500000477	81.632653	1	2940.000000	1.000000	1.700000	1.000000	49
i1	224.9025	3.4500000477	93.023256	1	2580.000000	1.000000	1.700000	1.000000	43
i1	224.4975	3.4500000477	108.108108	1	2220.000000	1.000000	1.700000	1.000000	37
i1	224.0925	3.4500000477	129.032258	1	1860.000000	1.000000	1.700000	1.000000	31
i1	223.6875	3.4500000477	160.000000	1	1500.000000	1.000000	1.700000	1.000000	25
i1	223.2825	3.4500000477	210.526316	1	1140.000000	1.000000	1.700000	1.000000	19
i1	222.8775	3.4500000477	307.692308	1	780.000000	1.000000	1.700000	1.000000	13
i1	222.4725	3.4500000477	571.428571	1	420.000000	1.000000	1.700000	1.000000	7
i1	222.0675	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	222.135	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	222.405	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	222.54	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	222.81	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	222.945	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	223.215	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	223.35	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	223.62	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	223.755	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	224.025	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	224.16	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	224.43	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	224.565	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	224.835	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	224.97	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	225.24	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	225.375	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	225.645	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	225.915	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	226.185	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	226.455	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	229.5828	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	229.3092	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	229.0356	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	228.762	3.4500000477	72.727273	1	3300.000000	1.000000	1.700000	1.000000	55
i1	228.4884	3.4500000477	78.431373	1	3060.000000	1.000000	1.700000	1.000000	51
i1	228.2148	3.4500000477	85.106383	1	2820.000000	1.000000	1.700000	1.000000	47
i1	227.8044	3.4500000477	97.560976	1	2460.000000	1.000000	1.700000	1.000000	41
i1	227.394	3.4500000477	114.285714	1	2100.000000	1.000000	1.700000	1.000000	35
i1	226.9836	3.4500000477	137.931034	1	1740.000000	1.000000	1.700000	1.000000	29
i1	226.5732	3.4500000477	173.913043	1	1380.000000	1.000000	1.700000	1.000000	23
i1	226.1628	3.4500000477	235.294118	1	1020.000000	1.000000	1.700000	1.000000	17
i1	225.7524	3.4500000477	363.636364	1	660.000000	1.000000	1.700000	1.000000	11
i1	225.342	3.4500000477	800.000000	1	300.000000	1.000000	1.700000	1.000000	5
i1	225.0684	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	225.2736	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	225.4104	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	225.684	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	225.8208	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	226.0944	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	226.2312	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	226.5048	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	226.6416	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	226.9152	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	227.052	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	227.3256	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	227.4624	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	227.736	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	227.8728	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	228.1464	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	228.2832	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	228.5568	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	228.8304	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	229.104	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	229.3776	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	232.5045	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	232.2273	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	231.9501	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	231.6729	3.4500000477	75.471698	1	3180.000000	1.000000	1.700000	1.000000	53
i1	231.3957	3.4500000477	81.632653	1	2940.000000	1.000000	1.700000	1.000000	49
i1	231.1185	3.4500000477	88.888889	1	2700.000000	1.000000	1.700000	1.000000	45
i1	230.7027	3.4500000477	102.564103	1	2340.000000	1.000000	1.700000	1.000000	39
i1	230.2869	3.4500000477	121.212121	1	1980.000000	1.000000	1.700000	1.000000	33
i1	229.8711	3.4500000477	148.148148	1	1620.000000	1.000000	1.700000	1.000000	27
i1	229.4553	3.4500000477	190.476190	1	1260.000000	1.000000	1.700000	1.000000	21
i1	229.0395	3.4500000477	266.666667	1	900.000000	1.000000	1.700000	1.000000	15
i1	228.6237	3.4500000477	444.444444	1	540.000000	1.000000	1.700000	1.000000	9
i1	228.2079	3.4500000477	1333.333333	1	180.000000	1.000000	1.700000	1.000000	3
i1	228.1386	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	228.2772	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	228.5544	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	228.693	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	228.9702	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	229.1088	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	229.386	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	229.5246	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	229.8018	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	229.9404	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	230.2176	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	230.3562	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	230.6334	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	230.772	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	231.0492	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	231.1878	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	231.465	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	231.7422	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	232.0194	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	232.2966	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	232.5738	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	235.7034	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	235.4226	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	235.1418	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	234.861	3.4500000477	72.727273	1	3300.000000	1.000000	1.700000	1.000000	55
i1	234.5802	3.4500000477	78.431373	1	3060.000000	1.000000	1.700000	1.000000	51
i1	234.2994	3.4500000477	85.106383	1	2820.000000	1.000000	1.700000	1.000000	47
i1	234.0186	3.4500000477	93.023256	1	2580.000000	1.000000	1.700000	1.000000	43
i1	233.5974	3.4500000477	108.108108	1	2220.000000	1.000000	1.700000	1.000000	37
i1	233.1762	3.4500000477	129.032258	1	1860.000000	1.000000	1.700000	1.000000	31
i1	232.755	3.4500000477	160.000000	1	1500.000000	1.000000	1.700000	1.000000	25
i1	232.3338	3.4500000477	210.526316	1	1140.000000	1.000000	1.700000	1.000000	19
i1	231.9126	3.4500000477	307.692308	1	780.000000	1.000000	1.700000	1.000000	13
i1	231.4914	3.4500000477	571.428571	1	420.000000	1.000000	1.700000	1.000000	7
i1	231.0702	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	231.1404	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	231.4212	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	231.5616	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	231.8424	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	231.9828	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	232.2636	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	232.404	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	232.6848	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	232.8252	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	233.106	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	233.2464	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	233.5272	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	233.6676	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	233.9484	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	234.0888	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	234.3696	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	234.6504	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	234.9312	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	235.212	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	235.4928	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	238.6215	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	238.3371	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	238.0527	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	237.7683	3.4500000477	75.471698	1	3180.000000	1.000000	1.700000	1.000000	53
i1	237.4839	3.4500000477	81.632653	1	2940.000000	1.000000	1.700000	1.000000	49
i1	237.1995	3.4500000477	88.888889	1	2700.000000	1.000000	1.700000	1.000000	45
i1	236.9151	3.4500000477	97.560976	1	2460.000000	1.000000	1.700000	1.000000	41
i1	236.4885	3.4500000477	114.285714	1	2100.000000	1.000000	1.700000	1.000000	35
i1	236.0619	3.4500000477	137.931034	1	1740.000000	1.000000	1.700000	1.000000	29
i1	235.6353	3.4500000477	173.913043	1	1380.000000	1.000000	1.700000	1.000000	23
i1	235.2087	3.4500000477	235.294118	1	1020.000000	1.000000	1.700000	1.000000	17
i1	234.7821	3.4500000477	363.636364	1	660.000000	1.000000	1.700000	1.000000	11
i1	234.3555	3.4500000477	800.000000	1	300.000000	1.000000	1.700000	1.000000	5
i1	234.0711	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	234.2844	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	234.4266	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	234.711	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	234.8532	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	235.1376	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	235.2798	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	235.5642	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	235.7064	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	235.9908	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	236.133	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	236.4174	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	236.5596	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	236.844	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	236.9862	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	237.2706	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	237.555	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	237.8394	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	238.1238	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	238.4082	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	238.6926	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	241.824	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	241.536	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	241.248	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	240.96	3.4500000477	72.727273	1	3300.000000	1.000000	1.700000	1.000000	55
i1	240.672	3.4500000477	78.431373	1	3060.000000	1.000000	1.700000	1.000000	51
i1	240.384	3.4500000477	85.106383	1	2820.000000	1.000000	1.700000	1.000000	47
i1	240.096	3.4500000477	93.023256	1	2580.000000	1.000000	1.700000	1.000000	43
i1	239.808	3.4500000477	102.564103	1	2340.000000	1.000000	1.700000	1.000000	39
i1	239.376	3.4500000477	121.212121	1	1980.000000	1.000000	1.700000	1.000000	33
i1	238.944	3.4500000477	148.148148	1	1620.000000	1.000000	1.700000	1.000000	27
i1	238.512	3.4500000477	190.476190	1	1260.000000	1.000000	1.700000	1.000000	21
i1	238.08	3.4500000477	266.666667	1	900.000000	1.000000	1.700000	1.000000	15
i1	237.648	3.4500000477	444.444444	1	540.000000	1.000000	1.700000	1.000000	9
i1	237.216	3.4500000477	1333.333333	1	180.000000	1.000000	1.700000	1.000000	3
i1	237.144	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	237.288	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	237.576	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	237.72	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	238.008	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	238.152	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	238.44	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	238.584	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	238.872	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	239.016	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	239.304	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	239.448	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	239.736	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	239.88	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	240.168	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	240.456	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	240.744	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	241.032	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	241.32	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	241.608	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	244.7385	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	244.4469	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	244.1553	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	243.8637	3.4500000477	75.471698	1	3180.000000	1.000000	1.700000	1.000000	53
i1	243.5721	3.4500000477	81.632653	1	2940.000000	1.000000	1.700000	1.000000	49
i1	243.2805	3.4500000477	88.888889	1	2700.000000	1.000000	1.700000	1.000000	45
i1	242.9889	3.4500000477	97.560976	1	2460.000000	1.000000	1.700000	1.000000	41
i1	242.6973	3.4500000477	108.108108	1	2220.000000	1.000000	1.700000	1.000000	37
i1	242.2599	3.4500000477	129.032258	1	1860.000000	1.000000	1.700000	1.000000	31
i1	241.8225	3.4500000477	160.000000	1	1500.000000	1.000000	1.700000	1.000000	25
i1	241.3851	3.4500000477	210.526316	1	1140.000000	1.000000	1.700000	1.000000	19
i1	240.9477	3.4500000477	307.692308	1	780.000000	1.000000	1.700000	1.000000	13
i1	240.5103	3.4500000477	571.428571	1	420.000000	1.000000	1.700000	1.000000	7
i1	240.0729	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	240.1458	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	240.4374	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	240.5832	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	240.8748	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	241.0206	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	241.3122	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	241.458	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	241.7496	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	241.8954	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	242.187	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	242.3328	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	242.6244	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	242.7702	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	243.0618	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	243.3534	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	243.645	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	243.9366	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	244.2282	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	244.5198	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	244.8114	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	247.9446	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	247.6494	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	247.3542	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	247.059	3.4500000477	72.727273	1	3300.000000	1.000000	1.700000	1.000000	55
i1	246.7638	3.4500000477	78.431373	1	3060.000000	1.000000	1.700000	1.000000	51
i1	246.4686	3.4500000477	85.106383	1	2820.000000	1.000000	1.700000	1.000000	47
i1	246.1734	3.4500000477	93.023256	1	2580.000000	1.000000	1.700000	1.000000	43
i1	245.8782	3.4500000477	102.564103	1	2340.000000	1.000000	1.700000	1.000000	39
i1	245.583	3.4500000477	114.285714	1	2100.000000	1.000000	1.700000	1.000000	35
i1	245.1402	3.4500000477	137.931034	1	1740.000000	1.000000	1.700000	1.000000	29
i1	244.6974	3.4500000477	173.913043	1	1380.000000	1.000000	1.700000	1.000000	23
i1	244.2546	3.4500000477	235.294118	1	1020.000000	1.000000	1.700000	1.000000	17
i1	243.8118	3.4500000477	363.636364	1	660.000000	1.000000	1.700000	1.000000	11
i1	243.369	3.4500000477	800.000000	1	300.000000	1.000000	1.700000	1.000000	5
i1	243.0738	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	243.2952	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	243.4428	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	243.738	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	243.8856	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	244.1808	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	244.3284	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	244.6236	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	244.7712	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	245.0664	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	245.214	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	245.5092	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	245.6568	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	245.952	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	246.2472	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	246.5424	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	246.8376	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	247.1328	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	247.428	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	247.7232	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	250.8555	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	250.5567	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	250.2579	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	249.9591	3.4500000477	75.471698	1	3180.000000	1.000000	1.700000	1.000000	53
i1	249.6603	3.4500000477	81.632653	1	2940.000000	1.000000	1.700000	1.000000	49
i1	249.3615	3.4500000477	88.888889	1	2700.000000	1.000000	1.700000	1.000000	45
i1	249.0627	3.4500000477	97.560976	1	2460.000000	1.000000	1.700000	1.000000	41
i1	248.7639	3.4500000477	108.108108	1	2220.000000	1.000000	1.700000	1.000000	37
i1	248.4651	3.4500000477	121.212121	1	1980.000000	1.000000	1.700000	1.000000	33
i1	248.0169	3.4500000477	148.148148	1	1620.000000	1.000000	1.700000	1.000000	27
i1	247.5687	3.4500000477	190.476190	1	1260.000000	1.000000	1.700000	1.000000	21
i1	247.1205	3.4500000477	266.666667	1	900.000000	1.000000	1.700000	1.000000	15
i1	246.6723	3.4500000477	444.444444	1	540.000000	1.000000	1.700000	1.000000	9
i1	246.2241	3.4500000477	1333.333333	1	180.000000	1.000000	1.700000	1.000000	3
i1	246.1494	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	246.2988	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	246.5976	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	246.747	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	247.0458	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	247.1952	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	247.494	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	247.6434	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	247.9422	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	248.0916	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	248.3904	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	248.5398	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	248.8386	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	249.1374	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	249.4362	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	249.735	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	250.0338	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	250.3326	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	250.6314	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	250.9302	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	254.0652	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	253.7628	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	253.4604	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	253.158	3.4500000477	72.727273	1	3300.000000	1.000000	1.700000	1.000000	55
i1	252.8556	3.4500000477	78.431373	1	3060.000000	1.000000	1.700000	1.000000	51
i1	252.5532	3.4500000477	85.106383	1	2820.000000	1.000000	1.700000	1.000000	47
i1	252.2508	3.4500000477	93.023256	1	2580.000000	1.000000	1.700000	1.000000	43
i1	251.9484	3.4500000477	102.564103	1	2340.000000	1.000000	1.700000	1.000000	39
i1	251.646	3.4500000477	114.285714	1	2100.000000	1.000000	1.700000	1.000000	35
i1	251.3436	3.4500000477	129.032258	1	1860.000000	1.000000	1.700000	1.000000	31
i1	250.89	3.4500000477	160.000000	1	1500.000000	1.000000	1.700000	1.000000	25
i1	250.4364	3.4500000477	210.526316	1	1140.000000	1.000000	1.700000	1.000000	19
i1	249.9828	3.4500000477	307.692308	1	780.000000	1.000000	1.700000	1.000000	13
i1	249.5292	3.4500000477	571.428571	1	420.000000	1.000000	1.700000	1.000000	7
i1	249.0756	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	249.1512	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	249.4536	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	249.6048	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	249.9072	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	250.0584	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	250.3608	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	250.512	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	250.8144	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	250.9656	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	251.268	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	251.4192	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	251.7216	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	252.024	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	252.3264	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	252.6288	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	252.9312	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	253.2336	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	253.536	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	253.8384	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	256.9725	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	256.6665	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	256.3605	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	256.0545	3.4500000477	75.471698	1	3180.000000	1.000000	1.700000	1.000000	53
i1	255.7485	3.4500000477	81.632653	1	2940.000000	1.000000	1.700000	1.000000	49
i1	255.4425	3.4500000477	88.888889	1	2700.000000	1.000000	1.700000	1.000000	45
i1	255.1365	3.4500000477	97.560976	1	2460.000000	1.000000	1.700000	1.000000	41
i1	254.8305	3.4500000477	108.108108	1	2220.000000	1.000000	1.700000	1.000000	37
i1	254.5245	3.4500000477	121.212121	1	1980.000000	1.000000	1.700000	1.000000	33
i1	254.2185	3.4500000477	137.931034	1	1740.000000	1.000000	1.700000	1.000000	29
i1	253.7595	3.4500000477	173.913043	1	1380.000000	1.000000	1.700000	1.000000	23
i1	253.3005	3.4500000477	235.294118	1	1020.000000	1.000000	1.700000	1.000000	17
i1	252.8415	3.4500000477	363.636364	1	660.000000	1.000000	1.700000	1.000000	11
i1	252.3825	3.4500000477	800.000000	1	300.000000	1.000000	1.700000	1.000000	5
i1	252.0765	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	252.306	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	252.459	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	252.765	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	252.918	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	253.224	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	253.377	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	253.683	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	253.836	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	254.142	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	254.295	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	254.601	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	254.907	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	255.213	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	255.519	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	255.825	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	256.131	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	256.437	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	256.743	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	257.049	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	260.1858	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	259.8762	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	259.5666	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	259.257	3.4500000477	72.727273	1	3300.000000	1.000000	1.700000	1.000000	55
i1	258.9474	3.4500000477	78.431373	1	3060.000000	1.000000	1.700000	1.000000	51
i1	258.6378	3.4500000477	85.106383	1	2820.000000	1.000000	1.700000	1.000000	47
i1	258.3282	3.4500000477	93.023256	1	2580.000000	1.000000	1.700000	1.000000	43
i1	258.0186	3.4500000477	102.564103	1	2340.000000	1.000000	1.700000	1.000000	39
i1	257.709	3.4500000477	114.285714	1	2100.000000	1.000000	1.700000	1.000000	35
i1	257.3994	3.4500000477	129.032258	1	1860.000000	1.000000	1.700000	1.000000	31
i1	257.0898	3.4500000477	148.148148	1	1620.000000	1.000000	1.700000	1.000000	27
i1	256.6254	3.4500000477	190.476190	1	1260.000000	1.000000	1.700000	1.000000	21
i1	256.161	3.4500000477	266.666667	1	900.000000	1.000000	1.700000	1.000000	15
i1	255.6966	3.4500000477	444.444444	1	540.000000	1.000000	1.700000	1.000000	9
i1	255.2322	3.4500000477	1333.333333	1	180.000000	1.000000	1.700000	1.000000	3
i1	255.1548	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	255.3096	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	255.6192	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	255.774	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	256.0836	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	256.2384	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	256.548	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	256.7028	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	257.0124	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	257.1672	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	257.4768	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	257.7864	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	258.096	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	258.4056	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	258.7152	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	259.0248	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	259.3344	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	259.644	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	259.9536	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	263.0895	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	262.7763	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	262.4631	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	262.1499	3.4500000477	75.471698	1	3180.000000	1.000000	1.700000	1.000000	53
i1	261.8367	3.4500000477	81.632653	1	2940.000000	1.000000	1.700000	1.000000	49
i1	261.5235	3.4500000477	88.888889	1	2700.000000	1.000000	1.700000	1.000000	45
i1	261.2103	3.4500000477	97.560976	1	2460.000000	1.000000	1.700000	1.000000	41
i1	260.8971	3.4500000477	108.108108	1	2220.000000	1.000000	1.700000	1.000000	37
i1	260.5839	3.4500000477	121.212121	1	1980.000000	1.000000	1.700000	1.000000	33
i1	260.2707	3.4500000477	137.931034	1	1740.000000	1.000000	1.700000	1.000000	29
i1	259.9575	3.4500000477	160.000000	1	1500.000000	1.000000	1.700000	1.000000	25
i1	259.4877	3.4500000477	210.526316	1	1140.000000	1.000000	1.700000	1.000000	19
i1	259.0179	3.4500000477	307.692308	1	780.000000	1.000000	1.700000	1.000000	13
i1	258.5481	3.4500000477	571.428571	1	420.000000	1.000000	1.700000	1.000000	7
i1	258.0783	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	258.1566	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	258.4698	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	258.6264	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	258.9396	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	259.0962	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	259.4094	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	259.566	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	259.8792	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	260.0358	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	260.349	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	260.6622	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	260.9754	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	261.2886	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	261.6018	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	261.915	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	262.2282	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	262.5414	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	262.8546	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	263.1678	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	266.3064	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	265.9896	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	265.6728	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	265.356	3.4500000477	72.727273	1	3300.000000	1.000000	1.700000	1.000000	55
i1	265.0392	3.4500000477	78.431373	1	3060.000000	1.000000	1.700000	1.000000	51
i1	264.7224	3.4500000477	85.106383	1	2820.000000	1.000000	1.700000	1.000000	47
i1	264.4056	3.4500000477	93.023256	1	2580.000000	1.000000	1.700000	1.000000	43
i1	264.0888	3.4500000477	102.564103	1	2340.000000	1.000000	1.700000	1.000000	39
i1	263.772	3.4500000477	114.285714	1	2100.000000	1.000000	1.700000	1.000000	35
i1	263.4552	3.4500000477	129.032258	1	1860.000000	1.000000	1.700000	1.000000	31
i1	263.1384	3.4500000477	148.148148	1	1620.000000	1.000000	1.700000	1.000000	27
i1	262.8216	3.4500000477	173.913043	1	1380.000000	1.000000	1.700000	1.000000	23
i1	262.3464	3.4500000477	235.294118	1	1020.000000	1.000000	1.700000	1.000000	17
i1	261.8712	3.4500000477	363.636364	1	660.000000	1.000000	1.700000	1.000000	11
i1	261.396	3.4500000477	800.000000	1	300.000000	1.000000	1.700000	1.000000	5
i1	261.0792	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	261.3168	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	261.4752	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	261.792	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	261.9504	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	262.2672	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	262.4256	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	262.7424	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	262.9008	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	263.2176	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	263.5344	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	263.8512	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	264.168	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	264.4848	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	264.8016	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	265.1184	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	265.4352	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	265.752	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	266.0688	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	269.2065	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	268.8861	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	268.5657	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	268.2453	3.4500000477	75.471698	1	3180.000000	1.000000	1.700000	1.000000	53
i1	267.9249	3.4500000477	81.632653	1	2940.000000	1.000000	1.700000	1.000000	49
i1	267.6045	3.4500000477	88.888889	1	2700.000000	1.000000	1.700000	1.000000	45
i1	267.2841	3.4500000477	97.560976	1	2460.000000	1.000000	1.700000	1.000000	41
i1	266.9637	3.4500000477	108.108108	1	2220.000000	1.000000	1.700000	1.000000	37
i1	266.6433	3.4500000477	121.212121	1	1980.000000	1.000000	1.700000	1.000000	33
i1	266.3229	3.4500000477	137.931034	1	1740.000000	1.000000	1.700000	1.000000	29
i1	266.0025	3.4500000477	160.000000	1	1500.000000	1.000000	1.700000	1.000000	25
i1	265.6821	3.4500000477	190.476190	1	1260.000000	1.000000	1.700000	1.000000	21
i1	265.2015	3.4500000477	266.666667	1	900.000000	1.000000	1.700000	1.000000	15
i1	264.7209	3.4500000477	444.444444	1	540.000000	1.000000	1.700000	1.000000	9
i1	264.2403	3.4500000477	1333.333333	1	180.000000	1.000000	1.700000	1.000000	3
i1	264.1602	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	264.3204	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	264.6408	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	264.801	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	265.1214	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	265.2816	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	265.602	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	265.7622	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	266.0826	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	266.403	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	266.7234	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	267.0438	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	267.3642	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	267.6846	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	268.005	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	268.3254	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	268.6458	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	268.9662	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	269.2866	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	272.427	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	272.103	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	271.779	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	271.455	3.4500000477	72.727273	1	3300.000000	1.000000	1.700000	1.000000	55
i1	271.131	3.4500000477	78.431373	1	3060.000000	1.000000	1.700000	1.000000	51
i1	270.807	3.4500000477	85.106383	1	2820.000000	1.000000	1.700000	1.000000	47
i1	270.483	3.4500000477	93.023256	1	2580.000000	1.000000	1.700000	1.000000	43
i1	270.159	3.4500000477	102.564103	1	2340.000000	1.000000	1.700000	1.000000	39
i1	269.835	3.4500000477	114.285714	1	2100.000000	1.000000	1.700000	1.000000	35
i1	269.511	3.4500000477	129.032258	1	1860.000000	1.000000	1.700000	1.000000	31
i1	269.187	3.4500000477	148.148148	1	1620.000000	1.000000	1.700000	1.000000	27
i1	268.863	3.4500000477	173.913043	1	1380.000000	1.000000	1.700000	1.000000	23
i1	268.539	3.4500000477	210.526316	1	1140.000000	1.000000	1.700000	1.000000	19
i1	268.053	3.4500000477	307.692308	1	780.000000	1.000000	1.700000	1.000000	13
i1	267.567	3.4500000477	571.428571	1	420.000000	1.000000	1.700000	1.000000	7
i1	267.081	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	267.162	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	267.486	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	267.648	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	267.972	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	268.134	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	268.458	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	268.62	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	268.944	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	269.268	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	269.592	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	269.916	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	270.24	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	270.564	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	270.888	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	271.212	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	271.536	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	271.86	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	272.184	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	275.3235	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	274.9959	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	274.6683	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	274.3407	3.4500000477	75.471698	1	3180.000000	1.000000	1.700000	1.000000	53
i1	274.0131	3.4500000477	81.632653	1	2940.000000	1.000000	1.700000	1.000000	49
i1	273.6855	3.4500000477	88.888889	1	2700.000000	1.000000	1.700000	1.000000	45
i1	273.3579	3.4500000477	97.560976	1	2460.000000	1.000000	1.700000	1.000000	41
i1	273.0303	3.4500000477	108.108108	1	2220.000000	1.000000	1.700000	1.000000	37
i1	272.7027	3.4500000477	121.212121	1	1980.000000	1.000000	1.700000	1.000000	33
i1	272.3751	3.4500000477	137.931034	1	1740.000000	1.000000	1.700000	1.000000	29
i1	272.0475	3.4500000477	160.000000	1	1500.000000	1.000000	1.700000	1.000000	25
i1	271.7199	3.4500000477	190.476190	1	1260.000000	1.000000	1.700000	1.000000	21
i1	271.3923	3.4500000477	235.294118	1	1020.000000	1.000000	1.700000	1.000000	17
i1	270.9009	3.4500000477	363.636364	1	660.000000	1.000000	1.700000	1.000000	11
i1	270.4095	3.4500000477	800.000000	1	300.000000	1.000000	1.700000	1.000000	5
i1	270.0819	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	270.3276	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	270.4914	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	270.819	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	270.9828	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	271.3104	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	271.4742	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	271.8018	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	272.1294	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	272.457	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	272.7846	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	273.1122	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	273.4398	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	273.7674	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	274.095	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	274.4226	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	274.7502	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	275.0778	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	275.4054	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	278.5476	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	278.2164	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	277.8852	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	277.554	3.4500000477	72.727273	1	3300.000000	1.000000	1.700000	1.000000	55
i1	277.2228	3.4500000477	78.431373	1	3060.000000	1.000000	1.700000	1.000000	51
i1	276.8916	3.4500000477	85.106383	1	2820.000000	1.000000	1.700000	1.000000	47
i1	276.5604	3.4500000477	93.023256	1	2580.000000	1.000000	1.700000	1.000000	43
i1	276.2292	3.4500000477	102.564103	1	2340.000000	1.000000	1.700000	1.000000	39
i1	275.898	3.4500000477	114.285714	1	2100.000000	1.000000	1.700000	1.000000	35
i1	275.5668	3.4500000477	129.032258	1	1860.000000	1.000000	1.700000	1.000000	31
i1	275.2356	3.4500000477	148.148148	1	1620.000000	1.000000	1.700000	1.000000	27
i1	274.9044	3.4500000477	173.913043	1	1380.000000	1.000000	1.700000	1.000000	23
i1	274.5732	3.4500000477	210.526316	1	1140.000000	1.000000	1.700000	1.000000	19
i1	274.242	3.4500000477	266.666667	1	900.000000	1.000000	1.700000	1.000000	15
i1	273.7452	3.4500000477	444.444444	1	540.000000	1.000000	1.700000	1.000000	9
i1	273.2484	3.4500000477	1333.333333	1	180.000000	1.000000	1.700000	1.000000	3
i1	273.1656	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	273.3312	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	273.6624	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	273.828	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	274.1592	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	274.3248	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	274.656	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	274.9872	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	275.3184	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	275.6496	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	275.9808	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	276.312	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	276.6432	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	276.9744	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	277.3056	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	277.6368	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	277.968	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	278.2992	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	281.4405	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	281.1057	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	280.7709	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	280.4361	3.4500000477	75.471698	1	3180.000000	1.000000	1.700000	1.000000	53
i1	280.1013	3.4500000477	81.632653	1	2940.000000	1.000000	1.700000	1.000000	49
i1	279.7665	3.4500000477	88.888889	1	2700.000000	1.000000	1.700000	1.000000	45
i1	279.4317	3.4500000477	97.560976	1	2460.000000	1.000000	1.700000	1.000000	41
i1	279.0969	3.4500000477	108.108108	1	2220.000000	1.000000	1.700000	1.000000	37
i1	278.7621	3.4500000477	121.212121	1	1980.000000	1.000000	1.700000	1.000000	33
i1	278.4273	3.4500000477	137.931034	1	1740.000000	1.000000	1.700000	1.000000	29
i1	278.0925	3.4500000477	160.000000	1	1500.000000	1.000000	1.700000	1.000000	25
i1	277.7577	3.4500000477	190.476190	1	1260.000000	1.000000	1.700000	1.000000	21
i1	277.4229	3.4500000477	235.294118	1	1020.000000	1.000000	1.700000	1.000000	17
i1	277.0881	3.4500000477	307.692308	1	780.000000	1.000000	1.700000	1.000000	13
i1	276.5859	3.4500000477	571.428571	1	420.000000	1.000000	1.700000	1.000000	7
i1	276.0837	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	276.1674	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	276.5022	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	276.6696	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	277.0044	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	277.1718	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	277.5066	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	277.8414	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	278.1762	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	278.511	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	278.8458	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	279.1806	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	279.5154	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	279.8502	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	280.185	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	280.5198	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	280.8546	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	281.1894	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	281.5242	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	284.6682	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	284.3298	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	283.9914	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	283.653	3.4500000477	72.727273	1	3300.000000	1.000000	1.700000	1.000000	55
i1	283.3146	3.4500000477	78.431373	1	3060.000000	1.000000	1.700000	1.000000	51
i1	282.9762	3.4500000477	85.106383	1	2820.000000	1.000000	1.700000	1.000000	47
i1	282.6378	3.4500000477	93.023256	1	2580.000000	1.000000	1.700000	1.000000	43
i1	282.2994	3.4500000477	102.564103	1	2340.000000	1.000000	1.700000	1.000000	39
i1	281.961	3.4500000477	114.285714	1	2100.000000	1.000000	1.700000	1.000000	35
i1	281.6226	3.4500000477	129.032258	1	1860.000000	1.000000	1.700000	1.000000	31
i1	281.2842	3.4500000477	148.148148	1	1620.000000	1.000000	1.700000	1.000000	27
i1	280.9458	3.4500000477	173.913043	1	1380.000000	1.000000	1.700000	1.000000	23
i1	280.6074	3.4500000477	210.526316	1	1140.000000	1.000000	1.700000	1.000000	19
i1	280.269	3.4500000477	266.666667	1	900.000000	1.000000	1.700000	1.000000	15
i1	279.9306	3.4500000477	363.636364	1	660.000000	1.000000	1.700000	1.000000	11
i1	279.423	3.4500000477	800.000000	1	300.000000	1.000000	1.700000	1.000000	5
i1	279.0846	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	279.3384	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	279.5076	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	279.846	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	280.0152	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	280.3536	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	280.692	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	281.0304	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	281.3688	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	281.7072	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	282.0456	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	282.384	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	282.7224	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	283.0608	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	283.3992	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	283.7376	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	284.076	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	284.4144	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	287.5575	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	287.2155	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	286.8735	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	286.5315	3.4500000477	75.471698	1	3180.000000	1.000000	1.700000	1.000000	53
i1	286.1895	3.4500000477	81.632653	1	2940.000000	1.000000	1.700000	1.000000	49
i1	285.8475	3.4500000477	88.888889	1	2700.000000	1.000000	1.700000	1.000000	45
i1	285.5055	3.4500000477	97.560976	1	2460.000000	1.000000	1.700000	1.000000	41
i1	285.1635	3.4500000477	108.108108	1	2220.000000	1.000000	1.700000	1.000000	37
i1	284.8215	3.4500000477	121.212121	1	1980.000000	1.000000	1.700000	1.000000	33
i1	284.4795	3.4500000477	137.931034	1	1740.000000	1.000000	1.700000	1.000000	29
i1	284.1375	3.4500000477	160.000000	1	1500.000000	1.000000	1.700000	1.000000	25
i1	283.7955	3.4500000477	190.476190	1	1260.000000	1.000000	1.700000	1.000000	21
i1	283.4535	3.4500000477	235.294118	1	1020.000000	1.000000	1.700000	1.000000	17
i1	283.1115	3.4500000477	307.692308	1	780.000000	1.000000	1.700000	1.000000	13
i1	282.7695	3.4500000477	444.444444	1	540.000000	1.000000	1.700000	1.000000	9
i1	282.2565	3.4500000477	1333.333333	1	180.000000	1.000000	1.700000	1.000000	3
i1	282.171	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	282.342	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	282.684	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	282.855	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	283.197	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	283.539	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	283.881	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	284.223	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	284.565	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	284.907	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	285.249	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	285.591	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	285.933	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	286.275	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	286.617	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	286.959	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	287.301	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	287.643	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	290.7888	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	290.4432	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	290.0976	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	289.752	3.4500000477	72.727273	1	3300.000000	1.000000	1.700000	1.000000	55
i1	289.4064	3.4500000477	78.431373	1	3060.000000	1.000000	1.700000	1.000000	51
i1	289.0608	3.4500000477	85.106383	1	2820.000000	1.000000	1.700000	1.000000	47
i1	288.7152	3.4500000477	93.023256	1	2580.000000	1.000000	1.700000	1.000000	43
i1	288.3696	3.4500000477	102.564103	1	2340.000000	1.000000	1.700000	1.000000	39
i1	288.024	3.4500000477	114.285714	1	2100.000000	1.000000	1.700000	1.000000	35
i1	287.6784	3.4500000477	129.032258	1	1860.000000	1.000000	1.700000	1.000000	31
i1	287.3328	3.4500000477	148.148148	1	1620.000000	1.000000	1.700000	1.000000	27
i1	286.9872	3.4500000477	173.913043	1	1380.000000	1.000000	1.700000	1.000000	23
i1	286.6416	3.4500000477	210.526316	1	1140.000000	1.000000	1.700000	1.000000	19
i1	286.296	3.4500000477	266.666667	1	900.000000	1.000000	1.700000	1.000000	15
i1	285.9504	3.4500000477	363.636364	1	660.000000	1.000000	1.700000	1.000000	11
i1	285.6048	3.4500000477	571.428571	1	420.000000	1.000000	1.700000	1.000000	7
i1	285.0864	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	285.1728	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	285.5184	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	285.6912	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	286.0368	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	286.3824	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	286.728	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	287.0736	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	287.4192	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	287.7648	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	288.1104	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	288.456	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	288.8016	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	289.1472	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	289.4928	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	289.8384	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	290.184	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	290.5296	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	293.6745	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	293.3253	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	292.9761	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	292.6269	3.4500000477	75.471698	1	3180.000000	1.000000	1.700000	1.000000	53
i1	292.2777	3.4500000477	81.632653	1	2940.000000	1.000000	1.700000	1.000000	49
i1	291.9285	3.4500000477	88.888889	1	2700.000000	1.000000	1.700000	1.000000	45
i1	291.5793	3.4500000477	97.560976	1	2460.000000	1.000000	1.700000	1.000000	41
i1	291.2301	3.4500000477	108.108108	1	2220.000000	1.000000	1.700000	1.000000	37
i1	290.8809	3.4500000477	121.212121	1	1980.000000	1.000000	1.700000	1.000000	33
i1	290.5317	3.4500000477	137.931034	1	1740.000000	1.000000	1.700000	1.000000	29
i1	290.1825	3.4500000477	160.000000	1	1500.000000	1.000000	1.700000	1.000000	25
i1	289.8333	3.4500000477	190.476190	1	1260.000000	1.000000	1.700000	1.000000	21
i1	289.4841	3.4500000477	235.294118	1	1020.000000	1.000000	1.700000	1.000000	17
i1	289.1349	3.4500000477	307.692308	1	780.000000	1.000000	1.700000	1.000000	13
i1	288.7857	3.4500000477	444.444444	1	540.000000	1.000000	1.700000	1.000000	9
i1	288.4365	3.4500000477	800.000000	1	300.000000	1.000000	1.700000	1.000000	5
i1	288.0873	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	288.3492	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	288.5238	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	288.873	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	289.2222	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	289.5714	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	289.9206	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	290.2698	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	290.619	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	290.9682	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	291.3174	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	291.6666	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	292.0158	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	292.365	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	292.7142	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	293.0634	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	293.4126	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	293.7618	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	296.9094	3.4500000477	59.701493	1	4020.000000	1.000000	1.700000	1.000000	67
i1	296.5566	3.4500000477	63.492063	1	3780.000000	1.000000	1.700000	1.000000	63
i1	296.2038	3.4500000477	67.796610	1	3540.000000	1.000000	1.700000	1.000000	59
i1	295.851	3.4500000477	72.727273	1	3300.000000	1.000000	1.700000	1.000000	55
i1	295.4982	3.4500000477	78.431373	1	3060.000000	1.000000	1.700000	1.000000	51
i1	295.1454	3.4500000477	85.106383	1	2820.000000	1.000000	1.700000	1.000000	47
i1	294.7926	3.4500000477	93.023256	1	2580.000000	1.000000	1.700000	1.000000	43
i1	294.4398	3.4500000477	102.564103	1	2340.000000	1.000000	1.700000	1.000000	39
i1	294.087	3.4500000477	114.285714	1	2100.000000	1.000000	1.700000	1.000000	35
i1	293.7342	3.4500000477	129.032258	1	1860.000000	1.000000	1.700000	1.000000	31
i1	293.3814	3.4500000477	148.148148	1	1620.000000	1.000000	1.700000	1.000000	27
i1	293.0286	3.4500000477	173.913043	1	1380.000000	1.000000	1.700000	1.000000	23
i1	292.6758	3.4500000477	210.526316	1	1140.000000	1.000000	1.700000	1.000000	19
i1	292.323	3.4500000477	266.666667	1	900.000000	1.000000	1.700000	1.000000	15
i1	291.9702	3.4500000477	363.636364	1	660.000000	1.000000	1.700000	1.000000	11
i1	291.6174	3.4500000477	571.428571	1	420.000000	1.000000	1.700000	1.000000	7
i1	291.2646	3.4500000477	1333.333333	1	180.000000	1.000000	1.700000	1.000000	3
i1	291.1764	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	291.3528	3.4500000477	1000.000000	1	240.000000	1.000000	1.700000	1.000000	4
i1	291.7056	3.4500000477	500.000000	1	480.000000	1.000000	1.700000	1.000000	8
i1	292.0584	3.4500000477	333.333333	1	720.000000	1.000000	1.700000	1.000000	12
i1	292.4112	3.4500000477	250.000000	1	960.000000	1.000000	1.700000	1.000000	16
i1	292.764	3.4500000477	200.000000	1	1200.000000	1.000000	1.700000	1.000000	20
i1	293.1168	3.4500000477	166.666667	1	1440.000000	1.000000	1.700000	1.000000	24
i1	293.4696	3.4500000477	142.857143	1	1680.000000	1.000000	1.700000	1.000000	28
i1	293.8224	3.4500000477	125.000000	1	1920.000000	1.000000	1.700000	1.000000	32
i1	294.1752	3.4500000477	111.111111	1	2160.000000	1.000000	1.700000	1.000000	36
i1	294.528	3.4500000477	100.000000	1	2400.000000	1.000000	1.700000	1.000000	40
i1	294.8808	3.4500000477	90.909091	1	2640.000000	1.000000	1.700000	1.000000	44
i1	295.2336	3.4500000477	83.333333	1	2880.000000	1.000000	1.700000	1.000000	48
i1	295.5864	3.4500000477	76.923077	1	3120.000000	1.000000	1.700000	1.000000	52
i1	295.9392	3.4500000477	71.428571	1	3360.000000	1.000000	1.700000	1.000000	56
i1	296.292	3.4500000477	66.666667	1	3600.000000	1.000000	1.700000	1.000000	60
i1	296.6448	3.4500000477	62.500000	1	3840.000000	1.000000	1.700000	1.000000	64
i1	299.7915	3.4500000477	61.538462	1	3900.000000	1.000000	1.700000	1.000000	65
i1	299.4351	3.4500000477	65.573770	1	3660.000000	1.000000	1.700000	1.000000	61
i1	299.0787	3.4500000477	70.175439	1	3420.000000	1.000000	1.700000	1.000000	57
i1	298.7223	3.4500000477	75.471698	1	3180.000000	1.000000	1.700000	1.000000	53
i1	298.3659	3.4500000477	81.632653	1	2940.000000	1.000000	1.700000	1.000000	49
i1	298.0095	3.4500000477	88.888889	1	2700.000000	1.000000	1.700000	1.000000	45
i1	297.6531	3.4500000477	97.560976	1	2460.000000	1.000000	1.700000	1.000000	41
i1	297.2967	3.4500000477	108.108108	1	2220.000000	1.000000	1.700000	1.000000	37
i1	296.9403	3.4500000477	121.212121	1	1980.000000	1.000000	1.700000	1.000000	33
i1	296.5839	3.4500000477	137.931034	1	1740.000000	1.000000	1.700000	1.000000	29
i1	296.2275	3.4500000477	160.000000	1	1500.000000	1.000000	1.700000	1.000000	25
i1	295.8711	3.4500000477	190.476190	1	1260.000000	1.000000	1.700000	1.000000	21
i1	295.5147	3.4500000477	235.294118	1	1020.000000	1.000000	1.700000	1.000000	17
i1	295.1583	3.4500000477	307.692308	1	780.000000	1.000000	1.700000	1.000000	13
i1	294.8019	3.4500000477	444.444444	1	540.000000	1.000000	1.700000	1.000000	9
i1	294.4455	3.4500000477	800.000000	1	300.000000	1.000000	1.700000	1.000000	5
i1	294.0891	3.4500000477	4000.000000	1	60.000000	1.000000	1.700000	1.000000	1
i1	294.1782	3.4500000477	2000.000000	1	120.000000	1.000000	1.700000	1.000000	2
i1	294.5346	3.4500000477	666.666667	1	360.000000	1.000000	1.700000	1.000000	6
i1	294.891	3.4500000477	400.000000	1	600.000000	1.000000	1.700000	1.000000	10
i1	295.2474	3.4500000477	285.714286	1	840.000000	1.000000	1.700000	1.000000	14
i1	295.6038	3.4500000477	222.222222	1	1080.000000	1.000000	1.700000	1.000000	18
i1	295.9602	3.4500000477	181.818182	1	1320.000000	1.000000	1.700000	1.000000	22
i1	296.3166	3.4500000477	153.846154	1	1560.000000	1.000000	1.700000	1.000000	26
i1	296.673	3.4500000477	133.333333	1	1800.000000	1.000000	1.700000	1.000000	30
i1	297.0294	3.4500000477	117.647059	1	2040.000000	1.000000	1.700000	1.000000	34
i1	297.3858	3.4500000477	105.263158	1	2280.000000	1.000000	1.700000	1.000000	38
i1	297.7422	3.4500000477	95.238095	1	2520.000000	1.000000	1.700000	1.000000	42
i1	298.0986	3.4500000477	86.956522	1	2760.000000	1.000000	1.700000	1.000000	46
i1	298.455	3.4500000477	80.000000	1	3000.000000	1.000000	1.700000	1.000000	50
i1	298.8114	3.4500000477	74.074074	1	3240.000000	1.000000	1.700000	1.000000	54
i1	299.1678	3.4500000477	68.965517	1	3480.000000	1.000000	1.700000	1.000000	58
i1	299.5242	3.4500000477	64.516129	1	3720.000000	1.000000	1.700000	1.000000	62
i1	299.8806	3.4500000477	60.606061	1	3960.000000	1.000000	1.700000	1.000000	66
i1	303.03	20.7000007629	59.701493	1	4020.000000	1.000000	1.700000	6.900000	67
i1	302.67	20.7000007629	63.492063	1	3780.000000	1.000000	1.700000	6.900000	63
i1	302.31	20.7000007629	67.796610	1	3540.000000	1.000000	1.700000	6.900000	59
i1	301.95	20.7000007629	72.727273	1	3300.000000	1.000000	1.700000	6.900000	55
i1	301.59	20.7000007629	78.431373	1	3060.000000	1.000000	1.700000	6.900000	51
i1	301.23	20.7000007629	85.106383	1	2820.000000	1.000000	1.700000	6.900000	47
i1	300.87	20.7000007629	93.023256	1	2580.000000	1.000000	1.700000	6.900000	43
i1	300.51	20.7000007629	102.564103	1	2340.000000	1.000000	1.700000	6.900000	39
i1	300.15	20.7000007629	114.285714	1	2100.000000	1.000000	1.700000	6.900000	35
i1	299.79	20.7000007629	129.032258	1	1860.000000	1.000000	1.700000	6.900000	31
i1	299.43	20.7000007629	148.148148	1	1620.000000	1.000000	1.700000	6.900000	27
i1	299.07	20.7000007629	173.913043	1	1380.000000	1.000000	1.700000	6.900000	23
i1	298.71	20.7000007629	210.526316	1	1140.000000	1.000000	1.700000	6.900000	19
i1	298.35	20.7000007629	266.666667	1	900.000000	1.000000	1.700000	6.900000	15
i1	297.99	20.7000007629	363.636364	1	660.000000	1.000000	1.700000	6.900000	11
i1	297.63	20.7000007629	571.428571	1	420.000000	1.000000	1.700000	6.900000	7
i1	297.27	20.7000007629	1333.333333	1	180.000000	1.000000	1.700000	6.900000	3
i1	297.09	20.7000007629	4000.000000	1	60.000000	1.000000	1.700000	6.900000	1
i1	297.36	20.7000007629	1000.000000	1	240.000000	1.000000	1.700000	6.900000	4
i1	297.72	20.7000007629	500.000000	1	480.000000	1.000000	1.700000	6.900000	8
i1	298.08	20.7000007629	333.333333	1	720.000000	1.000000	1.700000	6.900000	12
i1	298.44	20.7000007629	250.000000	1	960.000000	1.000000	1.700000	6.900000	16
i1	298.8	20.7000007629	200.000000	1	1200.000000	1.000000	1.700000	6.900000	20
i1	299.16	20.7000007629	166.666667	1	1440.000000	1.000000	1.700000	6.900000	24
i1	299.52	20.7000007629	142.857143	1	1680.000000	1.000000	1.700000	6.900000	28
i1	299.88	20.7000007629	125.000000	1	1920.000000	1.000000	1.700000	6.900000	32
i1	300.24	20.7000007629	111.111111	1	2160.000000	1.000000	1.700000	6.900000	36
i1	300.6	20.7000007629	100.000000	1	2400.000000	1.000000	1.700000	6.900000	40
i1	300.96	20.7000007629	90.909091	1	2640.000000	1.000000	1.700000	6.900000	44
i1	301.32	20.7000007629	83.333333	1	2880.000000	1.000000	1.700000	6.900000	48
i1	301.68	20.7000007629	76.923077	1	3120.000000	1.000000	1.700000	6.900000	52
i1	302.04	20.7000007629	71.428571	1	3360.000000	1.000000	1.700000	6.900000	56
i1	302.4	20.7000007629	66.666667	1	3600.000000	1.000000	1.700000	6.900000	60
i1	302.76	20.7000007629	62.500000	1	3840.000000	1.000000	1.700000	6.900000	64
i1	0.0	20.7000007629	3600.000000	1	180.000000	0.300000	1.700000	6.900000	1
i1	3.1206	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	3.117	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	3.1134	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	3.1098	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	3.1062	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	3.1026	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	3.099	3.4500000477	65.454545	1	9900.000000	0.300000	1.700000	1.000000	55
i1	3.0954	3.4500000477	67.924528	1	9540.000000	0.300000	1.700000	1.000000	53
i1	3.0918	3.4500000477	70.588235	1	9180.000000	0.300000	1.700000	1.000000	51
i1	3.0882	3.4500000477	73.469388	1	8820.000000	0.300000	1.700000	1.000000	49
i1	3.0846	3.4500000477	76.595745	1	8460.000000	0.300000	1.700000	1.000000	47
i1	3.081	3.4500000477	80.000000	1	8100.000000	0.300000	1.700000	1.000000	45
i1	3.0774	3.4500000477	83.720930	1	7740.000000	0.300000	1.700000	1.000000	43
i1	3.0738	3.4500000477	87.804878	1	7380.000000	0.300000	1.700000	1.000000	41
i1	3.0702	3.4500000477	92.307692	1	7020.000000	0.300000	1.700000	1.000000	39
i1	3.0666	3.4500000477	97.297297	1	6660.000000	0.300000	1.700000	1.000000	37
i1	3.063	3.4500000477	102.857143	1	6300.000000	0.300000	1.700000	1.000000	35
i1	3.0594	3.4500000477	109.090909	1	5940.000000	0.300000	1.700000	1.000000	33
i1	3.0558	3.4500000477	116.129032	1	5580.000000	0.300000	1.700000	1.000000	31
i1	3.0522	3.4500000477	124.137931	1	5220.000000	0.300000	1.700000	1.000000	29
i1	3.0486	3.4500000477	133.333333	1	4860.000000	0.300000	1.700000	1.000000	27
i1	3.045	3.4500000477	144.000000	1	4500.000000	0.300000	1.700000	1.000000	25
i1	3.0414	3.4500000477	156.521739	1	4140.000000	0.300000	1.700000	1.000000	23
i1	3.0378	3.4500000477	171.428571	1	3780.000000	0.300000	1.700000	1.000000	21
i1	3.0342	3.4500000477	189.473684	1	3420.000000	0.300000	1.700000	1.000000	19
i1	3.0306	3.4500000477	211.764706	1	3060.000000	0.300000	1.700000	1.000000	17
i1	3.027	3.4500000477	240.000000	1	2700.000000	0.300000	1.700000	1.000000	15
i1	3.0234	3.4500000477	276.923077	1	2340.000000	0.300000	1.700000	1.000000	13
i1	3.0198	3.4500000477	327.272727	1	1980.000000	0.300000	1.700000	1.000000	11
i1	3.0162	3.4500000477	400.000000	1	1620.000000	0.300000	1.700000	1.000000	9
i1	3.0126	3.4500000477	514.285714	1	1260.000000	0.300000	1.700000	1.000000	7
i1	3.009	3.4500000477	720.000000	1	900.000000	0.300000	1.700000	1.000000	5
i1	3.0054	3.4500000477	1200.000000	1	540.000000	0.300000	1.700000	1.000000	3
i1	3.0036	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	3.0072	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	3.0108	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	3.0144	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	3.018	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	3.0216	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	3.0252	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	3.0288	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	3.0324	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	3.036	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	3.0396	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	3.0432	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	3.0468	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	3.0504	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	3.054	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	3.0576	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	3.0612	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	3.0648	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	3.0684	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	3.072	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	3.0756	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	3.0792	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	3.0828	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	3.0864	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	3.09	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	3.0936	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	3.0972	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	3.1008	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	3.1044	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	3.108	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	3.1116	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	3.1152	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	3.1188	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	6.0027	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	6.0054	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	9.2412	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	9.234	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	9.2268	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	9.2196	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	9.2124	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	9.2052	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	9.198	3.4500000477	65.454545	1	9900.000000	0.300000	1.700000	1.000000	55
i1	9.1908	3.4500000477	67.924528	1	9540.000000	0.300000	1.700000	1.000000	53
i1	9.1836	3.4500000477	70.588235	1	9180.000000	0.300000	1.700000	1.000000	51
i1	9.1764	3.4500000477	73.469388	1	8820.000000	0.300000	1.700000	1.000000	49
i1	9.1692	3.4500000477	76.595745	1	8460.000000	0.300000	1.700000	1.000000	47
i1	9.162	3.4500000477	80.000000	1	8100.000000	0.300000	1.700000	1.000000	45
i1	9.1548	3.4500000477	83.720930	1	7740.000000	0.300000	1.700000	1.000000	43
i1	9.1476	3.4500000477	87.804878	1	7380.000000	0.300000	1.700000	1.000000	41
i1	9.1404	3.4500000477	92.307692	1	7020.000000	0.300000	1.700000	1.000000	39
i1	9.1332	3.4500000477	97.297297	1	6660.000000	0.300000	1.700000	1.000000	37
i1	9.126	3.4500000477	102.857143	1	6300.000000	0.300000	1.700000	1.000000	35
i1	9.1188	3.4500000477	109.090909	1	5940.000000	0.300000	1.700000	1.000000	33
i1	9.1116	3.4500000477	116.129032	1	5580.000000	0.300000	1.700000	1.000000	31
i1	9.1044	3.4500000477	124.137931	1	5220.000000	0.300000	1.700000	1.000000	29
i1	9.0972	3.4500000477	133.333333	1	4860.000000	0.300000	1.700000	1.000000	27
i1	9.09	3.4500000477	144.000000	1	4500.000000	0.300000	1.700000	1.000000	25
i1	9.0828	3.4500000477	156.521739	1	4140.000000	0.300000	1.700000	1.000000	23
i1	9.0756	3.4500000477	171.428571	1	3780.000000	0.300000	1.700000	1.000000	21
i1	9.0684	3.4500000477	189.473684	1	3420.000000	0.300000	1.700000	1.000000	19
i1	9.0612	3.4500000477	211.764706	1	3060.000000	0.300000	1.700000	1.000000	17
i1	9.054	3.4500000477	240.000000	1	2700.000000	0.300000	1.700000	1.000000	15
i1	9.0468	3.4500000477	276.923077	1	2340.000000	0.300000	1.700000	1.000000	13
i1	9.0396	3.4500000477	327.272727	1	1980.000000	0.300000	1.700000	1.000000	11
i1	9.0324	3.4500000477	400.000000	1	1620.000000	0.300000	1.700000	1.000000	9
i1	9.0252	3.4500000477	514.285714	1	1260.000000	0.300000	1.700000	1.000000	7
i1	9.018	3.4500000477	720.000000	1	900.000000	0.300000	1.700000	1.000000	5
i1	9.0036	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	9.0144	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	9.0216	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	9.0288	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	9.036	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	9.0432	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	9.0504	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	9.0576	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	9.0648	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	9.072	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	9.0792	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	9.0864	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	9.0936	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	9.1008	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	9.108	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	9.1152	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	9.1224	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	9.1296	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	9.1368	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	9.144	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	9.1512	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	9.1584	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	9.1656	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	9.1728	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	9.18	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	9.1872	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	9.1944	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	9.2016	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	9.2088	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	9.216	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	9.2232	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	9.2304	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	9.2376	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	12.0135	3.4500000477	1200.000000	1	540.000000	0.300000	1.700000	1.000000	3
i1	12.009	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	12.018	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	15.3618	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	15.351	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	15.3402	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	15.3294	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	15.3186	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	15.3078	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	15.297	3.4500000477	65.454545	1	9900.000000	0.300000	1.700000	1.000000	55
i1	15.2862	3.4500000477	67.924528	1	9540.000000	0.300000	1.700000	1.000000	53
i1	15.2754	3.4500000477	70.588235	1	9180.000000	0.300000	1.700000	1.000000	51
i1	15.2646	3.4500000477	73.469388	1	8820.000000	0.300000	1.700000	1.000000	49
i1	15.2538	3.4500000477	76.595745	1	8460.000000	0.300000	1.700000	1.000000	47
i1	15.243	3.4500000477	80.000000	1	8100.000000	0.300000	1.700000	1.000000	45
i1	15.2322	3.4500000477	83.720930	1	7740.000000	0.300000	1.700000	1.000000	43
i1	15.2214	3.4500000477	87.804878	1	7380.000000	0.300000	1.700000	1.000000	41
i1	15.2106	3.4500000477	92.307692	1	7020.000000	0.300000	1.700000	1.000000	39
i1	15.1998	3.4500000477	97.297297	1	6660.000000	0.300000	1.700000	1.000000	37
i1	15.189	3.4500000477	102.857143	1	6300.000000	0.300000	1.700000	1.000000	35
i1	15.1782	3.4500000477	109.090909	1	5940.000000	0.300000	1.700000	1.000000	33
i1	15.1674	3.4500000477	116.129032	1	5580.000000	0.300000	1.700000	1.000000	31
i1	15.1566	3.4500000477	124.137931	1	5220.000000	0.300000	1.700000	1.000000	29
i1	15.1458	3.4500000477	133.333333	1	4860.000000	0.300000	1.700000	1.000000	27
i1	15.135	3.4500000477	144.000000	1	4500.000000	0.300000	1.700000	1.000000	25
i1	15.1242	3.4500000477	156.521739	1	4140.000000	0.300000	1.700000	1.000000	23
i1	15.1134	3.4500000477	171.428571	1	3780.000000	0.300000	1.700000	1.000000	21
i1	15.1026	3.4500000477	189.473684	1	3420.000000	0.300000	1.700000	1.000000	19
i1	15.0918	3.4500000477	211.764706	1	3060.000000	0.300000	1.700000	1.000000	17
i1	15.081	3.4500000477	240.000000	1	2700.000000	0.300000	1.700000	1.000000	15
i1	15.0702	3.4500000477	276.923077	1	2340.000000	0.300000	1.700000	1.000000	13
i1	15.0594	3.4500000477	327.272727	1	1980.000000	0.300000	1.700000	1.000000	11
i1	15.0486	3.4500000477	400.000000	1	1620.000000	0.300000	1.700000	1.000000	9
i1	15.0378	3.4500000477	514.285714	1	1260.000000	0.300000	1.700000	1.000000	7
i1	15.0054	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	15.0108	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	15.0324	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	15.0432	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	15.054	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	15.0648	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	15.0756	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	15.0864	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	15.0972	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	15.108	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	15.1188	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	15.1296	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	15.1404	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	15.1512	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	15.162	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	15.1728	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	15.1836	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	15.1944	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	15.2052	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	15.216	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	15.2268	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	15.2376	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	15.2484	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	15.2592	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	15.27	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	15.2808	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	15.2916	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	15.3024	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	15.3132	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	15.324	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	15.3348	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	15.3456	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	15.3564	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	18.0315	3.4500000477	720.000000	1	900.000000	0.300000	1.700000	1.000000	5
i1	18.0063	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	18.0252	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	18.0378	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	21.4824	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	21.468	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	21.4536	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	21.4392	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	21.4248	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	21.4104	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	21.396	3.4500000477	65.454545	1	9900.000000	0.300000	1.700000	1.000000	55
i1	21.3816	3.4500000477	67.924528	1	9540.000000	0.300000	1.700000	1.000000	53
i1	21.3672	3.4500000477	70.588235	1	9180.000000	0.300000	1.700000	1.000000	51
i1	21.3528	3.4500000477	73.469388	1	8820.000000	0.300000	1.700000	1.000000	49
i1	21.3384	3.4500000477	76.595745	1	8460.000000	0.300000	1.700000	1.000000	47
i1	21.324	3.4500000477	80.000000	1	8100.000000	0.300000	1.700000	1.000000	45
i1	21.3096	3.4500000477	83.720930	1	7740.000000	0.300000	1.700000	1.000000	43
i1	21.2952	3.4500000477	87.804878	1	7380.000000	0.300000	1.700000	1.000000	41
i1	21.2808	3.4500000477	92.307692	1	7020.000000	0.300000	1.700000	1.000000	39
i1	21.2664	3.4500000477	97.297297	1	6660.000000	0.300000	1.700000	1.000000	37
i1	21.252	3.4500000477	102.857143	1	6300.000000	0.300000	1.700000	1.000000	35
i1	21.2376	3.4500000477	109.090909	1	5940.000000	0.300000	1.700000	1.000000	33
i1	21.2232	3.4500000477	116.129032	1	5580.000000	0.300000	1.700000	1.000000	31
i1	21.2088	3.4500000477	124.137931	1	5220.000000	0.300000	1.700000	1.000000	29
i1	21.1944	3.4500000477	133.333333	1	4860.000000	0.300000	1.700000	1.000000	27
i1	21.18	3.4500000477	144.000000	1	4500.000000	0.300000	1.700000	1.000000	25
i1	21.1656	3.4500000477	156.521739	1	4140.000000	0.300000	1.700000	1.000000	23
i1	21.1512	3.4500000477	171.428571	1	3780.000000	0.300000	1.700000	1.000000	21
i1	21.1368	3.4500000477	189.473684	1	3420.000000	0.300000	1.700000	1.000000	19
i1	21.1224	3.4500000477	211.764706	1	3060.000000	0.300000	1.700000	1.000000	17
i1	21.108	3.4500000477	240.000000	1	2700.000000	0.300000	1.700000	1.000000	15
i1	21.0936	3.4500000477	276.923077	1	2340.000000	0.300000	1.700000	1.000000	13
i1	21.0792	3.4500000477	327.272727	1	1980.000000	0.300000	1.700000	1.000000	11
i1	21.0648	3.4500000477	400.000000	1	1620.000000	0.300000	1.700000	1.000000	9
i1	21.0216	3.4500000477	1200.000000	1	540.000000	0.300000	1.700000	1.000000	3
i1	21.0144	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	21.0288	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	21.0576	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	21.072	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	21.0864	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	21.1008	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	21.1152	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	21.1296	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	21.144	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	21.1584	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	21.1728	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	21.1872	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	21.2016	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	21.216	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	21.2304	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	21.2448	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	21.2592	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	21.2736	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	21.288	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	21.3024	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	21.3168	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	21.3312	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	21.3456	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	21.36	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	21.3744	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	21.3888	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	21.4032	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	21.4176	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	21.432	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	21.4464	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	21.4608	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	21.4752	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	24.0567	3.4500000477	514.285714	1	1260.000000	0.300000	1.700000	1.000000	7
i1	24.0081	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	24.0162	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	24.0486	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	24.0648	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	27.603	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	27.585	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	27.567	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	27.549	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	27.531	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	27.513	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	27.495	3.4500000477	65.454545	1	9900.000000	0.300000	1.700000	1.000000	55
i1	27.477	3.4500000477	67.924528	1	9540.000000	0.300000	1.700000	1.000000	53
i1	27.459	3.4500000477	70.588235	1	9180.000000	0.300000	1.700000	1.000000	51
i1	27.441	3.4500000477	73.469388	1	8820.000000	0.300000	1.700000	1.000000	49
i1	27.423	3.4500000477	76.595745	1	8460.000000	0.300000	1.700000	1.000000	47
i1	27.405	3.4500000477	80.000000	1	8100.000000	0.300000	1.700000	1.000000	45
i1	27.387	3.4500000477	83.720930	1	7740.000000	0.300000	1.700000	1.000000	43
i1	27.369	3.4500000477	87.804878	1	7380.000000	0.300000	1.700000	1.000000	41
i1	27.351	3.4500000477	92.307692	1	7020.000000	0.300000	1.700000	1.000000	39
i1	27.333	3.4500000477	97.297297	1	6660.000000	0.300000	1.700000	1.000000	37
i1	27.315	3.4500000477	102.857143	1	6300.000000	0.300000	1.700000	1.000000	35
i1	27.297	3.4500000477	109.090909	1	5940.000000	0.300000	1.700000	1.000000	33
i1	27.279	3.4500000477	116.129032	1	5580.000000	0.300000	1.700000	1.000000	31
i1	27.261	3.4500000477	124.137931	1	5220.000000	0.300000	1.700000	1.000000	29
i1	27.243	3.4500000477	133.333333	1	4860.000000	0.300000	1.700000	1.000000	27
i1	27.225	3.4500000477	144.000000	1	4500.000000	0.300000	1.700000	1.000000	25
i1	27.207	3.4500000477	156.521739	1	4140.000000	0.300000	1.700000	1.000000	23
i1	27.189	3.4500000477	171.428571	1	3780.000000	0.300000	1.700000	1.000000	21
i1	27.171	3.4500000477	189.473684	1	3420.000000	0.300000	1.700000	1.000000	19
i1	27.153	3.4500000477	211.764706	1	3060.000000	0.300000	1.700000	1.000000	17
i1	27.135	3.4500000477	240.000000	1	2700.000000	0.300000	1.700000	1.000000	15
i1	27.117	3.4500000477	276.923077	1	2340.000000	0.300000	1.700000	1.000000	13
i1	27.099	3.4500000477	327.272727	1	1980.000000	0.300000	1.700000	1.000000	11
i1	27.045	3.4500000477	720.000000	1	900.000000	0.300000	1.700000	1.000000	5
i1	27.009	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	27.036	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	27.054	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	27.09	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	27.108	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	27.126	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	27.144	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	27.162	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	27.18	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	27.198	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	27.216	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	27.234	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	27.252	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	27.27	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	27.288	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	27.306	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	27.324	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	27.342	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	27.36	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	27.378	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	27.396	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	27.414	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	27.432	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	27.45	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	27.468	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	27.486	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	27.504	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	27.522	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	27.54	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	27.558	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	27.576	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	27.594	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	30.0891	3.4500000477	400.000000	1	1620.000000	0.300000	1.700000	1.000000	9
i1	30.0297	3.4500000477	1200.000000	1	540.000000	0.300000	1.700000	1.000000	3
i1	30.0198	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	30.0396	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	30.0792	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	30.099	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	33.7236	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	33.702	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	33.6804	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	33.6588	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	33.6372	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	33.6156	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	33.594	3.4500000477	65.454545	1	9900.000000	0.300000	1.700000	1.000000	55
i1	33.5724	3.4500000477	67.924528	1	9540.000000	0.300000	1.700000	1.000000	53
i1	33.5508	3.4500000477	70.588235	1	9180.000000	0.300000	1.700000	1.000000	51
i1	33.5292	3.4500000477	73.469388	1	8820.000000	0.300000	1.700000	1.000000	49
i1	33.5076	3.4500000477	76.595745	1	8460.000000	0.300000	1.700000	1.000000	47
i1	33.486	3.4500000477	80.000000	1	8100.000000	0.300000	1.700000	1.000000	45
i1	33.4644	3.4500000477	83.720930	1	7740.000000	0.300000	1.700000	1.000000	43
i1	33.4428	3.4500000477	87.804878	1	7380.000000	0.300000	1.700000	1.000000	41
i1	33.4212	3.4500000477	92.307692	1	7020.000000	0.300000	1.700000	1.000000	39
i1	33.3996	3.4500000477	97.297297	1	6660.000000	0.300000	1.700000	1.000000	37
i1	33.378	3.4500000477	102.857143	1	6300.000000	0.300000	1.700000	1.000000	35
i1	33.3564	3.4500000477	109.090909	1	5940.000000	0.300000	1.700000	1.000000	33
i1	33.3348	3.4500000477	116.129032	1	5580.000000	0.300000	1.700000	1.000000	31
i1	33.3132	3.4500000477	124.137931	1	5220.000000	0.300000	1.700000	1.000000	29
i1	33.2916	3.4500000477	133.333333	1	4860.000000	0.300000	1.700000	1.000000	27
i1	33.27	3.4500000477	144.000000	1	4500.000000	0.300000	1.700000	1.000000	25
i1	33.2484	3.4500000477	156.521739	1	4140.000000	0.300000	1.700000	1.000000	23
i1	33.2268	3.4500000477	171.428571	1	3780.000000	0.300000	1.700000	1.000000	21
i1	33.2052	3.4500000477	189.473684	1	3420.000000	0.300000	1.700000	1.000000	19
i1	33.1836	3.4500000477	211.764706	1	3060.000000	0.300000	1.700000	1.000000	17
i1	33.162	3.4500000477	240.000000	1	2700.000000	0.300000	1.700000	1.000000	15
i1	33.1404	3.4500000477	276.923077	1	2340.000000	0.300000	1.700000	1.000000	13
i1	33.0756	3.4500000477	514.285714	1	1260.000000	0.300000	1.700000	1.000000	7
i1	33.0108	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	33.0216	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	33.0648	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	33.0864	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	33.1296	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	33.1512	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	33.1728	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	33.1944	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	33.216	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	33.2376	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	33.2592	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	33.2808	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	33.3024	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	33.324	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	33.3456	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	33.3672	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	33.3888	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	33.4104	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	33.432	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	33.4536	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	33.4752	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	33.4968	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	33.5184	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	33.54	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	33.5616	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	33.5832	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	33.6048	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	33.6264	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	33.648	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	33.6696	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	33.6912	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	33.7128	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	36.1287	3.4500000477	327.272727	1	1980.000000	0.300000	1.700000	1.000000	11
i1	36.0585	3.4500000477	720.000000	1	900.000000	0.300000	1.700000	1.000000	5
i1	36.0117	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	36.0468	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	36.0702	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	36.117	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	36.1404	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	39.8442	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	39.819	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	39.7938	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	39.7686	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	39.7434	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	39.7182	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	39.693	3.4500000477	65.454545	1	9900.000000	0.300000	1.700000	1.000000	55
i1	39.6678	3.4500000477	67.924528	1	9540.000000	0.300000	1.700000	1.000000	53
i1	39.6426	3.4500000477	70.588235	1	9180.000000	0.300000	1.700000	1.000000	51
i1	39.6174	3.4500000477	73.469388	1	8820.000000	0.300000	1.700000	1.000000	49
i1	39.5922	3.4500000477	76.595745	1	8460.000000	0.300000	1.700000	1.000000	47
i1	39.567	3.4500000477	80.000000	1	8100.000000	0.300000	1.700000	1.000000	45
i1	39.5418	3.4500000477	83.720930	1	7740.000000	0.300000	1.700000	1.000000	43
i1	39.5166	3.4500000477	87.804878	1	7380.000000	0.300000	1.700000	1.000000	41
i1	39.4914	3.4500000477	92.307692	1	7020.000000	0.300000	1.700000	1.000000	39
i1	39.4662	3.4500000477	97.297297	1	6660.000000	0.300000	1.700000	1.000000	37
i1	39.441	3.4500000477	102.857143	1	6300.000000	0.300000	1.700000	1.000000	35
i1	39.4158	3.4500000477	109.090909	1	5940.000000	0.300000	1.700000	1.000000	33
i1	39.3906	3.4500000477	116.129032	1	5580.000000	0.300000	1.700000	1.000000	31
i1	39.3654	3.4500000477	124.137931	1	5220.000000	0.300000	1.700000	1.000000	29
i1	39.3402	3.4500000477	133.333333	1	4860.000000	0.300000	1.700000	1.000000	27
i1	39.315	3.4500000477	144.000000	1	4500.000000	0.300000	1.700000	1.000000	25
i1	39.2898	3.4500000477	156.521739	1	4140.000000	0.300000	1.700000	1.000000	23
i1	39.2646	3.4500000477	171.428571	1	3780.000000	0.300000	1.700000	1.000000	21
i1	39.2394	3.4500000477	189.473684	1	3420.000000	0.300000	1.700000	1.000000	19
i1	39.2142	3.4500000477	211.764706	1	3060.000000	0.300000	1.700000	1.000000	17
i1	39.189	3.4500000477	240.000000	1	2700.000000	0.300000	1.700000	1.000000	15
i1	39.1134	3.4500000477	400.000000	1	1620.000000	0.300000	1.700000	1.000000	9
i1	39.0378	3.4500000477	1200.000000	1	540.000000	0.300000	1.700000	1.000000	3
i1	39.0252	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	39.0504	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	39.1008	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	39.126	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	39.1764	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	39.2016	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	39.2268	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	39.252	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	39.2772	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	39.3024	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	39.3276	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	39.3528	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	39.378	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	39.4032	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	39.4284	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	39.4536	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	39.4788	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	39.504	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	39.5292	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	39.5544	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	39.5796	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	39.6048	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	39.63	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	39.6552	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	39.6804	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	39.7056	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	39.7308	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	39.756	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	39.7812	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	39.8064	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	39.8316	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	42.1755	3.4500000477	276.923077	1	2340.000000	0.300000	1.700000	1.000000	13
i1	42.0945	3.4500000477	514.285714	1	1260.000000	0.300000	1.700000	1.000000	7
i1	42.0135	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	42.027	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	42.081	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	42.108	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	42.162	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	42.189	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	45.9648	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	45.936	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	45.9072	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	45.8784	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	45.8496	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	45.8208	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	45.792	3.4500000477	65.454545	1	9900.000000	0.300000	1.700000	1.000000	55
i1	45.7632	3.4500000477	67.924528	1	9540.000000	0.300000	1.700000	1.000000	53
i1	45.7344	3.4500000477	70.588235	1	9180.000000	0.300000	1.700000	1.000000	51
i1	45.7056	3.4500000477	73.469388	1	8820.000000	0.300000	1.700000	1.000000	49
i1	45.6768	3.4500000477	76.595745	1	8460.000000	0.300000	1.700000	1.000000	47
i1	45.648	3.4500000477	80.000000	1	8100.000000	0.300000	1.700000	1.000000	45
i1	45.6192	3.4500000477	83.720930	1	7740.000000	0.300000	1.700000	1.000000	43
i1	45.5904	3.4500000477	87.804878	1	7380.000000	0.300000	1.700000	1.000000	41
i1	45.5616	3.4500000477	92.307692	1	7020.000000	0.300000	1.700000	1.000000	39
i1	45.5328	3.4500000477	97.297297	1	6660.000000	0.300000	1.700000	1.000000	37
i1	45.504	3.4500000477	102.857143	1	6300.000000	0.300000	1.700000	1.000000	35
i1	45.4752	3.4500000477	109.090909	1	5940.000000	0.300000	1.700000	1.000000	33
i1	45.4464	3.4500000477	116.129032	1	5580.000000	0.300000	1.700000	1.000000	31
i1	45.4176	3.4500000477	124.137931	1	5220.000000	0.300000	1.700000	1.000000	29
i1	45.3888	3.4500000477	133.333333	1	4860.000000	0.300000	1.700000	1.000000	27
i1	45.36	3.4500000477	144.000000	1	4500.000000	0.300000	1.700000	1.000000	25
i1	45.3312	3.4500000477	156.521739	1	4140.000000	0.300000	1.700000	1.000000	23
i1	45.3024	3.4500000477	171.428571	1	3780.000000	0.300000	1.700000	1.000000	21
i1	45.2736	3.4500000477	189.473684	1	3420.000000	0.300000	1.700000	1.000000	19
i1	45.2448	3.4500000477	211.764706	1	3060.000000	0.300000	1.700000	1.000000	17
i1	45.1584	3.4500000477	327.272727	1	1980.000000	0.300000	1.700000	1.000000	11
i1	45.072	3.4500000477	720.000000	1	900.000000	0.300000	1.700000	1.000000	5
i1	45.0144	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	45.0576	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	45.0864	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	45.144	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	45.1728	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	45.2304	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	45.2592	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	45.288	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	45.3168	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	45.3456	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	45.3744	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	45.4032	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	45.432	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	45.4608	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	45.4896	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	45.5184	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	45.5472	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	45.576	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	45.6048	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	45.6336	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	45.6624	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	45.6912	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	45.72	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	45.7488	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	45.7776	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	45.8064	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	45.8352	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	45.864	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	45.8928	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	45.9216	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	45.9504	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	48.2295	3.4500000477	240.000000	1	2700.000000	0.300000	1.700000	1.000000	15
i1	48.1377	3.4500000477	400.000000	1	1620.000000	0.300000	1.700000	1.000000	9
i1	48.0459	3.4500000477	1200.000000	1	540.000000	0.300000	1.700000	1.000000	3
i1	48.0306	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	48.0612	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	48.1224	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	48.153	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	48.2142	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	48.2448	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	52.0854	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	52.053	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	52.0206	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	51.9882	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	51.9558	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	51.9234	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	51.891	3.4500000477	65.454545	1	9900.000000	0.300000	1.700000	1.000000	55
i1	51.8586	3.4500000477	67.924528	1	9540.000000	0.300000	1.700000	1.000000	53
i1	51.8262	3.4500000477	70.588235	1	9180.000000	0.300000	1.700000	1.000000	51
i1	51.7938	3.4500000477	73.469388	1	8820.000000	0.300000	1.700000	1.000000	49
i1	51.7614	3.4500000477	76.595745	1	8460.000000	0.300000	1.700000	1.000000	47
i1	51.729	3.4500000477	80.000000	1	8100.000000	0.300000	1.700000	1.000000	45
i1	51.6966	3.4500000477	83.720930	1	7740.000000	0.300000	1.700000	1.000000	43
i1	51.6642	3.4500000477	87.804878	1	7380.000000	0.300000	1.700000	1.000000	41
i1	51.6318	3.4500000477	92.307692	1	7020.000000	0.300000	1.700000	1.000000	39
i1	51.5994	3.4500000477	97.297297	1	6660.000000	0.300000	1.700000	1.000000	37
i1	51.567	3.4500000477	102.857143	1	6300.000000	0.300000	1.700000	1.000000	35
i1	51.5346	3.4500000477	109.090909	1	5940.000000	0.300000	1.700000	1.000000	33
i1	51.5022	3.4500000477	116.129032	1	5580.000000	0.300000	1.700000	1.000000	31
i1	51.4698	3.4500000477	124.137931	1	5220.000000	0.300000	1.700000	1.000000	29
i1	51.4374	3.4500000477	133.333333	1	4860.000000	0.300000	1.700000	1.000000	27
i1	51.405	3.4500000477	144.000000	1	4500.000000	0.300000	1.700000	1.000000	25
i1	51.3726	3.4500000477	156.521739	1	4140.000000	0.300000	1.700000	1.000000	23
i1	51.3402	3.4500000477	171.428571	1	3780.000000	0.300000	1.700000	1.000000	21
i1	51.3078	3.4500000477	189.473684	1	3420.000000	0.300000	1.700000	1.000000	19
i1	51.2106	3.4500000477	276.923077	1	2340.000000	0.300000	1.700000	1.000000	13
i1	51.1134	3.4500000477	514.285714	1	1260.000000	0.300000	1.700000	1.000000	7
i1	51.0162	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	51.0324	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	51.0972	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	51.1296	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	51.1944	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	51.2268	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	51.2916	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	51.324	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	51.3564	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	51.3888	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	51.4212	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	51.4536	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	51.486	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	51.5184	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	51.5508	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	51.5832	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	51.6156	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	51.648	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	51.6804	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	51.7128	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	51.7452	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	51.7776	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	51.81	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	51.8424	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	51.8748	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	51.9072	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	51.9396	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	51.972	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	52.0044	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	52.0368	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	52.0692	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	54.2907	3.4500000477	211.764706	1	3060.000000	0.300000	1.700000	1.000000	17
i1	54.1881	3.4500000477	327.272727	1	1980.000000	0.300000	1.700000	1.000000	11
i1	54.0855	3.4500000477	720.000000	1	900.000000	0.300000	1.700000	1.000000	5
i1	54.0171	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	54.0684	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	54.1026	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	54.171	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	54.2052	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	54.2736	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	54.3078	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	58.206	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	58.17	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	58.134	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	58.098	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	58.062	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	58.026	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	57.99	3.4500000477	65.454545	1	9900.000000	0.300000	1.700000	1.000000	55
i1	57.954	3.4500000477	67.924528	1	9540.000000	0.300000	1.700000	1.000000	53
i1	57.918	3.4500000477	70.588235	1	9180.000000	0.300000	1.700000	1.000000	51
i1	57.882	3.4500000477	73.469388	1	8820.000000	0.300000	1.700000	1.000000	49
i1	57.846	3.4500000477	76.595745	1	8460.000000	0.300000	1.700000	1.000000	47
i1	57.81	3.4500000477	80.000000	1	8100.000000	0.300000	1.700000	1.000000	45
i1	57.774	3.4500000477	83.720930	1	7740.000000	0.300000	1.700000	1.000000	43
i1	57.738	3.4500000477	87.804878	1	7380.000000	0.300000	1.700000	1.000000	41
i1	57.702	3.4500000477	92.307692	1	7020.000000	0.300000	1.700000	1.000000	39
i1	57.666	3.4500000477	97.297297	1	6660.000000	0.300000	1.700000	1.000000	37
i1	57.63	3.4500000477	102.857143	1	6300.000000	0.300000	1.700000	1.000000	35
i1	57.594	3.4500000477	109.090909	1	5940.000000	0.300000	1.700000	1.000000	33
i1	57.558	3.4500000477	116.129032	1	5580.000000	0.300000	1.700000	1.000000	31
i1	57.522	3.4500000477	124.137931	1	5220.000000	0.300000	1.700000	1.000000	29
i1	57.486	3.4500000477	133.333333	1	4860.000000	0.300000	1.700000	1.000000	27
i1	57.45	3.4500000477	144.000000	1	4500.000000	0.300000	1.700000	1.000000	25
i1	57.414	3.4500000477	156.521739	1	4140.000000	0.300000	1.700000	1.000000	23
i1	57.378	3.4500000477	171.428571	1	3780.000000	0.300000	1.700000	1.000000	21
i1	57.27	3.4500000477	240.000000	1	2700.000000	0.300000	1.700000	1.000000	15
i1	57.162	3.4500000477	400.000000	1	1620.000000	0.300000	1.700000	1.000000	9
i1	57.054	3.4500000477	1200.000000	1	540.000000	0.300000	1.700000	1.000000	3
i1	57.036	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	57.072	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	57.144	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	57.18	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	57.252	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	57.288	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	57.36	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	57.396	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	57.432	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	57.468	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	57.504	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	57.54	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	57.576	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	57.612	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	57.648	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	57.684	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	57.72	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	57.756	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	57.792	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	57.828	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	57.864	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	57.9	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	57.936	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	57.972	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	58.008	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	58.044	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	58.08	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	58.116	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	58.152	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	58.188	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	60.3591	3.4500000477	189.473684	1	3420.000000	0.300000	1.700000	1.000000	19
i1	60.2457	3.4500000477	276.923077	1	2340.000000	0.300000	1.700000	1.000000	13
i1	60.1323	3.4500000477	514.285714	1	1260.000000	0.300000	1.700000	1.000000	7
i1	60.0189	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	60.0378	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	60.1134	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	60.1512	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	60.2268	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	60.2646	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	60.3402	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	60.378	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	64.3266	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	64.287	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	64.2474	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	64.2078	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	64.1682	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	64.1286	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	64.089	3.4500000477	65.454545	1	9900.000000	0.300000	1.700000	1.000000	55
i1	64.0494	3.4500000477	67.924528	1	9540.000000	0.300000	1.700000	1.000000	53
i1	64.0098	3.4500000477	70.588235	1	9180.000000	0.300000	1.700000	1.000000	51
i1	63.9702	3.4500000477	73.469388	1	8820.000000	0.300000	1.700000	1.000000	49
i1	63.9306	3.4500000477	76.595745	1	8460.000000	0.300000	1.700000	1.000000	47
i1	63.891	3.4500000477	80.000000	1	8100.000000	0.300000	1.700000	1.000000	45
i1	63.8514	3.4500000477	83.720930	1	7740.000000	0.300000	1.700000	1.000000	43
i1	63.8118	3.4500000477	87.804878	1	7380.000000	0.300000	1.700000	1.000000	41
i1	63.7722	3.4500000477	92.307692	1	7020.000000	0.300000	1.700000	1.000000	39
i1	63.7326	3.4500000477	97.297297	1	6660.000000	0.300000	1.700000	1.000000	37
i1	63.693	3.4500000477	102.857143	1	6300.000000	0.300000	1.700000	1.000000	35
i1	63.6534	3.4500000477	109.090909	1	5940.000000	0.300000	1.700000	1.000000	33
i1	63.6138	3.4500000477	116.129032	1	5580.000000	0.300000	1.700000	1.000000	31
i1	63.5742	3.4500000477	124.137931	1	5220.000000	0.300000	1.700000	1.000000	29
i1	63.5346	3.4500000477	133.333333	1	4860.000000	0.300000	1.700000	1.000000	27
i1	63.495	3.4500000477	144.000000	1	4500.000000	0.300000	1.700000	1.000000	25
i1	63.4554	3.4500000477	156.521739	1	4140.000000	0.300000	1.700000	1.000000	23
i1	63.3366	3.4500000477	211.764706	1	3060.000000	0.300000	1.700000	1.000000	17
i1	63.2178	3.4500000477	327.272727	1	1980.000000	0.300000	1.700000	1.000000	11
i1	63.099	3.4500000477	720.000000	1	900.000000	0.300000	1.700000	1.000000	5
i1	63.0198	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	63.0792	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	63.1188	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	63.198	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	63.2376	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	63.3168	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	63.3564	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	63.4356	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	63.4752	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	63.5148	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	63.5544	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	63.594	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	63.6336	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	63.6732	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	63.7128	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	63.7524	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	63.792	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	63.8316	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	63.8712	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	63.9108	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	63.9504	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	63.99	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	64.0296	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	64.0692	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	64.1088	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	64.1484	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	64.188	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	64.2276	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	64.2672	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	64.3068	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	66.4347	3.4500000477	171.428571	1	3780.000000	0.300000	1.700000	1.000000	21
i1	66.3105	3.4500000477	240.000000	1	2700.000000	0.300000	1.700000	1.000000	15
i1	66.1863	3.4500000477	400.000000	1	1620.000000	0.300000	1.700000	1.000000	9
i1	66.0621	3.4500000477	1200.000000	1	540.000000	0.300000	1.700000	1.000000	3
i1	66.0414	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	66.0828	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	66.1656	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	66.207	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	66.2898	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	66.3312	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	66.414	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	66.4554	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	70.4472	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	70.404	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	70.3608	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	70.3176	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	70.2744	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	70.2312	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	70.188	3.4500000477	65.454545	1	9900.000000	0.300000	1.700000	1.000000	55
i1	70.1448	3.4500000477	67.924528	1	9540.000000	0.300000	1.700000	1.000000	53
i1	70.1016	3.4500000477	70.588235	1	9180.000000	0.300000	1.700000	1.000000	51
i1	70.0584	3.4500000477	73.469388	1	8820.000000	0.300000	1.700000	1.000000	49
i1	70.0152	3.4500000477	76.595745	1	8460.000000	0.300000	1.700000	1.000000	47
i1	69.972	3.4500000477	80.000000	1	8100.000000	0.300000	1.700000	1.000000	45
i1	69.9288	3.4500000477	83.720930	1	7740.000000	0.300000	1.700000	1.000000	43
i1	69.8856	3.4500000477	87.804878	1	7380.000000	0.300000	1.700000	1.000000	41
i1	69.8424	3.4500000477	92.307692	1	7020.000000	0.300000	1.700000	1.000000	39
i1	69.7992	3.4500000477	97.297297	1	6660.000000	0.300000	1.700000	1.000000	37
i1	69.756	3.4500000477	102.857143	1	6300.000000	0.300000	1.700000	1.000000	35
i1	69.7128	3.4500000477	109.090909	1	5940.000000	0.300000	1.700000	1.000000	33
i1	69.6696	3.4500000477	116.129032	1	5580.000000	0.300000	1.700000	1.000000	31
i1	69.6264	3.4500000477	124.137931	1	5220.000000	0.300000	1.700000	1.000000	29
i1	69.5832	3.4500000477	133.333333	1	4860.000000	0.300000	1.700000	1.000000	27
i1	69.54	3.4500000477	144.000000	1	4500.000000	0.300000	1.700000	1.000000	25
i1	69.4104	3.4500000477	189.473684	1	3420.000000	0.300000	1.700000	1.000000	19
i1	69.2808	3.4500000477	276.923077	1	2340.000000	0.300000	1.700000	1.000000	13
i1	69.1512	3.4500000477	514.285714	1	1260.000000	0.300000	1.700000	1.000000	7
i1	69.0216	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	69.0432	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	69.1296	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	69.1728	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	69.2592	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	69.3024	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	69.3888	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	69.432	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	69.5184	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	69.5616	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	69.6048	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	69.648	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	69.6912	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	69.7344	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	69.7776	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	69.8208	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	69.864	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	69.9072	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	69.9504	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	69.9936	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	70.0368	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	70.08	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	70.1232	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	70.1664	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	70.2096	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	70.2528	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	70.296	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	70.3392	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	70.3824	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	70.4256	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	72.5175	3.4500000477	156.521739	1	4140.000000	0.300000	1.700000	1.000000	23
i1	72.3825	3.4500000477	211.764706	1	3060.000000	0.300000	1.700000	1.000000	17
i1	72.2475	3.4500000477	327.272727	1	1980.000000	0.300000	1.700000	1.000000	11
i1	72.1125	3.4500000477	720.000000	1	900.000000	0.300000	1.700000	1.000000	5
i1	72.0225	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	72.09	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	72.135	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	72.225	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	72.27	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	72.36	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	72.405	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	72.495	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	72.54	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	76.5678	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	76.521	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	76.4742	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	76.4274	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	76.3806	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	76.3338	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	76.287	3.4500000477	65.454545	1	9900.000000	0.300000	1.700000	1.000000	55
i1	76.2402	3.4500000477	67.924528	1	9540.000000	0.300000	1.700000	1.000000	53
i1	76.1934	3.4500000477	70.588235	1	9180.000000	0.300000	1.700000	1.000000	51
i1	76.1466	3.4500000477	73.469388	1	8820.000000	0.300000	1.700000	1.000000	49
i1	76.0998	3.4500000477	76.595745	1	8460.000000	0.300000	1.700000	1.000000	47
i1	76.053	3.4500000477	80.000000	1	8100.000000	0.300000	1.700000	1.000000	45
i1	76.0062	3.4500000477	83.720930	1	7740.000000	0.300000	1.700000	1.000000	43
i1	75.9594	3.4500000477	87.804878	1	7380.000000	0.300000	1.700000	1.000000	41
i1	75.9126	3.4500000477	92.307692	1	7020.000000	0.300000	1.700000	1.000000	39
i1	75.8658	3.4500000477	97.297297	1	6660.000000	0.300000	1.700000	1.000000	37
i1	75.819	3.4500000477	102.857143	1	6300.000000	0.300000	1.700000	1.000000	35
i1	75.7722	3.4500000477	109.090909	1	5940.000000	0.300000	1.700000	1.000000	33
i1	75.7254	3.4500000477	116.129032	1	5580.000000	0.300000	1.700000	1.000000	31
i1	75.6786	3.4500000477	124.137931	1	5220.000000	0.300000	1.700000	1.000000	29
i1	75.6318	3.4500000477	133.333333	1	4860.000000	0.300000	1.700000	1.000000	27
i1	75.4914	3.4500000477	171.428571	1	3780.000000	0.300000	1.700000	1.000000	21
i1	75.351	3.4500000477	240.000000	1	2700.000000	0.300000	1.700000	1.000000	15
i1	75.2106	3.4500000477	400.000000	1	1620.000000	0.300000	1.700000	1.000000	9
i1	75.0702	3.4500000477	1200.000000	1	540.000000	0.300000	1.700000	1.000000	3
i1	75.0468	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	75.0936	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	75.1872	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	75.234	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	75.3276	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	75.3744	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	75.468	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	75.5148	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	75.6084	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	75.6552	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	75.702	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	75.7488	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	75.7956	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	75.8424	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	75.8892	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	75.936	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	75.9828	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	76.0296	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	76.0764	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	76.1232	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	76.17	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	76.2168	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	76.2636	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	76.3104	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	76.3572	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	76.404	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	76.4508	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	76.4976	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	76.5444	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	78.6075	3.4500000477	144.000000	1	4500.000000	0.300000	1.700000	1.000000	25
i1	78.4617	3.4500000477	189.473684	1	3420.000000	0.300000	1.700000	1.000000	19
i1	78.3159	3.4500000477	276.923077	1	2340.000000	0.300000	1.700000	1.000000	13
i1	78.1701	3.4500000477	514.285714	1	1260.000000	0.300000	1.700000	1.000000	7
i1	78.0243	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	78.0486	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	78.1458	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	78.1944	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	78.2916	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	78.3402	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	78.4374	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	78.486	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	78.5832	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	78.6318	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	82.6884	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	82.638	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	82.5876	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	82.5372	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	82.4868	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	82.4364	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	82.386	3.4500000477	65.454545	1	9900.000000	0.300000	1.700000	1.000000	55
i1	82.3356	3.4500000477	67.924528	1	9540.000000	0.300000	1.700000	1.000000	53
i1	82.2852	3.4500000477	70.588235	1	9180.000000	0.300000	1.700000	1.000000	51
i1	82.2348	3.4500000477	73.469388	1	8820.000000	0.300000	1.700000	1.000000	49
i1	82.1844	3.4500000477	76.595745	1	8460.000000	0.300000	1.700000	1.000000	47
i1	82.134	3.4500000477	80.000000	1	8100.000000	0.300000	1.700000	1.000000	45
i1	82.0836	3.4500000477	83.720930	1	7740.000000	0.300000	1.700000	1.000000	43
i1	82.0332	3.4500000477	87.804878	1	7380.000000	0.300000	1.700000	1.000000	41
i1	81.9828	3.4500000477	92.307692	1	7020.000000	0.300000	1.700000	1.000000	39
i1	81.9324	3.4500000477	97.297297	1	6660.000000	0.300000	1.700000	1.000000	37
i1	81.882	3.4500000477	102.857143	1	6300.000000	0.300000	1.700000	1.000000	35
i1	81.8316	3.4500000477	109.090909	1	5940.000000	0.300000	1.700000	1.000000	33
i1	81.7812	3.4500000477	116.129032	1	5580.000000	0.300000	1.700000	1.000000	31
i1	81.7308	3.4500000477	124.137931	1	5220.000000	0.300000	1.700000	1.000000	29
i1	81.5796	3.4500000477	156.521739	1	4140.000000	0.300000	1.700000	1.000000	23
i1	81.4284	3.4500000477	211.764706	1	3060.000000	0.300000	1.700000	1.000000	17
i1	81.2772	3.4500000477	327.272727	1	1980.000000	0.300000	1.700000	1.000000	11
i1	81.126	3.4500000477	720.000000	1	900.000000	0.300000	1.700000	1.000000	5
i1	81.0252	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	81.1008	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	81.1512	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	81.252	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	81.3024	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	81.4032	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	81.4536	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	81.5544	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	81.6048	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	81.7056	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	81.756	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	81.8064	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	81.8568	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	81.9072	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	81.9576	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	82.008	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	82.0584	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	82.1088	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	82.1592	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	82.2096	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	82.26	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	82.3104	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	82.3608	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	82.4112	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	82.4616	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	82.512	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	82.5624	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	82.6128	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	82.6632	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	84.7047	3.4500000477	133.333333	1	4860.000000	0.300000	1.700000	1.000000	27
i1	84.5481	3.4500000477	171.428571	1	3780.000000	0.300000	1.700000	1.000000	21
i1	84.3915	3.4500000477	240.000000	1	2700.000000	0.300000	1.700000	1.000000	15
i1	84.2349	3.4500000477	400.000000	1	1620.000000	0.300000	1.700000	1.000000	9
i1	84.0783	3.4500000477	1200.000000	1	540.000000	0.300000	1.700000	1.000000	3
i1	84.0522	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	84.1044	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	84.2088	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	84.261	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	84.3654	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	84.4176	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	84.522	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	84.5742	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	84.6786	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	84.7308	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	88.809	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	88.755	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	88.701	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	88.647	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	88.593	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	88.539	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	88.485	3.4500000477	65.454545	1	9900.000000	0.300000	1.700000	1.000000	55
i1	88.431	3.4500000477	67.924528	1	9540.000000	0.300000	1.700000	1.000000	53
i1	88.377	3.4500000477	70.588235	1	9180.000000	0.300000	1.700000	1.000000	51
i1	88.323	3.4500000477	73.469388	1	8820.000000	0.300000	1.700000	1.000000	49
i1	88.269	3.4500000477	76.595745	1	8460.000000	0.300000	1.700000	1.000000	47
i1	88.215	3.4500000477	80.000000	1	8100.000000	0.300000	1.700000	1.000000	45
i1	88.161	3.4500000477	83.720930	1	7740.000000	0.300000	1.700000	1.000000	43
i1	88.107	3.4500000477	87.804878	1	7380.000000	0.300000	1.700000	1.000000	41
i1	88.053	3.4500000477	92.307692	1	7020.000000	0.300000	1.700000	1.000000	39
i1	87.999	3.4500000477	97.297297	1	6660.000000	0.300000	1.700000	1.000000	37
i1	87.945	3.4500000477	102.857143	1	6300.000000	0.300000	1.700000	1.000000	35
i1	87.891	3.4500000477	109.090909	1	5940.000000	0.300000	1.700000	1.000000	33
i1	87.837	3.4500000477	116.129032	1	5580.000000	0.300000	1.700000	1.000000	31
i1	87.675	3.4500000477	144.000000	1	4500.000000	0.300000	1.700000	1.000000	25
i1	87.513	3.4500000477	189.473684	1	3420.000000	0.300000	1.700000	1.000000	19
i1	87.351	3.4500000477	276.923077	1	2340.000000	0.300000	1.700000	1.000000	13
i1	87.189	3.4500000477	514.285714	1	1260.000000	0.300000	1.700000	1.000000	7
i1	87.027	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	87.054	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	87.162	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	87.216	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	87.324	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	87.378	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	87.486	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	87.54	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	87.648	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	87.702	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	87.81	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	87.864	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	87.918	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	87.972	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	88.026	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	88.08	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	88.134	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	88.188	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	88.242	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	88.296	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	88.35	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	88.404	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	88.458	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	88.512	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	88.566	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	88.62	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	88.674	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	88.728	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	88.782	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	90.8091	3.4500000477	124.137931	1	5220.000000	0.300000	1.700000	1.000000	29
i1	90.6417	3.4500000477	156.521739	1	4140.000000	0.300000	1.700000	1.000000	23
i1	90.4743	3.4500000477	211.764706	1	3060.000000	0.300000	1.700000	1.000000	17
i1	90.3069	3.4500000477	327.272727	1	1980.000000	0.300000	1.700000	1.000000	11
i1	90.1395	3.4500000477	720.000000	1	900.000000	0.300000	1.700000	1.000000	5
i1	90.0279	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	90.1116	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	90.1674	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	90.279	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	90.3348	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	90.4464	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	90.5022	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	90.6138	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	90.6696	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	90.7812	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	90.837	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	94.9296	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	94.872	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	94.8144	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	94.7568	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	94.6992	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	94.6416	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	94.584	3.4500000477	65.454545	1	9900.000000	0.300000	1.700000	1.000000	55
i1	94.5264	3.4500000477	67.924528	1	9540.000000	0.300000	1.700000	1.000000	53
i1	94.4688	3.4500000477	70.588235	1	9180.000000	0.300000	1.700000	1.000000	51
i1	94.4112	3.4500000477	73.469388	1	8820.000000	0.300000	1.700000	1.000000	49
i1	94.3536	3.4500000477	76.595745	1	8460.000000	0.300000	1.700000	1.000000	47
i1	94.296	3.4500000477	80.000000	1	8100.000000	0.300000	1.700000	1.000000	45
i1	94.2384	3.4500000477	83.720930	1	7740.000000	0.300000	1.700000	1.000000	43
i1	94.1808	3.4500000477	87.804878	1	7380.000000	0.300000	1.700000	1.000000	41
i1	94.1232	3.4500000477	92.307692	1	7020.000000	0.300000	1.700000	1.000000	39
i1	94.0656	3.4500000477	97.297297	1	6660.000000	0.300000	1.700000	1.000000	37
i1	94.008	3.4500000477	102.857143	1	6300.000000	0.300000	1.700000	1.000000	35
i1	93.9504	3.4500000477	109.090909	1	5940.000000	0.300000	1.700000	1.000000	33
i1	93.7776	3.4500000477	133.333333	1	4860.000000	0.300000	1.700000	1.000000	27
i1	93.6048	3.4500000477	171.428571	1	3780.000000	0.300000	1.700000	1.000000	21
i1	93.432	3.4500000477	240.000000	1	2700.000000	0.300000	1.700000	1.000000	15
i1	93.2592	3.4500000477	400.000000	1	1620.000000	0.300000	1.700000	1.000000	9
i1	93.0864	3.4500000477	1200.000000	1	540.000000	0.300000	1.700000	1.000000	3
i1	93.0576	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	93.1152	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	93.2304	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	93.288	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	93.4032	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	93.4608	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	93.576	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	93.6336	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	93.7488	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	93.8064	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	93.9216	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	93.9792	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	94.0368	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	94.0944	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	94.152	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	94.2096	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	94.2672	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	94.3248	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	94.3824	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	94.44	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	94.4976	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	94.5552	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	94.6128	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	94.6704	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	94.728	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	94.7856	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	94.8432	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	94.9008	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	96.9207	3.4500000477	116.129032	1	5580.000000	0.300000	1.700000	1.000000	31
i1	96.7425	3.4500000477	144.000000	1	4500.000000	0.300000	1.700000	1.000000	25
i1	96.5643	3.4500000477	189.473684	1	3420.000000	0.300000	1.700000	1.000000	19
i1	96.3861	3.4500000477	276.923077	1	2340.000000	0.300000	1.700000	1.000000	13
i1	96.2079	3.4500000477	514.285714	1	1260.000000	0.300000	1.700000	1.000000	7
i1	96.0297	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	96.0594	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	96.1782	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	96.2376	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	96.3564	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	96.4158	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	96.5346	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	96.594	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	96.7128	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	96.7722	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	96.891	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	96.9504	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	101.0502	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	100.989	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	100.9278	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	100.8666	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	100.8054	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	100.7442	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	100.683	3.4500000477	65.454545	1	9900.000000	0.300000	1.700000	1.000000	55
i1	100.6218	3.4500000477	67.924528	1	9540.000000	0.300000	1.700000	1.000000	53
i1	100.5606	3.4500000477	70.588235	1	9180.000000	0.300000	1.700000	1.000000	51
i1	100.4994	3.4500000477	73.469388	1	8820.000000	0.300000	1.700000	1.000000	49
i1	100.4382	3.4500000477	76.595745	1	8460.000000	0.300000	1.700000	1.000000	47
i1	100.377	3.4500000477	80.000000	1	8100.000000	0.300000	1.700000	1.000000	45
i1	100.3158	3.4500000477	83.720930	1	7740.000000	0.300000	1.700000	1.000000	43
i1	100.2546	3.4500000477	87.804878	1	7380.000000	0.300000	1.700000	1.000000	41
i1	100.1934	3.4500000477	92.307692	1	7020.000000	0.300000	1.700000	1.000000	39
i1	100.1322	3.4500000477	97.297297	1	6660.000000	0.300000	1.700000	1.000000	37
i1	100.071	3.4500000477	102.857143	1	6300.000000	0.300000	1.700000	1.000000	35
i1	99.8874	3.4500000477	124.137931	1	5220.000000	0.300000	1.700000	1.000000	29
i1	99.7038	3.4500000477	156.521739	1	4140.000000	0.300000	1.700000	1.000000	23
i1	99.5202	3.4500000477	211.764706	1	3060.000000	0.300000	1.700000	1.000000	17
i1	99.3366	3.4500000477	327.272727	1	1980.000000	0.300000	1.700000	1.000000	11
i1	99.153	3.4500000477	720.000000	1	900.000000	0.300000	1.700000	1.000000	5
i1	99.0306	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	99.1224	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	99.1836	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	99.306	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	99.3672	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	99.4896	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	99.5508	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	99.6732	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	99.7344	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	99.8568	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	99.918	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	100.0404	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	100.1016	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	100.1628	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	100.224	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	100.2852	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	100.3464	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	100.4076	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	100.4688	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	100.53	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	100.5912	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	100.6524	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	100.7136	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	100.7748	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	100.836	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	100.8972	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	100.9584	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	101.0196	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	103.0395	3.4500000477	109.090909	1	5940.000000	0.300000	1.700000	1.000000	33
i1	102.8505	3.4500000477	133.333333	1	4860.000000	0.300000	1.700000	1.000000	27
i1	102.6615	3.4500000477	171.428571	1	3780.000000	0.300000	1.700000	1.000000	21
i1	102.4725	3.4500000477	240.000000	1	2700.000000	0.300000	1.700000	1.000000	15
i1	102.2835	3.4500000477	400.000000	1	1620.000000	0.300000	1.700000	1.000000	9
i1	102.0945	3.4500000477	1200.000000	1	540.000000	0.300000	1.700000	1.000000	3
i1	102.063	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	102.126	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	102.252	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	102.315	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	102.441	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	102.504	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	102.63	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	102.693	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	102.819	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	102.882	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	103.008	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	103.071	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	107.1708	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	107.106	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	107.0412	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	106.9764	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	106.9116	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	106.8468	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	106.782	3.4500000477	65.454545	1	9900.000000	0.300000	1.700000	1.000000	55
i1	106.7172	3.4500000477	67.924528	1	9540.000000	0.300000	1.700000	1.000000	53
i1	106.6524	3.4500000477	70.588235	1	9180.000000	0.300000	1.700000	1.000000	51
i1	106.5876	3.4500000477	73.469388	1	8820.000000	0.300000	1.700000	1.000000	49
i1	106.5228	3.4500000477	76.595745	1	8460.000000	0.300000	1.700000	1.000000	47
i1	106.458	3.4500000477	80.000000	1	8100.000000	0.300000	1.700000	1.000000	45
i1	106.3932	3.4500000477	83.720930	1	7740.000000	0.300000	1.700000	1.000000	43
i1	106.3284	3.4500000477	87.804878	1	7380.000000	0.300000	1.700000	1.000000	41
i1	106.2636	3.4500000477	92.307692	1	7020.000000	0.300000	1.700000	1.000000	39
i1	106.1988	3.4500000477	97.297297	1	6660.000000	0.300000	1.700000	1.000000	37
i1	106.0044	3.4500000477	116.129032	1	5580.000000	0.300000	1.700000	1.000000	31
i1	105.81	3.4500000477	144.000000	1	4500.000000	0.300000	1.700000	1.000000	25
i1	105.6156	3.4500000477	189.473684	1	3420.000000	0.300000	1.700000	1.000000	19
i1	105.4212	3.4500000477	276.923077	1	2340.000000	0.300000	1.700000	1.000000	13
i1	105.2268	3.4500000477	514.285714	1	1260.000000	0.300000	1.700000	1.000000	7
i1	105.0324	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	105.0648	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	105.1944	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	105.2592	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	105.3888	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	105.4536	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	105.5832	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	105.648	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	105.7776	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	105.8424	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	105.972	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	106.0368	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	106.1664	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	106.2312	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	106.296	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	106.3608	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	106.4256	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	106.4904	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	106.5552	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	106.62	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	106.6848	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	106.7496	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	106.8144	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	106.8792	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	106.944	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	107.0088	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	107.0736	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	107.1384	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	109.1655	3.4500000477	102.857143	1	6300.000000	0.300000	1.700000	1.000000	35
i1	108.9657	3.4500000477	124.137931	1	5220.000000	0.300000	1.700000	1.000000	29
i1	108.7659	3.4500000477	156.521739	1	4140.000000	0.300000	1.700000	1.000000	23
i1	108.5661	3.4500000477	211.764706	1	3060.000000	0.300000	1.700000	1.000000	17
i1	108.3663	3.4500000477	327.272727	1	1980.000000	0.300000	1.700000	1.000000	11
i1	108.1665	3.4500000477	720.000000	1	900.000000	0.300000	1.700000	1.000000	5
i1	108.0333	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	108.1332	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	108.1998	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	108.333	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	108.3996	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	108.5328	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	108.5994	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	108.7326	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	108.7992	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	108.9324	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	108.999	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	109.1322	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	109.1988	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	113.2914	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	113.223	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	113.1546	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	113.0862	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	113.0178	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	112.9494	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	112.881	3.4500000477	65.454545	1	9900.000000	0.300000	1.700000	1.000000	55
i1	112.8126	3.4500000477	67.924528	1	9540.000000	0.300000	1.700000	1.000000	53
i1	112.7442	3.4500000477	70.588235	1	9180.000000	0.300000	1.700000	1.000000	51
i1	112.6758	3.4500000477	73.469388	1	8820.000000	0.300000	1.700000	1.000000	49
i1	112.6074	3.4500000477	76.595745	1	8460.000000	0.300000	1.700000	1.000000	47
i1	112.539	3.4500000477	80.000000	1	8100.000000	0.300000	1.700000	1.000000	45
i1	112.4706	3.4500000477	83.720930	1	7740.000000	0.300000	1.700000	1.000000	43
i1	112.4022	3.4500000477	87.804878	1	7380.000000	0.300000	1.700000	1.000000	41
i1	112.3338	3.4500000477	92.307692	1	7020.000000	0.300000	1.700000	1.000000	39
i1	112.1286	3.4500000477	109.090909	1	5940.000000	0.300000	1.700000	1.000000	33
i1	111.9234	3.4500000477	133.333333	1	4860.000000	0.300000	1.700000	1.000000	27
i1	111.7182	3.4500000477	171.428571	1	3780.000000	0.300000	1.700000	1.000000	21
i1	111.513	3.4500000477	240.000000	1	2700.000000	0.300000	1.700000	1.000000	15
i1	111.3078	3.4500000477	400.000000	1	1620.000000	0.300000	1.700000	1.000000	9
i1	111.1026	3.4500000477	1200.000000	1	540.000000	0.300000	1.700000	1.000000	3
i1	111.0684	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	111.1368	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	111.2736	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	111.342	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	111.4788	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	111.5472	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	111.684	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	111.7524	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	111.8892	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	111.9576	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	112.0944	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	112.1628	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	112.2996	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	112.368	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	112.4364	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	112.5048	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	112.5732	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	112.6416	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	112.71	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	112.7784	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	112.8468	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	112.9152	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	112.9836	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	113.052	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	113.1204	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	113.1888	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	113.2572	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	115.2987	3.4500000477	97.297297	1	6660.000000	0.300000	1.700000	1.000000	37
i1	115.0881	3.4500000477	116.129032	1	5580.000000	0.300000	1.700000	1.000000	31
i1	114.8775	3.4500000477	144.000000	1	4500.000000	0.300000	1.700000	1.000000	25
i1	114.6669	3.4500000477	189.473684	1	3420.000000	0.300000	1.700000	1.000000	19
i1	114.4563	3.4500000477	276.923077	1	2340.000000	0.300000	1.700000	1.000000	13
i1	114.2457	3.4500000477	514.285714	1	1260.000000	0.300000	1.700000	1.000000	7
i1	114.0351	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	114.0702	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	114.2106	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	114.2808	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	114.4212	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	114.4914	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	114.6318	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	114.702	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	114.8424	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	114.9126	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	115.053	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	115.1232	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	115.2636	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	115.3338	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	119.412	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	119.34	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	119.268	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	119.196	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	119.124	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	119.052	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	118.98	3.4500000477	65.454545	1	9900.000000	0.300000	1.700000	1.000000	55
i1	118.908	3.4500000477	67.924528	1	9540.000000	0.300000	1.700000	1.000000	53
i1	118.836	3.4500000477	70.588235	1	9180.000000	0.300000	1.700000	1.000000	51
i1	118.764	3.4500000477	73.469388	1	8820.000000	0.300000	1.700000	1.000000	49
i1	118.692	3.4500000477	76.595745	1	8460.000000	0.300000	1.700000	1.000000	47
i1	118.62	3.4500000477	80.000000	1	8100.000000	0.300000	1.700000	1.000000	45
i1	118.548	3.4500000477	83.720930	1	7740.000000	0.300000	1.700000	1.000000	43
i1	118.476	3.4500000477	87.804878	1	7380.000000	0.300000	1.700000	1.000000	41
i1	118.26	3.4500000477	102.857143	1	6300.000000	0.300000	1.700000	1.000000	35
i1	118.044	3.4500000477	124.137931	1	5220.000000	0.300000	1.700000	1.000000	29
i1	117.828	3.4500000477	156.521739	1	4140.000000	0.300000	1.700000	1.000000	23
i1	117.612	3.4500000477	211.764706	1	3060.000000	0.300000	1.700000	1.000000	17
i1	117.396	3.4500000477	327.272727	1	1980.000000	0.300000	1.700000	1.000000	11
i1	117.18	3.4500000477	720.000000	1	900.000000	0.300000	1.700000	1.000000	5
i1	117.036	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	117.144	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	117.216	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	117.36	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	117.432	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	117.576	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	117.648	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	117.792	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	117.864	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	118.008	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	118.08	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	118.224	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	118.296	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	118.44	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	118.512	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	118.584	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	118.656	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	118.728	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	118.8	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	118.872	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	118.944	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	119.016	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	119.088	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	119.16	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	119.232	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	119.304	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	119.376	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	121.4391	3.4500000477	92.307692	1	7020.000000	0.300000	1.700000	1.000000	39
i1	121.2177	3.4500000477	109.090909	1	5940.000000	0.300000	1.700000	1.000000	33
i1	120.9963	3.4500000477	133.333333	1	4860.000000	0.300000	1.700000	1.000000	27
i1	120.7749	3.4500000477	171.428571	1	3780.000000	0.300000	1.700000	1.000000	21
i1	120.5535	3.4500000477	240.000000	1	2700.000000	0.300000	1.700000	1.000000	15
i1	120.3321	3.4500000477	400.000000	1	1620.000000	0.300000	1.700000	1.000000	9
i1	120.1107	3.4500000477	1200.000000	1	540.000000	0.300000	1.700000	1.000000	3
i1	120.0738	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	120.1476	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	120.2952	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	120.369	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	120.5166	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	120.5904	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	120.738	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	120.8118	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	120.9594	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	121.0332	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	121.1808	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	121.2546	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	121.4022	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	121.476	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	125.5326	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	125.457	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	125.3814	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	125.3058	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	125.2302	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	125.1546	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	125.079	3.4500000477	65.454545	1	9900.000000	0.300000	1.700000	1.000000	55
i1	125.0034	3.4500000477	67.924528	1	9540.000000	0.300000	1.700000	1.000000	53
i1	124.9278	3.4500000477	70.588235	1	9180.000000	0.300000	1.700000	1.000000	51
i1	124.8522	3.4500000477	73.469388	1	8820.000000	0.300000	1.700000	1.000000	49
i1	124.7766	3.4500000477	76.595745	1	8460.000000	0.300000	1.700000	1.000000	47
i1	124.701	3.4500000477	80.000000	1	8100.000000	0.300000	1.700000	1.000000	45
i1	124.6254	3.4500000477	83.720930	1	7740.000000	0.300000	1.700000	1.000000	43
i1	124.3986	3.4500000477	97.297297	1	6660.000000	0.300000	1.700000	1.000000	37
i1	124.1718	3.4500000477	116.129032	1	5580.000000	0.300000	1.700000	1.000000	31
i1	123.945	3.4500000477	144.000000	1	4500.000000	0.300000	1.700000	1.000000	25
i1	123.7182	3.4500000477	189.473684	1	3420.000000	0.300000	1.700000	1.000000	19
i1	123.4914	3.4500000477	276.923077	1	2340.000000	0.300000	1.700000	1.000000	13
i1	123.2646	3.4500000477	514.285714	1	1260.000000	0.300000	1.700000	1.000000	7
i1	123.0378	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	123.0756	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	123.2268	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	123.3024	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	123.4536	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	123.5292	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	123.6804	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	123.756	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	123.9072	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	123.9828	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	124.134	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	124.2096	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	124.3608	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	124.4364	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	124.5876	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	124.6632	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	124.7388	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	124.8144	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	124.89	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	124.9656	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	125.0412	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	125.1168	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	125.1924	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	125.268	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	125.3436	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	125.4192	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	125.4948	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	127.5867	3.4500000477	87.804878	1	7380.000000	0.300000	1.700000	1.000000	41
i1	127.3545	3.4500000477	102.857143	1	6300.000000	0.300000	1.700000	1.000000	35
i1	127.1223	3.4500000477	124.137931	1	5220.000000	0.300000	1.700000	1.000000	29
i1	126.8901	3.4500000477	156.521739	1	4140.000000	0.300000	1.700000	1.000000	23
i1	126.6579	3.4500000477	211.764706	1	3060.000000	0.300000	1.700000	1.000000	17
i1	126.4257	3.4500000477	327.272727	1	1980.000000	0.300000	1.700000	1.000000	11
i1	126.1935	3.4500000477	720.000000	1	900.000000	0.300000	1.700000	1.000000	5
i1	126.0387	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	126.1548	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	126.2322	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	126.387	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	126.4644	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	126.6192	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	126.6966	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	126.8514	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	126.9288	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	127.0836	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	127.161	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	127.3158	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	127.3932	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	127.548	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	127.6254	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	131.6532	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	131.574	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	131.4948	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	131.4156	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	131.3364	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	131.2572	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	131.178	3.4500000477	65.454545	1	9900.000000	0.300000	1.700000	1.000000	55
i1	131.0988	3.4500000477	67.924528	1	9540.000000	0.300000	1.700000	1.000000	53
i1	131.0196	3.4500000477	70.588235	1	9180.000000	0.300000	1.700000	1.000000	51
i1	130.9404	3.4500000477	73.469388	1	8820.000000	0.300000	1.700000	1.000000	49
i1	130.8612	3.4500000477	76.595745	1	8460.000000	0.300000	1.700000	1.000000	47
i1	130.782	3.4500000477	80.000000	1	8100.000000	0.300000	1.700000	1.000000	45
i1	130.5444	3.4500000477	92.307692	1	7020.000000	0.300000	1.700000	1.000000	39
i1	130.3068	3.4500000477	109.090909	1	5940.000000	0.300000	1.700000	1.000000	33
i1	130.0692	3.4500000477	133.333333	1	4860.000000	0.300000	1.700000	1.000000	27
i1	129.8316	3.4500000477	171.428571	1	3780.000000	0.300000	1.700000	1.000000	21
i1	129.594	3.4500000477	240.000000	1	2700.000000	0.300000	1.700000	1.000000	15
i1	129.3564	3.4500000477	400.000000	1	1620.000000	0.300000	1.700000	1.000000	9
i1	129.1188	3.4500000477	1200.000000	1	540.000000	0.300000	1.700000	1.000000	3
i1	129.0792	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	129.1584	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	129.3168	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	129.396	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	129.5544	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	129.6336	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	129.792	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	129.8712	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	130.0296	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	130.1088	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	130.2672	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	130.3464	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	130.5048	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	130.584	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	130.7424	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	130.8216	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	130.9008	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	130.98	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	131.0592	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	131.1384	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	131.2176	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	131.2968	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	131.376	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	131.4552	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	131.5344	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	131.6136	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	133.7415	3.4500000477	83.720930	1	7740.000000	0.300000	1.700000	1.000000	43
i1	133.4985	3.4500000477	97.297297	1	6660.000000	0.300000	1.700000	1.000000	37
i1	133.2555	3.4500000477	116.129032	1	5580.000000	0.300000	1.700000	1.000000	31
i1	133.0125	3.4500000477	144.000000	1	4500.000000	0.300000	1.700000	1.000000	25
i1	132.7695	3.4500000477	189.473684	1	3420.000000	0.300000	1.700000	1.000000	19
i1	132.5265	3.4500000477	276.923077	1	2340.000000	0.300000	1.700000	1.000000	13
i1	132.2835	3.4500000477	514.285714	1	1260.000000	0.300000	1.700000	1.000000	7
i1	132.0405	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	132.081	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	132.243	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	132.324	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	132.486	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	132.567	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	132.729	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	132.81	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	132.972	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	133.053	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	133.215	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	133.296	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	133.458	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	133.539	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	133.701	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	133.782	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	137.7738	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	137.691	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	137.6082	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	137.5254	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	137.4426	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	137.3598	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	137.277	3.4500000477	65.454545	1	9900.000000	0.300000	1.700000	1.000000	55
i1	137.1942	3.4500000477	67.924528	1	9540.000000	0.300000	1.700000	1.000000	53
i1	137.1114	3.4500000477	70.588235	1	9180.000000	0.300000	1.700000	1.000000	51
i1	137.0286	3.4500000477	73.469388	1	8820.000000	0.300000	1.700000	1.000000	49
i1	136.9458	3.4500000477	76.595745	1	8460.000000	0.300000	1.700000	1.000000	47
i1	136.6974	3.4500000477	87.804878	1	7380.000000	0.300000	1.700000	1.000000	41
i1	136.449	3.4500000477	102.857143	1	6300.000000	0.300000	1.700000	1.000000	35
i1	136.2006	3.4500000477	124.137931	1	5220.000000	0.300000	1.700000	1.000000	29
i1	135.9522	3.4500000477	156.521739	1	4140.000000	0.300000	1.700000	1.000000	23
i1	135.7038	3.4500000477	211.764706	1	3060.000000	0.300000	1.700000	1.000000	17
i1	135.4554	3.4500000477	327.272727	1	1980.000000	0.300000	1.700000	1.000000	11
i1	135.207	3.4500000477	720.000000	1	900.000000	0.300000	1.700000	1.000000	5
i1	135.0414	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	135.1656	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	135.2484	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	135.414	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	135.4968	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	135.6624	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	135.7452	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	135.9108	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	135.9936	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	136.1592	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	136.242	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	136.4076	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	136.4904	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	136.656	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	136.7388	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	136.9044	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	136.9872	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	137.07	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	137.1528	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	137.2356	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	137.3184	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	137.4012	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	137.484	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	137.5668	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	137.6496	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	137.7324	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	139.9035	3.4500000477	80.000000	1	8100.000000	0.300000	1.700000	1.000000	45
i1	139.6497	3.4500000477	92.307692	1	7020.000000	0.300000	1.700000	1.000000	39
i1	139.3959	3.4500000477	109.090909	1	5940.000000	0.300000	1.700000	1.000000	33
i1	139.1421	3.4500000477	133.333333	1	4860.000000	0.300000	1.700000	1.000000	27
i1	138.8883	3.4500000477	171.428571	1	3780.000000	0.300000	1.700000	1.000000	21
i1	138.6345	3.4500000477	240.000000	1	2700.000000	0.300000	1.700000	1.000000	15
i1	138.3807	3.4500000477	400.000000	1	1620.000000	0.300000	1.700000	1.000000	9
i1	138.1269	3.4500000477	1200.000000	1	540.000000	0.300000	1.700000	1.000000	3
i1	138.0846	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	138.1692	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	138.3384	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	138.423	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	138.5922	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	138.6768	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	138.846	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	138.9306	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	139.0998	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	139.1844	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	139.3536	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	139.4382	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	139.6074	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	139.692	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	139.8612	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	139.9458	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	143.8944	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	143.808	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	143.7216	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	143.6352	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	143.5488	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	143.4624	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	143.376	3.4500000477	65.454545	1	9900.000000	0.300000	1.700000	1.000000	55
i1	143.2896	3.4500000477	67.924528	1	9540.000000	0.300000	1.700000	1.000000	53
i1	143.2032	3.4500000477	70.588235	1	9180.000000	0.300000	1.700000	1.000000	51
i1	143.1168	3.4500000477	73.469388	1	8820.000000	0.300000	1.700000	1.000000	49
i1	142.8576	3.4500000477	83.720930	1	7740.000000	0.300000	1.700000	1.000000	43
i1	142.5984	3.4500000477	97.297297	1	6660.000000	0.300000	1.700000	1.000000	37
i1	142.3392	3.4500000477	116.129032	1	5580.000000	0.300000	1.700000	1.000000	31
i1	142.08	3.4500000477	144.000000	1	4500.000000	0.300000	1.700000	1.000000	25
i1	141.8208	3.4500000477	189.473684	1	3420.000000	0.300000	1.700000	1.000000	19
i1	141.5616	3.4500000477	276.923077	1	2340.000000	0.300000	1.700000	1.000000	13
i1	141.3024	3.4500000477	514.285714	1	1260.000000	0.300000	1.700000	1.000000	7
i1	141.0432	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	141.0864	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	141.2592	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	141.3456	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	141.5184	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	141.6048	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	141.7776	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	141.864	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	142.0368	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	142.1232	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	142.296	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	142.3824	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	142.5552	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	142.6416	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	142.8144	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	142.9008	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	143.0736	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	143.16	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	143.2464	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	143.3328	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	143.4192	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	143.5056	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	143.592	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	143.6784	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	143.7648	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	143.8512	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	146.0727	3.4500000477	76.595745	1	8460.000000	0.300000	1.700000	1.000000	47
i1	145.8081	3.4500000477	87.804878	1	7380.000000	0.300000	1.700000	1.000000	41
i1	145.5435	3.4500000477	102.857143	1	6300.000000	0.300000	1.700000	1.000000	35
i1	145.2789	3.4500000477	124.137931	1	5220.000000	0.300000	1.700000	1.000000	29
i1	145.0143	3.4500000477	156.521739	1	4140.000000	0.300000	1.700000	1.000000	23
i1	144.7497	3.4500000477	211.764706	1	3060.000000	0.300000	1.700000	1.000000	17
i1	144.4851	3.4500000477	327.272727	1	1980.000000	0.300000	1.700000	1.000000	11
i1	144.2205	3.4500000477	720.000000	1	900.000000	0.300000	1.700000	1.000000	5
i1	144.0441	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	144.1764	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	144.2646	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	144.441	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	144.5292	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	144.7056	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	144.7938	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	144.9702	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	145.0584	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	145.2348	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	145.323	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	145.4994	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	145.5876	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	145.764	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	145.8522	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	146.0286	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	146.1168	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	150.015	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	149.925	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	149.835	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	149.745	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	149.655	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	149.565	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	149.475	3.4500000477	65.454545	1	9900.000000	0.300000	1.700000	1.000000	55
i1	149.385	3.4500000477	67.924528	1	9540.000000	0.300000	1.700000	1.000000	53
i1	149.295	3.4500000477	70.588235	1	9180.000000	0.300000	1.700000	1.000000	51
i1	149.025	3.4500000477	80.000000	1	8100.000000	0.300000	1.700000	1.000000	45
i1	148.755	3.4500000477	92.307692	1	7020.000000	0.300000	1.700000	1.000000	39
i1	148.485	3.4500000477	109.090909	1	5940.000000	0.300000	1.700000	1.000000	33
i1	148.215	3.4500000477	133.333333	1	4860.000000	0.300000	1.700000	1.000000	27
i1	147.945	3.4500000477	171.428571	1	3780.000000	0.300000	1.700000	1.000000	21
i1	147.675	3.4500000477	240.000000	1	2700.000000	0.300000	1.700000	1.000000	15
i1	147.405	3.4500000477	400.000000	1	1620.000000	0.300000	1.700000	1.000000	9
i1	147.135	3.4500000477	1200.000000	1	540.000000	0.300000	1.700000	1.000000	3
i1	147.09	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	147.18	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	147.36	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	147.45	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	147.63	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	147.72	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	147.9	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	147.99	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	148.17	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	148.26	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	148.44	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	148.53	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	148.71	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	148.8	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	148.98	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	149.07	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	149.25	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	149.34	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	149.43	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	149.52	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	149.61	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	149.7	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	149.79	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	149.88	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	149.97	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	152.2491	3.4500000477	73.469388	1	8820.000000	0.300000	1.700000	1.000000	49
i1	151.9737	3.4500000477	83.720930	1	7740.000000	0.300000	1.700000	1.000000	43
i1	151.6983	3.4500000477	97.297297	1	6660.000000	0.300000	1.700000	1.000000	37
i1	151.4229	3.4500000477	116.129032	1	5580.000000	0.300000	1.700000	1.000000	31
i1	151.1475	3.4500000477	144.000000	1	4500.000000	0.300000	1.700000	1.000000	25
i1	150.8721	3.4500000477	189.473684	1	3420.000000	0.300000	1.700000	1.000000	19
i1	150.5967	3.4500000477	276.923077	1	2340.000000	0.300000	1.700000	1.000000	13
i1	150.3213	3.4500000477	514.285714	1	1260.000000	0.300000	1.700000	1.000000	7
i1	150.0459	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	150.0918	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	150.2754	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	150.3672	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	150.5508	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	150.6426	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	150.8262	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	150.918	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	151.1016	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	151.1934	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	151.377	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	151.4688	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	151.6524	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	151.7442	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	151.9278	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	152.0196	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	152.2032	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	152.295	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	156.1356	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	156.042	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	155.9484	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	155.8548	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	155.7612	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	155.6676	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	155.574	3.4500000477	65.454545	1	9900.000000	0.300000	1.700000	1.000000	55
i1	155.4804	3.4500000477	67.924528	1	9540.000000	0.300000	1.700000	1.000000	53
i1	155.1996	3.4500000477	76.595745	1	8460.000000	0.300000	1.700000	1.000000	47
i1	154.9188	3.4500000477	87.804878	1	7380.000000	0.300000	1.700000	1.000000	41
i1	154.638	3.4500000477	102.857143	1	6300.000000	0.300000	1.700000	1.000000	35
i1	154.3572	3.4500000477	124.137931	1	5220.000000	0.300000	1.700000	1.000000	29
i1	154.0764	3.4500000477	156.521739	1	4140.000000	0.300000	1.700000	1.000000	23
i1	153.7956	3.4500000477	211.764706	1	3060.000000	0.300000	1.700000	1.000000	17
i1	153.5148	3.4500000477	327.272727	1	1980.000000	0.300000	1.700000	1.000000	11
i1	153.234	3.4500000477	720.000000	1	900.000000	0.300000	1.700000	1.000000	5
i1	153.0468	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	153.1872	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	153.2808	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	153.468	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	153.5616	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	153.7488	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	153.8424	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	154.0296	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	154.1232	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	154.3104	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	154.404	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	154.5912	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	154.6848	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	154.872	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	154.9656	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	155.1528	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	155.2464	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	155.4336	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	155.5272	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	155.6208	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	155.7144	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	155.808	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	155.9016	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	155.9952	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	156.0888	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	158.4327	3.4500000477	70.588235	1	9180.000000	0.300000	1.700000	1.000000	51
i1	158.1465	3.4500000477	80.000000	1	8100.000000	0.300000	1.700000	1.000000	45
i1	157.8603	3.4500000477	92.307692	1	7020.000000	0.300000	1.700000	1.000000	39
i1	157.5741	3.4500000477	109.090909	1	5940.000000	0.300000	1.700000	1.000000	33
i1	157.2879	3.4500000477	133.333333	1	4860.000000	0.300000	1.700000	1.000000	27
i1	157.0017	3.4500000477	171.428571	1	3780.000000	0.300000	1.700000	1.000000	21
i1	156.7155	3.4500000477	240.000000	1	2700.000000	0.300000	1.700000	1.000000	15
i1	156.4293	3.4500000477	400.000000	1	1620.000000	0.300000	1.700000	1.000000	9
i1	156.1431	3.4500000477	1200.000000	1	540.000000	0.300000	1.700000	1.000000	3
i1	156.0954	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	156.1908	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	156.3816	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	156.477	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	156.6678	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	156.7632	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	156.954	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	157.0494	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	157.2402	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	157.3356	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	157.5264	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	157.6218	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	157.8126	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	157.908	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	158.0988	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	158.1942	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	158.385	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	158.4804	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	162.2562	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	162.159	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	162.0618	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	161.9646	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	161.8674	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	161.7702	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	161.673	3.4500000477	65.454545	1	9900.000000	0.300000	1.700000	1.000000	55
i1	161.3814	3.4500000477	73.469388	1	8820.000000	0.300000	1.700000	1.000000	49
i1	161.0898	3.4500000477	83.720930	1	7740.000000	0.300000	1.700000	1.000000	43
i1	160.7982	3.4500000477	97.297297	1	6660.000000	0.300000	1.700000	1.000000	37
i1	160.5066	3.4500000477	116.129032	1	5580.000000	0.300000	1.700000	1.000000	31
i1	160.215	3.4500000477	144.000000	1	4500.000000	0.300000	1.700000	1.000000	25
i1	159.9234	3.4500000477	189.473684	1	3420.000000	0.300000	1.700000	1.000000	19
i1	159.6318	3.4500000477	276.923077	1	2340.000000	0.300000	1.700000	1.000000	13
i1	159.3402	3.4500000477	514.285714	1	1260.000000	0.300000	1.700000	1.000000	7
i1	159.0486	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	159.0972	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	159.2916	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	159.3888	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	159.5832	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	159.6804	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	159.8748	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	159.972	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	160.1664	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	160.2636	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	160.458	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	160.5552	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	160.7496	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	160.8468	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	161.0412	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	161.1384	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	161.3328	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	161.43	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	161.6244	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	161.7216	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	161.8188	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	161.916	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	162.0132	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	162.1104	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	162.2076	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	164.6235	3.4500000477	67.924528	1	9540.000000	0.300000	1.700000	1.000000	53
i1	164.3265	3.4500000477	76.595745	1	8460.000000	0.300000	1.700000	1.000000	47
i1	164.0295	3.4500000477	87.804878	1	7380.000000	0.300000	1.700000	1.000000	41
i1	163.7325	3.4500000477	102.857143	1	6300.000000	0.300000	1.700000	1.000000	35
i1	163.4355	3.4500000477	124.137931	1	5220.000000	0.300000	1.700000	1.000000	29
i1	163.1385	3.4500000477	156.521739	1	4140.000000	0.300000	1.700000	1.000000	23
i1	162.8415	3.4500000477	211.764706	1	3060.000000	0.300000	1.700000	1.000000	17
i1	162.5445	3.4500000477	327.272727	1	1980.000000	0.300000	1.700000	1.000000	11
i1	162.2475	3.4500000477	720.000000	1	900.000000	0.300000	1.700000	1.000000	5
i1	162.0495	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	162.198	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	162.297	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	162.495	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	162.594	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	162.792	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	162.891	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	163.089	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	163.188	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	163.386	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	163.485	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	163.683	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	163.782	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	163.98	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	164.079	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	164.277	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	164.376	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	164.574	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	164.673	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	168.3768	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	168.276	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	168.1752	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	168.0744	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	167.9736	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	167.8728	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	167.5704	3.4500000477	70.588235	1	9180.000000	0.300000	1.700000	1.000000	51
i1	167.268	3.4500000477	80.000000	1	8100.000000	0.300000	1.700000	1.000000	45
i1	166.9656	3.4500000477	92.307692	1	7020.000000	0.300000	1.700000	1.000000	39
i1	166.6632	3.4500000477	109.090909	1	5940.000000	0.300000	1.700000	1.000000	33
i1	166.3608	3.4500000477	133.333333	1	4860.000000	0.300000	1.700000	1.000000	27
i1	166.0584	3.4500000477	171.428571	1	3780.000000	0.300000	1.700000	1.000000	21
i1	165.756	3.4500000477	240.000000	1	2700.000000	0.300000	1.700000	1.000000	15
i1	165.4536	3.4500000477	400.000000	1	1620.000000	0.300000	1.700000	1.000000	9
i1	165.1512	3.4500000477	1200.000000	1	540.000000	0.300000	1.700000	1.000000	3
i1	165.1008	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	165.2016	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	165.4032	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	165.504	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	165.7056	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	165.8064	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	166.008	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	166.1088	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	166.3104	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	166.4112	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	166.6128	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	166.7136	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	166.9152	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	167.016	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	167.2176	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	167.3184	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	167.52	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	167.6208	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	167.8224	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	167.9232	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	168.024	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	168.1248	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	168.2256	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	168.3264	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	170.8215	3.4500000477	65.454545	1	9900.000000	0.300000	1.700000	1.000000	55
i1	170.5137	3.4500000477	73.469388	1	8820.000000	0.300000	1.700000	1.000000	49
i1	170.2059	3.4500000477	83.720930	1	7740.000000	0.300000	1.700000	1.000000	43
i1	169.8981	3.4500000477	97.297297	1	6660.000000	0.300000	1.700000	1.000000	37
i1	169.5903	3.4500000477	116.129032	1	5580.000000	0.300000	1.700000	1.000000	31
i1	169.2825	3.4500000477	144.000000	1	4500.000000	0.300000	1.700000	1.000000	25
i1	168.9747	3.4500000477	189.473684	1	3420.000000	0.300000	1.700000	1.000000	19
i1	168.6669	3.4500000477	276.923077	1	2340.000000	0.300000	1.700000	1.000000	13
i1	168.3591	3.4500000477	514.285714	1	1260.000000	0.300000	1.700000	1.000000	7
i1	168.0513	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	168.1026	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	168.3078	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	168.4104	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	168.6156	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	168.7182	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	168.9234	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	169.026	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	169.2312	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	169.3338	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	169.539	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	169.6416	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	169.8468	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	169.9494	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	170.1546	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	170.2572	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	170.4624	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	170.565	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	170.7702	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	170.8728	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	174.4974	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	174.393	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	174.2886	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	174.1842	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	174.0798	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	173.7666	3.4500000477	67.924528	1	9540.000000	0.300000	1.700000	1.000000	53
i1	173.4534	3.4500000477	76.595745	1	8460.000000	0.300000	1.700000	1.000000	47
i1	173.1402	3.4500000477	87.804878	1	7380.000000	0.300000	1.700000	1.000000	41
i1	172.827	3.4500000477	102.857143	1	6300.000000	0.300000	1.700000	1.000000	35
i1	172.5138	3.4500000477	124.137931	1	5220.000000	0.300000	1.700000	1.000000	29
i1	172.2006	3.4500000477	156.521739	1	4140.000000	0.300000	1.700000	1.000000	23
i1	171.8874	3.4500000477	211.764706	1	3060.000000	0.300000	1.700000	1.000000	17
i1	171.5742	3.4500000477	327.272727	1	1980.000000	0.300000	1.700000	1.000000	11
i1	171.261	3.4500000477	720.000000	1	900.000000	0.300000	1.700000	1.000000	5
i1	171.0522	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	171.2088	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	171.3132	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	171.522	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	171.6264	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	171.8352	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	171.9396	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	172.1484	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	172.2528	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	172.4616	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	172.566	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	172.7748	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	172.8792	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	173.088	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	173.1924	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	173.4012	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	173.5056	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	173.7144	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	173.8188	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	174.0276	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	174.132	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	174.2364	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	174.3408	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	174.4452	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	177.0267	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	176.7081	3.4500000477	70.588235	1	9180.000000	0.300000	1.700000	1.000000	51
i1	176.3895	3.4500000477	80.000000	1	8100.000000	0.300000	1.700000	1.000000	45
i1	176.0709	3.4500000477	92.307692	1	7020.000000	0.300000	1.700000	1.000000	39
i1	175.7523	3.4500000477	109.090909	1	5940.000000	0.300000	1.700000	1.000000	33
i1	175.4337	3.4500000477	133.333333	1	4860.000000	0.300000	1.700000	1.000000	27
i1	175.1151	3.4500000477	171.428571	1	3780.000000	0.300000	1.700000	1.000000	21
i1	174.7965	3.4500000477	240.000000	1	2700.000000	0.300000	1.700000	1.000000	15
i1	174.4779	3.4500000477	400.000000	1	1620.000000	0.300000	1.700000	1.000000	9
i1	174.1593	3.4500000477	1200.000000	1	540.000000	0.300000	1.700000	1.000000	3
i1	174.1062	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	174.2124	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	174.4248	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	174.531	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	174.7434	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	174.8496	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	175.062	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	175.1682	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	175.3806	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	175.4868	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	175.6992	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	175.8054	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	176.0178	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	176.124	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	176.3364	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	176.4426	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	176.655	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	176.7612	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	176.9736	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	177.0798	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	180.618	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	180.51	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	180.402	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	180.294	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	179.97	3.4500000477	65.454545	1	9900.000000	0.300000	1.700000	1.000000	55
i1	179.646	3.4500000477	73.469388	1	8820.000000	0.300000	1.700000	1.000000	49
i1	179.322	3.4500000477	83.720930	1	7740.000000	0.300000	1.700000	1.000000	43
i1	178.998	3.4500000477	97.297297	1	6660.000000	0.300000	1.700000	1.000000	37
i1	178.674	3.4500000477	116.129032	1	5580.000000	0.300000	1.700000	1.000000	31
i1	178.35	3.4500000477	144.000000	1	4500.000000	0.300000	1.700000	1.000000	25
i1	178.026	3.4500000477	189.473684	1	3420.000000	0.300000	1.700000	1.000000	19
i1	177.702	3.4500000477	276.923077	1	2340.000000	0.300000	1.700000	1.000000	13
i1	177.378	3.4500000477	514.285714	1	1260.000000	0.300000	1.700000	1.000000	7
i1	177.054	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	177.108	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	177.324	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	177.432	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	177.648	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	177.756	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	177.972	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	178.08	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	178.296	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	178.404	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	178.62	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	178.728	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	178.944	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	179.052	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	179.268	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	179.376	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	179.592	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	179.7	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	179.916	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	180.024	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	180.24	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	180.348	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	180.456	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	180.564	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	183.2391	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	182.9097	3.4500000477	67.924528	1	9540.000000	0.300000	1.700000	1.000000	53
i1	182.5803	3.4500000477	76.595745	1	8460.000000	0.300000	1.700000	1.000000	47
i1	182.2509	3.4500000477	87.804878	1	7380.000000	0.300000	1.700000	1.000000	41
i1	181.9215	3.4500000477	102.857143	1	6300.000000	0.300000	1.700000	1.000000	35
i1	181.5921	3.4500000477	124.137931	1	5220.000000	0.300000	1.700000	1.000000	29
i1	181.2627	3.4500000477	156.521739	1	4140.000000	0.300000	1.700000	1.000000	23
i1	180.9333	3.4500000477	211.764706	1	3060.000000	0.300000	1.700000	1.000000	17
i1	180.6039	3.4500000477	327.272727	1	1980.000000	0.300000	1.700000	1.000000	11
i1	180.2745	3.4500000477	720.000000	1	900.000000	0.300000	1.700000	1.000000	5
i1	180.0549	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	180.2196	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	180.3294	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	180.549	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	180.6588	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	180.8784	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	180.9882	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	181.2078	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	181.3176	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	181.5372	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	181.647	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	181.8666	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	181.9764	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	182.196	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	182.3058	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	182.5254	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	182.6352	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	182.8548	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	182.9646	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	183.1842	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	183.294	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	186.7386	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	186.627	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	186.5154	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	186.1806	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	185.8458	3.4500000477	70.588235	1	9180.000000	0.300000	1.700000	1.000000	51
i1	185.511	3.4500000477	80.000000	1	8100.000000	0.300000	1.700000	1.000000	45
i1	185.1762	3.4500000477	92.307692	1	7020.000000	0.300000	1.700000	1.000000	39
i1	184.8414	3.4500000477	109.090909	1	5940.000000	0.300000	1.700000	1.000000	33
i1	184.5066	3.4500000477	133.333333	1	4860.000000	0.300000	1.700000	1.000000	27
i1	184.1718	3.4500000477	171.428571	1	3780.000000	0.300000	1.700000	1.000000	21
i1	183.837	3.4500000477	240.000000	1	2700.000000	0.300000	1.700000	1.000000	15
i1	183.5022	3.4500000477	400.000000	1	1620.000000	0.300000	1.700000	1.000000	9
i1	183.1674	3.4500000477	1200.000000	1	540.000000	0.300000	1.700000	1.000000	3
i1	183.1116	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	183.2232	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	183.4464	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	183.558	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	183.7812	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	183.8928	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	184.116	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	184.2276	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	184.4508	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	184.5624	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	184.7856	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	184.8972	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	185.1204	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	185.232	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	185.4552	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	185.5668	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	185.79	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	185.9016	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	186.1248	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	186.2364	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	186.4596	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	186.5712	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	186.6828	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	189.4587	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	189.1185	3.4500000477	65.454545	1	9900.000000	0.300000	1.700000	1.000000	55
i1	188.7783	3.4500000477	73.469388	1	8820.000000	0.300000	1.700000	1.000000	49
i1	188.4381	3.4500000477	83.720930	1	7740.000000	0.300000	1.700000	1.000000	43
i1	188.0979	3.4500000477	97.297297	1	6660.000000	0.300000	1.700000	1.000000	37
i1	187.7577	3.4500000477	116.129032	1	5580.000000	0.300000	1.700000	1.000000	31
i1	187.4175	3.4500000477	144.000000	1	4500.000000	0.300000	1.700000	1.000000	25
i1	187.0773	3.4500000477	189.473684	1	3420.000000	0.300000	1.700000	1.000000	19
i1	186.7371	3.4500000477	276.923077	1	2340.000000	0.300000	1.700000	1.000000	13
i1	186.3969	3.4500000477	514.285714	1	1260.000000	0.300000	1.700000	1.000000	7
i1	186.0567	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	186.1134	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	186.3402	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	186.4536	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	186.6804	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	186.7938	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	187.0206	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	187.134	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	187.3608	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	187.4742	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	187.701	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	187.8144	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	188.0412	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	188.1546	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	188.3814	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	188.4948	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	188.7216	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	188.835	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	189.0618	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	189.1752	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	189.402	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	189.5154	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	192.8592	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	192.744	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	192.3984	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	192.0528	3.4500000477	67.924528	1	9540.000000	0.300000	1.700000	1.000000	53
i1	191.7072	3.4500000477	76.595745	1	8460.000000	0.300000	1.700000	1.000000	47
i1	191.3616	3.4500000477	87.804878	1	7380.000000	0.300000	1.700000	1.000000	41
i1	191.016	3.4500000477	102.857143	1	6300.000000	0.300000	1.700000	1.000000	35
i1	190.6704	3.4500000477	124.137931	1	5220.000000	0.300000	1.700000	1.000000	29
i1	190.3248	3.4500000477	156.521739	1	4140.000000	0.300000	1.700000	1.000000	23
i1	189.9792	3.4500000477	211.764706	1	3060.000000	0.300000	1.700000	1.000000	17
i1	189.6336	3.4500000477	327.272727	1	1980.000000	0.300000	1.700000	1.000000	11
i1	189.288	3.4500000477	720.000000	1	900.000000	0.300000	1.700000	1.000000	5
i1	189.0576	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	189.2304	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	189.3456	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	189.576	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	189.6912	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	189.9216	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	190.0368	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	190.2672	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	190.3824	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	190.6128	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	190.728	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	190.9584	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	191.0736	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	191.304	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	191.4192	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	191.6496	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	191.7648	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	191.9952	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	192.1104	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	192.3408	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	192.456	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	192.6864	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	192.8016	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	195.6855	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	195.3345	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	194.9835	3.4500000477	70.588235	1	9180.000000	0.300000	1.700000	1.000000	51
i1	194.6325	3.4500000477	80.000000	1	8100.000000	0.300000	1.700000	1.000000	45
i1	194.2815	3.4500000477	92.307692	1	7020.000000	0.300000	1.700000	1.000000	39
i1	193.9305	3.4500000477	109.090909	1	5940.000000	0.300000	1.700000	1.000000	33
i1	193.5795	3.4500000477	133.333333	1	4860.000000	0.300000	1.700000	1.000000	27
i1	193.2285	3.4500000477	171.428571	1	3780.000000	0.300000	1.700000	1.000000	21
i1	192.8775	3.4500000477	240.000000	1	2700.000000	0.300000	1.700000	1.000000	15
i1	192.5265	3.4500000477	400.000000	1	1620.000000	0.300000	1.700000	1.000000	9
i1	192.1755	3.4500000477	1200.000000	1	540.000000	0.300000	1.700000	1.000000	3
i1	192.117	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	192.234	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	192.468	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	192.585	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	192.819	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	192.936	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	193.17	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	193.287	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	193.521	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	193.638	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	193.872	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	193.989	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	194.223	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	194.34	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	194.574	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	194.691	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	194.925	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	195.042	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	195.276	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	195.393	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	195.627	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	195.744	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	198.9798	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	198.6234	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	198.267	3.4500000477	65.454545	1	9900.000000	0.300000	1.700000	1.000000	55
i1	197.9106	3.4500000477	73.469388	1	8820.000000	0.300000	1.700000	1.000000	49
i1	197.5542	3.4500000477	83.720930	1	7740.000000	0.300000	1.700000	1.000000	43
i1	197.1978	3.4500000477	97.297297	1	6660.000000	0.300000	1.700000	1.000000	37
i1	196.8414	3.4500000477	116.129032	1	5580.000000	0.300000	1.700000	1.000000	31
i1	196.485	3.4500000477	144.000000	1	4500.000000	0.300000	1.700000	1.000000	25
i1	196.1286	3.4500000477	189.473684	1	3420.000000	0.300000	1.700000	1.000000	19
i1	195.7722	3.4500000477	276.923077	1	2340.000000	0.300000	1.700000	1.000000	13
i1	195.4158	3.4500000477	514.285714	1	1260.000000	0.300000	1.700000	1.000000	7
i1	195.0594	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	195.1188	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	195.3564	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	195.4752	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	195.7128	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	195.8316	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	196.0692	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	196.188	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	196.4256	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	196.5444	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	196.782	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	196.9008	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	197.1384	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	197.2572	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	197.4948	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	197.6136	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	197.8512	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	197.97	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	198.2076	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	198.3264	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	198.564	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	198.6828	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	198.9204	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	201.9195	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	201.5577	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	201.1959	3.4500000477	67.924528	1	9540.000000	0.300000	1.700000	1.000000	53
i1	200.8341	3.4500000477	76.595745	1	8460.000000	0.300000	1.700000	1.000000	47
i1	200.4723	3.4500000477	87.804878	1	7380.000000	0.300000	1.700000	1.000000	41
i1	200.1105	3.4500000477	102.857143	1	6300.000000	0.300000	1.700000	1.000000	35
i1	199.7487	3.4500000477	124.137931	1	5220.000000	0.300000	1.700000	1.000000	29
i1	199.3869	3.4500000477	156.521739	1	4140.000000	0.300000	1.700000	1.000000	23
i1	199.0251	3.4500000477	211.764706	1	3060.000000	0.300000	1.700000	1.000000	17
i1	198.6633	3.4500000477	327.272727	1	1980.000000	0.300000	1.700000	1.000000	11
i1	198.3015	3.4500000477	720.000000	1	900.000000	0.300000	1.700000	1.000000	5
i1	198.0603	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	198.2412	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	198.3618	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	198.603	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	198.7236	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	198.9648	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	199.0854	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	199.3266	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	199.4472	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	199.6884	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	199.809	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	200.0502	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	200.1708	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	200.412	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	200.5326	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	200.7738	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	200.8944	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	201.1356	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	201.2562	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	201.4974	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	201.618	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	201.8592	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	201.9798	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	205.1004	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	204.8556	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	204.4884	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	204.1212	3.4500000477	70.588235	1	9180.000000	0.300000	1.700000	1.000000	51
i1	203.754	3.4500000477	80.000000	1	8100.000000	0.300000	1.700000	1.000000	45
i1	203.3868	3.4500000477	92.307692	1	7020.000000	0.300000	1.700000	1.000000	39
i1	203.0196	3.4500000477	109.090909	1	5940.000000	0.300000	1.700000	1.000000	33
i1	202.6524	3.4500000477	133.333333	1	4860.000000	0.300000	1.700000	1.000000	27
i1	202.2852	3.4500000477	171.428571	1	3780.000000	0.300000	1.700000	1.000000	21
i1	201.918	3.4500000477	240.000000	1	2700.000000	0.300000	1.700000	1.000000	15
i1	201.5508	3.4500000477	400.000000	1	1620.000000	0.300000	1.700000	1.000000	9
i1	201.1836	3.4500000477	1200.000000	1	540.000000	0.300000	1.700000	1.000000	3
i1	201.1224	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	201.2448	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	201.4896	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	201.612	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	201.8568	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	201.9792	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	202.224	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	202.3464	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	202.5912	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	202.7136	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	202.9584	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	203.0808	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	203.3256	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	203.448	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	203.6928	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	203.8152	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	204.06	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	204.1824	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	204.4272	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	204.5496	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	204.7944	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	204.9168	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	208.0365	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	207.7881	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	207.4155	3.4500000477	65.454545	1	9900.000000	0.300000	1.700000	1.000000	55
i1	207.0429	3.4500000477	73.469388	1	8820.000000	0.300000	1.700000	1.000000	49
i1	206.6703	3.4500000477	83.720930	1	7740.000000	0.300000	1.700000	1.000000	43
i1	206.2977	3.4500000477	97.297297	1	6660.000000	0.300000	1.700000	1.000000	37
i1	205.9251	3.4500000477	116.129032	1	5580.000000	0.300000	1.700000	1.000000	31
i1	205.5525	3.4500000477	144.000000	1	4500.000000	0.300000	1.700000	1.000000	25
i1	205.1799	3.4500000477	189.473684	1	3420.000000	0.300000	1.700000	1.000000	19
i1	204.8073	3.4500000477	276.923077	1	2340.000000	0.300000	1.700000	1.000000	13
i1	204.4347	3.4500000477	514.285714	1	1260.000000	0.300000	1.700000	1.000000	7
i1	204.0621	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	204.1242	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	204.3726	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	204.4968	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	204.7452	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	204.8694	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	205.1178	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	205.242	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	205.4904	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	205.6146	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	205.863	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	205.9872	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	206.2356	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	206.3598	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	206.6082	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	206.7324	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	206.9808	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	207.105	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	207.3534	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	207.4776	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	207.726	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	207.8502	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	208.0986	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	211.221	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	210.969	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	210.717	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	210.339	3.4500000477	67.924528	1	9540.000000	0.300000	1.700000	1.000000	53
i1	209.961	3.4500000477	76.595745	1	8460.000000	0.300000	1.700000	1.000000	47
i1	209.583	3.4500000477	87.804878	1	7380.000000	0.300000	1.700000	1.000000	41
i1	209.205	3.4500000477	102.857143	1	6300.000000	0.300000	1.700000	1.000000	35
i1	208.827	3.4500000477	124.137931	1	5220.000000	0.300000	1.700000	1.000000	29
i1	208.449	3.4500000477	156.521739	1	4140.000000	0.300000	1.700000	1.000000	23
i1	208.071	3.4500000477	211.764706	1	3060.000000	0.300000	1.700000	1.000000	17
i1	207.693	3.4500000477	327.272727	1	1980.000000	0.300000	1.700000	1.000000	11
i1	207.315	3.4500000477	720.000000	1	900.000000	0.300000	1.700000	1.000000	5
i1	207.063	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	207.252	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	207.378	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	207.63	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	207.756	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	208.008	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	208.134	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	208.386	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	208.512	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	208.764	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	208.89	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	209.142	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	209.268	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	209.52	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	209.646	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	209.898	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	210.024	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	210.276	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	210.402	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	210.654	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	210.78	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	211.032	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	214.1535	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	213.8979	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	213.6423	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	213.2589	3.4500000477	70.588235	1	9180.000000	0.300000	1.700000	1.000000	51
i1	212.8755	3.4500000477	80.000000	1	8100.000000	0.300000	1.700000	1.000000	45
i1	212.4921	3.4500000477	92.307692	1	7020.000000	0.300000	1.700000	1.000000	39
i1	212.1087	3.4500000477	109.090909	1	5940.000000	0.300000	1.700000	1.000000	33
i1	211.7253	3.4500000477	133.333333	1	4860.000000	0.300000	1.700000	1.000000	27
i1	211.3419	3.4500000477	171.428571	1	3780.000000	0.300000	1.700000	1.000000	21
i1	210.9585	3.4500000477	240.000000	1	2700.000000	0.300000	1.700000	1.000000	15
i1	210.5751	3.4500000477	400.000000	1	1620.000000	0.300000	1.700000	1.000000	9
i1	210.1917	3.4500000477	1200.000000	1	540.000000	0.300000	1.700000	1.000000	3
i1	210.1278	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	210.2556	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	210.5112	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	210.639	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	210.8946	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	211.0224	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	211.278	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	211.4058	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	211.6614	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	211.7892	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	212.0448	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	212.1726	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	212.4282	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	212.556	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	212.8116	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	212.9394	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	213.195	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	213.3228	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	213.5784	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	213.7062	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	213.9618	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	214.2174	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	217.3416	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	217.0824	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	216.8232	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	216.564	3.4500000477	65.454545	1	9900.000000	0.300000	1.700000	1.000000	55
i1	216.1752	3.4500000477	73.469388	1	8820.000000	0.300000	1.700000	1.000000	49
i1	215.7864	3.4500000477	83.720930	1	7740.000000	0.300000	1.700000	1.000000	43
i1	215.3976	3.4500000477	97.297297	1	6660.000000	0.300000	1.700000	1.000000	37
i1	215.0088	3.4500000477	116.129032	1	5580.000000	0.300000	1.700000	1.000000	31
i1	214.62	3.4500000477	144.000000	1	4500.000000	0.300000	1.700000	1.000000	25
i1	214.2312	3.4500000477	189.473684	1	3420.000000	0.300000	1.700000	1.000000	19
i1	213.8424	3.4500000477	276.923077	1	2340.000000	0.300000	1.700000	1.000000	13
i1	213.4536	3.4500000477	514.285714	1	1260.000000	0.300000	1.700000	1.000000	7
i1	213.0648	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	213.1296	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	213.3888	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	213.5184	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	213.7776	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	213.9072	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	214.1664	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	214.296	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	214.5552	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	214.6848	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	214.944	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	215.0736	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	215.3328	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	215.4624	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	215.7216	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	215.8512	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	216.1104	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	216.24	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	216.4992	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	216.6288	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	216.888	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	217.1472	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	220.2705	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	220.0077	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	219.7449	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	219.4821	3.4500000477	67.924528	1	9540.000000	0.300000	1.700000	1.000000	53
i1	219.0879	3.4500000477	76.595745	1	8460.000000	0.300000	1.700000	1.000000	47
i1	218.6937	3.4500000477	87.804878	1	7380.000000	0.300000	1.700000	1.000000	41
i1	218.2995	3.4500000477	102.857143	1	6300.000000	0.300000	1.700000	1.000000	35
i1	217.9053	3.4500000477	124.137931	1	5220.000000	0.300000	1.700000	1.000000	29
i1	217.5111	3.4500000477	156.521739	1	4140.000000	0.300000	1.700000	1.000000	23
i1	217.1169	3.4500000477	211.764706	1	3060.000000	0.300000	1.700000	1.000000	17
i1	216.7227	3.4500000477	327.272727	1	1980.000000	0.300000	1.700000	1.000000	11
i1	216.3285	3.4500000477	720.000000	1	900.000000	0.300000	1.700000	1.000000	5
i1	216.0657	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	216.2628	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	216.3942	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	216.657	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	216.7884	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	217.0512	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	217.1826	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	217.4454	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	217.5768	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	217.8396	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	217.971	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	218.2338	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	218.3652	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	218.628	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	218.7594	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	219.0222	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	219.1536	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	219.4164	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	219.5478	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	219.8106	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	220.0734	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	220.3362	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	223.4622	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	223.1958	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	222.9294	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	222.663	3.4500000477	65.454545	1	9900.000000	0.300000	1.700000	1.000000	55
i1	222.3966	3.4500000477	70.588235	1	9180.000000	0.300000	1.700000	1.000000	51
i1	221.997	3.4500000477	80.000000	1	8100.000000	0.300000	1.700000	1.000000	45
i1	221.5974	3.4500000477	92.307692	1	7020.000000	0.300000	1.700000	1.000000	39
i1	221.1978	3.4500000477	109.090909	1	5940.000000	0.300000	1.700000	1.000000	33
i1	220.7982	3.4500000477	133.333333	1	4860.000000	0.300000	1.700000	1.000000	27
i1	220.3986	3.4500000477	171.428571	1	3780.000000	0.300000	1.700000	1.000000	21
i1	219.999	3.4500000477	240.000000	1	2700.000000	0.300000	1.700000	1.000000	15
i1	219.5994	3.4500000477	400.000000	1	1620.000000	0.300000	1.700000	1.000000	9
i1	219.1998	3.4500000477	1200.000000	1	540.000000	0.300000	1.700000	1.000000	3
i1	219.1332	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	219.2664	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	219.5328	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	219.666	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	219.9324	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	220.0656	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	220.332	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	220.4652	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	220.7316	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	220.8648	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	221.1312	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	221.2644	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	221.5308	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	221.664	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	221.9304	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	222.0636	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	222.33	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	222.4632	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	222.7296	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	222.996	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	223.2624	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	226.3875	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	226.1175	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	225.8475	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	225.5775	3.4500000477	67.924528	1	9540.000000	0.300000	1.700000	1.000000	53
i1	225.3075	3.4500000477	73.469388	1	8820.000000	0.300000	1.700000	1.000000	49
i1	224.9025	3.4500000477	83.720930	1	7740.000000	0.300000	1.700000	1.000000	43
i1	224.4975	3.4500000477	97.297297	1	6660.000000	0.300000	1.700000	1.000000	37
i1	224.0925	3.4500000477	116.129032	1	5580.000000	0.300000	1.700000	1.000000	31
i1	223.6875	3.4500000477	144.000000	1	4500.000000	0.300000	1.700000	1.000000	25
i1	223.2825	3.4500000477	189.473684	1	3420.000000	0.300000	1.700000	1.000000	19
i1	222.8775	3.4500000477	276.923077	1	2340.000000	0.300000	1.700000	1.000000	13
i1	222.4725	3.4500000477	514.285714	1	1260.000000	0.300000	1.700000	1.000000	7
i1	222.0675	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	222.135	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	222.405	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	222.54	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	222.81	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	222.945	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	223.215	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	223.35	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	223.62	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	223.755	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	224.025	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	224.16	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	224.43	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	224.565	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	224.835	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	224.97	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	225.24	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	225.375	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	225.645	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	225.915	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	226.185	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	226.455	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	229.5828	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	229.3092	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	229.0356	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	228.762	3.4500000477	65.454545	1	9900.000000	0.300000	1.700000	1.000000	55
i1	228.4884	3.4500000477	70.588235	1	9180.000000	0.300000	1.700000	1.000000	51
i1	228.2148	3.4500000477	76.595745	1	8460.000000	0.300000	1.700000	1.000000	47
i1	227.8044	3.4500000477	87.804878	1	7380.000000	0.300000	1.700000	1.000000	41
i1	227.394	3.4500000477	102.857143	1	6300.000000	0.300000	1.700000	1.000000	35
i1	226.9836	3.4500000477	124.137931	1	5220.000000	0.300000	1.700000	1.000000	29
i1	226.5732	3.4500000477	156.521739	1	4140.000000	0.300000	1.700000	1.000000	23
i1	226.1628	3.4500000477	211.764706	1	3060.000000	0.300000	1.700000	1.000000	17
i1	225.7524	3.4500000477	327.272727	1	1980.000000	0.300000	1.700000	1.000000	11
i1	225.342	3.4500000477	720.000000	1	900.000000	0.300000	1.700000	1.000000	5
i1	225.0684	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	225.2736	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	225.4104	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	225.684	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	225.8208	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	226.0944	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	226.2312	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	226.5048	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	226.6416	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	226.9152	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	227.052	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	227.3256	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	227.4624	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	227.736	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	227.8728	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	228.1464	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	228.2832	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	228.5568	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	228.8304	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	229.104	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	229.3776	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	232.5045	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	232.2273	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	231.9501	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	231.6729	3.4500000477	67.924528	1	9540.000000	0.300000	1.700000	1.000000	53
i1	231.3957	3.4500000477	73.469388	1	8820.000000	0.300000	1.700000	1.000000	49
i1	231.1185	3.4500000477	80.000000	1	8100.000000	0.300000	1.700000	1.000000	45
i1	230.7027	3.4500000477	92.307692	1	7020.000000	0.300000	1.700000	1.000000	39
i1	230.2869	3.4500000477	109.090909	1	5940.000000	0.300000	1.700000	1.000000	33
i1	229.8711	3.4500000477	133.333333	1	4860.000000	0.300000	1.700000	1.000000	27
i1	229.4553	3.4500000477	171.428571	1	3780.000000	0.300000	1.700000	1.000000	21
i1	229.0395	3.4500000477	240.000000	1	2700.000000	0.300000	1.700000	1.000000	15
i1	228.6237	3.4500000477	400.000000	1	1620.000000	0.300000	1.700000	1.000000	9
i1	228.2079	3.4500000477	1200.000000	1	540.000000	0.300000	1.700000	1.000000	3
i1	228.1386	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	228.2772	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	228.5544	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	228.693	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	228.9702	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	229.1088	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	229.386	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	229.5246	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	229.8018	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	229.9404	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	230.2176	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	230.3562	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	230.6334	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	230.772	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	231.0492	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	231.1878	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	231.465	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	231.7422	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	232.0194	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	232.2966	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	232.5738	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	235.7034	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	235.4226	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	235.1418	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	234.861	3.4500000477	65.454545	1	9900.000000	0.300000	1.700000	1.000000	55
i1	234.5802	3.4500000477	70.588235	1	9180.000000	0.300000	1.700000	1.000000	51
i1	234.2994	3.4500000477	76.595745	1	8460.000000	0.300000	1.700000	1.000000	47
i1	234.0186	3.4500000477	83.720930	1	7740.000000	0.300000	1.700000	1.000000	43
i1	233.5974	3.4500000477	97.297297	1	6660.000000	0.300000	1.700000	1.000000	37
i1	233.1762	3.4500000477	116.129032	1	5580.000000	0.300000	1.700000	1.000000	31
i1	232.755	3.4500000477	144.000000	1	4500.000000	0.300000	1.700000	1.000000	25
i1	232.3338	3.4500000477	189.473684	1	3420.000000	0.300000	1.700000	1.000000	19
i1	231.9126	3.4500000477	276.923077	1	2340.000000	0.300000	1.700000	1.000000	13
i1	231.4914	3.4500000477	514.285714	1	1260.000000	0.300000	1.700000	1.000000	7
i1	231.0702	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	231.1404	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	231.4212	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	231.5616	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	231.8424	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	231.9828	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	232.2636	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	232.404	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	232.6848	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	232.8252	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	233.106	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	233.2464	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	233.5272	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	233.6676	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	233.9484	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	234.0888	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	234.3696	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	234.6504	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	234.9312	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	235.212	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	235.4928	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	238.6215	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	238.3371	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	238.0527	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	237.7683	3.4500000477	67.924528	1	9540.000000	0.300000	1.700000	1.000000	53
i1	237.4839	3.4500000477	73.469388	1	8820.000000	0.300000	1.700000	1.000000	49
i1	237.1995	3.4500000477	80.000000	1	8100.000000	0.300000	1.700000	1.000000	45
i1	236.9151	3.4500000477	87.804878	1	7380.000000	0.300000	1.700000	1.000000	41
i1	236.4885	3.4500000477	102.857143	1	6300.000000	0.300000	1.700000	1.000000	35
i1	236.0619	3.4500000477	124.137931	1	5220.000000	0.300000	1.700000	1.000000	29
i1	235.6353	3.4500000477	156.521739	1	4140.000000	0.300000	1.700000	1.000000	23
i1	235.2087	3.4500000477	211.764706	1	3060.000000	0.300000	1.700000	1.000000	17
i1	234.7821	3.4500000477	327.272727	1	1980.000000	0.300000	1.700000	1.000000	11
i1	234.3555	3.4500000477	720.000000	1	900.000000	0.300000	1.700000	1.000000	5
i1	234.0711	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	234.2844	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	234.4266	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	234.711	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	234.8532	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	235.1376	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	235.2798	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	235.5642	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	235.7064	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	235.9908	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	236.133	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	236.4174	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	236.5596	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	236.844	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	236.9862	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	237.2706	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	237.555	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	237.8394	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	238.1238	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	238.4082	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	238.6926	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	241.824	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	241.536	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	241.248	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	240.96	3.4500000477	65.454545	1	9900.000000	0.300000	1.700000	1.000000	55
i1	240.672	3.4500000477	70.588235	1	9180.000000	0.300000	1.700000	1.000000	51
i1	240.384	3.4500000477	76.595745	1	8460.000000	0.300000	1.700000	1.000000	47
i1	240.096	3.4500000477	83.720930	1	7740.000000	0.300000	1.700000	1.000000	43
i1	239.808	3.4500000477	92.307692	1	7020.000000	0.300000	1.700000	1.000000	39
i1	239.376	3.4500000477	109.090909	1	5940.000000	0.300000	1.700000	1.000000	33
i1	238.944	3.4500000477	133.333333	1	4860.000000	0.300000	1.700000	1.000000	27
i1	238.512	3.4500000477	171.428571	1	3780.000000	0.300000	1.700000	1.000000	21
i1	238.08	3.4500000477	240.000000	1	2700.000000	0.300000	1.700000	1.000000	15
i1	237.648	3.4500000477	400.000000	1	1620.000000	0.300000	1.700000	1.000000	9
i1	237.216	3.4500000477	1200.000000	1	540.000000	0.300000	1.700000	1.000000	3
i1	237.144	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	237.288	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	237.576	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	237.72	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	238.008	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	238.152	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	238.44	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	238.584	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	238.872	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	239.016	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	239.304	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	239.448	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	239.736	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	239.88	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	240.168	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	240.456	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	240.744	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	241.032	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	241.32	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	241.608	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	244.7385	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	244.4469	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	244.1553	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	243.8637	3.4500000477	67.924528	1	9540.000000	0.300000	1.700000	1.000000	53
i1	243.5721	3.4500000477	73.469388	1	8820.000000	0.300000	1.700000	1.000000	49
i1	243.2805	3.4500000477	80.000000	1	8100.000000	0.300000	1.700000	1.000000	45
i1	242.9889	3.4500000477	87.804878	1	7380.000000	0.300000	1.700000	1.000000	41
i1	242.6973	3.4500000477	97.297297	1	6660.000000	0.300000	1.700000	1.000000	37
i1	242.2599	3.4500000477	116.129032	1	5580.000000	0.300000	1.700000	1.000000	31
i1	241.8225	3.4500000477	144.000000	1	4500.000000	0.300000	1.700000	1.000000	25
i1	241.3851	3.4500000477	189.473684	1	3420.000000	0.300000	1.700000	1.000000	19
i1	240.9477	3.4500000477	276.923077	1	2340.000000	0.300000	1.700000	1.000000	13
i1	240.5103	3.4500000477	514.285714	1	1260.000000	0.300000	1.700000	1.000000	7
i1	240.0729	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	240.1458	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	240.4374	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	240.5832	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	240.8748	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	241.0206	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	241.3122	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	241.458	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	241.7496	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	241.8954	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	242.187	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	242.3328	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	242.6244	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	242.7702	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	243.0618	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	243.3534	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	243.645	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	243.9366	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	244.2282	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	244.5198	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	244.8114	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	247.9446	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	247.6494	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	247.3542	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	247.059	3.4500000477	65.454545	1	9900.000000	0.300000	1.700000	1.000000	55
i1	246.7638	3.4500000477	70.588235	1	9180.000000	0.300000	1.700000	1.000000	51
i1	246.4686	3.4500000477	76.595745	1	8460.000000	0.300000	1.700000	1.000000	47
i1	246.1734	3.4500000477	83.720930	1	7740.000000	0.300000	1.700000	1.000000	43
i1	245.8782	3.4500000477	92.307692	1	7020.000000	0.300000	1.700000	1.000000	39
i1	245.583	3.4500000477	102.857143	1	6300.000000	0.300000	1.700000	1.000000	35
i1	245.1402	3.4500000477	124.137931	1	5220.000000	0.300000	1.700000	1.000000	29
i1	244.6974	3.4500000477	156.521739	1	4140.000000	0.300000	1.700000	1.000000	23
i1	244.2546	3.4500000477	211.764706	1	3060.000000	0.300000	1.700000	1.000000	17
i1	243.8118	3.4500000477	327.272727	1	1980.000000	0.300000	1.700000	1.000000	11
i1	243.369	3.4500000477	720.000000	1	900.000000	0.300000	1.700000	1.000000	5
i1	243.0738	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	243.2952	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	243.4428	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	243.738	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	243.8856	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	244.1808	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	244.3284	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	244.6236	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	244.7712	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	245.0664	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	245.214	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	245.5092	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	245.6568	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	245.952	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	246.2472	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	246.5424	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	246.8376	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	247.1328	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	247.428	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	247.7232	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	250.8555	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	250.5567	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	250.2579	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	249.9591	3.4500000477	67.924528	1	9540.000000	0.300000	1.700000	1.000000	53
i1	249.6603	3.4500000477	73.469388	1	8820.000000	0.300000	1.700000	1.000000	49
i1	249.3615	3.4500000477	80.000000	1	8100.000000	0.300000	1.700000	1.000000	45
i1	249.0627	3.4500000477	87.804878	1	7380.000000	0.300000	1.700000	1.000000	41
i1	248.7639	3.4500000477	97.297297	1	6660.000000	0.300000	1.700000	1.000000	37
i1	248.4651	3.4500000477	109.090909	1	5940.000000	0.300000	1.700000	1.000000	33
i1	248.0169	3.4500000477	133.333333	1	4860.000000	0.300000	1.700000	1.000000	27
i1	247.5687	3.4500000477	171.428571	1	3780.000000	0.300000	1.700000	1.000000	21
i1	247.1205	3.4500000477	240.000000	1	2700.000000	0.300000	1.700000	1.000000	15
i1	246.6723	3.4500000477	400.000000	1	1620.000000	0.300000	1.700000	1.000000	9
i1	246.2241	3.4500000477	1200.000000	1	540.000000	0.300000	1.700000	1.000000	3
i1	246.1494	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	246.2988	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	246.5976	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	246.747	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	247.0458	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	247.1952	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	247.494	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	247.6434	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	247.9422	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	248.0916	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	248.3904	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	248.5398	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	248.8386	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	249.1374	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	249.4362	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	249.735	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	250.0338	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	250.3326	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	250.6314	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	250.9302	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	254.0652	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	253.7628	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	253.4604	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	253.158	3.4500000477	65.454545	1	9900.000000	0.300000	1.700000	1.000000	55
i1	252.8556	3.4500000477	70.588235	1	9180.000000	0.300000	1.700000	1.000000	51
i1	252.5532	3.4500000477	76.595745	1	8460.000000	0.300000	1.700000	1.000000	47
i1	252.2508	3.4500000477	83.720930	1	7740.000000	0.300000	1.700000	1.000000	43
i1	251.9484	3.4500000477	92.307692	1	7020.000000	0.300000	1.700000	1.000000	39
i1	251.646	3.4500000477	102.857143	1	6300.000000	0.300000	1.700000	1.000000	35
i1	251.3436	3.4500000477	116.129032	1	5580.000000	0.300000	1.700000	1.000000	31
i1	250.89	3.4500000477	144.000000	1	4500.000000	0.300000	1.700000	1.000000	25
i1	250.4364	3.4500000477	189.473684	1	3420.000000	0.300000	1.700000	1.000000	19
i1	249.9828	3.4500000477	276.923077	1	2340.000000	0.300000	1.700000	1.000000	13
i1	249.5292	3.4500000477	514.285714	1	1260.000000	0.300000	1.700000	1.000000	7
i1	249.0756	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	249.1512	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	249.4536	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	249.6048	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	249.9072	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	250.0584	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	250.3608	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	250.512	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	250.8144	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	250.9656	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	251.268	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	251.4192	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	251.7216	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	252.024	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	252.3264	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	252.6288	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	252.9312	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	253.2336	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	253.536	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	253.8384	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	256.9725	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	256.6665	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	256.3605	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	256.0545	3.4500000477	67.924528	1	9540.000000	0.300000	1.700000	1.000000	53
i1	255.7485	3.4500000477	73.469388	1	8820.000000	0.300000	1.700000	1.000000	49
i1	255.4425	3.4500000477	80.000000	1	8100.000000	0.300000	1.700000	1.000000	45
i1	255.1365	3.4500000477	87.804878	1	7380.000000	0.300000	1.700000	1.000000	41
i1	254.8305	3.4500000477	97.297297	1	6660.000000	0.300000	1.700000	1.000000	37
i1	254.5245	3.4500000477	109.090909	1	5940.000000	0.300000	1.700000	1.000000	33
i1	254.2185	3.4500000477	124.137931	1	5220.000000	0.300000	1.700000	1.000000	29
i1	253.7595	3.4500000477	156.521739	1	4140.000000	0.300000	1.700000	1.000000	23
i1	253.3005	3.4500000477	211.764706	1	3060.000000	0.300000	1.700000	1.000000	17
i1	252.8415	3.4500000477	327.272727	1	1980.000000	0.300000	1.700000	1.000000	11
i1	252.3825	3.4500000477	720.000000	1	900.000000	0.300000	1.700000	1.000000	5
i1	252.0765	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	252.306	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	252.459	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	252.765	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	252.918	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	253.224	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	253.377	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	253.683	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	253.836	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	254.142	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	254.295	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	254.601	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	254.907	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	255.213	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	255.519	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	255.825	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	256.131	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	256.437	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	256.743	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	257.049	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	260.1858	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	259.8762	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	259.5666	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	259.257	3.4500000477	65.454545	1	9900.000000	0.300000	1.700000	1.000000	55
i1	258.9474	3.4500000477	70.588235	1	9180.000000	0.300000	1.700000	1.000000	51
i1	258.6378	3.4500000477	76.595745	1	8460.000000	0.300000	1.700000	1.000000	47
i1	258.3282	3.4500000477	83.720930	1	7740.000000	0.300000	1.700000	1.000000	43
i1	258.0186	3.4500000477	92.307692	1	7020.000000	0.300000	1.700000	1.000000	39
i1	257.709	3.4500000477	102.857143	1	6300.000000	0.300000	1.700000	1.000000	35
i1	257.3994	3.4500000477	116.129032	1	5580.000000	0.300000	1.700000	1.000000	31
i1	257.0898	3.4500000477	133.333333	1	4860.000000	0.300000	1.700000	1.000000	27
i1	256.6254	3.4500000477	171.428571	1	3780.000000	0.300000	1.700000	1.000000	21
i1	256.161	3.4500000477	240.000000	1	2700.000000	0.300000	1.700000	1.000000	15
i1	255.6966	3.4500000477	400.000000	1	1620.000000	0.300000	1.700000	1.000000	9
i1	255.2322	3.4500000477	1200.000000	1	540.000000	0.300000	1.700000	1.000000	3
i1	255.1548	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	255.3096	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	255.6192	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	255.774	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	256.0836	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	256.2384	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	256.548	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	256.7028	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	257.0124	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	257.1672	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	257.4768	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	257.7864	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	258.096	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	258.4056	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	258.7152	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	259.0248	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	259.3344	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	259.644	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	259.9536	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	263.0895	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	262.7763	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	262.4631	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	262.1499	3.4500000477	67.924528	1	9540.000000	0.300000	1.700000	1.000000	53
i1	261.8367	3.4500000477	73.469388	1	8820.000000	0.300000	1.700000	1.000000	49
i1	261.5235	3.4500000477	80.000000	1	8100.000000	0.300000	1.700000	1.000000	45
i1	261.2103	3.4500000477	87.804878	1	7380.000000	0.300000	1.700000	1.000000	41
i1	260.8971	3.4500000477	97.297297	1	6660.000000	0.300000	1.700000	1.000000	37
i1	260.5839	3.4500000477	109.090909	1	5940.000000	0.300000	1.700000	1.000000	33
i1	260.2707	3.4500000477	124.137931	1	5220.000000	0.300000	1.700000	1.000000	29
i1	259.9575	3.4500000477	144.000000	1	4500.000000	0.300000	1.700000	1.000000	25
i1	259.4877	3.4500000477	189.473684	1	3420.000000	0.300000	1.700000	1.000000	19
i1	259.0179	3.4500000477	276.923077	1	2340.000000	0.300000	1.700000	1.000000	13
i1	258.5481	3.4500000477	514.285714	1	1260.000000	0.300000	1.700000	1.000000	7
i1	258.0783	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	258.1566	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	258.4698	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	258.6264	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	258.9396	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	259.0962	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	259.4094	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	259.566	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	259.8792	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	260.0358	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	260.349	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	260.6622	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	260.9754	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	261.2886	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	261.6018	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	261.915	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	262.2282	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	262.5414	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	262.8546	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	263.1678	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	266.3064	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	265.9896	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	265.6728	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	265.356	3.4500000477	65.454545	1	9900.000000	0.300000	1.700000	1.000000	55
i1	265.0392	3.4500000477	70.588235	1	9180.000000	0.300000	1.700000	1.000000	51
i1	264.7224	3.4500000477	76.595745	1	8460.000000	0.300000	1.700000	1.000000	47
i1	264.4056	3.4500000477	83.720930	1	7740.000000	0.300000	1.700000	1.000000	43
i1	264.0888	3.4500000477	92.307692	1	7020.000000	0.300000	1.700000	1.000000	39
i1	263.772	3.4500000477	102.857143	1	6300.000000	0.300000	1.700000	1.000000	35
i1	263.4552	3.4500000477	116.129032	1	5580.000000	0.300000	1.700000	1.000000	31
i1	263.1384	3.4500000477	133.333333	1	4860.000000	0.300000	1.700000	1.000000	27
i1	262.8216	3.4500000477	156.521739	1	4140.000000	0.300000	1.700000	1.000000	23
i1	262.3464	3.4500000477	211.764706	1	3060.000000	0.300000	1.700000	1.000000	17
i1	261.8712	3.4500000477	327.272727	1	1980.000000	0.300000	1.700000	1.000000	11
i1	261.396	3.4500000477	720.000000	1	900.000000	0.300000	1.700000	1.000000	5
i1	261.0792	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	261.3168	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	261.4752	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	261.792	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	261.9504	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	262.2672	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	262.4256	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	262.7424	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	262.9008	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	263.2176	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	263.5344	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	263.8512	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	264.168	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	264.4848	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	264.8016	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	265.1184	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	265.4352	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	265.752	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	266.0688	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	269.2065	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	268.8861	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	268.5657	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	268.2453	3.4500000477	67.924528	1	9540.000000	0.300000	1.700000	1.000000	53
i1	267.9249	3.4500000477	73.469388	1	8820.000000	0.300000	1.700000	1.000000	49
i1	267.6045	3.4500000477	80.000000	1	8100.000000	0.300000	1.700000	1.000000	45
i1	267.2841	3.4500000477	87.804878	1	7380.000000	0.300000	1.700000	1.000000	41
i1	266.9637	3.4500000477	97.297297	1	6660.000000	0.300000	1.700000	1.000000	37
i1	266.6433	3.4500000477	109.090909	1	5940.000000	0.300000	1.700000	1.000000	33
i1	266.3229	3.4500000477	124.137931	1	5220.000000	0.300000	1.700000	1.000000	29
i1	266.0025	3.4500000477	144.000000	1	4500.000000	0.300000	1.700000	1.000000	25
i1	265.6821	3.4500000477	171.428571	1	3780.000000	0.300000	1.700000	1.000000	21
i1	265.2015	3.4500000477	240.000000	1	2700.000000	0.300000	1.700000	1.000000	15
i1	264.7209	3.4500000477	400.000000	1	1620.000000	0.300000	1.700000	1.000000	9
i1	264.2403	3.4500000477	1200.000000	1	540.000000	0.300000	1.700000	1.000000	3
i1	264.1602	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	264.3204	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	264.6408	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	264.801	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	265.1214	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	265.2816	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	265.602	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	265.7622	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	266.0826	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	266.403	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	266.7234	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	267.0438	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	267.3642	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	267.6846	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	268.005	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	268.3254	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	268.6458	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	268.9662	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	269.2866	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	272.427	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	272.103	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	271.779	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	271.455	3.4500000477	65.454545	1	9900.000000	0.300000	1.700000	1.000000	55
i1	271.131	3.4500000477	70.588235	1	9180.000000	0.300000	1.700000	1.000000	51
i1	270.807	3.4500000477	76.595745	1	8460.000000	0.300000	1.700000	1.000000	47
i1	270.483	3.4500000477	83.720930	1	7740.000000	0.300000	1.700000	1.000000	43
i1	270.159	3.4500000477	92.307692	1	7020.000000	0.300000	1.700000	1.000000	39
i1	269.835	3.4500000477	102.857143	1	6300.000000	0.300000	1.700000	1.000000	35
i1	269.511	3.4500000477	116.129032	1	5580.000000	0.300000	1.700000	1.000000	31
i1	269.187	3.4500000477	133.333333	1	4860.000000	0.300000	1.700000	1.000000	27
i1	268.863	3.4500000477	156.521739	1	4140.000000	0.300000	1.700000	1.000000	23
i1	268.539	3.4500000477	189.473684	1	3420.000000	0.300000	1.700000	1.000000	19
i1	268.053	3.4500000477	276.923077	1	2340.000000	0.300000	1.700000	1.000000	13
i1	267.567	3.4500000477	514.285714	1	1260.000000	0.300000	1.700000	1.000000	7
i1	267.081	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	267.162	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	267.486	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	267.648	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	267.972	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	268.134	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	268.458	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	268.62	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	268.944	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	269.268	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	269.592	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	269.916	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	270.24	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	270.564	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	270.888	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	271.212	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	271.536	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	271.86	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	272.184	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	275.3235	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	274.9959	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	274.6683	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	274.3407	3.4500000477	67.924528	1	9540.000000	0.300000	1.700000	1.000000	53
i1	274.0131	3.4500000477	73.469388	1	8820.000000	0.300000	1.700000	1.000000	49
i1	273.6855	3.4500000477	80.000000	1	8100.000000	0.300000	1.700000	1.000000	45
i1	273.3579	3.4500000477	87.804878	1	7380.000000	0.300000	1.700000	1.000000	41
i1	273.0303	3.4500000477	97.297297	1	6660.000000	0.300000	1.700000	1.000000	37
i1	272.7027	3.4500000477	109.090909	1	5940.000000	0.300000	1.700000	1.000000	33
i1	272.3751	3.4500000477	124.137931	1	5220.000000	0.300000	1.700000	1.000000	29
i1	272.0475	3.4500000477	144.000000	1	4500.000000	0.300000	1.700000	1.000000	25
i1	271.7199	3.4500000477	171.428571	1	3780.000000	0.300000	1.700000	1.000000	21
i1	271.3923	3.4500000477	211.764706	1	3060.000000	0.300000	1.700000	1.000000	17
i1	270.9009	3.4500000477	327.272727	1	1980.000000	0.300000	1.700000	1.000000	11
i1	270.4095	3.4500000477	720.000000	1	900.000000	0.300000	1.700000	1.000000	5
i1	270.0819	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	270.3276	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	270.4914	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	270.819	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	270.9828	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	271.3104	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	271.4742	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	271.8018	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	272.1294	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	272.457	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	272.7846	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	273.1122	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	273.4398	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	273.7674	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	274.095	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	274.4226	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	274.7502	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	275.0778	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	275.4054	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	278.5476	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	278.2164	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	277.8852	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	277.554	3.4500000477	65.454545	1	9900.000000	0.300000	1.700000	1.000000	55
i1	277.2228	3.4500000477	70.588235	1	9180.000000	0.300000	1.700000	1.000000	51
i1	276.8916	3.4500000477	76.595745	1	8460.000000	0.300000	1.700000	1.000000	47
i1	276.5604	3.4500000477	83.720930	1	7740.000000	0.300000	1.700000	1.000000	43
i1	276.2292	3.4500000477	92.307692	1	7020.000000	0.300000	1.700000	1.000000	39
i1	275.898	3.4500000477	102.857143	1	6300.000000	0.300000	1.700000	1.000000	35
i1	275.5668	3.4500000477	116.129032	1	5580.000000	0.300000	1.700000	1.000000	31
i1	275.2356	3.4500000477	133.333333	1	4860.000000	0.300000	1.700000	1.000000	27
i1	274.9044	3.4500000477	156.521739	1	4140.000000	0.300000	1.700000	1.000000	23
i1	274.5732	3.4500000477	189.473684	1	3420.000000	0.300000	1.700000	1.000000	19
i1	274.242	3.4500000477	240.000000	1	2700.000000	0.300000	1.700000	1.000000	15
i1	273.7452	3.4500000477	400.000000	1	1620.000000	0.300000	1.700000	1.000000	9
i1	273.2484	3.4500000477	1200.000000	1	540.000000	0.300000	1.700000	1.000000	3
i1	273.1656	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	273.3312	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	273.6624	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	273.828	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	274.1592	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	274.3248	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	274.656	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	274.9872	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	275.3184	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	275.6496	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	275.9808	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	276.312	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	276.6432	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	276.9744	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	277.3056	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	277.6368	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	277.968	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	278.2992	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	281.4405	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	281.1057	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	280.7709	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	280.4361	3.4500000477	67.924528	1	9540.000000	0.300000	1.700000	1.000000	53
i1	280.1013	3.4500000477	73.469388	1	8820.000000	0.300000	1.700000	1.000000	49
i1	279.7665	3.4500000477	80.000000	1	8100.000000	0.300000	1.700000	1.000000	45
i1	279.4317	3.4500000477	87.804878	1	7380.000000	0.300000	1.700000	1.000000	41
i1	279.0969	3.4500000477	97.297297	1	6660.000000	0.300000	1.700000	1.000000	37
i1	278.7621	3.4500000477	109.090909	1	5940.000000	0.300000	1.700000	1.000000	33
i1	278.4273	3.4500000477	124.137931	1	5220.000000	0.300000	1.700000	1.000000	29
i1	278.0925	3.4500000477	144.000000	1	4500.000000	0.300000	1.700000	1.000000	25
i1	277.7577	3.4500000477	171.428571	1	3780.000000	0.300000	1.700000	1.000000	21
i1	277.4229	3.4500000477	211.764706	1	3060.000000	0.300000	1.700000	1.000000	17
i1	277.0881	3.4500000477	276.923077	1	2340.000000	0.300000	1.700000	1.000000	13
i1	276.5859	3.4500000477	514.285714	1	1260.000000	0.300000	1.700000	1.000000	7
i1	276.0837	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	276.1674	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	276.5022	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	276.6696	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	277.0044	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	277.1718	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	277.5066	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	277.8414	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	278.1762	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	278.511	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	278.8458	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	279.1806	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	279.5154	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	279.8502	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	280.185	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	280.5198	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	280.8546	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	281.1894	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	281.5242	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	284.6682	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	284.3298	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	283.9914	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	283.653	3.4500000477	65.454545	1	9900.000000	0.300000	1.700000	1.000000	55
i1	283.3146	3.4500000477	70.588235	1	9180.000000	0.300000	1.700000	1.000000	51
i1	282.9762	3.4500000477	76.595745	1	8460.000000	0.300000	1.700000	1.000000	47
i1	282.6378	3.4500000477	83.720930	1	7740.000000	0.300000	1.700000	1.000000	43
i1	282.2994	3.4500000477	92.307692	1	7020.000000	0.300000	1.700000	1.000000	39
i1	281.961	3.4500000477	102.857143	1	6300.000000	0.300000	1.700000	1.000000	35
i1	281.6226	3.4500000477	116.129032	1	5580.000000	0.300000	1.700000	1.000000	31
i1	281.2842	3.4500000477	133.333333	1	4860.000000	0.300000	1.700000	1.000000	27
i1	280.9458	3.4500000477	156.521739	1	4140.000000	0.300000	1.700000	1.000000	23
i1	280.6074	3.4500000477	189.473684	1	3420.000000	0.300000	1.700000	1.000000	19
i1	280.269	3.4500000477	240.000000	1	2700.000000	0.300000	1.700000	1.000000	15
i1	279.9306	3.4500000477	327.272727	1	1980.000000	0.300000	1.700000	1.000000	11
i1	279.423	3.4500000477	720.000000	1	900.000000	0.300000	1.700000	1.000000	5
i1	279.0846	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	279.3384	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	279.5076	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	279.846	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	280.0152	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	280.3536	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	280.692	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	281.0304	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	281.3688	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	281.7072	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	282.0456	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	282.384	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	282.7224	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	283.0608	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	283.3992	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	283.7376	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	284.076	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	284.4144	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	287.5575	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	287.2155	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	286.8735	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	286.5315	3.4500000477	67.924528	1	9540.000000	0.300000	1.700000	1.000000	53
i1	286.1895	3.4500000477	73.469388	1	8820.000000	0.300000	1.700000	1.000000	49
i1	285.8475	3.4500000477	80.000000	1	8100.000000	0.300000	1.700000	1.000000	45
i1	285.5055	3.4500000477	87.804878	1	7380.000000	0.300000	1.700000	1.000000	41
i1	285.1635	3.4500000477	97.297297	1	6660.000000	0.300000	1.700000	1.000000	37
i1	284.8215	3.4500000477	109.090909	1	5940.000000	0.300000	1.700000	1.000000	33
i1	284.4795	3.4500000477	124.137931	1	5220.000000	0.300000	1.700000	1.000000	29
i1	284.1375	3.4500000477	144.000000	1	4500.000000	0.300000	1.700000	1.000000	25
i1	283.7955	3.4500000477	171.428571	1	3780.000000	0.300000	1.700000	1.000000	21
i1	283.4535	3.4500000477	211.764706	1	3060.000000	0.300000	1.700000	1.000000	17
i1	283.1115	3.4500000477	276.923077	1	2340.000000	0.300000	1.700000	1.000000	13
i1	282.7695	3.4500000477	400.000000	1	1620.000000	0.300000	1.700000	1.000000	9
i1	282.2565	3.4500000477	1200.000000	1	540.000000	0.300000	1.700000	1.000000	3
i1	282.171	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	282.342	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	282.684	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	282.855	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	283.197	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	283.539	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	283.881	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	284.223	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	284.565	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	284.907	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	285.249	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	285.591	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	285.933	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	286.275	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	286.617	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	286.959	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	287.301	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	287.643	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	290.7888	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	290.4432	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	290.0976	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	289.752	3.4500000477	65.454545	1	9900.000000	0.300000	1.700000	1.000000	55
i1	289.4064	3.4500000477	70.588235	1	9180.000000	0.300000	1.700000	1.000000	51
i1	289.0608	3.4500000477	76.595745	1	8460.000000	0.300000	1.700000	1.000000	47
i1	288.7152	3.4500000477	83.720930	1	7740.000000	0.300000	1.700000	1.000000	43
i1	288.3696	3.4500000477	92.307692	1	7020.000000	0.300000	1.700000	1.000000	39
i1	288.024	3.4500000477	102.857143	1	6300.000000	0.300000	1.700000	1.000000	35
i1	287.6784	3.4500000477	116.129032	1	5580.000000	0.300000	1.700000	1.000000	31
i1	287.3328	3.4500000477	133.333333	1	4860.000000	0.300000	1.700000	1.000000	27
i1	286.9872	3.4500000477	156.521739	1	4140.000000	0.300000	1.700000	1.000000	23
i1	286.6416	3.4500000477	189.473684	1	3420.000000	0.300000	1.700000	1.000000	19
i1	286.296	3.4500000477	240.000000	1	2700.000000	0.300000	1.700000	1.000000	15
i1	285.9504	3.4500000477	327.272727	1	1980.000000	0.300000	1.700000	1.000000	11
i1	285.6048	3.4500000477	514.285714	1	1260.000000	0.300000	1.700000	1.000000	7
i1	285.0864	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	285.1728	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	285.5184	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	285.6912	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	286.0368	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	286.3824	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	286.728	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	287.0736	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	287.4192	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	287.7648	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	288.1104	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	288.456	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	288.8016	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	289.1472	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	289.4928	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	289.8384	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	290.184	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	290.5296	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	293.6745	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	293.3253	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	292.9761	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	292.6269	3.4500000477	67.924528	1	9540.000000	0.300000	1.700000	1.000000	53
i1	292.2777	3.4500000477	73.469388	1	8820.000000	0.300000	1.700000	1.000000	49
i1	291.9285	3.4500000477	80.000000	1	8100.000000	0.300000	1.700000	1.000000	45
i1	291.5793	3.4500000477	87.804878	1	7380.000000	0.300000	1.700000	1.000000	41
i1	291.2301	3.4500000477	97.297297	1	6660.000000	0.300000	1.700000	1.000000	37
i1	290.8809	3.4500000477	109.090909	1	5940.000000	0.300000	1.700000	1.000000	33
i1	290.5317	3.4500000477	124.137931	1	5220.000000	0.300000	1.700000	1.000000	29
i1	290.1825	3.4500000477	144.000000	1	4500.000000	0.300000	1.700000	1.000000	25
i1	289.8333	3.4500000477	171.428571	1	3780.000000	0.300000	1.700000	1.000000	21
i1	289.4841	3.4500000477	211.764706	1	3060.000000	0.300000	1.700000	1.000000	17
i1	289.1349	3.4500000477	276.923077	1	2340.000000	0.300000	1.700000	1.000000	13
i1	288.7857	3.4500000477	400.000000	1	1620.000000	0.300000	1.700000	1.000000	9
i1	288.4365	3.4500000477	720.000000	1	900.000000	0.300000	1.700000	1.000000	5
i1	288.0873	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	288.3492	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	288.5238	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	288.873	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	289.2222	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	289.5714	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	289.9206	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	290.2698	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	290.619	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	290.9682	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	291.3174	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	291.6666	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	292.0158	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	292.365	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	292.7142	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	293.0634	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	293.4126	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	293.7618	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	296.9094	3.4500000477	53.731343	1	12060.000000	0.300000	1.700000	1.000000	67
i1	296.5566	3.4500000477	57.142857	1	11340.000000	0.300000	1.700000	1.000000	63
i1	296.2038	3.4500000477	61.016949	1	10620.000000	0.300000	1.700000	1.000000	59
i1	295.851	3.4500000477	65.454545	1	9900.000000	0.300000	1.700000	1.000000	55
i1	295.4982	3.4500000477	70.588235	1	9180.000000	0.300000	1.700000	1.000000	51
i1	295.1454	3.4500000477	76.595745	1	8460.000000	0.300000	1.700000	1.000000	47
i1	294.7926	3.4500000477	83.720930	1	7740.000000	0.300000	1.700000	1.000000	43
i1	294.4398	3.4500000477	92.307692	1	7020.000000	0.300000	1.700000	1.000000	39
i1	294.087	3.4500000477	102.857143	1	6300.000000	0.300000	1.700000	1.000000	35
i1	293.7342	3.4500000477	116.129032	1	5580.000000	0.300000	1.700000	1.000000	31
i1	293.3814	3.4500000477	133.333333	1	4860.000000	0.300000	1.700000	1.000000	27
i1	293.0286	3.4500000477	156.521739	1	4140.000000	0.300000	1.700000	1.000000	23
i1	292.6758	3.4500000477	189.473684	1	3420.000000	0.300000	1.700000	1.000000	19
i1	292.323	3.4500000477	240.000000	1	2700.000000	0.300000	1.700000	1.000000	15
i1	291.9702	3.4500000477	327.272727	1	1980.000000	0.300000	1.700000	1.000000	11
i1	291.6174	3.4500000477	514.285714	1	1260.000000	0.300000	1.700000	1.000000	7
i1	291.2646	3.4500000477	1200.000000	1	540.000000	0.300000	1.700000	1.000000	3
i1	291.1764	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	291.3528	3.4500000477	900.000000	1	720.000000	0.300000	1.700000	1.000000	4
i1	291.7056	3.4500000477	450.000000	1	1440.000000	0.300000	1.700000	1.000000	8
i1	292.0584	3.4500000477	300.000000	1	2160.000000	0.300000	1.700000	1.000000	12
i1	292.4112	3.4500000477	225.000000	1	2880.000000	0.300000	1.700000	1.000000	16
i1	292.764	3.4500000477	180.000000	1	3600.000000	0.300000	1.700000	1.000000	20
i1	293.1168	3.4500000477	150.000000	1	4320.000000	0.300000	1.700000	1.000000	24
i1	293.4696	3.4500000477	128.571429	1	5040.000000	0.300000	1.700000	1.000000	28
i1	293.8224	3.4500000477	112.500000	1	5760.000000	0.300000	1.700000	1.000000	32
i1	294.1752	3.4500000477	100.000000	1	6480.000000	0.300000	1.700000	1.000000	36
i1	294.528	3.4500000477	90.000000	1	7200.000000	0.300000	1.700000	1.000000	40
i1	294.8808	3.4500000477	81.818182	1	7920.000000	0.300000	1.700000	1.000000	44
i1	295.2336	3.4500000477	75.000000	1	8640.000000	0.300000	1.700000	1.000000	48
i1	295.5864	3.4500000477	69.230769	1	9360.000000	0.300000	1.700000	1.000000	52
i1	295.9392	3.4500000477	64.285714	1	10080.000000	0.300000	1.700000	1.000000	56
i1	296.292	3.4500000477	60.000000	1	10800.000000	0.300000	1.700000	1.000000	60
i1	296.6448	3.4500000477	56.250000	1	11520.000000	0.300000	1.700000	1.000000	64
i1	299.7915	3.4500000477	55.384615	1	11700.000000	0.300000	1.700000	1.000000	65
i1	299.4351	3.4500000477	59.016393	1	10980.000000	0.300000	1.700000	1.000000	61
i1	299.0787	3.4500000477	63.157895	1	10260.000000	0.300000	1.700000	1.000000	57
i1	298.7223	3.4500000477	67.924528	1	9540.000000	0.300000	1.700000	1.000000	53
i1	298.3659	3.4500000477	73.469388	1	8820.000000	0.300000	1.700000	1.000000	49
i1	298.0095	3.4500000477	80.000000	1	8100.000000	0.300000	1.700000	1.000000	45
i1	297.6531	3.4500000477	87.804878	1	7380.000000	0.300000	1.700000	1.000000	41
i1	297.2967	3.4500000477	97.297297	1	6660.000000	0.300000	1.700000	1.000000	37
i1	296.9403	3.4500000477	109.090909	1	5940.000000	0.300000	1.700000	1.000000	33
i1	296.5839	3.4500000477	124.137931	1	5220.000000	0.300000	1.700000	1.000000	29
i1	296.2275	3.4500000477	144.000000	1	4500.000000	0.300000	1.700000	1.000000	25
i1	295.8711	3.4500000477	171.428571	1	3780.000000	0.300000	1.700000	1.000000	21
i1	295.5147	3.4500000477	211.764706	1	3060.000000	0.300000	1.700000	1.000000	17
i1	295.1583	3.4500000477	276.923077	1	2340.000000	0.300000	1.700000	1.000000	13
i1	294.8019	3.4500000477	400.000000	1	1620.000000	0.300000	1.700000	1.000000	9
i1	294.4455	3.4500000477	720.000000	1	900.000000	0.300000	1.700000	1.000000	5
i1	294.0891	3.4500000477	3600.000000	1	180.000000	0.300000	1.700000	1.000000	1
i1	294.1782	3.4500000477	1800.000000	1	360.000000	0.300000	1.700000	1.000000	2
i1	294.5346	3.4500000477	600.000000	1	1080.000000	0.300000	1.700000	1.000000	6
i1	294.891	3.4500000477	360.000000	1	1800.000000	0.300000	1.700000	1.000000	10
i1	295.2474	3.4500000477	257.142857	1	2520.000000	0.300000	1.700000	1.000000	14
i1	295.6038	3.4500000477	200.000000	1	3240.000000	0.300000	1.700000	1.000000	18
i1	295.9602	3.4500000477	163.636364	1	3960.000000	0.300000	1.700000	1.000000	22
i1	296.3166	3.4500000477	138.461538	1	4680.000000	0.300000	1.700000	1.000000	26
i1	296.673	3.4500000477	120.000000	1	5400.000000	0.300000	1.700000	1.000000	30
i1	297.0294	3.4500000477	105.882353	1	6120.000000	0.300000	1.700000	1.000000	34
i1	297.3858	3.4500000477	94.736842	1	6840.000000	0.300000	1.700000	1.000000	38
i1	297.7422	3.4500000477	85.714286	1	7560.000000	0.300000	1.700000	1.000000	42
i1	298.0986	3.4500000477	78.260870	1	8280.000000	0.300000	1.700000	1.000000	46
i1	298.455	3.4500000477	72.000000	1	9000.000000	0.300000	1.700000	1.000000	50
i1	298.8114	3.4500000477	66.666667	1	9720.000000	0.300000	1.700000	1.000000	54
i1	299.1678	3.4500000477	62.068966	1	10440.000000	0.300000	1.700000	1.000000	58
i1	299.5242	3.4500000477	58.064516	1	11160.000000	0.300000	1.700000	1.000000	62
i1	299.8806	3.4500000477	54.545455	1	11880.000000	0.300000	1.700000	1.000000	66
i1	303.03	20.7000007629	53.731343	1	12060.000000	0.300000	1.700000	6.900000	67
i1	302.67	20.7000007629	57.142857	1	11340.000000	0.300000	1.700000	6.900000	63
i1	302.31	20.7000007629	61.016949	1	10620.000000	0.300000	1.700000	6.900000	59
i1	301.95	20.7000007629	65.454545	1	9900.000000	0.300000	1.700000	6.900000	55
i1	301.59	20.7000007629	70.588235	1	9180.000000	0.300000	1.700000	6.900000	51
i1	301.23	20.7000007629	76.595745	1	8460.000000	0.300000	1.700000	6.900000	47
i1	300.87	20.7000007629	83.720930	1	7740.000000	0.300000	1.700000	6.900000	43
i1	300.51	20.7000007629	92.307692	1	7020.000000	0.300000	1.700000	6.900000	39
i1	300.15	20.7000007629	102.857143	1	6300.000000	0.300000	1.700000	6.900000	35
i1	299.79	20.7000007629	116.129032	1	5580.000000	0.300000	1.700000	6.900000	31
i1	299.43	20.7000007629	133.333333	1	4860.000000	0.300000	1.700000	6.900000	27
i1	299.07	20.7000007629	156.521739	1	4140.000000	0.300000	1.700000	6.900000	23
i1	298.71	20.7000007629	189.473684	1	3420.000000	0.300000	1.700000	6.900000	19
i1	298.35	20.7000007629	240.000000	1	2700.000000	0.300000	1.700000	6.900000	15
i1	297.99	20.7000007629	327.272727	1	1980.000000	0.300000	1.700000	6.900000	11
i1	297.63	20.7000007629	514.285714	1	1260.000000	0.300000	1.700000	6.900000	7
i1	297.27	20.7000007629	1200.000000	1	540.000000	0.300000	1.700000	6.900000	3
i1	297.09	20.7000007629	3600.000000	1	180.000000	0.300000	1.700000	6.900000	1
i1	297.36	20.7000007629	900.000000	1	720.000000	0.300000	1.700000	6.900000	4
i1	297.72	20.7000007629	450.000000	1	1440.000000	0.300000	1.700000	6.900000	8
i1	298.08	20.7000007629	300.000000	1	2160.000000	0.300000	1.700000	6.900000	12
i1	298.44	20.7000007629	225.000000	1	2880.000000	0.300000	1.700000	6.900000	16
i1	298.8	20.7000007629	180.000000	1	3600.000000	0.300000	1.700000	6.900000	20
i1	299.16	20.7000007629	150.000000	1	4320.000000	0.300000	1.700000	6.900000	24
i1	299.52	20.7000007629	128.571429	1	5040.000000	0.300000	1.700000	6.900000	28
i1	299.88	20.7000007629	112.500000	1	5760.000000	0.300000	1.700000	6.900000	32
i1	300.24	20.7000007629	100.000000	1	6480.000000	0.300000	1.700000	6.900000	36
i1	300.6	20.7000007629	90.000000	1	7200.000000	0.300000	1.700000	6.900000	40
i1	300.96	20.7000007629	81.818182	1	7920.000000	0.300000	1.700000	6.900000	44
i1	301.32	20.7000007629	75.000000	1	8640.000000	0.300000	1.700000	6.900000	48
i1	301.68	20.7000007629	69.230769	1	9360.000000	0.300000	1.700000	6.900000	52
i1	302.04	20.7000007629	64.285714	1	10080.000000	0.300000	1.700000	6.900000	56
i1	302.4	20.7000007629	60.000000	1	10800.000000	0.300000	1.700000	6.900000	60
i1	302.76	20.7000007629	56.250000	1	11520.000000	0.300000	1.700000	6.900000	64
i1	3.0009	20.7000007629	4000.000000	1	67.500000	0.000000	1.700000	6.900000	1
i1	6.1206	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	6.117	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	6.1134	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	6.1098	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	6.1062	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	6.1026	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	6.099	3.4500000477	72.727273	1	3712.500000	0.000000	1.700000	1.000000	55
i1	6.0954	3.4500000477	75.471698	1	3577.500000	0.000000	1.700000	1.000000	53
i1	6.0918	3.4500000477	78.431373	1	3442.500000	0.000000	1.700000	1.000000	51
i1	6.0882	3.4500000477	81.632653	1	3307.500000	0.000000	1.700000	1.000000	49
i1	6.0846	3.4500000477	85.106383	1	3172.500000	0.000000	1.700000	1.000000	47
i1	6.081	3.4500000477	88.888889	1	3037.500000	0.000000	1.700000	1.000000	45
i1	6.0774	3.4500000477	93.023256	1	2902.500000	0.000000	1.700000	1.000000	43
i1	6.0738	3.4500000477	97.560976	1	2767.500000	0.000000	1.700000	1.000000	41
i1	6.0702	3.4500000477	102.564103	1	2632.500000	0.000000	1.700000	1.000000	39
i1	6.0666	3.4500000477	108.108108	1	2497.500000	0.000000	1.700000	1.000000	37
i1	6.063	3.4500000477	114.285714	1	2362.500000	0.000000	1.700000	1.000000	35
i1	6.0594	3.4500000477	121.212121	1	2227.500000	0.000000	1.700000	1.000000	33
i1	6.0558	3.4500000477	129.032258	1	2092.500000	0.000000	1.700000	1.000000	31
i1	6.0522	3.4500000477	137.931034	1	1957.500000	0.000000	1.700000	1.000000	29
i1	6.0486	3.4500000477	148.148148	1	1822.500000	0.000000	1.700000	1.000000	27
i1	6.045	3.4500000477	160.000000	1	1687.500000	0.000000	1.700000	1.000000	25
i1	6.0414	3.4500000477	173.913043	1	1552.500000	0.000000	1.700000	1.000000	23
i1	6.0378	3.4500000477	190.476190	1	1417.500000	0.000000	1.700000	1.000000	21
i1	6.0342	3.4500000477	210.526316	1	1282.500000	0.000000	1.700000	1.000000	19
i1	6.0306	3.4500000477	235.294118	1	1147.500000	0.000000	1.700000	1.000000	17
i1	6.027	3.4500000477	266.666667	1	1012.500000	0.000000	1.700000	1.000000	15
i1	6.0234	3.4500000477	307.692308	1	877.500000	0.000000	1.700000	1.000000	13
i1	6.0198	3.4500000477	363.636364	1	742.500000	0.000000	1.700000	1.000000	11
i1	6.0162	3.4500000477	444.444444	1	607.500000	0.000000	1.700000	1.000000	9
i1	6.0126	3.4500000477	571.428571	1	472.500000	0.000000	1.700000	1.000000	7
i1	6.009	3.4500000477	800.000000	1	337.500000	0.000000	1.700000	1.000000	5
i1	6.0054	3.4500000477	1333.333333	1	202.500000	0.000000	1.700000	1.000000	3
i1	6.0036	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	6.0072	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	6.0108	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	6.0144	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	6.018	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	6.0216	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	6.0252	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	6.0288	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	6.0324	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	6.036	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	6.0396	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	6.0432	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	6.0468	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	6.0504	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	6.054	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	6.0576	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	6.0612	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	6.0648	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	6.0684	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	6.072	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	6.0756	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	6.0792	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	6.0828	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	6.0864	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	6.09	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	6.0936	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	6.0972	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	6.1008	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	6.1044	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	6.108	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	6.1116	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	6.1152	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	6.1188	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	9.0027	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	9.0054	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	12.2412	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	12.234	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	12.2268	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	12.2196	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	12.2124	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	12.2052	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	12.198	3.4500000477	72.727273	1	3712.500000	0.000000	1.700000	1.000000	55
i1	12.1908	3.4500000477	75.471698	1	3577.500000	0.000000	1.700000	1.000000	53
i1	12.1836	3.4500000477	78.431373	1	3442.500000	0.000000	1.700000	1.000000	51
i1	12.1764	3.4500000477	81.632653	1	3307.500000	0.000000	1.700000	1.000000	49
i1	12.1692	3.4500000477	85.106383	1	3172.500000	0.000000	1.700000	1.000000	47
i1	12.162	3.4500000477	88.888889	1	3037.500000	0.000000	1.700000	1.000000	45
i1	12.1548	3.4500000477	93.023256	1	2902.500000	0.000000	1.700000	1.000000	43
i1	12.1476	3.4500000477	97.560976	1	2767.500000	0.000000	1.700000	1.000000	41
i1	12.1404	3.4500000477	102.564103	1	2632.500000	0.000000	1.700000	1.000000	39
i1	12.1332	3.4500000477	108.108108	1	2497.500000	0.000000	1.700000	1.000000	37
i1	12.126	3.4500000477	114.285714	1	2362.500000	0.000000	1.700000	1.000000	35
i1	12.1188	3.4500000477	121.212121	1	2227.500000	0.000000	1.700000	1.000000	33
i1	12.1116	3.4500000477	129.032258	1	2092.500000	0.000000	1.700000	1.000000	31
i1	12.1044	3.4500000477	137.931034	1	1957.500000	0.000000	1.700000	1.000000	29
i1	12.0972	3.4500000477	148.148148	1	1822.500000	0.000000	1.700000	1.000000	27
i1	12.09	3.4500000477	160.000000	1	1687.500000	0.000000	1.700000	1.000000	25
i1	12.0828	3.4500000477	173.913043	1	1552.500000	0.000000	1.700000	1.000000	23
i1	12.0756	3.4500000477	190.476190	1	1417.500000	0.000000	1.700000	1.000000	21
i1	12.0684	3.4500000477	210.526316	1	1282.500000	0.000000	1.700000	1.000000	19
i1	12.0612	3.4500000477	235.294118	1	1147.500000	0.000000	1.700000	1.000000	17
i1	12.054	3.4500000477	266.666667	1	1012.500000	0.000000	1.700000	1.000000	15
i1	12.0468	3.4500000477	307.692308	1	877.500000	0.000000	1.700000	1.000000	13
i1	12.0396	3.4500000477	363.636364	1	742.500000	0.000000	1.700000	1.000000	11
i1	12.0324	3.4500000477	444.444444	1	607.500000	0.000000	1.700000	1.000000	9
i1	12.0252	3.4500000477	571.428571	1	472.500000	0.000000	1.700000	1.000000	7
i1	12.018	3.4500000477	800.000000	1	337.500000	0.000000	1.700000	1.000000	5
i1	12.0036	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	12.0144	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	12.0216	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	12.0288	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	12.036	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	12.0432	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	12.0504	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	12.0576	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	12.0648	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	12.072	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	12.0792	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	12.0864	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	12.0936	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	12.1008	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	12.108	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	12.1152	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	12.1224	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	12.1296	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	12.1368	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	12.144	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	12.1512	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	12.1584	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	12.1656	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	12.1728	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	12.18	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	12.1872	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	12.1944	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	12.2016	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	12.2088	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	12.216	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	12.2232	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	12.2304	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	12.2376	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	15.0135	3.4500000477	1333.333333	1	202.500000	0.000000	1.700000	1.000000	3
i1	15.009	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	15.018	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	18.3618	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	18.351	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	18.3402	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	18.3294	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	18.3186	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	18.3078	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	18.297	3.4500000477	72.727273	1	3712.500000	0.000000	1.700000	1.000000	55
i1	18.2862	3.4500000477	75.471698	1	3577.500000	0.000000	1.700000	1.000000	53
i1	18.2754	3.4500000477	78.431373	1	3442.500000	0.000000	1.700000	1.000000	51
i1	18.2646	3.4500000477	81.632653	1	3307.500000	0.000000	1.700000	1.000000	49
i1	18.2538	3.4500000477	85.106383	1	3172.500000	0.000000	1.700000	1.000000	47
i1	18.243	3.4500000477	88.888889	1	3037.500000	0.000000	1.700000	1.000000	45
i1	18.2322	3.4500000477	93.023256	1	2902.500000	0.000000	1.700000	1.000000	43
i1	18.2214	3.4500000477	97.560976	1	2767.500000	0.000000	1.700000	1.000000	41
i1	18.2106	3.4500000477	102.564103	1	2632.500000	0.000000	1.700000	1.000000	39
i1	18.1998	3.4500000477	108.108108	1	2497.500000	0.000000	1.700000	1.000000	37
i1	18.189	3.4500000477	114.285714	1	2362.500000	0.000000	1.700000	1.000000	35
i1	18.1782	3.4500000477	121.212121	1	2227.500000	0.000000	1.700000	1.000000	33
i1	18.1674	3.4500000477	129.032258	1	2092.500000	0.000000	1.700000	1.000000	31
i1	18.1566	3.4500000477	137.931034	1	1957.500000	0.000000	1.700000	1.000000	29
i1	18.1458	3.4500000477	148.148148	1	1822.500000	0.000000	1.700000	1.000000	27
i1	18.135	3.4500000477	160.000000	1	1687.500000	0.000000	1.700000	1.000000	25
i1	18.1242	3.4500000477	173.913043	1	1552.500000	0.000000	1.700000	1.000000	23
i1	18.1134	3.4500000477	190.476190	1	1417.500000	0.000000	1.700000	1.000000	21
i1	18.1026	3.4500000477	210.526316	1	1282.500000	0.000000	1.700000	1.000000	19
i1	18.0918	3.4500000477	235.294118	1	1147.500000	0.000000	1.700000	1.000000	17
i1	18.081	3.4500000477	266.666667	1	1012.500000	0.000000	1.700000	1.000000	15
i1	18.0702	3.4500000477	307.692308	1	877.500000	0.000000	1.700000	1.000000	13
i1	18.0594	3.4500000477	363.636364	1	742.500000	0.000000	1.700000	1.000000	11
i1	18.0486	3.4500000477	444.444444	1	607.500000	0.000000	1.700000	1.000000	9
i1	18.0378	3.4500000477	571.428571	1	472.500000	0.000000	1.700000	1.000000	7
i1	18.0054	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	18.0108	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	18.0324	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	18.0432	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	18.054	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	18.0648	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	18.0756	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	18.0864	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	18.0972	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	18.108	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	18.1188	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	18.1296	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	18.1404	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	18.1512	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	18.162	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	18.1728	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	18.1836	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	18.1944	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	18.2052	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	18.216	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	18.2268	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	18.2376	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	18.2484	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	18.2592	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	18.27	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	18.2808	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	18.2916	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	18.3024	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	18.3132	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	18.324	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	18.3348	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	18.3456	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	18.3564	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	21.0315	3.4500000477	800.000000	1	337.500000	0.000000	1.700000	1.000000	5
i1	21.0063	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	21.0252	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	21.0378	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	24.4824	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	24.468	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	24.4536	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	24.4392	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	24.4248	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	24.4104	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	24.396	3.4500000477	72.727273	1	3712.500000	0.000000	1.700000	1.000000	55
i1	24.3816	3.4500000477	75.471698	1	3577.500000	0.000000	1.700000	1.000000	53
i1	24.3672	3.4500000477	78.431373	1	3442.500000	0.000000	1.700000	1.000000	51
i1	24.3528	3.4500000477	81.632653	1	3307.500000	0.000000	1.700000	1.000000	49
i1	24.3384	3.4500000477	85.106383	1	3172.500000	0.000000	1.700000	1.000000	47
i1	24.324	3.4500000477	88.888889	1	3037.500000	0.000000	1.700000	1.000000	45
i1	24.3096	3.4500000477	93.023256	1	2902.500000	0.000000	1.700000	1.000000	43
i1	24.2952	3.4500000477	97.560976	1	2767.500000	0.000000	1.700000	1.000000	41
i1	24.2808	3.4500000477	102.564103	1	2632.500000	0.000000	1.700000	1.000000	39
i1	24.2664	3.4500000477	108.108108	1	2497.500000	0.000000	1.700000	1.000000	37
i1	24.252	3.4500000477	114.285714	1	2362.500000	0.000000	1.700000	1.000000	35
i1	24.2376	3.4500000477	121.212121	1	2227.500000	0.000000	1.700000	1.000000	33
i1	24.2232	3.4500000477	129.032258	1	2092.500000	0.000000	1.700000	1.000000	31
i1	24.2088	3.4500000477	137.931034	1	1957.500000	0.000000	1.700000	1.000000	29
i1	24.1944	3.4500000477	148.148148	1	1822.500000	0.000000	1.700000	1.000000	27
i1	24.18	3.4500000477	160.000000	1	1687.500000	0.000000	1.700000	1.000000	25
i1	24.1656	3.4500000477	173.913043	1	1552.500000	0.000000	1.700000	1.000000	23
i1	24.1512	3.4500000477	190.476190	1	1417.500000	0.000000	1.700000	1.000000	21
i1	24.1368	3.4500000477	210.526316	1	1282.500000	0.000000	1.700000	1.000000	19
i1	24.1224	3.4500000477	235.294118	1	1147.500000	0.000000	1.700000	1.000000	17
i1	24.108	3.4500000477	266.666667	1	1012.500000	0.000000	1.700000	1.000000	15
i1	24.0936	3.4500000477	307.692308	1	877.500000	0.000000	1.700000	1.000000	13
i1	24.0792	3.4500000477	363.636364	1	742.500000	0.000000	1.700000	1.000000	11
i1	24.0648	3.4500000477	444.444444	1	607.500000	0.000000	1.700000	1.000000	9
i1	24.0216	3.4500000477	1333.333333	1	202.500000	0.000000	1.700000	1.000000	3
i1	24.0144	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	24.0288	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	24.0576	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	24.072	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	24.0864	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	24.1008	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	24.1152	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	24.1296	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	24.144	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	24.1584	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	24.1728	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	24.1872	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	24.2016	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	24.216	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	24.2304	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	24.2448	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	24.2592	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	24.2736	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	24.288	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	24.3024	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	24.3168	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	24.3312	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	24.3456	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	24.36	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	24.3744	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	24.3888	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	24.4032	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	24.4176	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	24.432	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	24.4464	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	24.4608	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	24.4752	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	27.0567	3.4500000477	571.428571	1	472.500000	0.000000	1.700000	1.000000	7
i1	27.0081	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	27.0162	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	27.0486	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	27.0648	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	30.603	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	30.585	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	30.567	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	30.549	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	30.531	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	30.513	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	30.495	3.4500000477	72.727273	1	3712.500000	0.000000	1.700000	1.000000	55
i1	30.477	3.4500000477	75.471698	1	3577.500000	0.000000	1.700000	1.000000	53
i1	30.459	3.4500000477	78.431373	1	3442.500000	0.000000	1.700000	1.000000	51
i1	30.441	3.4500000477	81.632653	1	3307.500000	0.000000	1.700000	1.000000	49
i1	30.423	3.4500000477	85.106383	1	3172.500000	0.000000	1.700000	1.000000	47
i1	30.405	3.4500000477	88.888889	1	3037.500000	0.000000	1.700000	1.000000	45
i1	30.387	3.4500000477	93.023256	1	2902.500000	0.000000	1.700000	1.000000	43
i1	30.369	3.4500000477	97.560976	1	2767.500000	0.000000	1.700000	1.000000	41
i1	30.351	3.4500000477	102.564103	1	2632.500000	0.000000	1.700000	1.000000	39
i1	30.333	3.4500000477	108.108108	1	2497.500000	0.000000	1.700000	1.000000	37
i1	30.315	3.4500000477	114.285714	1	2362.500000	0.000000	1.700000	1.000000	35
i1	30.297	3.4500000477	121.212121	1	2227.500000	0.000000	1.700000	1.000000	33
i1	30.279	3.4500000477	129.032258	1	2092.500000	0.000000	1.700000	1.000000	31
i1	30.261	3.4500000477	137.931034	1	1957.500000	0.000000	1.700000	1.000000	29
i1	30.243	3.4500000477	148.148148	1	1822.500000	0.000000	1.700000	1.000000	27
i1	30.225	3.4500000477	160.000000	1	1687.500000	0.000000	1.700000	1.000000	25
i1	30.207	3.4500000477	173.913043	1	1552.500000	0.000000	1.700000	1.000000	23
i1	30.189	3.4500000477	190.476190	1	1417.500000	0.000000	1.700000	1.000000	21
i1	30.171	3.4500000477	210.526316	1	1282.500000	0.000000	1.700000	1.000000	19
i1	30.153	3.4500000477	235.294118	1	1147.500000	0.000000	1.700000	1.000000	17
i1	30.135	3.4500000477	266.666667	1	1012.500000	0.000000	1.700000	1.000000	15
i1	30.117	3.4500000477	307.692308	1	877.500000	0.000000	1.700000	1.000000	13
i1	30.099	3.4500000477	363.636364	1	742.500000	0.000000	1.700000	1.000000	11
i1	30.045	3.4500000477	800.000000	1	337.500000	0.000000	1.700000	1.000000	5
i1	30.009	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	30.036	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	30.054	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	30.09	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	30.108	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	30.126	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	30.144	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	30.162	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	30.18	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	30.198	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	30.216	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	30.234	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	30.252	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	30.27	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	30.288	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	30.306	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	30.324	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	30.342	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	30.36	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	30.378	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	30.396	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	30.414	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	30.432	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	30.45	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	30.468	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	30.486	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	30.504	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	30.522	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	30.54	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	30.558	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	30.576	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	30.594	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	33.0891	3.4500000477	444.444444	1	607.500000	0.000000	1.700000	1.000000	9
i1	33.0297	3.4500000477	1333.333333	1	202.500000	0.000000	1.700000	1.000000	3
i1	33.0198	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	33.0396	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	33.0792	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	33.099	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	36.7236	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	36.702	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	36.6804	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	36.6588	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	36.6372	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	36.6156	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	36.594	3.4500000477	72.727273	1	3712.500000	0.000000	1.700000	1.000000	55
i1	36.5724	3.4500000477	75.471698	1	3577.500000	0.000000	1.700000	1.000000	53
i1	36.5508	3.4500000477	78.431373	1	3442.500000	0.000000	1.700000	1.000000	51
i1	36.5292	3.4500000477	81.632653	1	3307.500000	0.000000	1.700000	1.000000	49
i1	36.5076	3.4500000477	85.106383	1	3172.500000	0.000000	1.700000	1.000000	47
i1	36.486	3.4500000477	88.888889	1	3037.500000	0.000000	1.700000	1.000000	45
i1	36.4644	3.4500000477	93.023256	1	2902.500000	0.000000	1.700000	1.000000	43
i1	36.4428	3.4500000477	97.560976	1	2767.500000	0.000000	1.700000	1.000000	41
i1	36.4212	3.4500000477	102.564103	1	2632.500000	0.000000	1.700000	1.000000	39
i1	36.3996	3.4500000477	108.108108	1	2497.500000	0.000000	1.700000	1.000000	37
i1	36.378	3.4500000477	114.285714	1	2362.500000	0.000000	1.700000	1.000000	35
i1	36.3564	3.4500000477	121.212121	1	2227.500000	0.000000	1.700000	1.000000	33
i1	36.3348	3.4500000477	129.032258	1	2092.500000	0.000000	1.700000	1.000000	31
i1	36.3132	3.4500000477	137.931034	1	1957.500000	0.000000	1.700000	1.000000	29
i1	36.2916	3.4500000477	148.148148	1	1822.500000	0.000000	1.700000	1.000000	27
i1	36.27	3.4500000477	160.000000	1	1687.500000	0.000000	1.700000	1.000000	25
i1	36.2484	3.4500000477	173.913043	1	1552.500000	0.000000	1.700000	1.000000	23
i1	36.2268	3.4500000477	190.476190	1	1417.500000	0.000000	1.700000	1.000000	21
i1	36.2052	3.4500000477	210.526316	1	1282.500000	0.000000	1.700000	1.000000	19
i1	36.1836	3.4500000477	235.294118	1	1147.500000	0.000000	1.700000	1.000000	17
i1	36.162	3.4500000477	266.666667	1	1012.500000	0.000000	1.700000	1.000000	15
i1	36.1404	3.4500000477	307.692308	1	877.500000	0.000000	1.700000	1.000000	13
i1	36.0756	3.4500000477	571.428571	1	472.500000	0.000000	1.700000	1.000000	7
i1	36.0108	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	36.0216	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	36.0648	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	36.0864	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	36.1296	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	36.1512	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	36.1728	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	36.1944	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	36.216	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	36.2376	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	36.2592	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	36.2808	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	36.3024	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	36.324	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	36.3456	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	36.3672	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	36.3888	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	36.4104	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	36.432	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	36.4536	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	36.4752	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	36.4968	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	36.5184	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	36.54	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	36.5616	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	36.5832	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	36.6048	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	36.6264	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	36.648	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	36.6696	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	36.6912	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	36.7128	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	39.1287	3.4500000477	363.636364	1	742.500000	0.000000	1.700000	1.000000	11
i1	39.0585	3.4500000477	800.000000	1	337.500000	0.000000	1.700000	1.000000	5
i1	39.0117	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	39.0468	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	39.0702	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	39.117	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	39.1404	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	42.8442	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	42.819	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	42.7938	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	42.7686	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	42.7434	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	42.7182	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	42.693	3.4500000477	72.727273	1	3712.500000	0.000000	1.700000	1.000000	55
i1	42.6678	3.4500000477	75.471698	1	3577.500000	0.000000	1.700000	1.000000	53
i1	42.6426	3.4500000477	78.431373	1	3442.500000	0.000000	1.700000	1.000000	51
i1	42.6174	3.4500000477	81.632653	1	3307.500000	0.000000	1.700000	1.000000	49
i1	42.5922	3.4500000477	85.106383	1	3172.500000	0.000000	1.700000	1.000000	47
i1	42.567	3.4500000477	88.888889	1	3037.500000	0.000000	1.700000	1.000000	45
i1	42.5418	3.4500000477	93.023256	1	2902.500000	0.000000	1.700000	1.000000	43
i1	42.5166	3.4500000477	97.560976	1	2767.500000	0.000000	1.700000	1.000000	41
i1	42.4914	3.4500000477	102.564103	1	2632.500000	0.000000	1.700000	1.000000	39
i1	42.4662	3.4500000477	108.108108	1	2497.500000	0.000000	1.700000	1.000000	37
i1	42.441	3.4500000477	114.285714	1	2362.500000	0.000000	1.700000	1.000000	35
i1	42.4158	3.4500000477	121.212121	1	2227.500000	0.000000	1.700000	1.000000	33
i1	42.3906	3.4500000477	129.032258	1	2092.500000	0.000000	1.700000	1.000000	31
i1	42.3654	3.4500000477	137.931034	1	1957.500000	0.000000	1.700000	1.000000	29
i1	42.3402	3.4500000477	148.148148	1	1822.500000	0.000000	1.700000	1.000000	27
i1	42.315	3.4500000477	160.000000	1	1687.500000	0.000000	1.700000	1.000000	25
i1	42.2898	3.4500000477	173.913043	1	1552.500000	0.000000	1.700000	1.000000	23
i1	42.2646	3.4500000477	190.476190	1	1417.500000	0.000000	1.700000	1.000000	21
i1	42.2394	3.4500000477	210.526316	1	1282.500000	0.000000	1.700000	1.000000	19
i1	42.2142	3.4500000477	235.294118	1	1147.500000	0.000000	1.700000	1.000000	17
i1	42.189	3.4500000477	266.666667	1	1012.500000	0.000000	1.700000	1.000000	15
i1	42.1134	3.4500000477	444.444444	1	607.500000	0.000000	1.700000	1.000000	9
i1	42.0378	3.4500000477	1333.333333	1	202.500000	0.000000	1.700000	1.000000	3
i1	42.0252	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	42.0504	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	42.1008	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	42.126	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	42.1764	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	42.2016	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	42.2268	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	42.252	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	42.2772	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	42.3024	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	42.3276	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	42.3528	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	42.378	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	42.4032	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	42.4284	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	42.4536	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	42.4788	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	42.504	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	42.5292	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	42.5544	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	42.5796	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	42.6048	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	42.63	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	42.6552	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	42.6804	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	42.7056	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	42.7308	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	42.756	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	42.7812	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	42.8064	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	42.8316	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	45.1755	3.4500000477	307.692308	1	877.500000	0.000000	1.700000	1.000000	13
i1	45.0945	3.4500000477	571.428571	1	472.500000	0.000000	1.700000	1.000000	7
i1	45.0135	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	45.027	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	45.081	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	45.108	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	45.162	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	45.189	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	48.9648	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	48.936	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	48.9072	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	48.8784	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	48.8496	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	48.8208	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	48.792	3.4500000477	72.727273	1	3712.500000	0.000000	1.700000	1.000000	55
i1	48.7632	3.4500000477	75.471698	1	3577.500000	0.000000	1.700000	1.000000	53
i1	48.7344	3.4500000477	78.431373	1	3442.500000	0.000000	1.700000	1.000000	51
i1	48.7056	3.4500000477	81.632653	1	3307.500000	0.000000	1.700000	1.000000	49
i1	48.6768	3.4500000477	85.106383	1	3172.500000	0.000000	1.700000	1.000000	47
i1	48.648	3.4500000477	88.888889	1	3037.500000	0.000000	1.700000	1.000000	45
i1	48.6192	3.4500000477	93.023256	1	2902.500000	0.000000	1.700000	1.000000	43
i1	48.5904	3.4500000477	97.560976	1	2767.500000	0.000000	1.700000	1.000000	41
i1	48.5616	3.4500000477	102.564103	1	2632.500000	0.000000	1.700000	1.000000	39
i1	48.5328	3.4500000477	108.108108	1	2497.500000	0.000000	1.700000	1.000000	37
i1	48.504	3.4500000477	114.285714	1	2362.500000	0.000000	1.700000	1.000000	35
i1	48.4752	3.4500000477	121.212121	1	2227.500000	0.000000	1.700000	1.000000	33
i1	48.4464	3.4500000477	129.032258	1	2092.500000	0.000000	1.700000	1.000000	31
i1	48.4176	3.4500000477	137.931034	1	1957.500000	0.000000	1.700000	1.000000	29
i1	48.3888	3.4500000477	148.148148	1	1822.500000	0.000000	1.700000	1.000000	27
i1	48.36	3.4500000477	160.000000	1	1687.500000	0.000000	1.700000	1.000000	25
i1	48.3312	3.4500000477	173.913043	1	1552.500000	0.000000	1.700000	1.000000	23
i1	48.3024	3.4500000477	190.476190	1	1417.500000	0.000000	1.700000	1.000000	21
i1	48.2736	3.4500000477	210.526316	1	1282.500000	0.000000	1.700000	1.000000	19
i1	48.2448	3.4500000477	235.294118	1	1147.500000	0.000000	1.700000	1.000000	17
i1	48.1584	3.4500000477	363.636364	1	742.500000	0.000000	1.700000	1.000000	11
i1	48.072	3.4500000477	800.000000	1	337.500000	0.000000	1.700000	1.000000	5
i1	48.0144	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	48.0576	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	48.0864	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	48.144	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	48.1728	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	48.2304	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	48.2592	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	48.288	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	48.3168	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	48.3456	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	48.3744	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	48.4032	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	48.432	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	48.4608	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	48.4896	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	48.5184	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	48.5472	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	48.576	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	48.6048	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	48.6336	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	48.6624	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	48.6912	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	48.72	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	48.7488	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	48.7776	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	48.8064	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	48.8352	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	48.864	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	48.8928	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	48.9216	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	48.9504	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	51.2295	3.4500000477	266.666667	1	1012.500000	0.000000	1.700000	1.000000	15
i1	51.1377	3.4500000477	444.444444	1	607.500000	0.000000	1.700000	1.000000	9
i1	51.0459	3.4500000477	1333.333333	1	202.500000	0.000000	1.700000	1.000000	3
i1	51.0306	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	51.0612	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	51.1224	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	51.153	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	51.2142	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	51.2448	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	55.0854	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	55.053	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	55.0206	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	54.9882	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	54.9558	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	54.9234	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	54.891	3.4500000477	72.727273	1	3712.500000	0.000000	1.700000	1.000000	55
i1	54.8586	3.4500000477	75.471698	1	3577.500000	0.000000	1.700000	1.000000	53
i1	54.8262	3.4500000477	78.431373	1	3442.500000	0.000000	1.700000	1.000000	51
i1	54.7938	3.4500000477	81.632653	1	3307.500000	0.000000	1.700000	1.000000	49
i1	54.7614	3.4500000477	85.106383	1	3172.500000	0.000000	1.700000	1.000000	47
i1	54.729	3.4500000477	88.888889	1	3037.500000	0.000000	1.700000	1.000000	45
i1	54.6966	3.4500000477	93.023256	1	2902.500000	0.000000	1.700000	1.000000	43
i1	54.6642	3.4500000477	97.560976	1	2767.500000	0.000000	1.700000	1.000000	41
i1	54.6318	3.4500000477	102.564103	1	2632.500000	0.000000	1.700000	1.000000	39
i1	54.5994	3.4500000477	108.108108	1	2497.500000	0.000000	1.700000	1.000000	37
i1	54.567	3.4500000477	114.285714	1	2362.500000	0.000000	1.700000	1.000000	35
i1	54.5346	3.4500000477	121.212121	1	2227.500000	0.000000	1.700000	1.000000	33
i1	54.5022	3.4500000477	129.032258	1	2092.500000	0.000000	1.700000	1.000000	31
i1	54.4698	3.4500000477	137.931034	1	1957.500000	0.000000	1.700000	1.000000	29
i1	54.4374	3.4500000477	148.148148	1	1822.500000	0.000000	1.700000	1.000000	27
i1	54.405	3.4500000477	160.000000	1	1687.500000	0.000000	1.700000	1.000000	25
i1	54.3726	3.4500000477	173.913043	1	1552.500000	0.000000	1.700000	1.000000	23
i1	54.3402	3.4500000477	190.476190	1	1417.500000	0.000000	1.700000	1.000000	21
i1	54.3078	3.4500000477	210.526316	1	1282.500000	0.000000	1.700000	1.000000	19
i1	54.2106	3.4500000477	307.692308	1	877.500000	0.000000	1.700000	1.000000	13
i1	54.1134	3.4500000477	571.428571	1	472.500000	0.000000	1.700000	1.000000	7
i1	54.0162	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	54.0324	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	54.0972	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	54.1296	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	54.1944	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	54.2268	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	54.2916	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	54.324	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	54.3564	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	54.3888	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	54.4212	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	54.4536	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	54.486	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	54.5184	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	54.5508	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	54.5832	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	54.6156	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	54.648	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	54.6804	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	54.7128	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	54.7452	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	54.7776	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	54.81	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	54.8424	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	54.8748	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	54.9072	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	54.9396	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	54.972	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	55.0044	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	55.0368	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	55.0692	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	57.2907	3.4500000477	235.294118	1	1147.500000	0.000000	1.700000	1.000000	17
i1	57.1881	3.4500000477	363.636364	1	742.500000	0.000000	1.700000	1.000000	11
i1	57.0855	3.4500000477	800.000000	1	337.500000	0.000000	1.700000	1.000000	5
i1	57.0171	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	57.0684	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	57.1026	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	57.171	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	57.2052	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	57.2736	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	57.3078	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	61.206	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	61.17	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	61.134	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	61.098	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	61.062	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	61.026	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	60.99	3.4500000477	72.727273	1	3712.500000	0.000000	1.700000	1.000000	55
i1	60.954	3.4500000477	75.471698	1	3577.500000	0.000000	1.700000	1.000000	53
i1	60.918	3.4500000477	78.431373	1	3442.500000	0.000000	1.700000	1.000000	51
i1	60.882	3.4500000477	81.632653	1	3307.500000	0.000000	1.700000	1.000000	49
i1	60.846	3.4500000477	85.106383	1	3172.500000	0.000000	1.700000	1.000000	47
i1	60.81	3.4500000477	88.888889	1	3037.500000	0.000000	1.700000	1.000000	45
i1	60.774	3.4500000477	93.023256	1	2902.500000	0.000000	1.700000	1.000000	43
i1	60.738	3.4500000477	97.560976	1	2767.500000	0.000000	1.700000	1.000000	41
i1	60.702	3.4500000477	102.564103	1	2632.500000	0.000000	1.700000	1.000000	39
i1	60.666	3.4500000477	108.108108	1	2497.500000	0.000000	1.700000	1.000000	37
i1	60.63	3.4500000477	114.285714	1	2362.500000	0.000000	1.700000	1.000000	35
i1	60.594	3.4500000477	121.212121	1	2227.500000	0.000000	1.700000	1.000000	33
i1	60.558	3.4500000477	129.032258	1	2092.500000	0.000000	1.700000	1.000000	31
i1	60.522	3.4500000477	137.931034	1	1957.500000	0.000000	1.700000	1.000000	29
i1	60.486	3.4500000477	148.148148	1	1822.500000	0.000000	1.700000	1.000000	27
i1	60.45	3.4500000477	160.000000	1	1687.500000	0.000000	1.700000	1.000000	25
i1	60.414	3.4500000477	173.913043	1	1552.500000	0.000000	1.700000	1.000000	23
i1	60.378	3.4500000477	190.476190	1	1417.500000	0.000000	1.700000	1.000000	21
i1	60.27	3.4500000477	266.666667	1	1012.500000	0.000000	1.700000	1.000000	15
i1	60.162	3.4500000477	444.444444	1	607.500000	0.000000	1.700000	1.000000	9
i1	60.054	3.4500000477	1333.333333	1	202.500000	0.000000	1.700000	1.000000	3
i1	60.036	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	60.072	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	60.144	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	60.18	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	60.252	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	60.288	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	60.36	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	60.396	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	60.432	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	60.468	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	60.504	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	60.54	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	60.576	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	60.612	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	60.648	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	60.684	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	60.72	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	60.756	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	60.792	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	60.828	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	60.864	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	60.9	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	60.936	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	60.972	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	61.008	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	61.044	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	61.08	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	61.116	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	61.152	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	61.188	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	63.3591	3.4500000477	210.526316	1	1282.500000	0.000000	1.700000	1.000000	19
i1	63.2457	3.4500000477	307.692308	1	877.500000	0.000000	1.700000	1.000000	13
i1	63.1323	3.4500000477	571.428571	1	472.500000	0.000000	1.700000	1.000000	7
i1	63.0189	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	63.0378	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	63.1134	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	63.1512	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	63.2268	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	63.2646	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	63.3402	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	63.378	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	67.3266	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	67.287	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	67.2474	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	67.2078	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	67.1682	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	67.1286	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	67.089	3.4500000477	72.727273	1	3712.500000	0.000000	1.700000	1.000000	55
i1	67.0494	3.4500000477	75.471698	1	3577.500000	0.000000	1.700000	1.000000	53
i1	67.0098	3.4500000477	78.431373	1	3442.500000	0.000000	1.700000	1.000000	51
i1	66.9702	3.4500000477	81.632653	1	3307.500000	0.000000	1.700000	1.000000	49
i1	66.9306	3.4500000477	85.106383	1	3172.500000	0.000000	1.700000	1.000000	47
i1	66.891	3.4500000477	88.888889	1	3037.500000	0.000000	1.700000	1.000000	45
i1	66.8514	3.4500000477	93.023256	1	2902.500000	0.000000	1.700000	1.000000	43
i1	66.8118	3.4500000477	97.560976	1	2767.500000	0.000000	1.700000	1.000000	41
i1	66.7722	3.4500000477	102.564103	1	2632.500000	0.000000	1.700000	1.000000	39
i1	66.7326	3.4500000477	108.108108	1	2497.500000	0.000000	1.700000	1.000000	37
i1	66.693	3.4500000477	114.285714	1	2362.500000	0.000000	1.700000	1.000000	35
i1	66.6534	3.4500000477	121.212121	1	2227.500000	0.000000	1.700000	1.000000	33
i1	66.6138	3.4500000477	129.032258	1	2092.500000	0.000000	1.700000	1.000000	31
i1	66.5742	3.4500000477	137.931034	1	1957.500000	0.000000	1.700000	1.000000	29
i1	66.5346	3.4500000477	148.148148	1	1822.500000	0.000000	1.700000	1.000000	27
i1	66.495	3.4500000477	160.000000	1	1687.500000	0.000000	1.700000	1.000000	25
i1	66.4554	3.4500000477	173.913043	1	1552.500000	0.000000	1.700000	1.000000	23
i1	66.3366	3.4500000477	235.294118	1	1147.500000	0.000000	1.700000	1.000000	17
i1	66.2178	3.4500000477	363.636364	1	742.500000	0.000000	1.700000	1.000000	11
i1	66.099	3.4500000477	800.000000	1	337.500000	0.000000	1.700000	1.000000	5
i1	66.0198	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	66.0792	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	66.1188	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	66.198	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	66.2376	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	66.3168	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	66.3564	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	66.4356	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	66.4752	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	66.5148	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	66.5544	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	66.594	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	66.6336	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	66.6732	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	66.7128	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	66.7524	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	66.792	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	66.8316	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	66.8712	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	66.9108	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	66.9504	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	66.99	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	67.0296	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	67.0692	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	67.1088	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	67.1484	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	67.188	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	67.2276	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	67.2672	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	67.3068	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	69.4347	3.4500000477	190.476190	1	1417.500000	0.000000	1.700000	1.000000	21
i1	69.3105	3.4500000477	266.666667	1	1012.500000	0.000000	1.700000	1.000000	15
i1	69.1863	3.4500000477	444.444444	1	607.500000	0.000000	1.700000	1.000000	9
i1	69.0621	3.4500000477	1333.333333	1	202.500000	0.000000	1.700000	1.000000	3
i1	69.0414	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	69.0828	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	69.1656	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	69.207	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	69.2898	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	69.3312	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	69.414	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	69.4554	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	73.4472	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	73.404	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	73.3608	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	73.3176	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	73.2744	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	73.2312	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	73.188	3.4500000477	72.727273	1	3712.500000	0.000000	1.700000	1.000000	55
i1	73.1448	3.4500000477	75.471698	1	3577.500000	0.000000	1.700000	1.000000	53
i1	73.1016	3.4500000477	78.431373	1	3442.500000	0.000000	1.700000	1.000000	51
i1	73.0584	3.4500000477	81.632653	1	3307.500000	0.000000	1.700000	1.000000	49
i1	73.0152	3.4500000477	85.106383	1	3172.500000	0.000000	1.700000	1.000000	47
i1	72.972	3.4500000477	88.888889	1	3037.500000	0.000000	1.700000	1.000000	45
i1	72.9288	3.4500000477	93.023256	1	2902.500000	0.000000	1.700000	1.000000	43
i1	72.8856	3.4500000477	97.560976	1	2767.500000	0.000000	1.700000	1.000000	41
i1	72.8424	3.4500000477	102.564103	1	2632.500000	0.000000	1.700000	1.000000	39
i1	72.7992	3.4500000477	108.108108	1	2497.500000	0.000000	1.700000	1.000000	37
i1	72.756	3.4500000477	114.285714	1	2362.500000	0.000000	1.700000	1.000000	35
i1	72.7128	3.4500000477	121.212121	1	2227.500000	0.000000	1.700000	1.000000	33
i1	72.6696	3.4500000477	129.032258	1	2092.500000	0.000000	1.700000	1.000000	31
i1	72.6264	3.4500000477	137.931034	1	1957.500000	0.000000	1.700000	1.000000	29
i1	72.5832	3.4500000477	148.148148	1	1822.500000	0.000000	1.700000	1.000000	27
i1	72.54	3.4500000477	160.000000	1	1687.500000	0.000000	1.700000	1.000000	25
i1	72.4104	3.4500000477	210.526316	1	1282.500000	0.000000	1.700000	1.000000	19
i1	72.2808	3.4500000477	307.692308	1	877.500000	0.000000	1.700000	1.000000	13
i1	72.1512	3.4500000477	571.428571	1	472.500000	0.000000	1.700000	1.000000	7
i1	72.0216	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	72.0432	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	72.1296	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	72.1728	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	72.2592	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	72.3024	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	72.3888	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	72.432	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	72.5184	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	72.5616	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	72.6048	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	72.648	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	72.6912	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	72.7344	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	72.7776	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	72.8208	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	72.864	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	72.9072	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	72.9504	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	72.9936	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	73.0368	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	73.08	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	73.1232	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	73.1664	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	73.2096	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	73.2528	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	73.296	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	73.3392	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	73.3824	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	73.4256	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	75.5175	3.4500000477	173.913043	1	1552.500000	0.000000	1.700000	1.000000	23
i1	75.3825	3.4500000477	235.294118	1	1147.500000	0.000000	1.700000	1.000000	17
i1	75.2475	3.4500000477	363.636364	1	742.500000	0.000000	1.700000	1.000000	11
i1	75.1125	3.4500000477	800.000000	1	337.500000	0.000000	1.700000	1.000000	5
i1	75.0225	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	75.09	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	75.135	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	75.225	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	75.27	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	75.36	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	75.405	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	75.495	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	75.54	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	79.5678	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	79.521	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	79.4742	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	79.4274	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	79.3806	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	79.3338	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	79.287	3.4500000477	72.727273	1	3712.500000	0.000000	1.700000	1.000000	55
i1	79.2402	3.4500000477	75.471698	1	3577.500000	0.000000	1.700000	1.000000	53
i1	79.1934	3.4500000477	78.431373	1	3442.500000	0.000000	1.700000	1.000000	51
i1	79.1466	3.4500000477	81.632653	1	3307.500000	0.000000	1.700000	1.000000	49
i1	79.0998	3.4500000477	85.106383	1	3172.500000	0.000000	1.700000	1.000000	47
i1	79.053	3.4500000477	88.888889	1	3037.500000	0.000000	1.700000	1.000000	45
i1	79.0062	3.4500000477	93.023256	1	2902.500000	0.000000	1.700000	1.000000	43
i1	78.9594	3.4500000477	97.560976	1	2767.500000	0.000000	1.700000	1.000000	41
i1	78.9126	3.4500000477	102.564103	1	2632.500000	0.000000	1.700000	1.000000	39
i1	78.8658	3.4500000477	108.108108	1	2497.500000	0.000000	1.700000	1.000000	37
i1	78.819	3.4500000477	114.285714	1	2362.500000	0.000000	1.700000	1.000000	35
i1	78.7722	3.4500000477	121.212121	1	2227.500000	0.000000	1.700000	1.000000	33
i1	78.7254	3.4500000477	129.032258	1	2092.500000	0.000000	1.700000	1.000000	31
i1	78.6786	3.4500000477	137.931034	1	1957.500000	0.000000	1.700000	1.000000	29
i1	78.6318	3.4500000477	148.148148	1	1822.500000	0.000000	1.700000	1.000000	27
i1	78.4914	3.4500000477	190.476190	1	1417.500000	0.000000	1.700000	1.000000	21
i1	78.351	3.4500000477	266.666667	1	1012.500000	0.000000	1.700000	1.000000	15
i1	78.2106	3.4500000477	444.444444	1	607.500000	0.000000	1.700000	1.000000	9
i1	78.0702	3.4500000477	1333.333333	1	202.500000	0.000000	1.700000	1.000000	3
i1	78.0468	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	78.0936	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	78.1872	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	78.234	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	78.3276	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	78.3744	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	78.468	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	78.5148	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	78.6084	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	78.6552	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	78.702	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	78.7488	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	78.7956	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	78.8424	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	78.8892	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	78.936	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	78.9828	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	79.0296	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	79.0764	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	79.1232	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	79.17	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	79.2168	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	79.2636	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	79.3104	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	79.3572	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	79.404	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	79.4508	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	79.4976	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	79.5444	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	81.6075	3.4500000477	160.000000	1	1687.500000	0.000000	1.700000	1.000000	25
i1	81.4617	3.4500000477	210.526316	1	1282.500000	0.000000	1.700000	1.000000	19
i1	81.3159	3.4500000477	307.692308	1	877.500000	0.000000	1.700000	1.000000	13
i1	81.1701	3.4500000477	571.428571	1	472.500000	0.000000	1.700000	1.000000	7
i1	81.0243	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	81.0486	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	81.1458	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	81.1944	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	81.2916	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	81.3402	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	81.4374	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	81.486	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	81.5832	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	81.6318	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	85.6884	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	85.638	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	85.5876	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	85.5372	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	85.4868	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	85.4364	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	85.386	3.4500000477	72.727273	1	3712.500000	0.000000	1.700000	1.000000	55
i1	85.3356	3.4500000477	75.471698	1	3577.500000	0.000000	1.700000	1.000000	53
i1	85.2852	3.4500000477	78.431373	1	3442.500000	0.000000	1.700000	1.000000	51
i1	85.2348	3.4500000477	81.632653	1	3307.500000	0.000000	1.700000	1.000000	49
i1	85.1844	3.4500000477	85.106383	1	3172.500000	0.000000	1.700000	1.000000	47
i1	85.134	3.4500000477	88.888889	1	3037.500000	0.000000	1.700000	1.000000	45
i1	85.0836	3.4500000477	93.023256	1	2902.500000	0.000000	1.700000	1.000000	43
i1	85.0332	3.4500000477	97.560976	1	2767.500000	0.000000	1.700000	1.000000	41
i1	84.9828	3.4500000477	102.564103	1	2632.500000	0.000000	1.700000	1.000000	39
i1	84.9324	3.4500000477	108.108108	1	2497.500000	0.000000	1.700000	1.000000	37
i1	84.882	3.4500000477	114.285714	1	2362.500000	0.000000	1.700000	1.000000	35
i1	84.8316	3.4500000477	121.212121	1	2227.500000	0.000000	1.700000	1.000000	33
i1	84.7812	3.4500000477	129.032258	1	2092.500000	0.000000	1.700000	1.000000	31
i1	84.7308	3.4500000477	137.931034	1	1957.500000	0.000000	1.700000	1.000000	29
i1	84.5796	3.4500000477	173.913043	1	1552.500000	0.000000	1.700000	1.000000	23
i1	84.4284	3.4500000477	235.294118	1	1147.500000	0.000000	1.700000	1.000000	17
i1	84.2772	3.4500000477	363.636364	1	742.500000	0.000000	1.700000	1.000000	11
i1	84.126	3.4500000477	800.000000	1	337.500000	0.000000	1.700000	1.000000	5
i1	84.0252	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	84.1008	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	84.1512	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	84.252	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	84.3024	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	84.4032	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	84.4536	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	84.5544	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	84.6048	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	84.7056	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	84.756	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	84.8064	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	84.8568	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	84.9072	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	84.9576	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	85.008	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	85.0584	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	85.1088	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	85.1592	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	85.2096	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	85.26	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	85.3104	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	85.3608	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	85.4112	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	85.4616	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	85.512	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	85.5624	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	85.6128	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	85.6632	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	87.7047	3.4500000477	148.148148	1	1822.500000	0.000000	1.700000	1.000000	27
i1	87.5481	3.4500000477	190.476190	1	1417.500000	0.000000	1.700000	1.000000	21
i1	87.3915	3.4500000477	266.666667	1	1012.500000	0.000000	1.700000	1.000000	15
i1	87.2349	3.4500000477	444.444444	1	607.500000	0.000000	1.700000	1.000000	9
i1	87.0783	3.4500000477	1333.333333	1	202.500000	0.000000	1.700000	1.000000	3
i1	87.0522	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	87.1044	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	87.2088	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	87.261	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	87.3654	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	87.4176	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	87.522	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	87.5742	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	87.6786	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	87.7308	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	91.809	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	91.755	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	91.701	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	91.647	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	91.593	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	91.539	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	91.485	3.4500000477	72.727273	1	3712.500000	0.000000	1.700000	1.000000	55
i1	91.431	3.4500000477	75.471698	1	3577.500000	0.000000	1.700000	1.000000	53
i1	91.377	3.4500000477	78.431373	1	3442.500000	0.000000	1.700000	1.000000	51
i1	91.323	3.4500000477	81.632653	1	3307.500000	0.000000	1.700000	1.000000	49
i1	91.269	3.4500000477	85.106383	1	3172.500000	0.000000	1.700000	1.000000	47
i1	91.215	3.4500000477	88.888889	1	3037.500000	0.000000	1.700000	1.000000	45
i1	91.161	3.4500000477	93.023256	1	2902.500000	0.000000	1.700000	1.000000	43
i1	91.107	3.4500000477	97.560976	1	2767.500000	0.000000	1.700000	1.000000	41
i1	91.053	3.4500000477	102.564103	1	2632.500000	0.000000	1.700000	1.000000	39
i1	90.999	3.4500000477	108.108108	1	2497.500000	0.000000	1.700000	1.000000	37
i1	90.945	3.4500000477	114.285714	1	2362.500000	0.000000	1.700000	1.000000	35
i1	90.891	3.4500000477	121.212121	1	2227.500000	0.000000	1.700000	1.000000	33
i1	90.837	3.4500000477	129.032258	1	2092.500000	0.000000	1.700000	1.000000	31
i1	90.675	3.4500000477	160.000000	1	1687.500000	0.000000	1.700000	1.000000	25
i1	90.513	3.4500000477	210.526316	1	1282.500000	0.000000	1.700000	1.000000	19
i1	90.351	3.4500000477	307.692308	1	877.500000	0.000000	1.700000	1.000000	13
i1	90.189	3.4500000477	571.428571	1	472.500000	0.000000	1.700000	1.000000	7
i1	90.027	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	90.054	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	90.162	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	90.216	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	90.324	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	90.378	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	90.486	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	90.54	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	90.648	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	90.702	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	90.81	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	90.864	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	90.918	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	90.972	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	91.026	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	91.08	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	91.134	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	91.188	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	91.242	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	91.296	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	91.35	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	91.404	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	91.458	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	91.512	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	91.566	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	91.62	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	91.674	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	91.728	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	91.782	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	93.8091	3.4500000477	137.931034	1	1957.500000	0.000000	1.700000	1.000000	29
i1	93.6417	3.4500000477	173.913043	1	1552.500000	0.000000	1.700000	1.000000	23
i1	93.4743	3.4500000477	235.294118	1	1147.500000	0.000000	1.700000	1.000000	17
i1	93.3069	3.4500000477	363.636364	1	742.500000	0.000000	1.700000	1.000000	11
i1	93.1395	3.4500000477	800.000000	1	337.500000	0.000000	1.700000	1.000000	5
i1	93.0279	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	93.1116	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	93.1674	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	93.279	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	93.3348	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	93.4464	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	93.5022	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	93.6138	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	93.6696	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	93.7812	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	93.837	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	97.9296	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	97.872	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	97.8144	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	97.7568	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	97.6992	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	97.6416	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	97.584	3.4500000477	72.727273	1	3712.500000	0.000000	1.700000	1.000000	55
i1	97.5264	3.4500000477	75.471698	1	3577.500000	0.000000	1.700000	1.000000	53
i1	97.4688	3.4500000477	78.431373	1	3442.500000	0.000000	1.700000	1.000000	51
i1	97.4112	3.4500000477	81.632653	1	3307.500000	0.000000	1.700000	1.000000	49
i1	97.3536	3.4500000477	85.106383	1	3172.500000	0.000000	1.700000	1.000000	47
i1	97.296	3.4500000477	88.888889	1	3037.500000	0.000000	1.700000	1.000000	45
i1	97.2384	3.4500000477	93.023256	1	2902.500000	0.000000	1.700000	1.000000	43
i1	97.1808	3.4500000477	97.560976	1	2767.500000	0.000000	1.700000	1.000000	41
i1	97.1232	3.4500000477	102.564103	1	2632.500000	0.000000	1.700000	1.000000	39
i1	97.0656	3.4500000477	108.108108	1	2497.500000	0.000000	1.700000	1.000000	37
i1	97.008	3.4500000477	114.285714	1	2362.500000	0.000000	1.700000	1.000000	35
i1	96.9504	3.4500000477	121.212121	1	2227.500000	0.000000	1.700000	1.000000	33
i1	96.7776	3.4500000477	148.148148	1	1822.500000	0.000000	1.700000	1.000000	27
i1	96.6048	3.4500000477	190.476190	1	1417.500000	0.000000	1.700000	1.000000	21
i1	96.432	3.4500000477	266.666667	1	1012.500000	0.000000	1.700000	1.000000	15
i1	96.2592	3.4500000477	444.444444	1	607.500000	0.000000	1.700000	1.000000	9
i1	96.0864	3.4500000477	1333.333333	1	202.500000	0.000000	1.700000	1.000000	3
i1	96.0576	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	96.1152	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	96.2304	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	96.288	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	96.4032	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	96.4608	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	96.576	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	96.6336	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	96.7488	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	96.8064	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	96.9216	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	96.9792	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	97.0368	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	97.0944	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	97.152	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	97.2096	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	97.2672	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	97.3248	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	97.3824	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	97.44	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	97.4976	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	97.5552	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	97.6128	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	97.6704	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	97.728	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	97.7856	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	97.8432	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	97.9008	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	99.9207	3.4500000477	129.032258	1	2092.500000	0.000000	1.700000	1.000000	31
i1	99.7425	3.4500000477	160.000000	1	1687.500000	0.000000	1.700000	1.000000	25
i1	99.5643	3.4500000477	210.526316	1	1282.500000	0.000000	1.700000	1.000000	19
i1	99.3861	3.4500000477	307.692308	1	877.500000	0.000000	1.700000	1.000000	13
i1	99.2079	3.4500000477	571.428571	1	472.500000	0.000000	1.700000	1.000000	7
i1	99.0297	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	99.0594	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	99.1782	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	99.2376	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	99.3564	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	99.4158	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	99.5346	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	99.594	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	99.7128	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	99.7722	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	99.891	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	99.9504	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	104.0502	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	103.989	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	103.9278	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	103.8666	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	103.8054	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	103.7442	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	103.683	3.4500000477	72.727273	1	3712.500000	0.000000	1.700000	1.000000	55
i1	103.6218	3.4500000477	75.471698	1	3577.500000	0.000000	1.700000	1.000000	53
i1	103.5606	3.4500000477	78.431373	1	3442.500000	0.000000	1.700000	1.000000	51
i1	103.4994	3.4500000477	81.632653	1	3307.500000	0.000000	1.700000	1.000000	49
i1	103.4382	3.4500000477	85.106383	1	3172.500000	0.000000	1.700000	1.000000	47
i1	103.377	3.4500000477	88.888889	1	3037.500000	0.000000	1.700000	1.000000	45
i1	103.3158	3.4500000477	93.023256	1	2902.500000	0.000000	1.700000	1.000000	43
i1	103.2546	3.4500000477	97.560976	1	2767.500000	0.000000	1.700000	1.000000	41
i1	103.1934	3.4500000477	102.564103	1	2632.500000	0.000000	1.700000	1.000000	39
i1	103.1322	3.4500000477	108.108108	1	2497.500000	0.000000	1.700000	1.000000	37
i1	103.071	3.4500000477	114.285714	1	2362.500000	0.000000	1.700000	1.000000	35
i1	102.8874	3.4500000477	137.931034	1	1957.500000	0.000000	1.700000	1.000000	29
i1	102.7038	3.4500000477	173.913043	1	1552.500000	0.000000	1.700000	1.000000	23
i1	102.5202	3.4500000477	235.294118	1	1147.500000	0.000000	1.700000	1.000000	17
i1	102.3366	3.4500000477	363.636364	1	742.500000	0.000000	1.700000	1.000000	11
i1	102.153	3.4500000477	800.000000	1	337.500000	0.000000	1.700000	1.000000	5
i1	102.0306	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	102.1224	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	102.1836	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	102.306	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	102.3672	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	102.4896	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	102.5508	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	102.6732	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	102.7344	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	102.8568	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	102.918	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	103.0404	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	103.1016	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	103.1628	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	103.224	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	103.2852	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	103.3464	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	103.4076	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	103.4688	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	103.53	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	103.5912	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	103.6524	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	103.7136	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	103.7748	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	103.836	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	103.8972	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	103.9584	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	104.0196	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	106.0395	3.4500000477	121.212121	1	2227.500000	0.000000	1.700000	1.000000	33
i1	105.8505	3.4500000477	148.148148	1	1822.500000	0.000000	1.700000	1.000000	27
i1	105.6615	3.4500000477	190.476190	1	1417.500000	0.000000	1.700000	1.000000	21
i1	105.4725	3.4500000477	266.666667	1	1012.500000	0.000000	1.700000	1.000000	15
i1	105.2835	3.4500000477	444.444444	1	607.500000	0.000000	1.700000	1.000000	9
i1	105.0945	3.4500000477	1333.333333	1	202.500000	0.000000	1.700000	1.000000	3
i1	105.063	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	105.126	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	105.252	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	105.315	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	105.441	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	105.504	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	105.63	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	105.693	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	105.819	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	105.882	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	106.008	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	106.071	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	110.1708	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	110.106	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	110.0412	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	109.9764	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	109.9116	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	109.8468	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	109.782	3.4500000477	72.727273	1	3712.500000	0.000000	1.700000	1.000000	55
i1	109.7172	3.4500000477	75.471698	1	3577.500000	0.000000	1.700000	1.000000	53
i1	109.6524	3.4500000477	78.431373	1	3442.500000	0.000000	1.700000	1.000000	51
i1	109.5876	3.4500000477	81.632653	1	3307.500000	0.000000	1.700000	1.000000	49
i1	109.5228	3.4500000477	85.106383	1	3172.500000	0.000000	1.700000	1.000000	47
i1	109.458	3.4500000477	88.888889	1	3037.500000	0.000000	1.700000	1.000000	45
i1	109.3932	3.4500000477	93.023256	1	2902.500000	0.000000	1.700000	1.000000	43
i1	109.3284	3.4500000477	97.560976	1	2767.500000	0.000000	1.700000	1.000000	41
i1	109.2636	3.4500000477	102.564103	1	2632.500000	0.000000	1.700000	1.000000	39
i1	109.1988	3.4500000477	108.108108	1	2497.500000	0.000000	1.700000	1.000000	37
i1	109.0044	3.4500000477	129.032258	1	2092.500000	0.000000	1.700000	1.000000	31
i1	108.81	3.4500000477	160.000000	1	1687.500000	0.000000	1.700000	1.000000	25
i1	108.6156	3.4500000477	210.526316	1	1282.500000	0.000000	1.700000	1.000000	19
i1	108.4212	3.4500000477	307.692308	1	877.500000	0.000000	1.700000	1.000000	13
i1	108.2268	3.4500000477	571.428571	1	472.500000	0.000000	1.700000	1.000000	7
i1	108.0324	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	108.0648	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	108.1944	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	108.2592	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	108.3888	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	108.4536	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	108.5832	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	108.648	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	108.7776	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	108.8424	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	108.972	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	109.0368	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	109.1664	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	109.2312	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	109.296	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	109.3608	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	109.4256	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	109.4904	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	109.5552	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	109.62	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	109.6848	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	109.7496	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	109.8144	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	109.8792	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	109.944	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	110.0088	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	110.0736	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	110.1384	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	112.1655	3.4500000477	114.285714	1	2362.500000	0.000000	1.700000	1.000000	35
i1	111.9657	3.4500000477	137.931034	1	1957.500000	0.000000	1.700000	1.000000	29
i1	111.7659	3.4500000477	173.913043	1	1552.500000	0.000000	1.700000	1.000000	23
i1	111.5661	3.4500000477	235.294118	1	1147.500000	0.000000	1.700000	1.000000	17
i1	111.3663	3.4500000477	363.636364	1	742.500000	0.000000	1.700000	1.000000	11
i1	111.1665	3.4500000477	800.000000	1	337.500000	0.000000	1.700000	1.000000	5
i1	111.0333	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	111.1332	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	111.1998	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	111.333	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	111.3996	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	111.5328	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	111.5994	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	111.7326	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	111.7992	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	111.9324	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	111.999	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	112.1322	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	112.1988	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	116.2914	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	116.223	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	116.1546	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	116.0862	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	116.0178	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	115.9494	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	115.881	3.4500000477	72.727273	1	3712.500000	0.000000	1.700000	1.000000	55
i1	115.8126	3.4500000477	75.471698	1	3577.500000	0.000000	1.700000	1.000000	53
i1	115.7442	3.4500000477	78.431373	1	3442.500000	0.000000	1.700000	1.000000	51
i1	115.6758	3.4500000477	81.632653	1	3307.500000	0.000000	1.700000	1.000000	49
i1	115.6074	3.4500000477	85.106383	1	3172.500000	0.000000	1.700000	1.000000	47
i1	115.539	3.4500000477	88.888889	1	3037.500000	0.000000	1.700000	1.000000	45
i1	115.4706	3.4500000477	93.023256	1	2902.500000	0.000000	1.700000	1.000000	43
i1	115.4022	3.4500000477	97.560976	1	2767.500000	0.000000	1.700000	1.000000	41
i1	115.3338	3.4500000477	102.564103	1	2632.500000	0.000000	1.700000	1.000000	39
i1	115.1286	3.4500000477	121.212121	1	2227.500000	0.000000	1.700000	1.000000	33
i1	114.9234	3.4500000477	148.148148	1	1822.500000	0.000000	1.700000	1.000000	27
i1	114.7182	3.4500000477	190.476190	1	1417.500000	0.000000	1.700000	1.000000	21
i1	114.513	3.4500000477	266.666667	1	1012.500000	0.000000	1.700000	1.000000	15
i1	114.3078	3.4500000477	444.444444	1	607.500000	0.000000	1.700000	1.000000	9
i1	114.1026	3.4500000477	1333.333333	1	202.500000	0.000000	1.700000	1.000000	3
i1	114.0684	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	114.1368	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	114.2736	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	114.342	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	114.4788	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	114.5472	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	114.684	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	114.7524	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	114.8892	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	114.9576	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	115.0944	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	115.1628	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	115.2996	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	115.368	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	115.4364	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	115.5048	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	115.5732	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	115.6416	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	115.71	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	115.7784	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	115.8468	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	115.9152	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	115.9836	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	116.052	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	116.1204	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	116.1888	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	116.2572	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	118.2987	3.4500000477	108.108108	1	2497.500000	0.000000	1.700000	1.000000	37
i1	118.0881	3.4500000477	129.032258	1	2092.500000	0.000000	1.700000	1.000000	31
i1	117.8775	3.4500000477	160.000000	1	1687.500000	0.000000	1.700000	1.000000	25
i1	117.6669	3.4500000477	210.526316	1	1282.500000	0.000000	1.700000	1.000000	19
i1	117.4563	3.4500000477	307.692308	1	877.500000	0.000000	1.700000	1.000000	13
i1	117.2457	3.4500000477	571.428571	1	472.500000	0.000000	1.700000	1.000000	7
i1	117.0351	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	117.0702	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	117.2106	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	117.2808	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	117.4212	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	117.4914	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	117.6318	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	117.702	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	117.8424	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	117.9126	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	118.053	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	118.1232	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	118.2636	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	118.3338	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	122.412	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	122.34	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	122.268	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	122.196	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	122.124	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	122.052	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	121.98	3.4500000477	72.727273	1	3712.500000	0.000000	1.700000	1.000000	55
i1	121.908	3.4500000477	75.471698	1	3577.500000	0.000000	1.700000	1.000000	53
i1	121.836	3.4500000477	78.431373	1	3442.500000	0.000000	1.700000	1.000000	51
i1	121.764	3.4500000477	81.632653	1	3307.500000	0.000000	1.700000	1.000000	49
i1	121.692	3.4500000477	85.106383	1	3172.500000	0.000000	1.700000	1.000000	47
i1	121.62	3.4500000477	88.888889	1	3037.500000	0.000000	1.700000	1.000000	45
i1	121.548	3.4500000477	93.023256	1	2902.500000	0.000000	1.700000	1.000000	43
i1	121.476	3.4500000477	97.560976	1	2767.500000	0.000000	1.700000	1.000000	41
i1	121.26	3.4500000477	114.285714	1	2362.500000	0.000000	1.700000	1.000000	35
i1	121.044	3.4500000477	137.931034	1	1957.500000	0.000000	1.700000	1.000000	29
i1	120.828	3.4500000477	173.913043	1	1552.500000	0.000000	1.700000	1.000000	23
i1	120.612	3.4500000477	235.294118	1	1147.500000	0.000000	1.700000	1.000000	17
i1	120.396	3.4500000477	363.636364	1	742.500000	0.000000	1.700000	1.000000	11
i1	120.18	3.4500000477	800.000000	1	337.500000	0.000000	1.700000	1.000000	5
i1	120.036	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	120.144	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	120.216	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	120.36	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	120.432	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	120.576	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	120.648	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	120.792	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	120.864	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	121.008	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	121.08	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	121.224	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	121.296	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	121.44	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	121.512	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	121.584	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	121.656	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	121.728	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	121.8	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	121.872	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	121.944	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	122.016	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	122.088	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	122.16	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	122.232	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	122.304	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	122.376	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	124.4391	3.4500000477	102.564103	1	2632.500000	0.000000	1.700000	1.000000	39
i1	124.2177	3.4500000477	121.212121	1	2227.500000	0.000000	1.700000	1.000000	33
i1	123.9963	3.4500000477	148.148148	1	1822.500000	0.000000	1.700000	1.000000	27
i1	123.7749	3.4500000477	190.476190	1	1417.500000	0.000000	1.700000	1.000000	21
i1	123.5535	3.4500000477	266.666667	1	1012.500000	0.000000	1.700000	1.000000	15
i1	123.3321	3.4500000477	444.444444	1	607.500000	0.000000	1.700000	1.000000	9
i1	123.1107	3.4500000477	1333.333333	1	202.500000	0.000000	1.700000	1.000000	3
i1	123.0738	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	123.1476	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	123.2952	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	123.369	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	123.5166	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	123.5904	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	123.738	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	123.8118	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	123.9594	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	124.0332	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	124.1808	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	124.2546	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	124.4022	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	124.476	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	128.5326	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	128.457	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	128.3814	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	128.3058	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	128.2302	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	128.1546	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	128.079	3.4500000477	72.727273	1	3712.500000	0.000000	1.700000	1.000000	55
i1	128.0034	3.4500000477	75.471698	1	3577.500000	0.000000	1.700000	1.000000	53
i1	127.9278	3.4500000477	78.431373	1	3442.500000	0.000000	1.700000	1.000000	51
i1	127.8522	3.4500000477	81.632653	1	3307.500000	0.000000	1.700000	1.000000	49
i1	127.7766	3.4500000477	85.106383	1	3172.500000	0.000000	1.700000	1.000000	47
i1	127.701	3.4500000477	88.888889	1	3037.500000	0.000000	1.700000	1.000000	45
i1	127.6254	3.4500000477	93.023256	1	2902.500000	0.000000	1.700000	1.000000	43
i1	127.3986	3.4500000477	108.108108	1	2497.500000	0.000000	1.700000	1.000000	37
i1	127.1718	3.4500000477	129.032258	1	2092.500000	0.000000	1.700000	1.000000	31
i1	126.945	3.4500000477	160.000000	1	1687.500000	0.000000	1.700000	1.000000	25
i1	126.7182	3.4500000477	210.526316	1	1282.500000	0.000000	1.700000	1.000000	19
i1	126.4914	3.4500000477	307.692308	1	877.500000	0.000000	1.700000	1.000000	13
i1	126.2646	3.4500000477	571.428571	1	472.500000	0.000000	1.700000	1.000000	7
i1	126.0378	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	126.0756	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	126.2268	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	126.3024	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	126.4536	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	126.5292	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	126.6804	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	126.756	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	126.9072	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	126.9828	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	127.134	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	127.2096	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	127.3608	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	127.4364	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	127.5876	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	127.6632	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	127.7388	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	127.8144	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	127.89	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	127.9656	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	128.0412	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	128.1168	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	128.1924	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	128.268	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	128.3436	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	128.4192	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	128.4948	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	130.5867	3.4500000477	97.560976	1	2767.500000	0.000000	1.700000	1.000000	41
i1	130.3545	3.4500000477	114.285714	1	2362.500000	0.000000	1.700000	1.000000	35
i1	130.1223	3.4500000477	137.931034	1	1957.500000	0.000000	1.700000	1.000000	29
i1	129.8901	3.4500000477	173.913043	1	1552.500000	0.000000	1.700000	1.000000	23
i1	129.6579	3.4500000477	235.294118	1	1147.500000	0.000000	1.700000	1.000000	17
i1	129.4257	3.4500000477	363.636364	1	742.500000	0.000000	1.700000	1.000000	11
i1	129.1935	3.4500000477	800.000000	1	337.500000	0.000000	1.700000	1.000000	5
i1	129.0387	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	129.1548	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	129.2322	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	129.387	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	129.4644	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	129.6192	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	129.6966	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	129.8514	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	129.9288	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	130.0836	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	130.161	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	130.3158	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	130.3932	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	130.548	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	130.6254	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	134.6532	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	134.574	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	134.4948	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	134.4156	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	134.3364	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	134.2572	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	134.178	3.4500000477	72.727273	1	3712.500000	0.000000	1.700000	1.000000	55
i1	134.0988	3.4500000477	75.471698	1	3577.500000	0.000000	1.700000	1.000000	53
i1	134.0196	3.4500000477	78.431373	1	3442.500000	0.000000	1.700000	1.000000	51
i1	133.9404	3.4500000477	81.632653	1	3307.500000	0.000000	1.700000	1.000000	49
i1	133.8612	3.4500000477	85.106383	1	3172.500000	0.000000	1.700000	1.000000	47
i1	133.782	3.4500000477	88.888889	1	3037.500000	0.000000	1.700000	1.000000	45
i1	133.5444	3.4500000477	102.564103	1	2632.500000	0.000000	1.700000	1.000000	39
i1	133.3068	3.4500000477	121.212121	1	2227.500000	0.000000	1.700000	1.000000	33
i1	133.0692	3.4500000477	148.148148	1	1822.500000	0.000000	1.700000	1.000000	27
i1	132.8316	3.4500000477	190.476190	1	1417.500000	0.000000	1.700000	1.000000	21
i1	132.594	3.4500000477	266.666667	1	1012.500000	0.000000	1.700000	1.000000	15
i1	132.3564	3.4500000477	444.444444	1	607.500000	0.000000	1.700000	1.000000	9
i1	132.1188	3.4500000477	1333.333333	1	202.500000	0.000000	1.700000	1.000000	3
i1	132.0792	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	132.1584	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	132.3168	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	132.396	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	132.5544	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	132.6336	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	132.792	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	132.8712	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	133.0296	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	133.1088	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	133.2672	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	133.3464	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	133.5048	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	133.584	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	133.7424	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	133.8216	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	133.9008	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	133.98	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	134.0592	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	134.1384	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	134.2176	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	134.2968	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	134.376	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	134.4552	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	134.5344	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	134.6136	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	136.7415	3.4500000477	93.023256	1	2902.500000	0.000000	1.700000	1.000000	43
i1	136.4985	3.4500000477	108.108108	1	2497.500000	0.000000	1.700000	1.000000	37
i1	136.2555	3.4500000477	129.032258	1	2092.500000	0.000000	1.700000	1.000000	31
i1	136.0125	3.4500000477	160.000000	1	1687.500000	0.000000	1.700000	1.000000	25
i1	135.7695	3.4500000477	210.526316	1	1282.500000	0.000000	1.700000	1.000000	19
i1	135.5265	3.4500000477	307.692308	1	877.500000	0.000000	1.700000	1.000000	13
i1	135.2835	3.4500000477	571.428571	1	472.500000	0.000000	1.700000	1.000000	7
i1	135.0405	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	135.081	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	135.243	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	135.324	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	135.486	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	135.567	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	135.729	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	135.81	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	135.972	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	136.053	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	136.215	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	136.296	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	136.458	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	136.539	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	136.701	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	136.782	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	140.7738	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	140.691	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	140.6082	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	140.5254	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	140.4426	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	140.3598	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	140.277	3.4500000477	72.727273	1	3712.500000	0.000000	1.700000	1.000000	55
i1	140.1942	3.4500000477	75.471698	1	3577.500000	0.000000	1.700000	1.000000	53
i1	140.1114	3.4500000477	78.431373	1	3442.500000	0.000000	1.700000	1.000000	51
i1	140.0286	3.4500000477	81.632653	1	3307.500000	0.000000	1.700000	1.000000	49
i1	139.9458	3.4500000477	85.106383	1	3172.500000	0.000000	1.700000	1.000000	47
i1	139.6974	3.4500000477	97.560976	1	2767.500000	0.000000	1.700000	1.000000	41
i1	139.449	3.4500000477	114.285714	1	2362.500000	0.000000	1.700000	1.000000	35
i1	139.2006	3.4500000477	137.931034	1	1957.500000	0.000000	1.700000	1.000000	29
i1	138.9522	3.4500000477	173.913043	1	1552.500000	0.000000	1.700000	1.000000	23
i1	138.7038	3.4500000477	235.294118	1	1147.500000	0.000000	1.700000	1.000000	17
i1	138.4554	3.4500000477	363.636364	1	742.500000	0.000000	1.700000	1.000000	11
i1	138.207	3.4500000477	800.000000	1	337.500000	0.000000	1.700000	1.000000	5
i1	138.0414	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	138.1656	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	138.2484	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	138.414	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	138.4968	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	138.6624	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	138.7452	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	138.9108	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	138.9936	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	139.1592	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	139.242	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	139.4076	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	139.4904	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	139.656	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	139.7388	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	139.9044	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	139.9872	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	140.07	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	140.1528	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	140.2356	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	140.3184	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	140.4012	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	140.484	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	140.5668	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	140.6496	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	140.7324	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	142.9035	3.4500000477	88.888889	1	3037.500000	0.000000	1.700000	1.000000	45
i1	142.6497	3.4500000477	102.564103	1	2632.500000	0.000000	1.700000	1.000000	39
i1	142.3959	3.4500000477	121.212121	1	2227.500000	0.000000	1.700000	1.000000	33
i1	142.1421	3.4500000477	148.148148	1	1822.500000	0.000000	1.700000	1.000000	27
i1	141.8883	3.4500000477	190.476190	1	1417.500000	0.000000	1.700000	1.000000	21
i1	141.6345	3.4500000477	266.666667	1	1012.500000	0.000000	1.700000	1.000000	15
i1	141.3807	3.4500000477	444.444444	1	607.500000	0.000000	1.700000	1.000000	9
i1	141.1269	3.4500000477	1333.333333	1	202.500000	0.000000	1.700000	1.000000	3
i1	141.0846	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	141.1692	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	141.3384	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	141.423	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	141.5922	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	141.6768	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	141.846	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	141.9306	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	142.0998	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	142.1844	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	142.3536	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	142.4382	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	142.6074	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	142.692	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	142.8612	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	142.9458	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	146.8944	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	146.808	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	146.7216	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	146.6352	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	146.5488	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	146.4624	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	146.376	3.4500000477	72.727273	1	3712.500000	0.000000	1.700000	1.000000	55
i1	146.2896	3.4500000477	75.471698	1	3577.500000	0.000000	1.700000	1.000000	53
i1	146.2032	3.4500000477	78.431373	1	3442.500000	0.000000	1.700000	1.000000	51
i1	146.1168	3.4500000477	81.632653	1	3307.500000	0.000000	1.700000	1.000000	49
i1	145.8576	3.4500000477	93.023256	1	2902.500000	0.000000	1.700000	1.000000	43
i1	145.5984	3.4500000477	108.108108	1	2497.500000	0.000000	1.700000	1.000000	37
i1	145.3392	3.4500000477	129.032258	1	2092.500000	0.000000	1.700000	1.000000	31
i1	145.08	3.4500000477	160.000000	1	1687.500000	0.000000	1.700000	1.000000	25
i1	144.8208	3.4500000477	210.526316	1	1282.500000	0.000000	1.700000	1.000000	19
i1	144.5616	3.4500000477	307.692308	1	877.500000	0.000000	1.700000	1.000000	13
i1	144.3024	3.4500000477	571.428571	1	472.500000	0.000000	1.700000	1.000000	7
i1	144.0432	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	144.0864	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	144.2592	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	144.3456	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	144.5184	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	144.6048	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	144.7776	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	144.864	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	145.0368	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	145.1232	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	145.296	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	145.3824	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	145.5552	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	145.6416	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	145.8144	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	145.9008	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	146.0736	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	146.16	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	146.2464	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	146.3328	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	146.4192	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	146.5056	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	146.592	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	146.6784	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	146.7648	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	146.8512	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	149.0727	3.4500000477	85.106383	1	3172.500000	0.000000	1.700000	1.000000	47
i1	148.8081	3.4500000477	97.560976	1	2767.500000	0.000000	1.700000	1.000000	41
i1	148.5435	3.4500000477	114.285714	1	2362.500000	0.000000	1.700000	1.000000	35
i1	148.2789	3.4500000477	137.931034	1	1957.500000	0.000000	1.700000	1.000000	29
i1	148.0143	3.4500000477	173.913043	1	1552.500000	0.000000	1.700000	1.000000	23
i1	147.7497	3.4500000477	235.294118	1	1147.500000	0.000000	1.700000	1.000000	17
i1	147.4851	3.4500000477	363.636364	1	742.500000	0.000000	1.700000	1.000000	11
i1	147.2205	3.4500000477	800.000000	1	337.500000	0.000000	1.700000	1.000000	5
i1	147.0441	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	147.1764	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	147.2646	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	147.441	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	147.5292	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	147.7056	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	147.7938	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	147.9702	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	148.0584	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	148.2348	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	148.323	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	148.4994	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	148.5876	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	148.764	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	148.8522	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	149.0286	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	149.1168	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	153.015	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	152.925	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	152.835	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	152.745	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	152.655	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	152.565	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	152.475	3.4500000477	72.727273	1	3712.500000	0.000000	1.700000	1.000000	55
i1	152.385	3.4500000477	75.471698	1	3577.500000	0.000000	1.700000	1.000000	53
i1	152.295	3.4500000477	78.431373	1	3442.500000	0.000000	1.700000	1.000000	51
i1	152.025	3.4500000477	88.888889	1	3037.500000	0.000000	1.700000	1.000000	45
i1	151.755	3.4500000477	102.564103	1	2632.500000	0.000000	1.700000	1.000000	39
i1	151.485	3.4500000477	121.212121	1	2227.500000	0.000000	1.700000	1.000000	33
i1	151.215	3.4500000477	148.148148	1	1822.500000	0.000000	1.700000	1.000000	27
i1	150.945	3.4500000477	190.476190	1	1417.500000	0.000000	1.700000	1.000000	21
i1	150.675	3.4500000477	266.666667	1	1012.500000	0.000000	1.700000	1.000000	15
i1	150.405	3.4500000477	444.444444	1	607.500000	0.000000	1.700000	1.000000	9
i1	150.135	3.4500000477	1333.333333	1	202.500000	0.000000	1.700000	1.000000	3
i1	150.09	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	150.18	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	150.36	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	150.45	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	150.63	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	150.72	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	150.9	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	150.99	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	151.17	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	151.26	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	151.44	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	151.53	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	151.71	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	151.8	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	151.98	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	152.07	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	152.25	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	152.34	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	152.43	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	152.52	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	152.61	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	152.7	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	152.79	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	152.88	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	152.97	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	155.2491	3.4500000477	81.632653	1	3307.500000	0.000000	1.700000	1.000000	49
i1	154.9737	3.4500000477	93.023256	1	2902.500000	0.000000	1.700000	1.000000	43
i1	154.6983	3.4500000477	108.108108	1	2497.500000	0.000000	1.700000	1.000000	37
i1	154.4229	3.4500000477	129.032258	1	2092.500000	0.000000	1.700000	1.000000	31
i1	154.1475	3.4500000477	160.000000	1	1687.500000	0.000000	1.700000	1.000000	25
i1	153.8721	3.4500000477	210.526316	1	1282.500000	0.000000	1.700000	1.000000	19
i1	153.5967	3.4500000477	307.692308	1	877.500000	0.000000	1.700000	1.000000	13
i1	153.3213	3.4500000477	571.428571	1	472.500000	0.000000	1.700000	1.000000	7
i1	153.0459	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	153.0918	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	153.2754	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	153.3672	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	153.5508	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	153.6426	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	153.8262	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	153.918	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	154.1016	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	154.1934	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	154.377	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	154.4688	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	154.6524	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	154.7442	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	154.9278	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	155.0196	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	155.2032	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	155.295	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	159.1356	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	159.042	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	158.9484	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	158.8548	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	158.7612	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	158.6676	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	158.574	3.4500000477	72.727273	1	3712.500000	0.000000	1.700000	1.000000	55
i1	158.4804	3.4500000477	75.471698	1	3577.500000	0.000000	1.700000	1.000000	53
i1	158.1996	3.4500000477	85.106383	1	3172.500000	0.000000	1.700000	1.000000	47
i1	157.9188	3.4500000477	97.560976	1	2767.500000	0.000000	1.700000	1.000000	41
i1	157.638	3.4500000477	114.285714	1	2362.500000	0.000000	1.700000	1.000000	35
i1	157.3572	3.4500000477	137.931034	1	1957.500000	0.000000	1.700000	1.000000	29
i1	157.0764	3.4500000477	173.913043	1	1552.500000	0.000000	1.700000	1.000000	23
i1	156.7956	3.4500000477	235.294118	1	1147.500000	0.000000	1.700000	1.000000	17
i1	156.5148	3.4500000477	363.636364	1	742.500000	0.000000	1.700000	1.000000	11
i1	156.234	3.4500000477	800.000000	1	337.500000	0.000000	1.700000	1.000000	5
i1	156.0468	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	156.1872	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	156.2808	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	156.468	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	156.5616	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	156.7488	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	156.8424	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	157.0296	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	157.1232	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	157.3104	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	157.404	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	157.5912	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	157.6848	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	157.872	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	157.9656	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	158.1528	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	158.2464	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	158.4336	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	158.5272	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	158.6208	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	158.7144	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	158.808	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	158.9016	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	158.9952	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	159.0888	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	161.4327	3.4500000477	78.431373	1	3442.500000	0.000000	1.700000	1.000000	51
i1	161.1465	3.4500000477	88.888889	1	3037.500000	0.000000	1.700000	1.000000	45
i1	160.8603	3.4500000477	102.564103	1	2632.500000	0.000000	1.700000	1.000000	39
i1	160.5741	3.4500000477	121.212121	1	2227.500000	0.000000	1.700000	1.000000	33
i1	160.2879	3.4500000477	148.148148	1	1822.500000	0.000000	1.700000	1.000000	27
i1	160.0017	3.4500000477	190.476190	1	1417.500000	0.000000	1.700000	1.000000	21
i1	159.7155	3.4500000477	266.666667	1	1012.500000	0.000000	1.700000	1.000000	15
i1	159.4293	3.4500000477	444.444444	1	607.500000	0.000000	1.700000	1.000000	9
i1	159.1431	3.4500000477	1333.333333	1	202.500000	0.000000	1.700000	1.000000	3
i1	159.0954	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	159.1908	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	159.3816	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	159.477	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	159.6678	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	159.7632	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	159.954	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	160.0494	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	160.2402	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	160.3356	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	160.5264	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	160.6218	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	160.8126	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	160.908	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	161.0988	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	161.1942	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	161.385	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	161.4804	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	165.2562	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	165.159	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	165.0618	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	164.9646	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	164.8674	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	164.7702	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	164.673	3.4500000477	72.727273	1	3712.500000	0.000000	1.700000	1.000000	55
i1	164.3814	3.4500000477	81.632653	1	3307.500000	0.000000	1.700000	1.000000	49
i1	164.0898	3.4500000477	93.023256	1	2902.500000	0.000000	1.700000	1.000000	43
i1	163.7982	3.4500000477	108.108108	1	2497.500000	0.000000	1.700000	1.000000	37
i1	163.5066	3.4500000477	129.032258	1	2092.500000	0.000000	1.700000	1.000000	31
i1	163.215	3.4500000477	160.000000	1	1687.500000	0.000000	1.700000	1.000000	25
i1	162.9234	3.4500000477	210.526316	1	1282.500000	0.000000	1.700000	1.000000	19
i1	162.6318	3.4500000477	307.692308	1	877.500000	0.000000	1.700000	1.000000	13
i1	162.3402	3.4500000477	571.428571	1	472.500000	0.000000	1.700000	1.000000	7
i1	162.0486	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	162.0972	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	162.2916	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	162.3888	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	162.5832	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	162.6804	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	162.8748	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	162.972	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	163.1664	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	163.2636	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	163.458	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	163.5552	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	163.7496	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	163.8468	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	164.0412	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	164.1384	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	164.3328	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	164.43	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	164.6244	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	164.7216	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	164.8188	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	164.916	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	165.0132	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	165.1104	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	165.2076	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	167.6235	3.4500000477	75.471698	1	3577.500000	0.000000	1.700000	1.000000	53
i1	167.3265	3.4500000477	85.106383	1	3172.500000	0.000000	1.700000	1.000000	47
i1	167.0295	3.4500000477	97.560976	1	2767.500000	0.000000	1.700000	1.000000	41
i1	166.7325	3.4500000477	114.285714	1	2362.500000	0.000000	1.700000	1.000000	35
i1	166.4355	3.4500000477	137.931034	1	1957.500000	0.000000	1.700000	1.000000	29
i1	166.1385	3.4500000477	173.913043	1	1552.500000	0.000000	1.700000	1.000000	23
i1	165.8415	3.4500000477	235.294118	1	1147.500000	0.000000	1.700000	1.000000	17
i1	165.5445	3.4500000477	363.636364	1	742.500000	0.000000	1.700000	1.000000	11
i1	165.2475	3.4500000477	800.000000	1	337.500000	0.000000	1.700000	1.000000	5
i1	165.0495	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	165.198	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	165.297	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	165.495	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	165.594	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	165.792	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	165.891	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	166.089	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	166.188	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	166.386	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	166.485	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	166.683	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	166.782	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	166.98	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	167.079	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	167.277	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	167.376	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	167.574	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	167.673	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	171.3768	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	171.276	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	171.1752	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	171.0744	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	170.9736	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	170.8728	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	170.5704	3.4500000477	78.431373	1	3442.500000	0.000000	1.700000	1.000000	51
i1	170.268	3.4500000477	88.888889	1	3037.500000	0.000000	1.700000	1.000000	45
i1	169.9656	3.4500000477	102.564103	1	2632.500000	0.000000	1.700000	1.000000	39
i1	169.6632	3.4500000477	121.212121	1	2227.500000	0.000000	1.700000	1.000000	33
i1	169.3608	3.4500000477	148.148148	1	1822.500000	0.000000	1.700000	1.000000	27
i1	169.0584	3.4500000477	190.476190	1	1417.500000	0.000000	1.700000	1.000000	21
i1	168.756	3.4500000477	266.666667	1	1012.500000	0.000000	1.700000	1.000000	15
i1	168.4536	3.4500000477	444.444444	1	607.500000	0.000000	1.700000	1.000000	9
i1	168.1512	3.4500000477	1333.333333	1	202.500000	0.000000	1.700000	1.000000	3
i1	168.1008	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	168.2016	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	168.4032	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	168.504	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	168.7056	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	168.8064	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	169.008	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	169.1088	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	169.3104	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	169.4112	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	169.6128	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	169.7136	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	169.9152	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	170.016	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	170.2176	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	170.3184	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	170.52	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	170.6208	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	170.8224	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	170.9232	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	171.024	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	171.1248	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	171.2256	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	171.3264	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	173.8215	3.4500000477	72.727273	1	3712.500000	0.000000	1.700000	1.000000	55
i1	173.5137	3.4500000477	81.632653	1	3307.500000	0.000000	1.700000	1.000000	49
i1	173.2059	3.4500000477	93.023256	1	2902.500000	0.000000	1.700000	1.000000	43
i1	172.8981	3.4500000477	108.108108	1	2497.500000	0.000000	1.700000	1.000000	37
i1	172.5903	3.4500000477	129.032258	1	2092.500000	0.000000	1.700000	1.000000	31
i1	172.2825	3.4500000477	160.000000	1	1687.500000	0.000000	1.700000	1.000000	25
i1	171.9747	3.4500000477	210.526316	1	1282.500000	0.000000	1.700000	1.000000	19
i1	171.6669	3.4500000477	307.692308	1	877.500000	0.000000	1.700000	1.000000	13
i1	171.3591	3.4500000477	571.428571	1	472.500000	0.000000	1.700000	1.000000	7
i1	171.0513	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	171.1026	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	171.3078	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	171.4104	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	171.6156	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	171.7182	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	171.9234	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	172.026	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	172.2312	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	172.3338	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	172.539	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	172.6416	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	172.8468	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	172.9494	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	173.1546	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	173.2572	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	173.4624	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	173.565	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	173.7702	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	173.8728	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	177.4974	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	177.393	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	177.2886	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	177.1842	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	177.0798	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	176.7666	3.4500000477	75.471698	1	3577.500000	0.000000	1.700000	1.000000	53
i1	176.4534	3.4500000477	85.106383	1	3172.500000	0.000000	1.700000	1.000000	47
i1	176.1402	3.4500000477	97.560976	1	2767.500000	0.000000	1.700000	1.000000	41
i1	175.827	3.4500000477	114.285714	1	2362.500000	0.000000	1.700000	1.000000	35
i1	175.5138	3.4500000477	137.931034	1	1957.500000	0.000000	1.700000	1.000000	29
i1	175.2006	3.4500000477	173.913043	1	1552.500000	0.000000	1.700000	1.000000	23
i1	174.8874	3.4500000477	235.294118	1	1147.500000	0.000000	1.700000	1.000000	17
i1	174.5742	3.4500000477	363.636364	1	742.500000	0.000000	1.700000	1.000000	11
i1	174.261	3.4500000477	800.000000	1	337.500000	0.000000	1.700000	1.000000	5
i1	174.0522	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	174.2088	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	174.3132	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	174.522	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	174.6264	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	174.8352	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	174.9396	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	175.1484	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	175.2528	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	175.4616	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	175.566	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	175.7748	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	175.8792	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	176.088	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	176.1924	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	176.4012	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	176.5056	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	176.7144	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	176.8188	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	177.0276	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	177.132	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	177.2364	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	177.3408	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	177.4452	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	180.0267	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	179.7081	3.4500000477	78.431373	1	3442.500000	0.000000	1.700000	1.000000	51
i1	179.3895	3.4500000477	88.888889	1	3037.500000	0.000000	1.700000	1.000000	45
i1	179.0709	3.4500000477	102.564103	1	2632.500000	0.000000	1.700000	1.000000	39
i1	178.7523	3.4500000477	121.212121	1	2227.500000	0.000000	1.700000	1.000000	33
i1	178.4337	3.4500000477	148.148148	1	1822.500000	0.000000	1.700000	1.000000	27
i1	178.1151	3.4500000477	190.476190	1	1417.500000	0.000000	1.700000	1.000000	21
i1	177.7965	3.4500000477	266.666667	1	1012.500000	0.000000	1.700000	1.000000	15
i1	177.4779	3.4500000477	444.444444	1	607.500000	0.000000	1.700000	1.000000	9
i1	177.1593	3.4500000477	1333.333333	1	202.500000	0.000000	1.700000	1.000000	3
i1	177.1062	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	177.2124	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	177.4248	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	177.531	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	177.7434	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	177.8496	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	178.062	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	178.1682	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	178.3806	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	178.4868	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	178.6992	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	178.8054	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	179.0178	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	179.124	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	179.3364	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	179.4426	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	179.655	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	179.7612	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	179.9736	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	180.0798	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	183.618	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	183.51	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	183.402	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	183.294	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	182.97	3.4500000477	72.727273	1	3712.500000	0.000000	1.700000	1.000000	55
i1	182.646	3.4500000477	81.632653	1	3307.500000	0.000000	1.700000	1.000000	49
i1	182.322	3.4500000477	93.023256	1	2902.500000	0.000000	1.700000	1.000000	43
i1	181.998	3.4500000477	108.108108	1	2497.500000	0.000000	1.700000	1.000000	37
i1	181.674	3.4500000477	129.032258	1	2092.500000	0.000000	1.700000	1.000000	31
i1	181.35	3.4500000477	160.000000	1	1687.500000	0.000000	1.700000	1.000000	25
i1	181.026	3.4500000477	210.526316	1	1282.500000	0.000000	1.700000	1.000000	19
i1	180.702	3.4500000477	307.692308	1	877.500000	0.000000	1.700000	1.000000	13
i1	180.378	3.4500000477	571.428571	1	472.500000	0.000000	1.700000	1.000000	7
i1	180.054	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	180.108	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	180.324	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	180.432	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	180.648	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	180.756	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	180.972	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	181.08	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	181.296	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	181.404	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	181.62	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	181.728	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	181.944	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	182.052	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	182.268	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	182.376	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	182.592	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	182.7	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	182.916	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	183.024	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	183.24	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	183.348	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	183.456	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	183.564	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	186.2391	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	185.9097	3.4500000477	75.471698	1	3577.500000	0.000000	1.700000	1.000000	53
i1	185.5803	3.4500000477	85.106383	1	3172.500000	0.000000	1.700000	1.000000	47
i1	185.2509	3.4500000477	97.560976	1	2767.500000	0.000000	1.700000	1.000000	41
i1	184.9215	3.4500000477	114.285714	1	2362.500000	0.000000	1.700000	1.000000	35
i1	184.5921	3.4500000477	137.931034	1	1957.500000	0.000000	1.700000	1.000000	29
i1	184.2627	3.4500000477	173.913043	1	1552.500000	0.000000	1.700000	1.000000	23
i1	183.9333	3.4500000477	235.294118	1	1147.500000	0.000000	1.700000	1.000000	17
i1	183.6039	3.4500000477	363.636364	1	742.500000	0.000000	1.700000	1.000000	11
i1	183.2745	3.4500000477	800.000000	1	337.500000	0.000000	1.700000	1.000000	5
i1	183.0549	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	183.2196	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	183.3294	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	183.549	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	183.6588	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	183.8784	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	183.9882	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	184.2078	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	184.3176	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	184.5372	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	184.647	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	184.8666	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	184.9764	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	185.196	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	185.3058	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	185.5254	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	185.6352	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	185.8548	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	185.9646	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	186.1842	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	186.294	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	189.7386	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	189.627	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	189.5154	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	189.1806	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	188.8458	3.4500000477	78.431373	1	3442.500000	0.000000	1.700000	1.000000	51
i1	188.511	3.4500000477	88.888889	1	3037.500000	0.000000	1.700000	1.000000	45
i1	188.1762	3.4500000477	102.564103	1	2632.500000	0.000000	1.700000	1.000000	39
i1	187.8414	3.4500000477	121.212121	1	2227.500000	0.000000	1.700000	1.000000	33
i1	187.5066	3.4500000477	148.148148	1	1822.500000	0.000000	1.700000	1.000000	27
i1	187.1718	3.4500000477	190.476190	1	1417.500000	0.000000	1.700000	1.000000	21
i1	186.837	3.4500000477	266.666667	1	1012.500000	0.000000	1.700000	1.000000	15
i1	186.5022	3.4500000477	444.444444	1	607.500000	0.000000	1.700000	1.000000	9
i1	186.1674	3.4500000477	1333.333333	1	202.500000	0.000000	1.700000	1.000000	3
i1	186.1116	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	186.2232	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	186.4464	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	186.558	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	186.7812	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	186.8928	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	187.116	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	187.2276	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	187.4508	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	187.5624	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	187.7856	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	187.8972	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	188.1204	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	188.232	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	188.4552	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	188.5668	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	188.79	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	188.9016	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	189.1248	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	189.2364	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	189.4596	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	189.5712	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	189.6828	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	192.4587	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	192.1185	3.4500000477	72.727273	1	3712.500000	0.000000	1.700000	1.000000	55
i1	191.7783	3.4500000477	81.632653	1	3307.500000	0.000000	1.700000	1.000000	49
i1	191.4381	3.4500000477	93.023256	1	2902.500000	0.000000	1.700000	1.000000	43
i1	191.0979	3.4500000477	108.108108	1	2497.500000	0.000000	1.700000	1.000000	37
i1	190.7577	3.4500000477	129.032258	1	2092.500000	0.000000	1.700000	1.000000	31
i1	190.4175	3.4500000477	160.000000	1	1687.500000	0.000000	1.700000	1.000000	25
i1	190.0773	3.4500000477	210.526316	1	1282.500000	0.000000	1.700000	1.000000	19
i1	189.7371	3.4500000477	307.692308	1	877.500000	0.000000	1.700000	1.000000	13
i1	189.3969	3.4500000477	571.428571	1	472.500000	0.000000	1.700000	1.000000	7
i1	189.0567	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	189.1134	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	189.3402	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	189.4536	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	189.6804	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	189.7938	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	190.0206	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	190.134	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	190.3608	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	190.4742	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	190.701	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	190.8144	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	191.0412	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	191.1546	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	191.3814	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	191.4948	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	191.7216	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	191.835	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	192.0618	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	192.1752	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	192.402	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	192.5154	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	195.8592	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	195.744	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	195.3984	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	195.0528	3.4500000477	75.471698	1	3577.500000	0.000000	1.700000	1.000000	53
i1	194.7072	3.4500000477	85.106383	1	3172.500000	0.000000	1.700000	1.000000	47
i1	194.3616	3.4500000477	97.560976	1	2767.500000	0.000000	1.700000	1.000000	41
i1	194.016	3.4500000477	114.285714	1	2362.500000	0.000000	1.700000	1.000000	35
i1	193.6704	3.4500000477	137.931034	1	1957.500000	0.000000	1.700000	1.000000	29
i1	193.3248	3.4500000477	173.913043	1	1552.500000	0.000000	1.700000	1.000000	23
i1	192.9792	3.4500000477	235.294118	1	1147.500000	0.000000	1.700000	1.000000	17
i1	192.6336	3.4500000477	363.636364	1	742.500000	0.000000	1.700000	1.000000	11
i1	192.288	3.4500000477	800.000000	1	337.500000	0.000000	1.700000	1.000000	5
i1	192.0576	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	192.2304	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	192.3456	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	192.576	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	192.6912	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	192.9216	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	193.0368	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	193.2672	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	193.3824	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	193.6128	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	193.728	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	193.9584	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	194.0736	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	194.304	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	194.4192	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	194.6496	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	194.7648	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	194.9952	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	195.1104	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	195.3408	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	195.456	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	195.6864	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	195.8016	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	198.6855	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	198.3345	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	197.9835	3.4500000477	78.431373	1	3442.500000	0.000000	1.700000	1.000000	51
i1	197.6325	3.4500000477	88.888889	1	3037.500000	0.000000	1.700000	1.000000	45
i1	197.2815	3.4500000477	102.564103	1	2632.500000	0.000000	1.700000	1.000000	39
i1	196.9305	3.4500000477	121.212121	1	2227.500000	0.000000	1.700000	1.000000	33
i1	196.5795	3.4500000477	148.148148	1	1822.500000	0.000000	1.700000	1.000000	27
i1	196.2285	3.4500000477	190.476190	1	1417.500000	0.000000	1.700000	1.000000	21
i1	195.8775	3.4500000477	266.666667	1	1012.500000	0.000000	1.700000	1.000000	15
i1	195.5265	3.4500000477	444.444444	1	607.500000	0.000000	1.700000	1.000000	9
i1	195.1755	3.4500000477	1333.333333	1	202.500000	0.000000	1.700000	1.000000	3
i1	195.117	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	195.234	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	195.468	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	195.585	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	195.819	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	195.936	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	196.17	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	196.287	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	196.521	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	196.638	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	196.872	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	196.989	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	197.223	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	197.34	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	197.574	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	197.691	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	197.925	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	198.042	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	198.276	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	198.393	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	198.627	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	198.744	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	201.9798	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	201.6234	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	201.267	3.4500000477	72.727273	1	3712.500000	0.000000	1.700000	1.000000	55
i1	200.9106	3.4500000477	81.632653	1	3307.500000	0.000000	1.700000	1.000000	49
i1	200.5542	3.4500000477	93.023256	1	2902.500000	0.000000	1.700000	1.000000	43
i1	200.1978	3.4500000477	108.108108	1	2497.500000	0.000000	1.700000	1.000000	37
i1	199.8414	3.4500000477	129.032258	1	2092.500000	0.000000	1.700000	1.000000	31
i1	199.485	3.4500000477	160.000000	1	1687.500000	0.000000	1.700000	1.000000	25
i1	199.1286	3.4500000477	210.526316	1	1282.500000	0.000000	1.700000	1.000000	19
i1	198.7722	3.4500000477	307.692308	1	877.500000	0.000000	1.700000	1.000000	13
i1	198.4158	3.4500000477	571.428571	1	472.500000	0.000000	1.700000	1.000000	7
i1	198.0594	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	198.1188	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	198.3564	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	198.4752	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	198.7128	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	198.8316	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	199.0692	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	199.188	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	199.4256	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	199.5444	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	199.782	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	199.9008	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	200.1384	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	200.2572	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	200.4948	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	200.6136	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	200.8512	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	200.97	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	201.2076	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	201.3264	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	201.564	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	201.6828	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	201.9204	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	204.9195	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	204.5577	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	204.1959	3.4500000477	75.471698	1	3577.500000	0.000000	1.700000	1.000000	53
i1	203.8341	3.4500000477	85.106383	1	3172.500000	0.000000	1.700000	1.000000	47
i1	203.4723	3.4500000477	97.560976	1	2767.500000	0.000000	1.700000	1.000000	41
i1	203.1105	3.4500000477	114.285714	1	2362.500000	0.000000	1.700000	1.000000	35
i1	202.7487	3.4500000477	137.931034	1	1957.500000	0.000000	1.700000	1.000000	29
i1	202.3869	3.4500000477	173.913043	1	1552.500000	0.000000	1.700000	1.000000	23
i1	202.0251	3.4500000477	235.294118	1	1147.500000	0.000000	1.700000	1.000000	17
i1	201.6633	3.4500000477	363.636364	1	742.500000	0.000000	1.700000	1.000000	11
i1	201.3015	3.4500000477	800.000000	1	337.500000	0.000000	1.700000	1.000000	5
i1	201.0603	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	201.2412	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	201.3618	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	201.603	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	201.7236	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	201.9648	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	202.0854	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	202.3266	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	202.4472	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	202.6884	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	202.809	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	203.0502	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	203.1708	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	203.412	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	203.5326	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	203.7738	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	203.8944	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	204.1356	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	204.2562	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	204.4974	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	204.618	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	204.8592	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	204.9798	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	208.1004	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	207.8556	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	207.4884	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	207.1212	3.4500000477	78.431373	1	3442.500000	0.000000	1.700000	1.000000	51
i1	206.754	3.4500000477	88.888889	1	3037.500000	0.000000	1.700000	1.000000	45
i1	206.3868	3.4500000477	102.564103	1	2632.500000	0.000000	1.700000	1.000000	39
i1	206.0196	3.4500000477	121.212121	1	2227.500000	0.000000	1.700000	1.000000	33
i1	205.6524	3.4500000477	148.148148	1	1822.500000	0.000000	1.700000	1.000000	27
i1	205.2852	3.4500000477	190.476190	1	1417.500000	0.000000	1.700000	1.000000	21
i1	204.918	3.4500000477	266.666667	1	1012.500000	0.000000	1.700000	1.000000	15
i1	204.5508	3.4500000477	444.444444	1	607.500000	0.000000	1.700000	1.000000	9
i1	204.1836	3.4500000477	1333.333333	1	202.500000	0.000000	1.700000	1.000000	3
i1	204.1224	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	204.2448	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	204.4896	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	204.612	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	204.8568	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	204.9792	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	205.224	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	205.3464	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	205.5912	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	205.7136	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	205.9584	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	206.0808	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	206.3256	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	206.448	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	206.6928	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	206.8152	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	207.06	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	207.1824	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	207.4272	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	207.5496	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	207.7944	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	207.9168	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	211.0365	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	210.7881	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	210.4155	3.4500000477	72.727273	1	3712.500000	0.000000	1.700000	1.000000	55
i1	210.0429	3.4500000477	81.632653	1	3307.500000	0.000000	1.700000	1.000000	49
i1	209.6703	3.4500000477	93.023256	1	2902.500000	0.000000	1.700000	1.000000	43
i1	209.2977	3.4500000477	108.108108	1	2497.500000	0.000000	1.700000	1.000000	37
i1	208.9251	3.4500000477	129.032258	1	2092.500000	0.000000	1.700000	1.000000	31
i1	208.5525	3.4500000477	160.000000	1	1687.500000	0.000000	1.700000	1.000000	25
i1	208.1799	3.4500000477	210.526316	1	1282.500000	0.000000	1.700000	1.000000	19
i1	207.8073	3.4500000477	307.692308	1	877.500000	0.000000	1.700000	1.000000	13
i1	207.4347	3.4500000477	571.428571	1	472.500000	0.000000	1.700000	1.000000	7
i1	207.0621	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	207.1242	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	207.3726	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	207.4968	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	207.7452	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	207.8694	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	208.1178	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	208.242	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	208.4904	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	208.6146	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	208.863	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	208.9872	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	209.2356	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	209.3598	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	209.6082	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	209.7324	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	209.9808	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	210.105	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	210.3534	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	210.4776	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	210.726	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	210.8502	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	211.0986	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	214.221	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	213.969	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	213.717	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	213.339	3.4500000477	75.471698	1	3577.500000	0.000000	1.700000	1.000000	53
i1	212.961	3.4500000477	85.106383	1	3172.500000	0.000000	1.700000	1.000000	47
i1	212.583	3.4500000477	97.560976	1	2767.500000	0.000000	1.700000	1.000000	41
i1	212.205	3.4500000477	114.285714	1	2362.500000	0.000000	1.700000	1.000000	35
i1	211.827	3.4500000477	137.931034	1	1957.500000	0.000000	1.700000	1.000000	29
i1	211.449	3.4500000477	173.913043	1	1552.500000	0.000000	1.700000	1.000000	23
i1	211.071	3.4500000477	235.294118	1	1147.500000	0.000000	1.700000	1.000000	17
i1	210.693	3.4500000477	363.636364	1	742.500000	0.000000	1.700000	1.000000	11
i1	210.315	3.4500000477	800.000000	1	337.500000	0.000000	1.700000	1.000000	5
i1	210.063	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	210.252	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	210.378	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	210.63	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	210.756	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	211.008	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	211.134	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	211.386	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	211.512	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	211.764	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	211.89	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	212.142	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	212.268	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	212.52	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	212.646	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	212.898	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	213.024	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	213.276	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	213.402	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	213.654	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	213.78	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	214.032	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	217.1535	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	216.8979	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	216.6423	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	216.2589	3.4500000477	78.431373	1	3442.500000	0.000000	1.700000	1.000000	51
i1	215.8755	3.4500000477	88.888889	1	3037.500000	0.000000	1.700000	1.000000	45
i1	215.4921	3.4500000477	102.564103	1	2632.500000	0.000000	1.700000	1.000000	39
i1	215.1087	3.4500000477	121.212121	1	2227.500000	0.000000	1.700000	1.000000	33
i1	214.7253	3.4500000477	148.148148	1	1822.500000	0.000000	1.700000	1.000000	27
i1	214.3419	3.4500000477	190.476190	1	1417.500000	0.000000	1.700000	1.000000	21
i1	213.9585	3.4500000477	266.666667	1	1012.500000	0.000000	1.700000	1.000000	15
i1	213.5751	3.4500000477	444.444444	1	607.500000	0.000000	1.700000	1.000000	9
i1	213.1917	3.4500000477	1333.333333	1	202.500000	0.000000	1.700000	1.000000	3
i1	213.1278	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	213.2556	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	213.5112	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	213.639	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	213.8946	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	214.0224	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	214.278	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	214.4058	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	214.6614	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	214.7892	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	215.0448	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	215.1726	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	215.4282	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	215.556	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	215.8116	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	215.9394	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	216.195	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	216.3228	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	216.5784	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	216.7062	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	216.9618	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	217.2174	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	220.3416	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	220.0824	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	219.8232	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	219.564	3.4500000477	72.727273	1	3712.500000	0.000000	1.700000	1.000000	55
i1	219.1752	3.4500000477	81.632653	1	3307.500000	0.000000	1.700000	1.000000	49
i1	218.7864	3.4500000477	93.023256	1	2902.500000	0.000000	1.700000	1.000000	43
i1	218.3976	3.4500000477	108.108108	1	2497.500000	0.000000	1.700000	1.000000	37
i1	218.0088	3.4500000477	129.032258	1	2092.500000	0.000000	1.700000	1.000000	31
i1	217.62	3.4500000477	160.000000	1	1687.500000	0.000000	1.700000	1.000000	25
i1	217.2312	3.4500000477	210.526316	1	1282.500000	0.000000	1.700000	1.000000	19
i1	216.8424	3.4500000477	307.692308	1	877.500000	0.000000	1.700000	1.000000	13
i1	216.4536	3.4500000477	571.428571	1	472.500000	0.000000	1.700000	1.000000	7
i1	216.0648	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	216.1296	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	216.3888	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	216.5184	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	216.7776	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	216.9072	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	217.1664	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	217.296	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	217.5552	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	217.6848	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	217.944	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	218.0736	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	218.3328	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	218.4624	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	218.7216	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	218.8512	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	219.1104	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	219.24	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	219.4992	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	219.6288	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	219.888	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	220.1472	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	223.2705	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	223.0077	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	222.7449	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	222.4821	3.4500000477	75.471698	1	3577.500000	0.000000	1.700000	1.000000	53
i1	222.0879	3.4500000477	85.106383	1	3172.500000	0.000000	1.700000	1.000000	47
i1	221.6937	3.4500000477	97.560976	1	2767.500000	0.000000	1.700000	1.000000	41
i1	221.2995	3.4500000477	114.285714	1	2362.500000	0.000000	1.700000	1.000000	35
i1	220.9053	3.4500000477	137.931034	1	1957.500000	0.000000	1.700000	1.000000	29
i1	220.5111	3.4500000477	173.913043	1	1552.500000	0.000000	1.700000	1.000000	23
i1	220.1169	3.4500000477	235.294118	1	1147.500000	0.000000	1.700000	1.000000	17
i1	219.7227	3.4500000477	363.636364	1	742.500000	0.000000	1.700000	1.000000	11
i1	219.3285	3.4500000477	800.000000	1	337.500000	0.000000	1.700000	1.000000	5
i1	219.0657	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	219.2628	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	219.3942	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	219.657	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	219.7884	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	220.0512	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	220.1826	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	220.4454	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	220.5768	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	220.8396	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	220.971	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	221.2338	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	221.3652	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	221.628	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	221.7594	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	222.0222	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	222.1536	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	222.4164	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	222.5478	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	222.8106	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	223.0734	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	223.3362	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	226.4622	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	226.1958	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	225.9294	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	225.663	3.4500000477	72.727273	1	3712.500000	0.000000	1.700000	1.000000	55
i1	225.3966	3.4500000477	78.431373	1	3442.500000	0.000000	1.700000	1.000000	51
i1	224.997	3.4500000477	88.888889	1	3037.500000	0.000000	1.700000	1.000000	45
i1	224.5974	3.4500000477	102.564103	1	2632.500000	0.000000	1.700000	1.000000	39
i1	224.1978	3.4500000477	121.212121	1	2227.500000	0.000000	1.700000	1.000000	33
i1	223.7982	3.4500000477	148.148148	1	1822.500000	0.000000	1.700000	1.000000	27
i1	223.3986	3.4500000477	190.476190	1	1417.500000	0.000000	1.700000	1.000000	21
i1	222.999	3.4500000477	266.666667	1	1012.500000	0.000000	1.700000	1.000000	15
i1	222.5994	3.4500000477	444.444444	1	607.500000	0.000000	1.700000	1.000000	9
i1	222.1998	3.4500000477	1333.333333	1	202.500000	0.000000	1.700000	1.000000	3
i1	222.1332	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	222.2664	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	222.5328	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	222.666	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	222.9324	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	223.0656	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	223.332	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	223.4652	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	223.7316	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	223.8648	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	224.1312	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	224.2644	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	224.5308	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	224.664	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	224.9304	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	225.0636	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	225.33	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	225.4632	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	225.7296	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	225.996	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	226.2624	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	229.3875	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	229.1175	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	228.8475	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	228.5775	3.4500000477	75.471698	1	3577.500000	0.000000	1.700000	1.000000	53
i1	228.3075	3.4500000477	81.632653	1	3307.500000	0.000000	1.700000	1.000000	49
i1	227.9025	3.4500000477	93.023256	1	2902.500000	0.000000	1.700000	1.000000	43
i1	227.4975	3.4500000477	108.108108	1	2497.500000	0.000000	1.700000	1.000000	37
i1	227.0925	3.4500000477	129.032258	1	2092.500000	0.000000	1.700000	1.000000	31
i1	226.6875	3.4500000477	160.000000	1	1687.500000	0.000000	1.700000	1.000000	25
i1	226.2825	3.4500000477	210.526316	1	1282.500000	0.000000	1.700000	1.000000	19
i1	225.8775	3.4500000477	307.692308	1	877.500000	0.000000	1.700000	1.000000	13
i1	225.4725	3.4500000477	571.428571	1	472.500000	0.000000	1.700000	1.000000	7
i1	225.0675	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	225.135	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	225.405	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	225.54	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	225.81	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	225.945	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	226.215	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	226.35	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	226.62	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	226.755	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	227.025	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	227.16	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	227.43	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	227.565	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	227.835	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	227.97	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	228.24	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	228.375	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	228.645	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	228.915	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	229.185	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	229.455	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	232.5828	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	232.3092	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	232.0356	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	231.762	3.4500000477	72.727273	1	3712.500000	0.000000	1.700000	1.000000	55
i1	231.4884	3.4500000477	78.431373	1	3442.500000	0.000000	1.700000	1.000000	51
i1	231.2148	3.4500000477	85.106383	1	3172.500000	0.000000	1.700000	1.000000	47
i1	230.8044	3.4500000477	97.560976	1	2767.500000	0.000000	1.700000	1.000000	41
i1	230.394	3.4500000477	114.285714	1	2362.500000	0.000000	1.700000	1.000000	35
i1	229.9836	3.4500000477	137.931034	1	1957.500000	0.000000	1.700000	1.000000	29
i1	229.5732	3.4500000477	173.913043	1	1552.500000	0.000000	1.700000	1.000000	23
i1	229.1628	3.4500000477	235.294118	1	1147.500000	0.000000	1.700000	1.000000	17
i1	228.7524	3.4500000477	363.636364	1	742.500000	0.000000	1.700000	1.000000	11
i1	228.342	3.4500000477	800.000000	1	337.500000	0.000000	1.700000	1.000000	5
i1	228.0684	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	228.2736	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	228.4104	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	228.684	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	228.8208	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	229.0944	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	229.2312	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	229.5048	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	229.6416	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	229.9152	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	230.052	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	230.3256	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	230.4624	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	230.736	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	230.8728	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	231.1464	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	231.2832	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	231.5568	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	231.8304	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	232.104	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	232.3776	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	235.5045	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	235.2273	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	234.9501	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	234.6729	3.4500000477	75.471698	1	3577.500000	0.000000	1.700000	1.000000	53
i1	234.3957	3.4500000477	81.632653	1	3307.500000	0.000000	1.700000	1.000000	49
i1	234.1185	3.4500000477	88.888889	1	3037.500000	0.000000	1.700000	1.000000	45
i1	233.7027	3.4500000477	102.564103	1	2632.500000	0.000000	1.700000	1.000000	39
i1	233.2869	3.4500000477	121.212121	1	2227.500000	0.000000	1.700000	1.000000	33
i1	232.8711	3.4500000477	148.148148	1	1822.500000	0.000000	1.700000	1.000000	27
i1	232.4553	3.4500000477	190.476190	1	1417.500000	0.000000	1.700000	1.000000	21
i1	232.0395	3.4500000477	266.666667	1	1012.500000	0.000000	1.700000	1.000000	15
i1	231.6237	3.4500000477	444.444444	1	607.500000	0.000000	1.700000	1.000000	9
i1	231.2079	3.4500000477	1333.333333	1	202.500000	0.000000	1.700000	1.000000	3
i1	231.1386	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	231.2772	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	231.5544	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	231.693	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	231.9702	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	232.1088	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	232.386	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	232.5246	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	232.8018	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	232.9404	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	233.2176	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	233.3562	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	233.6334	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	233.772	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	234.0492	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	234.1878	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	234.465	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	234.7422	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	235.0194	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	235.2966	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	235.5738	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	238.7034	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	238.4226	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	238.1418	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	237.861	3.4500000477	72.727273	1	3712.500000	0.000000	1.700000	1.000000	55
i1	237.5802	3.4500000477	78.431373	1	3442.500000	0.000000	1.700000	1.000000	51
i1	237.2994	3.4500000477	85.106383	1	3172.500000	0.000000	1.700000	1.000000	47
i1	237.0186	3.4500000477	93.023256	1	2902.500000	0.000000	1.700000	1.000000	43
i1	236.5974	3.4500000477	108.108108	1	2497.500000	0.000000	1.700000	1.000000	37
i1	236.1762	3.4500000477	129.032258	1	2092.500000	0.000000	1.700000	1.000000	31
i1	235.755	3.4500000477	160.000000	1	1687.500000	0.000000	1.700000	1.000000	25
i1	235.3338	3.4500000477	210.526316	1	1282.500000	0.000000	1.700000	1.000000	19
i1	234.9126	3.4500000477	307.692308	1	877.500000	0.000000	1.700000	1.000000	13
i1	234.4914	3.4500000477	571.428571	1	472.500000	0.000000	1.700000	1.000000	7
i1	234.0702	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	234.1404	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	234.4212	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	234.5616	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	234.8424	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	234.9828	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	235.2636	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	235.404	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	235.6848	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	235.8252	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	236.106	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	236.2464	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	236.5272	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	236.6676	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	236.9484	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	237.0888	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	237.3696	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	237.6504	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	237.9312	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	238.212	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	238.4928	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	241.6215	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	241.3371	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	241.0527	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	240.7683	3.4500000477	75.471698	1	3577.500000	0.000000	1.700000	1.000000	53
i1	240.4839	3.4500000477	81.632653	1	3307.500000	0.000000	1.700000	1.000000	49
i1	240.1995	3.4500000477	88.888889	1	3037.500000	0.000000	1.700000	1.000000	45
i1	239.9151	3.4500000477	97.560976	1	2767.500000	0.000000	1.700000	1.000000	41
i1	239.4885	3.4500000477	114.285714	1	2362.500000	0.000000	1.700000	1.000000	35
i1	239.0619	3.4500000477	137.931034	1	1957.500000	0.000000	1.700000	1.000000	29
i1	238.6353	3.4500000477	173.913043	1	1552.500000	0.000000	1.700000	1.000000	23
i1	238.2087	3.4500000477	235.294118	1	1147.500000	0.000000	1.700000	1.000000	17
i1	237.7821	3.4500000477	363.636364	1	742.500000	0.000000	1.700000	1.000000	11
i1	237.3555	3.4500000477	800.000000	1	337.500000	0.000000	1.700000	1.000000	5
i1	237.0711	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	237.2844	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	237.4266	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	237.711	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	237.8532	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	238.1376	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	238.2798	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	238.5642	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	238.7064	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	238.9908	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	239.133	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	239.4174	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	239.5596	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	239.844	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	239.9862	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	240.2706	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	240.555	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	240.8394	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	241.1238	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	241.4082	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	241.6926	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	244.824	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	244.536	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	244.248	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	243.96	3.4500000477	72.727273	1	3712.500000	0.000000	1.700000	1.000000	55
i1	243.672	3.4500000477	78.431373	1	3442.500000	0.000000	1.700000	1.000000	51
i1	243.384	3.4500000477	85.106383	1	3172.500000	0.000000	1.700000	1.000000	47
i1	243.096	3.4500000477	93.023256	1	2902.500000	0.000000	1.700000	1.000000	43
i1	242.808	3.4500000477	102.564103	1	2632.500000	0.000000	1.700000	1.000000	39
i1	242.376	3.4500000477	121.212121	1	2227.500000	0.000000	1.700000	1.000000	33
i1	241.944	3.4500000477	148.148148	1	1822.500000	0.000000	1.700000	1.000000	27
i1	241.512	3.4500000477	190.476190	1	1417.500000	0.000000	1.700000	1.000000	21
i1	241.08	3.4500000477	266.666667	1	1012.500000	0.000000	1.700000	1.000000	15
i1	240.648	3.4500000477	444.444444	1	607.500000	0.000000	1.700000	1.000000	9
i1	240.216	3.4500000477	1333.333333	1	202.500000	0.000000	1.700000	1.000000	3
i1	240.144	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	240.288	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	240.576	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	240.72	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	241.008	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	241.152	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	241.44	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	241.584	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	241.872	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	242.016	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	242.304	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	242.448	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	242.736	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	242.88	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	243.168	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	243.456	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	243.744	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	244.032	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	244.32	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	244.608	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	247.7385	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	247.4469	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	247.1553	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	246.8637	3.4500000477	75.471698	1	3577.500000	0.000000	1.700000	1.000000	53
i1	246.5721	3.4500000477	81.632653	1	3307.500000	0.000000	1.700000	1.000000	49
i1	246.2805	3.4500000477	88.888889	1	3037.500000	0.000000	1.700000	1.000000	45
i1	245.9889	3.4500000477	97.560976	1	2767.500000	0.000000	1.700000	1.000000	41
i1	245.6973	3.4500000477	108.108108	1	2497.500000	0.000000	1.700000	1.000000	37
i1	245.2599	3.4500000477	129.032258	1	2092.500000	0.000000	1.700000	1.000000	31
i1	244.8225	3.4500000477	160.000000	1	1687.500000	0.000000	1.700000	1.000000	25
i1	244.3851	3.4500000477	210.526316	1	1282.500000	0.000000	1.700000	1.000000	19
i1	243.9477	3.4500000477	307.692308	1	877.500000	0.000000	1.700000	1.000000	13
i1	243.5103	3.4500000477	571.428571	1	472.500000	0.000000	1.700000	1.000000	7
i1	243.0729	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	243.1458	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	243.4374	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	243.5832	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	243.8748	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	244.0206	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	244.3122	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	244.458	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	244.7496	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	244.8954	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	245.187	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	245.3328	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	245.6244	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	245.7702	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	246.0618	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	246.3534	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	246.645	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	246.9366	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	247.2282	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	247.5198	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	247.8114	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	250.9446	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	250.6494	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	250.3542	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	250.059	3.4500000477	72.727273	1	3712.500000	0.000000	1.700000	1.000000	55
i1	249.7638	3.4500000477	78.431373	1	3442.500000	0.000000	1.700000	1.000000	51
i1	249.4686	3.4500000477	85.106383	1	3172.500000	0.000000	1.700000	1.000000	47
i1	249.1734	3.4500000477	93.023256	1	2902.500000	0.000000	1.700000	1.000000	43
i1	248.8782	3.4500000477	102.564103	1	2632.500000	0.000000	1.700000	1.000000	39
i1	248.583	3.4500000477	114.285714	1	2362.500000	0.000000	1.700000	1.000000	35
i1	248.1402	3.4500000477	137.931034	1	1957.500000	0.000000	1.700000	1.000000	29
i1	247.6974	3.4500000477	173.913043	1	1552.500000	0.000000	1.700000	1.000000	23
i1	247.2546	3.4500000477	235.294118	1	1147.500000	0.000000	1.700000	1.000000	17
i1	246.8118	3.4500000477	363.636364	1	742.500000	0.000000	1.700000	1.000000	11
i1	246.369	3.4500000477	800.000000	1	337.500000	0.000000	1.700000	1.000000	5
i1	246.0738	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	246.2952	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	246.4428	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	246.738	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	246.8856	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	247.1808	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	247.3284	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	247.6236	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	247.7712	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	248.0664	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	248.214	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	248.5092	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	248.6568	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	248.952	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	249.2472	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	249.5424	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	249.8376	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	250.1328	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	250.428	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	250.7232	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	253.8555	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	253.5567	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	253.2579	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	252.9591	3.4500000477	75.471698	1	3577.500000	0.000000	1.700000	1.000000	53
i1	252.6603	3.4500000477	81.632653	1	3307.500000	0.000000	1.700000	1.000000	49
i1	252.3615	3.4500000477	88.888889	1	3037.500000	0.000000	1.700000	1.000000	45
i1	252.0627	3.4500000477	97.560976	1	2767.500000	0.000000	1.700000	1.000000	41
i1	251.7639	3.4500000477	108.108108	1	2497.500000	0.000000	1.700000	1.000000	37
i1	251.4651	3.4500000477	121.212121	1	2227.500000	0.000000	1.700000	1.000000	33
i1	251.0169	3.4500000477	148.148148	1	1822.500000	0.000000	1.700000	1.000000	27
i1	250.5687	3.4500000477	190.476190	1	1417.500000	0.000000	1.700000	1.000000	21
i1	250.1205	3.4500000477	266.666667	1	1012.500000	0.000000	1.700000	1.000000	15
i1	249.6723	3.4500000477	444.444444	1	607.500000	0.000000	1.700000	1.000000	9
i1	249.2241	3.4500000477	1333.333333	1	202.500000	0.000000	1.700000	1.000000	3
i1	249.1494	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	249.2988	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	249.5976	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	249.747	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	250.0458	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	250.1952	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	250.494	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	250.6434	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	250.9422	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	251.0916	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	251.3904	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	251.5398	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	251.8386	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	252.1374	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	252.4362	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	252.735	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	253.0338	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	253.3326	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	253.6314	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	253.9302	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	257.0652	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	256.7628	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	256.4604	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	256.158	3.4500000477	72.727273	1	3712.500000	0.000000	1.700000	1.000000	55
i1	255.8556	3.4500000477	78.431373	1	3442.500000	0.000000	1.700000	1.000000	51
i1	255.5532	3.4500000477	85.106383	1	3172.500000	0.000000	1.700000	1.000000	47
i1	255.2508	3.4500000477	93.023256	1	2902.500000	0.000000	1.700000	1.000000	43
i1	254.9484	3.4500000477	102.564103	1	2632.500000	0.000000	1.700000	1.000000	39
i1	254.646	3.4500000477	114.285714	1	2362.500000	0.000000	1.700000	1.000000	35
i1	254.3436	3.4500000477	129.032258	1	2092.500000	0.000000	1.700000	1.000000	31
i1	253.89	3.4500000477	160.000000	1	1687.500000	0.000000	1.700000	1.000000	25
i1	253.4364	3.4500000477	210.526316	1	1282.500000	0.000000	1.700000	1.000000	19
i1	252.9828	3.4500000477	307.692308	1	877.500000	0.000000	1.700000	1.000000	13
i1	252.5292	3.4500000477	571.428571	1	472.500000	0.000000	1.700000	1.000000	7
i1	252.0756	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	252.1512	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	252.4536	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	252.6048	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	252.9072	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	253.0584	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	253.3608	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	253.512	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	253.8144	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	253.9656	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	254.268	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	254.4192	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	254.7216	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	255.024	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	255.3264	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	255.6288	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	255.9312	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	256.2336	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	256.536	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	256.8384	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	259.9725	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	259.6665	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	259.3605	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	259.0545	3.4500000477	75.471698	1	3577.500000	0.000000	1.700000	1.000000	53
i1	258.7485	3.4500000477	81.632653	1	3307.500000	0.000000	1.700000	1.000000	49
i1	258.4425	3.4500000477	88.888889	1	3037.500000	0.000000	1.700000	1.000000	45
i1	258.1365	3.4500000477	97.560976	1	2767.500000	0.000000	1.700000	1.000000	41
i1	257.8305	3.4500000477	108.108108	1	2497.500000	0.000000	1.700000	1.000000	37
i1	257.5245	3.4500000477	121.212121	1	2227.500000	0.000000	1.700000	1.000000	33
i1	257.2185	3.4500000477	137.931034	1	1957.500000	0.000000	1.700000	1.000000	29
i1	256.7595	3.4500000477	173.913043	1	1552.500000	0.000000	1.700000	1.000000	23
i1	256.3005	3.4500000477	235.294118	1	1147.500000	0.000000	1.700000	1.000000	17
i1	255.8415	3.4500000477	363.636364	1	742.500000	0.000000	1.700000	1.000000	11
i1	255.3825	3.4500000477	800.000000	1	337.500000	0.000000	1.700000	1.000000	5
i1	255.0765	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	255.306	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	255.459	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	255.765	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	255.918	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	256.224	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	256.377	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	256.683	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	256.836	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	257.142	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	257.295	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	257.601	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	257.907	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	258.213	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	258.519	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	258.825	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	259.131	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	259.437	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	259.743	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	260.049	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	263.1858	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	262.8762	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	262.5666	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	262.257	3.4500000477	72.727273	1	3712.500000	0.000000	1.700000	1.000000	55
i1	261.9474	3.4500000477	78.431373	1	3442.500000	0.000000	1.700000	1.000000	51
i1	261.6378	3.4500000477	85.106383	1	3172.500000	0.000000	1.700000	1.000000	47
i1	261.3282	3.4500000477	93.023256	1	2902.500000	0.000000	1.700000	1.000000	43
i1	261.0186	3.4500000477	102.564103	1	2632.500000	0.000000	1.700000	1.000000	39
i1	260.709	3.4500000477	114.285714	1	2362.500000	0.000000	1.700000	1.000000	35
i1	260.3994	3.4500000477	129.032258	1	2092.500000	0.000000	1.700000	1.000000	31
i1	260.0898	3.4500000477	148.148148	1	1822.500000	0.000000	1.700000	1.000000	27
i1	259.6254	3.4500000477	190.476190	1	1417.500000	0.000000	1.700000	1.000000	21
i1	259.161	3.4500000477	266.666667	1	1012.500000	0.000000	1.700000	1.000000	15
i1	258.6966	3.4500000477	444.444444	1	607.500000	0.000000	1.700000	1.000000	9
i1	258.2322	3.4500000477	1333.333333	1	202.500000	0.000000	1.700000	1.000000	3
i1	258.1548	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	258.3096	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	258.6192	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	258.774	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	259.0836	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	259.2384	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	259.548	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	259.7028	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	260.0124	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	260.1672	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	260.4768	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	260.7864	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	261.096	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	261.4056	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	261.7152	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	262.0248	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	262.3344	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	262.644	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	262.9536	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	266.0895	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	265.7763	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	265.4631	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	265.1499	3.4500000477	75.471698	1	3577.500000	0.000000	1.700000	1.000000	53
i1	264.8367	3.4500000477	81.632653	1	3307.500000	0.000000	1.700000	1.000000	49
i1	264.5235	3.4500000477	88.888889	1	3037.500000	0.000000	1.700000	1.000000	45
i1	264.2103	3.4500000477	97.560976	1	2767.500000	0.000000	1.700000	1.000000	41
i1	263.8971	3.4500000477	108.108108	1	2497.500000	0.000000	1.700000	1.000000	37
i1	263.5839	3.4500000477	121.212121	1	2227.500000	0.000000	1.700000	1.000000	33
i1	263.2707	3.4500000477	137.931034	1	1957.500000	0.000000	1.700000	1.000000	29
i1	262.9575	3.4500000477	160.000000	1	1687.500000	0.000000	1.700000	1.000000	25
i1	262.4877	3.4500000477	210.526316	1	1282.500000	0.000000	1.700000	1.000000	19
i1	262.0179	3.4500000477	307.692308	1	877.500000	0.000000	1.700000	1.000000	13
i1	261.5481	3.4500000477	571.428571	1	472.500000	0.000000	1.700000	1.000000	7
i1	261.0783	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	261.1566	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	261.4698	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	261.6264	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	261.9396	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	262.0962	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	262.4094	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	262.566	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	262.8792	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	263.0358	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	263.349	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	263.6622	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	263.9754	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	264.2886	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	264.6018	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	264.915	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	265.2282	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	265.5414	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	265.8546	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	266.1678	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	269.3064	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	268.9896	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	268.6728	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	268.356	3.4500000477	72.727273	1	3712.500000	0.000000	1.700000	1.000000	55
i1	268.0392	3.4500000477	78.431373	1	3442.500000	0.000000	1.700000	1.000000	51
i1	267.7224	3.4500000477	85.106383	1	3172.500000	0.000000	1.700000	1.000000	47
i1	267.4056	3.4500000477	93.023256	1	2902.500000	0.000000	1.700000	1.000000	43
i1	267.0888	3.4500000477	102.564103	1	2632.500000	0.000000	1.700000	1.000000	39
i1	266.772	3.4500000477	114.285714	1	2362.500000	0.000000	1.700000	1.000000	35
i1	266.4552	3.4500000477	129.032258	1	2092.500000	0.000000	1.700000	1.000000	31
i1	266.1384	3.4500000477	148.148148	1	1822.500000	0.000000	1.700000	1.000000	27
i1	265.8216	3.4500000477	173.913043	1	1552.500000	0.000000	1.700000	1.000000	23
i1	265.3464	3.4500000477	235.294118	1	1147.500000	0.000000	1.700000	1.000000	17
i1	264.8712	3.4500000477	363.636364	1	742.500000	0.000000	1.700000	1.000000	11
i1	264.396	3.4500000477	800.000000	1	337.500000	0.000000	1.700000	1.000000	5
i1	264.0792	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	264.3168	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	264.4752	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	264.792	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	264.9504	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	265.2672	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	265.4256	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	265.7424	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	265.9008	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	266.2176	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	266.5344	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	266.8512	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	267.168	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	267.4848	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	267.8016	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	268.1184	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	268.4352	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	268.752	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	269.0688	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	272.2065	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	271.8861	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	271.5657	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	271.2453	3.4500000477	75.471698	1	3577.500000	0.000000	1.700000	1.000000	53
i1	270.9249	3.4500000477	81.632653	1	3307.500000	0.000000	1.700000	1.000000	49
i1	270.6045	3.4500000477	88.888889	1	3037.500000	0.000000	1.700000	1.000000	45
i1	270.2841	3.4500000477	97.560976	1	2767.500000	0.000000	1.700000	1.000000	41
i1	269.9637	3.4500000477	108.108108	1	2497.500000	0.000000	1.700000	1.000000	37
i1	269.6433	3.4500000477	121.212121	1	2227.500000	0.000000	1.700000	1.000000	33
i1	269.3229	3.4500000477	137.931034	1	1957.500000	0.000000	1.700000	1.000000	29
i1	269.0025	3.4500000477	160.000000	1	1687.500000	0.000000	1.700000	1.000000	25
i1	268.6821	3.4500000477	190.476190	1	1417.500000	0.000000	1.700000	1.000000	21
i1	268.2015	3.4500000477	266.666667	1	1012.500000	0.000000	1.700000	1.000000	15
i1	267.7209	3.4500000477	444.444444	1	607.500000	0.000000	1.700000	1.000000	9
i1	267.2403	3.4500000477	1333.333333	1	202.500000	0.000000	1.700000	1.000000	3
i1	267.1602	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	267.3204	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	267.6408	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	267.801	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	268.1214	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	268.2816	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	268.602	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	268.7622	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	269.0826	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	269.403	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	269.7234	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	270.0438	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	270.3642	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	270.6846	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	271.005	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	271.3254	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	271.6458	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	271.9662	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	272.2866	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	275.427	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	275.103	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	274.779	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	274.455	3.4500000477	72.727273	1	3712.500000	0.000000	1.700000	1.000000	55
i1	274.131	3.4500000477	78.431373	1	3442.500000	0.000000	1.700000	1.000000	51
i1	273.807	3.4500000477	85.106383	1	3172.500000	0.000000	1.700000	1.000000	47
i1	273.483	3.4500000477	93.023256	1	2902.500000	0.000000	1.700000	1.000000	43
i1	273.159	3.4500000477	102.564103	1	2632.500000	0.000000	1.700000	1.000000	39
i1	272.835	3.4500000477	114.285714	1	2362.500000	0.000000	1.700000	1.000000	35
i1	272.511	3.4500000477	129.032258	1	2092.500000	0.000000	1.700000	1.000000	31
i1	272.187	3.4500000477	148.148148	1	1822.500000	0.000000	1.700000	1.000000	27
i1	271.863	3.4500000477	173.913043	1	1552.500000	0.000000	1.700000	1.000000	23
i1	271.539	3.4500000477	210.526316	1	1282.500000	0.000000	1.700000	1.000000	19
i1	271.053	3.4500000477	307.692308	1	877.500000	0.000000	1.700000	1.000000	13
i1	270.567	3.4500000477	571.428571	1	472.500000	0.000000	1.700000	1.000000	7
i1	270.081	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	270.162	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	270.486	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	270.648	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	270.972	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	271.134	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	271.458	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	271.62	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	271.944	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	272.268	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	272.592	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	272.916	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	273.24	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	273.564	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	273.888	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	274.212	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	274.536	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	274.86	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	275.184	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	278.3235	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	277.9959	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	277.6683	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	277.3407	3.4500000477	75.471698	1	3577.500000	0.000000	1.700000	1.000000	53
i1	277.0131	3.4500000477	81.632653	1	3307.500000	0.000000	1.700000	1.000000	49
i1	276.6855	3.4500000477	88.888889	1	3037.500000	0.000000	1.700000	1.000000	45
i1	276.3579	3.4500000477	97.560976	1	2767.500000	0.000000	1.700000	1.000000	41
i1	276.0303	3.4500000477	108.108108	1	2497.500000	0.000000	1.700000	1.000000	37
i1	275.7027	3.4500000477	121.212121	1	2227.500000	0.000000	1.700000	1.000000	33
i1	275.3751	3.4500000477	137.931034	1	1957.500000	0.000000	1.700000	1.000000	29
i1	275.0475	3.4500000477	160.000000	1	1687.500000	0.000000	1.700000	1.000000	25
i1	274.7199	3.4500000477	190.476190	1	1417.500000	0.000000	1.700000	1.000000	21
i1	274.3923	3.4500000477	235.294118	1	1147.500000	0.000000	1.700000	1.000000	17
i1	273.9009	3.4500000477	363.636364	1	742.500000	0.000000	1.700000	1.000000	11
i1	273.4095	3.4500000477	800.000000	1	337.500000	0.000000	1.700000	1.000000	5
i1	273.0819	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	273.3276	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	273.4914	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	273.819	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	273.9828	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	274.3104	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	274.4742	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	274.8018	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	275.1294	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	275.457	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	275.7846	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	276.1122	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	276.4398	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	276.7674	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	277.095	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	277.4226	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	277.7502	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	278.0778	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	278.4054	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	281.5476	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	281.2164	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	280.8852	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	280.554	3.4500000477	72.727273	1	3712.500000	0.000000	1.700000	1.000000	55
i1	280.2228	3.4500000477	78.431373	1	3442.500000	0.000000	1.700000	1.000000	51
i1	279.8916	3.4500000477	85.106383	1	3172.500000	0.000000	1.700000	1.000000	47
i1	279.5604	3.4500000477	93.023256	1	2902.500000	0.000000	1.700000	1.000000	43
i1	279.2292	3.4500000477	102.564103	1	2632.500000	0.000000	1.700000	1.000000	39
i1	278.898	3.4500000477	114.285714	1	2362.500000	0.000000	1.700000	1.000000	35
i1	278.5668	3.4500000477	129.032258	1	2092.500000	0.000000	1.700000	1.000000	31
i1	278.2356	3.4500000477	148.148148	1	1822.500000	0.000000	1.700000	1.000000	27
i1	277.9044	3.4500000477	173.913043	1	1552.500000	0.000000	1.700000	1.000000	23
i1	277.5732	3.4500000477	210.526316	1	1282.500000	0.000000	1.700000	1.000000	19
i1	277.242	3.4500000477	266.666667	1	1012.500000	0.000000	1.700000	1.000000	15
i1	276.7452	3.4500000477	444.444444	1	607.500000	0.000000	1.700000	1.000000	9
i1	276.2484	3.4500000477	1333.333333	1	202.500000	0.000000	1.700000	1.000000	3
i1	276.1656	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	276.3312	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	276.6624	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	276.828	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	277.1592	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	277.3248	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	277.656	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	277.9872	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	278.3184	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	278.6496	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	278.9808	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	279.312	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	279.6432	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	279.9744	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	280.3056	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	280.6368	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	280.968	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	281.2992	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	284.4405	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	284.1057	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	283.7709	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	283.4361	3.4500000477	75.471698	1	3577.500000	0.000000	1.700000	1.000000	53
i1	283.1013	3.4500000477	81.632653	1	3307.500000	0.000000	1.700000	1.000000	49
i1	282.7665	3.4500000477	88.888889	1	3037.500000	0.000000	1.700000	1.000000	45
i1	282.4317	3.4500000477	97.560976	1	2767.500000	0.000000	1.700000	1.000000	41
i1	282.0969	3.4500000477	108.108108	1	2497.500000	0.000000	1.700000	1.000000	37
i1	281.7621	3.4500000477	121.212121	1	2227.500000	0.000000	1.700000	1.000000	33
i1	281.4273	3.4500000477	137.931034	1	1957.500000	0.000000	1.700000	1.000000	29
i1	281.0925	3.4500000477	160.000000	1	1687.500000	0.000000	1.700000	1.000000	25
i1	280.7577	3.4500000477	190.476190	1	1417.500000	0.000000	1.700000	1.000000	21
i1	280.4229	3.4500000477	235.294118	1	1147.500000	0.000000	1.700000	1.000000	17
i1	280.0881	3.4500000477	307.692308	1	877.500000	0.000000	1.700000	1.000000	13
i1	279.5859	3.4500000477	571.428571	1	472.500000	0.000000	1.700000	1.000000	7
i1	279.0837	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	279.1674	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	279.5022	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	279.6696	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	280.0044	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	280.1718	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	280.5066	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	280.8414	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	281.1762	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	281.511	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	281.8458	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	282.1806	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	282.5154	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	282.8502	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	283.185	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	283.5198	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	283.8546	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	284.1894	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	284.5242	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	287.6682	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	287.3298	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	286.9914	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	286.653	3.4500000477	72.727273	1	3712.500000	0.000000	1.700000	1.000000	55
i1	286.3146	3.4500000477	78.431373	1	3442.500000	0.000000	1.700000	1.000000	51
i1	285.9762	3.4500000477	85.106383	1	3172.500000	0.000000	1.700000	1.000000	47
i1	285.6378	3.4500000477	93.023256	1	2902.500000	0.000000	1.700000	1.000000	43
i1	285.2994	3.4500000477	102.564103	1	2632.500000	0.000000	1.700000	1.000000	39
i1	284.961	3.4500000477	114.285714	1	2362.500000	0.000000	1.700000	1.000000	35
i1	284.6226	3.4500000477	129.032258	1	2092.500000	0.000000	1.700000	1.000000	31
i1	284.2842	3.4500000477	148.148148	1	1822.500000	0.000000	1.700000	1.000000	27
i1	283.9458	3.4500000477	173.913043	1	1552.500000	0.000000	1.700000	1.000000	23
i1	283.6074	3.4500000477	210.526316	1	1282.500000	0.000000	1.700000	1.000000	19
i1	283.269	3.4500000477	266.666667	1	1012.500000	0.000000	1.700000	1.000000	15
i1	282.9306	3.4500000477	363.636364	1	742.500000	0.000000	1.700000	1.000000	11
i1	282.423	3.4500000477	800.000000	1	337.500000	0.000000	1.700000	1.000000	5
i1	282.0846	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	282.3384	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	282.5076	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	282.846	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	283.0152	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	283.3536	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	283.692	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	284.0304	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	284.3688	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	284.7072	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	285.0456	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	285.384	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	285.7224	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	286.0608	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	286.3992	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	286.7376	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	287.076	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	287.4144	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	290.5575	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	290.2155	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	289.8735	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	289.5315	3.4500000477	75.471698	1	3577.500000	0.000000	1.700000	1.000000	53
i1	289.1895	3.4500000477	81.632653	1	3307.500000	0.000000	1.700000	1.000000	49
i1	288.8475	3.4500000477	88.888889	1	3037.500000	0.000000	1.700000	1.000000	45
i1	288.5055	3.4500000477	97.560976	1	2767.500000	0.000000	1.700000	1.000000	41
i1	288.1635	3.4500000477	108.108108	1	2497.500000	0.000000	1.700000	1.000000	37
i1	287.8215	3.4500000477	121.212121	1	2227.500000	0.000000	1.700000	1.000000	33
i1	287.4795	3.4500000477	137.931034	1	1957.500000	0.000000	1.700000	1.000000	29
i1	287.1375	3.4500000477	160.000000	1	1687.500000	0.000000	1.700000	1.000000	25
i1	286.7955	3.4500000477	190.476190	1	1417.500000	0.000000	1.700000	1.000000	21
i1	286.4535	3.4500000477	235.294118	1	1147.500000	0.000000	1.700000	1.000000	17
i1	286.1115	3.4500000477	307.692308	1	877.500000	0.000000	1.700000	1.000000	13
i1	285.7695	3.4500000477	444.444444	1	607.500000	0.000000	1.700000	1.000000	9
i1	285.2565	3.4500000477	1333.333333	1	202.500000	0.000000	1.700000	1.000000	3
i1	285.171	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	285.342	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	285.684	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	285.855	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	286.197	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	286.539	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	286.881	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	287.223	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	287.565	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	287.907	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	288.249	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	288.591	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	288.933	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	289.275	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	289.617	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	289.959	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	290.301	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	290.643	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	293.7888	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	293.4432	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	293.0976	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	292.752	3.4500000477	72.727273	1	3712.500000	0.000000	1.700000	1.000000	55
i1	292.4064	3.4500000477	78.431373	1	3442.500000	0.000000	1.700000	1.000000	51
i1	292.0608	3.4500000477	85.106383	1	3172.500000	0.000000	1.700000	1.000000	47
i1	291.7152	3.4500000477	93.023256	1	2902.500000	0.000000	1.700000	1.000000	43
i1	291.3696	3.4500000477	102.564103	1	2632.500000	0.000000	1.700000	1.000000	39
i1	291.024	3.4500000477	114.285714	1	2362.500000	0.000000	1.700000	1.000000	35
i1	290.6784	3.4500000477	129.032258	1	2092.500000	0.000000	1.700000	1.000000	31
i1	290.3328	3.4500000477	148.148148	1	1822.500000	0.000000	1.700000	1.000000	27
i1	289.9872	3.4500000477	173.913043	1	1552.500000	0.000000	1.700000	1.000000	23
i1	289.6416	3.4500000477	210.526316	1	1282.500000	0.000000	1.700000	1.000000	19
i1	289.296	3.4500000477	266.666667	1	1012.500000	0.000000	1.700000	1.000000	15
i1	288.9504	3.4500000477	363.636364	1	742.500000	0.000000	1.700000	1.000000	11
i1	288.6048	3.4500000477	571.428571	1	472.500000	0.000000	1.700000	1.000000	7
i1	288.0864	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	288.1728	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	288.5184	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	288.6912	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	289.0368	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	289.3824	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	289.728	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	290.0736	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	290.4192	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	290.7648	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	291.1104	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	291.456	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	291.8016	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	292.1472	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	292.4928	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	292.8384	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	293.184	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	293.5296	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	296.6745	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	296.3253	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	295.9761	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	295.6269	3.4500000477	75.471698	1	3577.500000	0.000000	1.700000	1.000000	53
i1	295.2777	3.4500000477	81.632653	1	3307.500000	0.000000	1.700000	1.000000	49
i1	294.9285	3.4500000477	88.888889	1	3037.500000	0.000000	1.700000	1.000000	45
i1	294.5793	3.4500000477	97.560976	1	2767.500000	0.000000	1.700000	1.000000	41
i1	294.2301	3.4500000477	108.108108	1	2497.500000	0.000000	1.700000	1.000000	37
i1	293.8809	3.4500000477	121.212121	1	2227.500000	0.000000	1.700000	1.000000	33
i1	293.5317	3.4500000477	137.931034	1	1957.500000	0.000000	1.700000	1.000000	29
i1	293.1825	3.4500000477	160.000000	1	1687.500000	0.000000	1.700000	1.000000	25
i1	292.8333	3.4500000477	190.476190	1	1417.500000	0.000000	1.700000	1.000000	21
i1	292.4841	3.4500000477	235.294118	1	1147.500000	0.000000	1.700000	1.000000	17
i1	292.1349	3.4500000477	307.692308	1	877.500000	0.000000	1.700000	1.000000	13
i1	291.7857	3.4500000477	444.444444	1	607.500000	0.000000	1.700000	1.000000	9
i1	291.4365	3.4500000477	800.000000	1	337.500000	0.000000	1.700000	1.000000	5
i1	291.0873	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	291.3492	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	291.5238	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	291.873	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	292.2222	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	292.5714	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	292.9206	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	293.2698	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	293.619	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	293.9682	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	294.3174	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	294.6666	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	295.0158	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	295.365	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	295.7142	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	296.0634	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	296.4126	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	296.7618	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	299.9094	3.4500000477	59.701493	1	4522.500000	0.000000	1.700000	1.000000	67
i1	299.5566	3.4500000477	63.492063	1	4252.500000	0.000000	1.700000	1.000000	63
i1	299.2038	3.4500000477	67.796610	1	3982.500000	0.000000	1.700000	1.000000	59
i1	298.851	3.4500000477	72.727273	1	3712.500000	0.000000	1.700000	1.000000	55
i1	298.4982	3.4500000477	78.431373	1	3442.500000	0.000000	1.700000	1.000000	51
i1	298.1454	3.4500000477	85.106383	1	3172.500000	0.000000	1.700000	1.000000	47
i1	297.7926	3.4500000477	93.023256	1	2902.500000	0.000000	1.700000	1.000000	43
i1	297.4398	3.4500000477	102.564103	1	2632.500000	0.000000	1.700000	1.000000	39
i1	297.087	3.4500000477	114.285714	1	2362.500000	0.000000	1.700000	1.000000	35
i1	296.7342	3.4500000477	129.032258	1	2092.500000	0.000000	1.700000	1.000000	31
i1	296.3814	3.4500000477	148.148148	1	1822.500000	0.000000	1.700000	1.000000	27
i1	296.0286	3.4500000477	173.913043	1	1552.500000	0.000000	1.700000	1.000000	23
i1	295.6758	3.4500000477	210.526316	1	1282.500000	0.000000	1.700000	1.000000	19
i1	295.323	3.4500000477	266.666667	1	1012.500000	0.000000	1.700000	1.000000	15
i1	294.9702	3.4500000477	363.636364	1	742.500000	0.000000	1.700000	1.000000	11
i1	294.6174	3.4500000477	571.428571	1	472.500000	0.000000	1.700000	1.000000	7
i1	294.2646	3.4500000477	1333.333333	1	202.500000	0.000000	1.700000	1.000000	3
i1	294.1764	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	294.3528	3.4500000477	1000.000000	1	270.000000	0.000000	1.700000	1.000000	4
i1	294.7056	3.4500000477	500.000000	1	540.000000	0.000000	1.700000	1.000000	8
i1	295.0584	3.4500000477	333.333333	1	810.000000	0.000000	1.700000	1.000000	12
i1	295.4112	3.4500000477	250.000000	1	1080.000000	0.000000	1.700000	1.000000	16
i1	295.764	3.4500000477	200.000000	1	1350.000000	0.000000	1.700000	1.000000	20
i1	296.1168	3.4500000477	166.666667	1	1620.000000	0.000000	1.700000	1.000000	24
i1	296.4696	3.4500000477	142.857143	1	1890.000000	0.000000	1.700000	1.000000	28
i1	296.8224	3.4500000477	125.000000	1	2160.000000	0.000000	1.700000	1.000000	32
i1	297.1752	3.4500000477	111.111111	1	2430.000000	0.000000	1.700000	1.000000	36
i1	297.528	3.4500000477	100.000000	1	2700.000000	0.000000	1.700000	1.000000	40
i1	297.8808	3.4500000477	90.909091	1	2970.000000	0.000000	1.700000	1.000000	44
i1	298.2336	3.4500000477	83.333333	1	3240.000000	0.000000	1.700000	1.000000	48
i1	298.5864	3.4500000477	76.923077	1	3510.000000	0.000000	1.700000	1.000000	52
i1	298.9392	3.4500000477	71.428571	1	3780.000000	0.000000	1.700000	1.000000	56
i1	299.292	3.4500000477	66.666667	1	4050.000000	0.000000	1.700000	1.000000	60
i1	299.6448	3.4500000477	62.500000	1	4320.000000	0.000000	1.700000	1.000000	64
i1	302.7915	3.4500000477	61.538462	1	4387.500000	0.000000	1.700000	1.000000	65
i1	302.4351	3.4500000477	65.573770	1	4117.500000	0.000000	1.700000	1.000000	61
i1	302.0787	3.4500000477	70.175439	1	3847.500000	0.000000	1.700000	1.000000	57
i1	301.7223	3.4500000477	75.471698	1	3577.500000	0.000000	1.700000	1.000000	53
i1	301.3659	3.4500000477	81.632653	1	3307.500000	0.000000	1.700000	1.000000	49
i1	301.0095	3.4500000477	88.888889	1	3037.500000	0.000000	1.700000	1.000000	45
i1	300.6531	3.4500000477	97.560976	1	2767.500000	0.000000	1.700000	1.000000	41
i1	300.2967	3.4500000477	108.108108	1	2497.500000	0.000000	1.700000	1.000000	37
i1	299.9403	3.4500000477	121.212121	1	2227.500000	0.000000	1.700000	1.000000	33
i1	299.5839	3.4500000477	137.931034	1	1957.500000	0.000000	1.700000	1.000000	29
i1	299.2275	3.4500000477	160.000000	1	1687.500000	0.000000	1.700000	1.000000	25
i1	298.8711	3.4500000477	190.476190	1	1417.500000	0.000000	1.700000	1.000000	21
i1	298.5147	3.4500000477	235.294118	1	1147.500000	0.000000	1.700000	1.000000	17
i1	298.1583	3.4500000477	307.692308	1	877.500000	0.000000	1.700000	1.000000	13
i1	297.8019	3.4500000477	444.444444	1	607.500000	0.000000	1.700000	1.000000	9
i1	297.4455	3.4500000477	800.000000	1	337.500000	0.000000	1.700000	1.000000	5
i1	297.0891	3.4500000477	4000.000000	1	67.500000	0.000000	1.700000	1.000000	1
i1	297.1782	3.4500000477	2000.000000	1	135.000000	0.000000	1.700000	1.000000	2
i1	297.5346	3.4500000477	666.666667	1	405.000000	0.000000	1.700000	1.000000	6
i1	297.891	3.4500000477	400.000000	1	675.000000	0.000000	1.700000	1.000000	10
i1	298.2474	3.4500000477	285.714286	1	945.000000	0.000000	1.700000	1.000000	14
i1	298.6038	3.4500000477	222.222222	1	1215.000000	0.000000	1.700000	1.000000	18
i1	298.9602	3.4500000477	181.818182	1	1485.000000	0.000000	1.700000	1.000000	22
i1	299.3166	3.4500000477	153.846154	1	1755.000000	0.000000	1.700000	1.000000	26
i1	299.673	3.4500000477	133.333333	1	2025.000000	0.000000	1.700000	1.000000	30
i1	300.0294	3.4500000477	117.647059	1	2295.000000	0.000000	1.700000	1.000000	34
i1	300.3858	3.4500000477	105.263158	1	2565.000000	0.000000	1.700000	1.000000	38
i1	300.7422	3.4500000477	95.238095	1	2835.000000	0.000000	1.700000	1.000000	42
i1	301.0986	3.4500000477	86.956522	1	3105.000000	0.000000	1.700000	1.000000	46
i1	301.455	3.4500000477	80.000000	1	3375.000000	0.000000	1.700000	1.000000	50
i1	301.8114	3.4500000477	74.074074	1	3645.000000	0.000000	1.700000	1.000000	54
i1	302.1678	3.4500000477	68.965517	1	3915.000000	0.000000	1.700000	1.000000	58
i1	302.5242	3.4500000477	64.516129	1	4185.000000	0.000000	1.700000	1.000000	62
i1	302.8806	3.4500000477	60.606061	1	4455.000000	0.000000	1.700000	1.000000	66
i1	306.03	20.7000007629	59.701493	1	4522.500000	0.000000	1.700000	6.900000	67
i1	305.67	20.7000007629	63.492063	1	4252.500000	0.000000	1.700000	6.900000	63
i1	305.31	20.7000007629	67.796610	1	3982.500000	0.000000	1.700000	6.900000	59
i1	304.95	20.7000007629	72.727273	1	3712.500000	0.000000	1.700000	6.900000	55
i1	304.59	20.7000007629	78.431373	1	3442.500000	0.000000	1.700000	6.900000	51
i1	304.23	20.7000007629	85.106383	1	3172.500000	0.000000	1.700000	6.900000	47
i1	303.87	20.7000007629	93.023256	1	2902.500000	0.000000	1.700000	6.900000	43
i1	303.51	20.7000007629	102.564103	1	2632.500000	0.000000	1.700000	6.900000	39
i1	303.15	20.7000007629	114.285714	1	2362.500000	0.000000	1.700000	6.900000	35
i1	302.79	20.7000007629	129.032258	1	2092.500000	0.000000	1.700000	6.900000	31
i1	302.43	20.7000007629	148.148148	1	1822.500000	0.000000	1.700000	6.900000	27
i1	302.07	20.7000007629	173.913043	1	1552.500000	0.000000	1.700000	6.900000	23
i1	301.71	20.7000007629	210.526316	1	1282.500000	0.000000	1.700000	6.900000	19
i1	301.35	20.7000007629	266.666667	1	1012.500000	0.000000	1.700000	6.900000	15
i1	300.99	20.7000007629	363.636364	1	742.500000	0.000000	1.700000	6.900000	11
i1	300.63	20.7000007629	571.428571	1	472.500000	0.000000	1.700000	6.900000	7
i1	300.27	20.7000007629	1333.333333	1	202.500000	0.000000	1.700000	6.900000	3
i1	300.09	20.7000007629	4000.000000	1	67.500000	0.000000	1.700000	6.900000	1
i1	300.36	20.7000007629	1000.000000	1	270.000000	0.000000	1.700000	6.900000	4
i1	300.72	20.7000007629	500.000000	1	540.000000	0.000000	1.700000	6.900000	8
i1	301.08	20.7000007629	333.333333	1	810.000000	0.000000	1.700000	6.900000	12
i1	301.44	20.7000007629	250.000000	1	1080.000000	0.000000	1.700000	6.900000	16
i1	301.8	20.7000007629	200.000000	1	1350.000000	0.000000	1.700000	6.900000	20
i1	302.16	20.7000007629	166.666667	1	1620.000000	0.000000	1.700000	6.900000	24
i1	302.52	20.7000007629	142.857143	1	1890.000000	0.000000	1.700000	6.900000	28
i1	302.88	20.7000007629	125.000000	1	2160.000000	0.000000	1.700000	6.900000	32
i1	303.24	20.7000007629	111.111111	1	2430.000000	0.000000	1.700000	6.900000	36
i1	303.6	20.7000007629	100.000000	1	2700.000000	0.000000	1.700000	6.900000	40
i1	303.96	20.7000007629	90.909091	1	2970.000000	0.000000	1.700000	6.900000	44
i1	304.32	20.7000007629	83.333333	1	3240.000000	0.000000	1.700000	6.900000	48
i1	304.68	20.7000007629	76.923077	1	3510.000000	0.000000	1.700000	6.900000	52
i1	305.04	20.7000007629	71.428571	1	3780.000000	0.000000	1.700000	6.900000	56
i1	305.4	20.7000007629	66.666667	1	4050.000000	0.000000	1.700000	6.900000	60
i1	305.76	20.7000007629	62.500000	1	4320.000000	0.000000	1.700000	6.900000	64
i1	3.0009	20.7000007629	3600.000000	1	180.000000	0.700000	1.700000	6.900000	1
i1	6.1206	3.4500000477	53.731343	1	12060.000000	0.700000	1.700000	1.000000	67
i1	6.117	3.4500000477	55.384615	1	11700.000000	0.700000	1.700000	1.000000	65
i1	6.1134	3.4500000477	57.142857	1	11340.000000	0.700000	1.700000	1.000000	63
i1	6.1098	3.4500000477	59.016393	1	10980.000000	0.700000	1.700000	1.000000	61
i1	6.1062	3.4500000477	61.016949	1	10620.000000	0.700000	1.700000	1.000000	59
i1	6.1026	3.4500000477	63.157895	1	10260.000000	0.700000	1.700000	1.000000	57
i1	6.099	3.4500000477	65.454545	1	9900.000000	0.700000	1.700000	1.000000	55
i1	6.0954	3.4500000477	67.924528	1	9540.000000	0.700000	1.700000	1.000000	53
i1	6.0918	3.4500000477	70.588235	1	9180.000000	0.700000	1.700000	1.000000	51
i1	6.0882	3.4500000477	73.469388	1	8820.000000	0.700000	1.700000	1.000000	49
i1	6.0846	3.4500000477	76.595745	1	8460.000000	0.700000	1.700000	1.000000	47
i1	6.081	3.4500000477	80.000000	1	8100.000000	0.700000	1.700000	1.000000	45
i1	6.0774	3.4500000477	83.720930	1	7740.000000	0.700000	1.700000	1.000000	43
i1	6.0738	3.4500000477	87.804878	1	7380.000000	0.700000	1.700000	1.000000	41
i1	6.0702	3.4500000477	92.307692	1	7020.000000	0.700000	1.700000	1.000000	39
i1	6.0666	3.4500000477	97.297297	1	6660.000000	0.700000	1.700000	1.000000	37
i1	6.063	3.4500000477	102.857143	1	6300.000000	0.700000	1.700000	1.000000	35
i1	6.0594	3.4500000477	109.090909	1	5940.000000	0.700000	1.700000	1.000000	33
i1	6.0558	3.4500000477	116.129032	1	5580.000000	0.700000	1.700000	1.000000	31
i1	6.0522	3.4500000477	124.137931	1	5220.000000	0.700000	1.700000	1.000000	29
i1	6.0486	3.4500000477	133.333333	1	4860.000000	0.700000	1.700000	1.000000	27
i1	6.045	3.4500000477	144.000000	1	4500.000000	0.700000	1.700000	1.000000	25
i1	6.0414	3.4500000477	156.521739	1	4140.000000	0.700000	1.700000	1.000000	23
i1	6.0378	3.4500000477	171.428571	1	3780.000000	0.700000	1.700000	1.000000	21
i1	6.0342	3.4500000477	189.473684	1	3420.000000	0.700000	1.700000	1.000000	19
i1	6.0306	3.4500000477	211.764706	1	3060.000000	0.700000	1.700000	1.000000	17
i1	6.027	3.4500000477	240.000000	1	2700.000000	0.700000	1.700000	1.000000	15
i1	6.0234	3.4500000477	276.923077	1	2340.000000	0.700000	1.700000	1.000000	13
i1	6.0198	3.4500000477	327.272727	1	1980.000000	0.700000	1.700000	1.000000	11
i1	6.0162	3.4500000477	400.000000	1	1620.000000	0.700000	1.700000	1.000000	9
i1	6.0126	3.4500000477	514.285714	1	1260.000000	0.700000	1.700000	1.000000	7
i1	6.009	3.4500000477	720.000000	1	900.000000	0.700000	1.700000	1.000000	5
i1	6.0054	3.4500000477	1200.000000	1	540.000000	0.700000	1.700000	1.000000	3
i1	6.0036	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	6.0072	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	6.0108	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	6.0144	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	6.018	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	6.0216	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	6.0252	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	6.0288	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	6.0324	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	6.036	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	6.0396	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	6.0432	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	6.0468	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	6.0504	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	6.054	3.4500000477	120.000000	1	5400.000000	0.700000	1.700000	1.000000	30
i1	6.0576	3.4500000477	112.500000	1	5760.000000	0.700000	1.700000	1.000000	32
i1	6.0612	3.4500000477	105.882353	1	6120.000000	0.700000	1.700000	1.000000	34
i1	6.0648	3.4500000477	100.000000	1	6480.000000	0.700000	1.700000	1.000000	36
i1	6.0684	3.4500000477	94.736842	1	6840.000000	0.700000	1.700000	1.000000	38
i1	6.072	3.4500000477	90.000000	1	7200.000000	0.700000	1.700000	1.000000	40
i1	6.0756	3.4500000477	85.714286	1	7560.000000	0.700000	1.700000	1.000000	42
i1	6.0792	3.4500000477	81.818182	1	7920.000000	0.700000	1.700000	1.000000	44
i1	6.0828	3.4500000477	78.260870	1	8280.000000	0.700000	1.700000	1.000000	46
i1	6.0864	3.4500000477	75.000000	1	8640.000000	0.700000	1.700000	1.000000	48
i1	6.09	3.4500000477	72.000000	1	9000.000000	0.700000	1.700000	1.000000	50
i1	6.0936	3.4500000477	69.230769	1	9360.000000	0.700000	1.700000	1.000000	52
i1	6.0972	3.4500000477	66.666667	1	9720.000000	0.700000	1.700000	1.000000	54
i1	6.1008	3.4500000477	64.285714	1	10080.000000	0.700000	1.700000	1.000000	56
i1	6.1044	3.4500000477	62.068966	1	10440.000000	0.700000	1.700000	1.000000	58
i1	6.108	3.4500000477	60.000000	1	10800.000000	0.700000	1.700000	1.000000	60
i1	6.1116	3.4500000477	58.064516	1	11160.000000	0.700000	1.700000	1.000000	62
i1	6.1152	3.4500000477	56.250000	1	11520.000000	0.700000	1.700000	1.000000	64
i1	6.1188	3.4500000477	54.545455	1	11880.000000	0.700000	1.700000	1.000000	66
i1	9.0027	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	9.0054	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	12.2412	3.4500000477	53.731343	1	12060.000000	0.700000	1.700000	1.000000	67
i1	12.234	3.4500000477	55.384615	1	11700.000000	0.700000	1.700000	1.000000	65
i1	12.2268	3.4500000477	57.142857	1	11340.000000	0.700000	1.700000	1.000000	63
i1	12.2196	3.4500000477	59.016393	1	10980.000000	0.700000	1.700000	1.000000	61
i1	12.2124	3.4500000477	61.016949	1	10620.000000	0.700000	1.700000	1.000000	59
i1	12.2052	3.4500000477	63.157895	1	10260.000000	0.700000	1.700000	1.000000	57
i1	12.198	3.4500000477	65.454545	1	9900.000000	0.700000	1.700000	1.000000	55
i1	12.1908	3.4500000477	67.924528	1	9540.000000	0.700000	1.700000	1.000000	53
i1	12.1836	3.4500000477	70.588235	1	9180.000000	0.700000	1.700000	1.000000	51
i1	12.1764	3.4500000477	73.469388	1	8820.000000	0.700000	1.700000	1.000000	49
i1	12.1692	3.4500000477	76.595745	1	8460.000000	0.700000	1.700000	1.000000	47
i1	12.162	3.4500000477	80.000000	1	8100.000000	0.700000	1.700000	1.000000	45
i1	12.1548	3.4500000477	83.720930	1	7740.000000	0.700000	1.700000	1.000000	43
i1	12.1476	3.4500000477	87.804878	1	7380.000000	0.700000	1.700000	1.000000	41
i1	12.1404	3.4500000477	92.307692	1	7020.000000	0.700000	1.700000	1.000000	39
i1	12.1332	3.4500000477	97.297297	1	6660.000000	0.700000	1.700000	1.000000	37
i1	12.126	3.4500000477	102.857143	1	6300.000000	0.700000	1.700000	1.000000	35
i1	12.1188	3.4500000477	109.090909	1	5940.000000	0.700000	1.700000	1.000000	33
i1	12.1116	3.4500000477	116.129032	1	5580.000000	0.700000	1.700000	1.000000	31
i1	12.1044	3.4500000477	124.137931	1	5220.000000	0.700000	1.700000	1.000000	29
i1	12.0972	3.4500000477	133.333333	1	4860.000000	0.700000	1.700000	1.000000	27
i1	12.09	3.4500000477	144.000000	1	4500.000000	0.700000	1.700000	1.000000	25
i1	12.0828	3.4500000477	156.521739	1	4140.000000	0.700000	1.700000	1.000000	23
i1	12.0756	3.4500000477	171.428571	1	3780.000000	0.700000	1.700000	1.000000	21
i1	12.0684	3.4500000477	189.473684	1	3420.000000	0.700000	1.700000	1.000000	19
i1	12.0612	3.4500000477	211.764706	1	3060.000000	0.700000	1.700000	1.000000	17
i1	12.054	3.4500000477	240.000000	1	2700.000000	0.700000	1.700000	1.000000	15
i1	12.0468	3.4500000477	276.923077	1	2340.000000	0.700000	1.700000	1.000000	13
i1	12.0396	3.4500000477	327.272727	1	1980.000000	0.700000	1.700000	1.000000	11
i1	12.0324	3.4500000477	400.000000	1	1620.000000	0.700000	1.700000	1.000000	9
i1	12.0252	3.4500000477	514.285714	1	1260.000000	0.700000	1.700000	1.000000	7
i1	12.018	3.4500000477	720.000000	1	900.000000	0.700000	1.700000	1.000000	5
i1	12.0036	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	12.0144	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	12.0216	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	12.0288	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	12.036	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	12.0432	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	12.0504	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	12.0576	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	12.0648	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	12.072	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	12.0792	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	12.0864	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	12.0936	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	12.1008	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	12.108	3.4500000477	120.000000	1	5400.000000	0.700000	1.700000	1.000000	30
i1	12.1152	3.4500000477	112.500000	1	5760.000000	0.700000	1.700000	1.000000	32
i1	12.1224	3.4500000477	105.882353	1	6120.000000	0.700000	1.700000	1.000000	34
i1	12.1296	3.4500000477	100.000000	1	6480.000000	0.700000	1.700000	1.000000	36
i1	12.1368	3.4500000477	94.736842	1	6840.000000	0.700000	1.700000	1.000000	38
i1	12.144	3.4500000477	90.000000	1	7200.000000	0.700000	1.700000	1.000000	40
i1	12.1512	3.4500000477	85.714286	1	7560.000000	0.700000	1.700000	1.000000	42
i1	12.1584	3.4500000477	81.818182	1	7920.000000	0.700000	1.700000	1.000000	44
i1	12.1656	3.4500000477	78.260870	1	8280.000000	0.700000	1.700000	1.000000	46
i1	12.1728	3.4500000477	75.000000	1	8640.000000	0.700000	1.700000	1.000000	48
i1	12.18	3.4500000477	72.000000	1	9000.000000	0.700000	1.700000	1.000000	50
i1	12.1872	3.4500000477	69.230769	1	9360.000000	0.700000	1.700000	1.000000	52
i1	12.1944	3.4500000477	66.666667	1	9720.000000	0.700000	1.700000	1.000000	54
i1	12.2016	3.4500000477	64.285714	1	10080.000000	0.700000	1.700000	1.000000	56
i1	12.2088	3.4500000477	62.068966	1	10440.000000	0.700000	1.700000	1.000000	58
i1	12.216	3.4500000477	60.000000	1	10800.000000	0.700000	1.700000	1.000000	60
i1	12.2232	3.4500000477	58.064516	1	11160.000000	0.700000	1.700000	1.000000	62
i1	12.2304	3.4500000477	56.250000	1	11520.000000	0.700000	1.700000	1.000000	64
i1	12.2376	3.4500000477	54.545455	1	11880.000000	0.700000	1.700000	1.000000	66
i1	15.0135	3.4500000477	1200.000000	1	540.000000	0.700000	1.700000	1.000000	3
i1	15.009	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	15.018	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	18.3618	3.4500000477	53.731343	1	12060.000000	0.700000	1.700000	1.000000	67
i1	18.351	3.4500000477	55.384615	1	11700.000000	0.700000	1.700000	1.000000	65
i1	18.3402	3.4500000477	57.142857	1	11340.000000	0.700000	1.700000	1.000000	63
i1	18.3294	3.4500000477	59.016393	1	10980.000000	0.700000	1.700000	1.000000	61
i1	18.3186	3.4500000477	61.016949	1	10620.000000	0.700000	1.700000	1.000000	59
i1	18.3078	3.4500000477	63.157895	1	10260.000000	0.700000	1.700000	1.000000	57
i1	18.297	3.4500000477	65.454545	1	9900.000000	0.700000	1.700000	1.000000	55
i1	18.2862	3.4500000477	67.924528	1	9540.000000	0.700000	1.700000	1.000000	53
i1	18.2754	3.4500000477	70.588235	1	9180.000000	0.700000	1.700000	1.000000	51
i1	18.2646	3.4500000477	73.469388	1	8820.000000	0.700000	1.700000	1.000000	49
i1	18.2538	3.4500000477	76.595745	1	8460.000000	0.700000	1.700000	1.000000	47
i1	18.243	3.4500000477	80.000000	1	8100.000000	0.700000	1.700000	1.000000	45
i1	18.2322	3.4500000477	83.720930	1	7740.000000	0.700000	1.700000	1.000000	43
i1	18.2214	3.4500000477	87.804878	1	7380.000000	0.700000	1.700000	1.000000	41
i1	18.2106	3.4500000477	92.307692	1	7020.000000	0.700000	1.700000	1.000000	39
i1	18.1998	3.4500000477	97.297297	1	6660.000000	0.700000	1.700000	1.000000	37
i1	18.189	3.4500000477	102.857143	1	6300.000000	0.700000	1.700000	1.000000	35
i1	18.1782	3.4500000477	109.090909	1	5940.000000	0.700000	1.700000	1.000000	33
i1	18.1674	3.4500000477	116.129032	1	5580.000000	0.700000	1.700000	1.000000	31
i1	18.1566	3.4500000477	124.137931	1	5220.000000	0.700000	1.700000	1.000000	29
i1	18.1458	3.4500000477	133.333333	1	4860.000000	0.700000	1.700000	1.000000	27
i1	18.135	3.4500000477	144.000000	1	4500.000000	0.700000	1.700000	1.000000	25
i1	18.1242	3.4500000477	156.521739	1	4140.000000	0.700000	1.700000	1.000000	23
i1	18.1134	3.4500000477	171.428571	1	3780.000000	0.700000	1.700000	1.000000	21
i1	18.1026	3.4500000477	189.473684	1	3420.000000	0.700000	1.700000	1.000000	19
i1	18.0918	3.4500000477	211.764706	1	3060.000000	0.700000	1.700000	1.000000	17
i1	18.081	3.4500000477	240.000000	1	2700.000000	0.700000	1.700000	1.000000	15
i1	18.0702	3.4500000477	276.923077	1	2340.000000	0.700000	1.700000	1.000000	13
i1	18.0594	3.4500000477	327.272727	1	1980.000000	0.700000	1.700000	1.000000	11
i1	18.0486	3.4500000477	400.000000	1	1620.000000	0.700000	1.700000	1.000000	9
i1	18.0378	3.4500000477	514.285714	1	1260.000000	0.700000	1.700000	1.000000	7
i1	18.0054	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	18.0108	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	18.0324	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	18.0432	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	18.054	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	18.0648	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	18.0756	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	18.0864	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	18.0972	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	18.108	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	18.1188	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	18.1296	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	18.1404	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	18.1512	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	18.162	3.4500000477	120.000000	1	5400.000000	0.700000	1.700000	1.000000	30
i1	18.1728	3.4500000477	112.500000	1	5760.000000	0.700000	1.700000	1.000000	32
i1	18.1836	3.4500000477	105.882353	1	6120.000000	0.700000	1.700000	1.000000	34
i1	18.1944	3.4500000477	100.000000	1	6480.000000	0.700000	1.700000	1.000000	36
i1	18.2052	3.4500000477	94.736842	1	6840.000000	0.700000	1.700000	1.000000	38
i1	18.216	3.4500000477	90.000000	1	7200.000000	0.700000	1.700000	1.000000	40
i1	18.2268	3.4500000477	85.714286	1	7560.000000	0.700000	1.700000	1.000000	42
i1	18.2376	3.4500000477	81.818182	1	7920.000000	0.700000	1.700000	1.000000	44
i1	18.2484	3.4500000477	78.260870	1	8280.000000	0.700000	1.700000	1.000000	46
i1	18.2592	3.4500000477	75.000000	1	8640.000000	0.700000	1.700000	1.000000	48
i1	18.27	3.4500000477	72.000000	1	9000.000000	0.700000	1.700000	1.000000	50
i1	18.2808	3.4500000477	69.230769	1	9360.000000	0.700000	1.700000	1.000000	52
i1	18.2916	3.4500000477	66.666667	1	9720.000000	0.700000	1.700000	1.000000	54
i1	18.3024	3.4500000477	64.285714	1	10080.000000	0.700000	1.700000	1.000000	56
i1	18.3132	3.4500000477	62.068966	1	10440.000000	0.700000	1.700000	1.000000	58
i1	18.324	3.4500000477	60.000000	1	10800.000000	0.700000	1.700000	1.000000	60
i1	18.3348	3.4500000477	58.064516	1	11160.000000	0.700000	1.700000	1.000000	62
i1	18.3456	3.4500000477	56.250000	1	11520.000000	0.700000	1.700000	1.000000	64
i1	18.3564	3.4500000477	54.545455	1	11880.000000	0.700000	1.700000	1.000000	66
i1	21.0315	3.4500000477	720.000000	1	900.000000	0.700000	1.700000	1.000000	5
i1	21.0063	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	21.0252	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	21.0378	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	24.4824	3.4500000477	53.731343	1	12060.000000	0.700000	1.700000	1.000000	67
i1	24.468	3.4500000477	55.384615	1	11700.000000	0.700000	1.700000	1.000000	65
i1	24.4536	3.4500000477	57.142857	1	11340.000000	0.700000	1.700000	1.000000	63
i1	24.4392	3.4500000477	59.016393	1	10980.000000	0.700000	1.700000	1.000000	61
i1	24.4248	3.4500000477	61.016949	1	10620.000000	0.700000	1.700000	1.000000	59
i1	24.4104	3.4500000477	63.157895	1	10260.000000	0.700000	1.700000	1.000000	57
i1	24.396	3.4500000477	65.454545	1	9900.000000	0.700000	1.700000	1.000000	55
i1	24.3816	3.4500000477	67.924528	1	9540.000000	0.700000	1.700000	1.000000	53
i1	24.3672	3.4500000477	70.588235	1	9180.000000	0.700000	1.700000	1.000000	51
i1	24.3528	3.4500000477	73.469388	1	8820.000000	0.700000	1.700000	1.000000	49
i1	24.3384	3.4500000477	76.595745	1	8460.000000	0.700000	1.700000	1.000000	47
i1	24.324	3.4500000477	80.000000	1	8100.000000	0.700000	1.700000	1.000000	45
i1	24.3096	3.4500000477	83.720930	1	7740.000000	0.700000	1.700000	1.000000	43
i1	24.2952	3.4500000477	87.804878	1	7380.000000	0.700000	1.700000	1.000000	41
i1	24.2808	3.4500000477	92.307692	1	7020.000000	0.700000	1.700000	1.000000	39
i1	24.2664	3.4500000477	97.297297	1	6660.000000	0.700000	1.700000	1.000000	37
i1	24.252	3.4500000477	102.857143	1	6300.000000	0.700000	1.700000	1.000000	35
i1	24.2376	3.4500000477	109.090909	1	5940.000000	0.700000	1.700000	1.000000	33
i1	24.2232	3.4500000477	116.129032	1	5580.000000	0.700000	1.700000	1.000000	31
i1	24.2088	3.4500000477	124.137931	1	5220.000000	0.700000	1.700000	1.000000	29
i1	24.1944	3.4500000477	133.333333	1	4860.000000	0.700000	1.700000	1.000000	27
i1	24.18	3.4500000477	144.000000	1	4500.000000	0.700000	1.700000	1.000000	25
i1	24.1656	3.4500000477	156.521739	1	4140.000000	0.700000	1.700000	1.000000	23
i1	24.1512	3.4500000477	171.428571	1	3780.000000	0.700000	1.700000	1.000000	21
i1	24.1368	3.4500000477	189.473684	1	3420.000000	0.700000	1.700000	1.000000	19
i1	24.1224	3.4500000477	211.764706	1	3060.000000	0.700000	1.700000	1.000000	17
i1	24.108	3.4500000477	240.000000	1	2700.000000	0.700000	1.700000	1.000000	15
i1	24.0936	3.4500000477	276.923077	1	2340.000000	0.700000	1.700000	1.000000	13
i1	24.0792	3.4500000477	327.272727	1	1980.000000	0.700000	1.700000	1.000000	11
i1	24.0648	3.4500000477	400.000000	1	1620.000000	0.700000	1.700000	1.000000	9
i1	24.0216	3.4500000477	1200.000000	1	540.000000	0.700000	1.700000	1.000000	3
i1	24.0144	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	24.0288	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	24.0576	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	24.072	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	24.0864	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	24.1008	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	24.1152	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	24.1296	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	24.144	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	24.1584	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	24.1728	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	24.1872	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	24.2016	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	24.216	3.4500000477	120.000000	1	5400.000000	0.700000	1.700000	1.000000	30
i1	24.2304	3.4500000477	112.500000	1	5760.000000	0.700000	1.700000	1.000000	32
i1	24.2448	3.4500000477	105.882353	1	6120.000000	0.700000	1.700000	1.000000	34
i1	24.2592	3.4500000477	100.000000	1	6480.000000	0.700000	1.700000	1.000000	36
i1	24.2736	3.4500000477	94.736842	1	6840.000000	0.700000	1.700000	1.000000	38
i1	24.288	3.4500000477	90.000000	1	7200.000000	0.700000	1.700000	1.000000	40
i1	24.3024	3.4500000477	85.714286	1	7560.000000	0.700000	1.700000	1.000000	42
i1	24.3168	3.4500000477	81.818182	1	7920.000000	0.700000	1.700000	1.000000	44
i1	24.3312	3.4500000477	78.260870	1	8280.000000	0.700000	1.700000	1.000000	46
i1	24.3456	3.4500000477	75.000000	1	8640.000000	0.700000	1.700000	1.000000	48
i1	24.36	3.4500000477	72.000000	1	9000.000000	0.700000	1.700000	1.000000	50
i1	24.3744	3.4500000477	69.230769	1	9360.000000	0.700000	1.700000	1.000000	52
i1	24.3888	3.4500000477	66.666667	1	9720.000000	0.700000	1.700000	1.000000	54
i1	24.4032	3.4500000477	64.285714	1	10080.000000	0.700000	1.700000	1.000000	56
i1	24.4176	3.4500000477	62.068966	1	10440.000000	0.700000	1.700000	1.000000	58
i1	24.432	3.4500000477	60.000000	1	10800.000000	0.700000	1.700000	1.000000	60
i1	24.4464	3.4500000477	58.064516	1	11160.000000	0.700000	1.700000	1.000000	62
i1	24.4608	3.4500000477	56.250000	1	11520.000000	0.700000	1.700000	1.000000	64
i1	24.4752	3.4500000477	54.545455	1	11880.000000	0.700000	1.700000	1.000000	66
i1	27.0567	3.4500000477	514.285714	1	1260.000000	0.700000	1.700000	1.000000	7
i1	27.0081	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	27.0162	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	27.0486	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	27.0648	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	30.603	3.4500000477	53.731343	1	12060.000000	0.700000	1.700000	1.000000	67
i1	30.585	3.4500000477	55.384615	1	11700.000000	0.700000	1.700000	1.000000	65
i1	30.567	3.4500000477	57.142857	1	11340.000000	0.700000	1.700000	1.000000	63
i1	30.549	3.4500000477	59.016393	1	10980.000000	0.700000	1.700000	1.000000	61
i1	30.531	3.4500000477	61.016949	1	10620.000000	0.700000	1.700000	1.000000	59
i1	30.513	3.4500000477	63.157895	1	10260.000000	0.700000	1.700000	1.000000	57
i1	30.495	3.4500000477	65.454545	1	9900.000000	0.700000	1.700000	1.000000	55
i1	30.477	3.4500000477	67.924528	1	9540.000000	0.700000	1.700000	1.000000	53
i1	30.459	3.4500000477	70.588235	1	9180.000000	0.700000	1.700000	1.000000	51
i1	30.441	3.4500000477	73.469388	1	8820.000000	0.700000	1.700000	1.000000	49
i1	30.423	3.4500000477	76.595745	1	8460.000000	0.700000	1.700000	1.000000	47
i1	30.405	3.4500000477	80.000000	1	8100.000000	0.700000	1.700000	1.000000	45
i1	30.387	3.4500000477	83.720930	1	7740.000000	0.700000	1.700000	1.000000	43
i1	30.369	3.4500000477	87.804878	1	7380.000000	0.700000	1.700000	1.000000	41
i1	30.351	3.4500000477	92.307692	1	7020.000000	0.700000	1.700000	1.000000	39
i1	30.333	3.4500000477	97.297297	1	6660.000000	0.700000	1.700000	1.000000	37
i1	30.315	3.4500000477	102.857143	1	6300.000000	0.700000	1.700000	1.000000	35
i1	30.297	3.4500000477	109.090909	1	5940.000000	0.700000	1.700000	1.000000	33
i1	30.279	3.4500000477	116.129032	1	5580.000000	0.700000	1.700000	1.000000	31
i1	30.261	3.4500000477	124.137931	1	5220.000000	0.700000	1.700000	1.000000	29
i1	30.243	3.4500000477	133.333333	1	4860.000000	0.700000	1.700000	1.000000	27
i1	30.225	3.4500000477	144.000000	1	4500.000000	0.700000	1.700000	1.000000	25
i1	30.207	3.4500000477	156.521739	1	4140.000000	0.700000	1.700000	1.000000	23
i1	30.189	3.4500000477	171.428571	1	3780.000000	0.700000	1.700000	1.000000	21
i1	30.171	3.4500000477	189.473684	1	3420.000000	0.700000	1.700000	1.000000	19
i1	30.153	3.4500000477	211.764706	1	3060.000000	0.700000	1.700000	1.000000	17
i1	30.135	3.4500000477	240.000000	1	2700.000000	0.700000	1.700000	1.000000	15
i1	30.117	3.4500000477	276.923077	1	2340.000000	0.700000	1.700000	1.000000	13
i1	30.099	3.4500000477	327.272727	1	1980.000000	0.700000	1.700000	1.000000	11
i1	30.045	3.4500000477	720.000000	1	900.000000	0.700000	1.700000	1.000000	5
i1	30.009	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	30.036	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	30.054	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	30.09	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	30.108	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	30.126	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	30.144	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	30.162	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	30.18	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	30.198	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	30.216	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	30.234	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	30.252	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	30.27	3.4500000477	120.000000	1	5400.000000	0.700000	1.700000	1.000000	30
i1	30.288	3.4500000477	112.500000	1	5760.000000	0.700000	1.700000	1.000000	32
i1	30.306	3.4500000477	105.882353	1	6120.000000	0.700000	1.700000	1.000000	34
i1	30.324	3.4500000477	100.000000	1	6480.000000	0.700000	1.700000	1.000000	36
i1	30.342	3.4500000477	94.736842	1	6840.000000	0.700000	1.700000	1.000000	38
i1	30.36	3.4500000477	90.000000	1	7200.000000	0.700000	1.700000	1.000000	40
i1	30.378	3.4500000477	85.714286	1	7560.000000	0.700000	1.700000	1.000000	42
i1	30.396	3.4500000477	81.818182	1	7920.000000	0.700000	1.700000	1.000000	44
i1	30.414	3.4500000477	78.260870	1	8280.000000	0.700000	1.700000	1.000000	46
i1	30.432	3.4500000477	75.000000	1	8640.000000	0.700000	1.700000	1.000000	48
i1	30.45	3.4500000477	72.000000	1	9000.000000	0.700000	1.700000	1.000000	50
i1	30.468	3.4500000477	69.230769	1	9360.000000	0.700000	1.700000	1.000000	52
i1	30.486	3.4500000477	66.666667	1	9720.000000	0.700000	1.700000	1.000000	54
i1	30.504	3.4500000477	64.285714	1	10080.000000	0.700000	1.700000	1.000000	56
i1	30.522	3.4500000477	62.068966	1	10440.000000	0.700000	1.700000	1.000000	58
i1	30.54	3.4500000477	60.000000	1	10800.000000	0.700000	1.700000	1.000000	60
i1	30.558	3.4500000477	58.064516	1	11160.000000	0.700000	1.700000	1.000000	62
i1	30.576	3.4500000477	56.250000	1	11520.000000	0.700000	1.700000	1.000000	64
i1	30.594	3.4500000477	54.545455	1	11880.000000	0.700000	1.700000	1.000000	66
i1	33.0891	3.4500000477	400.000000	1	1620.000000	0.700000	1.700000	1.000000	9
i1	33.0297	3.4500000477	1200.000000	1	540.000000	0.700000	1.700000	1.000000	3
i1	33.0198	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	33.0396	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	33.0792	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	33.099	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	36.7236	3.4500000477	53.731343	1	12060.000000	0.700000	1.700000	1.000000	67
i1	36.702	3.4500000477	55.384615	1	11700.000000	0.700000	1.700000	1.000000	65
i1	36.6804	3.4500000477	57.142857	1	11340.000000	0.700000	1.700000	1.000000	63
i1	36.6588	3.4500000477	59.016393	1	10980.000000	0.700000	1.700000	1.000000	61
i1	36.6372	3.4500000477	61.016949	1	10620.000000	0.700000	1.700000	1.000000	59
i1	36.6156	3.4500000477	63.157895	1	10260.000000	0.700000	1.700000	1.000000	57
i1	36.594	3.4500000477	65.454545	1	9900.000000	0.700000	1.700000	1.000000	55
i1	36.5724	3.4500000477	67.924528	1	9540.000000	0.700000	1.700000	1.000000	53
i1	36.5508	3.4500000477	70.588235	1	9180.000000	0.700000	1.700000	1.000000	51
i1	36.5292	3.4500000477	73.469388	1	8820.000000	0.700000	1.700000	1.000000	49
i1	36.5076	3.4500000477	76.595745	1	8460.000000	0.700000	1.700000	1.000000	47
i1	36.486	3.4500000477	80.000000	1	8100.000000	0.700000	1.700000	1.000000	45
i1	36.4644	3.4500000477	83.720930	1	7740.000000	0.700000	1.700000	1.000000	43
i1	36.4428	3.4500000477	87.804878	1	7380.000000	0.700000	1.700000	1.000000	41
i1	36.4212	3.4500000477	92.307692	1	7020.000000	0.700000	1.700000	1.000000	39
i1	36.3996	3.4500000477	97.297297	1	6660.000000	0.700000	1.700000	1.000000	37
i1	36.378	3.4500000477	102.857143	1	6300.000000	0.700000	1.700000	1.000000	35
i1	36.3564	3.4500000477	109.090909	1	5940.000000	0.700000	1.700000	1.000000	33
i1	36.3348	3.4500000477	116.129032	1	5580.000000	0.700000	1.700000	1.000000	31
i1	36.3132	3.4500000477	124.137931	1	5220.000000	0.700000	1.700000	1.000000	29
i1	36.2916	3.4500000477	133.333333	1	4860.000000	0.700000	1.700000	1.000000	27
i1	36.27	3.4500000477	144.000000	1	4500.000000	0.700000	1.700000	1.000000	25
i1	36.2484	3.4500000477	156.521739	1	4140.000000	0.700000	1.700000	1.000000	23
i1	36.2268	3.4500000477	171.428571	1	3780.000000	0.700000	1.700000	1.000000	21
i1	36.2052	3.4500000477	189.473684	1	3420.000000	0.700000	1.700000	1.000000	19
i1	36.1836	3.4500000477	211.764706	1	3060.000000	0.700000	1.700000	1.000000	17
i1	36.162	3.4500000477	240.000000	1	2700.000000	0.700000	1.700000	1.000000	15
i1	36.1404	3.4500000477	276.923077	1	2340.000000	0.700000	1.700000	1.000000	13
i1	36.0756	3.4500000477	514.285714	1	1260.000000	0.700000	1.700000	1.000000	7
i1	36.0108	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	36.0216	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	36.0648	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	36.0864	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	36.1296	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	36.1512	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	36.1728	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	36.1944	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	36.216	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	36.2376	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	36.2592	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	36.2808	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	36.3024	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	36.324	3.4500000477	120.000000	1	5400.000000	0.700000	1.700000	1.000000	30
i1	36.3456	3.4500000477	112.500000	1	5760.000000	0.700000	1.700000	1.000000	32
i1	36.3672	3.4500000477	105.882353	1	6120.000000	0.700000	1.700000	1.000000	34
i1	36.3888	3.4500000477	100.000000	1	6480.000000	0.700000	1.700000	1.000000	36
i1	36.4104	3.4500000477	94.736842	1	6840.000000	0.700000	1.700000	1.000000	38
i1	36.432	3.4500000477	90.000000	1	7200.000000	0.700000	1.700000	1.000000	40
i1	36.4536	3.4500000477	85.714286	1	7560.000000	0.700000	1.700000	1.000000	42
i1	36.4752	3.4500000477	81.818182	1	7920.000000	0.700000	1.700000	1.000000	44
i1	36.4968	3.4500000477	78.260870	1	8280.000000	0.700000	1.700000	1.000000	46
i1	36.5184	3.4500000477	75.000000	1	8640.000000	0.700000	1.700000	1.000000	48
i1	36.54	3.4500000477	72.000000	1	9000.000000	0.700000	1.700000	1.000000	50
i1	36.5616	3.4500000477	69.230769	1	9360.000000	0.700000	1.700000	1.000000	52
i1	36.5832	3.4500000477	66.666667	1	9720.000000	0.700000	1.700000	1.000000	54
i1	36.6048	3.4500000477	64.285714	1	10080.000000	0.700000	1.700000	1.000000	56
i1	36.6264	3.4500000477	62.068966	1	10440.000000	0.700000	1.700000	1.000000	58
i1	36.648	3.4500000477	60.000000	1	10800.000000	0.700000	1.700000	1.000000	60
i1	36.6696	3.4500000477	58.064516	1	11160.000000	0.700000	1.700000	1.000000	62
i1	36.6912	3.4500000477	56.250000	1	11520.000000	0.700000	1.700000	1.000000	64
i1	36.7128	3.4500000477	54.545455	1	11880.000000	0.700000	1.700000	1.000000	66
i1	39.1287	3.4500000477	327.272727	1	1980.000000	0.700000	1.700000	1.000000	11
i1	39.0585	3.4500000477	720.000000	1	900.000000	0.700000	1.700000	1.000000	5
i1	39.0117	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	39.0468	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	39.0702	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	39.117	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	39.1404	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	42.8442	3.4500000477	53.731343	1	12060.000000	0.700000	1.700000	1.000000	67
i1	42.819	3.4500000477	55.384615	1	11700.000000	0.700000	1.700000	1.000000	65
i1	42.7938	3.4500000477	57.142857	1	11340.000000	0.700000	1.700000	1.000000	63
i1	42.7686	3.4500000477	59.016393	1	10980.000000	0.700000	1.700000	1.000000	61
i1	42.7434	3.4500000477	61.016949	1	10620.000000	0.700000	1.700000	1.000000	59
i1	42.7182	3.4500000477	63.157895	1	10260.000000	0.700000	1.700000	1.000000	57
i1	42.693	3.4500000477	65.454545	1	9900.000000	0.700000	1.700000	1.000000	55
i1	42.6678	3.4500000477	67.924528	1	9540.000000	0.700000	1.700000	1.000000	53
i1	42.6426	3.4500000477	70.588235	1	9180.000000	0.700000	1.700000	1.000000	51
i1	42.6174	3.4500000477	73.469388	1	8820.000000	0.700000	1.700000	1.000000	49
i1	42.5922	3.4500000477	76.595745	1	8460.000000	0.700000	1.700000	1.000000	47
i1	42.567	3.4500000477	80.000000	1	8100.000000	0.700000	1.700000	1.000000	45
i1	42.5418	3.4500000477	83.720930	1	7740.000000	0.700000	1.700000	1.000000	43
i1	42.5166	3.4500000477	87.804878	1	7380.000000	0.700000	1.700000	1.000000	41
i1	42.4914	3.4500000477	92.307692	1	7020.000000	0.700000	1.700000	1.000000	39
i1	42.4662	3.4500000477	97.297297	1	6660.000000	0.700000	1.700000	1.000000	37
i1	42.441	3.4500000477	102.857143	1	6300.000000	0.700000	1.700000	1.000000	35
i1	42.4158	3.4500000477	109.090909	1	5940.000000	0.700000	1.700000	1.000000	33
i1	42.3906	3.4500000477	116.129032	1	5580.000000	0.700000	1.700000	1.000000	31
i1	42.3654	3.4500000477	124.137931	1	5220.000000	0.700000	1.700000	1.000000	29
i1	42.3402	3.4500000477	133.333333	1	4860.000000	0.700000	1.700000	1.000000	27
i1	42.315	3.4500000477	144.000000	1	4500.000000	0.700000	1.700000	1.000000	25
i1	42.2898	3.4500000477	156.521739	1	4140.000000	0.700000	1.700000	1.000000	23
i1	42.2646	3.4500000477	171.428571	1	3780.000000	0.700000	1.700000	1.000000	21
i1	42.2394	3.4500000477	189.473684	1	3420.000000	0.700000	1.700000	1.000000	19
i1	42.2142	3.4500000477	211.764706	1	3060.000000	0.700000	1.700000	1.000000	17
i1	42.189	3.4500000477	240.000000	1	2700.000000	0.700000	1.700000	1.000000	15
i1	42.1134	3.4500000477	400.000000	1	1620.000000	0.700000	1.700000	1.000000	9
i1	42.0378	3.4500000477	1200.000000	1	540.000000	0.700000	1.700000	1.000000	3
i1	42.0252	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	42.0504	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	42.1008	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	42.126	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	42.1764	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	42.2016	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	42.2268	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	42.252	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	42.2772	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	42.3024	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	42.3276	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	42.3528	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	42.378	3.4500000477	120.000000	1	5400.000000	0.700000	1.700000	1.000000	30
i1	42.4032	3.4500000477	112.500000	1	5760.000000	0.700000	1.700000	1.000000	32
i1	42.4284	3.4500000477	105.882353	1	6120.000000	0.700000	1.700000	1.000000	34
i1	42.4536	3.4500000477	100.000000	1	6480.000000	0.700000	1.700000	1.000000	36
i1	42.4788	3.4500000477	94.736842	1	6840.000000	0.700000	1.700000	1.000000	38
i1	42.504	3.4500000477	90.000000	1	7200.000000	0.700000	1.700000	1.000000	40
i1	42.5292	3.4500000477	85.714286	1	7560.000000	0.700000	1.700000	1.000000	42
i1	42.5544	3.4500000477	81.818182	1	7920.000000	0.700000	1.700000	1.000000	44
i1	42.5796	3.4500000477	78.260870	1	8280.000000	0.700000	1.700000	1.000000	46
i1	42.6048	3.4500000477	75.000000	1	8640.000000	0.700000	1.700000	1.000000	48
i1	42.63	3.4500000477	72.000000	1	9000.000000	0.700000	1.700000	1.000000	50
i1	42.6552	3.4500000477	69.230769	1	9360.000000	0.700000	1.700000	1.000000	52
i1	42.6804	3.4500000477	66.666667	1	9720.000000	0.700000	1.700000	1.000000	54
i1	42.7056	3.4500000477	64.285714	1	10080.000000	0.700000	1.700000	1.000000	56
i1	42.7308	3.4500000477	62.068966	1	10440.000000	0.700000	1.700000	1.000000	58
i1	42.756	3.4500000477	60.000000	1	10800.000000	0.700000	1.700000	1.000000	60
i1	42.7812	3.4500000477	58.064516	1	11160.000000	0.700000	1.700000	1.000000	62
i1	42.8064	3.4500000477	56.250000	1	11520.000000	0.700000	1.700000	1.000000	64
i1	42.8316	3.4500000477	54.545455	1	11880.000000	0.700000	1.700000	1.000000	66
i1	45.1755	3.4500000477	276.923077	1	2340.000000	0.700000	1.700000	1.000000	13
i1	45.0945	3.4500000477	514.285714	1	1260.000000	0.700000	1.700000	1.000000	7
i1	45.0135	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	45.027	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	45.081	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	45.108	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	45.162	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	45.189	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	48.9648	3.4500000477	53.731343	1	12060.000000	0.700000	1.700000	1.000000	67
i1	48.936	3.4500000477	55.384615	1	11700.000000	0.700000	1.700000	1.000000	65
i1	48.9072	3.4500000477	57.142857	1	11340.000000	0.700000	1.700000	1.000000	63
i1	48.8784	3.4500000477	59.016393	1	10980.000000	0.700000	1.700000	1.000000	61
i1	48.8496	3.4500000477	61.016949	1	10620.000000	0.700000	1.700000	1.000000	59
i1	48.8208	3.4500000477	63.157895	1	10260.000000	0.700000	1.700000	1.000000	57
i1	48.792	3.4500000477	65.454545	1	9900.000000	0.700000	1.700000	1.000000	55
i1	48.7632	3.4500000477	67.924528	1	9540.000000	0.700000	1.700000	1.000000	53
i1	48.7344	3.4500000477	70.588235	1	9180.000000	0.700000	1.700000	1.000000	51
i1	48.7056	3.4500000477	73.469388	1	8820.000000	0.700000	1.700000	1.000000	49
i1	48.6768	3.4500000477	76.595745	1	8460.000000	0.700000	1.700000	1.000000	47
i1	48.648	3.4500000477	80.000000	1	8100.000000	0.700000	1.700000	1.000000	45
i1	48.6192	3.4500000477	83.720930	1	7740.000000	0.700000	1.700000	1.000000	43
i1	48.5904	3.4500000477	87.804878	1	7380.000000	0.700000	1.700000	1.000000	41
i1	48.5616	3.4500000477	92.307692	1	7020.000000	0.700000	1.700000	1.000000	39
i1	48.5328	3.4500000477	97.297297	1	6660.000000	0.700000	1.700000	1.000000	37
i1	48.504	3.4500000477	102.857143	1	6300.000000	0.700000	1.700000	1.000000	35
i1	48.4752	3.4500000477	109.090909	1	5940.000000	0.700000	1.700000	1.000000	33
i1	48.4464	3.4500000477	116.129032	1	5580.000000	0.700000	1.700000	1.000000	31
i1	48.4176	3.4500000477	124.137931	1	5220.000000	0.700000	1.700000	1.000000	29
i1	48.3888	3.4500000477	133.333333	1	4860.000000	0.700000	1.700000	1.000000	27
i1	48.36	3.4500000477	144.000000	1	4500.000000	0.700000	1.700000	1.000000	25
i1	48.3312	3.4500000477	156.521739	1	4140.000000	0.700000	1.700000	1.000000	23
i1	48.3024	3.4500000477	171.428571	1	3780.000000	0.700000	1.700000	1.000000	21
i1	48.2736	3.4500000477	189.473684	1	3420.000000	0.700000	1.700000	1.000000	19
i1	48.2448	3.4500000477	211.764706	1	3060.000000	0.700000	1.700000	1.000000	17
i1	48.1584	3.4500000477	327.272727	1	1980.000000	0.700000	1.700000	1.000000	11
i1	48.072	3.4500000477	720.000000	1	900.000000	0.700000	1.700000	1.000000	5
i1	48.0144	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	48.0576	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	48.0864	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	48.144	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	48.1728	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	48.2304	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	48.2592	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	48.288	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	48.3168	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	48.3456	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	48.3744	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	48.4032	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	48.432	3.4500000477	120.000000	1	5400.000000	0.700000	1.700000	1.000000	30
i1	48.4608	3.4500000477	112.500000	1	5760.000000	0.700000	1.700000	1.000000	32
i1	48.4896	3.4500000477	105.882353	1	6120.000000	0.700000	1.700000	1.000000	34
i1	48.5184	3.4500000477	100.000000	1	6480.000000	0.700000	1.700000	1.000000	36
i1	48.5472	3.4500000477	94.736842	1	6840.000000	0.700000	1.700000	1.000000	38
i1	48.576	3.4500000477	90.000000	1	7200.000000	0.700000	1.700000	1.000000	40
i1	48.6048	3.4500000477	85.714286	1	7560.000000	0.700000	1.700000	1.000000	42
i1	48.6336	3.4500000477	81.818182	1	7920.000000	0.700000	1.700000	1.000000	44
i1	48.6624	3.4500000477	78.260870	1	8280.000000	0.700000	1.700000	1.000000	46
i1	48.6912	3.4500000477	75.000000	1	8640.000000	0.700000	1.700000	1.000000	48
i1	48.72	3.4500000477	72.000000	1	9000.000000	0.700000	1.700000	1.000000	50
i1	48.7488	3.4500000477	69.230769	1	9360.000000	0.700000	1.700000	1.000000	52
i1	48.7776	3.4500000477	66.666667	1	9720.000000	0.700000	1.700000	1.000000	54
i1	48.8064	3.4500000477	64.285714	1	10080.000000	0.700000	1.700000	1.000000	56
i1	48.8352	3.4500000477	62.068966	1	10440.000000	0.700000	1.700000	1.000000	58
i1	48.864	3.4500000477	60.000000	1	10800.000000	0.700000	1.700000	1.000000	60
i1	48.8928	3.4500000477	58.064516	1	11160.000000	0.700000	1.700000	1.000000	62
i1	48.9216	3.4500000477	56.250000	1	11520.000000	0.700000	1.700000	1.000000	64
i1	48.9504	3.4500000477	54.545455	1	11880.000000	0.700000	1.700000	1.000000	66
i1	51.2295	3.4500000477	240.000000	1	2700.000000	0.700000	1.700000	1.000000	15
i1	51.1377	3.4500000477	400.000000	1	1620.000000	0.700000	1.700000	1.000000	9
i1	51.0459	3.4500000477	1200.000000	1	540.000000	0.700000	1.700000	1.000000	3
i1	51.0306	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	51.0612	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	51.1224	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	51.153	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	51.2142	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	51.2448	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	55.0854	3.4500000477	53.731343	1	12060.000000	0.700000	1.700000	1.000000	67
i1	55.053	3.4500000477	55.384615	1	11700.000000	0.700000	1.700000	1.000000	65
i1	55.0206	3.4500000477	57.142857	1	11340.000000	0.700000	1.700000	1.000000	63
i1	54.9882	3.4500000477	59.016393	1	10980.000000	0.700000	1.700000	1.000000	61
i1	54.9558	3.4500000477	61.016949	1	10620.000000	0.700000	1.700000	1.000000	59
i1	54.9234	3.4500000477	63.157895	1	10260.000000	0.700000	1.700000	1.000000	57
i1	54.891	3.4500000477	65.454545	1	9900.000000	0.700000	1.700000	1.000000	55
i1	54.8586	3.4500000477	67.924528	1	9540.000000	0.700000	1.700000	1.000000	53
i1	54.8262	3.4500000477	70.588235	1	9180.000000	0.700000	1.700000	1.000000	51
i1	54.7938	3.4500000477	73.469388	1	8820.000000	0.700000	1.700000	1.000000	49
i1	54.7614	3.4500000477	76.595745	1	8460.000000	0.700000	1.700000	1.000000	47
i1	54.729	3.4500000477	80.000000	1	8100.000000	0.700000	1.700000	1.000000	45
i1	54.6966	3.4500000477	83.720930	1	7740.000000	0.700000	1.700000	1.000000	43
i1	54.6642	3.4500000477	87.804878	1	7380.000000	0.700000	1.700000	1.000000	41
i1	54.6318	3.4500000477	92.307692	1	7020.000000	0.700000	1.700000	1.000000	39
i1	54.5994	3.4500000477	97.297297	1	6660.000000	0.700000	1.700000	1.000000	37
i1	54.567	3.4500000477	102.857143	1	6300.000000	0.700000	1.700000	1.000000	35
i1	54.5346	3.4500000477	109.090909	1	5940.000000	0.700000	1.700000	1.000000	33
i1	54.5022	3.4500000477	116.129032	1	5580.000000	0.700000	1.700000	1.000000	31
i1	54.4698	3.4500000477	124.137931	1	5220.000000	0.700000	1.700000	1.000000	29
i1	54.4374	3.4500000477	133.333333	1	4860.000000	0.700000	1.700000	1.000000	27
i1	54.405	3.4500000477	144.000000	1	4500.000000	0.700000	1.700000	1.000000	25
i1	54.3726	3.4500000477	156.521739	1	4140.000000	0.700000	1.700000	1.000000	23
i1	54.3402	3.4500000477	171.428571	1	3780.000000	0.700000	1.700000	1.000000	21
i1	54.3078	3.4500000477	189.473684	1	3420.000000	0.700000	1.700000	1.000000	19
i1	54.2106	3.4500000477	276.923077	1	2340.000000	0.700000	1.700000	1.000000	13
i1	54.1134	3.4500000477	514.285714	1	1260.000000	0.700000	1.700000	1.000000	7
i1	54.0162	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	54.0324	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	54.0972	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	54.1296	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	54.1944	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	54.2268	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	54.2916	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	54.324	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	54.3564	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	54.3888	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	54.4212	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	54.4536	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	54.486	3.4500000477	120.000000	1	5400.000000	0.700000	1.700000	1.000000	30
i1	54.5184	3.4500000477	112.500000	1	5760.000000	0.700000	1.700000	1.000000	32
i1	54.5508	3.4500000477	105.882353	1	6120.000000	0.700000	1.700000	1.000000	34
i1	54.5832	3.4500000477	100.000000	1	6480.000000	0.700000	1.700000	1.000000	36
i1	54.6156	3.4500000477	94.736842	1	6840.000000	0.700000	1.700000	1.000000	38
i1	54.648	3.4500000477	90.000000	1	7200.000000	0.700000	1.700000	1.000000	40
i1	54.6804	3.4500000477	85.714286	1	7560.000000	0.700000	1.700000	1.000000	42
i1	54.7128	3.4500000477	81.818182	1	7920.000000	0.700000	1.700000	1.000000	44
i1	54.7452	3.4500000477	78.260870	1	8280.000000	0.700000	1.700000	1.000000	46
i1	54.7776	3.4500000477	75.000000	1	8640.000000	0.700000	1.700000	1.000000	48
i1	54.81	3.4500000477	72.000000	1	9000.000000	0.700000	1.700000	1.000000	50
i1	54.8424	3.4500000477	69.230769	1	9360.000000	0.700000	1.700000	1.000000	52
i1	54.8748	3.4500000477	66.666667	1	9720.000000	0.700000	1.700000	1.000000	54
i1	54.9072	3.4500000477	64.285714	1	10080.000000	0.700000	1.700000	1.000000	56
i1	54.9396	3.4500000477	62.068966	1	10440.000000	0.700000	1.700000	1.000000	58
i1	54.972	3.4500000477	60.000000	1	10800.000000	0.700000	1.700000	1.000000	60
i1	55.0044	3.4500000477	58.064516	1	11160.000000	0.700000	1.700000	1.000000	62
i1	55.0368	3.4500000477	56.250000	1	11520.000000	0.700000	1.700000	1.000000	64
i1	55.0692	3.4500000477	54.545455	1	11880.000000	0.700000	1.700000	1.000000	66
i1	57.2907	3.4500000477	211.764706	1	3060.000000	0.700000	1.700000	1.000000	17
i1	57.1881	3.4500000477	327.272727	1	1980.000000	0.700000	1.700000	1.000000	11
i1	57.0855	3.4500000477	720.000000	1	900.000000	0.700000	1.700000	1.000000	5
i1	57.0171	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	57.0684	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	57.1026	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	57.171	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	57.2052	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	57.2736	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	57.3078	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	61.206	3.4500000477	53.731343	1	12060.000000	0.700000	1.700000	1.000000	67
i1	61.17	3.4500000477	55.384615	1	11700.000000	0.700000	1.700000	1.000000	65
i1	61.134	3.4500000477	57.142857	1	11340.000000	0.700000	1.700000	1.000000	63
i1	61.098	3.4500000477	59.016393	1	10980.000000	0.700000	1.700000	1.000000	61
i1	61.062	3.4500000477	61.016949	1	10620.000000	0.700000	1.700000	1.000000	59
i1	61.026	3.4500000477	63.157895	1	10260.000000	0.700000	1.700000	1.000000	57
i1	60.99	3.4500000477	65.454545	1	9900.000000	0.700000	1.700000	1.000000	55
i1	60.954	3.4500000477	67.924528	1	9540.000000	0.700000	1.700000	1.000000	53
i1	60.918	3.4500000477	70.588235	1	9180.000000	0.700000	1.700000	1.000000	51
i1	60.882	3.4500000477	73.469388	1	8820.000000	0.700000	1.700000	1.000000	49
i1	60.846	3.4500000477	76.595745	1	8460.000000	0.700000	1.700000	1.000000	47
i1	60.81	3.4500000477	80.000000	1	8100.000000	0.700000	1.700000	1.000000	45
i1	60.774	3.4500000477	83.720930	1	7740.000000	0.700000	1.700000	1.000000	43
i1	60.738	3.4500000477	87.804878	1	7380.000000	0.700000	1.700000	1.000000	41
i1	60.702	3.4500000477	92.307692	1	7020.000000	0.700000	1.700000	1.000000	39
i1	60.666	3.4500000477	97.297297	1	6660.000000	0.700000	1.700000	1.000000	37
i1	60.63	3.4500000477	102.857143	1	6300.000000	0.700000	1.700000	1.000000	35
i1	60.594	3.4500000477	109.090909	1	5940.000000	0.700000	1.700000	1.000000	33
i1	60.558	3.4500000477	116.129032	1	5580.000000	0.700000	1.700000	1.000000	31
i1	60.522	3.4500000477	124.137931	1	5220.000000	0.700000	1.700000	1.000000	29
i1	60.486	3.4500000477	133.333333	1	4860.000000	0.700000	1.700000	1.000000	27
i1	60.45	3.4500000477	144.000000	1	4500.000000	0.700000	1.700000	1.000000	25
i1	60.414	3.4500000477	156.521739	1	4140.000000	0.700000	1.700000	1.000000	23
i1	60.378	3.4500000477	171.428571	1	3780.000000	0.700000	1.700000	1.000000	21
i1	60.27	3.4500000477	240.000000	1	2700.000000	0.700000	1.700000	1.000000	15
i1	60.162	3.4500000477	400.000000	1	1620.000000	0.700000	1.700000	1.000000	9
i1	60.054	3.4500000477	1200.000000	1	540.000000	0.700000	1.700000	1.000000	3
i1	60.036	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	60.072	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	60.144	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	60.18	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	60.252	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	60.288	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	60.36	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	60.396	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	60.432	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	60.468	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	60.504	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	60.54	3.4500000477	120.000000	1	5400.000000	0.700000	1.700000	1.000000	30
i1	60.576	3.4500000477	112.500000	1	5760.000000	0.700000	1.700000	1.000000	32
i1	60.612	3.4500000477	105.882353	1	6120.000000	0.700000	1.700000	1.000000	34
i1	60.648	3.4500000477	100.000000	1	6480.000000	0.700000	1.700000	1.000000	36
i1	60.684	3.4500000477	94.736842	1	6840.000000	0.700000	1.700000	1.000000	38
i1	60.72	3.4500000477	90.000000	1	7200.000000	0.700000	1.700000	1.000000	40
i1	60.756	3.4500000477	85.714286	1	7560.000000	0.700000	1.700000	1.000000	42
i1	60.792	3.4500000477	81.818182	1	7920.000000	0.700000	1.700000	1.000000	44
i1	60.828	3.4500000477	78.260870	1	8280.000000	0.700000	1.700000	1.000000	46
i1	60.864	3.4500000477	75.000000	1	8640.000000	0.700000	1.700000	1.000000	48
i1	60.9	3.4500000477	72.000000	1	9000.000000	0.700000	1.700000	1.000000	50
i1	60.936	3.4500000477	69.230769	1	9360.000000	0.700000	1.700000	1.000000	52
i1	60.972	3.4500000477	66.666667	1	9720.000000	0.700000	1.700000	1.000000	54
i1	61.008	3.4500000477	64.285714	1	10080.000000	0.700000	1.700000	1.000000	56
i1	61.044	3.4500000477	62.068966	1	10440.000000	0.700000	1.700000	1.000000	58
i1	61.08	3.4500000477	60.000000	1	10800.000000	0.700000	1.700000	1.000000	60
i1	61.116	3.4500000477	58.064516	1	11160.000000	0.700000	1.700000	1.000000	62
i1	61.152	3.4500000477	56.250000	1	11520.000000	0.700000	1.700000	1.000000	64
i1	61.188	3.4500000477	54.545455	1	11880.000000	0.700000	1.700000	1.000000	66
i1	63.3591	3.4500000477	189.473684	1	3420.000000	0.700000	1.700000	1.000000	19
i1	63.2457	3.4500000477	276.923077	1	2340.000000	0.700000	1.700000	1.000000	13
i1	63.1323	3.4500000477	514.285714	1	1260.000000	0.700000	1.700000	1.000000	7
i1	63.0189	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	63.0378	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	63.1134	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	63.1512	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	63.2268	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	63.2646	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	63.3402	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	63.378	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	67.3266	3.4500000477	53.731343	1	12060.000000	0.700000	1.700000	1.000000	67
i1	67.287	3.4500000477	55.384615	1	11700.000000	0.700000	1.700000	1.000000	65
i1	67.2474	3.4500000477	57.142857	1	11340.000000	0.700000	1.700000	1.000000	63
i1	67.2078	3.4500000477	59.016393	1	10980.000000	0.700000	1.700000	1.000000	61
i1	67.1682	3.4500000477	61.016949	1	10620.000000	0.700000	1.700000	1.000000	59
i1	67.1286	3.4500000477	63.157895	1	10260.000000	0.700000	1.700000	1.000000	57
i1	67.089	3.4500000477	65.454545	1	9900.000000	0.700000	1.700000	1.000000	55
i1	67.0494	3.4500000477	67.924528	1	9540.000000	0.700000	1.700000	1.000000	53
i1	67.0098	3.4500000477	70.588235	1	9180.000000	0.700000	1.700000	1.000000	51
i1	66.9702	3.4500000477	73.469388	1	8820.000000	0.700000	1.700000	1.000000	49
i1	66.9306	3.4500000477	76.595745	1	8460.000000	0.700000	1.700000	1.000000	47
i1	66.891	3.4500000477	80.000000	1	8100.000000	0.700000	1.700000	1.000000	45
i1	66.8514	3.4500000477	83.720930	1	7740.000000	0.700000	1.700000	1.000000	43
i1	66.8118	3.4500000477	87.804878	1	7380.000000	0.700000	1.700000	1.000000	41
i1	66.7722	3.4500000477	92.307692	1	7020.000000	0.700000	1.700000	1.000000	39
i1	66.7326	3.4500000477	97.297297	1	6660.000000	0.700000	1.700000	1.000000	37
i1	66.693	3.4500000477	102.857143	1	6300.000000	0.700000	1.700000	1.000000	35
i1	66.6534	3.4500000477	109.090909	1	5940.000000	0.700000	1.700000	1.000000	33
i1	66.6138	3.4500000477	116.129032	1	5580.000000	0.700000	1.700000	1.000000	31
i1	66.5742	3.4500000477	124.137931	1	5220.000000	0.700000	1.700000	1.000000	29
i1	66.5346	3.4500000477	133.333333	1	4860.000000	0.700000	1.700000	1.000000	27
i1	66.495	3.4500000477	144.000000	1	4500.000000	0.700000	1.700000	1.000000	25
i1	66.4554	3.4500000477	156.521739	1	4140.000000	0.700000	1.700000	1.000000	23
i1	66.3366	3.4500000477	211.764706	1	3060.000000	0.700000	1.700000	1.000000	17
i1	66.2178	3.4500000477	327.272727	1	1980.000000	0.700000	1.700000	1.000000	11
i1	66.099	3.4500000477	720.000000	1	900.000000	0.700000	1.700000	1.000000	5
i1	66.0198	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	66.0792	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	66.1188	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	66.198	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	66.2376	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	66.3168	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	66.3564	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	66.4356	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	66.4752	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	66.5148	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	66.5544	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	66.594	3.4500000477	120.000000	1	5400.000000	0.700000	1.700000	1.000000	30
i1	66.6336	3.4500000477	112.500000	1	5760.000000	0.700000	1.700000	1.000000	32
i1	66.6732	3.4500000477	105.882353	1	6120.000000	0.700000	1.700000	1.000000	34
i1	66.7128	3.4500000477	100.000000	1	6480.000000	0.700000	1.700000	1.000000	36
i1	66.7524	3.4500000477	94.736842	1	6840.000000	0.700000	1.700000	1.000000	38
i1	66.792	3.4500000477	90.000000	1	7200.000000	0.700000	1.700000	1.000000	40
i1	66.8316	3.4500000477	85.714286	1	7560.000000	0.700000	1.700000	1.000000	42
i1	66.8712	3.4500000477	81.818182	1	7920.000000	0.700000	1.700000	1.000000	44
i1	66.9108	3.4500000477	78.260870	1	8280.000000	0.700000	1.700000	1.000000	46
i1	66.9504	3.4500000477	75.000000	1	8640.000000	0.700000	1.700000	1.000000	48
i1	66.99	3.4500000477	72.000000	1	9000.000000	0.700000	1.700000	1.000000	50
i1	67.0296	3.4500000477	69.230769	1	9360.000000	0.700000	1.700000	1.000000	52
i1	67.0692	3.4500000477	66.666667	1	9720.000000	0.700000	1.700000	1.000000	54
i1	67.1088	3.4500000477	64.285714	1	10080.000000	0.700000	1.700000	1.000000	56
i1	67.1484	3.4500000477	62.068966	1	10440.000000	0.700000	1.700000	1.000000	58
i1	67.188	3.4500000477	60.000000	1	10800.000000	0.700000	1.700000	1.000000	60
i1	67.2276	3.4500000477	58.064516	1	11160.000000	0.700000	1.700000	1.000000	62
i1	67.2672	3.4500000477	56.250000	1	11520.000000	0.700000	1.700000	1.000000	64
i1	67.3068	3.4500000477	54.545455	1	11880.000000	0.700000	1.700000	1.000000	66
i1	69.4347	3.4500000477	171.428571	1	3780.000000	0.700000	1.700000	1.000000	21
i1	69.3105	3.4500000477	240.000000	1	2700.000000	0.700000	1.700000	1.000000	15
i1	69.1863	3.4500000477	400.000000	1	1620.000000	0.700000	1.700000	1.000000	9
i1	69.0621	3.4500000477	1200.000000	1	540.000000	0.700000	1.700000	1.000000	3
i1	69.0414	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	69.0828	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	69.1656	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	69.207	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	69.2898	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	69.3312	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	69.414	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	69.4554	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	73.4472	3.4500000477	53.731343	1	12060.000000	0.700000	1.700000	1.000000	67
i1	73.404	3.4500000477	55.384615	1	11700.000000	0.700000	1.700000	1.000000	65
i1	73.3608	3.4500000477	57.142857	1	11340.000000	0.700000	1.700000	1.000000	63
i1	73.3176	3.4500000477	59.016393	1	10980.000000	0.700000	1.700000	1.000000	61
i1	73.2744	3.4500000477	61.016949	1	10620.000000	0.700000	1.700000	1.000000	59
i1	73.2312	3.4500000477	63.157895	1	10260.000000	0.700000	1.700000	1.000000	57
i1	73.188	3.4500000477	65.454545	1	9900.000000	0.700000	1.700000	1.000000	55
i1	73.1448	3.4500000477	67.924528	1	9540.000000	0.700000	1.700000	1.000000	53
i1	73.1016	3.4500000477	70.588235	1	9180.000000	0.700000	1.700000	1.000000	51
i1	73.0584	3.4500000477	73.469388	1	8820.000000	0.700000	1.700000	1.000000	49
i1	73.0152	3.4500000477	76.595745	1	8460.000000	0.700000	1.700000	1.000000	47
i1	72.972	3.4500000477	80.000000	1	8100.000000	0.700000	1.700000	1.000000	45
i1	72.9288	3.4500000477	83.720930	1	7740.000000	0.700000	1.700000	1.000000	43
i1	72.8856	3.4500000477	87.804878	1	7380.000000	0.700000	1.700000	1.000000	41
i1	72.8424	3.4500000477	92.307692	1	7020.000000	0.700000	1.700000	1.000000	39
i1	72.7992	3.4500000477	97.297297	1	6660.000000	0.700000	1.700000	1.000000	37
i1	72.756	3.4500000477	102.857143	1	6300.000000	0.700000	1.700000	1.000000	35
i1	72.7128	3.4500000477	109.090909	1	5940.000000	0.700000	1.700000	1.000000	33
i1	72.6696	3.4500000477	116.129032	1	5580.000000	0.700000	1.700000	1.000000	31
i1	72.6264	3.4500000477	124.137931	1	5220.000000	0.700000	1.700000	1.000000	29
i1	72.5832	3.4500000477	133.333333	1	4860.000000	0.700000	1.700000	1.000000	27
i1	72.54	3.4500000477	144.000000	1	4500.000000	0.700000	1.700000	1.000000	25
i1	72.4104	3.4500000477	189.473684	1	3420.000000	0.700000	1.700000	1.000000	19
i1	72.2808	3.4500000477	276.923077	1	2340.000000	0.700000	1.700000	1.000000	13
i1	72.1512	3.4500000477	514.285714	1	1260.000000	0.700000	1.700000	1.000000	7
i1	72.0216	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	72.0432	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	72.1296	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	72.1728	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	72.2592	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	72.3024	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	72.3888	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	72.432	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	72.5184	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	72.5616	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	72.6048	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	72.648	3.4500000477	120.000000	1	5400.000000	0.700000	1.700000	1.000000	30
i1	72.6912	3.4500000477	112.500000	1	5760.000000	0.700000	1.700000	1.000000	32
i1	72.7344	3.4500000477	105.882353	1	6120.000000	0.700000	1.700000	1.000000	34
i1	72.7776	3.4500000477	100.000000	1	6480.000000	0.700000	1.700000	1.000000	36
i1	72.8208	3.4500000477	94.736842	1	6840.000000	0.700000	1.700000	1.000000	38
i1	72.864	3.4500000477	90.000000	1	7200.000000	0.700000	1.700000	1.000000	40
i1	72.9072	3.4500000477	85.714286	1	7560.000000	0.700000	1.700000	1.000000	42
i1	72.9504	3.4500000477	81.818182	1	7920.000000	0.700000	1.700000	1.000000	44
i1	72.9936	3.4500000477	78.260870	1	8280.000000	0.700000	1.700000	1.000000	46
i1	73.0368	3.4500000477	75.000000	1	8640.000000	0.700000	1.700000	1.000000	48
i1	73.08	3.4500000477	72.000000	1	9000.000000	0.700000	1.700000	1.000000	50
i1	73.1232	3.4500000477	69.230769	1	9360.000000	0.700000	1.700000	1.000000	52
i1	73.1664	3.4500000477	66.666667	1	9720.000000	0.700000	1.700000	1.000000	54
i1	73.2096	3.4500000477	64.285714	1	10080.000000	0.700000	1.700000	1.000000	56
i1	73.2528	3.4500000477	62.068966	1	10440.000000	0.700000	1.700000	1.000000	58
i1	73.296	3.4500000477	60.000000	1	10800.000000	0.700000	1.700000	1.000000	60
i1	73.3392	3.4500000477	58.064516	1	11160.000000	0.700000	1.700000	1.000000	62
i1	73.3824	3.4500000477	56.250000	1	11520.000000	0.700000	1.700000	1.000000	64
i1	73.4256	3.4500000477	54.545455	1	11880.000000	0.700000	1.700000	1.000000	66
i1	75.5175	3.4500000477	156.521739	1	4140.000000	0.700000	1.700000	1.000000	23
i1	75.3825	3.4500000477	211.764706	1	3060.000000	0.700000	1.700000	1.000000	17
i1	75.2475	3.4500000477	327.272727	1	1980.000000	0.700000	1.700000	1.000000	11
i1	75.1125	3.4500000477	720.000000	1	900.000000	0.700000	1.700000	1.000000	5
i1	75.0225	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	75.09	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	75.135	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	75.225	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	75.27	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	75.36	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	75.405	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	75.495	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	75.54	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	79.5678	3.4500000477	53.731343	1	12060.000000	0.700000	1.700000	1.000000	67
i1	79.521	3.4500000477	55.384615	1	11700.000000	0.700000	1.700000	1.000000	65
i1	79.4742	3.4500000477	57.142857	1	11340.000000	0.700000	1.700000	1.000000	63
i1	79.4274	3.4500000477	59.016393	1	10980.000000	0.700000	1.700000	1.000000	61
i1	79.3806	3.4500000477	61.016949	1	10620.000000	0.700000	1.700000	1.000000	59
i1	79.3338	3.4500000477	63.157895	1	10260.000000	0.700000	1.700000	1.000000	57
i1	79.287	3.4500000477	65.454545	1	9900.000000	0.700000	1.700000	1.000000	55
i1	79.2402	3.4500000477	67.924528	1	9540.000000	0.700000	1.700000	1.000000	53
i1	79.1934	3.4500000477	70.588235	1	9180.000000	0.700000	1.700000	1.000000	51
i1	79.1466	3.4500000477	73.469388	1	8820.000000	0.700000	1.700000	1.000000	49
i1	79.0998	3.4500000477	76.595745	1	8460.000000	0.700000	1.700000	1.000000	47
i1	79.053	3.4500000477	80.000000	1	8100.000000	0.700000	1.700000	1.000000	45
i1	79.0062	3.4500000477	83.720930	1	7740.000000	0.700000	1.700000	1.000000	43
i1	78.9594	3.4500000477	87.804878	1	7380.000000	0.700000	1.700000	1.000000	41
i1	78.9126	3.4500000477	92.307692	1	7020.000000	0.700000	1.700000	1.000000	39
i1	78.8658	3.4500000477	97.297297	1	6660.000000	0.700000	1.700000	1.000000	37
i1	78.819	3.4500000477	102.857143	1	6300.000000	0.700000	1.700000	1.000000	35
i1	78.7722	3.4500000477	109.090909	1	5940.000000	0.700000	1.700000	1.000000	33
i1	78.7254	3.4500000477	116.129032	1	5580.000000	0.700000	1.700000	1.000000	31
i1	78.6786	3.4500000477	124.137931	1	5220.000000	0.700000	1.700000	1.000000	29
i1	78.6318	3.4500000477	133.333333	1	4860.000000	0.700000	1.700000	1.000000	27
i1	78.4914	3.4500000477	171.428571	1	3780.000000	0.700000	1.700000	1.000000	21
i1	78.351	3.4500000477	240.000000	1	2700.000000	0.700000	1.700000	1.000000	15
i1	78.2106	3.4500000477	400.000000	1	1620.000000	0.700000	1.700000	1.000000	9
i1	78.0702	3.4500000477	1200.000000	1	540.000000	0.700000	1.700000	1.000000	3
i1	78.0468	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	78.0936	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	78.1872	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	78.234	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	78.3276	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	78.3744	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	78.468	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	78.5148	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	78.6084	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	78.6552	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	78.702	3.4500000477	120.000000	1	5400.000000	0.700000	1.700000	1.000000	30
i1	78.7488	3.4500000477	112.500000	1	5760.000000	0.700000	1.700000	1.000000	32
i1	78.7956	3.4500000477	105.882353	1	6120.000000	0.700000	1.700000	1.000000	34
i1	78.8424	3.4500000477	100.000000	1	6480.000000	0.700000	1.700000	1.000000	36
i1	78.8892	3.4500000477	94.736842	1	6840.000000	0.700000	1.700000	1.000000	38
i1	78.936	3.4500000477	90.000000	1	7200.000000	0.700000	1.700000	1.000000	40
i1	78.9828	3.4500000477	85.714286	1	7560.000000	0.700000	1.700000	1.000000	42
i1	79.0296	3.4500000477	81.818182	1	7920.000000	0.700000	1.700000	1.000000	44
i1	79.0764	3.4500000477	78.260870	1	8280.000000	0.700000	1.700000	1.000000	46
i1	79.1232	3.4500000477	75.000000	1	8640.000000	0.700000	1.700000	1.000000	48
i1	79.17	3.4500000477	72.000000	1	9000.000000	0.700000	1.700000	1.000000	50
i1	79.2168	3.4500000477	69.230769	1	9360.000000	0.700000	1.700000	1.000000	52
i1	79.2636	3.4500000477	66.666667	1	9720.000000	0.700000	1.700000	1.000000	54
i1	79.3104	3.4500000477	64.285714	1	10080.000000	0.700000	1.700000	1.000000	56
i1	79.3572	3.4500000477	62.068966	1	10440.000000	0.700000	1.700000	1.000000	58
i1	79.404	3.4500000477	60.000000	1	10800.000000	0.700000	1.700000	1.000000	60
i1	79.4508	3.4500000477	58.064516	1	11160.000000	0.700000	1.700000	1.000000	62
i1	79.4976	3.4500000477	56.250000	1	11520.000000	0.700000	1.700000	1.000000	64
i1	79.5444	3.4500000477	54.545455	1	11880.000000	0.700000	1.700000	1.000000	66
i1	81.6075	3.4500000477	144.000000	1	4500.000000	0.700000	1.700000	1.000000	25
i1	81.4617	3.4500000477	189.473684	1	3420.000000	0.700000	1.700000	1.000000	19
i1	81.3159	3.4500000477	276.923077	1	2340.000000	0.700000	1.700000	1.000000	13
i1	81.1701	3.4500000477	514.285714	1	1260.000000	0.700000	1.700000	1.000000	7
i1	81.0243	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	81.0486	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	81.1458	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	81.1944	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	81.2916	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	81.3402	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	81.4374	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	81.486	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	81.5832	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	81.6318	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	85.6884	3.4500000477	53.731343	1	12060.000000	0.700000	1.700000	1.000000	67
i1	85.638	3.4500000477	55.384615	1	11700.000000	0.700000	1.700000	1.000000	65
i1	85.5876	3.4500000477	57.142857	1	11340.000000	0.700000	1.700000	1.000000	63
i1	85.5372	3.4500000477	59.016393	1	10980.000000	0.700000	1.700000	1.000000	61
i1	85.4868	3.4500000477	61.016949	1	10620.000000	0.700000	1.700000	1.000000	59
i1	85.4364	3.4500000477	63.157895	1	10260.000000	0.700000	1.700000	1.000000	57
i1	85.386	3.4500000477	65.454545	1	9900.000000	0.700000	1.700000	1.000000	55
i1	85.3356	3.4500000477	67.924528	1	9540.000000	0.700000	1.700000	1.000000	53
i1	85.2852	3.4500000477	70.588235	1	9180.000000	0.700000	1.700000	1.000000	51
i1	85.2348	3.4500000477	73.469388	1	8820.000000	0.700000	1.700000	1.000000	49
i1	85.1844	3.4500000477	76.595745	1	8460.000000	0.700000	1.700000	1.000000	47
i1	85.134	3.4500000477	80.000000	1	8100.000000	0.700000	1.700000	1.000000	45
i1	85.0836	3.4500000477	83.720930	1	7740.000000	0.700000	1.700000	1.000000	43
i1	85.0332	3.4500000477	87.804878	1	7380.000000	0.700000	1.700000	1.000000	41
i1	84.9828	3.4500000477	92.307692	1	7020.000000	0.700000	1.700000	1.000000	39
i1	84.9324	3.4500000477	97.297297	1	6660.000000	0.700000	1.700000	1.000000	37
i1	84.882	3.4500000477	102.857143	1	6300.000000	0.700000	1.700000	1.000000	35
i1	84.8316	3.4500000477	109.090909	1	5940.000000	0.700000	1.700000	1.000000	33
i1	84.7812	3.4500000477	116.129032	1	5580.000000	0.700000	1.700000	1.000000	31
i1	84.7308	3.4500000477	124.137931	1	5220.000000	0.700000	1.700000	1.000000	29
i1	84.5796	3.4500000477	156.521739	1	4140.000000	0.700000	1.700000	1.000000	23
i1	84.4284	3.4500000477	211.764706	1	3060.000000	0.700000	1.700000	1.000000	17
i1	84.2772	3.4500000477	327.272727	1	1980.000000	0.700000	1.700000	1.000000	11
i1	84.126	3.4500000477	720.000000	1	900.000000	0.700000	1.700000	1.000000	5
i1	84.0252	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	84.1008	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	84.1512	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	84.252	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	84.3024	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	84.4032	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	84.4536	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	84.5544	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	84.6048	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	84.7056	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	84.756	3.4500000477	120.000000	1	5400.000000	0.700000	1.700000	1.000000	30
i1	84.8064	3.4500000477	112.500000	1	5760.000000	0.700000	1.700000	1.000000	32
i1	84.8568	3.4500000477	105.882353	1	6120.000000	0.700000	1.700000	1.000000	34
i1	84.9072	3.4500000477	100.000000	1	6480.000000	0.700000	1.700000	1.000000	36
i1	84.9576	3.4500000477	94.736842	1	6840.000000	0.700000	1.700000	1.000000	38
i1	85.008	3.4500000477	90.000000	1	7200.000000	0.700000	1.700000	1.000000	40
i1	85.0584	3.4500000477	85.714286	1	7560.000000	0.700000	1.700000	1.000000	42
i1	85.1088	3.4500000477	81.818182	1	7920.000000	0.700000	1.700000	1.000000	44
i1	85.1592	3.4500000477	78.260870	1	8280.000000	0.700000	1.700000	1.000000	46
i1	85.2096	3.4500000477	75.000000	1	8640.000000	0.700000	1.700000	1.000000	48
i1	85.26	3.4500000477	72.000000	1	9000.000000	0.700000	1.700000	1.000000	50
i1	85.3104	3.4500000477	69.230769	1	9360.000000	0.700000	1.700000	1.000000	52
i1	85.3608	3.4500000477	66.666667	1	9720.000000	0.700000	1.700000	1.000000	54
i1	85.4112	3.4500000477	64.285714	1	10080.000000	0.700000	1.700000	1.000000	56
i1	85.4616	3.4500000477	62.068966	1	10440.000000	0.700000	1.700000	1.000000	58
i1	85.512	3.4500000477	60.000000	1	10800.000000	0.700000	1.700000	1.000000	60
i1	85.5624	3.4500000477	58.064516	1	11160.000000	0.700000	1.700000	1.000000	62
i1	85.6128	3.4500000477	56.250000	1	11520.000000	0.700000	1.700000	1.000000	64
i1	85.6632	3.4500000477	54.545455	1	11880.000000	0.700000	1.700000	1.000000	66
i1	87.7047	3.4500000477	133.333333	1	4860.000000	0.700000	1.700000	1.000000	27
i1	87.5481	3.4500000477	171.428571	1	3780.000000	0.700000	1.700000	1.000000	21
i1	87.3915	3.4500000477	240.000000	1	2700.000000	0.700000	1.700000	1.000000	15
i1	87.2349	3.4500000477	400.000000	1	1620.000000	0.700000	1.700000	1.000000	9
i1	87.0783	3.4500000477	1200.000000	1	540.000000	0.700000	1.700000	1.000000	3
i1	87.0522	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	87.1044	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	87.2088	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	87.261	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	87.3654	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	87.4176	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	87.522	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	87.5742	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	87.6786	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	87.7308	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	91.809	3.4500000477	53.731343	1	12060.000000	0.700000	1.700000	1.000000	67
i1	91.755	3.4500000477	55.384615	1	11700.000000	0.700000	1.700000	1.000000	65
i1	91.701	3.4500000477	57.142857	1	11340.000000	0.700000	1.700000	1.000000	63
i1	91.647	3.4500000477	59.016393	1	10980.000000	0.700000	1.700000	1.000000	61
i1	91.593	3.4500000477	61.016949	1	10620.000000	0.700000	1.700000	1.000000	59
i1	91.539	3.4500000477	63.157895	1	10260.000000	0.700000	1.700000	1.000000	57
i1	91.485	3.4500000477	65.454545	1	9900.000000	0.700000	1.700000	1.000000	55
i1	91.431	3.4500000477	67.924528	1	9540.000000	0.700000	1.700000	1.000000	53
i1	91.377	3.4500000477	70.588235	1	9180.000000	0.700000	1.700000	1.000000	51
i1	91.323	3.4500000477	73.469388	1	8820.000000	0.700000	1.700000	1.000000	49
i1	91.269	3.4500000477	76.595745	1	8460.000000	0.700000	1.700000	1.000000	47
i1	91.215	3.4500000477	80.000000	1	8100.000000	0.700000	1.700000	1.000000	45
i1	91.161	3.4500000477	83.720930	1	7740.000000	0.700000	1.700000	1.000000	43
i1	91.107	3.4500000477	87.804878	1	7380.000000	0.700000	1.700000	1.000000	41
i1	91.053	3.4500000477	92.307692	1	7020.000000	0.700000	1.700000	1.000000	39
i1	90.999	3.4500000477	97.297297	1	6660.000000	0.700000	1.700000	1.000000	37
i1	90.945	3.4500000477	102.857143	1	6300.000000	0.700000	1.700000	1.000000	35
i1	90.891	3.4500000477	109.090909	1	5940.000000	0.700000	1.700000	1.000000	33
i1	90.837	3.4500000477	116.129032	1	5580.000000	0.700000	1.700000	1.000000	31
i1	90.675	3.4500000477	144.000000	1	4500.000000	0.700000	1.700000	1.000000	25
i1	90.513	3.4500000477	189.473684	1	3420.000000	0.700000	1.700000	1.000000	19
i1	90.351	3.4500000477	276.923077	1	2340.000000	0.700000	1.700000	1.000000	13
i1	90.189	3.4500000477	514.285714	1	1260.000000	0.700000	1.700000	1.000000	7
i1	90.027	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	90.054	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	90.162	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	90.216	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	90.324	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	90.378	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	90.486	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	90.54	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	90.648	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	90.702	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	90.81	3.4500000477	120.000000	1	5400.000000	0.700000	1.700000	1.000000	30
i1	90.864	3.4500000477	112.500000	1	5760.000000	0.700000	1.700000	1.000000	32
i1	90.918	3.4500000477	105.882353	1	6120.000000	0.700000	1.700000	1.000000	34
i1	90.972	3.4500000477	100.000000	1	6480.000000	0.700000	1.700000	1.000000	36
i1	91.026	3.4500000477	94.736842	1	6840.000000	0.700000	1.700000	1.000000	38
i1	91.08	3.4500000477	90.000000	1	7200.000000	0.700000	1.700000	1.000000	40
i1	91.134	3.4500000477	85.714286	1	7560.000000	0.700000	1.700000	1.000000	42
i1	91.188	3.4500000477	81.818182	1	7920.000000	0.700000	1.700000	1.000000	44
i1	91.242	3.4500000477	78.260870	1	8280.000000	0.700000	1.700000	1.000000	46
i1	91.296	3.4500000477	75.000000	1	8640.000000	0.700000	1.700000	1.000000	48
i1	91.35	3.4500000477	72.000000	1	9000.000000	0.700000	1.700000	1.000000	50
i1	91.404	3.4500000477	69.230769	1	9360.000000	0.700000	1.700000	1.000000	52
i1	91.458	3.4500000477	66.666667	1	9720.000000	0.700000	1.700000	1.000000	54
i1	91.512	3.4500000477	64.285714	1	10080.000000	0.700000	1.700000	1.000000	56
i1	91.566	3.4500000477	62.068966	1	10440.000000	0.700000	1.700000	1.000000	58
i1	91.62	3.4500000477	60.000000	1	10800.000000	0.700000	1.700000	1.000000	60
i1	91.674	3.4500000477	58.064516	1	11160.000000	0.700000	1.700000	1.000000	62
i1	91.728	3.4500000477	56.250000	1	11520.000000	0.700000	1.700000	1.000000	64
i1	91.782	3.4500000477	54.545455	1	11880.000000	0.700000	1.700000	1.000000	66
i1	93.8091	3.4500000477	124.137931	1	5220.000000	0.700000	1.700000	1.000000	29
i1	93.6417	3.4500000477	156.521739	1	4140.000000	0.700000	1.700000	1.000000	23
i1	93.4743	3.4500000477	211.764706	1	3060.000000	0.700000	1.700000	1.000000	17
i1	93.3069	3.4500000477	327.272727	1	1980.000000	0.700000	1.700000	1.000000	11
i1	93.1395	3.4500000477	720.000000	1	900.000000	0.700000	1.700000	1.000000	5
i1	93.0279	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	93.1116	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	93.1674	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	93.279	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	93.3348	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	93.4464	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	93.5022	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	93.6138	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	93.6696	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	93.7812	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	93.837	3.4500000477	120.000000	1	5400.000000	0.700000	1.700000	1.000000	30
i1	97.9296	3.4500000477	53.731343	1	12060.000000	0.700000	1.700000	1.000000	67
i1	97.872	3.4500000477	55.384615	1	11700.000000	0.700000	1.700000	1.000000	65
i1	97.8144	3.4500000477	57.142857	1	11340.000000	0.700000	1.700000	1.000000	63
i1	97.7568	3.4500000477	59.016393	1	10980.000000	0.700000	1.700000	1.000000	61
i1	97.6992	3.4500000477	61.016949	1	10620.000000	0.700000	1.700000	1.000000	59
i1	97.6416	3.4500000477	63.157895	1	10260.000000	0.700000	1.700000	1.000000	57
i1	97.584	3.4500000477	65.454545	1	9900.000000	0.700000	1.700000	1.000000	55
i1	97.5264	3.4500000477	67.924528	1	9540.000000	0.700000	1.700000	1.000000	53
i1	97.4688	3.4500000477	70.588235	1	9180.000000	0.700000	1.700000	1.000000	51
i1	97.4112	3.4500000477	73.469388	1	8820.000000	0.700000	1.700000	1.000000	49
i1	97.3536	3.4500000477	76.595745	1	8460.000000	0.700000	1.700000	1.000000	47
i1	97.296	3.4500000477	80.000000	1	8100.000000	0.700000	1.700000	1.000000	45
i1	97.2384	3.4500000477	83.720930	1	7740.000000	0.700000	1.700000	1.000000	43
i1	97.1808	3.4500000477	87.804878	1	7380.000000	0.700000	1.700000	1.000000	41
i1	97.1232	3.4500000477	92.307692	1	7020.000000	0.700000	1.700000	1.000000	39
i1	97.0656	3.4500000477	97.297297	1	6660.000000	0.700000	1.700000	1.000000	37
i1	97.008	3.4500000477	102.857143	1	6300.000000	0.700000	1.700000	1.000000	35
i1	96.9504	3.4500000477	109.090909	1	5940.000000	0.700000	1.700000	1.000000	33
i1	96.7776	3.4500000477	133.333333	1	4860.000000	0.700000	1.700000	1.000000	27
i1	96.6048	3.4500000477	171.428571	1	3780.000000	0.700000	1.700000	1.000000	21
i1	96.432	3.4500000477	240.000000	1	2700.000000	0.700000	1.700000	1.000000	15
i1	96.2592	3.4500000477	400.000000	1	1620.000000	0.700000	1.700000	1.000000	9
i1	96.0864	3.4500000477	1200.000000	1	540.000000	0.700000	1.700000	1.000000	3
i1	96.0576	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	96.1152	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	96.2304	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	96.288	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	96.4032	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	96.4608	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	96.576	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	96.6336	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	96.7488	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	96.8064	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	96.9216	3.4500000477	112.500000	1	5760.000000	0.700000	1.700000	1.000000	32
i1	96.9792	3.4500000477	105.882353	1	6120.000000	0.700000	1.700000	1.000000	34
i1	97.0368	3.4500000477	100.000000	1	6480.000000	0.700000	1.700000	1.000000	36
i1	97.0944	3.4500000477	94.736842	1	6840.000000	0.700000	1.700000	1.000000	38
i1	97.152	3.4500000477	90.000000	1	7200.000000	0.700000	1.700000	1.000000	40
i1	97.2096	3.4500000477	85.714286	1	7560.000000	0.700000	1.700000	1.000000	42
i1	97.2672	3.4500000477	81.818182	1	7920.000000	0.700000	1.700000	1.000000	44
i1	97.3248	3.4500000477	78.260870	1	8280.000000	0.700000	1.700000	1.000000	46
i1	97.3824	3.4500000477	75.000000	1	8640.000000	0.700000	1.700000	1.000000	48
i1	97.44	3.4500000477	72.000000	1	9000.000000	0.700000	1.700000	1.000000	50
i1	97.4976	3.4500000477	69.230769	1	9360.000000	0.700000	1.700000	1.000000	52
i1	97.5552	3.4500000477	66.666667	1	9720.000000	0.700000	1.700000	1.000000	54
i1	97.6128	3.4500000477	64.285714	1	10080.000000	0.700000	1.700000	1.000000	56
i1	97.6704	3.4500000477	62.068966	1	10440.000000	0.700000	1.700000	1.000000	58
i1	97.728	3.4500000477	60.000000	1	10800.000000	0.700000	1.700000	1.000000	60
i1	97.7856	3.4500000477	58.064516	1	11160.000000	0.700000	1.700000	1.000000	62
i1	97.8432	3.4500000477	56.250000	1	11520.000000	0.700000	1.700000	1.000000	64
i1	97.9008	3.4500000477	54.545455	1	11880.000000	0.700000	1.700000	1.000000	66
i1	99.9207	3.4500000477	116.129032	1	5580.000000	0.700000	1.700000	1.000000	31
i1	99.7425	3.4500000477	144.000000	1	4500.000000	0.700000	1.700000	1.000000	25
i1	99.5643	3.4500000477	189.473684	1	3420.000000	0.700000	1.700000	1.000000	19
i1	99.3861	3.4500000477	276.923077	1	2340.000000	0.700000	1.700000	1.000000	13
i1	99.2079	3.4500000477	514.285714	1	1260.000000	0.700000	1.700000	1.000000	7
i1	99.0297	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	99.0594	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	99.1782	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	99.2376	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	99.3564	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	99.4158	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	99.5346	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	99.594	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	99.7128	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	99.7722	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	99.891	3.4500000477	120.000000	1	5400.000000	0.700000	1.700000	1.000000	30
i1	99.9504	3.4500000477	112.500000	1	5760.000000	0.700000	1.700000	1.000000	32
i1	104.0502	3.4500000477	53.731343	1	12060.000000	0.700000	1.700000	1.000000	67
i1	103.989	3.4500000477	55.384615	1	11700.000000	0.700000	1.700000	1.000000	65
i1	103.9278	3.4500000477	57.142857	1	11340.000000	0.700000	1.700000	1.000000	63
i1	103.8666	3.4500000477	59.016393	1	10980.000000	0.700000	1.700000	1.000000	61
i1	103.8054	3.4500000477	61.016949	1	10620.000000	0.700000	1.700000	1.000000	59
i1	103.7442	3.4500000477	63.157895	1	10260.000000	0.700000	1.700000	1.000000	57
i1	103.683	3.4500000477	65.454545	1	9900.000000	0.700000	1.700000	1.000000	55
i1	103.6218	3.4500000477	67.924528	1	9540.000000	0.700000	1.700000	1.000000	53
i1	103.5606	3.4500000477	70.588235	1	9180.000000	0.700000	1.700000	1.000000	51
i1	103.4994	3.4500000477	73.469388	1	8820.000000	0.700000	1.700000	1.000000	49
i1	103.4382	3.4500000477	76.595745	1	8460.000000	0.700000	1.700000	1.000000	47
i1	103.377	3.4500000477	80.000000	1	8100.000000	0.700000	1.700000	1.000000	45
i1	103.3158	3.4500000477	83.720930	1	7740.000000	0.700000	1.700000	1.000000	43
i1	103.2546	3.4500000477	87.804878	1	7380.000000	0.700000	1.700000	1.000000	41
i1	103.1934	3.4500000477	92.307692	1	7020.000000	0.700000	1.700000	1.000000	39
i1	103.1322	3.4500000477	97.297297	1	6660.000000	0.700000	1.700000	1.000000	37
i1	103.071	3.4500000477	102.857143	1	6300.000000	0.700000	1.700000	1.000000	35
i1	102.8874	3.4500000477	124.137931	1	5220.000000	0.700000	1.700000	1.000000	29
i1	102.7038	3.4500000477	156.521739	1	4140.000000	0.700000	1.700000	1.000000	23
i1	102.5202	3.4500000477	211.764706	1	3060.000000	0.700000	1.700000	1.000000	17
i1	102.3366	3.4500000477	327.272727	1	1980.000000	0.700000	1.700000	1.000000	11
i1	102.153	3.4500000477	720.000000	1	900.000000	0.700000	1.700000	1.000000	5
i1	102.0306	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	102.1224	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	102.1836	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	102.306	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	102.3672	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	102.4896	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	102.5508	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	102.6732	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	102.7344	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	102.8568	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	102.918	3.4500000477	120.000000	1	5400.000000	0.700000	1.700000	1.000000	30
i1	103.0404	3.4500000477	105.882353	1	6120.000000	0.700000	1.700000	1.000000	34
i1	103.1016	3.4500000477	100.000000	1	6480.000000	0.700000	1.700000	1.000000	36
i1	103.1628	3.4500000477	94.736842	1	6840.000000	0.700000	1.700000	1.000000	38
i1	103.224	3.4500000477	90.000000	1	7200.000000	0.700000	1.700000	1.000000	40
i1	103.2852	3.4500000477	85.714286	1	7560.000000	0.700000	1.700000	1.000000	42
i1	103.3464	3.4500000477	81.818182	1	7920.000000	0.700000	1.700000	1.000000	44
i1	103.4076	3.4500000477	78.260870	1	8280.000000	0.700000	1.700000	1.000000	46
i1	103.4688	3.4500000477	75.000000	1	8640.000000	0.700000	1.700000	1.000000	48
i1	103.53	3.4500000477	72.000000	1	9000.000000	0.700000	1.700000	1.000000	50
i1	103.5912	3.4500000477	69.230769	1	9360.000000	0.700000	1.700000	1.000000	52
i1	103.6524	3.4500000477	66.666667	1	9720.000000	0.700000	1.700000	1.000000	54
i1	103.7136	3.4500000477	64.285714	1	10080.000000	0.700000	1.700000	1.000000	56
i1	103.7748	3.4500000477	62.068966	1	10440.000000	0.700000	1.700000	1.000000	58
i1	103.836	3.4500000477	60.000000	1	10800.000000	0.700000	1.700000	1.000000	60
i1	103.8972	3.4500000477	58.064516	1	11160.000000	0.700000	1.700000	1.000000	62
i1	103.9584	3.4500000477	56.250000	1	11520.000000	0.700000	1.700000	1.000000	64
i1	104.0196	3.4500000477	54.545455	1	11880.000000	0.700000	1.700000	1.000000	66
i1	106.0395	3.4500000477	109.090909	1	5940.000000	0.700000	1.700000	1.000000	33
i1	105.8505	3.4500000477	133.333333	1	4860.000000	0.700000	1.700000	1.000000	27
i1	105.6615	3.4500000477	171.428571	1	3780.000000	0.700000	1.700000	1.000000	21
i1	105.4725	3.4500000477	240.000000	1	2700.000000	0.700000	1.700000	1.000000	15
i1	105.2835	3.4500000477	400.000000	1	1620.000000	0.700000	1.700000	1.000000	9
i1	105.0945	3.4500000477	1200.000000	1	540.000000	0.700000	1.700000	1.000000	3
i1	105.063	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	105.126	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	105.252	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	105.315	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	105.441	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	105.504	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	105.63	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	105.693	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	105.819	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	105.882	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	106.008	3.4500000477	112.500000	1	5760.000000	0.700000	1.700000	1.000000	32
i1	106.071	3.4500000477	105.882353	1	6120.000000	0.700000	1.700000	1.000000	34
i1	110.1708	3.4500000477	53.731343	1	12060.000000	0.700000	1.700000	1.000000	67
i1	110.106	3.4500000477	55.384615	1	11700.000000	0.700000	1.700000	1.000000	65
i1	110.0412	3.4500000477	57.142857	1	11340.000000	0.700000	1.700000	1.000000	63
i1	109.9764	3.4500000477	59.016393	1	10980.000000	0.700000	1.700000	1.000000	61
i1	109.9116	3.4500000477	61.016949	1	10620.000000	0.700000	1.700000	1.000000	59
i1	109.8468	3.4500000477	63.157895	1	10260.000000	0.700000	1.700000	1.000000	57
i1	109.782	3.4500000477	65.454545	1	9900.000000	0.700000	1.700000	1.000000	55
i1	109.7172	3.4500000477	67.924528	1	9540.000000	0.700000	1.700000	1.000000	53
i1	109.6524	3.4500000477	70.588235	1	9180.000000	0.700000	1.700000	1.000000	51
i1	109.5876	3.4500000477	73.469388	1	8820.000000	0.700000	1.700000	1.000000	49
i1	109.5228	3.4500000477	76.595745	1	8460.000000	0.700000	1.700000	1.000000	47
i1	109.458	3.4500000477	80.000000	1	8100.000000	0.700000	1.700000	1.000000	45
i1	109.3932	3.4500000477	83.720930	1	7740.000000	0.700000	1.700000	1.000000	43
i1	109.3284	3.4500000477	87.804878	1	7380.000000	0.700000	1.700000	1.000000	41
i1	109.2636	3.4500000477	92.307692	1	7020.000000	0.700000	1.700000	1.000000	39
i1	109.1988	3.4500000477	97.297297	1	6660.000000	0.700000	1.700000	1.000000	37
i1	109.0044	3.4500000477	116.129032	1	5580.000000	0.700000	1.700000	1.000000	31
i1	108.81	3.4500000477	144.000000	1	4500.000000	0.700000	1.700000	1.000000	25
i1	108.6156	3.4500000477	189.473684	1	3420.000000	0.700000	1.700000	1.000000	19
i1	108.4212	3.4500000477	276.923077	1	2340.000000	0.700000	1.700000	1.000000	13
i1	108.2268	3.4500000477	514.285714	1	1260.000000	0.700000	1.700000	1.000000	7
i1	108.0324	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	108.0648	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	108.1944	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	108.2592	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	108.3888	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	108.4536	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	108.5832	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	108.648	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	108.7776	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	108.8424	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	108.972	3.4500000477	120.000000	1	5400.000000	0.700000	1.700000	1.000000	30
i1	109.0368	3.4500000477	112.500000	1	5760.000000	0.700000	1.700000	1.000000	32
i1	109.1664	3.4500000477	100.000000	1	6480.000000	0.700000	1.700000	1.000000	36
i1	109.2312	3.4500000477	94.736842	1	6840.000000	0.700000	1.700000	1.000000	38
i1	109.296	3.4500000477	90.000000	1	7200.000000	0.700000	1.700000	1.000000	40
i1	109.3608	3.4500000477	85.714286	1	7560.000000	0.700000	1.700000	1.000000	42
i1	109.4256	3.4500000477	81.818182	1	7920.000000	0.700000	1.700000	1.000000	44
i1	109.4904	3.4500000477	78.260870	1	8280.000000	0.700000	1.700000	1.000000	46
i1	109.5552	3.4500000477	75.000000	1	8640.000000	0.700000	1.700000	1.000000	48
i1	109.62	3.4500000477	72.000000	1	9000.000000	0.700000	1.700000	1.000000	50
i1	109.6848	3.4500000477	69.230769	1	9360.000000	0.700000	1.700000	1.000000	52
i1	109.7496	3.4500000477	66.666667	1	9720.000000	0.700000	1.700000	1.000000	54
i1	109.8144	3.4500000477	64.285714	1	10080.000000	0.700000	1.700000	1.000000	56
i1	109.8792	3.4500000477	62.068966	1	10440.000000	0.700000	1.700000	1.000000	58
i1	109.944	3.4500000477	60.000000	1	10800.000000	0.700000	1.700000	1.000000	60
i1	110.0088	3.4500000477	58.064516	1	11160.000000	0.700000	1.700000	1.000000	62
i1	110.0736	3.4500000477	56.250000	1	11520.000000	0.700000	1.700000	1.000000	64
i1	110.1384	3.4500000477	54.545455	1	11880.000000	0.700000	1.700000	1.000000	66
i1	112.1655	3.4500000477	102.857143	1	6300.000000	0.700000	1.700000	1.000000	35
i1	111.9657	3.4500000477	124.137931	1	5220.000000	0.700000	1.700000	1.000000	29
i1	111.7659	3.4500000477	156.521739	1	4140.000000	0.700000	1.700000	1.000000	23
i1	111.5661	3.4500000477	211.764706	1	3060.000000	0.700000	1.700000	1.000000	17
i1	111.3663	3.4500000477	327.272727	1	1980.000000	0.700000	1.700000	1.000000	11
i1	111.1665	3.4500000477	720.000000	1	900.000000	0.700000	1.700000	1.000000	5
i1	111.0333	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	111.1332	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	111.1998	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	111.333	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	111.3996	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	111.5328	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	111.5994	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	111.7326	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	111.7992	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	111.9324	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	111.999	3.4500000477	120.000000	1	5400.000000	0.700000	1.700000	1.000000	30
i1	112.1322	3.4500000477	105.882353	1	6120.000000	0.700000	1.700000	1.000000	34
i1	112.1988	3.4500000477	100.000000	1	6480.000000	0.700000	1.700000	1.000000	36
i1	116.2914	3.4500000477	53.731343	1	12060.000000	0.700000	1.700000	1.000000	67
i1	116.223	3.4500000477	55.384615	1	11700.000000	0.700000	1.700000	1.000000	65
i1	116.1546	3.4500000477	57.142857	1	11340.000000	0.700000	1.700000	1.000000	63
i1	116.0862	3.4500000477	59.016393	1	10980.000000	0.700000	1.700000	1.000000	61
i1	116.0178	3.4500000477	61.016949	1	10620.000000	0.700000	1.700000	1.000000	59
i1	115.9494	3.4500000477	63.157895	1	10260.000000	0.700000	1.700000	1.000000	57
i1	115.881	3.4500000477	65.454545	1	9900.000000	0.700000	1.700000	1.000000	55
i1	115.8126	3.4500000477	67.924528	1	9540.000000	0.700000	1.700000	1.000000	53
i1	115.7442	3.4500000477	70.588235	1	9180.000000	0.700000	1.700000	1.000000	51
i1	115.6758	3.4500000477	73.469388	1	8820.000000	0.700000	1.700000	1.000000	49
i1	115.6074	3.4500000477	76.595745	1	8460.000000	0.700000	1.700000	1.000000	47
i1	115.539	3.4500000477	80.000000	1	8100.000000	0.700000	1.700000	1.000000	45
i1	115.4706	3.4500000477	83.720930	1	7740.000000	0.700000	1.700000	1.000000	43
i1	115.4022	3.4500000477	87.804878	1	7380.000000	0.700000	1.700000	1.000000	41
i1	115.3338	3.4500000477	92.307692	1	7020.000000	0.700000	1.700000	1.000000	39
i1	115.1286	3.4500000477	109.090909	1	5940.000000	0.700000	1.700000	1.000000	33
i1	114.9234	3.4500000477	133.333333	1	4860.000000	0.700000	1.700000	1.000000	27
i1	114.7182	3.4500000477	171.428571	1	3780.000000	0.700000	1.700000	1.000000	21
i1	114.513	3.4500000477	240.000000	1	2700.000000	0.700000	1.700000	1.000000	15
i1	114.3078	3.4500000477	400.000000	1	1620.000000	0.700000	1.700000	1.000000	9
i1	114.1026	3.4500000477	1200.000000	1	540.000000	0.700000	1.700000	1.000000	3
i1	114.0684	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	114.1368	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	114.2736	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	114.342	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	114.4788	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	114.5472	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	114.684	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	114.7524	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	114.8892	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	114.9576	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	115.0944	3.4500000477	112.500000	1	5760.000000	0.700000	1.700000	1.000000	32
i1	115.1628	3.4500000477	105.882353	1	6120.000000	0.700000	1.700000	1.000000	34
i1	115.2996	3.4500000477	94.736842	1	6840.000000	0.700000	1.700000	1.000000	38
i1	115.368	3.4500000477	90.000000	1	7200.000000	0.700000	1.700000	1.000000	40
i1	115.4364	3.4500000477	85.714286	1	7560.000000	0.700000	1.700000	1.000000	42
i1	115.5048	3.4500000477	81.818182	1	7920.000000	0.700000	1.700000	1.000000	44
i1	115.5732	3.4500000477	78.260870	1	8280.000000	0.700000	1.700000	1.000000	46
i1	115.6416	3.4500000477	75.000000	1	8640.000000	0.700000	1.700000	1.000000	48
i1	115.71	3.4500000477	72.000000	1	9000.000000	0.700000	1.700000	1.000000	50
i1	115.7784	3.4500000477	69.230769	1	9360.000000	0.700000	1.700000	1.000000	52
i1	115.8468	3.4500000477	66.666667	1	9720.000000	0.700000	1.700000	1.000000	54
i1	115.9152	3.4500000477	64.285714	1	10080.000000	0.700000	1.700000	1.000000	56
i1	115.9836	3.4500000477	62.068966	1	10440.000000	0.700000	1.700000	1.000000	58
i1	116.052	3.4500000477	60.000000	1	10800.000000	0.700000	1.700000	1.000000	60
i1	116.1204	3.4500000477	58.064516	1	11160.000000	0.700000	1.700000	1.000000	62
i1	116.1888	3.4500000477	56.250000	1	11520.000000	0.700000	1.700000	1.000000	64
i1	116.2572	3.4500000477	54.545455	1	11880.000000	0.700000	1.700000	1.000000	66
i1	118.2987	3.4500000477	97.297297	1	6660.000000	0.700000	1.700000	1.000000	37
i1	118.0881	3.4500000477	116.129032	1	5580.000000	0.700000	1.700000	1.000000	31
i1	117.8775	3.4500000477	144.000000	1	4500.000000	0.700000	1.700000	1.000000	25
i1	117.6669	3.4500000477	189.473684	1	3420.000000	0.700000	1.700000	1.000000	19
i1	117.4563	3.4500000477	276.923077	1	2340.000000	0.700000	1.700000	1.000000	13
i1	117.2457	3.4500000477	514.285714	1	1260.000000	0.700000	1.700000	1.000000	7
i1	117.0351	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	117.0702	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	117.2106	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	117.2808	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	117.4212	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	117.4914	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	117.6318	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	117.702	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	117.8424	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	117.9126	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	118.053	3.4500000477	120.000000	1	5400.000000	0.700000	1.700000	1.000000	30
i1	118.1232	3.4500000477	112.500000	1	5760.000000	0.700000	1.700000	1.000000	32
i1	118.2636	3.4500000477	100.000000	1	6480.000000	0.700000	1.700000	1.000000	36
i1	118.3338	3.4500000477	94.736842	1	6840.000000	0.700000	1.700000	1.000000	38
i1	122.412	3.4500000477	53.731343	1	12060.000000	0.700000	1.700000	1.000000	67
i1	122.34	3.4500000477	55.384615	1	11700.000000	0.700000	1.700000	1.000000	65
i1	122.268	3.4500000477	57.142857	1	11340.000000	0.700000	1.700000	1.000000	63
i1	122.196	3.4500000477	59.016393	1	10980.000000	0.700000	1.700000	1.000000	61
i1	122.124	3.4500000477	61.016949	1	10620.000000	0.700000	1.700000	1.000000	59
i1	122.052	3.4500000477	63.157895	1	10260.000000	0.700000	1.700000	1.000000	57
i1	121.98	3.4500000477	65.454545	1	9900.000000	0.700000	1.700000	1.000000	55
i1	121.908	3.4500000477	67.924528	1	9540.000000	0.700000	1.700000	1.000000	53
i1	121.836	3.4500000477	70.588235	1	9180.000000	0.700000	1.700000	1.000000	51
i1	121.764	3.4500000477	73.469388	1	8820.000000	0.700000	1.700000	1.000000	49
i1	121.692	3.4500000477	76.595745	1	8460.000000	0.700000	1.700000	1.000000	47
i1	121.62	3.4500000477	80.000000	1	8100.000000	0.700000	1.700000	1.000000	45
i1	121.548	3.4500000477	83.720930	1	7740.000000	0.700000	1.700000	1.000000	43
i1	121.476	3.4500000477	87.804878	1	7380.000000	0.700000	1.700000	1.000000	41
i1	121.26	3.4500000477	102.857143	1	6300.000000	0.700000	1.700000	1.000000	35
i1	121.044	3.4500000477	124.137931	1	5220.000000	0.700000	1.700000	1.000000	29
i1	120.828	3.4500000477	156.521739	1	4140.000000	0.700000	1.700000	1.000000	23
i1	120.612	3.4500000477	211.764706	1	3060.000000	0.700000	1.700000	1.000000	17
i1	120.396	3.4500000477	327.272727	1	1980.000000	0.700000	1.700000	1.000000	11
i1	120.18	3.4500000477	720.000000	1	900.000000	0.700000	1.700000	1.000000	5
i1	120.036	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	120.144	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	120.216	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	120.36	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	120.432	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	120.576	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	120.648	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	120.792	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	120.864	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	121.008	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	121.08	3.4500000477	120.000000	1	5400.000000	0.700000	1.700000	1.000000	30
i1	121.224	3.4500000477	105.882353	1	6120.000000	0.700000	1.700000	1.000000	34
i1	121.296	3.4500000477	100.000000	1	6480.000000	0.700000	1.700000	1.000000	36
i1	121.44	3.4500000477	90.000000	1	7200.000000	0.700000	1.700000	1.000000	40
i1	121.512	3.4500000477	85.714286	1	7560.000000	0.700000	1.700000	1.000000	42
i1	121.584	3.4500000477	81.818182	1	7920.000000	0.700000	1.700000	1.000000	44
i1	121.656	3.4500000477	78.260870	1	8280.000000	0.700000	1.700000	1.000000	46
i1	121.728	3.4500000477	75.000000	1	8640.000000	0.700000	1.700000	1.000000	48
i1	121.8	3.4500000477	72.000000	1	9000.000000	0.700000	1.700000	1.000000	50
i1	121.872	3.4500000477	69.230769	1	9360.000000	0.700000	1.700000	1.000000	52
i1	121.944	3.4500000477	66.666667	1	9720.000000	0.700000	1.700000	1.000000	54
i1	122.016	3.4500000477	64.285714	1	10080.000000	0.700000	1.700000	1.000000	56
i1	122.088	3.4500000477	62.068966	1	10440.000000	0.700000	1.700000	1.000000	58
i1	122.16	3.4500000477	60.000000	1	10800.000000	0.700000	1.700000	1.000000	60
i1	122.232	3.4500000477	58.064516	1	11160.000000	0.700000	1.700000	1.000000	62
i1	122.304	3.4500000477	56.250000	1	11520.000000	0.700000	1.700000	1.000000	64
i1	122.376	3.4500000477	54.545455	1	11880.000000	0.700000	1.700000	1.000000	66
i1	124.4391	3.4500000477	92.307692	1	7020.000000	0.700000	1.700000	1.000000	39
i1	124.2177	3.4500000477	109.090909	1	5940.000000	0.700000	1.700000	1.000000	33
i1	123.9963	3.4500000477	133.333333	1	4860.000000	0.700000	1.700000	1.000000	27
i1	123.7749	3.4500000477	171.428571	1	3780.000000	0.700000	1.700000	1.000000	21
i1	123.5535	3.4500000477	240.000000	1	2700.000000	0.700000	1.700000	1.000000	15
i1	123.3321	3.4500000477	400.000000	1	1620.000000	0.700000	1.700000	1.000000	9
i1	123.1107	3.4500000477	1200.000000	1	540.000000	0.700000	1.700000	1.000000	3
i1	123.0738	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	123.1476	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	123.2952	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	123.369	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	123.5166	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	123.5904	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	123.738	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	123.8118	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	123.9594	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	124.0332	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	124.1808	3.4500000477	112.500000	1	5760.000000	0.700000	1.700000	1.000000	32
i1	124.2546	3.4500000477	105.882353	1	6120.000000	0.700000	1.700000	1.000000	34
i1	124.4022	3.4500000477	94.736842	1	6840.000000	0.700000	1.700000	1.000000	38
i1	124.476	3.4500000477	90.000000	1	7200.000000	0.700000	1.700000	1.000000	40
i1	128.5326	3.4500000477	53.731343	1	12060.000000	0.700000	1.700000	1.000000	67
i1	128.457	3.4500000477	55.384615	1	11700.000000	0.700000	1.700000	1.000000	65
i1	128.3814	3.4500000477	57.142857	1	11340.000000	0.700000	1.700000	1.000000	63
i1	128.3058	3.4500000477	59.016393	1	10980.000000	0.700000	1.700000	1.000000	61
i1	128.2302	3.4500000477	61.016949	1	10620.000000	0.700000	1.700000	1.000000	59
i1	128.1546	3.4500000477	63.157895	1	10260.000000	0.700000	1.700000	1.000000	57
i1	128.079	3.4500000477	65.454545	1	9900.000000	0.700000	1.700000	1.000000	55
i1	128.0034	3.4500000477	67.924528	1	9540.000000	0.700000	1.700000	1.000000	53
i1	127.9278	3.4500000477	70.588235	1	9180.000000	0.700000	1.700000	1.000000	51
i1	127.8522	3.4500000477	73.469388	1	8820.000000	0.700000	1.700000	1.000000	49
i1	127.7766	3.4500000477	76.595745	1	8460.000000	0.700000	1.700000	1.000000	47
i1	127.701	3.4500000477	80.000000	1	8100.000000	0.700000	1.700000	1.000000	45
i1	127.6254	3.4500000477	83.720930	1	7740.000000	0.700000	1.700000	1.000000	43
i1	127.3986	3.4500000477	97.297297	1	6660.000000	0.700000	1.700000	1.000000	37
i1	127.1718	3.4500000477	116.129032	1	5580.000000	0.700000	1.700000	1.000000	31
i1	126.945	3.4500000477	144.000000	1	4500.000000	0.700000	1.700000	1.000000	25
i1	126.7182	3.4500000477	189.473684	1	3420.000000	0.700000	1.700000	1.000000	19
i1	126.4914	3.4500000477	276.923077	1	2340.000000	0.700000	1.700000	1.000000	13
i1	126.2646	3.4500000477	514.285714	1	1260.000000	0.700000	1.700000	1.000000	7
i1	126.0378	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	126.0756	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	126.2268	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	126.3024	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	126.4536	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	126.5292	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	126.6804	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	126.756	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	126.9072	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	126.9828	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	127.134	3.4500000477	120.000000	1	5400.000000	0.700000	1.700000	1.000000	30
i1	127.2096	3.4500000477	112.500000	1	5760.000000	0.700000	1.700000	1.000000	32
i1	127.3608	3.4500000477	100.000000	1	6480.000000	0.700000	1.700000	1.000000	36
i1	127.4364	3.4500000477	94.736842	1	6840.000000	0.700000	1.700000	1.000000	38
i1	127.5876	3.4500000477	85.714286	1	7560.000000	0.700000	1.700000	1.000000	42
i1	127.6632	3.4500000477	81.818182	1	7920.000000	0.700000	1.700000	1.000000	44
i1	127.7388	3.4500000477	78.260870	1	8280.000000	0.700000	1.700000	1.000000	46
i1	127.8144	3.4500000477	75.000000	1	8640.000000	0.700000	1.700000	1.000000	48
i1	127.89	3.4500000477	72.000000	1	9000.000000	0.700000	1.700000	1.000000	50
i1	127.9656	3.4500000477	69.230769	1	9360.000000	0.700000	1.700000	1.000000	52
i1	128.0412	3.4500000477	66.666667	1	9720.000000	0.700000	1.700000	1.000000	54
i1	128.1168	3.4500000477	64.285714	1	10080.000000	0.700000	1.700000	1.000000	56
i1	128.1924	3.4500000477	62.068966	1	10440.000000	0.700000	1.700000	1.000000	58
i1	128.268	3.4500000477	60.000000	1	10800.000000	0.700000	1.700000	1.000000	60
i1	128.3436	3.4500000477	58.064516	1	11160.000000	0.700000	1.700000	1.000000	62
i1	128.4192	3.4500000477	56.250000	1	11520.000000	0.700000	1.700000	1.000000	64
i1	128.4948	3.4500000477	54.545455	1	11880.000000	0.700000	1.700000	1.000000	66
i1	130.5867	3.4500000477	87.804878	1	7380.000000	0.700000	1.700000	1.000000	41
i1	130.3545	3.4500000477	102.857143	1	6300.000000	0.700000	1.700000	1.000000	35
i1	130.1223	3.4500000477	124.137931	1	5220.000000	0.700000	1.700000	1.000000	29
i1	129.8901	3.4500000477	156.521739	1	4140.000000	0.700000	1.700000	1.000000	23
i1	129.6579	3.4500000477	211.764706	1	3060.000000	0.700000	1.700000	1.000000	17
i1	129.4257	3.4500000477	327.272727	1	1980.000000	0.700000	1.700000	1.000000	11
i1	129.1935	3.4500000477	720.000000	1	900.000000	0.700000	1.700000	1.000000	5
i1	129.0387	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	129.1548	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	129.2322	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	129.387	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	129.4644	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	129.6192	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	129.6966	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	129.8514	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	129.9288	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	130.0836	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	130.161	3.4500000477	120.000000	1	5400.000000	0.700000	1.700000	1.000000	30
i1	130.3158	3.4500000477	105.882353	1	6120.000000	0.700000	1.700000	1.000000	34
i1	130.3932	3.4500000477	100.000000	1	6480.000000	0.700000	1.700000	1.000000	36
i1	130.548	3.4500000477	90.000000	1	7200.000000	0.700000	1.700000	1.000000	40
i1	130.6254	3.4500000477	85.714286	1	7560.000000	0.700000	1.700000	1.000000	42
i1	134.6532	3.4500000477	53.731343	1	12060.000000	0.700000	1.700000	1.000000	67
i1	134.574	3.4500000477	55.384615	1	11700.000000	0.700000	1.700000	1.000000	65
i1	134.4948	3.4500000477	57.142857	1	11340.000000	0.700000	1.700000	1.000000	63
i1	134.4156	3.4500000477	59.016393	1	10980.000000	0.700000	1.700000	1.000000	61
i1	134.3364	3.4500000477	61.016949	1	10620.000000	0.700000	1.700000	1.000000	59
i1	134.2572	3.4500000477	63.157895	1	10260.000000	0.700000	1.700000	1.000000	57
i1	134.178	3.4500000477	65.454545	1	9900.000000	0.700000	1.700000	1.000000	55
i1	134.0988	3.4500000477	67.924528	1	9540.000000	0.700000	1.700000	1.000000	53
i1	134.0196	3.4500000477	70.588235	1	9180.000000	0.700000	1.700000	1.000000	51
i1	133.9404	3.4500000477	73.469388	1	8820.000000	0.700000	1.700000	1.000000	49
i1	133.8612	3.4500000477	76.595745	1	8460.000000	0.700000	1.700000	1.000000	47
i1	133.782	3.4500000477	80.000000	1	8100.000000	0.700000	1.700000	1.000000	45
i1	133.5444	3.4500000477	92.307692	1	7020.000000	0.700000	1.700000	1.000000	39
i1	133.3068	3.4500000477	109.090909	1	5940.000000	0.700000	1.700000	1.000000	33
i1	133.0692	3.4500000477	133.333333	1	4860.000000	0.700000	1.700000	1.000000	27
i1	132.8316	3.4500000477	171.428571	1	3780.000000	0.700000	1.700000	1.000000	21
i1	132.594	3.4500000477	240.000000	1	2700.000000	0.700000	1.700000	1.000000	15
i1	132.3564	3.4500000477	400.000000	1	1620.000000	0.700000	1.700000	1.000000	9
i1	132.1188	3.4500000477	1200.000000	1	540.000000	0.700000	1.700000	1.000000	3
i1	132.0792	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	132.1584	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	132.3168	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	132.396	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	132.5544	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	132.6336	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	132.792	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	132.8712	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	133.0296	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	133.1088	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	133.2672	3.4500000477	112.500000	1	5760.000000	0.700000	1.700000	1.000000	32
i1	133.3464	3.4500000477	105.882353	1	6120.000000	0.700000	1.700000	1.000000	34
i1	133.5048	3.4500000477	94.736842	1	6840.000000	0.700000	1.700000	1.000000	38
i1	133.584	3.4500000477	90.000000	1	7200.000000	0.700000	1.700000	1.000000	40
i1	133.7424	3.4500000477	81.818182	1	7920.000000	0.700000	1.700000	1.000000	44
i1	133.8216	3.4500000477	78.260870	1	8280.000000	0.700000	1.700000	1.000000	46
i1	133.9008	3.4500000477	75.000000	1	8640.000000	0.700000	1.700000	1.000000	48
i1	133.98	3.4500000477	72.000000	1	9000.000000	0.700000	1.700000	1.000000	50
i1	134.0592	3.4500000477	69.230769	1	9360.000000	0.700000	1.700000	1.000000	52
i1	134.1384	3.4500000477	66.666667	1	9720.000000	0.700000	1.700000	1.000000	54
i1	134.2176	3.4500000477	64.285714	1	10080.000000	0.700000	1.700000	1.000000	56
i1	134.2968	3.4500000477	62.068966	1	10440.000000	0.700000	1.700000	1.000000	58
i1	134.376	3.4500000477	60.000000	1	10800.000000	0.700000	1.700000	1.000000	60
i1	134.4552	3.4500000477	58.064516	1	11160.000000	0.700000	1.700000	1.000000	62
i1	134.5344	3.4500000477	56.250000	1	11520.000000	0.700000	1.700000	1.000000	64
i1	134.6136	3.4500000477	54.545455	1	11880.000000	0.700000	1.700000	1.000000	66
i1	136.7415	3.4500000477	83.720930	1	7740.000000	0.700000	1.700000	1.000000	43
i1	136.4985	3.4500000477	97.297297	1	6660.000000	0.700000	1.700000	1.000000	37
i1	136.2555	3.4500000477	116.129032	1	5580.000000	0.700000	1.700000	1.000000	31
i1	136.0125	3.4500000477	144.000000	1	4500.000000	0.700000	1.700000	1.000000	25
i1	135.7695	3.4500000477	189.473684	1	3420.000000	0.700000	1.700000	1.000000	19
i1	135.5265	3.4500000477	276.923077	1	2340.000000	0.700000	1.700000	1.000000	13
i1	135.2835	3.4500000477	514.285714	1	1260.000000	0.700000	1.700000	1.000000	7
i1	135.0405	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	135.081	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	135.243	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	135.324	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	135.486	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	135.567	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	135.729	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	135.81	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	135.972	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	136.053	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	136.215	3.4500000477	120.000000	1	5400.000000	0.700000	1.700000	1.000000	30
i1	136.296	3.4500000477	112.500000	1	5760.000000	0.700000	1.700000	1.000000	32
i1	136.458	3.4500000477	100.000000	1	6480.000000	0.700000	1.700000	1.000000	36
i1	136.539	3.4500000477	94.736842	1	6840.000000	0.700000	1.700000	1.000000	38
i1	136.701	3.4500000477	85.714286	1	7560.000000	0.700000	1.700000	1.000000	42
i1	136.782	3.4500000477	81.818182	1	7920.000000	0.700000	1.700000	1.000000	44
i1	140.7738	3.4500000477	53.731343	1	12060.000000	0.700000	1.700000	1.000000	67
i1	140.691	3.4500000477	55.384615	1	11700.000000	0.700000	1.700000	1.000000	65
i1	140.6082	3.4500000477	57.142857	1	11340.000000	0.700000	1.700000	1.000000	63
i1	140.5254	3.4500000477	59.016393	1	10980.000000	0.700000	1.700000	1.000000	61
i1	140.4426	3.4500000477	61.016949	1	10620.000000	0.700000	1.700000	1.000000	59
i1	140.3598	3.4500000477	63.157895	1	10260.000000	0.700000	1.700000	1.000000	57
i1	140.277	3.4500000477	65.454545	1	9900.000000	0.700000	1.700000	1.000000	55
i1	140.1942	3.4500000477	67.924528	1	9540.000000	0.700000	1.700000	1.000000	53
i1	140.1114	3.4500000477	70.588235	1	9180.000000	0.700000	1.700000	1.000000	51
i1	140.0286	3.4500000477	73.469388	1	8820.000000	0.700000	1.700000	1.000000	49
i1	139.9458	3.4500000477	76.595745	1	8460.000000	0.700000	1.700000	1.000000	47
i1	139.6974	3.4500000477	87.804878	1	7380.000000	0.700000	1.700000	1.000000	41
i1	139.449	3.4500000477	102.857143	1	6300.000000	0.700000	1.700000	1.000000	35
i1	139.2006	3.4500000477	124.137931	1	5220.000000	0.700000	1.700000	1.000000	29
i1	138.9522	3.4500000477	156.521739	1	4140.000000	0.700000	1.700000	1.000000	23
i1	138.7038	3.4500000477	211.764706	1	3060.000000	0.700000	1.700000	1.000000	17
i1	138.4554	3.4500000477	327.272727	1	1980.000000	0.700000	1.700000	1.000000	11
i1	138.207	3.4500000477	720.000000	1	900.000000	0.700000	1.700000	1.000000	5
i1	138.0414	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	138.1656	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	138.2484	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	138.414	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	138.4968	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	138.6624	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	138.7452	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	138.9108	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	138.9936	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	139.1592	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	139.242	3.4500000477	120.000000	1	5400.000000	0.700000	1.700000	1.000000	30
i1	139.4076	3.4500000477	105.882353	1	6120.000000	0.700000	1.700000	1.000000	34
i1	139.4904	3.4500000477	100.000000	1	6480.000000	0.700000	1.700000	1.000000	36
i1	139.656	3.4500000477	90.000000	1	7200.000000	0.700000	1.700000	1.000000	40
i1	139.7388	3.4500000477	85.714286	1	7560.000000	0.700000	1.700000	1.000000	42
i1	139.9044	3.4500000477	78.260870	1	8280.000000	0.700000	1.700000	1.000000	46
i1	139.9872	3.4500000477	75.000000	1	8640.000000	0.700000	1.700000	1.000000	48
i1	140.07	3.4500000477	72.000000	1	9000.000000	0.700000	1.700000	1.000000	50
i1	140.1528	3.4500000477	69.230769	1	9360.000000	0.700000	1.700000	1.000000	52
i1	140.2356	3.4500000477	66.666667	1	9720.000000	0.700000	1.700000	1.000000	54
i1	140.3184	3.4500000477	64.285714	1	10080.000000	0.700000	1.700000	1.000000	56
i1	140.4012	3.4500000477	62.068966	1	10440.000000	0.700000	1.700000	1.000000	58
i1	140.484	3.4500000477	60.000000	1	10800.000000	0.700000	1.700000	1.000000	60
i1	140.5668	3.4500000477	58.064516	1	11160.000000	0.700000	1.700000	1.000000	62
i1	140.6496	3.4500000477	56.250000	1	11520.000000	0.700000	1.700000	1.000000	64
i1	140.7324	3.4500000477	54.545455	1	11880.000000	0.700000	1.700000	1.000000	66
i1	142.9035	3.4500000477	80.000000	1	8100.000000	0.700000	1.700000	1.000000	45
i1	142.6497	3.4500000477	92.307692	1	7020.000000	0.700000	1.700000	1.000000	39
i1	142.3959	3.4500000477	109.090909	1	5940.000000	0.700000	1.700000	1.000000	33
i1	142.1421	3.4500000477	133.333333	1	4860.000000	0.700000	1.700000	1.000000	27
i1	141.8883	3.4500000477	171.428571	1	3780.000000	0.700000	1.700000	1.000000	21
i1	141.6345	3.4500000477	240.000000	1	2700.000000	0.700000	1.700000	1.000000	15
i1	141.3807	3.4500000477	400.000000	1	1620.000000	0.700000	1.700000	1.000000	9
i1	141.1269	3.4500000477	1200.000000	1	540.000000	0.700000	1.700000	1.000000	3
i1	141.0846	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	141.1692	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	141.3384	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	141.423	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	141.5922	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	141.6768	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	141.846	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	141.9306	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	142.0998	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	142.1844	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	142.3536	3.4500000477	112.500000	1	5760.000000	0.700000	1.700000	1.000000	32
i1	142.4382	3.4500000477	105.882353	1	6120.000000	0.700000	1.700000	1.000000	34
i1	142.6074	3.4500000477	94.736842	1	6840.000000	0.700000	1.700000	1.000000	38
i1	142.692	3.4500000477	90.000000	1	7200.000000	0.700000	1.700000	1.000000	40
i1	142.8612	3.4500000477	81.818182	1	7920.000000	0.700000	1.700000	1.000000	44
i1	142.9458	3.4500000477	78.260870	1	8280.000000	0.700000	1.700000	1.000000	46
i1	146.8944	3.4500000477	53.731343	1	12060.000000	0.700000	1.700000	1.000000	67
i1	146.808	3.4500000477	55.384615	1	11700.000000	0.700000	1.700000	1.000000	65
i1	146.7216	3.4500000477	57.142857	1	11340.000000	0.700000	1.700000	1.000000	63
i1	146.6352	3.4500000477	59.016393	1	10980.000000	0.700000	1.700000	1.000000	61
i1	146.5488	3.4500000477	61.016949	1	10620.000000	0.700000	1.700000	1.000000	59
i1	146.4624	3.4500000477	63.157895	1	10260.000000	0.700000	1.700000	1.000000	57
i1	146.376	3.4500000477	65.454545	1	9900.000000	0.700000	1.700000	1.000000	55
i1	146.2896	3.4500000477	67.924528	1	9540.000000	0.700000	1.700000	1.000000	53
i1	146.2032	3.4500000477	70.588235	1	9180.000000	0.700000	1.700000	1.000000	51
i1	146.1168	3.4500000477	73.469388	1	8820.000000	0.700000	1.700000	1.000000	49
i1	145.8576	3.4500000477	83.720930	1	7740.000000	0.700000	1.700000	1.000000	43
i1	145.5984	3.4500000477	97.297297	1	6660.000000	0.700000	1.700000	1.000000	37
i1	145.3392	3.4500000477	116.129032	1	5580.000000	0.700000	1.700000	1.000000	31
i1	145.08	3.4500000477	144.000000	1	4500.000000	0.700000	1.700000	1.000000	25
i1	144.8208	3.4500000477	189.473684	1	3420.000000	0.700000	1.700000	1.000000	19
i1	144.5616	3.4500000477	276.923077	1	2340.000000	0.700000	1.700000	1.000000	13
i1	144.3024	3.4500000477	514.285714	1	1260.000000	0.700000	1.700000	1.000000	7
i1	144.0432	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	144.0864	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	144.2592	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	144.3456	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	144.5184	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	144.6048	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	144.7776	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	144.864	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	145.0368	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	145.1232	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	145.296	3.4500000477	120.000000	1	5400.000000	0.700000	1.700000	1.000000	30
i1	145.3824	3.4500000477	112.500000	1	5760.000000	0.700000	1.700000	1.000000	32
i1	145.5552	3.4500000477	100.000000	1	6480.000000	0.700000	1.700000	1.000000	36
i1	145.6416	3.4500000477	94.736842	1	6840.000000	0.700000	1.700000	1.000000	38
i1	145.8144	3.4500000477	85.714286	1	7560.000000	0.700000	1.700000	1.000000	42
i1	145.9008	3.4500000477	81.818182	1	7920.000000	0.700000	1.700000	1.000000	44
i1	146.0736	3.4500000477	75.000000	1	8640.000000	0.700000	1.700000	1.000000	48
i1	146.16	3.4500000477	72.000000	1	9000.000000	0.700000	1.700000	1.000000	50
i1	146.2464	3.4500000477	69.230769	1	9360.000000	0.700000	1.700000	1.000000	52
i1	146.3328	3.4500000477	66.666667	1	9720.000000	0.700000	1.700000	1.000000	54
i1	146.4192	3.4500000477	64.285714	1	10080.000000	0.700000	1.700000	1.000000	56
i1	146.5056	3.4500000477	62.068966	1	10440.000000	0.700000	1.700000	1.000000	58
i1	146.592	3.4500000477	60.000000	1	10800.000000	0.700000	1.700000	1.000000	60
i1	146.6784	3.4500000477	58.064516	1	11160.000000	0.700000	1.700000	1.000000	62
i1	146.7648	3.4500000477	56.250000	1	11520.000000	0.700000	1.700000	1.000000	64
i1	146.8512	3.4500000477	54.545455	1	11880.000000	0.700000	1.700000	1.000000	66
i1	149.0727	3.4500000477	76.595745	1	8460.000000	0.700000	1.700000	1.000000	47
i1	148.8081	3.4500000477	87.804878	1	7380.000000	0.700000	1.700000	1.000000	41
i1	148.5435	3.4500000477	102.857143	1	6300.000000	0.700000	1.700000	1.000000	35
i1	148.2789	3.4500000477	124.137931	1	5220.000000	0.700000	1.700000	1.000000	29
i1	148.0143	3.4500000477	156.521739	1	4140.000000	0.700000	1.700000	1.000000	23
i1	147.7497	3.4500000477	211.764706	1	3060.000000	0.700000	1.700000	1.000000	17
i1	147.4851	3.4500000477	327.272727	1	1980.000000	0.700000	1.700000	1.000000	11
i1	147.2205	3.4500000477	720.000000	1	900.000000	0.700000	1.700000	1.000000	5
i1	147.0441	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	147.1764	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	147.2646	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	147.441	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	147.5292	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	147.7056	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	147.7938	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	147.9702	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	148.0584	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	148.2348	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	148.323	3.4500000477	120.000000	1	5400.000000	0.700000	1.700000	1.000000	30
i1	148.4994	3.4500000477	105.882353	1	6120.000000	0.700000	1.700000	1.000000	34
i1	148.5876	3.4500000477	100.000000	1	6480.000000	0.700000	1.700000	1.000000	36
i1	148.764	3.4500000477	90.000000	1	7200.000000	0.700000	1.700000	1.000000	40
i1	148.8522	3.4500000477	85.714286	1	7560.000000	0.700000	1.700000	1.000000	42
i1	149.0286	3.4500000477	78.260870	1	8280.000000	0.700000	1.700000	1.000000	46
i1	149.1168	3.4500000477	75.000000	1	8640.000000	0.700000	1.700000	1.000000	48
i1	153.015	3.4500000477	53.731343	1	12060.000000	0.700000	1.700000	1.000000	67
i1	152.925	3.4500000477	55.384615	1	11700.000000	0.700000	1.700000	1.000000	65
i1	152.835	3.4500000477	57.142857	1	11340.000000	0.700000	1.700000	1.000000	63
i1	152.745	3.4500000477	59.016393	1	10980.000000	0.700000	1.700000	1.000000	61
i1	152.655	3.4500000477	61.016949	1	10620.000000	0.700000	1.700000	1.000000	59
i1	152.565	3.4500000477	63.157895	1	10260.000000	0.700000	1.700000	1.000000	57
i1	152.475	3.4500000477	65.454545	1	9900.000000	0.700000	1.700000	1.000000	55
i1	152.385	3.4500000477	67.924528	1	9540.000000	0.700000	1.700000	1.000000	53
i1	152.295	3.4500000477	70.588235	1	9180.000000	0.700000	1.700000	1.000000	51
i1	152.025	3.4500000477	80.000000	1	8100.000000	0.700000	1.700000	1.000000	45
i1	151.755	3.4500000477	92.307692	1	7020.000000	0.700000	1.700000	1.000000	39
i1	151.485	3.4500000477	109.090909	1	5940.000000	0.700000	1.700000	1.000000	33
i1	151.215	3.4500000477	133.333333	1	4860.000000	0.700000	1.700000	1.000000	27
i1	150.945	3.4500000477	171.428571	1	3780.000000	0.700000	1.700000	1.000000	21
i1	150.675	3.4500000477	240.000000	1	2700.000000	0.700000	1.700000	1.000000	15
i1	150.405	3.4500000477	400.000000	1	1620.000000	0.700000	1.700000	1.000000	9
i1	150.135	3.4500000477	1200.000000	1	540.000000	0.700000	1.700000	1.000000	3
i1	150.09	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	150.18	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	150.36	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	150.45	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	150.63	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	150.72	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	150.9	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	150.99	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	151.17	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	151.26	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	151.44	3.4500000477	112.500000	1	5760.000000	0.700000	1.700000	1.000000	32
i1	151.53	3.4500000477	105.882353	1	6120.000000	0.700000	1.700000	1.000000	34
i1	151.71	3.4500000477	94.736842	1	6840.000000	0.700000	1.700000	1.000000	38
i1	151.8	3.4500000477	90.000000	1	7200.000000	0.700000	1.700000	1.000000	40
i1	151.98	3.4500000477	81.818182	1	7920.000000	0.700000	1.700000	1.000000	44
i1	152.07	3.4500000477	78.260870	1	8280.000000	0.700000	1.700000	1.000000	46
i1	152.25	3.4500000477	72.000000	1	9000.000000	0.700000	1.700000	1.000000	50
i1	152.34	3.4500000477	69.230769	1	9360.000000	0.700000	1.700000	1.000000	52
i1	152.43	3.4500000477	66.666667	1	9720.000000	0.700000	1.700000	1.000000	54
i1	152.52	3.4500000477	64.285714	1	10080.000000	0.700000	1.700000	1.000000	56
i1	152.61	3.4500000477	62.068966	1	10440.000000	0.700000	1.700000	1.000000	58
i1	152.7	3.4500000477	60.000000	1	10800.000000	0.700000	1.700000	1.000000	60
i1	152.79	3.4500000477	58.064516	1	11160.000000	0.700000	1.700000	1.000000	62
i1	152.88	3.4500000477	56.250000	1	11520.000000	0.700000	1.700000	1.000000	64
i1	152.97	3.4500000477	54.545455	1	11880.000000	0.700000	1.700000	1.000000	66
i1	155.2491	3.4500000477	73.469388	1	8820.000000	0.700000	1.700000	1.000000	49
i1	154.9737	3.4500000477	83.720930	1	7740.000000	0.700000	1.700000	1.000000	43
i1	154.6983	3.4500000477	97.297297	1	6660.000000	0.700000	1.700000	1.000000	37
i1	154.4229	3.4500000477	116.129032	1	5580.000000	0.700000	1.700000	1.000000	31
i1	154.1475	3.4500000477	144.000000	1	4500.000000	0.700000	1.700000	1.000000	25
i1	153.8721	3.4500000477	189.473684	1	3420.000000	0.700000	1.700000	1.000000	19
i1	153.5967	3.4500000477	276.923077	1	2340.000000	0.700000	1.700000	1.000000	13
i1	153.3213	3.4500000477	514.285714	1	1260.000000	0.700000	1.700000	1.000000	7
i1	153.0459	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	153.0918	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	153.2754	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	153.3672	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	153.5508	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	153.6426	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	153.8262	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	153.918	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	154.1016	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	154.1934	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	154.377	3.4500000477	120.000000	1	5400.000000	0.700000	1.700000	1.000000	30
i1	154.4688	3.4500000477	112.500000	1	5760.000000	0.700000	1.700000	1.000000	32
i1	154.6524	3.4500000477	100.000000	1	6480.000000	0.700000	1.700000	1.000000	36
i1	154.7442	3.4500000477	94.736842	1	6840.000000	0.700000	1.700000	1.000000	38
i1	154.9278	3.4500000477	85.714286	1	7560.000000	0.700000	1.700000	1.000000	42
i1	155.0196	3.4500000477	81.818182	1	7920.000000	0.700000	1.700000	1.000000	44
i1	155.2032	3.4500000477	75.000000	1	8640.000000	0.700000	1.700000	1.000000	48
i1	155.295	3.4500000477	72.000000	1	9000.000000	0.700000	1.700000	1.000000	50
i1	159.1356	3.4500000477	53.731343	1	12060.000000	0.700000	1.700000	1.000000	67
i1	159.042	3.4500000477	55.384615	1	11700.000000	0.700000	1.700000	1.000000	65
i1	158.9484	3.4500000477	57.142857	1	11340.000000	0.700000	1.700000	1.000000	63
i1	158.8548	3.4500000477	59.016393	1	10980.000000	0.700000	1.700000	1.000000	61
i1	158.7612	3.4500000477	61.016949	1	10620.000000	0.700000	1.700000	1.000000	59
i1	158.6676	3.4500000477	63.157895	1	10260.000000	0.700000	1.700000	1.000000	57
i1	158.574	3.4500000477	65.454545	1	9900.000000	0.700000	1.700000	1.000000	55
i1	158.4804	3.4500000477	67.924528	1	9540.000000	0.700000	1.700000	1.000000	53
i1	158.1996	3.4500000477	76.595745	1	8460.000000	0.700000	1.700000	1.000000	47
i1	157.9188	3.4500000477	87.804878	1	7380.000000	0.700000	1.700000	1.000000	41
i1	157.638	3.4500000477	102.857143	1	6300.000000	0.700000	1.700000	1.000000	35
i1	157.3572	3.4500000477	124.137931	1	5220.000000	0.700000	1.700000	1.000000	29
i1	157.0764	3.4500000477	156.521739	1	4140.000000	0.700000	1.700000	1.000000	23
i1	156.7956	3.4500000477	211.764706	1	3060.000000	0.700000	1.700000	1.000000	17
i1	156.5148	3.4500000477	327.272727	1	1980.000000	0.700000	1.700000	1.000000	11
i1	156.234	3.4500000477	720.000000	1	900.000000	0.700000	1.700000	1.000000	5
i1	156.0468	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	156.1872	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	156.2808	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	156.468	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	156.5616	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	156.7488	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	156.8424	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	157.0296	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	157.1232	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	157.3104	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	157.404	3.4500000477	120.000000	1	5400.000000	0.700000	1.700000	1.000000	30
i1	157.5912	3.4500000477	105.882353	1	6120.000000	0.700000	1.700000	1.000000	34
i1	157.6848	3.4500000477	100.000000	1	6480.000000	0.700000	1.700000	1.000000	36
i1	157.872	3.4500000477	90.000000	1	7200.000000	0.700000	1.700000	1.000000	40
i1	157.9656	3.4500000477	85.714286	1	7560.000000	0.700000	1.700000	1.000000	42
i1	158.1528	3.4500000477	78.260870	1	8280.000000	0.700000	1.700000	1.000000	46
i1	158.2464	3.4500000477	75.000000	1	8640.000000	0.700000	1.700000	1.000000	48
i1	158.4336	3.4500000477	69.230769	1	9360.000000	0.700000	1.700000	1.000000	52
i1	158.5272	3.4500000477	66.666667	1	9720.000000	0.700000	1.700000	1.000000	54
i1	158.6208	3.4500000477	64.285714	1	10080.000000	0.700000	1.700000	1.000000	56
i1	158.7144	3.4500000477	62.068966	1	10440.000000	0.700000	1.700000	1.000000	58
i1	158.808	3.4500000477	60.000000	1	10800.000000	0.700000	1.700000	1.000000	60
i1	158.9016	3.4500000477	58.064516	1	11160.000000	0.700000	1.700000	1.000000	62
i1	158.9952	3.4500000477	56.250000	1	11520.000000	0.700000	1.700000	1.000000	64
i1	159.0888	3.4500000477	54.545455	1	11880.000000	0.700000	1.700000	1.000000	66
i1	161.4327	3.4500000477	70.588235	1	9180.000000	0.700000	1.700000	1.000000	51
i1	161.1465	3.4500000477	80.000000	1	8100.000000	0.700000	1.700000	1.000000	45
i1	160.8603	3.4500000477	92.307692	1	7020.000000	0.700000	1.700000	1.000000	39
i1	160.5741	3.4500000477	109.090909	1	5940.000000	0.700000	1.700000	1.000000	33
i1	160.2879	3.4500000477	133.333333	1	4860.000000	0.700000	1.700000	1.000000	27
i1	160.0017	3.4500000477	171.428571	1	3780.000000	0.700000	1.700000	1.000000	21
i1	159.7155	3.4500000477	240.000000	1	2700.000000	0.700000	1.700000	1.000000	15
i1	159.4293	3.4500000477	400.000000	1	1620.000000	0.700000	1.700000	1.000000	9
i1	159.1431	3.4500000477	1200.000000	1	540.000000	0.700000	1.700000	1.000000	3
i1	159.0954	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	159.1908	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	159.3816	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	159.477	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	159.6678	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	159.7632	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	159.954	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	160.0494	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	160.2402	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	160.3356	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	160.5264	3.4500000477	112.500000	1	5760.000000	0.700000	1.700000	1.000000	32
i1	160.6218	3.4500000477	105.882353	1	6120.000000	0.700000	1.700000	1.000000	34
i1	160.8126	3.4500000477	94.736842	1	6840.000000	0.700000	1.700000	1.000000	38
i1	160.908	3.4500000477	90.000000	1	7200.000000	0.700000	1.700000	1.000000	40
i1	161.0988	3.4500000477	81.818182	1	7920.000000	0.700000	1.700000	1.000000	44
i1	161.1942	3.4500000477	78.260870	1	8280.000000	0.700000	1.700000	1.000000	46
i1	161.385	3.4500000477	72.000000	1	9000.000000	0.700000	1.700000	1.000000	50
i1	161.4804	3.4500000477	69.230769	1	9360.000000	0.700000	1.700000	1.000000	52
i1	165.2562	3.4500000477	53.731343	1	12060.000000	0.700000	1.700000	1.000000	67
i1	165.159	3.4500000477	55.384615	1	11700.000000	0.700000	1.700000	1.000000	65
i1	165.0618	3.4500000477	57.142857	1	11340.000000	0.700000	1.700000	1.000000	63
i1	164.9646	3.4500000477	59.016393	1	10980.000000	0.700000	1.700000	1.000000	61
i1	164.8674	3.4500000477	61.016949	1	10620.000000	0.700000	1.700000	1.000000	59
i1	164.7702	3.4500000477	63.157895	1	10260.000000	0.700000	1.700000	1.000000	57
i1	164.673	3.4500000477	65.454545	1	9900.000000	0.700000	1.700000	1.000000	55
i1	164.3814	3.4500000477	73.469388	1	8820.000000	0.700000	1.700000	1.000000	49
i1	164.0898	3.4500000477	83.720930	1	7740.000000	0.700000	1.700000	1.000000	43
i1	163.7982	3.4500000477	97.297297	1	6660.000000	0.700000	1.700000	1.000000	37
i1	163.5066	3.4500000477	116.129032	1	5580.000000	0.700000	1.700000	1.000000	31
i1	163.215	3.4500000477	144.000000	1	4500.000000	0.700000	1.700000	1.000000	25
i1	162.9234	3.4500000477	189.473684	1	3420.000000	0.700000	1.700000	1.000000	19
i1	162.6318	3.4500000477	276.923077	1	2340.000000	0.700000	1.700000	1.000000	13
i1	162.3402	3.4500000477	514.285714	1	1260.000000	0.700000	1.700000	1.000000	7
i1	162.0486	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	162.0972	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	162.2916	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	162.3888	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	162.5832	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	162.6804	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	162.8748	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	162.972	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	163.1664	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	163.2636	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	163.458	3.4500000477	120.000000	1	5400.000000	0.700000	1.700000	1.000000	30
i1	163.5552	3.4500000477	112.500000	1	5760.000000	0.700000	1.700000	1.000000	32
i1	163.7496	3.4500000477	100.000000	1	6480.000000	0.700000	1.700000	1.000000	36
i1	163.8468	3.4500000477	94.736842	1	6840.000000	0.700000	1.700000	1.000000	38
i1	164.0412	3.4500000477	85.714286	1	7560.000000	0.700000	1.700000	1.000000	42
i1	164.1384	3.4500000477	81.818182	1	7920.000000	0.700000	1.700000	1.000000	44
i1	164.3328	3.4500000477	75.000000	1	8640.000000	0.700000	1.700000	1.000000	48
i1	164.43	3.4500000477	72.000000	1	9000.000000	0.700000	1.700000	1.000000	50
i1	164.6244	3.4500000477	66.666667	1	9720.000000	0.700000	1.700000	1.000000	54
i1	164.7216	3.4500000477	64.285714	1	10080.000000	0.700000	1.700000	1.000000	56
i1	164.8188	3.4500000477	62.068966	1	10440.000000	0.700000	1.700000	1.000000	58
i1	164.916	3.4500000477	60.000000	1	10800.000000	0.700000	1.700000	1.000000	60
i1	165.0132	3.4500000477	58.064516	1	11160.000000	0.700000	1.700000	1.000000	62
i1	165.1104	3.4500000477	56.250000	1	11520.000000	0.700000	1.700000	1.000000	64
i1	165.2076	3.4500000477	54.545455	1	11880.000000	0.700000	1.700000	1.000000	66
i1	167.6235	3.4500000477	67.924528	1	9540.000000	0.700000	1.700000	1.000000	53
i1	167.3265	3.4500000477	76.595745	1	8460.000000	0.700000	1.700000	1.000000	47
i1	167.0295	3.4500000477	87.804878	1	7380.000000	0.700000	1.700000	1.000000	41
i1	166.7325	3.4500000477	102.857143	1	6300.000000	0.700000	1.700000	1.000000	35
i1	166.4355	3.4500000477	124.137931	1	5220.000000	0.700000	1.700000	1.000000	29
i1	166.1385	3.4500000477	156.521739	1	4140.000000	0.700000	1.700000	1.000000	23
i1	165.8415	3.4500000477	211.764706	1	3060.000000	0.700000	1.700000	1.000000	17
i1	165.5445	3.4500000477	327.272727	1	1980.000000	0.700000	1.700000	1.000000	11
i1	165.2475	3.4500000477	720.000000	1	900.000000	0.700000	1.700000	1.000000	5
i1	165.0495	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	165.198	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	165.297	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	165.495	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	165.594	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	165.792	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	165.891	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	166.089	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	166.188	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	166.386	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	166.485	3.4500000477	120.000000	1	5400.000000	0.700000	1.700000	1.000000	30
i1	166.683	3.4500000477	105.882353	1	6120.000000	0.700000	1.700000	1.000000	34
i1	166.782	3.4500000477	100.000000	1	6480.000000	0.700000	1.700000	1.000000	36
i1	166.98	3.4500000477	90.000000	1	7200.000000	0.700000	1.700000	1.000000	40
i1	167.079	3.4500000477	85.714286	1	7560.000000	0.700000	1.700000	1.000000	42
i1	167.277	3.4500000477	78.260870	1	8280.000000	0.700000	1.700000	1.000000	46
i1	167.376	3.4500000477	75.000000	1	8640.000000	0.700000	1.700000	1.000000	48
i1	167.574	3.4500000477	69.230769	1	9360.000000	0.700000	1.700000	1.000000	52
i1	167.673	3.4500000477	66.666667	1	9720.000000	0.700000	1.700000	1.000000	54
i1	171.3768	3.4500000477	53.731343	1	12060.000000	0.700000	1.700000	1.000000	67
i1	171.276	3.4500000477	55.384615	1	11700.000000	0.700000	1.700000	1.000000	65
i1	171.1752	3.4500000477	57.142857	1	11340.000000	0.700000	1.700000	1.000000	63
i1	171.0744	3.4500000477	59.016393	1	10980.000000	0.700000	1.700000	1.000000	61
i1	170.9736	3.4500000477	61.016949	1	10620.000000	0.700000	1.700000	1.000000	59
i1	170.8728	3.4500000477	63.157895	1	10260.000000	0.700000	1.700000	1.000000	57
i1	170.5704	3.4500000477	70.588235	1	9180.000000	0.700000	1.700000	1.000000	51
i1	170.268	3.4500000477	80.000000	1	8100.000000	0.700000	1.700000	1.000000	45
i1	169.9656	3.4500000477	92.307692	1	7020.000000	0.700000	1.700000	1.000000	39
i1	169.6632	3.4500000477	109.090909	1	5940.000000	0.700000	1.700000	1.000000	33
i1	169.3608	3.4500000477	133.333333	1	4860.000000	0.700000	1.700000	1.000000	27
i1	169.0584	3.4500000477	171.428571	1	3780.000000	0.700000	1.700000	1.000000	21
i1	168.756	3.4500000477	240.000000	1	2700.000000	0.700000	1.700000	1.000000	15
i1	168.4536	3.4500000477	400.000000	1	1620.000000	0.700000	1.700000	1.000000	9
i1	168.1512	3.4500000477	1200.000000	1	540.000000	0.700000	1.700000	1.000000	3
i1	168.1008	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	168.2016	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	168.4032	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	168.504	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	168.7056	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	168.8064	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	169.008	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	169.1088	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	169.3104	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	169.4112	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	169.6128	3.4500000477	112.500000	1	5760.000000	0.700000	1.700000	1.000000	32
i1	169.7136	3.4500000477	105.882353	1	6120.000000	0.700000	1.700000	1.000000	34
i1	169.9152	3.4500000477	94.736842	1	6840.000000	0.700000	1.700000	1.000000	38
i1	170.016	3.4500000477	90.000000	1	7200.000000	0.700000	1.700000	1.000000	40
i1	170.2176	3.4500000477	81.818182	1	7920.000000	0.700000	1.700000	1.000000	44
i1	170.3184	3.4500000477	78.260870	1	8280.000000	0.700000	1.700000	1.000000	46
i1	170.52	3.4500000477	72.000000	1	9000.000000	0.700000	1.700000	1.000000	50
i1	170.6208	3.4500000477	69.230769	1	9360.000000	0.700000	1.700000	1.000000	52
i1	170.8224	3.4500000477	64.285714	1	10080.000000	0.700000	1.700000	1.000000	56
i1	170.9232	3.4500000477	62.068966	1	10440.000000	0.700000	1.700000	1.000000	58
i1	171.024	3.4500000477	60.000000	1	10800.000000	0.700000	1.700000	1.000000	60
i1	171.1248	3.4500000477	58.064516	1	11160.000000	0.700000	1.700000	1.000000	62
i1	171.2256	3.4500000477	56.250000	1	11520.000000	0.700000	1.700000	1.000000	64
i1	171.3264	3.4500000477	54.545455	1	11880.000000	0.700000	1.700000	1.000000	66
i1	173.8215	3.4500000477	65.454545	1	9900.000000	0.700000	1.700000	1.000000	55
i1	173.5137	3.4500000477	73.469388	1	8820.000000	0.700000	1.700000	1.000000	49
i1	173.2059	3.4500000477	83.720930	1	7740.000000	0.700000	1.700000	1.000000	43
i1	172.8981	3.4500000477	97.297297	1	6660.000000	0.700000	1.700000	1.000000	37
i1	172.5903	3.4500000477	116.129032	1	5580.000000	0.700000	1.700000	1.000000	31
i1	172.2825	3.4500000477	144.000000	1	4500.000000	0.700000	1.700000	1.000000	25
i1	171.9747	3.4500000477	189.473684	1	3420.000000	0.700000	1.700000	1.000000	19
i1	171.6669	3.4500000477	276.923077	1	2340.000000	0.700000	1.700000	1.000000	13
i1	171.3591	3.4500000477	514.285714	1	1260.000000	0.700000	1.700000	1.000000	7
i1	171.0513	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	171.1026	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	171.3078	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	171.4104	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	171.6156	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	171.7182	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	171.9234	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	172.026	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	172.2312	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	172.3338	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	172.539	3.4500000477	120.000000	1	5400.000000	0.700000	1.700000	1.000000	30
i1	172.6416	3.4500000477	112.500000	1	5760.000000	0.700000	1.700000	1.000000	32
i1	172.8468	3.4500000477	100.000000	1	6480.000000	0.700000	1.700000	1.000000	36
i1	172.9494	3.4500000477	94.736842	1	6840.000000	0.700000	1.700000	1.000000	38
i1	173.1546	3.4500000477	85.714286	1	7560.000000	0.700000	1.700000	1.000000	42
i1	173.2572	3.4500000477	81.818182	1	7920.000000	0.700000	1.700000	1.000000	44
i1	173.4624	3.4500000477	75.000000	1	8640.000000	0.700000	1.700000	1.000000	48
i1	173.565	3.4500000477	72.000000	1	9000.000000	0.700000	1.700000	1.000000	50
i1	173.7702	3.4500000477	66.666667	1	9720.000000	0.700000	1.700000	1.000000	54
i1	173.8728	3.4500000477	64.285714	1	10080.000000	0.700000	1.700000	1.000000	56
i1	177.4974	3.4500000477	53.731343	1	12060.000000	0.700000	1.700000	1.000000	67
i1	177.393	3.4500000477	55.384615	1	11700.000000	0.700000	1.700000	1.000000	65
i1	177.2886	3.4500000477	57.142857	1	11340.000000	0.700000	1.700000	1.000000	63
i1	177.1842	3.4500000477	59.016393	1	10980.000000	0.700000	1.700000	1.000000	61
i1	177.0798	3.4500000477	61.016949	1	10620.000000	0.700000	1.700000	1.000000	59
i1	176.7666	3.4500000477	67.924528	1	9540.000000	0.700000	1.700000	1.000000	53
i1	176.4534	3.4500000477	76.595745	1	8460.000000	0.700000	1.700000	1.000000	47
i1	176.1402	3.4500000477	87.804878	1	7380.000000	0.700000	1.700000	1.000000	41
i1	175.827	3.4500000477	102.857143	1	6300.000000	0.700000	1.700000	1.000000	35
i1	175.5138	3.4500000477	124.137931	1	5220.000000	0.700000	1.700000	1.000000	29
i1	175.2006	3.4500000477	156.521739	1	4140.000000	0.700000	1.700000	1.000000	23
i1	174.8874	3.4500000477	211.764706	1	3060.000000	0.700000	1.700000	1.000000	17
i1	174.5742	3.4500000477	327.272727	1	1980.000000	0.700000	1.700000	1.000000	11
i1	174.261	3.4500000477	720.000000	1	900.000000	0.700000	1.700000	1.000000	5
i1	174.0522	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	174.2088	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	174.3132	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	174.522	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	174.6264	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	174.8352	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	174.9396	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	175.1484	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	175.2528	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	175.4616	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	175.566	3.4500000477	120.000000	1	5400.000000	0.700000	1.700000	1.000000	30
i1	175.7748	3.4500000477	105.882353	1	6120.000000	0.700000	1.700000	1.000000	34
i1	175.8792	3.4500000477	100.000000	1	6480.000000	0.700000	1.700000	1.000000	36
i1	176.088	3.4500000477	90.000000	1	7200.000000	0.700000	1.700000	1.000000	40
i1	176.1924	3.4500000477	85.714286	1	7560.000000	0.700000	1.700000	1.000000	42
i1	176.4012	3.4500000477	78.260870	1	8280.000000	0.700000	1.700000	1.000000	46
i1	176.5056	3.4500000477	75.000000	1	8640.000000	0.700000	1.700000	1.000000	48
i1	176.7144	3.4500000477	69.230769	1	9360.000000	0.700000	1.700000	1.000000	52
i1	176.8188	3.4500000477	66.666667	1	9720.000000	0.700000	1.700000	1.000000	54
i1	177.0276	3.4500000477	62.068966	1	10440.000000	0.700000	1.700000	1.000000	58
i1	177.132	3.4500000477	60.000000	1	10800.000000	0.700000	1.700000	1.000000	60
i1	177.2364	3.4500000477	58.064516	1	11160.000000	0.700000	1.700000	1.000000	62
i1	177.3408	3.4500000477	56.250000	1	11520.000000	0.700000	1.700000	1.000000	64
i1	177.4452	3.4500000477	54.545455	1	11880.000000	0.700000	1.700000	1.000000	66
i1	180.0267	3.4500000477	63.157895	1	10260.000000	0.700000	1.700000	1.000000	57
i1	179.7081	3.4500000477	70.588235	1	9180.000000	0.700000	1.700000	1.000000	51
i1	179.3895	3.4500000477	80.000000	1	8100.000000	0.700000	1.700000	1.000000	45
i1	179.0709	3.4500000477	92.307692	1	7020.000000	0.700000	1.700000	1.000000	39
i1	178.7523	3.4500000477	109.090909	1	5940.000000	0.700000	1.700000	1.000000	33
i1	178.4337	3.4500000477	133.333333	1	4860.000000	0.700000	1.700000	1.000000	27
i1	178.1151	3.4500000477	171.428571	1	3780.000000	0.700000	1.700000	1.000000	21
i1	177.7965	3.4500000477	240.000000	1	2700.000000	0.700000	1.700000	1.000000	15
i1	177.4779	3.4500000477	400.000000	1	1620.000000	0.700000	1.700000	1.000000	9
i1	177.1593	3.4500000477	1200.000000	1	540.000000	0.700000	1.700000	1.000000	3
i1	177.1062	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	177.2124	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	177.4248	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	177.531	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	177.7434	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	177.8496	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	178.062	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	178.1682	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	178.3806	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	178.4868	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	178.6992	3.4500000477	112.500000	1	5760.000000	0.700000	1.700000	1.000000	32
i1	178.8054	3.4500000477	105.882353	1	6120.000000	0.700000	1.700000	1.000000	34
i1	179.0178	3.4500000477	94.736842	1	6840.000000	0.700000	1.700000	1.000000	38
i1	179.124	3.4500000477	90.000000	1	7200.000000	0.700000	1.700000	1.000000	40
i1	179.3364	3.4500000477	81.818182	1	7920.000000	0.700000	1.700000	1.000000	44
i1	179.4426	3.4500000477	78.260870	1	8280.000000	0.700000	1.700000	1.000000	46
i1	179.655	3.4500000477	72.000000	1	9000.000000	0.700000	1.700000	1.000000	50
i1	179.7612	3.4500000477	69.230769	1	9360.000000	0.700000	1.700000	1.000000	52
i1	179.9736	3.4500000477	64.285714	1	10080.000000	0.700000	1.700000	1.000000	56
i1	180.0798	3.4500000477	62.068966	1	10440.000000	0.700000	1.700000	1.000000	58
i1	183.618	3.4500000477	53.731343	1	12060.000000	0.700000	1.700000	1.000000	67
i1	183.51	3.4500000477	55.384615	1	11700.000000	0.700000	1.700000	1.000000	65
i1	183.402	3.4500000477	57.142857	1	11340.000000	0.700000	1.700000	1.000000	63
i1	183.294	3.4500000477	59.016393	1	10980.000000	0.700000	1.700000	1.000000	61
i1	182.97	3.4500000477	65.454545	1	9900.000000	0.700000	1.700000	1.000000	55
i1	182.646	3.4500000477	73.469388	1	8820.000000	0.700000	1.700000	1.000000	49
i1	182.322	3.4500000477	83.720930	1	7740.000000	0.700000	1.700000	1.000000	43
i1	181.998	3.4500000477	97.297297	1	6660.000000	0.700000	1.700000	1.000000	37
i1	181.674	3.4500000477	116.129032	1	5580.000000	0.700000	1.700000	1.000000	31
i1	181.35	3.4500000477	144.000000	1	4500.000000	0.700000	1.700000	1.000000	25
i1	181.026	3.4500000477	189.473684	1	3420.000000	0.700000	1.700000	1.000000	19
i1	180.702	3.4500000477	276.923077	1	2340.000000	0.700000	1.700000	1.000000	13
i1	180.378	3.4500000477	514.285714	1	1260.000000	0.700000	1.700000	1.000000	7
i1	180.054	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	180.108	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	180.324	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	180.432	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	180.648	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	180.756	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	180.972	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	181.08	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	181.296	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	181.404	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	181.62	3.4500000477	120.000000	1	5400.000000	0.700000	1.700000	1.000000	30
i1	181.728	3.4500000477	112.500000	1	5760.000000	0.700000	1.700000	1.000000	32
i1	181.944	3.4500000477	100.000000	1	6480.000000	0.700000	1.700000	1.000000	36
i1	182.052	3.4500000477	94.736842	1	6840.000000	0.700000	1.700000	1.000000	38
i1	182.268	3.4500000477	85.714286	1	7560.000000	0.700000	1.700000	1.000000	42
i1	182.376	3.4500000477	81.818182	1	7920.000000	0.700000	1.700000	1.000000	44
i1	182.592	3.4500000477	75.000000	1	8640.000000	0.700000	1.700000	1.000000	48
i1	182.7	3.4500000477	72.000000	1	9000.000000	0.700000	1.700000	1.000000	50
i1	182.916	3.4500000477	66.666667	1	9720.000000	0.700000	1.700000	1.000000	54
i1	183.024	3.4500000477	64.285714	1	10080.000000	0.700000	1.700000	1.000000	56
i1	183.24	3.4500000477	60.000000	1	10800.000000	0.700000	1.700000	1.000000	60
i1	183.348	3.4500000477	58.064516	1	11160.000000	0.700000	1.700000	1.000000	62
i1	183.456	3.4500000477	56.250000	1	11520.000000	0.700000	1.700000	1.000000	64
i1	183.564	3.4500000477	54.545455	1	11880.000000	0.700000	1.700000	1.000000	66
i1	186.2391	3.4500000477	61.016949	1	10620.000000	0.700000	1.700000	1.000000	59
i1	185.9097	3.4500000477	67.924528	1	9540.000000	0.700000	1.700000	1.000000	53
i1	185.5803	3.4500000477	76.595745	1	8460.000000	0.700000	1.700000	1.000000	47
i1	185.2509	3.4500000477	87.804878	1	7380.000000	0.700000	1.700000	1.000000	41
i1	184.9215	3.4500000477	102.857143	1	6300.000000	0.700000	1.700000	1.000000	35
i1	184.5921	3.4500000477	124.137931	1	5220.000000	0.700000	1.700000	1.000000	29
i1	184.2627	3.4500000477	156.521739	1	4140.000000	0.700000	1.700000	1.000000	23
i1	183.9333	3.4500000477	211.764706	1	3060.000000	0.700000	1.700000	1.000000	17
i1	183.6039	3.4500000477	327.272727	1	1980.000000	0.700000	1.700000	1.000000	11
i1	183.2745	3.4500000477	720.000000	1	900.000000	0.700000	1.700000	1.000000	5
i1	183.0549	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	183.2196	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	183.3294	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	183.549	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	183.6588	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	183.8784	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	183.9882	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	184.2078	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	184.3176	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	184.5372	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	184.647	3.4500000477	120.000000	1	5400.000000	0.700000	1.700000	1.000000	30
i1	184.8666	3.4500000477	105.882353	1	6120.000000	0.700000	1.700000	1.000000	34
i1	184.9764	3.4500000477	100.000000	1	6480.000000	0.700000	1.700000	1.000000	36
i1	185.196	3.4500000477	90.000000	1	7200.000000	0.700000	1.700000	1.000000	40
i1	185.3058	3.4500000477	85.714286	1	7560.000000	0.700000	1.700000	1.000000	42
i1	185.5254	3.4500000477	78.260870	1	8280.000000	0.700000	1.700000	1.000000	46
i1	185.6352	3.4500000477	75.000000	1	8640.000000	0.700000	1.700000	1.000000	48
i1	185.8548	3.4500000477	69.230769	1	9360.000000	0.700000	1.700000	1.000000	52
i1	185.9646	3.4500000477	66.666667	1	9720.000000	0.700000	1.700000	1.000000	54
i1	186.1842	3.4500000477	62.068966	1	10440.000000	0.700000	1.700000	1.000000	58
i1	186.294	3.4500000477	60.000000	1	10800.000000	0.700000	1.700000	1.000000	60
i1	189.7386	3.4500000477	53.731343	1	12060.000000	0.700000	1.700000	1.000000	67
i1	189.627	3.4500000477	55.384615	1	11700.000000	0.700000	1.700000	1.000000	65
i1	189.5154	3.4500000477	57.142857	1	11340.000000	0.700000	1.700000	1.000000	63
i1	189.1806	3.4500000477	63.157895	1	10260.000000	0.700000	1.700000	1.000000	57
i1	188.8458	3.4500000477	70.588235	1	9180.000000	0.700000	1.700000	1.000000	51
i1	188.511	3.4500000477	80.000000	1	8100.000000	0.700000	1.700000	1.000000	45
i1	188.1762	3.4500000477	92.307692	1	7020.000000	0.700000	1.700000	1.000000	39
i1	187.8414	3.4500000477	109.090909	1	5940.000000	0.700000	1.700000	1.000000	33
i1	187.5066	3.4500000477	133.333333	1	4860.000000	0.700000	1.700000	1.000000	27
i1	187.1718	3.4500000477	171.428571	1	3780.000000	0.700000	1.700000	1.000000	21
i1	186.837	3.4500000477	240.000000	1	2700.000000	0.700000	1.700000	1.000000	15
i1	186.5022	3.4500000477	400.000000	1	1620.000000	0.700000	1.700000	1.000000	9
i1	186.1674	3.4500000477	1200.000000	1	540.000000	0.700000	1.700000	1.000000	3
i1	186.1116	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	186.2232	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	186.4464	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	186.558	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	186.7812	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	186.8928	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	187.116	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	187.2276	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	187.4508	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	187.5624	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	187.7856	3.4500000477	112.500000	1	5760.000000	0.700000	1.700000	1.000000	32
i1	187.8972	3.4500000477	105.882353	1	6120.000000	0.700000	1.700000	1.000000	34
i1	188.1204	3.4500000477	94.736842	1	6840.000000	0.700000	1.700000	1.000000	38
i1	188.232	3.4500000477	90.000000	1	7200.000000	0.700000	1.700000	1.000000	40
i1	188.4552	3.4500000477	81.818182	1	7920.000000	0.700000	1.700000	1.000000	44
i1	188.5668	3.4500000477	78.260870	1	8280.000000	0.700000	1.700000	1.000000	46
i1	188.79	3.4500000477	72.000000	1	9000.000000	0.700000	1.700000	1.000000	50
i1	188.9016	3.4500000477	69.230769	1	9360.000000	0.700000	1.700000	1.000000	52
i1	189.1248	3.4500000477	64.285714	1	10080.000000	0.700000	1.700000	1.000000	56
i1	189.2364	3.4500000477	62.068966	1	10440.000000	0.700000	1.700000	1.000000	58
i1	189.4596	3.4500000477	58.064516	1	11160.000000	0.700000	1.700000	1.000000	62
i1	189.5712	3.4500000477	56.250000	1	11520.000000	0.700000	1.700000	1.000000	64
i1	189.6828	3.4500000477	54.545455	1	11880.000000	0.700000	1.700000	1.000000	66
i1	192.4587	3.4500000477	59.016393	1	10980.000000	0.700000	1.700000	1.000000	61
i1	192.1185	3.4500000477	65.454545	1	9900.000000	0.700000	1.700000	1.000000	55
i1	191.7783	3.4500000477	73.469388	1	8820.000000	0.700000	1.700000	1.000000	49
i1	191.4381	3.4500000477	83.720930	1	7740.000000	0.700000	1.700000	1.000000	43
i1	191.0979	3.4500000477	97.297297	1	6660.000000	0.700000	1.700000	1.000000	37
i1	190.7577	3.4500000477	116.129032	1	5580.000000	0.700000	1.700000	1.000000	31
i1	190.4175	3.4500000477	144.000000	1	4500.000000	0.700000	1.700000	1.000000	25
i1	190.0773	3.4500000477	189.473684	1	3420.000000	0.700000	1.700000	1.000000	19
i1	189.7371	3.4500000477	276.923077	1	2340.000000	0.700000	1.700000	1.000000	13
i1	189.3969	3.4500000477	514.285714	1	1260.000000	0.700000	1.700000	1.000000	7
i1	189.0567	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	189.1134	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	189.3402	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	189.4536	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	189.6804	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	189.7938	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	190.0206	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	190.134	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	190.3608	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	190.4742	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	190.701	3.4500000477	120.000000	1	5400.000000	0.700000	1.700000	1.000000	30
i1	190.8144	3.4500000477	112.500000	1	5760.000000	0.700000	1.700000	1.000000	32
i1	191.0412	3.4500000477	100.000000	1	6480.000000	0.700000	1.700000	1.000000	36
i1	191.1546	3.4500000477	94.736842	1	6840.000000	0.700000	1.700000	1.000000	38
i1	191.3814	3.4500000477	85.714286	1	7560.000000	0.700000	1.700000	1.000000	42
i1	191.4948	3.4500000477	81.818182	1	7920.000000	0.700000	1.700000	1.000000	44
i1	191.7216	3.4500000477	75.000000	1	8640.000000	0.700000	1.700000	1.000000	48
i1	191.835	3.4500000477	72.000000	1	9000.000000	0.700000	1.700000	1.000000	50
i1	192.0618	3.4500000477	66.666667	1	9720.000000	0.700000	1.700000	1.000000	54
i1	192.1752	3.4500000477	64.285714	1	10080.000000	0.700000	1.700000	1.000000	56
i1	192.402	3.4500000477	60.000000	1	10800.000000	0.700000	1.700000	1.000000	60
i1	192.5154	3.4500000477	58.064516	1	11160.000000	0.700000	1.700000	1.000000	62
i1	195.8592	3.4500000477	53.731343	1	12060.000000	0.700000	1.700000	1.000000	67
i1	195.744	3.4500000477	55.384615	1	11700.000000	0.700000	1.700000	1.000000	65
i1	195.3984	3.4500000477	61.016949	1	10620.000000	0.700000	1.700000	1.000000	59
i1	195.0528	3.4500000477	67.924528	1	9540.000000	0.700000	1.700000	1.000000	53
i1	194.7072	3.4500000477	76.595745	1	8460.000000	0.700000	1.700000	1.000000	47
i1	194.3616	3.4500000477	87.804878	1	7380.000000	0.700000	1.700000	1.000000	41
i1	194.016	3.4500000477	102.857143	1	6300.000000	0.700000	1.700000	1.000000	35
i1	193.6704	3.4500000477	124.137931	1	5220.000000	0.700000	1.700000	1.000000	29
i1	193.3248	3.4500000477	156.521739	1	4140.000000	0.700000	1.700000	1.000000	23
i1	192.9792	3.4500000477	211.764706	1	3060.000000	0.700000	1.700000	1.000000	17
i1	192.6336	3.4500000477	327.272727	1	1980.000000	0.700000	1.700000	1.000000	11
i1	192.288	3.4500000477	720.000000	1	900.000000	0.700000	1.700000	1.000000	5
i1	192.0576	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	192.2304	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	192.3456	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	192.576	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	192.6912	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	192.9216	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	193.0368	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	193.2672	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	193.3824	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	193.6128	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	193.728	3.4500000477	120.000000	1	5400.000000	0.700000	1.700000	1.000000	30
i1	193.9584	3.4500000477	105.882353	1	6120.000000	0.700000	1.700000	1.000000	34
i1	194.0736	3.4500000477	100.000000	1	6480.000000	0.700000	1.700000	1.000000	36
i1	194.304	3.4500000477	90.000000	1	7200.000000	0.700000	1.700000	1.000000	40
i1	194.4192	3.4500000477	85.714286	1	7560.000000	0.700000	1.700000	1.000000	42
i1	194.6496	3.4500000477	78.260870	1	8280.000000	0.700000	1.700000	1.000000	46
i1	194.7648	3.4500000477	75.000000	1	8640.000000	0.700000	1.700000	1.000000	48
i1	194.9952	3.4500000477	69.230769	1	9360.000000	0.700000	1.700000	1.000000	52
i1	195.1104	3.4500000477	66.666667	1	9720.000000	0.700000	1.700000	1.000000	54
i1	195.3408	3.4500000477	62.068966	1	10440.000000	0.700000	1.700000	1.000000	58
i1	195.456	3.4500000477	60.000000	1	10800.000000	0.700000	1.700000	1.000000	60
i1	195.6864	3.4500000477	56.250000	1	11520.000000	0.700000	1.700000	1.000000	64
i1	195.8016	3.4500000477	54.545455	1	11880.000000	0.700000	1.700000	1.000000	66
i1	198.6855	3.4500000477	57.142857	1	11340.000000	0.700000	1.700000	1.000000	63
i1	198.3345	3.4500000477	63.157895	1	10260.000000	0.700000	1.700000	1.000000	57
i1	197.9835	3.4500000477	70.588235	1	9180.000000	0.700000	1.700000	1.000000	51
i1	197.6325	3.4500000477	80.000000	1	8100.000000	0.700000	1.700000	1.000000	45
i1	197.2815	3.4500000477	92.307692	1	7020.000000	0.700000	1.700000	1.000000	39
i1	196.9305	3.4500000477	109.090909	1	5940.000000	0.700000	1.700000	1.000000	33
i1	196.5795	3.4500000477	133.333333	1	4860.000000	0.700000	1.700000	1.000000	27
i1	196.2285	3.4500000477	171.428571	1	3780.000000	0.700000	1.700000	1.000000	21
i1	195.8775	3.4500000477	240.000000	1	2700.000000	0.700000	1.700000	1.000000	15
i1	195.5265	3.4500000477	400.000000	1	1620.000000	0.700000	1.700000	1.000000	9
i1	195.1755	3.4500000477	1200.000000	1	540.000000	0.700000	1.700000	1.000000	3
i1	195.117	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	195.234	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	195.468	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	195.585	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	195.819	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	195.936	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	196.17	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	196.287	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	196.521	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	196.638	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	196.872	3.4500000477	112.500000	1	5760.000000	0.700000	1.700000	1.000000	32
i1	196.989	3.4500000477	105.882353	1	6120.000000	0.700000	1.700000	1.000000	34
i1	197.223	3.4500000477	94.736842	1	6840.000000	0.700000	1.700000	1.000000	38
i1	197.34	3.4500000477	90.000000	1	7200.000000	0.700000	1.700000	1.000000	40
i1	197.574	3.4500000477	81.818182	1	7920.000000	0.700000	1.700000	1.000000	44
i1	197.691	3.4500000477	78.260870	1	8280.000000	0.700000	1.700000	1.000000	46
i1	197.925	3.4500000477	72.000000	1	9000.000000	0.700000	1.700000	1.000000	50
i1	198.042	3.4500000477	69.230769	1	9360.000000	0.700000	1.700000	1.000000	52
i1	198.276	3.4500000477	64.285714	1	10080.000000	0.700000	1.700000	1.000000	56
i1	198.393	3.4500000477	62.068966	1	10440.000000	0.700000	1.700000	1.000000	58
i1	198.627	3.4500000477	58.064516	1	11160.000000	0.700000	1.700000	1.000000	62
i1	198.744	3.4500000477	56.250000	1	11520.000000	0.700000	1.700000	1.000000	64
i1	201.9798	3.4500000477	53.731343	1	12060.000000	0.700000	1.700000	1.000000	67
i1	201.6234	3.4500000477	59.016393	1	10980.000000	0.700000	1.700000	1.000000	61
i1	201.267	3.4500000477	65.454545	1	9900.000000	0.700000	1.700000	1.000000	55
i1	200.9106	3.4500000477	73.469388	1	8820.000000	0.700000	1.700000	1.000000	49
i1	200.5542	3.4500000477	83.720930	1	7740.000000	0.700000	1.700000	1.000000	43
i1	200.1978	3.4500000477	97.297297	1	6660.000000	0.700000	1.700000	1.000000	37
i1	199.8414	3.4500000477	116.129032	1	5580.000000	0.700000	1.700000	1.000000	31
i1	199.485	3.4500000477	144.000000	1	4500.000000	0.700000	1.700000	1.000000	25
i1	199.1286	3.4500000477	189.473684	1	3420.000000	0.700000	1.700000	1.000000	19
i1	198.7722	3.4500000477	276.923077	1	2340.000000	0.700000	1.700000	1.000000	13
i1	198.4158	3.4500000477	514.285714	1	1260.000000	0.700000	1.700000	1.000000	7
i1	198.0594	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	198.1188	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	198.3564	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	198.4752	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	198.7128	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	198.8316	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	199.0692	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	199.188	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	199.4256	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	199.5444	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	199.782	3.4500000477	120.000000	1	5400.000000	0.700000	1.700000	1.000000	30
i1	199.9008	3.4500000477	112.500000	1	5760.000000	0.700000	1.700000	1.000000	32
i1	200.1384	3.4500000477	100.000000	1	6480.000000	0.700000	1.700000	1.000000	36
i1	200.2572	3.4500000477	94.736842	1	6840.000000	0.700000	1.700000	1.000000	38
i1	200.4948	3.4500000477	85.714286	1	7560.000000	0.700000	1.700000	1.000000	42
i1	200.6136	3.4500000477	81.818182	1	7920.000000	0.700000	1.700000	1.000000	44
i1	200.8512	3.4500000477	75.000000	1	8640.000000	0.700000	1.700000	1.000000	48
i1	200.97	3.4500000477	72.000000	1	9000.000000	0.700000	1.700000	1.000000	50
i1	201.2076	3.4500000477	66.666667	1	9720.000000	0.700000	1.700000	1.000000	54
i1	201.3264	3.4500000477	64.285714	1	10080.000000	0.700000	1.700000	1.000000	56
i1	201.564	3.4500000477	60.000000	1	10800.000000	0.700000	1.700000	1.000000	60
i1	201.6828	3.4500000477	58.064516	1	11160.000000	0.700000	1.700000	1.000000	62
i1	201.9204	3.4500000477	54.545455	1	11880.000000	0.700000	1.700000	1.000000	66
i1	204.9195	3.4500000477	55.384615	1	11700.000000	0.700000	1.700000	1.000000	65
i1	204.5577	3.4500000477	61.016949	1	10620.000000	0.700000	1.700000	1.000000	59
i1	204.1959	3.4500000477	67.924528	1	9540.000000	0.700000	1.700000	1.000000	53
i1	203.8341	3.4500000477	76.595745	1	8460.000000	0.700000	1.700000	1.000000	47
i1	203.4723	3.4500000477	87.804878	1	7380.000000	0.700000	1.700000	1.000000	41
i1	203.1105	3.4500000477	102.857143	1	6300.000000	0.700000	1.700000	1.000000	35
i1	202.7487	3.4500000477	124.137931	1	5220.000000	0.700000	1.700000	1.000000	29
i1	202.3869	3.4500000477	156.521739	1	4140.000000	0.700000	1.700000	1.000000	23
i1	202.0251	3.4500000477	211.764706	1	3060.000000	0.700000	1.700000	1.000000	17
i1	201.6633	3.4500000477	327.272727	1	1980.000000	0.700000	1.700000	1.000000	11
i1	201.3015	3.4500000477	720.000000	1	900.000000	0.700000	1.700000	1.000000	5
i1	201.0603	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	201.2412	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	201.3618	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	201.603	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	201.7236	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	201.9648	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	202.0854	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	202.3266	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	202.4472	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	202.6884	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	202.809	3.4500000477	120.000000	1	5400.000000	0.700000	1.700000	1.000000	30
i1	203.0502	3.4500000477	105.882353	1	6120.000000	0.700000	1.700000	1.000000	34
i1	203.1708	3.4500000477	100.000000	1	6480.000000	0.700000	1.700000	1.000000	36
i1	203.412	3.4500000477	90.000000	1	7200.000000	0.700000	1.700000	1.000000	40
i1	203.5326	3.4500000477	85.714286	1	7560.000000	0.700000	1.700000	1.000000	42
i1	203.7738	3.4500000477	78.260870	1	8280.000000	0.700000	1.700000	1.000000	46
i1	203.8944	3.4500000477	75.000000	1	8640.000000	0.700000	1.700000	1.000000	48
i1	204.1356	3.4500000477	69.230769	1	9360.000000	0.700000	1.700000	1.000000	52
i1	204.2562	3.4500000477	66.666667	1	9720.000000	0.700000	1.700000	1.000000	54
i1	204.4974	3.4500000477	62.068966	1	10440.000000	0.700000	1.700000	1.000000	58
i1	204.618	3.4500000477	60.000000	1	10800.000000	0.700000	1.700000	1.000000	60
i1	204.8592	3.4500000477	56.250000	1	11520.000000	0.700000	1.700000	1.000000	64
i1	204.9798	3.4500000477	54.545455	1	11880.000000	0.700000	1.700000	1.000000	66
i1	208.1004	3.4500000477	53.731343	1	12060.000000	0.700000	1.700000	1.000000	67
i1	207.8556	3.4500000477	57.142857	1	11340.000000	0.700000	1.700000	1.000000	63
i1	207.4884	3.4500000477	63.157895	1	10260.000000	0.700000	1.700000	1.000000	57
i1	207.1212	3.4500000477	70.588235	1	9180.000000	0.700000	1.700000	1.000000	51
i1	206.754	3.4500000477	80.000000	1	8100.000000	0.700000	1.700000	1.000000	45
i1	206.3868	3.4500000477	92.307692	1	7020.000000	0.700000	1.700000	1.000000	39
i1	206.0196	3.4500000477	109.090909	1	5940.000000	0.700000	1.700000	1.000000	33
i1	205.6524	3.4500000477	133.333333	1	4860.000000	0.700000	1.700000	1.000000	27
i1	205.2852	3.4500000477	171.428571	1	3780.000000	0.700000	1.700000	1.000000	21
i1	204.918	3.4500000477	240.000000	1	2700.000000	0.700000	1.700000	1.000000	15
i1	204.5508	3.4500000477	400.000000	1	1620.000000	0.700000	1.700000	1.000000	9
i1	204.1836	3.4500000477	1200.000000	1	540.000000	0.700000	1.700000	1.000000	3
i1	204.1224	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	204.2448	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	204.4896	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	204.612	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	204.8568	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	204.9792	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	205.224	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	205.3464	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	205.5912	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	205.7136	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	205.9584	3.4500000477	112.500000	1	5760.000000	0.700000	1.700000	1.000000	32
i1	206.0808	3.4500000477	105.882353	1	6120.000000	0.700000	1.700000	1.000000	34
i1	206.3256	3.4500000477	94.736842	1	6840.000000	0.700000	1.700000	1.000000	38
i1	206.448	3.4500000477	90.000000	1	7200.000000	0.700000	1.700000	1.000000	40
i1	206.6928	3.4500000477	81.818182	1	7920.000000	0.700000	1.700000	1.000000	44
i1	206.8152	3.4500000477	78.260870	1	8280.000000	0.700000	1.700000	1.000000	46
i1	207.06	3.4500000477	72.000000	1	9000.000000	0.700000	1.700000	1.000000	50
i1	207.1824	3.4500000477	69.230769	1	9360.000000	0.700000	1.700000	1.000000	52
i1	207.4272	3.4500000477	64.285714	1	10080.000000	0.700000	1.700000	1.000000	56
i1	207.5496	3.4500000477	62.068966	1	10440.000000	0.700000	1.700000	1.000000	58
i1	207.7944	3.4500000477	58.064516	1	11160.000000	0.700000	1.700000	1.000000	62
i1	207.9168	3.4500000477	56.250000	1	11520.000000	0.700000	1.700000	1.000000	64
i1	211.0365	3.4500000477	55.384615	1	11700.000000	0.700000	1.700000	1.000000	65
i1	210.7881	3.4500000477	59.016393	1	10980.000000	0.700000	1.700000	1.000000	61
i1	210.4155	3.4500000477	65.454545	1	9900.000000	0.700000	1.700000	1.000000	55
i1	210.0429	3.4500000477	73.469388	1	8820.000000	0.700000	1.700000	1.000000	49
i1	209.6703	3.4500000477	83.720930	1	7740.000000	0.700000	1.700000	1.000000	43
i1	209.2977	3.4500000477	97.297297	1	6660.000000	0.700000	1.700000	1.000000	37
i1	208.9251	3.4500000477	116.129032	1	5580.000000	0.700000	1.700000	1.000000	31
i1	208.5525	3.4500000477	144.000000	1	4500.000000	0.700000	1.700000	1.000000	25
i1	208.1799	3.4500000477	189.473684	1	3420.000000	0.700000	1.700000	1.000000	19
i1	207.8073	3.4500000477	276.923077	1	2340.000000	0.700000	1.700000	1.000000	13
i1	207.4347	3.4500000477	514.285714	1	1260.000000	0.700000	1.700000	1.000000	7
i1	207.0621	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	207.1242	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	207.3726	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	207.4968	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	207.7452	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	207.8694	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	208.1178	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	208.242	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	208.4904	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	208.6146	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	208.863	3.4500000477	120.000000	1	5400.000000	0.700000	1.700000	1.000000	30
i1	208.9872	3.4500000477	112.500000	1	5760.000000	0.700000	1.700000	1.000000	32
i1	209.2356	3.4500000477	100.000000	1	6480.000000	0.700000	1.700000	1.000000	36
i1	209.3598	3.4500000477	94.736842	1	6840.000000	0.700000	1.700000	1.000000	38
i1	209.6082	3.4500000477	85.714286	1	7560.000000	0.700000	1.700000	1.000000	42
i1	209.7324	3.4500000477	81.818182	1	7920.000000	0.700000	1.700000	1.000000	44
i1	209.9808	3.4500000477	75.000000	1	8640.000000	0.700000	1.700000	1.000000	48
i1	210.105	3.4500000477	72.000000	1	9000.000000	0.700000	1.700000	1.000000	50
i1	210.3534	3.4500000477	66.666667	1	9720.000000	0.700000	1.700000	1.000000	54
i1	210.4776	3.4500000477	64.285714	1	10080.000000	0.700000	1.700000	1.000000	56
i1	210.726	3.4500000477	60.000000	1	10800.000000	0.700000	1.700000	1.000000	60
i1	210.8502	3.4500000477	58.064516	1	11160.000000	0.700000	1.700000	1.000000	62
i1	211.0986	3.4500000477	54.545455	1	11880.000000	0.700000	1.700000	1.000000	66
i1	214.221	3.4500000477	53.731343	1	12060.000000	0.700000	1.700000	1.000000	67
i1	213.969	3.4500000477	57.142857	1	11340.000000	0.700000	1.700000	1.000000	63
i1	213.717	3.4500000477	61.016949	1	10620.000000	0.700000	1.700000	1.000000	59
i1	213.339	3.4500000477	67.924528	1	9540.000000	0.700000	1.700000	1.000000	53
i1	212.961	3.4500000477	76.595745	1	8460.000000	0.700000	1.700000	1.000000	47
i1	212.583	3.4500000477	87.804878	1	7380.000000	0.700000	1.700000	1.000000	41
i1	212.205	3.4500000477	102.857143	1	6300.000000	0.700000	1.700000	1.000000	35
i1	211.827	3.4500000477	124.137931	1	5220.000000	0.700000	1.700000	1.000000	29
i1	211.449	3.4500000477	156.521739	1	4140.000000	0.700000	1.700000	1.000000	23
i1	211.071	3.4500000477	211.764706	1	3060.000000	0.700000	1.700000	1.000000	17
i1	210.693	3.4500000477	327.272727	1	1980.000000	0.700000	1.700000	1.000000	11
i1	210.315	3.4500000477	720.000000	1	900.000000	0.700000	1.700000	1.000000	5
i1	210.063	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	210.252	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	210.378	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	210.63	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	210.756	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	211.008	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	211.134	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	211.386	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	211.512	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	211.764	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	211.89	3.4500000477	120.000000	1	5400.000000	0.700000	1.700000	1.000000	30
i1	212.142	3.4500000477	105.882353	1	6120.000000	0.700000	1.700000	1.000000	34
i1	212.268	3.4500000477	100.000000	1	6480.000000	0.700000	1.700000	1.000000	36
i1	212.52	3.4500000477	90.000000	1	7200.000000	0.700000	1.700000	1.000000	40
i1	212.646	3.4500000477	85.714286	1	7560.000000	0.700000	1.700000	1.000000	42
i1	212.898	3.4500000477	78.260870	1	8280.000000	0.700000	1.700000	1.000000	46
i1	213.024	3.4500000477	75.000000	1	8640.000000	0.700000	1.700000	1.000000	48
i1	213.276	3.4500000477	69.230769	1	9360.000000	0.700000	1.700000	1.000000	52
i1	213.402	3.4500000477	66.666667	1	9720.000000	0.700000	1.700000	1.000000	54
i1	213.654	3.4500000477	62.068966	1	10440.000000	0.700000	1.700000	1.000000	58
i1	213.78	3.4500000477	60.000000	1	10800.000000	0.700000	1.700000	1.000000	60
i1	214.032	3.4500000477	56.250000	1	11520.000000	0.700000	1.700000	1.000000	64
i1	217.1535	3.4500000477	55.384615	1	11700.000000	0.700000	1.700000	1.000000	65
i1	216.8979	3.4500000477	59.016393	1	10980.000000	0.700000	1.700000	1.000000	61
i1	216.6423	3.4500000477	63.157895	1	10260.000000	0.700000	1.700000	1.000000	57
i1	216.2589	3.4500000477	70.588235	1	9180.000000	0.700000	1.700000	1.000000	51
i1	215.8755	3.4500000477	80.000000	1	8100.000000	0.700000	1.700000	1.000000	45
i1	215.4921	3.4500000477	92.307692	1	7020.000000	0.700000	1.700000	1.000000	39
i1	215.1087	3.4500000477	109.090909	1	5940.000000	0.700000	1.700000	1.000000	33
i1	214.7253	3.4500000477	133.333333	1	4860.000000	0.700000	1.700000	1.000000	27
i1	214.3419	3.4500000477	171.428571	1	3780.000000	0.700000	1.700000	1.000000	21
i1	213.9585	3.4500000477	240.000000	1	2700.000000	0.700000	1.700000	1.000000	15
i1	213.5751	3.4500000477	400.000000	1	1620.000000	0.700000	1.700000	1.000000	9
i1	213.1917	3.4500000477	1200.000000	1	540.000000	0.700000	1.700000	1.000000	3
i1	213.1278	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	213.2556	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	213.5112	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	213.639	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	213.8946	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	214.0224	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	214.278	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	214.4058	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	214.6614	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	214.7892	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	215.0448	3.4500000477	112.500000	1	5760.000000	0.700000	1.700000	1.000000	32
i1	215.1726	3.4500000477	105.882353	1	6120.000000	0.700000	1.700000	1.000000	34
i1	215.4282	3.4500000477	94.736842	1	6840.000000	0.700000	1.700000	1.000000	38
i1	215.556	3.4500000477	90.000000	1	7200.000000	0.700000	1.700000	1.000000	40
i1	215.8116	3.4500000477	81.818182	1	7920.000000	0.700000	1.700000	1.000000	44
i1	215.9394	3.4500000477	78.260870	1	8280.000000	0.700000	1.700000	1.000000	46
i1	216.195	3.4500000477	72.000000	1	9000.000000	0.700000	1.700000	1.000000	50
i1	216.3228	3.4500000477	69.230769	1	9360.000000	0.700000	1.700000	1.000000	52
i1	216.5784	3.4500000477	64.285714	1	10080.000000	0.700000	1.700000	1.000000	56
i1	216.7062	3.4500000477	62.068966	1	10440.000000	0.700000	1.700000	1.000000	58
i1	216.9618	3.4500000477	58.064516	1	11160.000000	0.700000	1.700000	1.000000	62
i1	217.2174	3.4500000477	54.545455	1	11880.000000	0.700000	1.700000	1.000000	66
i1	220.3416	3.4500000477	53.731343	1	12060.000000	0.700000	1.700000	1.000000	67
i1	220.0824	3.4500000477	57.142857	1	11340.000000	0.700000	1.700000	1.000000	63
i1	219.8232	3.4500000477	61.016949	1	10620.000000	0.700000	1.700000	1.000000	59
i1	219.564	3.4500000477	65.454545	1	9900.000000	0.700000	1.700000	1.000000	55
i1	219.1752	3.4500000477	73.469388	1	8820.000000	0.700000	1.700000	1.000000	49
i1	218.7864	3.4500000477	83.720930	1	7740.000000	0.700000	1.700000	1.000000	43
i1	218.3976	3.4500000477	97.297297	1	6660.000000	0.700000	1.700000	1.000000	37
i1	218.0088	3.4500000477	116.129032	1	5580.000000	0.700000	1.700000	1.000000	31
i1	217.62	3.4500000477	144.000000	1	4500.000000	0.700000	1.700000	1.000000	25
i1	217.2312	3.4500000477	189.473684	1	3420.000000	0.700000	1.700000	1.000000	19
i1	216.8424	3.4500000477	276.923077	1	2340.000000	0.700000	1.700000	1.000000	13
i1	216.4536	3.4500000477	514.285714	1	1260.000000	0.700000	1.700000	1.000000	7
i1	216.0648	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	216.1296	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	216.3888	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	216.5184	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	216.7776	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	216.9072	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	217.1664	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	217.296	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	217.5552	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	217.6848	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	217.944	3.4500000477	120.000000	1	5400.000000	0.700000	1.700000	1.000000	30
i1	218.0736	3.4500000477	112.500000	1	5760.000000	0.700000	1.700000	1.000000	32
i1	218.3328	3.4500000477	100.000000	1	6480.000000	0.700000	1.700000	1.000000	36
i1	218.4624	3.4500000477	94.736842	1	6840.000000	0.700000	1.700000	1.000000	38
i1	218.7216	3.4500000477	85.714286	1	7560.000000	0.700000	1.700000	1.000000	42
i1	218.8512	3.4500000477	81.818182	1	7920.000000	0.700000	1.700000	1.000000	44
i1	219.1104	3.4500000477	75.000000	1	8640.000000	0.700000	1.700000	1.000000	48
i1	219.24	3.4500000477	72.000000	1	9000.000000	0.700000	1.700000	1.000000	50
i1	219.4992	3.4500000477	66.666667	1	9720.000000	0.700000	1.700000	1.000000	54
i1	219.6288	3.4500000477	64.285714	1	10080.000000	0.700000	1.700000	1.000000	56
i1	219.888	3.4500000477	60.000000	1	10800.000000	0.700000	1.700000	1.000000	60
i1	220.1472	3.4500000477	56.250000	1	11520.000000	0.700000	1.700000	1.000000	64
i1	223.2705	3.4500000477	55.384615	1	11700.000000	0.700000	1.700000	1.000000	65
i1	223.0077	3.4500000477	59.016393	1	10980.000000	0.700000	1.700000	1.000000	61
i1	222.7449	3.4500000477	63.157895	1	10260.000000	0.700000	1.700000	1.000000	57
i1	222.4821	3.4500000477	67.924528	1	9540.000000	0.700000	1.700000	1.000000	53
i1	222.0879	3.4500000477	76.595745	1	8460.000000	0.700000	1.700000	1.000000	47
i1	221.6937	3.4500000477	87.804878	1	7380.000000	0.700000	1.700000	1.000000	41
i1	221.2995	3.4500000477	102.857143	1	6300.000000	0.700000	1.700000	1.000000	35
i1	220.9053	3.4500000477	124.137931	1	5220.000000	0.700000	1.700000	1.000000	29
i1	220.5111	3.4500000477	156.521739	1	4140.000000	0.700000	1.700000	1.000000	23
i1	220.1169	3.4500000477	211.764706	1	3060.000000	0.700000	1.700000	1.000000	17
i1	219.7227	3.4500000477	327.272727	1	1980.000000	0.700000	1.700000	1.000000	11
i1	219.3285	3.4500000477	720.000000	1	900.000000	0.700000	1.700000	1.000000	5
i1	219.0657	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	219.2628	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	219.3942	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	219.657	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	219.7884	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	220.0512	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	220.1826	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	220.4454	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	220.5768	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	220.8396	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	220.971	3.4500000477	120.000000	1	5400.000000	0.700000	1.700000	1.000000	30
i1	221.2338	3.4500000477	105.882353	1	6120.000000	0.700000	1.700000	1.000000	34
i1	221.3652	3.4500000477	100.000000	1	6480.000000	0.700000	1.700000	1.000000	36
i1	221.628	3.4500000477	90.000000	1	7200.000000	0.700000	1.700000	1.000000	40
i1	221.7594	3.4500000477	85.714286	1	7560.000000	0.700000	1.700000	1.000000	42
i1	222.0222	3.4500000477	78.260870	1	8280.000000	0.700000	1.700000	1.000000	46
i1	222.1536	3.4500000477	75.000000	1	8640.000000	0.700000	1.700000	1.000000	48
i1	222.4164	3.4500000477	69.230769	1	9360.000000	0.700000	1.700000	1.000000	52
i1	222.5478	3.4500000477	66.666667	1	9720.000000	0.700000	1.700000	1.000000	54
i1	222.8106	3.4500000477	62.068966	1	10440.000000	0.700000	1.700000	1.000000	58
i1	223.0734	3.4500000477	58.064516	1	11160.000000	0.700000	1.700000	1.000000	62
i1	223.3362	3.4500000477	54.545455	1	11880.000000	0.700000	1.700000	1.000000	66
i1	226.4622	3.4500000477	53.731343	1	12060.000000	0.700000	1.700000	1.000000	67
i1	226.1958	3.4500000477	57.142857	1	11340.000000	0.700000	1.700000	1.000000	63
i1	225.9294	3.4500000477	61.016949	1	10620.000000	0.700000	1.700000	1.000000	59
i1	225.663	3.4500000477	65.454545	1	9900.000000	0.700000	1.700000	1.000000	55
i1	225.3966	3.4500000477	70.588235	1	9180.000000	0.700000	1.700000	1.000000	51
i1	224.997	3.4500000477	80.000000	1	8100.000000	0.700000	1.700000	1.000000	45
i1	224.5974	3.4500000477	92.307692	1	7020.000000	0.700000	1.700000	1.000000	39
i1	224.1978	3.4500000477	109.090909	1	5940.000000	0.700000	1.700000	1.000000	33
i1	223.7982	3.4500000477	133.333333	1	4860.000000	0.700000	1.700000	1.000000	27
i1	223.3986	3.4500000477	171.428571	1	3780.000000	0.700000	1.700000	1.000000	21
i1	222.999	3.4500000477	240.000000	1	2700.000000	0.700000	1.700000	1.000000	15
i1	222.5994	3.4500000477	400.000000	1	1620.000000	0.700000	1.700000	1.000000	9
i1	222.1998	3.4500000477	1200.000000	1	540.000000	0.700000	1.700000	1.000000	3
i1	222.1332	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	222.2664	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	222.5328	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	222.666	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	222.9324	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	223.0656	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	223.332	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	223.4652	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	223.7316	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	223.8648	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	224.1312	3.4500000477	112.500000	1	5760.000000	0.700000	1.700000	1.000000	32
i1	224.2644	3.4500000477	105.882353	1	6120.000000	0.700000	1.700000	1.000000	34
i1	224.5308	3.4500000477	94.736842	1	6840.000000	0.700000	1.700000	1.000000	38
i1	224.664	3.4500000477	90.000000	1	7200.000000	0.700000	1.700000	1.000000	40
i1	224.9304	3.4500000477	81.818182	1	7920.000000	0.700000	1.700000	1.000000	44
i1	225.0636	3.4500000477	78.260870	1	8280.000000	0.700000	1.700000	1.000000	46
i1	225.33	3.4500000477	72.000000	1	9000.000000	0.700000	1.700000	1.000000	50
i1	225.4632	3.4500000477	69.230769	1	9360.000000	0.700000	1.700000	1.000000	52
i1	225.7296	3.4500000477	64.285714	1	10080.000000	0.700000	1.700000	1.000000	56
i1	225.996	3.4500000477	60.000000	1	10800.000000	0.700000	1.700000	1.000000	60
i1	226.2624	3.4500000477	56.250000	1	11520.000000	0.700000	1.700000	1.000000	64
i1	229.3875	3.4500000477	55.384615	1	11700.000000	0.700000	1.700000	1.000000	65
i1	229.1175	3.4500000477	59.016393	1	10980.000000	0.700000	1.700000	1.000000	61
i1	228.8475	3.4500000477	63.157895	1	10260.000000	0.700000	1.700000	1.000000	57
i1	228.5775	3.4500000477	67.924528	1	9540.000000	0.700000	1.700000	1.000000	53
i1	228.3075	3.4500000477	73.469388	1	8820.000000	0.700000	1.700000	1.000000	49
i1	227.9025	3.4500000477	83.720930	1	7740.000000	0.700000	1.700000	1.000000	43
i1	227.4975	3.4500000477	97.297297	1	6660.000000	0.700000	1.700000	1.000000	37
i1	227.0925	3.4500000477	116.129032	1	5580.000000	0.700000	1.700000	1.000000	31
i1	226.6875	3.4500000477	144.000000	1	4500.000000	0.700000	1.700000	1.000000	25
i1	226.2825	3.4500000477	189.473684	1	3420.000000	0.700000	1.700000	1.000000	19
i1	225.8775	3.4500000477	276.923077	1	2340.000000	0.700000	1.700000	1.000000	13
i1	225.4725	3.4500000477	514.285714	1	1260.000000	0.700000	1.700000	1.000000	7
i1	225.0675	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	225.135	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	225.405	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	225.54	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	225.81	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	225.945	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	226.215	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	226.35	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	226.62	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	226.755	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	227.025	3.4500000477	120.000000	1	5400.000000	0.700000	1.700000	1.000000	30
i1	227.16	3.4500000477	112.500000	1	5760.000000	0.700000	1.700000	1.000000	32
i1	227.43	3.4500000477	100.000000	1	6480.000000	0.700000	1.700000	1.000000	36
i1	227.565	3.4500000477	94.736842	1	6840.000000	0.700000	1.700000	1.000000	38
i1	227.835	3.4500000477	85.714286	1	7560.000000	0.700000	1.700000	1.000000	42
i1	227.97	3.4500000477	81.818182	1	7920.000000	0.700000	1.700000	1.000000	44
i1	228.24	3.4500000477	75.000000	1	8640.000000	0.700000	1.700000	1.000000	48
i1	228.375	3.4500000477	72.000000	1	9000.000000	0.700000	1.700000	1.000000	50
i1	228.645	3.4500000477	66.666667	1	9720.000000	0.700000	1.700000	1.000000	54
i1	228.915	3.4500000477	62.068966	1	10440.000000	0.700000	1.700000	1.000000	58
i1	229.185	3.4500000477	58.064516	1	11160.000000	0.700000	1.700000	1.000000	62
i1	229.455	3.4500000477	54.545455	1	11880.000000	0.700000	1.700000	1.000000	66
i1	232.5828	3.4500000477	53.731343	1	12060.000000	0.700000	1.700000	1.000000	67
i1	232.3092	3.4500000477	57.142857	1	11340.000000	0.700000	1.700000	1.000000	63
i1	232.0356	3.4500000477	61.016949	1	10620.000000	0.700000	1.700000	1.000000	59
i1	231.762	3.4500000477	65.454545	1	9900.000000	0.700000	1.700000	1.000000	55
i1	231.4884	3.4500000477	70.588235	1	9180.000000	0.700000	1.700000	1.000000	51
i1	231.2148	3.4500000477	76.595745	1	8460.000000	0.700000	1.700000	1.000000	47
i1	230.8044	3.4500000477	87.804878	1	7380.000000	0.700000	1.700000	1.000000	41
i1	230.394	3.4500000477	102.857143	1	6300.000000	0.700000	1.700000	1.000000	35
i1	229.9836	3.4500000477	124.137931	1	5220.000000	0.700000	1.700000	1.000000	29
i1	229.5732	3.4500000477	156.521739	1	4140.000000	0.700000	1.700000	1.000000	23
i1	229.1628	3.4500000477	211.764706	1	3060.000000	0.700000	1.700000	1.000000	17
i1	228.7524	3.4500000477	327.272727	1	1980.000000	0.700000	1.700000	1.000000	11
i1	228.342	3.4500000477	720.000000	1	900.000000	0.700000	1.700000	1.000000	5
i1	228.0684	3.4500000477	3600.000000	1	180.000000	0.700000	1.700000	1.000000	1
i1	228.2736	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	228.4104	3.4500000477	600.000000	1	1080.000000	0.700000	1.700000	1.000000	6
i1	228.684	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	228.8208	3.4500000477	300.000000	1	2160.000000	0.700000	1.700000	1.000000	12
i1	229.0944	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	229.2312	3.4500000477	200.000000	1	3240.000000	0.700000	1.700000	1.000000	18
i1	229.5048	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	229.6416	3.4500000477	150.000000	1	4320.000000	0.700000	1.700000	1.000000	24
i1	229.9152	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	230.052	3.4500000477	120.000000	1	5400.000000	0.700000	1.700000	1.000000	30
i1	230.3256	3.4500000477	105.882353	1	6120.000000	0.700000	1.700000	1.000000	34
i1	230.4624	3.4500000477	100.000000	1	6480.000000	0.700000	1.700000	1.000000	36
i1	230.736	3.4500000477	90.000000	1	7200.000000	0.700000	1.700000	1.000000	40
i1	230.8728	3.4500000477	85.714286	1	7560.000000	0.700000	1.700000	1.000000	42
i1	231.1464	3.4500000477	78.260870	1	8280.000000	0.700000	1.700000	1.000000	46
i1	231.2832	3.4500000477	75.000000	1	8640.000000	0.700000	1.700000	1.000000	48
i1	231.5568	3.4500000477	69.230769	1	9360.000000	0.700000	1.700000	1.000000	52
i1	231.8304	3.4500000477	64.285714	1	10080.000000	0.700000	1.700000	1.000000	56
i1	232.104	3.4500000477	60.000000	1	10800.000000	0.700000	1.700000	1.000000	60
i1	232.3776	3.4500000477	56.250000	1	11520.000000	0.700000	1.700000	1.000000	64
i1	235.5045	3.4500000477	55.384615	1	11700.000000	0.700000	1.700000	1.000000	65
i1	235.2273	3.4500000477	59.016393	1	10980.000000	0.700000	1.700000	1.000000	61
i1	234.9501	3.4500000477	63.157895	1	10260.000000	0.700000	1.700000	1.000000	57
i1	234.6729	3.4500000477	67.924528	1	9540.000000	0.700000	1.700000	1.000000	53
i1	234.3957	3.4500000477	73.469388	1	8820.000000	0.700000	1.700000	1.000000	49
i1	234.1185	3.4500000477	80.000000	1	8100.000000	0.700000	1.700000	1.000000	45
i1	233.7027	3.4500000477	92.307692	1	7020.000000	0.700000	1.700000	1.000000	39
i1	233.2869	3.4500000477	109.090909	1	5940.000000	0.700000	1.700000	1.000000	33
i1	232.8711	3.4500000477	133.333333	1	4860.000000	0.700000	1.700000	1.000000	27
i1	232.4553	3.4500000477	171.428571	1	3780.000000	0.700000	1.700000	1.000000	21
i1	232.0395	3.4500000477	240.000000	1	2700.000000	0.700000	1.700000	1.000000	15
i1	231.6237	3.4500000477	400.000000	1	1620.000000	0.700000	1.700000	1.000000	9
i1	231.2079	3.4500000477	1200.000000	1	540.000000	0.700000	1.700000	1.000000	3
i1	231.1386	3.4500000477	1800.000000	1	360.000000	0.700000	1.700000	1.000000	2
i1	231.2772	3.4500000477	900.000000	1	720.000000	0.700000	1.700000	1.000000	4
i1	231.5544	3.4500000477	450.000000	1	1440.000000	0.700000	1.700000	1.000000	8
i1	231.693	3.4500000477	360.000000	1	1800.000000	0.700000	1.700000	1.000000	10
i1	231.9702	3.4500000477	257.142857	1	2520.000000	0.700000	1.700000	1.000000	14
i1	232.1088	3.4500000477	225.000000	1	2880.000000	0.700000	1.700000	1.000000	16
i1	232.386	3.4500000477	180.000000	1	3600.000000	0.700000	1.700000	1.000000	20
i1	232.5246	3.4500000477	163.636364	1	3960.000000	0.700000	1.700000	1.000000	22
i1	232.8018	3.4500000477	138.461538	1	4680.000000	0.700000	1.700000	1.000000	26
i1	232.9404	3.4500000477	128.571429	1	5040.000000	0.700000	1.700000	1.000000	28
i1	233.2176	3.4500000477	112.500000	1	5760.000000	0.700000	1.700000	1.000000	32
i1	233.3562	3.4500000477	105.882353	1	6120.000000	0.700000	1.700000	1.000000	34
i1	233.6334	3.4500000477	94.736842	1	6840.000000	0.700000	1.700000	1.000000	38
i1	233.772	3.4500000477	90.000000	1	7200.000000	0.700000	1.700000	1.000000	40
i1	234.0492	3.4500000477	81.818182	1	7920.000000	0.700000	1.700000	1.000000	44
i1	234.1878	3.4500000477	78.260870	1	8280.000000	0.700000	1.700000	1.000000	46
i1	234.465	3.4500000477	72.000000	1	9000.000000	0.700000	1.700000	1.000000	50
i1	234.7422	3.4500000477	66.666667	1	9720.000000	0.700000	1.700000	1.000000	54
i1	235.0194	3.4500000477	62.068966	1	10440.000000	0.700000	1.700000	1.000000	58
i1	235.2966	3.4500000477	58.064516	1	11160.000000	0.700000	1.700000	1.000000	62
i1	235.5738	