/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.IOException;
import org.apache.fontbox.ttf.CmapSubtable;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.TrueTypeFont;

public class CmapTable
extends TTFTable {
    public static final String TAG = "cmap";
    public static final int PLATFORM_UNICODE = 0;
    public static final int PLATFORM_MACINTOSH = 1;
    public static final int PLATFORM_WINDOWS = 3;
    public static final int ENCODING_MAC_ROMAN = 0;
    public static final int ENCODING_WIN_SYMBOL = 0;
    public static final int ENCODING_WIN_UNICODE_BMP = 1;
    public static final int ENCODING_WIN_SHIFT_JIS = 2;
    public static final int ENCODING_WIN_BIG5 = 3;
    public static final int ENCODING_WIN_PRC = 4;
    public static final int ENCODING_WIN_WANSUNG = 5;
    public static final int ENCODING_WIN_JOHAB = 6;
    public static final int ENCODING_WIN_UNICODE_FULL = 10;
    public static final int ENCODING_UNICODE_1_0 = 0;
    public static final int ENCODING_UNICODE_1_1 = 1;
    public static final int ENCODING_UNICODE_2_0_BMP = 3;
    public static final int ENCODING_UNICODE_2_0_FULL = 4;
    private CmapSubtable[] cmaps;

    CmapTable(TrueTypeFont trueTypeFont) {
        super(trueTypeFont);
    }

    @Override
    public void read(TrueTypeFont trueTypeFont, TTFDataStream tTFDataStream) throws IOException {
        int n;
        int n2 = tTFDataStream.readUnsignedShort();
        int n3 = tTFDataStream.readUnsignedShort();
        this.cmaps = new CmapSubtable[n3];
        for (n = 0; n < n3; ++n) {
            CmapSubtable cmapSubtable = new CmapSubtable();
            cmapSubtable.initData(tTFDataStream);
            this.cmaps[n] = cmapSubtable;
        }
        for (n = 0; n < n3; ++n) {
            this.cmaps[n].initSubtable(this, trueTypeFont.getNumberOfGlyphs(), tTFDataStream);
        }
        this.initialized = true;
    }

    public CmapSubtable[] getCmaps() {
        return this.cmaps;
    }

    public void setCmaps(CmapSubtable[] cmapSubtableArray) {
        this.cmaps = cmapSubtableArray;
    }

    public CmapSubtable getSubtable(int n, int n2) {
        for (CmapSubtable cmapSubtable : this.cmaps) {
            if (cmapSubtable.getPlatformId() != n || cmapSubtable.getPlatformEncodingId() != n2) continue;
            return cmapSubtable;
        }
        return null;
    }
}

