/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.ttf.GlyphDescription;

class GlyphRenderer {
    private static final Log LOG = LogFactory.getLog(GlyphRenderer.class);
    private GlyphDescription glyphDescription;

    GlyphRenderer(GlyphDescription glyphDescription) {
        this.glyphDescription = glyphDescription;
    }

    public GeneralPath getPath() {
        Point[] pointArray = this.describe(this.glyphDescription);
        return this.calculatePath(pointArray);
    }

    private Point[] describe(GlyphDescription glyphDescription) {
        int n = 0;
        int n2 = -1;
        Point[] pointArray = new Point[glyphDescription.getPointCount()];
        for (int i = 0; i < glyphDescription.getPointCount(); ++i) {
            boolean bl;
            if (n2 == -1) {
                n2 = glyphDescription.getEndPtOfContours(n);
            }
            boolean bl2 = bl = n2 == i;
            if (bl) {
                ++n;
                n2 = -1;
            }
            pointArray[i] = new Point(glyphDescription.getXCoordinate(i), glyphDescription.getYCoordinate(i), (glyphDescription.getFlags(i) & 1) != 0, bl);
        }
        return pointArray;
    }

    private GeneralPath calculatePath(Point[] pointArray) {
        GeneralPath generalPath = new GeneralPath();
        int n = 0;
        int n2 = pointArray.length;
        for (int i = 0; i < n2; ++i) {
            int n3;
            if (!pointArray[i].endOfContour) continue;
            Point point = pointArray[n];
            Point point2 = pointArray[i];
            ArrayList<Point> arrayList = new ArrayList<Point>();
            for (n3 = n; n3 <= i; ++n3) {
                arrayList.add(pointArray[n3]);
            }
            if (pointArray[n].onCurve) {
                arrayList.add(point);
            } else if (pointArray[i].onCurve) {
                arrayList.add(0, point2);
            } else {
                Point point3 = this.midValue(point, point2);
                arrayList.add(0, point3);
                arrayList.add(point3);
            }
            this.moveTo(generalPath, (Point)arrayList.get(0));
            int n4 = arrayList.size();
            for (n3 = 1; n3 < n4; ++n3) {
                Point point4 = (Point)arrayList.get(n3);
                if (point4.onCurve) {
                    this.lineTo(generalPath, point4);
                    continue;
                }
                if (((Point)arrayList.get(n3 + 1)).onCurve) {
                    this.quadTo(generalPath, point4, (Point)arrayList.get(n3 + 1));
                    ++n3;
                    continue;
                }
                this.quadTo(generalPath, point4, this.midValue(point4, (Point)arrayList.get(n3 + 1)));
            }
            generalPath.closePath();
            n = i + 1;
        }
        return generalPath;
    }

    private void moveTo(GeneralPath generalPath, Point point) {
        generalPath.moveTo(point.x, point.y);
        if (LOG.isDebugEnabled()) {
            LOG.trace((Object)("moveTo: " + String.format("%d,%d", point.x, point.y)));
        }
    }

    private void lineTo(GeneralPath generalPath, Point point) {
        generalPath.lineTo(point.x, point.y);
        if (LOG.isDebugEnabled()) {
            LOG.trace((Object)("lineTo: " + String.format("%d,%d", point.x, point.y)));
        }
    }

    private void quadTo(GeneralPath generalPath, Point point, Point point2) {
        generalPath.quadTo(point.x, point.y, point2.x, point2.y);
        if (LOG.isDebugEnabled()) {
            LOG.trace((Object)("quadTo: " + String.format("%d,%d %d,%d", point.x, point.y, point2.x, point2.y)));
        }
    }

    private int midValue(int n, int n2) {
        return n + (n2 - n) / 2;
    }

    private Point midValue(Point point, Point point2) {
        return new Point(this.midValue(point.x, point2.x), this.midValue(point.y, point2.y));
    }

    private static class Point {
        private int x = 0;
        private int y = 0;
        private boolean onCurve = true;
        private boolean endOfContour = false;

        Point(int n, int n2, boolean bl, boolean bl2) {
            this.x = n;
            this.y = n2;
            this.onCurve = bl;
            this.endOfContour = bl2;
        }

        Point(int n, int n2) {
            this(n, n2, true, false);
        }

        public String toString() {
            return String.format("Point(%d,%d,%s,%s)", this.x, this.y, this.onCurve ? "onCurve" : "", this.endOfContour ? "endOfContour" : "");
        }
    }
}

