/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.IOException;
import org.apache.fontbox.ttf.HorizontalHeaderTable;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.TrueTypeFont;

public class HorizontalMetricsTable
extends TTFTable {
    public static final String TAG = "hmtx";
    private int[] advanceWidth;
    private short[] leftSideBearing;
    private short[] nonHorizontalLeftSideBearing;
    private int numHMetrics;

    HorizontalMetricsTable(TrueTypeFont trueTypeFont) {
        super(trueTypeFont);
    }

    @Override
    public void read(TrueTypeFont trueTypeFont, TTFDataStream tTFDataStream) throws IOException {
        int n;
        HorizontalHeaderTable horizontalHeaderTable = trueTypeFont.getHorizontalHeader();
        this.numHMetrics = horizontalHeaderTable.getNumberOfHMetrics();
        int n2 = trueTypeFont.getNumberOfGlyphs();
        int n3 = 0;
        this.advanceWidth = new int[this.numHMetrics];
        this.leftSideBearing = new short[this.numHMetrics];
        for (n = 0; n < this.numHMetrics; ++n) {
            this.advanceWidth[n] = tTFDataStream.readUnsignedShort();
            this.leftSideBearing[n] = tTFDataStream.readSignedShort();
            n3 += 4;
        }
        if ((long)n3 < this.getLength()) {
            n = n2 - this.numHMetrics;
            if (n < 0) {
                n = n2;
            }
            this.nonHorizontalLeftSideBearing = new short[n];
            for (int i = 0; i < n; ++i) {
                if ((long)n3 >= this.getLength()) continue;
                this.nonHorizontalLeftSideBearing[i] = tTFDataStream.readSignedShort();
                n3 += 2;
            }
        }
        this.initialized = true;
    }

    public int getAdvanceWidth(int n) {
        if (n < this.numHMetrics) {
            return this.advanceWidth[n];
        }
        return this.advanceWidth[this.advanceWidth.length - 1];
    }

    public int getLeftSideBearing(int n) {
        if (n < this.numHMetrics) {
            return this.leftSideBearing[n];
        }
        return this.nonHorizontalLeftSideBearing[n - this.numHMetrics];
    }
}

