/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.fontbox.ttf.CmapTable;
import org.apache.fontbox.ttf.DigitalSignatureTable;
import org.apache.fontbox.ttf.GlyphTable;
import org.apache.fontbox.ttf.HeaderTable;
import org.apache.fontbox.ttf.HorizontalHeaderTable;
import org.apache.fontbox.ttf.HorizontalMetricsTable;
import org.apache.fontbox.ttf.IndexToLocationTable;
import org.apache.fontbox.ttf.KerningTable;
import org.apache.fontbox.ttf.MaximumProfileTable;
import org.apache.fontbox.ttf.MemoryTTFDataStream;
import org.apache.fontbox.ttf.NamingTable;
import org.apache.fontbox.ttf.OS2WindowsMetricsTable;
import org.apache.fontbox.ttf.PostScriptTable;
import org.apache.fontbox.ttf.RAFDataStream;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.fontbox.ttf.VerticalHeaderTable;
import org.apache.fontbox.ttf.VerticalMetricsTable;
import org.apache.fontbox.ttf.VerticalOriginTable;

public class TTFParser {
    private boolean isEmbedded = false;
    private boolean parseOnDemandOnly = false;

    public TTFParser() {
        this(false);
    }

    public TTFParser(boolean bl) {
        this(bl, false);
    }

    public TTFParser(boolean bl, boolean bl2) {
        this.isEmbedded = bl;
        this.parseOnDemandOnly = bl2;
    }

    public TrueTypeFont parse(String string) throws IOException {
        return this.parse(new File(string));
    }

    public TrueTypeFont parse(File file) throws IOException {
        RAFDataStream rAFDataStream = new RAFDataStream(file, "r");
        try {
            return this.parse(rAFDataStream);
        }
        catch (IOException iOException) {
            rAFDataStream.close();
            throw iOException;
        }
    }

    public TrueTypeFont parse(InputStream inputStream) throws IOException {
        return this.parse(new MemoryTTFDataStream(inputStream));
    }

    public TrueTypeFont parseEmbedded(InputStream inputStream) throws IOException {
        this.isEmbedded = true;
        return this.parse(new MemoryTTFDataStream(inputStream));
    }

    TrueTypeFont parse(TTFDataStream tTFDataStream) throws IOException {
        TrueTypeFont trueTypeFont = this.newFont(tTFDataStream);
        trueTypeFont.setVersion(tTFDataStream.read32Fixed());
        int n = tTFDataStream.readUnsignedShort();
        int n2 = tTFDataStream.readUnsignedShort();
        int n3 = tTFDataStream.readUnsignedShort();
        int n4 = tTFDataStream.readUnsignedShort();
        for (int i = 0; i < n; ++i) {
            TTFTable tTFTable = this.readTableDirectory(trueTypeFont, tTFDataStream);
            if (tTFTable == null) continue;
            trueTypeFont.addTable(tTFTable);
        }
        if (!this.parseOnDemandOnly) {
            this.parseTables(trueTypeFont, tTFDataStream);
        }
        return trueTypeFont;
    }

    TrueTypeFont newFont(TTFDataStream tTFDataStream) {
        return new TrueTypeFont(tTFDataStream);
    }

    private void parseTables(TrueTypeFont trueTypeFont, TTFDataStream tTFDataStream) throws IOException {
        TTFTable tTFTable2;
        for (TTFTable tTFTable2 : trueTypeFont.getTables()) {
            if (tTFTable2.getInitialized()) continue;
            trueTypeFont.readTable(tTFTable2);
        }
        boolean bl = this.allowCFF() && trueTypeFont.tables.containsKey("CFF ");
        tTFTable2 = trueTypeFont.getHeader();
        if (tTFTable2 == null) {
            throw new IOException("head is mandatory");
        }
        HorizontalHeaderTable horizontalHeaderTable = trueTypeFont.getHorizontalHeader();
        if (horizontalHeaderTable == null) {
            throw new IOException("hhead is mandatory");
        }
        MaximumProfileTable maximumProfileTable = trueTypeFont.getMaximumProfile();
        if (maximumProfileTable == null) {
            throw new IOException("maxp is mandatory");
        }
        PostScriptTable postScriptTable = trueTypeFont.getPostScript();
        if (postScriptTable == null && !this.isEmbedded) {
            throw new IOException("post is mandatory");
        }
        if (!bl) {
            IndexToLocationTable indexToLocationTable = trueTypeFont.getIndexToLocation();
            if (indexToLocationTable == null) {
                throw new IOException("loca is mandatory");
            }
            if (trueTypeFont.getGlyph() == null) {
                throw new IOException("glyf is mandatory");
            }
        }
        if (trueTypeFont.getNaming() == null && !this.isEmbedded) {
            throw new IOException("name is mandatory");
        }
        if (trueTypeFont.getHorizontalMetrics() == null) {
            throw new IOException("hmtx is mandatory");
        }
        if (!this.isEmbedded && trueTypeFont.getCmap() == null) {
            throw new IOException("cmap is mandatory");
        }
    }

    protected boolean allowCFF() {
        return false;
    }

    private TTFTable readTableDirectory(TrueTypeFont trueTypeFont, TTFDataStream tTFDataStream) throws IOException {
        TTFTable tTFTable = null;
        String string = tTFDataStream.readString(4);
        tTFTable = string.equals("cmap") ? new CmapTable(trueTypeFont) : (string.equals("glyf") ? new GlyphTable(trueTypeFont) : (string.equals("head") ? new HeaderTable(trueTypeFont) : (string.equals("hhea") ? new HorizontalHeaderTable(trueTypeFont) : (string.equals("hmtx") ? new HorizontalMetricsTable(trueTypeFont) : (string.equals("loca") ? new IndexToLocationTable(trueTypeFont) : (string.equals("maxp") ? new MaximumProfileTable(trueTypeFont) : (string.equals("name") ? new NamingTable(trueTypeFont) : (string.equals("OS/2") ? new OS2WindowsMetricsTable(trueTypeFont) : (string.equals("post") ? new PostScriptTable(trueTypeFont) : (string.equals("DSIG") ? new DigitalSignatureTable(trueTypeFont) : (string.equals("kern") ? new KerningTable(trueTypeFont) : (string.equals("vhea") ? new VerticalHeaderTable(trueTypeFont) : (string.equals("vmtx") ? new VerticalMetricsTable(trueTypeFont) : (string.equals("VORG") ? new VerticalOriginTable(trueTypeFont) : this.readTable(trueTypeFont, string)))))))))))))));
        tTFTable.setTag(string);
        tTFTable.setCheckSum(tTFDataStream.readUnsignedInt());
        tTFTable.setOffset(tTFDataStream.readUnsignedInt());
        tTFTable.setLength(tTFDataStream.readUnsignedInt());
        if (tTFTable.getLength() == 0L && !string.equals("glyf")) {
            return null;
        }
        return tTFTable;
    }

    protected TTFTable readTable(TrueTypeFont trueTypeFont, String string) {
        return new TTFTable(trueTypeFont);
    }
}

