/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.ttf.CmapSubtable;
import org.apache.fontbox.ttf.GlyphTable;
import org.apache.fontbox.ttf.HeaderTable;
import org.apache.fontbox.ttf.HorizontalHeaderTable;
import org.apache.fontbox.ttf.HorizontalMetricsTable;
import org.apache.fontbox.ttf.MaximumProfileTable;
import org.apache.fontbox.ttf.NameRecord;
import org.apache.fontbox.ttf.NamingTable;
import org.apache.fontbox.ttf.OS2WindowsMetricsTable;
import org.apache.fontbox.ttf.PostScriptTable;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.fontbox.ttf.WGL4Names;

public final class TTFSubsetter {
    private static final Log LOG = LogFactory.getLog(TTFSubsetter.class);
    private static final byte[] PAD_BUF = new byte[]{0, 0, 0};
    private final TrueTypeFont ttf;
    private final CmapSubtable unicodeCmap;
    private final SortedMap<Integer, Integer> uniToGID;
    private final List<String> keepTables;
    private final SortedSet<Integer> glyphIds;
    private String prefix;
    private boolean hasAddedCompoundReferences;

    public TTFSubsetter(TrueTypeFont trueTypeFont) throws IOException {
        this(trueTypeFont, null);
    }

    public TTFSubsetter(TrueTypeFont trueTypeFont, List<String> list) throws IOException {
        this.ttf = trueTypeFont;
        this.keepTables = list;
        this.uniToGID = new TreeMap<Integer, Integer>();
        this.glyphIds = new TreeSet<Integer>();
        this.unicodeCmap = trueTypeFont.getUnicodeCmap();
        this.glyphIds.add(0);
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public void add(int n) {
        int n2 = this.unicodeCmap.getGlyphId(n);
        if (n2 != 0) {
            this.uniToGID.put(n, n2);
            this.glyphIds.add(n2);
        }
    }

    public void addAll(Set<Integer> set) {
        for (int n : set) {
            this.add(n);
        }
    }

    public Map<Integer, Integer> getGIDMap() throws IOException {
        this.addCompoundReferences();
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n = 0;
        Iterator iterator = this.glyphIds.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            hashMap.put(n, n2);
            ++n;
        }
        return hashMap;
    }

    private long writeFileHeader(DataOutputStream dataOutputStream, int n) throws IOException {
        dataOutputStream.writeInt(65536);
        dataOutputStream.writeShort(n);
        int n2 = Integer.highestOneBit(n);
        int n3 = n2 * 16;
        dataOutputStream.writeShort(n3);
        int n4 = this.log2(n2);
        dataOutputStream.writeShort(n4);
        int n5 = 16 * n - n3;
        dataOutputStream.writeShort(n5);
        return 65536L + this.toUInt32(n, n3) + this.toUInt32(n4, n5);
    }

    private long writeTableHeader(DataOutputStream dataOutputStream, String string, long l, byte[] byArray) throws IOException {
        long l2 = 0L;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            l2 += ((long)byArray[i] & 0xFFL) << 24 - i % 4 * 8;
        }
        byte[] byArray2 = string.getBytes("US-ASCII");
        dataOutputStream.write(byArray2, 0, 4);
        dataOutputStream.writeInt((int)(l2 &= 0xFFFFFFFFL));
        dataOutputStream.writeInt((int)l);
        dataOutputStream.writeInt(byArray.length);
        return this.toUInt32(byArray2) + l2 + l2 + l + (long)byArray.length;
    }

    private void writeTableBody(OutputStream outputStream, byte[] byArray) throws IOException {
        int n = byArray.length;
        outputStream.write(byArray);
        if (n % 4 != 0) {
            outputStream.write(PAD_BUF, 0, 4 - n % 4);
        }
    }

    private byte[] buildHeadTable() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        HeaderTable headerTable = this.ttf.getHeader();
        this.writeFixed(dataOutputStream, headerTable.getVersion());
        this.writeFixed(dataOutputStream, headerTable.getFontRevision());
        this.writeUint32(dataOutputStream, 0L);
        this.writeUint32(dataOutputStream, headerTable.getMagicNumber());
        this.writeUint16(dataOutputStream, headerTable.getFlags());
        this.writeUint16(dataOutputStream, headerTable.getUnitsPerEm());
        this.writeLongDateTime(dataOutputStream, headerTable.getCreated());
        this.writeLongDateTime(dataOutputStream, headerTable.getModified());
        this.writeSInt16(dataOutputStream, headerTable.getXMin());
        this.writeSInt16(dataOutputStream, headerTable.getYMin());
        this.writeSInt16(dataOutputStream, headerTable.getXMax());
        this.writeSInt16(dataOutputStream, headerTable.getYMax());
        this.writeUint16(dataOutputStream, headerTable.getMacStyle());
        this.writeUint16(dataOutputStream, headerTable.getLowestRecPPEM());
        this.writeSInt16(dataOutputStream, headerTable.getFontDirectionHint());
        this.writeSInt16(dataOutputStream, (short)1);
        this.writeSInt16(dataOutputStream, headerTable.getGlyphDataFormat());
        dataOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] buildHheaTable() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        HorizontalHeaderTable horizontalHeaderTable = this.ttf.getHorizontalHeader();
        this.writeFixed(dataOutputStream, horizontalHeaderTable.getVersion());
        this.writeSInt16(dataOutputStream, horizontalHeaderTable.getAscender());
        this.writeSInt16(dataOutputStream, horizontalHeaderTable.getDescender());
        this.writeSInt16(dataOutputStream, horizontalHeaderTable.getLineGap());
        this.writeUint16(dataOutputStream, horizontalHeaderTable.getAdvanceWidthMax());
        this.writeSInt16(dataOutputStream, horizontalHeaderTable.getMinLeftSideBearing());
        this.writeSInt16(dataOutputStream, horizontalHeaderTable.getMinRightSideBearing());
        this.writeSInt16(dataOutputStream, horizontalHeaderTable.getXMaxExtent());
        this.writeSInt16(dataOutputStream, horizontalHeaderTable.getCaretSlopeRise());
        this.writeSInt16(dataOutputStream, horizontalHeaderTable.getCaretSlopeRun());
        this.writeSInt16(dataOutputStream, horizontalHeaderTable.getReserved1());
        this.writeSInt16(dataOutputStream, horizontalHeaderTable.getReserved2());
        this.writeSInt16(dataOutputStream, horizontalHeaderTable.getReserved3());
        this.writeSInt16(dataOutputStream, horizontalHeaderTable.getReserved4());
        this.writeSInt16(dataOutputStream, horizontalHeaderTable.getReserved5());
        this.writeSInt16(dataOutputStream, horizontalHeaderTable.getMetricDataFormat());
        int n = this.glyphIds.subSet(0, horizontalHeaderTable.getNumberOfHMetrics()).size();
        if (this.glyphIds.last() >= horizontalHeaderTable.getNumberOfHMetrics() && !this.glyphIds.contains(horizontalHeaderTable.getNumberOfHMetrics() - 1)) {
            ++n;
        }
        this.writeUint16(dataOutputStream, n);
        dataOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    private boolean shouldCopyNameRecord(NameRecord nameRecord) {
        return nameRecord.getPlatformId() == 3 && nameRecord.getPlatformEncodingId() == 1 && nameRecord.getLanguageId() == 1033 && nameRecord.getNameId() >= 0 && nameRecord.getNameId() < 7;
    }

    /*
     * WARNING - void declaration
     */
    private byte[] buildNameTable() throws IOException {
        void var9_14;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        NamingTable namingTable = this.ttf.getNaming();
        if (namingTable == null || this.keepTables != null && !this.keepTables.contains("name")) {
            return null;
        }
        List<NameRecord> list = namingTable.getNameRecords();
        int n = 0;
        for (NameRecord nameRecord : list) {
            if (!this.shouldCopyNameRecord(nameRecord)) continue;
            ++n;
        }
        this.writeUint16(dataOutputStream, 0);
        this.writeUint16(dataOutputStream, n);
        this.writeUint16(dataOutputStream, 6 + 12 * n);
        if (n == 0) {
            return null;
        }
        Object object = new byte[n][];
        int n2 = 0;
        for (NameRecord object2 : list) {
            if (!this.shouldCopyNameRecord(object2)) continue;
            int n3 = object2.getPlatformId();
            int n4 = object2.getPlatformEncodingId();
            String string = "ISO-8859-1";
            if (n3 == 3 && n4 == 1) {
                string = "UTF-16BE";
            } else if (n3 == 2) {
                if (n4 == 0) {
                    string = "US-ASCII";
                } else if (n4 == 1) {
                    string = "UTF16-BE";
                } else if (n4 == 2) {
                    string = "ISO-8859-1";
                }
            }
            String string2 = object2.getString();
            if (object2.getNameId() == 6 && this.prefix != null) {
                string2 = this.prefix + string2;
            }
            object[n2] = string2.getBytes(string);
            ++n2;
        }
        int n5 = 0;
        n2 = 0;
        for (NameRecord nameRecord : list) {
            if (!this.shouldCopyNameRecord(nameRecord)) continue;
            this.writeUint16(dataOutputStream, nameRecord.getPlatformId());
            this.writeUint16(dataOutputStream, nameRecord.getPlatformEncodingId());
            this.writeUint16(dataOutputStream, nameRecord.getLanguageId());
            this.writeUint16(dataOutputStream, nameRecord.getNameId());
            this.writeUint16(dataOutputStream, ((Object)object[n2]).length);
            this.writeUint16(dataOutputStream, n5);
            n5 += ((Object)object[n2]).length;
            ++n2;
        }
        boolean bl = false;
        while (var9_14 < n) {
            dataOutputStream.write((byte[])object[var9_14]);
            ++var9_14;
        }
        dataOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] buildMaxpTable() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        MaximumProfileTable maximumProfileTable = this.ttf.getMaximumProfile();
        this.writeFixed(dataOutputStream, 1.0);
        this.writeUint16(dataOutputStream, this.glyphIds.size());
        this.writeUint16(dataOutputStream, maximumProfileTable.getMaxPoints());
        this.writeUint16(dataOutputStream, maximumProfileTable.getMaxContours());
        this.writeUint16(dataOutputStream, maximumProfileTable.getMaxCompositePoints());
        this.writeUint16(dataOutputStream, maximumProfileTable.getMaxCompositeContours());
        this.writeUint16(dataOutputStream, maximumProfileTable.getMaxZones());
        this.writeUint16(dataOutputStream, maximumProfileTable.getMaxTwilightPoints());
        this.writeUint16(dataOutputStream, maximumProfileTable.getMaxStorage());
        this.writeUint16(dataOutputStream, maximumProfileTable.getMaxFunctionDefs());
        this.writeUint16(dataOutputStream, maximumProfileTable.getMaxInstructionDefs());
        this.writeUint16(dataOutputStream, maximumProfileTable.getMaxStackElements());
        this.writeUint16(dataOutputStream, maximumProfileTable.getMaxSizeOfInstructions());
        this.writeUint16(dataOutputStream, maximumProfileTable.getMaxComponentElements());
        this.writeUint16(dataOutputStream, maximumProfileTable.getMaxComponentDepth());
        dataOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] buildOS2Table() throws IOException {
        OS2WindowsMetricsTable oS2WindowsMetricsTable = this.ttf.getOS2Windows();
        if (oS2WindowsMetricsTable == null || this.uniToGID.isEmpty() || this.keepTables != null && !this.keepTables.contains("OS/2")) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        this.writeUint16(dataOutputStream, oS2WindowsMetricsTable.getVersion());
        this.writeSInt16(dataOutputStream, oS2WindowsMetricsTable.getAverageCharWidth());
        this.writeUint16(dataOutputStream, oS2WindowsMetricsTable.getWeightClass());
        this.writeUint16(dataOutputStream, oS2WindowsMetricsTable.getWidthClass());
        this.writeSInt16(dataOutputStream, oS2WindowsMetricsTable.getFsType());
        this.writeSInt16(dataOutputStream, oS2WindowsMetricsTable.getSubscriptXSize());
        this.writeSInt16(dataOutputStream, oS2WindowsMetricsTable.getSubscriptYSize());
        this.writeSInt16(dataOutputStream, oS2WindowsMetricsTable.getSubscriptXOffset());
        this.writeSInt16(dataOutputStream, oS2WindowsMetricsTable.getSubscriptYOffset());
        this.writeSInt16(dataOutputStream, oS2WindowsMetricsTable.getSuperscriptXSize());
        this.writeSInt16(dataOutputStream, oS2WindowsMetricsTable.getSuperscriptYSize());
        this.writeSInt16(dataOutputStream, oS2WindowsMetricsTable.getSuperscriptXOffset());
        this.writeSInt16(dataOutputStream, oS2WindowsMetricsTable.getSuperscriptYOffset());
        this.writeSInt16(dataOutputStream, oS2WindowsMetricsTable.getStrikeoutSize());
        this.writeSInt16(dataOutputStream, oS2WindowsMetricsTable.getStrikeoutPosition());
        this.writeSInt16(dataOutputStream, (short)oS2WindowsMetricsTable.getFamilyClass());
        dataOutputStream.write(oS2WindowsMetricsTable.getPanose());
        this.writeUint32(dataOutputStream, 0L);
        this.writeUint32(dataOutputStream, 0L);
        this.writeUint32(dataOutputStream, 0L);
        this.writeUint32(dataOutputStream, 0L);
        dataOutputStream.write(oS2WindowsMetricsTable.getAchVendId().getBytes("US-ASCII"));
        this.writeUint16(dataOutputStream, oS2WindowsMetricsTable.getFsSelection());
        this.writeUint16(dataOutputStream, this.uniToGID.firstKey());
        this.writeUint16(dataOutputStream, this.uniToGID.lastKey());
        this.writeUint16(dataOutputStream, oS2WindowsMetricsTable.getTypoAscender());
        this.writeUint16(dataOutputStream, oS2WindowsMetricsTable.getTypoDescender());
        this.writeUint16(dataOutputStream, oS2WindowsMetricsTable.getTypoLineGap());
        this.writeUint16(dataOutputStream, oS2WindowsMetricsTable.getWinAscent());
        this.writeUint16(dataOutputStream, oS2WindowsMetricsTable.getWinDescent());
        dataOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] buildLocaTable(long[] lArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        for (long l : lArray) {
            this.writeUint32(dataOutputStream, l);
        }
        dataOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCompoundReferences() throws IOException {
        TreeSet<Integer> treeSet;
        boolean bl;
        if (this.hasAddedCompoundReferences) {
            return;
        }
        this.hasAddedCompoundReferences = true;
        do {
            GlyphTable glyphTable = this.ttf.getGlyph();
            long[] lArray = this.ttf.getIndexToLocation().getOffsets();
            treeSet = null;
            try (InputStream inputStream = this.ttf.getOriginalData();){
                inputStream.skip(glyphTable.getOffset());
                long l = 0L;
                for (Integer n : this.glyphIds) {
                    long l2 = lArray[n];
                    long l3 = lArray[n + 1] - l2;
                    inputStream.skip(l2 - l);
                    byte[] byArray = new byte[(int)l3];
                    inputStream.read(byArray);
                    if (byArray.length >= 2 && byArray[0] == -1 && byArray[1] == -1) {
                        int n2;
                        int n3 = 10;
                        do {
                            int n4;
                            n2 = (byArray[n3] & 0xFF) << 8 | byArray[n3 + 1] & 0xFF;
                            if (!this.glyphIds.contains(n4 = (byArray[n3 += 2] & 0xFF) << 8 | byArray[n3 + 1] & 0xFF)) {
                                if (treeSet == null) {
                                    treeSet = new TreeSet<Integer>();
                                }
                                treeSet.add(n4);
                            }
                            n3 += 2;
                            n3 = (n2 & 1) != 0 ? (n3 += 4) : (n3 += 2);
                            if ((n2 & 0x80) != 0) {
                                n3 += 8;
                                continue;
                            }
                            if ((n2 & 0x40) != 0) {
                                n3 += 4;
                                continue;
                            }
                            if ((n2 & 8) == 0) continue;
                            n3 += 2;
                        } while ((n2 & 0x20) != 0);
                    }
                    l = lArray[n + 1];
                }
            }
            if (treeSet == null) continue;
            this.glyphIds.addAll(treeSet);
        } while (bl = treeSet != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] buildGlyfTable(long[] lArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GlyphTable glyphTable = this.ttf.getGlyph();
        long[] lArray2 = this.ttf.getIndexToLocation().getOffsets();
        try (InputStream inputStream = this.ttf.getOriginalData();){
            inputStream.skip(glyphTable.getOffset());
            long l = 0L;
            long l2 = 0L;
            int n = 0;
            for (Integer n2 : this.glyphIds) {
                int n3;
                long l3 = lArray2[n2];
                long l4 = lArray2[n2 + 1] - l3;
                lArray[n++] = l2;
                inputStream.skip(l3 - l);
                byte[] byArray = new byte[(int)l4];
                inputStream.read(byArray);
                if (byArray.length >= 2 && byArray[0] == -1 && byArray[1] == -1) {
                    int n4;
                    int n5;
                    n3 = 10;
                    do {
                        n5 = (byArray[n3] & 0xFF) << 8 | byArray[n3 + 1] & 0xFF;
                        if (!this.glyphIds.contains(n4 = (byArray[n3 += 2] & 0xFF) << 8 | byArray[n3 + 1] & 0xFF)) {
                            this.glyphIds.add(n4);
                        }
                        int n6 = this.getNewGlyphId(n4);
                        byArray[n3] = (byte)(n6 >>> 8);
                        byArray[n3 + 1] = (byte)n6;
                        n3 += 2;
                        n3 = (n5 & 1) != 0 ? (n3 += 4) : (n3 += 2);
                        if ((n5 & 0x80) != 0) {
                            n3 += 8;
                            continue;
                        }
                        if ((n5 & 0x40) != 0) {
                            n3 += 4;
                            continue;
                        }
                        if ((n5 & 8) == 0) continue;
                        n3 += 2;
                    } while ((n5 & 0x20) != 0);
                    if ((n5 & 0x100) == 256) {
                        n4 = (byArray[n3] & 0xFF) << 8 | byArray[n3 + 1] & 0xFF;
                        n3 += 2;
                        n3 += n4;
                    }
                    byteArrayOutputStream.write(byArray, 0, n3);
                    l2 += (long)n3;
                } else if (byArray.length > 0) {
                    byteArrayOutputStream.write(byArray, 0, byArray.length);
                    l2 += (long)byArray.length;
                }
                if (l2 % 4L != 0L) {
                    n3 = 4 - (int)(l2 % 4L);
                    byteArrayOutputStream.write(PAD_BUF, 0, n3);
                    l2 += (long)n3;
                }
                l = l3 + l4;
            }
            lArray[n++] = l2;
        }
        return byteArrayOutputStream.toByteArray();
    }

    private int getNewGlyphId(Integer n) {
        return this.glyphIds.headSet(n).size();
    }

    private byte[] buildCmapTable() throws IOException {
        int n;
        Map.Entry<Integer, Integer> entry;
        if (this.ttf.getCmap() == null || this.uniToGID.isEmpty() || this.keepTables != null && !this.keepTables.contains("cmap")) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        this.writeUint16(dataOutputStream, 0);
        this.writeUint16(dataOutputStream, 1);
        this.writeUint16(dataOutputStream, 3);
        this.writeUint16(dataOutputStream, 1);
        this.writeUint32(dataOutputStream, 12L);
        Iterator<Map.Entry<Integer, Integer>> iterator = this.uniToGID.entrySet().iterator();
        Map.Entry<Integer, Integer> entry2 = entry = iterator.next();
        int n2 = this.getNewGlyphId(entry.getValue());
        int[] nArray = new int[this.uniToGID.size() + 1];
        int[] nArray2 = new int[this.uniToGID.size() + 1];
        int[] nArray3 = new int[this.uniToGID.size() + 1];
        int n3 = 0;
        while (iterator.hasNext()) {
            Map.Entry<Integer, Integer> entry3 = iterator.next();
            n = this.getNewGlyphId(entry3.getValue());
            if (entry3.getKey() > 65535) {
                throw new UnsupportedOperationException("non-BMP Unicode character");
            }
            if (entry3.getKey() != entry2.getKey() + 1 || n - n2 != entry3.getKey() - entry.getKey()) {
                if (n2 != 0) {
                    nArray[n3] = entry.getKey();
                    nArray2[n3] = entry2.getKey();
                    nArray3[n3] = n2 - entry.getKey();
                    ++n3;
                } else if (!entry.getKey().equals(entry2.getKey())) {
                    nArray[n3] = entry.getKey() + 1;
                    nArray2[n3] = entry2.getKey();
                    nArray3[n3] = n2 - entry.getKey();
                    ++n3;
                }
                n2 = n;
                entry = entry3;
            }
            entry2 = entry3;
        }
        nArray[n3] = entry.getKey();
        nArray2[n3] = entry2.getKey();
        nArray3[n3] = n2 - entry.getKey();
        nArray[++n3] = 65535;
        nArray2[n3] = 65535;
        nArray3[n3] = 1;
        int n4 = 2 * (int)Math.pow(2.0, this.log2(++n3));
        this.writeUint16(dataOutputStream, 4);
        this.writeUint16(dataOutputStream, 16 + n3 * 4 * 2);
        this.writeUint16(dataOutputStream, 0);
        this.writeUint16(dataOutputStream, n3 * 2);
        this.writeUint16(dataOutputStream, n4);
        this.writeUint16(dataOutputStream, this.log2(n4 / 2));
        this.writeUint16(dataOutputStream, 2 * n3 - n4);
        for (n = 0; n < n3; ++n) {
            this.writeUint16(dataOutputStream, nArray2[n]);
        }
        this.writeUint16(dataOutputStream, 0);
        for (n = 0; n < n3; ++n) {
            this.writeUint16(dataOutputStream, nArray[n]);
        }
        for (n = 0; n < n3; ++n) {
            this.writeUint16(dataOutputStream, nArray3[n]);
        }
        for (n = 0; n < n3; ++n) {
            this.writeUint16(dataOutputStream, 0);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] buildPostTable() throws IOException {
        Object object;
        PostScriptTable postScriptTable = this.ttf.getPostScript();
        if (postScriptTable == null || this.keepTables != null && !this.keepTables.contains("post")) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        this.writeFixed(dataOutputStream, 2.0);
        this.writeFixed(dataOutputStream, postScriptTable.getItalicAngle());
        this.writeSInt16(dataOutputStream, postScriptTable.getUnderlinePosition());
        this.writeSInt16(dataOutputStream, postScriptTable.getUnderlineThickness());
        this.writeUint32(dataOutputStream, postScriptTable.getIsFixedPitch());
        this.writeUint32(dataOutputStream, postScriptTable.getMinMemType42());
        this.writeUint32(dataOutputStream, postScriptTable.getMaxMemType42());
        this.writeUint32(dataOutputStream, postScriptTable.getMinMemType1());
        this.writeUint32(dataOutputStream, postScriptTable.getMaxMemType1());
        this.writeUint16(dataOutputStream, this.glyphIds.size());
        LinkedHashMap<Object, Integer> linkedHashMap = new LinkedHashMap<Object, Integer>();
        Iterator<Object> iterator = this.glyphIds.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            object = postScriptTable.getName(n);
            Integer n2 = WGL4Names.MAC_GLYPH_NAMES_INDICES.get(object);
            if (n2 != null) {
                this.writeUint16(dataOutputStream, n2);
                continue;
            }
            Integer n3 = (Integer)linkedHashMap.get(object);
            if (n3 == null) {
                n3 = linkedHashMap.size();
                linkedHashMap.put(object, n3);
            }
            this.writeUint16(dataOutputStream, 258 + n3);
        }
        for (String string : linkedHashMap.keySet()) {
            object = string.getBytes(Charset.forName("US-ASCII"));
            this.writeUint8(dataOutputStream, ((Object)object).length);
            dataOutputStream.write((byte[])object);
        }
        dataOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] buildHmtxTable() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        HorizontalHeaderTable horizontalHeaderTable = this.ttf.getHorizontalHeader();
        HorizontalMetricsTable horizontalMetricsTable = this.ttf.getHorizontalMetrics();
        InputStream inputStream = this.ttf.getOriginalData();
        int n = horizontalHeaderTable.getNumberOfHMetrics() - 1;
        boolean bl = false;
        if (this.glyphIds.last() > n && !this.glyphIds.contains(n)) {
            bl = true;
        }
        try {
            inputStream.skip(horizontalMetricsTable.getOffset());
            long l = 0L;
            for (Integer n2 : this.glyphIds) {
                long l2;
                if (n2 <= n) {
                    l2 = n2 * 4;
                    l = this.copyBytes(inputStream, byteArrayOutputStream, l2, l, 4);
                    continue;
                }
                if (bl) {
                    bl = false;
                    l2 = n * 4;
                    l = this.copyBytes(inputStream, byteArrayOutputStream, l2, l, 2);
                }
                l2 = horizontalHeaderTable.getNumberOfHMetrics() * 4 + (n2 - horizontalHeaderTable.getNumberOfHMetrics()) * 2;
                l = this.copyBytes(inputStream, byteArrayOutputStream, l2, l, 2);
            }
            Object object = byteArrayOutputStream.toByteArray();
            return object;
        }
        finally {
            inputStream.close();
        }
    }

    private long copyBytes(InputStream inputStream, OutputStream outputStream, long l, long l2, int n) throws IOException {
        long l3 = l - l2;
        if (l3 != inputStream.skip(l3)) {
            throw new EOFException("Unexpected EOF exception parsing glyphId of hmtx table.");
        }
        byte[] byArray = new byte[n];
        if (n != inputStream.read(byArray, 0, n)) {
            throw new EOFException("Unexpected EOF exception parsing glyphId of hmtx table.");
        }
        outputStream.write(byArray, 0, n);
        return l + (long)n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToStream(OutputStream outputStream) throws IOException {
        if (this.glyphIds.isEmpty() || this.uniToGID.isEmpty()) {
            LOG.info((Object)"font subset is empty");
        }
        this.addCompoundReferences();
        try (DataOutputStream dataOutputStream = new DataOutputStream(outputStream);){
            long[] lArray = new long[this.glyphIds.size() + 1];
            byte[] byArray = this.buildHeadTable();
            byte[] byArray2 = this.buildHheaTable();
            byte[] byArray3 = this.buildMaxpTable();
            byte[] byArray4 = this.buildNameTable();
            byte[] byArray5 = this.buildOS2Table();
            byte[] byArray6 = this.buildGlyfTable(lArray);
            byte[] byArray7 = this.buildLocaTable(lArray);
            byte[] byArray8 = this.buildCmapTable();
            byte[] byArray9 = this.buildHmtxTable();
            byte[] byArray10 = this.buildPostTable();
            TreeMap<String, byte[]> treeMap = new TreeMap<String, byte[]>();
            if (byArray5 != null) {
                treeMap.put("OS/2", byArray5);
            }
            if (byArray8 != null) {
                treeMap.put("cmap", byArray8);
            }
            if (byArray6 != null) {
                treeMap.put("glyf", byArray6);
            }
            treeMap.put("head", byArray);
            treeMap.put("hhea", byArray2);
            treeMap.put("hmtx", byArray9);
            if (byArray7 != null) {
                treeMap.put("loca", byArray7);
            }
            treeMap.put("maxp", byArray3);
            if (byArray4 != null) {
                treeMap.put("name", byArray4);
            }
            if (byArray10 != null) {
                treeMap.put("post", byArray10);
            }
            for (Map.Entry<String, TTFTable> entry : this.ttf.getTableMap().entrySet()) {
                String string = entry.getKey();
                TTFTable tTFTable = entry.getValue();
                if (treeMap.containsKey(string) || this.keepTables != null && !this.keepTables.contains(string)) continue;
                treeMap.put(string, this.ttf.getTableBytes(tTFTable));
            }
            long l = this.writeFileHeader(dataOutputStream, treeMap.size());
            long l2 = 12L + 16L * (long)treeMap.size();
            for (Map.Entry object : treeMap.entrySet()) {
                l += this.writeTableHeader(dataOutputStream, (String)object.getKey(), l2, (byte[])object.getValue());
                l2 += (long)((((byte[])object.getValue()).length + 3) / 4 * 4);
            }
            l = 2981146554L - (l & 0xFFFFFFFFL);
            byArray[8] = (byte)(l >>> 24);
            byArray[9] = (byte)(l >>> 16);
            byArray[10] = (byte)(l >>> 8);
            byArray[11] = (byte)l;
            for (byte[] byArray11 : treeMap.values()) {
                this.writeTableBody(dataOutputStream, byArray11);
            }
        }
    }

    private void writeFixed(DataOutputStream dataOutputStream, double d) throws IOException {
        double d2 = Math.floor(d);
        double d3 = (d - d2) * 65536.0;
        dataOutputStream.writeShort((int)d2);
        dataOutputStream.writeShort((int)d3);
    }

    private void writeUint32(DataOutputStream dataOutputStream, long l) throws IOException {
        dataOutputStream.writeInt((int)l);
    }

    private void writeUint16(DataOutputStream dataOutputStream, int n) throws IOException {
        dataOutputStream.writeShort(n);
    }

    private void writeSInt16(DataOutputStream dataOutputStream, short s) throws IOException {
        dataOutputStream.writeShort(s);
    }

    private void writeUint8(DataOutputStream dataOutputStream, int n) throws IOException {
        dataOutputStream.writeByte(n);
    }

    private void writeLongDateTime(DataOutputStream dataOutputStream, Calendar calendar) throws IOException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(1904, 0, 1);
        long l = gregorianCalendar.getTimeInMillis();
        long l2 = (calendar.getTimeInMillis() - l) / 1000L;
        dataOutputStream.writeLong(l2);
    }

    private long toUInt32(int n, int n2) {
        return ((long)n & 0xFFFFL) << 16 | (long)n2 & 0xFFFFL;
    }

    private long toUInt32(byte[] byArray) {
        return ((long)byArray[0] & 0xFFL) << 24 | ((long)byArray[1] & 0xFFL) << 16 | ((long)byArray[2] & 0xFFL) << 8 | (long)byArray[3] & 0xFFL;
    }

    private int log2(int n) {
        return (int)Math.round(Math.log(n) / Math.log(2.0));
    }
}

