/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.fontbox.ttf.MemoryTTFDataStream;
import org.apache.fontbox.ttf.OTFParser;
import org.apache.fontbox.ttf.RAFDataStream;
import org.apache.fontbox.ttf.TTCDataStream;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeFont;

public class TrueTypeCollection
implements Closeable {
    private final TTFDataStream stream;
    private final int numFonts;
    private final long[] fontOffsets;

    public TrueTypeCollection(File file) throws IOException {
        this(new RAFDataStream(file, "r"));
    }

    public TrueTypeCollection(InputStream inputStream) throws IOException {
        this(new MemoryTTFDataStream(inputStream));
    }

    TrueTypeCollection(TTFDataStream tTFDataStream) throws IOException {
        int n;
        this.stream = tTFDataStream;
        String string = tTFDataStream.readTag();
        if (!string.equals("ttcf")) {
            throw new IOException("Missing TTC header");
        }
        float f = tTFDataStream.read32Fixed();
        this.numFonts = (int)tTFDataStream.readUnsignedInt();
        this.fontOffsets = new long[this.numFonts];
        for (n = 0; n < this.numFonts; ++n) {
            this.fontOffsets[n] = tTFDataStream.readUnsignedInt();
        }
        if (f >= 2.0f) {
            n = tTFDataStream.readUnsignedShort();
            int n2 = tTFDataStream.readUnsignedShort();
            int n3 = tTFDataStream.readUnsignedShort();
        }
    }

    public void processAllFonts(TrueTypeFontProcessor trueTypeFontProcessor) throws IOException {
        for (int i = 0; i < this.numFonts; ++i) {
            TrueTypeFont trueTypeFont = this.getFontAtIndex(i);
            trueTypeFontProcessor.process(trueTypeFont);
        }
    }

    private TrueTypeFont getFontAtIndex(int n) throws IOException {
        this.stream.seek(this.fontOffsets[n]);
        TTFParser tTFParser = this.stream.readTag().equals("OTTO") ? new OTFParser(false, true) : new TTFParser(false, true);
        this.stream.seek(this.fontOffsets[n]);
        return tTFParser.parse(new TTCDataStream(this.stream));
    }

    public TrueTypeFont getFontByName(String string) throws IOException {
        for (int i = 0; i < this.numFonts; ++i) {
            TrueTypeFont trueTypeFont = this.getFontAtIndex(i);
            if (!trueTypeFont.getName().equals(string)) continue;
            return trueTypeFont;
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    public static interface TrueTypeFontProcessor {
        public void process(TrueTypeFont var1) throws IOException;
    }
}

