/*
 * Decompiled with CFR 0.152.
 */
package plugins.UPnP.org.cybergarage.upnp.control;

import plugins.UPnP.org.cybergarage.http.HTTPRequest;
import plugins.UPnP.org.cybergarage.soap.SOAP;
import plugins.UPnP.org.cybergarage.soap.SOAPResponse;
import plugins.UPnP.org.cybergarage.upnp.Service;
import plugins.UPnP.org.cybergarage.upnp.StateVariable;
import plugins.UPnP.org.cybergarage.upnp.control.ControlRequest;
import plugins.UPnP.org.cybergarage.upnp.control.QueryResponse;
import plugins.UPnP.org.cybergarage.xml.Node;

public class QueryRequest
extends ControlRequest {
    public QueryRequest() {
    }

    public QueryRequest(HTTPRequest httpReq) {
        this.set(httpReq);
    }

    private Node getVarNameNode() {
        Node bodyNode = this.getBodyNode();
        if (bodyNode == null) {
            return null;
        }
        if (!bodyNode.hasNodes()) {
            return null;
        }
        Node queryStateVarNode = bodyNode.getNode(0);
        if (queryStateVarNode == null) {
            return null;
        }
        if (!queryStateVarNode.hasNodes()) {
            return null;
        }
        return queryStateVarNode.getNode(0);
    }

    public String getVarName() {
        Node node = this.getVarNameNode();
        if (node == null) {
            return "";
        }
        return node.getValue();
    }

    public void setRequest(StateVariable stateVar) {
        Service service = stateVar.getService();
        this.setRequestHost(service);
        this.setEnvelopeNode(SOAP.createEnvelopeBodyNode());
        Node envNode = this.getEnvelopeNode();
        Node bodyNode = this.getBodyNode();
        Node qeuryNode = this.createContentNode(stateVar);
        bodyNode.addNode(qeuryNode);
        this.setContent(envNode);
        this.setSOAPAction("urn:schemas-upnp-org:control-1-0#QueryStateVariable");
    }

    private Node createContentNode(StateVariable stateVar) {
        Node queryVarNode = new Node();
        queryVarNode.setName("u", "QueryStateVariable");
        queryVarNode.setNameSpace("u", "urn:schemas-upnp-org:control-1-0");
        Node varNode = new Node();
        varNode.setName("u", "varName");
        varNode.setValue(stateVar.getName());
        queryVarNode.addNode(varNode);
        return queryVarNode;
    }

    public QueryResponse post() {
        SOAPResponse soapRes = this.postMessage(this.getRequestHost(), this.getRequestPort());
        return new QueryResponse(soapRes);
    }
}

