/*
 * Decompiled with CFR 0.152.
 */
package plugins.UPnP.org.cybergarage.upnp.ssdp;

import plugins.UPnP.org.cybergarage.net.HostInterface;
import plugins.UPnP.org.cybergarage.upnp.device.SearchListener;
import plugins.UPnP.org.cybergarage.upnp.ssdp.HTTPMUSocket;
import plugins.UPnP.org.cybergarage.upnp.ssdp.SSDP;
import plugins.UPnP.org.cybergarage.upnp.ssdp.SSDPPacket;
import plugins.UPnP.org.cybergarage.util.ListenerList;

public class SSDPSearchSocket
extends HTTPMUSocket
implements Runnable {
    private ListenerList deviceSearchListenerList = new ListenerList();
    private Thread deviceSearchThread = null;

    public SSDPSearchSocket() {
    }

    public SSDPSearchSocket(String bindAddr) {
        this.open(bindAddr);
    }

    public boolean open(String bindAddr) {
        String addr = "239.255.255.250";
        if (HostInterface.isIPv6Address(bindAddr)) {
            addr = SSDP.getIPv6Address();
        }
        return this.open(addr, 1900, bindAddr);
    }

    public void addSearchListener(SearchListener listener) {
        this.deviceSearchListenerList.add(listener);
    }

    public void removeSearchListener(SearchListener listener) {
        this.deviceSearchListenerList.remove(listener);
    }

    public void performSearchListener(SSDPPacket ssdpPacket) {
        int listenerSize = this.deviceSearchListenerList.size();
        for (int n = 0; n < listenerSize; ++n) {
            SearchListener listener = (SearchListener)this.deviceSearchListenerList.get(n);
            listener.deviceSearchReceived(ssdpPacket);
        }
    }

    @Override
    public void run() {
        Thread thisThread = Thread.currentThread();
        while (this.deviceSearchThread == thisThread) {
            Thread.yield();
            SSDPPacket packet = this.receive();
            if (packet == null || !packet.isDiscover()) continue;
            this.performSearchListener(packet);
        }
    }

    public void start() {
        this.deviceSearchThread = new Thread((Runnable)this, "UPnP-SSDPSearchSocket");
        this.deviceSearchThread.setDaemon(true);
        this.deviceSearchThread.start();
    }

    public void stop() {
        this.close();
        this.deviceSearchThread = null;
    }
}

