/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.foundation;

import com.db4o.foundation.DeepClone;
import com.db4o.foundation.NotImplementedException;
import com.db4o.foundation.Predicate4;
import com.db4o.foundation.ShallowClone;
import com.db4o.foundation.Visitor4;

public abstract class Tree
implements ShallowClone,
DeepClone {
    public Tree _preceding;
    public int _size = 1;
    public Tree _subsequent;

    public static final Tree add(Tree a_old, Tree a_new) {
        if (a_old == null) {
            return a_new;
        }
        return a_old.add(a_new);
    }

    public Tree add(Tree a_new) {
        return this.add(a_new, this.compare(a_new));
    }

    /*
     * Enabled aggressive block sorting
     */
    public Tree add(Tree a_new, int a_cmp) {
        if (a_cmp < 0) {
            if (this._subsequent == null) {
                this._subsequent = a_new;
                ++this._size;
                return this;
            }
            this._subsequent = this._subsequent.add(a_new);
            if (this._preceding != null) return this.balance();
            return this.rotateLeft();
        }
        if (a_cmp <= 0 && !a_new.duplicates()) {
            a_new.onAttemptToAddDuplicate(this);
            return this;
        }
        if (this._preceding == null) {
            this._preceding = a_new;
            ++this._size;
            return this;
        }
        this._preceding = this._preceding.add(a_new);
        if (this._subsequent != null) return this.balance();
        return this.rotateRight();
    }

    public Tree addedOrExisting() {
        if (this.wasAddedToTree()) {
            return this;
        }
        return this._preceding;
    }

    public boolean wasAddedToTree() {
        return this._size != 0;
    }

    public final Tree balance() {
        int cmp = this._subsequent.nodes() - this._preceding.nodes();
        if (cmp < -2) {
            return this.rotateRight();
        }
        if (cmp > 2) {
            return this.rotateLeft();
        }
        this.setSizeOwnPrecedingSubsequent();
        return this;
    }

    public Tree balanceCheckNulls() {
        if (this._subsequent == null) {
            if (this._preceding == null) {
                this.setSizeOwn();
                return this;
            }
            return this.rotateRight();
        }
        if (this._preceding == null) {
            return this.rotateLeft();
        }
        return this.balance();
    }

    public void calculateSize() {
        if (this._preceding == null) {
            if (this._subsequent == null) {
                this.setSizeOwn();
            } else {
                this.setSizeOwnSubsequent();
            }
        } else if (this._subsequent == null) {
            this.setSizeOwnPreceding();
        } else {
            this.setSizeOwnPrecedingSubsequent();
        }
    }

    public abstract int compare(Tree var1);

    public static Tree deepClone(Tree a_tree, Object a_param) {
        if (a_tree == null) {
            return null;
        }
        Tree newNode = (Tree)a_tree.deepClone(a_param);
        newNode._size = a_tree._size;
        newNode._preceding = Tree.deepClone(a_tree._preceding, a_param);
        newNode._subsequent = Tree.deepClone(a_tree._subsequent, a_param);
        return newNode;
    }

    @Override
    public Object deepClone(Object a_param) {
        return this.shallowClone();
    }

    public boolean duplicates() {
        return true;
    }

    public final Tree filter(Predicate4 a_filter) {
        if (this._preceding != null) {
            this._preceding = this._preceding.filter(a_filter);
        }
        if (this._subsequent != null) {
            this._subsequent = this._subsequent.filter(a_filter);
        }
        if (!a_filter.match(this)) {
            return this.remove();
        }
        return this;
    }

    public static final Tree find(Tree a_in, Tree a_tree) {
        if (a_in == null) {
            return null;
        }
        return a_in.find(a_tree);
    }

    public final Tree find(Tree a_tree) {
        int cmp = this.compare(a_tree);
        if (cmp < 0) {
            if (this._subsequent != null) {
                return this._subsequent.find(a_tree);
            }
        } else if (cmp > 0) {
            if (this._preceding != null) {
                return this._preceding.find(a_tree);
            }
        } else {
            return this;
        }
        return null;
    }

    public static final Tree findGreaterOrEqual(Tree a_in, Tree a_finder) {
        if (a_in == null) {
            return null;
        }
        int cmp = a_in.compare(a_finder);
        if (cmp == 0) {
            return a_in;
        }
        if (cmp > 0) {
            Tree node = Tree.findGreaterOrEqual(a_in._preceding, a_finder);
            if (node != null) {
                return node;
            }
            return a_in;
        }
        return Tree.findGreaterOrEqual(a_in._subsequent, a_finder);
    }

    public static final Tree findSmaller(Tree a_in, Tree a_node) {
        if (a_in == null) {
            return null;
        }
        int cmp = a_in.compare(a_node);
        if (cmp < 0) {
            Tree node = Tree.findSmaller(a_in._subsequent, a_node);
            if (node != null) {
                return node;
            }
            return a_in;
        }
        return Tree.findSmaller(a_in._preceding, a_node);
    }

    public final Tree first() {
        if (this._preceding == null) {
            return this;
        }
        return this._preceding.first();
    }

    public static Tree last(Tree tree) {
        if (tree == null) {
            return null;
        }
        return tree.last();
    }

    public final Tree last() {
        if (this._subsequent == null) {
            return this;
        }
        return this._subsequent.last();
    }

    public void onAttemptToAddDuplicate(Tree a_tree) {
        this._size = 0;
        this._preceding = a_tree;
    }

    public int nodes() {
        return this._size;
    }

    public int ownSize() {
        return 1;
    }

    public Tree remove() {
        if (this._subsequent != null && this._preceding != null) {
            this._subsequent = this._subsequent.rotateSmallestUp();
            this._subsequent._preceding = this._preceding;
            this._subsequent.calculateSize();
            return this._subsequent;
        }
        if (this._subsequent != null) {
            return this._subsequent;
        }
        return this._preceding;
    }

    public void removeChildren() {
        this._preceding = null;
        this._subsequent = null;
        this.setSizeOwn();
    }

    public Tree removeFirst() {
        if (this._preceding == null) {
            return this._subsequent;
        }
        this._preceding = this._preceding.removeFirst();
        this.calculateSize();
        return this;
    }

    public static Tree removeLike(Tree from, Tree a_find) {
        if (from == null) {
            return null;
        }
        return from.removeLike(a_find);
    }

    public final Tree removeLike(Tree a_find) {
        int cmp = this.compare(a_find);
        if (cmp == 0) {
            return this.remove();
        }
        if (cmp > 0) {
            if (this._preceding != null) {
                this._preceding = this._preceding.removeLike(a_find);
            }
        } else if (this._subsequent != null) {
            this._subsequent = this._subsequent.removeLike(a_find);
        }
        this.calculateSize();
        return this;
    }

    public final Tree removeNode(Tree a_tree) {
        if (this == a_tree) {
            return this.remove();
        }
        int cmp = this.compare(a_tree);
        if (cmp >= 0 && this._preceding != null) {
            this._preceding = this._preceding.removeNode(a_tree);
        }
        if (cmp <= 0 && this._subsequent != null) {
            this._subsequent = this._subsequent.removeNode(a_tree);
        }
        this.calculateSize();
        return this;
    }

    public final Tree rotateLeft() {
        Tree tree = this._subsequent;
        this._subsequent = tree._preceding;
        this.calculateSize();
        tree._preceding = this;
        if (tree._subsequent == null) {
            tree.setSizeOwnPlus(this);
        } else {
            tree.setSizeOwnPlus(this, tree._subsequent);
        }
        return tree;
    }

    public final Tree rotateRight() {
        Tree tree = this._preceding;
        this._preceding = tree._subsequent;
        this.calculateSize();
        tree._subsequent = this;
        if (tree._preceding == null) {
            tree.setSizeOwnPlus(this);
        } else {
            tree.setSizeOwnPlus(this, tree._preceding);
        }
        return tree;
    }

    private final Tree rotateSmallestUp() {
        if (this._preceding != null) {
            this._preceding = this._preceding.rotateSmallestUp();
            return this.rotateRight();
        }
        return this;
    }

    public void setSizeOwn() {
        this._size = this.ownSize();
    }

    public void setSizeOwnPrecedingSubsequent() {
        this._size = this.ownSize() + this._preceding._size + this._subsequent._size;
    }

    public void setSizeOwnPreceding() {
        this._size = this.ownSize() + this._preceding._size;
    }

    public void setSizeOwnSubsequent() {
        this._size = this.ownSize() + this._subsequent._size;
    }

    public void setSizeOwnPlus(Tree tree) {
        this._size = this.ownSize() + tree._size;
    }

    public void setSizeOwnPlus(Tree tree1, Tree tree2) {
        this._size = this.ownSize() + tree1._size + tree2._size;
    }

    public static int size(Tree a_tree) {
        if (a_tree == null) {
            return 0;
        }
        return a_tree.size();
    }

    public int size() {
        return this._size;
    }

    public static final void traverse(Tree tree, Visitor4 visitor) {
        if (tree == null) {
            return;
        }
        tree.traverse(visitor);
    }

    public final void traverse(Visitor4 a_visitor) {
        if (this._preceding != null) {
            this._preceding.traverse(a_visitor);
        }
        a_visitor.visit(this);
        if (this._subsequent != null) {
            this._subsequent.traverse(a_visitor);
        }
    }

    public final void traverseFromLeaves(Visitor4 a_visitor) {
        if (this._preceding != null) {
            this._preceding.traverseFromLeaves(a_visitor);
        }
        if (this._subsequent != null) {
            this._subsequent.traverseFromLeaves(a_visitor);
        }
        a_visitor.visit(this);
    }

    protected Tree shallowCloneInternal(Tree tree) {
        tree._preceding = this._preceding;
        tree._size = this._size;
        tree._subsequent = this._subsequent;
        return tree;
    }

    @Override
    public Object shallowClone() {
        throw new NotImplementedException();
    }

    public abstract Object key();

    public Object root() {
        return this;
    }

    public static final class ByRef {
        public Tree value;

        public ByRef() {
        }

        public ByRef(Tree initialValue) {
            this.value = initialValue;
        }
    }
}

