/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.ext.Db4oIOException;
import com.db4o.ext.IncompatibleFileFormatException;
import com.db4o.ext.OldFormatException;
import com.db4o.foundation.Cool;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.LatinStringIO;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.Platform4;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.SystemData;
import com.db4o.internal.Transaction;
import com.db4o.internal.fileheader.FileHeader;
import com.db4o.internal.fileheader.TimerFileLock;
import com.db4o.internal.handlers.IntHandler;

public final class ConfigBlock {
    private final LocalObjectContainer _container;
    private final TimerFileLock _timerFileLock;
    private int _address;
    private Transaction _transactionToCommit;
    public int _bootRecordID;
    private static final int MINIMUM_LENGTH = 21;
    static final int OPEN_TIME_OFFSET = 4;
    public static final int ACCESS_TIME_OFFSET = 12;
    public static final int TRANSACTION_OFFSET = 21;
    private static final int BOOTRECORD_OFFSET = 29;
    private static final int INT_FORMERLY_KNOWN_AS_BLOCK_OFFSET = 33;
    private static final int ENCRYPTION_PASSWORD_LENGTH = 5;
    private static final int PASSWORD_OFFSET = 38;
    private static final int FREESPACE_SYSTEM_OFFSET = 39;
    private static final int FREESPACE_ADDRESS_OFFSET = 43;
    private static final int CONVERTER_VERSION_OFFSET = 47;
    private static final int UUID_INDEX_ID_OFFSET = 51;
    private static final int LENGTH = 55;

    public static ConfigBlock forNewFile(LocalObjectContainer file) throws Db4oIOException {
        return new ConfigBlock(file, true, 0);
    }

    public static ConfigBlock forExistingFile(LocalObjectContainer file, int address) throws Db4oIOException, OldFormatException {
        return new ConfigBlock(file, false, address);
    }

    private ConfigBlock(LocalObjectContainer stream, boolean isNew, int address) throws Db4oIOException, OldFormatException {
        this._container = stream;
        this._timerFileLock = TimerFileLock.forFile(stream);
        this.timerFileLock().writeHeaderLock();
        if (!isNew) {
            this.read(address);
        }
        this.timerFileLock().start();
    }

    private TimerFileLock timerFileLock() {
        return this._timerFileLock;
    }

    public long openTime() {
        return this.timerFileLock().openTime();
    }

    public Transaction getTransactionToCommit() {
        return this._transactionToCommit;
    }

    private byte[] passwordToken() {
        byte[] pwdtoken = new byte[5];
        String fullpwd = this.configImpl().password();
        if (this.configImpl().encrypt() && fullpwd != null) {
            try {
                byte[] pwdbytes = new LatinStringIO().write(fullpwd);
                StatefulBuffer encwriter = new StatefulBuffer(this._container.transaction(), pwdbytes.length + 5);
                encwriter.append(pwdbytes);
                encwriter.append(new byte[5]);
                this._container._handlers.decrypt(encwriter);
                System.arraycopy(encwriter._buffer, 0, pwdtoken, 0, 5);
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
        return pwdtoken;
    }

    private SystemData systemData() {
        return this._container.systemData();
    }

    private void read(int address) throws Db4oIOException, OldFormatException {
        int uuidIndexId;
        this.addressChanged(address);
        this.timerFileLock().writeOpenTime();
        StatefulBuffer reader = this._container.getWriter(this._container.systemTransaction(), this._address, 55);
        this._container.readBytes(reader._buffer, this._address, 55);
        int oldLength = reader.readInt();
        if (oldLength > 55 || oldLength < 21) {
            throw new IncompatibleFileFormatException();
        }
        if (oldLength != 55 && !this.allowVersionUpdate()) {
            if (this.allowAutomaticShutdown()) {
                Platform4.removeShutDownHook(this._container);
            }
            throw new OldFormatException();
        }
        reader.readLong();
        long lastAccessTime = reader.readLong();
        this.systemData().stringEncoding(reader.readByte());
        if (oldLength > 21) {
            this._transactionToCommit = LocalTransaction.readInterruptedTransaction(this._container, reader);
        }
        if (oldLength > 29) {
            this._bootRecordID = reader.readInt();
        }
        if (oldLength > 33) {
            reader.readInt();
        }
        if (oldLength > 38) {
            byte[] encpassword = reader.readBytes(5);
            boolean nonZeroByte = false;
            for (int i = 0; i < encpassword.length; ++i) {
                if (encpassword[i] == 0) continue;
                nonZeroByte = true;
                break;
            }
            if (!nonZeroByte) {
                this._container._handlers.oldEncryptionOff();
            } else {
                byte[] storedpwd = this.passwordToken();
                for (int idx = 0; idx < storedpwd.length; ++idx) {
                    if (storedpwd[idx] == encpassword[idx]) continue;
                    this._container.fatalException(54);
                }
            }
        }
        if (oldLength > 39) {
            this.systemData().freespaceSystem(reader.readByte());
        }
        if (oldLength > 43) {
            this.systemData().freespaceAddress(reader.readInt());
        }
        if (oldLength > 47) {
            this.systemData().converterVersion(reader.readInt());
        }
        if (oldLength > 51 && 0 != (uuidIndexId = reader.readInt())) {
            this.systemData().uuidIndexId(uuidIndexId);
        }
        this._container.ensureFreespaceSlot();
        if (FileHeader.lockedByOtherSession(this._container, lastAccessTime)) {
            this._timerFileLock.checkIfOtherSessionAlive(this._container, this._address, 12, lastAccessTime);
        }
        if (this._container.needsLockFileThread()) {
            Cool.sleepIgnoringInterruption(100L);
            this._container.syncFiles();
            this.timerFileLock().checkOpenTime();
        }
        if (oldLength < 55) {
            this.write();
        }
    }

    private boolean allowAutomaticShutdown() {
        return this.configImpl().automaticShutDown();
    }

    private boolean allowVersionUpdate() {
        Config4Impl configImpl = this.configImpl();
        return !configImpl.isReadOnly() && configImpl.allowVersionUpdates();
    }

    private Config4Impl configImpl() {
        return this._container.configImpl();
    }

    public void write() {
        this.timerFileLock().checkHeaderLock();
        this.addressChanged(this._container.getSlot(55).address());
        StatefulBuffer writer = this._container.getWriter(this._container.transaction(), this._address, 55);
        IntHandler.writeInt(55, writer);
        for (int i = 0; i < 2; ++i) {
            writer.writeLong(this.timerFileLock().openTime());
        }
        writer.writeByte(this.systemData().stringEncoding());
        IntHandler.writeInt(0, writer);
        IntHandler.writeInt(0, writer);
        IntHandler.writeInt(this._bootRecordID, writer);
        IntHandler.writeInt(0, writer);
        writer.append(this.passwordToken());
        writer.writeByte(this.systemData().freespaceSystem());
        this._container.ensureFreespaceSlot();
        IntHandler.writeInt(this.systemData().freespaceAddress(), writer);
        IntHandler.writeInt(this.systemData().converterVersion(), writer);
        IntHandler.writeInt(this.systemData().uuidIndexId(), writer);
        writer.write();
        this.writePointer();
        this._container.syncFiles();
    }

    private void addressChanged(int address) {
        this._address = address;
        this.timerFileLock().setAddresses(this._address, 4, 12);
    }

    private void writePointer() {
        this.timerFileLock().checkHeaderLock();
        StatefulBuffer writer = this._container.getWriter(this._container.transaction(), 0, 4);
        writer.moveForward(2);
        IntHandler.writeInt(this._address, writer);
        writer.noXByteCheck();
        writer.write();
        this.timerFileLock().writeHeaderLock();
    }

    public int address() {
        return this._address;
    }

    public void close() throws Db4oIOException {
        this.timerFileLock().close();
    }
}

