/*
 * Decompiled with CFR 0.152.
 */
package org.bitpedia.collider.core;

import org.bitpedia.collider.core.Md5Handler;

public class KzTreeHandler {
    private static final int MD5_SIZE = 16;
    private static final int KZTREE_BLOCKSIZE = 32768;
    private static final int KZTREE_NODESIZE = 32;
    private static final int KZTREE_STACKSIZE = 1808;
    private int count;
    private byte[] leaf;
    private int blockIndex;
    private int index;
    private int topIndex;
    private byte[] nodes;
    private int gen;

    public void analyzeInit() {
        this.leaf = new byte[32768];
        this.nodes = new byte[1808];
        this.count = 0;
        this.blockIndex = 0;
        this.index = 0;
        this.topIndex = 0;
    }

    public void analyzeUpdate(byte[] byArray, int n, int n2) {
        if (0 != this.index) {
            int n3 = 32768 - this.index;
            if (n2 < n3) {
                System.arraycopy(byArray, n, this.leaf, this.blockIndex + this.index, n2);
                this.index += n2;
                return;
            }
            System.arraycopy(byArray, n, this.leaf, this.blockIndex + this.index, n3);
            this.index = 32768;
            this.kztreeBlock();
            n += n3;
            n2 -= n3;
        }
        while (32768 <= n2) {
            System.arraycopy(byArray, n, this.leaf, this.blockIndex, 32768);
            this.index = 32768;
            this.kztreeBlock();
            n += 32768;
            n2 -= 32768;
        }
        this.index = n2;
        if (0 != this.index) {
            System.arraycopy(byArray, n, this.leaf, this.blockIndex, n2);
        }
    }

    private void kztreeBlock() {
        byte[] byArray = Md5Handler.md5(this.leaf, this.index);
        System.arraycopy(byArray, 0, this.nodes, this.topIndex, byArray.length);
        this.topIndex += 16;
        ++this.count;
        this.gen = this.count;
        while (this.gen == this.gen >> 1 << 1) {
            this.kztreeCompose();
            this.gen >>= 1;
        }
    }

    private void kztreeCompose() {
        if (this.gen != this.gen >> 1 << 1) {
            byte[] byArray = Md5Handler.md5(this.nodes, this.topIndex - 16, 16);
            System.arraycopy(byArray, 0, this.nodes, this.topIndex - 16, 16);
            return;
        }
        int n = this.topIndex - 32;
        byte[] byArray = Md5Handler.md5(this.nodes, n, 32);
        System.arraycopy(byArray, 0, this.nodes, n, 16);
        this.topIndex -= 16;
    }

    public byte[] analyzeFinal() {
        if (0 < this.index) {
            this.kztreeBlock();
        }
        while (1 < this.gen) {
            this.kztreeCompose();
            this.gen = (this.gen + 1) / 2;
        }
        if (1 == this.count) {
            this.kztreeCompose();
        }
        if (0 == this.count) {
            this.kztreeBlock();
        }
        byte[] byArray = new byte[16];
        System.arraycopy(this.nodes, 0, byArray, 0, 16);
        return byArray;
    }
}

