/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.mantissa.fitting;

import org.spaceroots.mantissa.estimation.EstimatedParameter;
import org.spaceroots.mantissa.estimation.Estimator;
import org.spaceroots.mantissa.estimation.GaussNewtonEstimator;
import org.spaceroots.mantissa.fitting.AbstractCurveFitter;
import org.spaceroots.mantissa.fitting.PolynomialCoefficient;

public class PolynomialFitter
extends AbstractCurveFitter {
    private static final long serialVersionUID = -744904084649890769L;

    public PolynomialFitter(int degree, Estimator estimator) {
        super(degree + 1, estimator);
        for (int i = 0; i < this.coefficients.length; ++i) {
            this.coefficients[i] = new PolynomialCoefficient(i);
        }
    }

    public PolynomialFitter(PolynomialCoefficient[] coefficients, Estimator estimator) {
        super(coefficients, estimator);
    }

    public PolynomialFitter(int degree, int maxIterations, double convergence, double steadyStateThreshold, double epsilon) {
        this(degree, (Estimator)new GaussNewtonEstimator(maxIterations, steadyStateThreshold, convergence, epsilon));
    }

    public PolynomialFitter(PolynomialCoefficient[] coefficients, int maxIterations, double convergence, double steadyStateThreshold, double epsilon) {
        this(coefficients, (Estimator)new GaussNewtonEstimator(maxIterations, steadyStateThreshold, convergence, epsilon));
    }

    @Override
    public double valueAt(double x) {
        double y = this.coefficients[this.coefficients.length - 1].getEstimate();
        for (int i = this.coefficients.length - 2; i >= 0; --i) {
            y = y * x + this.coefficients[i].getEstimate();
        }
        return y;
    }

    @Override
    public double partial(double x, EstimatedParameter p) {
        if (p instanceof PolynomialCoefficient) {
            return Math.pow(x, ((PolynomialCoefficient)p).degree);
        }
        throw new RuntimeException("internal error");
    }
}

