/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.mantissa.linalg;

import org.spaceroots.mantissa.linalg.GeneralSquareMatrix;
import org.spaceroots.mantissa.linalg.Matrix;

public class SymetricalMatrix
extends GeneralSquareMatrix {
    private static final long serialVersionUID = -2083829252075519221L;

    public SymetricalMatrix(int order) {
        super(order);
    }

    public SymetricalMatrix(int order, double[] data) {
        super(order, data);
    }

    public SymetricalMatrix(SymetricalMatrix s) {
        super(s);
    }

    public SymetricalMatrix(double w, double[] a) {
        super(a.length, new double[a.length * a.length]);
        for (int i = 0; i < a.length; ++i) {
            int indexU;
            int indexL = indexU = i * (this.columns + 1);
            double factor = w * a[i];
            this.data[indexU] = factor * a[i];
            for (int j = i + 1; j < this.columns; ++j) {
                this.data[++indexU] = factor * a[j];
                this.data[indexL += this.columns] = this.data[indexU];
            }
        }
    }

    @Override
    public Matrix duplicate() {
        return new SymetricalMatrix(this);
    }

    @Override
    public void setElement(int i, int j, double value) {
        if (i != j) {
            throw new ArrayIndexOutOfBoundsException("cannot separately set elements out of diagonal in a symetrical matrix");
        }
        super.setElement(i, j, value);
    }

    public void setElementAndSymetricalElement(int i, int j, double value) {
        super.setElement(i, j, value);
        if (i != j) {
            super.setElement(j, i, value);
        }
    }

    public void selfAdd(SymetricalMatrix s) {
        if (this.rows != s.rows || this.columns != s.columns) {
            throw new IllegalArgumentException("cannot add a " + s.rows + 'x' + s.columns + " matrix to a " + this.rows + 'x' + this.columns + " matrix");
        }
        for (int i = 0; i < this.rows; ++i) {
            int indexU;
            int indexL = indexU = i * (this.columns + 1);
            int n = indexU;
            this.data[n] = this.data[n] + s.data[indexU];
            for (int j = i + 1; j < this.columns; ++j) {
                int n2 = ++indexU;
                this.data[n2] = this.data[n2] + s.data[indexU];
                this.data[indexL += this.columns] = this.data[indexU];
            }
        }
    }

    public void selfSub(SymetricalMatrix s) {
        if (this.rows != s.rows || this.columns != s.columns) {
            throw new IllegalArgumentException("cannot substract a " + s.rows + 'x' + s.columns + " matrix from a " + this.rows + 'x' + this.columns + " matrix");
        }
        for (int i = 0; i < this.rows; ++i) {
            int indexU;
            int indexL = indexU = i * (this.columns + 1);
            int n = indexU;
            this.data[n] = this.data[n] - s.data[indexU];
            for (int j = i + 1; j < this.columns; ++j) {
                int n2 = ++indexU;
                this.data[n2] = this.data[n2] - s.data[indexU];
                this.data[indexL += this.columns] = this.data[indexU];
            }
        }
    }

    public void selfAddWAAt(double w, double[] a) {
        if (this.rows != a.length) {
            throw new IllegalArgumentException("cannot add a " + a.length + 'x' + a.length + " matrix to a " + this.rows + 'x' + this.columns + " matrix");
        }
        for (int i = 0; i < this.rows; ++i) {
            int indexU;
            int indexL = indexU = i * (this.columns + 1);
            double factor = w * a[i];
            int n = indexU;
            this.data[n] = this.data[n] + factor * a[i];
            for (int j = i + 1; j < this.columns; ++j) {
                int n2 = ++indexU;
                this.data[n2] = this.data[n2] + factor * a[j];
                this.data[indexL += this.columns] = this.data[indexU];
            }
        }
    }
}

