/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.mantissa.linalg;

import org.spaceroots.mantissa.linalg.Matrix;
import org.spaceroots.mantissa.linalg.MatrixFactory;
import org.spaceroots.mantissa.linalg.NonNullRange;
import org.spaceroots.mantissa.linalg.SingularMatrixException;
import org.spaceroots.mantissa.linalg.SquareMatrix;

public class UpperTriangularMatrix
extends SquareMatrix {
    private static final long serialVersionUID = -197266611942032237L;

    public UpperTriangularMatrix(int order) {
        super(order);
    }

    public UpperTriangularMatrix(int order, double[] data) {
        super(order, data);
    }

    public UpperTriangularMatrix(UpperTriangularMatrix u) {
        super(u);
    }

    @Override
    public Matrix duplicate() {
        return new UpperTriangularMatrix(this);
    }

    @Override
    public void setElement(int i, int j, double value) {
        if (i > j) {
            throw new ArrayIndexOutOfBoundsException("cannot set elements below diagonal of a upper triangular matrix");
        }
        super.setElement(i, j, value);
    }

    public void selfAdd(UpperTriangularMatrix u) {
        if (this.rows != u.rows || this.columns != u.columns) {
            throw new IllegalArgumentException("cannot add a " + u.rows + 'x' + u.columns + " matrix to a " + this.rows + 'x' + this.columns + " matrix");
        }
        for (int i = 0; i < this.rows; ++i) {
            for (int index = i * (this.columns + 1); index < (i + 1) * this.columns; ++index) {
                int n = index;
                this.data[n] = this.data[n] + u.data[index];
            }
        }
    }

    public void selfSub(UpperTriangularMatrix u) {
        if (this.rows != u.rows || this.columns != u.columns) {
            throw new IllegalArgumentException("cannot substract a " + u.rows + 'x' + u.columns + " matrix from a " + this.rows + 'x' + this.columns + " matrix");
        }
        for (int i = 0; i < this.rows; ++i) {
            for (int index = i * (this.columns + 1); index < (i + 1) * this.columns; ++index) {
                int n = index;
                this.data[n] = this.data[n] - u.data[index];
            }
        }
    }

    @Override
    public double getDeterminant(double epsilon) {
        double determinant = this.data[0];
        for (int index = this.columns + 1; index < this.columns * this.columns; index += this.columns + 1) {
            determinant *= this.data[index];
        }
        return determinant;
    }

    @Override
    public Matrix solve(Matrix b, double epsilon) throws SingularMatrixException {
        if (b.getRows() != this.rows) {
            throw new IllegalArgumentException("dimension mismatch");
        }
        int bRows = b.getRows();
        int bCols = b.getColumns();
        double[] resultData = new double[bRows * bCols];
        int resultIndex = bRows * bCols - 1;
        int lowerElements = 0;
        int upperElements = 0;
        int minJ = this.columns;
        int maxJ = 0;
        for (int i = this.rows - 1; i >= 0; --i) {
            int j;
            double diag = this.data[i * (this.columns + 1)];
            if (Math.abs(diag) < epsilon) {
                throw new SingularMatrixException();
            }
            double inv = 1.0 / diag;
            NonNullRange range = b.getRangeForRow(i);
            minJ = Math.min(minJ, range.begin);
            maxJ = Math.max(maxJ, range.end);
            for (j = bCols - 1; j >= maxJ; --j) {
                resultData[resultIndex] = 0.0;
                --resultIndex;
            }
            int bIndex = i * bCols + maxJ - 1;
            while (j >= minJ) {
                int index1 = (i + 1) * this.columns - 1;
                int index2 = (bRows - 1) * bCols + j;
                double value = b.data[bIndex];
                while (index1 >= i * (this.columns + 1)) {
                    value -= this.data[index1] * resultData[index2];
                    --index1;
                    index2 -= bCols;
                }
                resultData[resultIndex] = value *= inv;
                if (j < i) {
                    ++lowerElements;
                } else if (i < j) {
                    ++upperElements;
                }
                --bIndex;
                --resultIndex;
                --j;
            }
            while (j >= 0) {
                resultData[resultIndex] = 0.0;
                --resultIndex;
                --j;
            }
        }
        return MatrixFactory.buildMatrix(bRows, bCols, resultData, lowerElements, upperElements);
    }

    @Override
    public NonNullRange getRangeForRow(int i) {
        return new NonNullRange(i, this.columns);
    }

    @Override
    public NonNullRange getRangeForColumn(int j) {
        return new NonNullRange(0, j + 1);
    }
}

