/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.mantissa.roots;

import org.spaceroots.mantissa.functions.FunctionException;
import org.spaceroots.mantissa.functions.scalar.ComputableFunction;
import org.spaceroots.mantissa.roots.ConvergenceChecker;
import org.spaceroots.mantissa.roots.RootsFinder;

public class BrentSolver
implements RootsFinder {
    private static final double epsilon = Math.pow(2.0, -52.0);
    private double root = Double.NaN;

    @Override
    public boolean findRoot(ComputableFunction function, ConvergenceChecker checker, int maxIter, double x0, double f0, double x1, double f1) throws FunctionException {
        double d;
        double a = x0;
        double fa = f0;
        double b = x1;
        double fb = f1;
        double c = a;
        double fc = fa;
        double e = d = b - a;
        for (int iter = 0; iter < maxIter; ++iter) {
            double fHigh;
            double xHigh;
            double fLow;
            double xLow;
            if (Math.abs(fc) < Math.abs(fb)) {
                a = b;
                b = c;
                c = a;
                fa = fb;
                fb = fc;
                fc = fa;
            }
            double tolS = 2.0 * epsilon * Math.abs(b);
            double xm = 0.5 * (c - b);
            if (b < c) {
                xLow = b;
                fLow = fb;
                xHigh = c;
                fHigh = fc;
            } else {
                xLow = c;
                fLow = fc;
                xHigh = b;
                fHigh = fb;
            }
            switch (checker.converged(xLow, fLow, xHigh, fHigh)) {
                case 1: {
                    this.root = xLow;
                    return true;
                }
                case 2: {
                    this.root = xHigh;
                    return true;
                }
            }
            if (Math.abs(xm) < tolS || Math.abs(fb) < Double.MIN_VALUE) {
                this.root = b;
                return true;
            }
            if (Math.abs(e) < tolS || Math.abs(fa) <= Math.abs(fb)) {
                e = d = xm;
            } else {
                double q;
                double p;
                double s = fb / fa;
                if (Math.abs(a - c) < epsilon * Math.max(Math.abs(a), Math.abs(c))) {
                    p = 2.0 * xm * s;
                    q = 1.0 - s;
                } else {
                    q = fa / fc;
                    double r = fb / fc;
                    p = s * (2.0 * xm * q * (q - r) - (b - a) * (r - 1.0));
                    q = (q - 1.0) * (r - 1.0) * (s - 1.0);
                }
                if (p > 0.0) {
                    q = -q;
                } else {
                    p = -p;
                }
                if (2.0 * p < 3.0 * xm * q - Math.abs(tolS * q) && p < Math.abs(0.5 * e * q)) {
                    e = d;
                    d = p / q;
                } else {
                    e = d = xm;
                }
            }
            a = b;
            fa = fb;
            fb = function.valueAt(b += Math.abs(d) > tolS ? d : (xm > 0.0 ? tolS : -tolS));
            if (!(fb * fc > 0.0)) continue;
            c = a;
            fc = fa;
            e = d = b - a;
        }
        return false;
    }

    @Override
    public double getRoot() {
        return this.root;
    }
}

