/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import freenet.client.ClientMetadata;
import freenet.keys.FreenetURI;
import freenet.support.api.RandomAccessBucket;
import java.io.Serializable;

public class InsertBlock
implements Serializable {
    private static final long serialVersionUID = 1L;
    private RandomAccessBucket data;
    private boolean isFreed;
    public FreenetURI desiredURI;
    public ClientMetadata clientMetadata;

    public InsertBlock(RandomAccessBucket data, ClientMetadata metadata, FreenetURI desiredURI) {
        if (data == null) {
            throw new NullPointerException();
        }
        this.data = data;
        this.isFreed = false;
        this.clientMetadata = metadata == null ? new ClientMetadata() : metadata;
        this.desiredURI = desiredURI;
    }

    public RandomAccessBucket getData() {
        return this.isFreed ? null : this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free() {
        InsertBlock insertBlock = this;
        synchronized (insertBlock) {
            if (this.isFreed) {
                return;
            }
            this.isFreed = true;
            if (this.data == null) {
                return;
            }
        }
        this.data.free();
    }

    public void nullData() {
        this.data = null;
    }

    public void nullURI() {
        this.desiredURI = null;
    }

    public void nullMetadata() {
        this.clientMetadata = null;
    }
}

