/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.async.SimpleBlockChooser;
import freenet.client.async.SplitFileInserterSegmentStorage;
import freenet.node.KeysFetchingLocally;
import freenet.support.io.StorageFormatException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;

public class SplitFileInserterSegmentBlockChooser
extends SimpleBlockChooser {
    final SplitFileInserterSegmentStorage segment;
    final KeysFetchingLocally keysFetching;
    final int[] consecutiveRNFs;
    final int consecutiveRNFsCountAsSuccess;

    public SplitFileInserterSegmentBlockChooser(SplitFileInserterSegmentStorage segment, int blocks, Random random, int maxRetries, KeysFetchingLocally keysFetching, int consecutiveRNFsCountAsSuccess) {
        super(blocks, random, maxRetries);
        this.segment = segment;
        this.keysFetching = keysFetching;
        this.consecutiveRNFsCountAsSuccess = consecutiveRNFsCountAsSuccess;
        this.consecutiveRNFs = (int[])(consecutiveRNFsCountAsSuccess > 0 ? new int[blocks] : null);
    }

    @Override
    protected int getMaxBlockNumber() {
        if (this.segment.hasEncoded()) {
            return this.segment.totalBlockCount;
        }
        return this.segment.dataBlockCount;
    }

    @Override
    protected void onCompletedAll() {
        this.segment.onInsertedAllBlocks();
    }

    @Override
    protected boolean checkValid(int chosen) {
        if (!super.checkValid(chosen)) {
            return false;
        }
        return !this.keysFetching.hasInsert(new SplitFileInserterSegmentStorage.BlockInsert(this.segment, chosen));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRNF(int blockNo) {
        SplitFileInserterSegmentBlockChooser splitFileInserterSegmentBlockChooser = this;
        synchronized (splitFileInserterSegmentBlockChooser) {
            assert (this.consecutiveRNFsCountAsSuccess > 0);
            int n = blockNo;
            this.consecutiveRNFs[n] = this.consecutiveRNFs[n] + 1;
            if (this.consecutiveRNFs[n] < this.consecutiveRNFsCountAsSuccess) {
                return;
            }
        }
        this.onSuccess(blockNo);
    }

    public synchronized boolean pushRNFs(int blockNo) {
        int ret = this.consecutiveRNFs[blockNo];
        this.consecutiveRNFs[blockNo] = 0;
        for (int i = 0; i < ret; ++i) {
            if (!this.onNonFatalFailure(blockNo)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void write(DataOutputStream dos) throws IOException {
        super.write(dos);
        if (this.consecutiveRNFsCountAsSuccess > 0) {
            for (int i : this.consecutiveRNFs) {
                dos.writeInt(i);
            }
        }
    }

    @Override
    public void read(DataInputStream dis) throws IOException, StorageFormatException {
        super.read(dis);
        if (this.consecutiveRNFsCountAsSuccess > 0) {
            for (int i = 0; i < this.consecutiveRNFs.length; ++i) {
                this.consecutiveRNFs[i] = dis.readInt();
            }
        }
    }
}

