/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.events;

import freenet.client.async.ClientContext;
import freenet.client.events.ClientEvent;
import freenet.client.events.ClientEventListener;
import freenet.client.events.ClientEventProducer;
import java.io.Serializable;
import java.util.ArrayList;

public class SimpleEventProducer
implements ClientEventProducer,
Serializable {
    private static final long serialVersionUID = 1L;
    private ArrayList<ClientEventListener> listeners = new ArrayList();

    public SimpleEventProducer() {
    }

    public SimpleEventProducer(ClientEventListener[] cela) {
        this();
        for (int i = 0; i < cela.length; ++i) {
            this.addEventListener(cela[i]);
        }
    }

    @Override
    public synchronized void addEventListener(ClientEventListener cel) {
        if (cel == null) {
            throw new IllegalArgumentException("Adding a null listener!");
        }
        this.listeners.add(cel);
    }

    @Override
    public synchronized boolean removeEventListener(ClientEventListener cel) {
        boolean b = this.listeners.remove(cel);
        this.listeners.trimToSize();
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void produceEvent(ClientEvent ce, ClientContext context) {
        ClientEventListener[] list;
        SimpleEventProducer simpleEventProducer = this;
        synchronized (simpleEventProducer) {
            list = this.getEventListeners();
        }
        for (ClientEventListener cel : list) {
            try {
                cel.receive(ce, context);
            }
            catch (Exception ue) {
                System.err.println("---Unexpected Exception------------------");
                ue.printStackTrace();
                System.err.println("-----------------------------------------");
            }
        }
    }

    public synchronized ClientEventListener[] getEventListeners() {
        ClientEventListener[] ret = new ClientEventListener[this.listeners.size()];
        return this.listeners.toArray(ret);
    }

    public synchronized void addEventListeners(ClientEventListener[] cela) {
        for (int i = 0; i < cela.length; ++i) {
            this.addEventListener(cela[i]);
        }
    }
}

