/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.FetchException;
import freenet.clients.http.FProxyFetchInProgress;
import freenet.support.api.Bucket;

public class FProxyFetchResult {
    public final String mimeType;
    public final long size;
    final Bucket data;
    public final long timeStarted;
    public final boolean goneToNetwork;
    public final int totalBlocks;
    public final int requiredBlocks;
    public final int fetchedBlocks;
    public final int failedBlocks;
    public final int fatallyFailedBlocks;
    public final boolean finalizedBlocks;
    private int fetchedCount;
    public final FetchException failed;
    final FProxyFetchInProgress progress;
    final boolean hasWaited;
    public final long eta;
    private final boolean finished;

    FProxyFetchResult(FProxyFetchInProgress parent, Bucket data, String mimeType, long timeStarted, boolean goneToNetwork, long eta, boolean hasWaited) {
        assert (data != null);
        this.data = data;
        this.mimeType = mimeType;
        this.size = data.size();
        this.timeStarted = timeStarted;
        this.goneToNetwork = goneToNetwork;
        this.fatallyFailedBlocks = 0;
        this.failedBlocks = 0;
        this.fetchedBlocks = 0;
        this.requiredBlocks = 0;
        this.totalBlocks = 0;
        this.finalizedBlocks = true;
        this.failed = null;
        this.progress = parent;
        this.eta = eta;
        this.hasWaited = hasWaited;
        this.finished = true;
    }

    FProxyFetchResult(FProxyFetchInProgress parent, String mimeType, long size, long timeStarted, boolean goneToNetwork, int totalBlocks, int requiredBlocks, int fetchedBlocks, int failedBlocks, int fatallyFailedBlocks, boolean finalizedBlocks, FetchException failed, long eta, boolean hasWaited) {
        this.data = null;
        this.mimeType = mimeType;
        this.size = size;
        this.timeStarted = timeStarted;
        this.goneToNetwork = goneToNetwork;
        this.totalBlocks = totalBlocks;
        this.requiredBlocks = requiredBlocks;
        this.fetchedBlocks = fetchedBlocks;
        this.failedBlocks = failedBlocks;
        this.fatallyFailedBlocks = fatallyFailedBlocks;
        this.finalizedBlocks = finalizedBlocks;
        this.failed = failed;
        this.progress = parent;
        this.eta = eta;
        this.hasWaited = hasWaited;
        this.finished = failed != null;
    }

    public void close() {
        this.progress.close(this);
    }

    public boolean hasData() {
        return this.data != null;
    }

    public Bucket getData() {
        return this.data;
    }

    public boolean hasWaited() {
        return this.hasWaited;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFetchCount(int fetched) {
        this.fetchedCount = fetched;
    }

    public int getFetchCount() {
        return this.fetchedCount;
    }
}

