/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http.wizardsteps;

import freenet.clients.http.FirstTimeWizardToadlet;
import freenet.clients.http.wizardsteps.BandwidthLimit;
import freenet.clients.http.wizardsteps.BandwidthManipulator;
import freenet.clients.http.wizardsteps.PageHelper;
import freenet.clients.http.wizardsteps.Step;
import freenet.clients.http.wizardsteps.WizardL10n;
import freenet.config.Config;
import freenet.config.InvalidConfigValueException;
import freenet.l10n.NodeL10n;
import freenet.node.NodeClientCore;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import freenet.support.SizeUtil;
import freenet.support.URLEncoder;
import freenet.support.api.HTTPRequest;
import java.text.DecimalFormat;

public class BANDWIDTH_RATE
extends BandwidthManipulator
implements Step {
    private final BandwidthLimit[] limits;

    public BANDWIDTH_RATE(NodeClientCore core, Config config) {
        super(core, config);
        int KiB = 1024;
        this.limits = new BandwidthLimit[]{new BandwidthLimit(262144L, 16384L, "bandwidthConnection4M", false), new BandwidthLimit(393216L, 16384L, "bandwidthConnection6M", true), new BandwidthLimit(524288L, 32768L, "bandwidthConnection8M", false), new BandwidthLimit(786432L, 65536L, "bandwidthConnection12M", false), new BandwidthLimit(0x140000L, 65536L, "bandwidthConnection20M", false), new BandwidthLimit(0x140000L, 327680L, "bandwidthConnectionVDSL", false), new BandwidthLimit(0x200000L, 0x200000L, "bandwidthConnection100M", false)};
    }

    @Override
    public void getStep(HTTPRequest request, PageHelper helper) {
        BandwidthLimit current;
        HTMLNode contentNode = helper.getPageContent(WizardL10n.l10n("bandwidthLimit"));
        HTMLNode formNode = helper.addFormChild(contentNode, ".", "limit");
        if (request.isParameterSet("parseError")) {
            this.parseErrorBox(contentNode, helper, request.getParam("parseTarget"));
        }
        HTMLNode infoBox = helper.getInfobox("infobox-normal", WizardL10n.l10n("bandwidthLimitRateTitle"), formNode, null, false);
        NodeL10n.getBase().addL10nSubstitution(infoBox, "FirstTimeWizardToadlet.bandwidthLimitRate", new String[]{"bold", "coreSettings"}, new HTMLNode[]{HTMLNode.STRONG, new HTMLNode("#", NodeL10n.getBase().getString("ConfigToadlet.node"))});
        HTMLNode table = infoBox.addChild("table");
        HTMLNode headerRow = table.addChild("tr");
        headerRow.addChild("th", WizardL10n.l10n("bandwidthConnectionHeader"));
        headerRow.addChild("th", WizardL10n.l10n("bandwidthDownloadHeader"));
        headerRow.addChild("th", WizardL10n.l10n("bandwidthUploadHeader"));
        headerRow.addChild("th", WizardL10n.l10n("bandwidthSelect"));
        boolean addedDefault = false;
        BandwidthLimit detected = this.detectBandwidthLimits();
        if (detected.downBytes > 0L && detected.upBytes > 0L) {
            BandwidthLimit usable = new BandwidthLimit(detected.downBytes / 2L, detected.upBytes / 2L, "bandwidthDetected", true);
            this.addLimitRow(table, helper, usable, true, true);
            addedDefault = true;
        }
        if ((current = this.getCurrentBandwidthLimitsOrNull()) != null) {
            this.addLimitRow(table, helper, current, false, !addedDefault);
            addedDefault = true;
        }
        for (BandwidthLimit limit : this.limits) {
            this.addLimitRow(table, helper, limit, false, !addedDefault);
        }
        HTMLNode customForm = table.addChild("tr");
        customForm.addChild("td", WizardL10n.l10n("bandwidthCustom"));
        customForm.addChild("td").addChild("input", new String[]{"type", "name"}, new String[]{"text", "customDown"});
        customForm.addChild("td").addChild("input", new String[]{"type", "name"}, new String[]{"text", "customUp"});
        infoBox.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "back", NodeL10n.getBase().getString("Toadlet.back")});
        infoBox.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "next", NodeL10n.getBase().getString("Toadlet.next")});
    }

    @Override
    public String postStep(HTTPRequest request) {
        String limitSelected = request.getPartAsStringFailsafe("bandwidth", 100);
        String down = request.getPartAsStringFailsafe("customDown", 20);
        String up = request.getPartAsStringFailsafe("customUp", 20);
        if (!down.equals("") && !up.equals("")) {
            String failedLimits = this.attemptSet(up, down);
            if (!failedLimits.isEmpty()) {
                return "BANDWIDTH_RATE&parseError=true&parseTarget=" + URLEncoder.encode(failedLimits, true);
            }
            this.setWizardComplete();
            return FirstTimeWizardToadlet.WIZARD_STEP.COMPLETE.name();
        }
        if (!limitSelected.isEmpty()) {
            int x = limitSelected.indexOf(47);
            if (x != -1) {
                String downString = limitSelected.substring(0, x);
                String upString = limitSelected.substring(x + 1);
                String preset = this.attemptSet(upString, downString);
                if (!preset.isEmpty()) {
                    Logger.error(this, "Failed to parse pre-defined limit! Please report.");
                    return (Object)((Object)FirstTimeWizardToadlet.WIZARD_STEP.BANDWIDTH_RATE) + "&parseError=true&parseTarget=" + URLEncoder.encode(preset, true);
                }
            }
        } else {
            Logger.error(this, "No bandwidth limit set!");
            return FirstTimeWizardToadlet.WIZARD_STEP.BANDWIDTH_RATE.name();
        }
        this.setWizardComplete();
        return FirstTimeWizardToadlet.WIZARD_STEP.COMPLETE.name();
    }

    private String attemptSet(String up, String down) {
        String failedLimits = "";
        try {
            this.setBandwidthLimit(down, false);
        }
        catch (InvalidConfigValueException e) {
            failedLimits = e.getMessage();
        }
        try {
            this.setBandwidthLimit(up, true);
        }
        catch (InvalidConfigValueException e) {
            if (!failedLimits.isEmpty()) {
                failedLimits = failedLimits + ' ';
            }
            failedLimits = failedLimits + e.getMessage();
        }
        return failedLimits;
    }

    private void addLimitRow(HTMLNode table, PageHelper helper, BandwidthLimit limit, boolean recommended, boolean useMaybeDefault) {
        HTMLNode row = table.addChild("tr");
        row.addChild("td", WizardL10n.l10n(limit.descriptionKey));
        String downColumn = SizeUtil.formatSize(limit.downBytes) + WizardL10n.l10n("bandwidthPerSecond");
        if (limit.downBytes >= 32768L) {
            downColumn = downColumn + " (= ";
            downColumn = limit.downBytes < 262144L ? downColumn + new DecimalFormat("0.0").format((double)(limit.downBytes * 8L) / 1048576.0) : downColumn + limit.downBytes * 8L / 0x100000L;
            downColumn = downColumn + "Mbps)";
        }
        row.addChild("td", downColumn);
        row.addChild("td", SizeUtil.formatSize(limit.upBytes) + WizardL10n.l10n("bandwidthPerSecond"));
        HTMLNode buttonCell = row.addChild("td");
        HTMLNode radio = buttonCell.addChild("input", new String[]{"type", "name", "value"}, new String[]{"radio", "bandwidth", limit.downBytes + "/" + limit.upBytes});
        if (recommended || useMaybeDefault && limit.maybeDefault) {
            radio.addAttribute("checked", "checked");
        }
        if (recommended) {
            buttonCell.addChild("#", WizardL10n.l10n("autodetectedSuggestedLimit"));
        }
    }
}

