/*
 * Decompiled with CFR 0.152.
 */
package freenet.io.comm;

import freenet.crypt.DSAPublicKey;
import freenet.io.comm.Message;
import freenet.io.comm.MessageType;
import freenet.io.comm.Peer;
import freenet.keys.Key;
import freenet.keys.NodeCHK;
import freenet.keys.NodeSSK;
import freenet.node.NodeStats;
import freenet.node.probe.Error;
import freenet.node.probe.Type;
import freenet.support.BitArray;
import freenet.support.Buffer;
import freenet.support.Fields;
import freenet.support.ShortBuffer;

public class DMT {
    public static final String UID = "uid";
    public static final String SEND_TIME = "sendTime";
    public static final String EXTERNAL_ADDRESS = "externalAddress";
    public static final String BUILD = "build";
    public static final String FIRST_GOOD_BUILD = "firstGoodBuild";
    public static final String JOINER = "joiner";
    public static final String REASON = "reason";
    public static final String DESCRIPTION = "description";
    public static final String TTL = "ttl";
    public static final String PEERS = "peers";
    public static final String URL = "url";
    public static final String FORWARDERS = "forwarders";
    public static final String FILE_LENGTH = "fileLength";
    public static final String LAST_MODIFIED = "lastModified";
    public static final String CHUNK_NO = "chunkNo";
    public static final String DATA_SOURCE = "dataSource";
    public static final String CACHED = "cached";
    public static final String PACKET_NO = "packetNo";
    public static final String DATA = "data";
    public static final String IS_HASH = "isHash";
    public static final String HASH = "hash";
    public static final String SENT = "sent";
    public static final String MISSING = "missing";
    public static final String KEY = "key";
    public static final String CHK_HEADER = "chkHeader";
    public static final String FREENET_URI = "freenetURI";
    public static final String FREENET_ROUTING_KEY = "freenetRoutingKey";
    public static final String TEST_CHK_HEADERS = "testCHKHeaders";
    public static final String HTL = "hopsToLive";
    public static final String SUCCESS = "success";
    public static final String FNP_SOURCE_PEERNODE = "sourcePeerNode";
    public static final String PING_SEQNO = "pingSequenceNumber";
    public static final String LOCATION = "location";
    public static final String NEAREST_LOCATION = "nearestLocation";
    public static final String BEST_LOCATION = "bestLocation";
    public static final String TARGET_LOCATION = "targetLocation";
    public static final String TYPE = "type";
    public static final String PAYLOAD = "payload";
    public static final String COUNTER = "counter";
    public static final String UNIQUE_COUNTER = "uniqueCounter";
    public static final String LINEAR_COUNTER = "linearCounter";
    public static final String RETURN_LOCATION = "returnLocation";
    public static final String BLOCK_HEADERS = "blockHeaders";
    public static final String DATA_INSERT_REJECTED_REASON = "dataInsertRejectedReason";
    public static final String STREAM_SEQNO = "streamSequenceNumber";
    public static final String IS_LOCAL = "isLocal";
    public static final String ANY_TIMED_OUT = "anyTimedOut";
    public static final String PUBKEY_HASH = "pubkeyHash";
    public static final String NEED_PUB_KEY = "needPubKey";
    public static final String PUBKEY_AS_BYTES = "pubkeyAsBytes";
    public static final String SOURCE_NODENAME = "sourceNodename";
    public static final String TARGET_NODENAME = "targetNodename";
    public static final String NODE_TO_NODE_MESSAGE_TYPE = "nodeToNodeMessageType";
    public static final String NODE_TO_NODE_MESSAGE_TEXT = "nodeToNodeMessageText";
    public static final String NODE_TO_NODE_MESSAGE_DATA = "nodeToNodeMessageData";
    public static final String NODE_UIDS = "nodeUIDs";
    public static final String MY_UID = "myUID";
    public static final String PEER_LOCATIONS = "peerLocations";
    public static final String PEER_UIDS = "peerUIDs";
    public static final String BEST_LOCATIONS_NOT_VISITED = "bestLocationsNotVisited";
    public static final String MAIN_JAR_KEY = "mainJarKey";
    public static final String EXTRA_JAR_KEY = "extraJarKey";
    public static final String REVOCATION_KEY = "revocationKey";
    public static final String HAVE_REVOCATION_KEY = "haveRevocationKey";
    public static final String MAIN_JAR_VERSION = "mainJarVersion";
    public static final String EXTRA_JAR_VERSION = "extJarVersion";
    public static final String REVOCATION_KEY_TIME_LAST_TRIED = "revocationKeyTimeLastTried";
    public static final String REVOCATION_KEY_DNF_COUNT = "revocationKeyDNFCount";
    public static final String REVOCATION_KEY_FILE_LENGTH = "revocationKeyFileLength";
    public static final String MAIN_JAR_FILE_LENGTH = "mainJarFileLength";
    public static final String EXTRA_JAR_FILE_LENGTH = "extraJarFileLength";
    public static final String PING_TIME = "pingTime";
    public static final String BWLIMIT_DELAY_TIME = "bwlimitDelayTime";
    public static final String TIME = "time";
    public static final String FORK_COUNT = "forkCount";
    public static final String TIME_LEFT = "timeLeft";
    public static final String PREV_UID = "prevUID";
    public static final String OPENNET_NODEREF = "opennetNoderef";
    public static final String REMOVE = "remove";
    public static final String PURGE = "purge";
    public static final String TRANSFER_UID = "transferUID";
    public static final String NODEREF_LENGTH = "noderefLength";
    public static final String PADDED_LENGTH = "paddedLength";
    public static final String TIME_DELTAS = "timeDeltas";
    public static final String HASHES = "hashes";
    public static final String REJECT_CODE = "rejectCode";
    public static final String ROUTING_ENABLED = "routingEnabled";
    public static final String OFFER_AUTHENTICATOR = "offerAuthenticator";
    public static final String DAWN_HTL = "dawnHtl";
    public static final String SECRET = "secret";
    public static final String NODE_IDENTITY = "nodeIdentity";
    public static final String UPTIME_PERCENT_48H = "uptimePercent48H";
    public static final String FRIEND_VISIBILITY = "friendVisibility";
    public static final String ENABLE_INSERT_FORK_WHEN_CACHEABLE = "enableInsertForkWhenCacheable";
    public static final String PREFER_INSERT = "preferInsert";
    public static final String IGNORE_LOW_BACKOFF = "ignoreLowBackoff";
    public static final String LIST_OF_UIDS = "listOfUIDs";
    public static final String UID_STILL_RUNNING_FLAGS = "UIDStillRunningFlags";
    public static final String PROBE_IDENTIFIER = "probeIdentifier";
    public static final String STORE_SIZE = "storeSize";
    public static final String LINK_LENGTHS = "linkLengths";
    public static final String UPTIME_PERCENT = "uptimePercent";
    public static final String EXPECTED_HASH = "expectedHash";
    public static final String REJECT_STATS = "rejectStats";
    public static final String OUTPUT_BANDWIDTH_CLASS = "outputBandwidthClass";
    public static final String CAPACITY_USAGE = "capacityUsage";
    public static final short PRIORITY_NOW = 0;
    public static final short PRIORITY_HIGH = 1;
    public static final short PRIORITY_UNSPECIFIED = 2;
    public static final short PRIORITY_LOW = 3;
    public static final short PRIORITY_REALTIME_DATA = 4;
    public static final short PRIORITY_BULK_DATA = 5;
    public static final short NUM_PRIORITIES = 6;
    public static final MessageType packetTransmit = new MessageType("packetTransmit", 5){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.PACKET_NO, Integer.class);
            this.addField(DMT.SENT, BitArray.class);
            this.addField(DMT.DATA, Buffer.class);
        }
    };
    public static final MessageType allSent = new MessageType("allSent", 5){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType allReceived = new MessageType("allReceived", 2){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType sendAborted = new MessageType("sendAborted", 2){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.DESCRIPTION, String.class);
            this.addField(DMT.REASON, Integer.class);
        }
    };
    public static final MessageType FNPBulkPacketSend = new MessageType("FNPBulkPacketSend", 5){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.PACKET_NO, Integer.class);
            this.addField(DMT.DATA, ShortBuffer.class);
        }
    };
    public static final MessageType FNPBulkSendAborted = new MessageType("FNPBulkSendAborted", 2){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType FNPBulkReceiveAborted = new MessageType("FNPBulkReceiveAborted", 2){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType FNPBulkReceivedAll = new MessageType("FNPBulkReceivedAll", 2){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType testTransferSend = new MessageType("testTransferSend", 2){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType testTransferSendAck = new MessageType("testTransferSendAck", 2){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType testSendCHK = new MessageType("testSendCHK", 2){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.FREENET_URI, String.class);
            this.addField(DMT.CHK_HEADER, Buffer.class);
        }
    };
    public static final MessageType testRequest = new MessageType("testRequest", 2){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.FREENET_ROUTING_KEY, Key.class);
            this.addField(DMT.HTL, Integer.class);
        }
    };
    public static final MessageType testDataNotFound = new MessageType("testDataNotFound", 2){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType testDataReply = new MessageType("testDataReply", 2){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.TEST_CHK_HEADERS, Buffer.class);
        }
    };
    public static final MessageType testSendCHKAck = new MessageType("testSendCHKAck", 2){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.FREENET_URI, String.class);
        }
    };
    public static final MessageType testDataReplyAck = new MessageType("testDataReplyAck", 2){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType testDataNotFoundAck = new MessageType("testDataNotFoundAck", 2){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType testReceiveCompleted = new MessageType("testReceiveCompleted", 2, true, false){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.SUCCESS, Boolean.class);
            this.addField(DMT.REASON, String.class);
        }
    };
    public static final MessageType testSendCompleted = new MessageType("testSendCompleted", 2, true, false){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.SUCCESS, Boolean.class);
            this.addField(DMT.REASON, String.class);
        }
    };
    public static final MessageType nodeToNodeMessage = new MessageType("nodeToNodeMessage", 3, false, false){
        {
            this.addField(DMT.NODE_TO_NODE_MESSAGE_TYPE, Integer.class);
            this.addField(DMT.NODE_TO_NODE_MESSAGE_DATA, ShortBuffer.class);
        }
    };
    public static final MessageType FNPCHKDataRequest = new MessageType("FNPCHKDataRequest", 3){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.HTL, Short.class);
            this.addField(DMT.NEAREST_LOCATION, Double.class);
            this.addField(DMT.FREENET_ROUTING_KEY, NodeCHK.class);
        }
    };
    public static final MessageType FNPSSKDataRequest = new MessageType("FNPSSKDataRequest", 3){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.HTL, Short.class);
            this.addField(DMT.NEAREST_LOCATION, Double.class);
            this.addField(DMT.FREENET_ROUTING_KEY, NodeSSK.class);
            this.addField(DMT.NEED_PUB_KEY, Boolean.class);
        }
    };
    public static final MessageType FNPRejectedLoop = new MessageType("FNPRejectLoop", 1){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType FNPRejectedOverload = new MessageType("FNPRejectOverload", 1){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.IS_LOCAL, Boolean.class);
        }
    };
    public static final MessageType FNPAccepted = new MessageType("FNPAccepted", 1){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType FNPDataNotFound = new MessageType("FNPDataNotFound", 2){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType FNPRecentlyFailed = new MessageType("FNPRecentlyFailed", 1){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.TIME_LEFT, Integer.class);
        }
    };
    public static final MessageType FNPCHKDataFound = new MessageType("FNPCHKDataFound", 2){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.BLOCK_HEADERS, ShortBuffer.class);
        }
    };
    public static final MessageType FNPRouteNotFound = new MessageType("FNPRouteNotFound", 2){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.HTL, Short.class);
        }
    };
    public static final MessageType FNPInsertRequest = new MessageType("FNPInsertRequest", 3){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.HTL, Short.class);
            this.addField(DMT.NEAREST_LOCATION, Double.class);
            this.addField(DMT.FREENET_ROUTING_KEY, Key.class);
        }
    };
    public static final MessageType FNPInsertReply = new MessageType("FNPInsertReply", 2){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType FNPDataInsert = new MessageType("FNPDataInsert", 1){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.BLOCK_HEADERS, ShortBuffer.class);
        }
    };
    public static final MessageType FNPInsertTransfersCompleted = new MessageType("FNPInsertTransfersCompleted", 2){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.ANY_TIMED_OUT, Boolean.class);
        }
    };
    public static final MessageType FNPRejectedTimeout = new MessageType("FNPTooSlow", 2){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType FNPDataInsertRejected = new MessageType("FNPDataInsertRejected", 2){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.DATA_INSERT_REJECTED_REASON, Short.class);
        }
    };
    public static final short DATA_INSERT_REJECTED_VERIFY_FAILED = 1;
    public static final short DATA_INSERT_REJECTED_RECEIVE_FAILED = 2;
    public static final short DATA_INSERT_REJECTED_SSK_ERROR = 3;
    public static final short DATA_INSERT_REJECTED_TIMEOUT_WAITING_FOR_ACCEPTED = 4;
    public static final MessageType FNPSSKInsertRequest = new MessageType("FNPSSKInsertRequest", 5){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.HTL, Short.class);
            this.addField(DMT.FREENET_ROUTING_KEY, NodeSSK.class);
            this.addField(DMT.NEAREST_LOCATION, Double.class);
            this.addField(DMT.BLOCK_HEADERS, ShortBuffer.class);
            this.addField(DMT.PUBKEY_HASH, ShortBuffer.class);
            this.addField(DMT.DATA, ShortBuffer.class);
        }
    };
    public static final MessageType FNPSSKInsertRequestNew = new MessageType("FNPSSKInsertRequestNew", 3){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.HTL, Short.class);
            this.addField(DMT.FREENET_ROUTING_KEY, NodeSSK.class);
        }
    };
    public static final MessageType FNPSSKInsertRequestHeaders = new MessageType("FNPSSKInsertRequestHeaders", 5){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.BLOCK_HEADERS, ShortBuffer.class);
        }
    };
    public static final MessageType FNPSSKInsertRequestData = new MessageType("FNPSSKInsertRequestData", 5){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.DATA, ShortBuffer.class);
        }
    };
    public static final MessageType FNPSSKDataFoundHeaders = new MessageType("FNPSSKDataFoundHeaders", 5){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.BLOCK_HEADERS, ShortBuffer.class);
        }
    };
    public static final MessageType FNPSSKDataFoundData = new MessageType("FNPSSKDataFoundData", 5){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.DATA, ShortBuffer.class);
        }
    };
    public static final MessageType FNPSSKAccepted = new MessageType("FNPSSKAccepted", 1){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.NEED_PUB_KEY, Boolean.class);
        }
    };
    public static final MessageType FNPSSKPubKey = new MessageType("FNPSSKPubKey", 5){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.PUBKEY_AS_BYTES, ShortBuffer.class);
        }
    };
    public static final MessageType FNPSSKPubKeyAccepted = new MessageType("FNPSSKPubKeyAccepted", 1){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType FNPOpennetCompletedAck = new MessageType("FNPOpennetCompletedAck", 1){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType FNPOpennetCompletedTimeout = new MessageType("FNPOpennetCompletedTimeout", 1){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType FNPOpennetConnectDestinationNew = new MessageType("FNPConnectDestinationNew", 2){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.TRANSFER_UID, Long.class);
            this.addField(DMT.NODEREF_LENGTH, Integer.class);
            this.addField(DMT.PADDED_LENGTH, Integer.class);
        }
    };
    public static final MessageType FNPOpennetConnectReplyNew = new MessageType("FNPConnectReplyNew", 2){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.TRANSFER_UID, Long.class);
            this.addField(DMT.NODEREF_LENGTH, Integer.class);
            this.addField(DMT.PADDED_LENGTH, Integer.class);
        }
    };
    public static final MessageType FNPOpennetAnnounceRequest = new MessageType("FNPOpennetAnnounceRequest", 1){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.TRANSFER_UID, Long.class);
            this.addField(DMT.NODEREF_LENGTH, Integer.class);
            this.addField(DMT.PADDED_LENGTH, Integer.class);
            this.addField(DMT.HTL, Short.class);
            this.addField(DMT.NEAREST_LOCATION, Double.class);
            this.addField(DMT.TARGET_LOCATION, Double.class);
        }
    };
    public static final MessageType FNPOpennetAnnounceReply = new MessageType("FNPOpennetAnnounceReply", 2){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.TRANSFER_UID, Long.class);
            this.addField(DMT.NODEREF_LENGTH, Integer.class);
            this.addField(DMT.PADDED_LENGTH, Integer.class);
        }
    };
    public static final MessageType FNPOpennetAnnounceCompleted = new MessageType("FNPOpennetAnnounceCompleted", 2){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType FNPOpennetDisabled = new MessageType("FNPOpennetDisabled", 1){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType FNPOpennetNoderefRejected = new MessageType("FNPOpennetNoderefRejected", 1){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.REJECT_CODE, Integer.class);
        }
    };
    public static final int NODEREF_REJECTED_TOO_BIG = 1;
    public static final int NODEREF_REJECTED_REAL_BIGGER_THAN_PADDED = 2;
    public static final int NODEREF_REJECTED_TRANSFER_FAILED = 3;
    public static final int NODEREF_REJECTED_INVALID = 4;
    public static final MessageType FNPOpennetAnnounceNodeNotWanted = new MessageType("FNPOpennetAnnounceNodeNotWanted", 3){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType FNPOfferKey = new MessageType("FNPOfferKey", 3){
        {
            this.addField(DMT.KEY, Key.class);
            this.addField(DMT.OFFER_AUTHENTICATOR, ShortBuffer.class);
        }
    };
    public static final MessageType FNPGetOfferedKey = new MessageType("FNPGetOfferedKey", 3){
        {
            this.addField(DMT.KEY, Key.class);
            this.addField(DMT.OFFER_AUTHENTICATOR, ShortBuffer.class);
            this.addField(DMT.NEED_PUB_KEY, Boolean.class);
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType FNPGetOfferedKeyInvalid = new MessageType("FNPGetOfferedKeyInvalid", 1){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.REASON, Short.class);
        }
    };
    public static final short GET_OFFERED_KEY_REJECTED_BAD_AUTHENTICATOR = 1;
    public static final short GET_OFFERED_KEY_REJECTED_NO_KEY = 2;
    public static final MessageType FNPPing = new MessageType("FNPPing", 1){
        {
            this.addField(DMT.PING_SEQNO, Integer.class);
        }
    };
    public static final MessageType FNPPong = new MessageType("FNPPong", 1){
        {
            this.addField(DMT.PING_SEQNO, Integer.class);
        }
    };
    public static final MessageType FNPRHProbeReply = new MessageType("FNPRHProbeReply", 2){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.NEAREST_LOCATION, Double.class);
            this.addField(DMT.BEST_LOCATION, Double.class);
            this.addField(DMT.COUNTER, Short.class);
            this.addField(DMT.UNIQUE_COUNTER, Short.class);
            this.addField(DMT.LINEAR_COUNTER, Short.class);
        }
    };
    public static final MessageType ProbeRequest = new MessageType("ProbeRequest", 1){
        {
            this.addField(DMT.HTL, Byte.class);
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.TYPE, Byte.class);
        }
    };
    public static final MessageType ProbeError = new MessageType("ProbeError", 1){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.TYPE, Byte.class);
        }
    };
    public static final MessageType ProbeRefused = new MessageType("ProbeRefused", 1){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType ProbeBandwidth = new MessageType("ProbeBandwidth", 1){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.OUTPUT_BANDWIDTH_UPPER_LIMIT, Float.class);
        }
    };
    public static final MessageType ProbeBuild = new MessageType("ProbeBuild", 1){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.BUILD, Integer.class);
        }
    };
    public static final MessageType ProbeIdentifier = new MessageType("ProbeIdentifier", 1){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.PROBE_IDENTIFIER, Long.class);
            this.addField(DMT.UPTIME_PERCENT, Byte.class);
        }
    };
    public static final MessageType ProbeLinkLengths = new MessageType("ProbeLinkLengths", 1){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.LINK_LENGTHS, float[].class);
        }
    };
    public static final MessageType ProbeLocation = new MessageType("ProbeLocation", 1){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.LOCATION, Float.class);
        }
    };
    public static final MessageType ProbeStoreSize = new MessageType("ProbeStoreSize", 1){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.STORE_SIZE, Float.class);
        }
    };
    public static final MessageType ProbeUptime = new MessageType("ProbeUptime", 1){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.UPTIME_PERCENT, Float.class);
        }
    };
    public static final MessageType ProbeRejectStats = new MessageType("ProbeRejectStats", 1){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.REJECT_STATS, ShortBuffer.class);
        }
    };
    static final int CAPACITY_USAGE_MULTIPLIER = 10240;
    static final byte CAPACITY_USAGE_MAX = 10;
    static final byte CAPACITY_USAGE_MIN = 1;
    public static final MessageType ProbeOverallBulkOutputCapacityUsage = new MessageType("ProbeOverallBulkOutputCapacityUsage", 1){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.OUTPUT_BANDWIDTH_CLASS, Byte.class);
            this.addField(DMT.CAPACITY_USAGE, Float.class);
        }
    };
    public static final MessageType FNPSwapRequest = new MessageType("FNPSwapRequest", 1){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.HASH, ShortBuffer.class);
            this.addField(DMT.HTL, Integer.class);
        }
    };
    public static final MessageType FNPSwapRejected = new MessageType("FNPSwapRejected", 1){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType FNPSwapReply = new MessageType("FNPSwapReply", 1){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.HASH, ShortBuffer.class);
        }
    };
    public static final MessageType FNPSwapCommit = new MessageType("FNPSwapCommit", 1){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.DATA, ShortBuffer.class);
        }
    };
    public static final MessageType FNPSwapComplete = new MessageType("FNPSwapComplete", 1){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.DATA, ShortBuffer.class);
        }
    };
    public static final MessageType FNPLocChangeNotificationNew = new MessageType("FNPLocationChangeNotification2", 3){
        {
            this.addField(DMT.LOCATION, Double.class);
            this.addField(DMT.PEER_LOCATIONS, ShortBuffer.class);
        }
    };
    public static final MessageType FNPRoutedPing = new MessageType("FNPRoutedPing", 3){
        {
            this.addRoutedToNodeMessageFields();
            this.addField(DMT.COUNTER, Integer.class);
        }
    };
    public static final MessageType FNPRoutedPong = new MessageType("FNPRoutedPong", 3){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.COUNTER, Integer.class);
        }
    };
    public static final MessageType FNPRoutedRejected = new MessageType("FNPRoutedRejected", 2){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.HTL, Short.class);
        }
    };
    public static final MessageType FNPDetectedIPAddress = new MessageType("FNPDetectedIPAddress", 1){
        {
            this.addField(DMT.EXTERNAL_ADDRESS, Peer.class);
        }
    };
    public static final MessageType FNPTime = new MessageType("FNPTime", 1){
        {
            this.addField(DMT.TIME, Long.class);
        }
    };
    public static final MessageType FNPUptime = new MessageType("FNPUptime", 3){
        {
            this.addField(DMT.UPTIME_PERCENT_48H, Byte.class);
        }
    };
    public static final MessageType FNPVisibility = new MessageType("FNPVisibility", 1){
        {
            this.addField(DMT.FRIEND_VISIBILITY, Short.class);
        }
    };
    public static final MessageType FNPSentPackets = new MessageType("FNPSentPackets", 1){
        {
            this.addField(DMT.TIME_DELTAS, ShortBuffer.class);
            this.addField(DMT.HASHES, ShortBuffer.class);
            this.addField(DMT.TIME, Long.class);
        }
    };
    public static final MessageType FNPVoid = new MessageType("FNPVoid", 3, false, true){};
    public static final MessageType FNPDisconnect = new MessageType("FNPDisconnect", 1){
        {
            this.addField(DMT.REMOVE, Boolean.class);
            this.addField(DMT.PURGE, Boolean.class);
            this.addField(DMT.NODE_TO_NODE_MESSAGE_TYPE, Integer.class);
            this.addField(DMT.NODE_TO_NODE_MESSAGE_DATA, ShortBuffer.class);
        }
    };
    public static final MessageType UOMAnnouncement = new MessageType("UOMAnnouncement", 3){
        {
            this.addField(DMT.MAIN_JAR_KEY, String.class);
            this.addField(DMT.REVOCATION_KEY, String.class);
            this.addField(DMT.HAVE_REVOCATION_KEY, Boolean.class);
            this.addField(DMT.MAIN_JAR_VERSION, Long.class);
            this.addField(DMT.REVOCATION_KEY_TIME_LAST_TRIED, Long.class);
            this.addField(DMT.REVOCATION_KEY_DNF_COUNT, Integer.class);
            this.addField(DMT.REVOCATION_KEY_FILE_LENGTH, Long.class);
            this.addField(DMT.MAIN_JAR_FILE_LENGTH, Long.class);
            this.addField(DMT.PING_TIME, Integer.class);
            this.addField(DMT.BWLIMIT_DELAY_TIME, Integer.class);
        }
    };
    public static final MessageType UOMRequestRevocation = new MessageType("UOMRequestRevocation", 1){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType UOMRequestMainJar = new MessageType("UOMRequestMainJar", 3){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType UOMSendingRevocation = new MessageType("UOMSendingRevocation", 1){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.FILE_LENGTH, Long.class);
            this.addField(DMT.REVOCATION_KEY, String.class);
        }
    };
    public static final MessageType UOMSendingMainJar = new MessageType("UOMSendingMainJar", 3){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.FILE_LENGTH, Long.class);
            this.addField(DMT.MAIN_JAR_KEY, String.class);
            this.addField(DMT.MAIN_JAR_VERSION, Integer.class);
        }
    };
    public static final MessageType UOMFetchDependency = new MessageType("UOMFetchDependency", 3){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.EXPECTED_HASH, ShortBuffer.class);
            this.addField(DMT.FILE_LENGTH, Long.class);
        }
    };
    public static final MessageType FNPSwapNodeUIDs = new MessageType("FNPSwapNodeUIDs", 2){
        {
            this.addField(DMT.NODE_UIDS, ShortBuffer.class);
        }
    };
    public static final MessageType FNPBestRoutesNotTaken = new MessageType("FNPBestRoutesNotTaken", 2){
        {
            this.addField(DMT.BEST_LOCATIONS_NOT_VISITED, ShortBuffer.class);
        }
    };
    public static final MessageType FNPRoutingStatus = new MessageType("FNPRoutingStatus", 1){
        {
            this.addField(DMT.ROUTING_ENABLED, Boolean.class);
        }
    };
    public static final MessageType FNPSubInsertForkControl = new MessageType("FNPSubInsertForkControl", 1){
        {
            this.addField(DMT.ENABLE_INSERT_FORK_WHEN_CACHEABLE, Boolean.class);
        }
    };
    public static final MessageType FNPSubInsertPreferInsert = new MessageType("FNPSubInsertPreferInsert", 1){
        {
            this.addField(DMT.PREFER_INSERT, Boolean.class);
        }
    };
    public static final MessageType FNPSubInsertIgnoreLowBackoff = new MessageType("FNPSubInsertIgnoreLowBackoff", 1){
        {
            this.addField(DMT.IGNORE_LOW_BACKOFF, Boolean.class);
        }
    };
    public static final MessageType FNPRejectIsSoft = new MessageType("FNPRejectIsSoft", 1){};
    public static final MessageType FNPPeerLoadStatusByte = new MessageType("FNPPeerLoadStatusByte", 1, false, true){
        {
            this.addField(DMT.OTHER_TRANSFERS_OUT_CHK, Byte.class);
            this.addField(DMT.OTHER_TRANSFERS_IN_CHK, Byte.class);
            this.addField(DMT.OTHER_TRANSFERS_OUT_SSK, Byte.class);
            this.addField(DMT.OTHER_TRANSFERS_IN_SSK, Byte.class);
            this.addField(DMT.AVERAGE_TRANSFERS_OUT_PER_INSERT, Byte.class);
            this.addField(DMT.OUTPUT_BANDWIDTH_LOWER_LIMIT, Integer.class);
            this.addField(DMT.OUTPUT_BANDWIDTH_UPPER_LIMIT, Integer.class);
            this.addField(DMT.OUTPUT_BANDWIDTH_PEER_LIMIT, Integer.class);
            this.addField(DMT.INPUT_BANDWIDTH_LOWER_LIMIT, Integer.class);
            this.addField(DMT.INPUT_BANDWIDTH_UPPER_LIMIT, Integer.class);
            this.addField(DMT.INPUT_BANDWIDTH_PEER_LIMIT, Integer.class);
            this.addField(DMT.MAX_TRANSFERS_OUT, Byte.class);
            this.addField(DMT.MAX_TRANSFERS_OUT_PEER_LIMIT, Byte.class);
            this.addField(DMT.MAX_TRANSFERS_OUT_LOWER_LIMIT, Byte.class);
            this.addField(DMT.MAX_TRANSFERS_OUT_UPPER_LIMIT, Byte.class);
            this.addField(DMT.REAL_TIME_FLAG, Boolean.class);
        }
    };
    public static final MessageType FNPPeerLoadStatusShort = new MessageType("FNPPeerLoadStatusShort", 1, false, true){
        {
            this.addField(DMT.OTHER_TRANSFERS_OUT_CHK, Short.class);
            this.addField(DMT.OTHER_TRANSFERS_IN_CHK, Short.class);
            this.addField(DMT.OTHER_TRANSFERS_OUT_SSK, Short.class);
            this.addField(DMT.OTHER_TRANSFERS_IN_SSK, Short.class);
            this.addField(DMT.AVERAGE_TRANSFERS_OUT_PER_INSERT, Short.class);
            this.addField(DMT.OUTPUT_BANDWIDTH_LOWER_LIMIT, Integer.class);
            this.addField(DMT.OUTPUT_BANDWIDTH_UPPER_LIMIT, Integer.class);
            this.addField(DMT.OUTPUT_BANDWIDTH_PEER_LIMIT, Integer.class);
            this.addField(DMT.INPUT_BANDWIDTH_LOWER_LIMIT, Integer.class);
            this.addField(DMT.INPUT_BANDWIDTH_UPPER_LIMIT, Integer.class);
            this.addField(DMT.INPUT_BANDWIDTH_PEER_LIMIT, Integer.class);
            this.addField(DMT.MAX_TRANSFERS_OUT, Short.class);
            this.addField(DMT.MAX_TRANSFERS_OUT_PEER_LIMIT, Short.class);
            this.addField(DMT.MAX_TRANSFERS_OUT_LOWER_LIMIT, Short.class);
            this.addField(DMT.MAX_TRANSFERS_OUT_UPPER_LIMIT, Short.class);
            this.addField(DMT.REAL_TIME_FLAG, Boolean.class);
        }
    };
    public static final MessageType FNPPeerLoadStatusInt = new MessageType("FNPPeerLoadStatusInt", 1, false, true){
        {
            this.addField(DMT.OTHER_TRANSFERS_OUT_CHK, Integer.class);
            this.addField(DMT.OTHER_TRANSFERS_IN_CHK, Integer.class);
            this.addField(DMT.OTHER_TRANSFERS_OUT_SSK, Integer.class);
            this.addField(DMT.OTHER_TRANSFERS_IN_SSK, Integer.class);
            this.addField(DMT.AVERAGE_TRANSFERS_OUT_PER_INSERT, Integer.class);
            this.addField(DMT.OUTPUT_BANDWIDTH_LOWER_LIMIT, Integer.class);
            this.addField(DMT.OUTPUT_BANDWIDTH_UPPER_LIMIT, Integer.class);
            this.addField(DMT.OUTPUT_BANDWIDTH_PEER_LIMIT, Integer.class);
            this.addField(DMT.INPUT_BANDWIDTH_LOWER_LIMIT, Integer.class);
            this.addField(DMT.INPUT_BANDWIDTH_UPPER_LIMIT, Integer.class);
            this.addField(DMT.INPUT_BANDWIDTH_PEER_LIMIT, Integer.class);
            this.addField(DMT.MAX_TRANSFERS_OUT, Integer.class);
            this.addField(DMT.MAX_TRANSFERS_OUT_PEER_LIMIT, Integer.class);
            this.addField(DMT.MAX_TRANSFERS_OUT_LOWER_LIMIT, Integer.class);
            this.addField(DMT.MAX_TRANSFERS_OUT_UPPER_LIMIT, Integer.class);
            this.addField(DMT.REAL_TIME_FLAG, Boolean.class);
        }
    };
    public static final String AVERAGE_TRANSFERS_OUT_PER_INSERT = "averageTransfersOutPerInsert";
    public static final String OTHER_TRANSFERS_OUT_CHK = "otherTransfersOutCHK";
    public static final String OTHER_TRANSFERS_IN_CHK = "otherTransfersInCHK";
    public static final String OTHER_TRANSFERS_OUT_SSK = "otherTransfersOutSSK";
    public static final String OTHER_TRANSFERS_IN_SSK = "otherTransfersInSSK";
    public static final String MAX_TRANSFERS_OUT = "maxTransfersOut";
    public static final String MAX_TRANSFERS_OUT_PEER_LIMIT = "maxTransfersOutPeerLimit";
    public static final String MAX_TRANSFERS_OUT_LOWER_LIMIT = "maxTransfersOutLowerLimit";
    public static final String MAX_TRANSFERS_OUT_UPPER_LIMIT = "maxTransfersOutUpperLimit";
    public static final String OUTPUT_BANDWIDTH_LOWER_LIMIT = "outputBandwidthLowerLimit";
    public static final String OUTPUT_BANDWIDTH_UPPER_LIMIT = "outputBandwidthUpperLimit";
    public static final String OUTPUT_BANDWIDTH_PEER_LIMIT = "outputBandwidthPeerLimit";
    public static final String INPUT_BANDWIDTH_LOWER_LIMIT = "inputBandwidthLowerLimit";
    public static final String INPUT_BANDWIDTH_UPPER_LIMIT = "inputBandwidthUpperLimit";
    public static final String INPUT_BANDWIDTH_PEER_LIMIT = "inputBandwidthPeerLimit";
    public static final String REAL_TIME_FLAG = "realTimeFlag";
    public static final MessageType FNPRealTimeFlag = new MessageType("FNPRealTimeFlag", 1){
        {
            this.addField(DMT.REAL_TIME_FLAG, Boolean.class);
        }
    };
    public static final MessageType FNPCheckStillRunning = new MessageType("FNPCheckStillRunning", 1){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.LIST_OF_UIDS, ShortBuffer.class);
        }
    };
    public static final MessageType FNPIsStillRunning = new MessageType("FNPIsStillRunning", 1){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.UID_STILL_RUNNING_FLAGS, BitArray.class);
        }
    };
    public static final MessageType FNPGetYourFullNoderef = new MessageType("FNPGetYourFullNoderef", 3){};
    public static final MessageType FNPMyFullNoderef = new MessageType("FNPMyFullNoderef", 3){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.NODEREF_LENGTH, Integer.class);
        }
    };

    public static Message createPacketTransmit(long uid, int packetNo, BitArray sent, Buffer data, boolean realTime) {
        Message msg = new Message(packetTransmit);
        msg.set(UID, uid);
        msg.set(PACKET_NO, packetNo);
        msg.set(SENT, sent);
        msg.set(DATA, data);
        if (realTime) {
            msg.boostPriority();
        }
        return msg;
    }

    public static int packetTransmitSize(int size, int _packets) {
        return size + 8 + 4 + BitArray.serializedLength(_packets) + 4;
    }

    public static int bulkPacketTransmitSize(int size) {
        return size + 8 + 4 + 4;
    }

    public static Message createAllSent(long uid, boolean realTime) {
        Message msg = new Message(allSent);
        msg.set(UID, uid);
        return msg;
    }

    public static Message createAllReceived(long uid) {
        Message msg = new Message(allReceived);
        msg.set(UID, uid);
        return msg;
    }

    public static Message createSendAborted(long uid, int reason, String description) {
        Message msg = new Message(sendAborted);
        msg.set(UID, uid);
        msg.set(REASON, reason);
        msg.set(DESCRIPTION, description);
        return msg;
    }

    public static Message createFNPBulkPacketSend(long uid, int packetNo, ShortBuffer data, boolean realTime) {
        Message msg = new Message(FNPBulkPacketSend);
        msg.set(UID, uid);
        msg.set(PACKET_NO, packetNo);
        msg.set(DATA, data);
        return msg;
    }

    public static Message createFNPBulkPacketSend(long uid, int packetNo, byte[] data, boolean realTime) {
        return DMT.createFNPBulkPacketSend(uid, packetNo, new ShortBuffer(data), realTime);
    }

    public static Message createFNPBulkSendAborted(long uid) {
        Message msg = new Message(FNPBulkSendAborted);
        msg.set(UID, uid);
        return msg;
    }

    public static Message createFNPBulkReceiveAborted(long uid) {
        Message msg = new Message(FNPBulkReceiveAborted);
        msg.set(UID, uid);
        return msg;
    }

    public static Message createFNPBulkReceivedAll(long uid) {
        Message msg = new Message(FNPBulkReceivedAll);
        msg.set(UID, uid);
        return msg;
    }

    public static Message createTestTransferSend(long uid) {
        Message msg = new Message(testTransferSend);
        msg.set(UID, uid);
        return msg;
    }

    public static Message createTestTransferSendAck(long uid) {
        Message msg = new Message(testTransferSendAck);
        msg.set(UID, uid);
        return msg;
    }

    public static Message createTestSendCHK(long uid, String uri, Buffer header) {
        Message msg = new Message(testSendCHK);
        msg.set(UID, uid);
        msg.set(FREENET_URI, uri);
        msg.set(CHK_HEADER, header);
        return msg;
    }

    public static Message createTestRequest(Key Key2, long id, int htl) {
        Message msg = new Message(testRequest);
        msg.set(UID, id);
        msg.set(FREENET_ROUTING_KEY, Key2);
        msg.set(HTL, htl);
        return msg;
    }

    public static Message createTestDataNotFound(long uid) {
        Message msg = new Message(testDataNotFound);
        msg.set(UID, uid);
        return msg;
    }

    public static Message createTestDataReply(long uid, byte[] headers) {
        Message msg = new Message(testDataReply);
        msg.set(UID, uid);
        msg.set(TEST_CHK_HEADERS, new Buffer(headers));
        return msg;
    }

    public static Message createTestSendCHKAck(long uid, String key) {
        Message msg = new Message(testSendCHKAck);
        msg.set(UID, uid);
        msg.set(FREENET_URI, key);
        return msg;
    }

    public static Message createTestDataReplyAck(long id) {
        Message msg = new Message(testDataReplyAck);
        msg.set(UID, id);
        return msg;
    }

    public static Message createTestDataNotFoundAck(long id) {
        Message msg = new Message(testDataNotFoundAck);
        msg.set(UID, id);
        return msg;
    }

    public static Message createTestReceiveCompleted(long id, boolean success, String reason) {
        Message msg = new Message(testReceiveCompleted);
        msg.set(UID, id);
        msg.set(SUCCESS, success);
        msg.set(REASON, reason);
        return msg;
    }

    public static Message createTestSendCompleted(long id, boolean success, String reason) {
        Message msg = new Message(testSendCompleted);
        msg.set(UID, id);
        msg.set(SUCCESS, success);
        msg.set(REASON, reason);
        return msg;
    }

    public static Message createNodeToNodeMessage(int type, byte[] data) {
        Message msg = new Message(nodeToNodeMessage);
        msg.set(NODE_TO_NODE_MESSAGE_TYPE, type);
        msg.set(NODE_TO_NODE_MESSAGE_DATA, new ShortBuffer(data));
        return msg;
    }

    public static Message createFNPCHKDataRequest(long id, short htl, NodeCHK key) {
        Message msg = new Message(FNPCHKDataRequest);
        msg.set(UID, id);
        msg.set(HTL, htl);
        msg.set(FREENET_ROUTING_KEY, key);
        msg.set(NEAREST_LOCATION, 0.0);
        return msg;
    }

    public static Message createFNPSSKDataRequest(long id, short htl, NodeSSK key, boolean needPubKey) {
        Message msg = new Message(FNPSSKDataRequest);
        msg.set(UID, id);
        msg.set(HTL, htl);
        msg.set(FREENET_ROUTING_KEY, key);
        msg.set(NEAREST_LOCATION, 0.0);
        msg.set(NEED_PUB_KEY, needPubKey);
        return msg;
    }

    public static Message createFNPRejectedLoop(long id) {
        Message msg = new Message(FNPRejectedLoop);
        msg.set(UID, id);
        return msg;
    }

    public static Message createFNPRejectedOverload(long id, boolean isLocal, boolean needsLoad, boolean realTimeFlag) {
        Message msg = new Message(FNPRejectedOverload);
        msg.set(UID, id);
        msg.set(IS_LOCAL, isLocal);
        if (needsLoad) {
            if (realTimeFlag) {
                msg.setNeedsLoadRT();
            } else {
                msg.setNeedsLoadBulk();
            }
        }
        return msg;
    }

    public static Message createFNPAccepted(long id) {
        Message msg = new Message(FNPAccepted);
        msg.set(UID, id);
        return msg;
    }

    public static Message createFNPDataNotFound(long id) {
        Message msg = new Message(FNPDataNotFound);
        msg.set(UID, id);
        return msg;
    }

    public static Message createFNPRecentlyFailed(long id, int timeLeft) {
        Message msg = new Message(FNPRecentlyFailed);
        msg.set(UID, id);
        msg.set(TIME_LEFT, timeLeft);
        return msg;
    }

    public static Message createFNPCHKDataFound(long id, byte[] buf) {
        Message msg = new Message(FNPCHKDataFound);
        msg.set(UID, id);
        msg.set(BLOCK_HEADERS, new ShortBuffer(buf));
        return msg;
    }

    public static Message createFNPRouteNotFound(long id, short htl) {
        Message msg = new Message(FNPRouteNotFound);
        msg.set(UID, id);
        msg.set(HTL, htl);
        return msg;
    }

    public static Message createFNPInsertRequest(long id, short htl, Key key) {
        Message msg = new Message(FNPInsertRequest);
        msg.set(UID, id);
        msg.set(HTL, htl);
        msg.set(FREENET_ROUTING_KEY, key);
        msg.set(NEAREST_LOCATION, 0.0);
        return msg;
    }

    public static Message createFNPInsertReply(long id) {
        Message msg = new Message(FNPInsertReply);
        msg.set(UID, id);
        return msg;
    }

    public static Message createFNPDataInsert(long uid, byte[] headers) {
        Message msg = new Message(FNPDataInsert);
        msg.set(UID, uid);
        msg.set(BLOCK_HEADERS, new ShortBuffer(headers));
        return msg;
    }

    public static Message createFNPInsertTransfersCompleted(long uid, boolean anyTimedOut) {
        Message msg = new Message(FNPInsertTransfersCompleted);
        msg.set(UID, uid);
        msg.set(ANY_TIMED_OUT, anyTimedOut);
        return msg;
    }

    public static Message createFNPRejectedTimeout(long uid) {
        Message msg = new Message(FNPRejectedTimeout);
        msg.set(UID, uid);
        return msg;
    }

    public static Message createFNPDataInsertRejected(long uid, short reason) {
        Message msg = new Message(FNPDataInsertRejected);
        msg.set(UID, uid);
        msg.set(DATA_INSERT_REJECTED_REASON, reason);
        return msg;
    }

    public static String getDataInsertRejectedReason(short reason) {
        if (reason == 1) {
            return "Verify failed";
        }
        if (reason == 2) {
            return "Receive failed";
        }
        if (reason == 3) {
            return "SSK error";
        }
        if (reason == 4) {
            return "Timeout waiting for Accepted (moved on)";
        }
        return "Unknown reason code: " + reason;
    }

    public static Message createFNPSSKInsertRequest(long uid, short htl, NodeSSK myKey, byte[] headers, byte[] data, byte[] pubKeyHash, boolean realTime) {
        Message msg = new Message(FNPSSKInsertRequest);
        msg.set(UID, uid);
        msg.set(HTL, htl);
        msg.set(FREENET_ROUTING_KEY, myKey);
        msg.set(NEAREST_LOCATION, 0.0);
        msg.set(BLOCK_HEADERS, new ShortBuffer(headers));
        msg.set(PUBKEY_HASH, new ShortBuffer(pubKeyHash));
        msg.set(DATA, new ShortBuffer(data));
        if (realTime) {
            msg.boostPriority();
        }
        return msg;
    }

    public static Message createFNPSSKInsertRequestNew(long uid, short htl, NodeSSK myKey) {
        Message msg = new Message(FNPSSKInsertRequestNew);
        msg.set(UID, uid);
        msg.set(HTL, htl);
        msg.set(FREENET_ROUTING_KEY, myKey);
        return msg;
    }

    public static Message createFNPSSKInsertRequestHeaders(long uid, byte[] headers, boolean realTime) {
        Message msg = new Message(FNPSSKInsertRequestHeaders);
        msg.set(UID, uid);
        msg.set(BLOCK_HEADERS, new ShortBuffer(headers));
        if (realTime) {
            msg.boostPriority();
        }
        return msg;
    }

    public static Message createFNPSSKInsertRequestData(long uid, byte[] data, boolean realTime) {
        Message msg = new Message(FNPSSKInsertRequestData);
        msg.set(UID, uid);
        msg.set(DATA, new ShortBuffer(data));
        if (realTime) {
            msg.boostPriority();
        }
        return msg;
    }

    public static Message createFNPSSKDataFoundHeaders(long uid, byte[] headers, boolean realTime) {
        Message msg = new Message(FNPSSKDataFoundHeaders);
        msg.set(UID, uid);
        msg.set(BLOCK_HEADERS, new ShortBuffer(headers));
        if (realTime) {
            msg.boostPriority();
        }
        return msg;
    }

    public static Message createFNPSSKDataFoundData(long uid, byte[] data, boolean realTime) {
        Message msg = new Message(FNPSSKDataFoundData);
        msg.set(UID, uid);
        msg.set(DATA, new ShortBuffer(data));
        if (realTime) {
            msg.boostPriority();
        }
        return msg;
    }

    public static Message createFNPSSKAccepted(long uid, boolean needPubKey) {
        Message msg = new Message(FNPSSKAccepted);
        msg.set(UID, uid);
        msg.set(NEED_PUB_KEY, needPubKey);
        return msg;
    }

    public static Message createFNPSSKPubKey(long uid, DSAPublicKey pubkey, boolean realTime) {
        Message msg = new Message(FNPSSKPubKey);
        msg.set(UID, uid);
        msg.set(PUBKEY_AS_BYTES, new ShortBuffer(pubkey.asPaddedBytes()));
        if (realTime) {
            msg.boostPriority();
        }
        return msg;
    }

    public static Message createFNPSSKPubKeyAccepted(long uid) {
        Message msg = new Message(FNPSSKPubKeyAccepted);
        msg.set(UID, uid);
        return msg;
    }

    public static Message createFNPOpennetCompletedAck(long uid) {
        Message msg = new Message(FNPOpennetCompletedAck);
        msg.set(UID, uid);
        return msg;
    }

    public static Message createFNPOpennetCompletedTimeout(long uid) {
        Message msg = new Message(FNPOpennetCompletedTimeout);
        msg.set(UID, uid);
        return msg;
    }

    public static Message createFNPOpennetConnectDestinationNew(long uid, long transferUID, int noderefLength, int paddedLength) {
        Message msg = new Message(FNPOpennetConnectDestinationNew);
        msg.set(UID, uid);
        msg.set(TRANSFER_UID, transferUID);
        msg.set(NODEREF_LENGTH, noderefLength);
        msg.set(PADDED_LENGTH, paddedLength);
        return msg;
    }

    public static Message createFNPOpennetConnectReplyNew(long uid, long transferUID, int noderefLength, int paddedLength) {
        Message msg = new Message(FNPOpennetConnectReplyNew);
        msg.set(UID, uid);
        msg.set(TRANSFER_UID, transferUID);
        msg.set(NODEREF_LENGTH, noderefLength);
        msg.set(PADDED_LENGTH, paddedLength);
        return msg;
    }

    public static Message createFNPOpennetAnnounceRequest(long uid, long transferUID, int noderefLength, int paddedLength, double target, short htl) {
        Message msg = new Message(FNPOpennetAnnounceRequest);
        msg.set(UID, uid);
        msg.set(TRANSFER_UID, transferUID);
        msg.set(NODEREF_LENGTH, noderefLength);
        msg.set(PADDED_LENGTH, paddedLength);
        msg.set(HTL, htl);
        msg.set(NEAREST_LOCATION, 0.0);
        msg.set(TARGET_LOCATION, target);
        return msg;
    }

    public static Message createFNPOpennetAnnounceReply(long uid, long transferUID, int noderefLength, int paddedLength) {
        Message msg = new Message(FNPOpennetAnnounceReply);
        msg.set(UID, uid);
        msg.set(TRANSFER_UID, transferUID);
        msg.set(NODEREF_LENGTH, noderefLength);
        msg.set(PADDED_LENGTH, paddedLength);
        return msg;
    }

    public static Message createFNPOpennetAnnounceCompleted(long uid) {
        Message msg = new Message(FNPOpennetAnnounceCompleted);
        msg.set(UID, uid);
        return msg;
    }

    public static Message createFNPOpennetDisabled(long uid) {
        Message msg = new Message(FNPOpennetDisabled);
        msg.set(UID, uid);
        return msg;
    }

    public static Message createFNPOpennetNoderefRejected(long uid, int rejectCode) {
        Message msg = new Message(FNPOpennetNoderefRejected);
        msg.set(UID, uid);
        msg.set(REJECT_CODE, rejectCode);
        return msg;
    }

    public static String getOpennetRejectedCode(int x) {
        switch (x) {
            case 1: {
                return "Too big";
            }
            case 2: {
                return "Real length bigger than padded length";
            }
            case 3: {
                return "Transfer failed";
            }
            case 4: {
                return "Invalid noderef";
            }
        }
        return "Unknown rejection code " + x;
    }

    public static Message createFNPOpennetAnnounceNodeNotWanted(long uid) {
        Message msg = new Message(FNPOpennetAnnounceNodeNotWanted);
        msg.set(UID, uid);
        return msg;
    }

    public static Message createFNPOfferKey(Key key, byte[] authenticator) {
        Message msg = new Message(FNPOfferKey);
        msg.set(KEY, key);
        msg.set(OFFER_AUTHENTICATOR, new ShortBuffer(authenticator));
        return msg;
    }

    public static Message createFNPGetOfferedKey(Key key, byte[] authenticator, boolean needPubkey, long uid) {
        Message msg = new Message(FNPGetOfferedKey);
        msg.set(KEY, key);
        msg.set(OFFER_AUTHENTICATOR, new ShortBuffer(authenticator));
        msg.set(NEED_PUB_KEY, needPubkey);
        msg.set(UID, uid);
        return msg;
    }

    public static Message createFNPGetOfferedKeyInvalid(long uid, short reason) {
        Message msg = new Message(FNPGetOfferedKeyInvalid);
        msg.set(UID, uid);
        msg.set(REASON, reason);
        return msg;
    }

    public static Message createFNPPing(int seqNo) {
        Message msg = new Message(FNPPing);
        msg.set(PING_SEQNO, seqNo);
        return msg;
    }

    public static Message createFNPPong(int seqNo) {
        Message msg = new Message(FNPPong);
        msg.set(PING_SEQNO, seqNo);
        return msg;
    }

    public static Message createFNPRHProbeReply(long uid, double nearest, double best, short counter, short uniqueCounter, short linearCounter) {
        Message msg = new Message(FNPRHProbeReply);
        msg.set(UID, uid);
        msg.set(NEAREST_LOCATION, nearest);
        msg.set(BEST_LOCATION, best);
        msg.set(COUNTER, counter);
        msg.set(UNIQUE_COUNTER, uniqueCounter);
        msg.set(LINEAR_COUNTER, linearCounter);
        return msg;
    }

    public static Message createProbeRequest(byte htl, long uid, Type type) {
        Message msg = new Message(ProbeRequest);
        msg.set(HTL, htl);
        msg.set(UID, uid);
        msg.set(TYPE, type.code);
        return msg;
    }

    public static Message createProbeError(long uid, Error error) {
        Message msg = new Message(ProbeError);
        msg.set(UID, uid);
        msg.set(TYPE, error.code);
        return msg;
    }

    public static Message createProbeRefused(long uid) {
        Message msg = new Message(ProbeRefused);
        msg.set(UID, uid);
        return msg;
    }

    public static Message createProbeBandwidth(long uid, float limit) {
        Message msg = new Message(ProbeBandwidth);
        msg.set(UID, uid);
        msg.set(OUTPUT_BANDWIDTH_UPPER_LIMIT, limit);
        return msg;
    }

    public static Message createProbeBuild(long uid, int build) {
        Message msg = new Message(ProbeBuild);
        msg.set(UID, uid);
        msg.set(BUILD, build);
        return msg;
    }

    public static Message createProbeIdentifier(long uid, long probeIdentifier, byte uptimePercentage) {
        Message msg = new Message(ProbeIdentifier);
        msg.set(UID, uid);
        msg.set(PROBE_IDENTIFIER, probeIdentifier);
        msg.set(UPTIME_PERCENT, uptimePercentage);
        return msg;
    }

    public static Message createProbeLinkLengths(long uid, float[] linkLengths) {
        Message msg = new Message(ProbeLinkLengths);
        msg.set(UID, uid);
        msg.set(LINK_LENGTHS, linkLengths);
        return msg;
    }

    public static Message createProbeLocation(long uid, float location) {
        Message msg = new Message(ProbeLocation);
        msg.set(UID, uid);
        msg.set(LOCATION, location);
        return msg;
    }

    public static Message createProbeStoreSize(long uid, float storeSize) {
        Message msg = new Message(ProbeStoreSize);
        msg.set(UID, uid);
        msg.set(STORE_SIZE, storeSize);
        return msg;
    }

    public static Message createProbeUptime(long uid, float uptimePercent) {
        Message msg = new Message(ProbeUptime);
        msg.set(UID, uid);
        msg.set(UPTIME_PERCENT, uptimePercent);
        return msg;
    }

    public static Message createProbeRejectStats(long uid, byte[] rejectStats) {
        Message msg = new Message(ProbeRejectStats);
        msg.set(UID, uid);
        msg.set(REJECT_STATS, new ShortBuffer(rejectStats));
        return msg;
    }

    public static final byte bandwidthClassForCapacityUsage(int bandwidthLimit) {
        bandwidthLimit /= 10240;
        bandwidthLimit = Math.min(bandwidthLimit, 10);
        return (byte)Math.max(bandwidthLimit, 1);
    }

    public static final Message createProbeOverallBulkOutputCapacityUsage(long uid, byte outputBandwidthClass, float capacityUsage) {
        Message msg = new Message(ProbeOverallBulkOutputCapacityUsage);
        msg.set(UID, uid);
        msg.set(OUTPUT_BANDWIDTH_CLASS, outputBandwidthClass);
        msg.set(CAPACITY_USAGE, capacityUsage);
        return msg;
    }

    public static Message createFNPSwapRequest(long uid, byte[] buf, int htl) {
        Message msg = new Message(FNPSwapRequest);
        msg.set(UID, uid);
        msg.set(HASH, new ShortBuffer(buf));
        msg.set(HTL, htl);
        return msg;
    }

    public static Message createFNPSwapRejected(long uid) {
        Message msg = new Message(FNPSwapRejected);
        msg.set(UID, uid);
        return msg;
    }

    public static Message createFNPSwapReply(long uid, byte[] buf) {
        Message msg = new Message(FNPSwapReply);
        msg.set(UID, uid);
        msg.set(HASH, new ShortBuffer(buf));
        return msg;
    }

    public static Message createFNPSwapCommit(long uid, byte[] buf) {
        Message msg = new Message(FNPSwapCommit);
        msg.set(UID, uid);
        msg.set(DATA, new ShortBuffer(buf));
        return msg;
    }

    public static Message createFNPSwapComplete(long uid, byte[] buf) {
        Message msg = new Message(FNPSwapComplete);
        msg.set(UID, uid);
        msg.set(DATA, new ShortBuffer(buf));
        return msg;
    }

    public static Message createFNPLocChangeNotificationNew(double myLocation, double[] locations) {
        Message msg = new Message(FNPLocChangeNotificationNew);
        ShortBuffer dst = new ShortBuffer(Fields.doublesToBytes(locations));
        msg.set(LOCATION, myLocation);
        msg.set(PEER_LOCATIONS, dst);
        return msg;
    }

    public static Message createFNPRoutedPing(long uid, double targetLocation, short htl, int counter, byte[] nodeIdentity) {
        Message msg = new Message(FNPRoutedPing);
        msg.setRoutedToNodeFields(uid, targetLocation, htl, nodeIdentity);
        msg.set(COUNTER, counter);
        return msg;
    }

    public static Message createFNPRoutedPong(long uid, int counter) {
        Message msg = new Message(FNPRoutedPong);
        msg.set(UID, uid);
        msg.set(COUNTER, counter);
        return msg;
    }

    public static Message createFNPRoutedRejected(long uid, short htl) {
        Message msg = new Message(FNPRoutedRejected);
        msg.set(UID, uid);
        msg.set(HTL, htl);
        return msg;
    }

    public static Message createFNPDetectedIPAddress(Peer peer) {
        Message msg = new Message(FNPDetectedIPAddress);
        msg.set(EXTERNAL_ADDRESS, peer);
        return msg;
    }

    public static Message createFNPTime(long time) {
        Message msg = new Message(FNPTime);
        msg.set(TIME, time);
        return msg;
    }

    public static Message createFNPUptime(byte uptimePercent) {
        Message msg = new Message(FNPUptime);
        msg.set(UPTIME_PERCENT_48H, uptimePercent);
        return msg;
    }

    public static Message createFNPVisibility(short visibility) {
        Message msg = new Message(FNPVisibility);
        msg.set(FRIEND_VISIBILITY, visibility);
        return msg;
    }

    public static Message createFNPVoid() {
        Message msg = new Message(FNPVoid);
        return msg;
    }

    public static Message createFNPDisconnect(boolean remove, boolean purge, int messageType, ShortBuffer messageData) {
        Message msg = new Message(FNPDisconnect);
        msg.set(REMOVE, remove);
        msg.set(PURGE, purge);
        msg.set(NODE_TO_NODE_MESSAGE_TYPE, messageType);
        msg.set(NODE_TO_NODE_MESSAGE_DATA, messageData);
        return msg;
    }

    public static Message createUOMAnnouncement(String mainKey, String revocationKey, boolean haveRevocation, long mainJarVersion, long timeLastTriedRevocationFetch, int revocationDNFCount, long revocationKeyLength, long mainJarLength, int pingTime, int bwlimitDelayTime) {
        Message msg = new Message(UOMAnnouncement);
        msg.set(MAIN_JAR_KEY, mainKey);
        msg.set(REVOCATION_KEY, revocationKey);
        msg.set(HAVE_REVOCATION_KEY, haveRevocation);
        msg.set(MAIN_JAR_VERSION, mainJarVersion);
        msg.set(REVOCATION_KEY_TIME_LAST_TRIED, timeLastTriedRevocationFetch);
        msg.set(REVOCATION_KEY_DNF_COUNT, revocationDNFCount);
        msg.set(REVOCATION_KEY_FILE_LENGTH, revocationKeyLength);
        msg.set(MAIN_JAR_FILE_LENGTH, mainJarLength);
        msg.set(PING_TIME, pingTime);
        msg.set(BWLIMIT_DELAY_TIME, bwlimitDelayTime);
        return msg;
    }

    public static Message createUOMRequestRevocation(long uid) {
        Message msg = new Message(UOMRequestRevocation);
        msg.set(UID, uid);
        return msg;
    }

    public static Message createUOMRequestMainJar(long uid) {
        Message msg = new Message(UOMRequestMainJar);
        msg.set(UID, uid);
        return msg;
    }

    public static Message createUOMSendingRevocation(long uid, long length, String key) {
        Message msg = new Message(UOMSendingRevocation);
        msg.set(UID, uid);
        msg.set(FILE_LENGTH, length);
        msg.set(REVOCATION_KEY, key);
        return msg;
    }

    public static Message createUOMSendingMainJar(long uid, long length, String key, int version) {
        Message msg = new Message(UOMSendingMainJar);
        msg.set(UID, uid);
        msg.set(FILE_LENGTH, length);
        msg.set(MAIN_JAR_KEY, key);
        msg.set(MAIN_JAR_VERSION, version);
        return msg;
    }

    public static Message createUOMFetchDependency(long uid, byte[] hash, long length) {
        Message msg = new Message(UOMFetchDependency);
        msg.set(UID, uid);
        msg.set(EXPECTED_HASH, new ShortBuffer(hash));
        msg.set(FILE_LENGTH, length);
        return msg;
    }

    public static Message createFNPSwapLocations(long[] uids) {
        Message msg = new Message(FNPSwapNodeUIDs);
        msg.set(NODE_UIDS, new ShortBuffer(Fields.longsToBytes(uids)));
        return msg;
    }

    public static Message createFNPBestRoutesNotTaken(byte[] locs) {
        Message msg = new Message(FNPBestRoutesNotTaken);
        msg.set(BEST_LOCATIONS_NOT_VISITED, new ShortBuffer(locs));
        return msg;
    }

    public static Message createFNPBestRoutesNotTaken(double[] locs) {
        return DMT.createFNPBestRoutesNotTaken(Fields.doublesToBytes(locs));
    }

    public static Message createFNPBestRoutesNotTaken(Double[] doubles) {
        double[] locs = new double[doubles.length];
        for (int i = 0; i < locs.length; ++i) {
            locs[i] = doubles[i];
        }
        return DMT.createFNPBestRoutesNotTaken(locs);
    }

    public static Message createRoutingStatus(boolean routeRequests) {
        Message msg = new Message(FNPRoutingStatus);
        msg.set(ROUTING_ENABLED, routeRequests);
        return msg;
    }

    public static Message createFNPSubInsertForkControl(boolean enableInsertForkWhenCacheable) {
        Message msg = new Message(FNPSubInsertForkControl);
        msg.set(ENABLE_INSERT_FORK_WHEN_CACHEABLE, enableInsertForkWhenCacheable);
        return msg;
    }

    public static Message createFNPSubInsertPreferInsert(boolean preferInsert) {
        Message msg = new Message(FNPSubInsertPreferInsert);
        msg.set(PREFER_INSERT, preferInsert);
        return msg;
    }

    public static Message createFNPSubInsertIgnoreLowBackoff(boolean ignoreLowBackoff) {
        Message msg = new Message(FNPSubInsertIgnoreLowBackoff);
        msg.set(IGNORE_LOW_BACKOFF, ignoreLowBackoff);
        return msg;
    }

    public static Message createFNPRejectIsSoft() {
        return new Message(FNPRejectIsSoft);
    }

    public static Message createFNPPeerLoadStatus(NodeStats.PeerLoadStats stats) {
        Message msg;
        if (stats.expectedTransfersInCHK < 256 && stats.expectedTransfersInSSK < 256 && stats.expectedTransfersOutCHK < 256 && stats.expectedTransfersOutSSK < 256 && stats.averageTransfersOutPerInsert < 256 && stats.maxTransfersOut < 256 && stats.maxTransfersOutLowerLimit < 256 && stats.maxTransfersOutPeerLimit < 256 && stats.maxTransfersOutUpperLimit < 256) {
            msg = new Message(FNPPeerLoadStatusByte);
            msg.set(OTHER_TRANSFERS_OUT_CHK, (byte)stats.expectedTransfersOutCHK);
            msg.set(OTHER_TRANSFERS_IN_CHK, (byte)stats.expectedTransfersInCHK);
            msg.set(OTHER_TRANSFERS_OUT_SSK, (byte)stats.expectedTransfersOutSSK);
            msg.set(OTHER_TRANSFERS_IN_SSK, (byte)stats.expectedTransfersInSSK);
            msg.set(AVERAGE_TRANSFERS_OUT_PER_INSERT, (byte)stats.averageTransfersOutPerInsert);
            msg.set(MAX_TRANSFERS_OUT, (byte)stats.maxTransfersOut);
            msg.set(MAX_TRANSFERS_OUT_PEER_LIMIT, (byte)stats.maxTransfersOutPeerLimit);
            msg.set(MAX_TRANSFERS_OUT_LOWER_LIMIT, (byte)stats.maxTransfersOutLowerLimit);
            msg.set(MAX_TRANSFERS_OUT_UPPER_LIMIT, (byte)stats.maxTransfersOutUpperLimit);
        } else if (stats.expectedTransfersInCHK < 65536 && stats.expectedTransfersInSSK < 65536 && stats.expectedTransfersOutCHK < 65536 && stats.expectedTransfersOutSSK < 65536 && stats.averageTransfersOutPerInsert < 65536 && stats.maxTransfersOut < 65536 && stats.maxTransfersOutLowerLimit < 65536 && stats.maxTransfersOutPeerLimit < 65536 && stats.maxTransfersOutUpperLimit < 65536) {
            msg = new Message(FNPPeerLoadStatusShort);
            msg.set(OTHER_TRANSFERS_OUT_CHK, (short)stats.expectedTransfersOutCHK);
            msg.set(OTHER_TRANSFERS_IN_CHK, (short)stats.expectedTransfersInCHK);
            msg.set(OTHER_TRANSFERS_OUT_SSK, (short)stats.expectedTransfersOutSSK);
            msg.set(OTHER_TRANSFERS_IN_SSK, (short)stats.expectedTransfersInSSK);
            msg.set(AVERAGE_TRANSFERS_OUT_PER_INSERT, (short)stats.averageTransfersOutPerInsert);
            msg.set(MAX_TRANSFERS_OUT, (short)stats.maxTransfersOut);
            msg.set(MAX_TRANSFERS_OUT_PEER_LIMIT, (short)stats.maxTransfersOutPeerLimit);
            msg.set(MAX_TRANSFERS_OUT_LOWER_LIMIT, (short)stats.maxTransfersOutLowerLimit);
            msg.set(MAX_TRANSFERS_OUT_UPPER_LIMIT, (short)stats.maxTransfersOutUpperLimit);
        } else {
            msg = new Message(FNPPeerLoadStatusInt);
            msg.set(OTHER_TRANSFERS_OUT_CHK, stats.expectedTransfersOutCHK);
            msg.set(OTHER_TRANSFERS_IN_CHK, stats.expectedTransfersInCHK);
            msg.set(OTHER_TRANSFERS_OUT_SSK, stats.expectedTransfersOutSSK);
            msg.set(OTHER_TRANSFERS_IN_SSK, stats.expectedTransfersInSSK);
            msg.set(AVERAGE_TRANSFERS_OUT_PER_INSERT, stats.averageTransfersOutPerInsert);
            msg.set(MAX_TRANSFERS_OUT, stats.maxTransfersOut);
            msg.set(MAX_TRANSFERS_OUT_PEER_LIMIT, stats.maxTransfersOutPeerLimit);
            msg.set(MAX_TRANSFERS_OUT_LOWER_LIMIT, stats.maxTransfersOutLowerLimit);
            msg.set(MAX_TRANSFERS_OUT_UPPER_LIMIT, stats.maxTransfersOutUpperLimit);
        }
        msg.set(OUTPUT_BANDWIDTH_LOWER_LIMIT, (int)stats.outputBandwidthLowerLimit);
        msg.set(OUTPUT_BANDWIDTH_UPPER_LIMIT, (int)stats.outputBandwidthUpperLimit);
        msg.set(OUTPUT_BANDWIDTH_PEER_LIMIT, (int)stats.outputBandwidthPeerLimit);
        msg.set(INPUT_BANDWIDTH_LOWER_LIMIT, (int)stats.inputBandwidthLowerLimit);
        msg.set(INPUT_BANDWIDTH_UPPER_LIMIT, (int)stats.inputBandwidthUpperLimit);
        msg.set(INPUT_BANDWIDTH_PEER_LIMIT, (int)stats.inputBandwidthPeerLimit);
        msg.set(REAL_TIME_FLAG, stats.realTime);
        return msg;
    }

    public static Message createFNPRealTimeFlag(boolean isBulk) {
        Message msg = new Message(FNPRealTimeFlag);
        msg.set(REAL_TIME_FLAG, isBulk);
        return msg;
    }

    public static boolean getRealTimeFlag(Message m) {
        Message bulk = m.getSubMessage(FNPRealTimeFlag);
        if (bulk == null) {
            return false;
        }
        return bulk.getBoolean(REAL_TIME_FLAG);
    }

    public static boolean isPeerLoadStatusMessage(Message m) {
        MessageType spec = m.getSpec();
        return spec == FNPPeerLoadStatusByte || spec == FNPPeerLoadStatusShort || spec == FNPPeerLoadStatusInt;
    }

    public static boolean isLoadLimitedRequest(Message m) {
        MessageType spec = m.getSpec();
        return spec == FNPCHKDataRequest || spec == FNPSSKDataRequest || spec == FNPSSKInsertRequest || spec == FNPInsertRequest || spec == FNPSSKInsertRequestNew || spec == FNPGetOfferedKey;
    }

    public static Message createFNPGetYourFullNoderef() {
        return new Message(FNPGetYourFullNoderef);
    }

    public static Message createFNPMyFullNoderef(long uid, int length) {
        Message m = new Message(FNPMyFullNoderef);
        m.set(UID, uid);
        m.set(NODEREF_LENGTH, length);
        return m;
    }
}

