/*
 * Decompiled with CFR 0.152.
 */
package freenet.io.xfer;

import freenet.support.LogThresholdCallback;
import freenet.support.Logger;

public class PacketThrottle {
    private static volatile boolean logMINOR;
    protected static final double PACKET_DROP_DECREASE_MULTIPLE = 0.875;
    protected static final double PACKET_TRANSMIT_INCREMENT = 0.3125;
    protected static final double SLOW_START_DIVISOR = 3.0;
    protected static final long MAX_DELAY = 1000L;
    protected static final long MIN_DELAY = 1L;
    public static final String VERSION = "$Id: PacketThrottle.java,v 1.3 2005/08/25 17:28:19 amphibian Exp $";
    public static final long DEFAULT_DELAY = 200L;
    private long _roundTripTime = 500L;
    private long _totalPackets;
    private long _droppedPackets;
    private float _windowSize = 2.0f;
    private final int PACKET_SIZE;
    private boolean slowStart = true;

    public PacketThrottle(int packetSize) {
        this.PACKET_SIZE = packetSize;
    }

    public synchronized void setRoundTripTime(long rtt) {
        this._roundTripTime = Math.max(rtt, 10L);
        if (logMINOR) {
            Logger.minor(this, "Set round trip time to " + rtt + " on " + this);
        }
    }

    public synchronized void notifyOfPacketsLost(int numPackets) {
        if (numPackets <= 0) {
            throw new IllegalArgumentException("Reported loss is zero or negative");
        }
        this._droppedPackets += (long)numPackets;
        this._totalPackets += (long)numPackets;
        this._windowSize = (float)((double)this._windowSize * Math.pow(0.875, numPackets));
        if (this._windowSize < 1.0f) {
            this._windowSize = 1.0f;
        }
        this.slowStart = false;
        if (logMINOR) {
            Logger.minor(this, "notifyOfPacketsLost(): " + this);
        }
    }

    public synchronized void notifyOfPacketAcknowledged(double maxWindowSize) {
        ++this._totalPackets;
        int windowSize = (int)this.getWindowSize();
        if (this.slowStart) {
            if (logMINOR) {
                Logger.minor(this, "Still in slow start");
            }
            this._windowSize = (float)((double)this._windowSize + (double)this._windowSize / 3.0);
            if ((double)this._windowSize > maxWindowSize) {
                this.slowStart = false;
            }
            if (this._windowSize < 1.0f) {
                this._windowSize = 1.0f;
            }
        } else {
            this._windowSize = (float)((double)this._windowSize + 0.3125 / (double)this._windowSize);
        }
        if ((double)this._windowSize > maxWindowSize) {
            this._windowSize = (float)maxWindowSize;
        }
        if (this._windowSize > (float)(windowSize + 1)) {
            this.notifyAll();
        }
        if (logMINOR) {
            Logger.minor(this, "notifyOfPacketAcked(): " + this);
        }
    }

    public synchronized long getDelay() {
        return Math.max(1L, (long)((float)this._roundTripTime / this._windowSize));
    }

    public synchronized String toString() {
        return Double.toString(this.getBandwidth()) + " k/sec, (w: " + this._windowSize + ", r:" + this._roundTripTime + ", d:" + (float)this._droppedPackets / (float)this._totalPackets + ") total=" + this._totalPackets + " : " + super.toString();
    }

    public synchronized long getRoundTripTime() {
        return this._roundTripTime;
    }

    public synchronized double getWindowSize() {
        return Math.max(1.0, (double)this._windowSize);
    }

    public synchronized double getBandwidth() {
        return (double)this.PACKET_SIZE * 1000.0 / (double)this.getDelay();
    }

    public synchronized void maybeDisconnected() {
        this.notifyAll();
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

