/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.node.Node;
import freenet.node.PeerNode;
import freenet.node.UIDTag;
import freenet.support.Logger;
import freenet.support.TimeUtil;

public class InsertTag
extends UIDTag {
    final boolean ssk;
    final START start;
    private Throwable handlerThrew;
    private boolean senderStarted;
    private boolean senderFinished;

    InsertTag(boolean ssk, START start, PeerNode source, boolean realTimeFlag, long uid, Node node) {
        super(source, realTimeFlag, uid, node);
        this.start = start;
        this.ssk = ssk;
    }

    public synchronized void startedSender() {
        this.senderStarted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishedSender() {
        boolean noRecordUnlock;
        InsertTag insertTag = this;
        synchronized (insertTag) {
            this.senderFinished = true;
            if (!this.mustUnlock()) {
                return;
            }
            noRecordUnlock = this.noRecordUnlock;
        }
        this.innerUnlock(noRecordUnlock);
    }

    @Override
    protected synchronized boolean mustUnlock() {
        if (this.senderStarted && !this.senderFinished) {
            return false;
        }
        return super.mustUnlock();
    }

    public synchronized void handlerThrew(Throwable t) {
        this.handlerThrew = t;
    }

    @Override
    public void logStillPresent(Long uid) {
        StringBuffer sb = new StringBuffer();
        sb.append("Still present after ").append(TimeUtil.formatTime(this.age()));
        sb.append(" : ").append(uid).append(" : start=").append((Object)this.start);
        sb.append(" ssk=").append(this.ssk);
        sb.append(" thrown=").append(this.handlerThrew);
        sb.append(" : ");
        sb.append(super.toString());
        if (this.handlerThrew != null) {
            Logger.error(this, sb.toString(), this.handlerThrew);
        } else {
            Logger.error(this, sb.toString());
        }
    }

    @Override
    public synchronized int expectedTransfersIn(boolean ignoreLocalVsRemote, int outwardTransfersPerInsert, boolean forAccept) {
        if (!this.accepted) {
            return 0;
        }
        return !this.isLocal() || ignoreLocalVsRemote ? 1 : 0;
    }

    @Override
    public synchronized int expectedTransfersOut(boolean ignoreLocalVsRemote, int outwardTransfersPerInsert, boolean forAccept) {
        if (!this.accepted) {
            return 0;
        }
        if (this.notRoutedOnwards) {
            return 0;
        }
        return outwardTransfersPerInsert;
    }

    @Override
    public boolean isSSK() {
        return this.ssk;
    }

    @Override
    public boolean isInsert() {
        return true;
    }

    @Override
    public boolean isOfferReply() {
        return false;
    }

    static enum START {
        LOCAL,
        REMOTE;

    }
}

