/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.node.PeerNode;
import freenet.support.Logger;

public class Location {
    public static final double LOCATION_INVALID = -1.0;

    public static double getLocation(String init) {
        try {
            if (init == null) {
                return -1.0;
            }
            double d = Double.parseDouble(init);
            if (!Location.isValid(d)) {
                return -1.0;
            }
            return d;
        }
        catch (NumberFormatException e) {
            return -1.0;
        }
    }

    public static double distance(PeerNode p, double loc) {
        return Location.distance(p.getLocation(), loc);
    }

    public static double distance(double a, double b) {
        if (!Location.isValid(a) || !Location.isValid(b)) {
            String errMsg = "Invalid Location ! a = " + a + " b = " + b + " Please report this bug!";
            Logger.error(Location.class, errMsg, (Throwable)new Exception("error"));
            throw new IllegalArgumentException(errMsg);
        }
        return Location.simpleDistance(a, b);
    }

    public static double distanceAllowInvalid(double a, double b) {
        if (!Location.isValid(a) && !Location.isValid(b)) {
            return 0.0;
        }
        if (!Location.isValid(a)) {
            return 2.0 - b;
        }
        if (!Location.isValid(b)) {
            return 2.0 - a;
        }
        return Location.simpleDistance(a, b);
    }

    private static double simpleDistance(double a, double b) {
        return Math.abs(Location.change(a, b));
    }

    public static double change(double from, double to) {
        double change = to - from;
        if (change > 0.5) {
            return change - 1.0;
        }
        if (change <= -0.5) {
            return change + 1.0;
        }
        return change;
    }

    public static double normalize(double rough) {
        double normal = rough % 1.0;
        if (normal < 0.0) {
            return 1.0 + normal;
        }
        return normal;
    }

    public static boolean equals(double a, double b) {
        return Location.distanceAllowInvalid(a, b) < 9.9E-324;
    }

    public static boolean isValid(double loc) {
        return loc >= 0.0 && loc <= 1.0;
    }
}

