/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.node.Node;
import freenet.node.ProgramDirectory;
import java.io.File;

public enum NodeFile {
    Seednodes(InstallDirectory.Node, "seednodes.fref"),
    InstallerWindows(InstallDirectory.Run, "freenet-latest-installer-windows.exe"),
    InstallerNonWindows(InstallDirectory.Run, "freenet-latest-installer-nonwindows.jar"),
    IPv4ToCountry(InstallDirectory.Run, "IpToCountry.dat");

    private final InstallDirectory dir;
    private final String filename;

    public File getFile(Node node) {
        return this.dir.getDir(node).file(this.filename);
    }

    public String getFilename() {
        return this.filename;
    }

    public ProgramDirectory getProgramDirectory(Node node) {
        return this.dir.getDir(node);
    }

    private NodeFile(InstallDirectory dir, String filename) {
        this.dir = dir;
        this.filename = filename;
    }

    private static enum InstallDirectory {
        Node{

            @Override
            ProgramDirectory getDir(Node node) {
                return node.nodeDir();
            }
        }
        ,
        Cfg{

            @Override
            ProgramDirectory getDir(Node node) {
                return node.cfgDir();
            }
        }
        ,
        User{

            @Override
            ProgramDirectory getDir(Node node) {
                return node.userDir();
            }
        }
        ,
        Run{

            @Override
            ProgramDirectory getDir(Node node) {
                return node.runDir();
            }
        }
        ,
        Store{

            @Override
            ProgramDirectory getDir(Node node) {
                return node.storeDir();
            }
        }
        ,
        Plugin{

            @Override
            ProgramDirectory getDir(Node node) {
                return node.pluginDir();
            }
        };


        abstract ProgramDirectory getDir(Node var1);
    }
}

