/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.useralerts;

import freenet.clients.fcp.FCPMessage;
import freenet.clients.fcp.FeedMessage;
import freenet.l10n.NodeL10n;
import freenet.node.PeerTooOldException;
import freenet.node.useralerts.UserAlert;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class DroppedOldPeersUserAlert
implements UserAlert {
    private final List<String> droppedOldPeers = new ArrayList<String>();
    private int droppedOldPeersBuild;
    private Date droppedOldPeersDate;
    private final File peersBrokenFile;
    private final long creationTime;

    public DroppedOldPeersUserAlert(File droppedPeersFile) {
        this.peersBrokenFile = droppedPeersFile;
        this.creationTime = System.currentTimeMillis();
        this.droppedOldPeersBuild = 0;
        this.droppedOldPeersDate = new Date();
    }

    public void add(PeerTooOldException e, String name) {
        name = name == null ? "(unknown name)" : "\"" + name + "\"";
        this.droppedOldPeers.add(name);
        if (e.buildNumber > this.droppedOldPeersBuild) {
            this.droppedOldPeersBuild = e.buildNumber;
            this.droppedOldPeersDate = e.buildDate;
        }
        String shortError = this.getLogWarning(e);
        System.err.println(shortError);
        Logger.error(this, shortError);
    }

    public boolean isEmpty() {
        return this.droppedOldPeers.isEmpty();
    }

    @Override
    public boolean userCanDismiss() {
        return true;
    }

    private String getErrorIntro() {
        String[] keys = new String[]{"count", "buildNumber", "buildDate", "filename"};
        String[] values = new String[]{"" + this.droppedOldPeers.size(), "" + this.droppedOldPeersBuild, this.droppedOldPeersDate.toString(), this.peersBrokenFile.toString()};
        return DroppedOldPeersUserAlert.l10n("droppingOldFriendFull", keys, values);
    }

    @Override
    public String getTitle() {
        String[] keys = new String[]{"count", "buildNumber", "buildDate", "filename"};
        String[] values = new String[]{"" + this.droppedOldPeers.size(), "" + this.droppedOldPeersBuild, this.droppedOldPeersDate.toString(), this.peersBrokenFile.toString()};
        return DroppedOldPeersUserAlert.l10n("droppingOldFriendTitle", keys, values);
    }

    @Override
    public String getText() {
        StringBuffer longErrorText = new StringBuffer();
        longErrorText.append(this.getErrorIntro());
        longErrorText.append('\n');
        longErrorText.append(DroppedOldPeersUserAlert.l10n("droppingOldFriendList"));
        longErrorText.append('\n');
        for (String name : this.droppedOldPeers) {
            longErrorText.append(name);
            longErrorText.append('\n');
        }
        longErrorText.setLength(longErrorText.length() - 1);
        return longErrorText.toString();
    }

    @Override
    public HTMLNode getHTMLText() {
        HTMLNode html = new HTMLNode("#");
        html.addChild("p", this.getErrorIntro());
        html.addChild("p", DroppedOldPeersUserAlert.l10n("droppingOldFriendList"));
        HTMLNode list = html.addChild("ul");
        for (String name : this.droppedOldPeers) {
            list.addChild("li", name);
        }
        return html;
    }

    @Override
    public String getShortText() {
        return this.getTitle();
    }

    @Override
    public short getPriorityClass() {
        return 0;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void isValid(boolean validity) {
    }

    @Override
    public String dismissButtonText() {
        return NodeL10n.getBase().getString("UserAlert.hide");
    }

    @Override
    public boolean shouldUnregisterOnDismiss() {
        return true;
    }

    @Override
    public void onDismiss() {
    }

    @Override
    public String anchor() {
        return "droppedPeersUserAlert";
    }

    @Override
    public boolean isEventNotification() {
        return false;
    }

    @Override
    public FCPMessage getFCPMessage() {
        return new FeedMessage(this.getTitle(), this.getShortText(), this.getText(), this.getPriorityClass(), this.getUpdatedTime());
    }

    @Override
    public long getUpdatedTime() {
        return this.creationTime;
    }

    private static String l10n(String key) {
        return NodeL10n.getBase().getString("DroppedOldPeersUserAlert." + key);
    }

    private static String l10n(String key, String pattern, String value) {
        return NodeL10n.getBase().getString("DroppedOldPeersUserAlert." + key, pattern, value);
    }

    private static String l10n(String key, String[] pattern, String[] value) {
        return NodeL10n.getBase().getString("DroppedOldPeersUserAlert." + key, pattern, value);
    }

    private String getLogWarning(PeerTooOldException e) {
        String[] keys = new String[]{"count", "buildNumber", "buildDate", "port"};
        String[] values = new String[]{Integer.toString(this.droppedOldPeers.size()), Integer.toString(e.buildNumber), e.buildDate.toString(), this.peersBrokenFile.getPath()};
        return DroppedOldPeersUserAlert.l10n("droppingOldFriendTitle", keys, values);
    }
}

