/*
 * Decompiled with CFR 0.152.
 */
package freenet.store.caching;

import freenet.store.caching.CachingFreenetStore;
import freenet.support.Logger;
import freenet.support.Ticker;
import java.util.ArrayList;

public class CachingFreenetStoreTracker {
    private static volatile boolean logMINOR;
    private static int numberOfKeysToWrite;
    private static double lowerThreshold;
    private final long maxSize;
    private final long period;
    private final ArrayList<CachingFreenetStore<?>> cachingStores;
    private final Ticker ticker;
    private boolean queuedJob;
    private boolean runningJob;
    private long size;

    public CachingFreenetStoreTracker(long maxSize, long period, Ticker ticker) {
        if (ticker == null) {
            throw new IllegalArgumentException();
        }
        this.size = 0L;
        this.maxSize = maxSize;
        this.period = period;
        this.queuedJob = false;
        this.cachingStores = new ArrayList();
        this.ticker = ticker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCachingFS(CachingFreenetStore<?> fs) {
        ArrayList<CachingFreenetStore<?>> arrayList = this.cachingStores;
        synchronized (arrayList) {
            this.cachingStores.add(fs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterCachingFS(CachingFreenetStore<?> fs) {
        Object object;
        long sizeBlock = 0L;
        while (true) {
            sizeBlock = fs.pushLeastRecentlyBlock();
            object = this;
            synchronized (object) {
                if (sizeBlock == -1L) {
                    break;
                }
                this.size -= sizeBlock;
            }
        }
        object = this.cachingStores;
        synchronized (object) {
            this.cachingStores.remove(fs);
        }
    }

    public synchronized boolean add(long sizeBlock) {
        boolean justStartedPush = false;
        if ((double)(this.size + sizeBlock) > (double)this.maxSize * lowerThreshold) {
            this.pushOffThreadNow();
            justStartedPush = true;
        }
        if (this.size + sizeBlock > this.maxSize) {
            return false;
        }
        this.size += sizeBlock;
        if (!justStartedPush) {
            this.pushOffThreadDelayed();
        }
        return true;
    }

    private synchronized void pushOffThreadNow() {
        if (this.runningJob) {
            return;
        }
        this.runningJob = true;
        this.ticker.queueTimedJob(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    CachingFreenetStoreTracker.this.pushAllCachingStores();
                }
                finally {
                    CachingFreenetStoreTracker.this.runningJob = false;
                }
            }
        }, 0L);
    }

    private void pushOffThreadDelayed() {
        if (this.queuedJob) {
            return;
        }
        this.queuedJob = true;
        this.ticker.queueTimedJob(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                2 var1_1 = this;
                synchronized (var1_1) {
                    if (CachingFreenetStoreTracker.this.runningJob) {
                        return;
                    }
                    CachingFreenetStoreTracker.this.runningJob = true;
                }
                try {
                    CachingFreenetStoreTracker.this.pushAllCachingStores();
                }
                finally {
                    var1_1 = this;
                    synchronized (var1_1) {
                        CachingFreenetStoreTracker.this.queuedJob = false;
                        CachingFreenetStoreTracker.this.runningJob = false;
                    }
                }
            }
        }, this.period);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pushAllCachingStores() {
        CachingFreenetStore[] cachingStoresSnapshot = null;
        block6: while (true) {
            ArrayList<CachingFreenetStore<?>> arrayList = this.cachingStores;
            synchronized (arrayList) {
                cachingStoresSnapshot = this.cachingStores.toArray(new CachingFreenetStore[this.cachingStores.size()]);
            }
            CachingFreenetStore[] arr$ = cachingStoresSnapshot;
            int len$ = arr$.length;
            int i$ = 0;
            while (true) {
                long sizeBlock;
                if (i$ >= len$) continue block6;
                CachingFreenetStore cfs = arr$[i$];
                for (int k = 0; k < numberOfKeysToWrite && (sizeBlock = cfs.pushLeastRecentlyBlock()) != -1L; ++k) {
                    CachingFreenetStoreTracker cachingFreenetStoreTracker = this;
                    synchronized (cachingFreenetStoreTracker) {
                        this.size -= sizeBlock;
                        assert (this.size >= 0L);
                        if (this.size < 0L) {
                            Logger.error(this, "Cache broken: Size = " + this.size);
                            this.size = 0L;
                        }
                        if (this.size == 0L) {
                            return;
                        }
                        continue;
                    }
                }
                ++i$;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSizeOfCache() {
        long sizeReturned;
        CachingFreenetStoreTracker cachingFreenetStoreTracker = this;
        synchronized (cachingFreenetStoreTracker) {
            sizeReturned = this.size;
        }
        return sizeReturned;
    }

    static {
        numberOfKeysToWrite = 20;
        lowerThreshold = 0.9;
        Logger.registerClass(CachingFreenetStore.class);
    }
}

