/*
 * Decompiled with CFR 0.152.
 */
package freenet.store.saltedhash;

import freenet.support.Fields;
import freenet.support.Logger;
import freenet.support.Ticker;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ResizablePersistentIntBuffer {
    private final File filename;
    private final RandomAccessFile raf;
    private final FileChannel channel;
    private final boolean isNew;
    private int size;
    private int[] buffer;
    private final ReadWriteLock lock;
    public static final int DEFAULT_PERSISTENCE_TIME = 300000;
    private static int globalPersistenceTime = 300000;
    private Ticker ticker;
    private boolean dirty;
    private boolean scheduled;
    private boolean writing;
    private boolean closed;
    private Runnable writer = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Logger.normal(this, "Writing slot cache " + ResizablePersistentIntBuffer.this);
            ResizablePersistentIntBuffer.this.lock.readLock().lock();
            try {
                ResizablePersistentIntBuffer resizablePersistentIntBuffer = ResizablePersistentIntBuffer.this;
                synchronized (resizablePersistentIntBuffer) {
                    block19: {
                        if (!ResizablePersistentIntBuffer.this.writing && ResizablePersistentIntBuffer.this.dirty && !ResizablePersistentIntBuffer.this.closed) break block19;
                        ResizablePersistentIntBuffer.this.scheduled = false;
                        return;
                    }
                    ResizablePersistentIntBuffer.this.scheduled = false;
                    ResizablePersistentIntBuffer.this.dirty = false;
                    ResizablePersistentIntBuffer.this.writing = true;
                }
                try {
                    ResizablePersistentIntBuffer.this.writeBuffer();
                }
                catch (IOException e) {
                    Logger.error(this, "Write failed during shutdown: " + e + " on " + ResizablePersistentIntBuffer.this.filename, (Throwable)e);
                }
            }
            finally {
                ResizablePersistentIntBuffer resizablePersistentIntBuffer = ResizablePersistentIntBuffer.this;
                synchronized (resizablePersistentIntBuffer) {
                    ResizablePersistentIntBuffer.this.writing = false;
                    ResizablePersistentIntBuffer.this.notifyAll();
                }
                ResizablePersistentIntBuffer.this.lock.readLock().unlock();
            }
            Logger.normal(this, "Written slot cache " + ResizablePersistentIntBuffer.this);
        }
    };

    public static synchronized void setPersistenceTime(int val) {
        globalPersistenceTime = val;
    }

    public static synchronized int getPersistenceTime() {
        return globalPersistenceTime;
    }

    public ResizablePersistentIntBuffer(File f, int size) throws IOException {
        this.filename = f;
        this.isNew = !f.exists();
        this.raf = new RandomAccessFile(f, "rw");
        this.lock = new ReentrantReadWriteLock();
        this.size = size;
        this.buffer = new int[size];
        long expectedLength = (long)size * 4L;
        long realLength = this.raf.length();
        if (realLength > expectedLength) {
            this.raf.setLength(expectedLength);
        }
        this.readBuffer((int)Math.min((long)size, realLength / 4L));
        if (realLength < expectedLength) {
            this.raf.setLength(expectedLength);
        }
        this.channel = this.raf.getChannel();
    }

    public void fill(int value) {
        for (int i = 0; i < this.buffer.length; ++i) {
            this.buffer[i] = value;
        }
    }

    private void readBuffer(int size) throws IOException {
        int[] data;
        this.raf.seek(0L);
        byte[] buf = new byte[32768];
        for (int read = 0; read < size; read += data.length) {
            int toRead = Math.min(buf.length, (size - read) * 4);
            this.raf.readFully(buf, 0, toRead);
            data = Fields.bytesToInts(buf, 0, toRead);
            System.arraycopy(data, 0, this.buffer, read, data.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Ticker ticker) {
        ResizablePersistentIntBuffer resizablePersistentIntBuffer = this;
        synchronized (resizablePersistentIntBuffer) {
            this.ticker = ticker;
            if (this.dirty) {
                int persistenceTime = ResizablePersistentIntBuffer.getPersistenceTime();
                Logger.normal(this, "Scheduling write of slot cache " + this + " in " + persistenceTime);
                ticker.queueTimedJob(this.writer, persistenceTime);
                this.scheduled = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get(int offset) {
        this.lock.readLock().lock();
        if (this.closed) {
            throw new IllegalStateException("Already shut down");
        }
        try {
            int n = this.buffer[offset];
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void put(int offset, int value) throws IOException {
        this.put(offset, value, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(int offset, int value, boolean noWrite) throws IOException {
        block15: {
            this.lock.readLock().lock();
            if (this.closed) {
                throw new IllegalStateException("Already shut down");
            }
            try {
                int persistenceTime = ResizablePersistentIntBuffer.getPersistenceTime();
                this.buffer[offset] = value;
                if (persistenceTime == -1 && !noWrite) {
                    this.channel.write(ByteBuffer.wrap(Fields.intToBytes(value)), (long)offset * 4L);
                    break block15;
                }
                if (persistenceTime > 0) {
                    ResizablePersistentIntBuffer resizablePersistentIntBuffer = this;
                    synchronized (resizablePersistentIntBuffer) {
                        this.dirty = true;
                        if (this.ticker != null) {
                            if (!this.scheduled) {
                                Logger.normal(this, "Scheduling write of slot cache " + this + " in " + persistenceTime);
                                this.ticker.queueTimedJob(this.writer, persistenceTime);
                                this.scheduled = true;
                            }
                        } else {
                            Logger.normal(this, "Will scheduling write of slot cache after startup: " + this + " in " + persistenceTime);
                        }
                        break block15;
                    }
                }
                ResizablePersistentIntBuffer resizablePersistentIntBuffer = this;
                synchronized (resizablePersistentIntBuffer) {
                    this.dirty = true;
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown() {
        this.lock.writeLock().lock();
        var1_1 = this;
        synchronized (var1_1) {
            if (this.closed) {
                // MONITOREXIT @DISABLED, blocks:[0, 18, 9] lbl6 : MonitorExitStatement: MONITOREXIT : var1_1
                this.lock.writeLock().unlock();
                return;
            }
            this.closed = true;
            if (!this.writing) break block19;
        }
        {
            block19: {
                while (this.writing) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException var2_4) {}
                }
                if (!this.dirty) {
                    // MONITOREXIT @DISABLED, blocks:[17, 9] lbl21 : MonitorExitStatement: MONITOREXIT : var1_1
                    this.lock.writeLock().unlock();
                    return;
                }
            }
            ** try [egrp 4[TRYBLOCK] [11 : 96->246)] { 
lbl26:
            // 1 sources

            this.writing = true;
        }
        try {
            Logger.normal(this, "Writing slot cache on shutdown: " + this);
            this.writeBuffer();
        }
        catch (IOException e) {
            Logger.error(this, "Write failed during shutdown: " + e + " on " + this.filename, (Throwable)e);
        }
        e = this;
        synchronized (e) {
            this.writing = false;
        }
        try {
            this.raf.close();
            return;
        }
        catch (IOException e) {
            Logger.error(this, "Close failed during shutdown: " + e + " on " + this.filename, (Throwable)e);
            return;
        }
lbl-1000:
        // 1 sources

        {
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        this.lock.writeLock().lock();
        try {
            ResizablePersistentIntBuffer resizablePersistentIntBuffer = this;
            synchronized (resizablePersistentIntBuffer) {
                block10: {
                    if (!this.closed) break block10;
                    return;
                }
                this.closed = true;
            }
            try {
                this.raf.close();
            }
            catch (IOException e) {
                Logger.error(this, "Close failed during shutdown: " + e + " on " + this.filename, (Throwable)e);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void writeBuffer() throws IOException {
        int toWrite;
        this.raf.seek(0L);
        for (int written = 0; written < this.size; written += toWrite) {
            toWrite = Math.min(32768, this.size - written);
            byte[] buf = Fields.intsToBytes(this.buffer, written, toWrite);
            this.raf.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize(int size) {
        this.lock.writeLock().lock();
        try {
            if (this.size == size) {
                return;
            }
            Logger.normal(this, "Resizing cache from " + this.size + " slots to " + size);
            this.size = size;
            this.buffer = Arrays.copyOf(this.buffer, size);
            try {
                this.raf.setLength(size * 4);
                this.writeBuffer();
            }
            catch (IOException e) {
                Logger.error(this, "Failed to change size or write during resize on " + this.filename + " : " + e, (Throwable)e);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void forceWrite() {
        block28: {
            Logger.normal(this, "Force write slot cache: " + this);
            this.lock.readLock().lock();
            var1_1 = this;
            synchronized (var1_1) {
                if (!this.closed) ** break block26
                // MONITOREXIT @DISABLED, blocks:[0, 1, 11] lbl8 : MonitorExitStatement: MONITOREXIT : var1_1
                var2_3 = this;
            }
            synchronized (var2_3) {
                this.writing = false;
            }
            this.lock.readLock().unlock();
            return;
            {
                this.dirty = false;
                if (!this.writing) ** break block27
                while (this.writing) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException var2_4) {}
                }
                if (this.dirty) ** break block27
                // MONITOREXIT @DISABLED, blocks:[3, 11] lbl30 : MonitorExitStatement: MONITOREXIT : var1_1
                var2_5 = this;
            }
            synchronized (var2_5) {
                this.writing = false;
            }
            this.lock.readLock().unlock();
            return;
            {
                this.writing = true;
                // MONITOREXIT @DISABLED, blocks:[6, 7, 11] lbl45 : MonitorExitStatement: MONITOREXIT : var1_1
                {
                    catch (Throwable var5_8) {
                        throw var5_8;
                    }
                }
                try {
                    this.writeBuffer();
                }
                catch (IOException e) {
                    Logger.error(this, "Write failed during shutdown: " + e + " on " + this.filename, (Throwable)e);
                }
                break block28;
            }
            {
                finally {
                    var1_1 = this;
                    synchronized (var1_1) {
                        this.writing = false;
                        // MONITOREXIT @DISABLED, blocks:[24, 9, 11] lbl63 : MonitorExitStatement: MONITOREXIT : var1_1
                        this.lock.readLock().unlock();
                    }
                }
            }
        }
    }

    public boolean isNew() {
        return this.isNew;
    }

    public String toString() {
        return this.filename.getPath();
    }

    public void replaceAllEntries(int key, int value) {
        for (int i = 0; i < this.buffer.length; ++i) {
            if (this.buffer[i] != key) continue;
            this.buffer[i] = value;
        }
    }

    public int size() {
        return this.size;
    }
}

