/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.client.DefaultMIMETypes;
import java.net.MalformedURLException;
import java.util.LinkedHashMap;
import java.util.Map;

public class MediaType {
    private final String type;
    private final String subtype;
    private final LinkedHashMap<String, String> parameters = new LinkedHashMap();

    public MediaType(String mediaType) throws NullPointerException, MalformedURLException {
        String[] parameters;
        if (mediaType == null) {
            throw new NullPointerException("contentType must not be null");
        }
        if (!DefaultMIMETypes.isPlausibleMIMEType(mediaType)) {
            throw new MalformedURLException("Doesn't look like a MIME type");
        }
        int slash = mediaType.indexOf(47);
        if (slash == -1) {
            throw new MalformedURLException("mediaType does not contain \u2018/\u2019!");
        }
        this.type = mediaType.substring(0, slash);
        int semicolon = mediaType.indexOf(59);
        if (semicolon == -1) {
            this.subtype = mediaType.substring(slash + 1);
            return;
        }
        this.subtype = mediaType.substring(slash + 1, semicolon).trim();
        for (String parameter : parameters = mediaType.substring(semicolon + 1).split(";")) {
            int equals = parameter.indexOf(61);
            if (equals == -1) {
                throw new MalformedURLException(String.format("Illegal parameter: \u201c%s\u201d", parameter));
            }
            String name = parameter.substring(0, equals).trim().toLowerCase();
            String value = parameter.substring(equals + 1).trim();
            if (value.startsWith("\"") && value.endsWith("\"")) {
                value = value.substring(1, value.length() - 1).trim();
            }
            this.parameters.put(name, value);
        }
    }

    public MediaType(String type, String subtype, String ... parameters) throws IllegalArgumentException {
        if ((parameters.length & 1) != 0) {
            throw new IllegalArgumentException("Invalid number of parameters given!");
        }
        this.type = type;
        this.subtype = subtype;
        for (int index = 0; index < parameters.length; index += 2) {
            this.parameters.put(parameters[index], parameters[index + 1]);
        }
    }

    public MediaType(String type, String subtype, Map<String, String> parameters) {
        this.type = type;
        this.subtype = subtype;
        this.parameters.putAll(parameters);
    }

    public String getType() {
        return this.type;
    }

    public MediaType setType(String type) {
        return new MediaType(type, this.subtype, this.parameters);
    }

    public String getSubtype() {
        return this.subtype;
    }

    public MediaType setSubtype(String subtype) {
        return new MediaType(this.type, subtype, this.parameters);
    }

    public String getParameter(String name) {
        return this.parameters.get(name.toLowerCase());
    }

    public MediaType setParameter(String name, String value) {
        MediaType newMediaType = new MediaType(this.type, this.subtype, this.parameters);
        if (value == null) {
            newMediaType.parameters.remove(name.toLowerCase());
        } else {
            newMediaType.parameters.put(name.toLowerCase(), value);
        }
        return newMediaType;
    }

    public MediaType removeParameter(String name) {
        if (!this.parameters.containsKey(name.toLowerCase())) {
            return this;
        }
        MediaType newMediaType = new MediaType(this.type, this.subtype, this.parameters);
        newMediaType.parameters.remove(name.toLowerCase());
        return newMediaType;
    }

    public String toString() {
        StringBuilder mediaType = new StringBuilder();
        mediaType.append(this.type).append('/').append(this.subtype);
        for (Map.Entry<String, String> parameter : this.parameters.entrySet()) {
            if (parameter.getValue() == null) continue;
            mediaType.append("; ").append(parameter.getKey()).append("=\"").append(parameter.getValue()).append("\"");
        }
        return mediaType.toString();
    }

    public static String getCharsetRobust(String expectedMimeType) {
        try {
            if (expectedMimeType == null) {
                return null;
            }
            MediaType type = new MediaType(expectedMimeType);
            return type.getParameter("charset");
        }
        catch (MalformedURLException e) {}
        finally {
            return null;
        }
    }

    public static String getCharsetRobustOrUTF(String expectedMimeType) {
        String charset = MediaType.getCharsetRobust(expectedMimeType);
        if (charset == null) {
            return "UTF-8";
        }
        return charset;
    }

    public LinkedHashMap<String, String> getParameters() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.putAll(this.parameters);
        return map;
    }

    public String getPlainType() {
        return this.type + '/' + this.subtype;
    }
}

