/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.api;

import freenet.client.DefaultMIMETypes;
import freenet.client.async.ClientContext;
import freenet.keys.FreenetURI;
import freenet.support.api.RandomAccessBucket;
import freenet.support.io.ResumeFailedException;
import java.io.Serializable;

public class ManifestElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    final String name;
    public final String fullName;
    final RandomAccessBucket data;
    public final String mimeOverride;
    final long dataSize;
    public final FreenetURI targetURI;

    public ManifestElement(String name2, String fullName2, RandomAccessBucket data2, String mimeOverride2, long size) {
        this.name = name2;
        this.fullName = fullName2;
        this.data = data2;
        assert (this.data != null);
        this.mimeOverride = mimeOverride2;
        this.dataSize = size;
        this.targetURI = null;
    }

    public ManifestElement(String name2, RandomAccessBucket data2, String mimeOverride2, long size2) {
        this.name = name2;
        this.fullName = name2;
        this.data = data2;
        this.mimeOverride = mimeOverride2;
        this.dataSize = size2;
        this.targetURI = null;
    }

    public ManifestElement(ManifestElement me, String newName) {
        this.name = newName;
        this.fullName = me.fullName;
        this.data = me.data;
        this.mimeOverride = me.mimeOverride;
        this.dataSize = me.dataSize;
        this.targetURI = me.targetURI;
    }

    public ManifestElement(ManifestElement me, String newName, String newFullName) {
        this.name = newName;
        this.fullName = newFullName;
        assert (this.fullName != null);
        this.data = me.data;
        this.mimeOverride = me.mimeOverride;
        this.dataSize = me.dataSize;
        this.targetURI = me.targetURI;
    }

    public ManifestElement(String name2, FreenetURI targetURI2, String mimeOverride2) {
        this.name = name2;
        this.fullName = name2;
        this.data = null;
        this.mimeOverride = mimeOverride2;
        this.dataSize = -1L;
        this.targetURI = targetURI2;
        assert (this.targetURI != null);
    }

    public ManifestElement(String name2, String fullName2, String mimeOverride2, FreenetURI targetURI2) {
        this.name = name2;
        this.fullName = fullName2;
        this.mimeOverride = mimeOverride2;
        this.targetURI = targetURI2;
        this.data = null;
        this.dataSize = -1L;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof ManifestElement && ((ManifestElement)o).name.equals(this.name);
    }

    public void freeData() {
        if (this.data != null) {
            this.data.free();
        }
    }

    public String getName() {
        return this.name;
    }

    public String getMimeTypeOverride() {
        return this.mimeOverride;
    }

    public String getMimeType() {
        String mimeType = this.mimeOverride;
        if (this.mimeOverride == null && this.name != null) {
            mimeType = DefaultMIMETypes.guessMIMEType(this.name, true);
        }
        return mimeType;
    }

    public RandomAccessBucket getData() {
        return this.data;
    }

    public long getSize() {
        return this.dataSize;
    }

    public FreenetURI getTargetURI() {
        return this.targetURI;
    }

    public void onResume(ClientContext context) throws ResumeFailedException {
        if (this.data != null) {
            this.data.onResume(context);
        }
    }
}

